/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins.dialogs;

import accessories.plugins.dialogs.ArrayListTransferHandler;
import com.jgoodies.forms.factories.ButtonBarFactory;
import freemind.common.TextTranslator;
import freemind.controller.StructuredMenuHolder;
import freemind.controller.actions.generated.instance.ManageStyleEditorWindowConfigurationStorage;
import freemind.controller.actions.generated.instance.Pattern;
import freemind.controller.actions.generated.instance.WindowConfigurationStorage;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.StylePatternFactory;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.dialogs.StylePatternFrame;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ManagePatternsPopupDialog
extends JDialog
implements TextTranslator,
KeyListener {
    private static Pattern sLastSelectedPattern = null;
    private static final String STACK_PATTERN_FRAME = "PATTERN";
    private static final String EMPTY_FRAME = "EMPTY_FRAME";
    private Pattern mLastSelectedPattern = null;
    private static final String WINDOW_PREFERENCE_STORAGE_PROPERTY = "accessories.plugins.dialogs.ManagePatternsPopupDialog/window_positions";
    public static final int CANCEL = -1;
    public static final int OK = 1;
    private int result = -1;
    private JPanel jContentPane = null;
    private MindMapController mController;
    private JButton jCancelButton;
    private JButton jOKButton;
    private CardLayout mCardLayout;
    private JPanel mRightStack;
    private PatternListModel mPatternListModel;
    private JPopupMenu popupMenu;
    private StylePatternFrame mStylePatternFrame;
    private JList mList;
    private boolean mIsDragging = false;
    private ArrayListTransferHandler mArrayListHandler;
    private JSplitPane mSplitPane;
    private static Logger logger = null;

    public ManagePatternsPopupDialog(JFrame caller, MindMapController controller) {
        super(caller);
        this.mController = controller;
        if (logger == null) {
            logger = this.mController.getFrame().getLogger(this.getClass().getName());
        }
        List patternList = new Vector();
        try {
            patternList = StylePatternFactory.loadPatterns(controller.getPatternReader());
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
            JOptionPane.showMessageDialog(this, this.getDialogTitle(), controller.getText("accessories/plugins/ManagePatterns.not_found"), 0);
        }
        this.initialize(patternList);
    }

    private void initialize(List patternList) {
        this.setTitle(this.getDialogTitle());
        JPanel contentPane = this.getJContentPane(patternList);
        this.setContentPane(contentPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ManagePatternsPopupDialog.this.cancelPressed();
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ManagePatternsPopupDialog.this.cancelPressed();
            }
        };
        Tools.addEscapeActionToDialog(this, cancelAction);
        int i = 0;
        if (sLastSelectedPattern != null) {
            for (Pattern pattern : this.mPatternListModel.getPatternList()) {
                if (pattern.getName().equals(sLastSelectedPattern.getName())) {
                    this.mList.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
        this.pack();
        ManageStyleEditorWindowConfigurationStorage decorateDialog = (ManageStyleEditorWindowConfigurationStorage)this.mController.decorateDialog(this, WINDOW_PREFERENCE_STORAGE_PROPERTY);
        if (decorateDialog != null) {
            this.mSplitPane.setDividerLocation(decorateDialog.getDividerPosition());
        }
    }

    private String getDialogTitle() {
        return this.mController.getText("accessories/plugins/ManagePatterns.dialog.title");
    }

    private void close() {
        ManageStyleEditorWindowConfigurationStorage storage = new ManageStyleEditorWindowConfigurationStorage();
        storage.setDividerPosition(this.mSplitPane.getDividerLocation());
        this.mController.storeDialogPositions(this, (WindowConfigurationStorage)storage, WINDOW_PREFERENCE_STORAGE_PROPERTY);
        this.dispose();
    }

    private void okPressed() {
        this.result = 1;
        this.writePatternBackToModel();
        this.close();
    }

    private void cancelPressed() {
        this.result = -1;
        this.close();
    }

    private JPanel getJContentPane(List patternList) {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.mList = new JList();
            this.mArrayListHandler = new ArrayListTransferHandler();
            this.mList.setSelectionMode(0);
            this.mPatternListModel = new PatternListModel(patternList);
            this.mList.setModel(this.mPatternListModel);
            this.mList.setTransferHandler(this.mArrayListHandler);
            this.mList.setDragEnabled(true);
            this.mList.addListSelectionListener(new PatternListSelectionListener());
            this.mList.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent pE) {
                    ManagePatternsPopupDialog.this.mIsDragging = true;
                }

                @Override
                public void mouseMoved(MouseEvent pE) {
                    ManagePatternsPopupDialog.this.mIsDragging = false;
                }
            });
            ActionListener addPatternActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManagePatternsPopupDialog.this.addPattern(actionEvent);
                }
            };
            ActionListener fromNodesActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManagePatternsPopupDialog.this.insertPatternFromNode(actionEvent);
                }
            };
            ActionListener applyActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManagePatternsPopupDialog.this.applyToNode(actionEvent);
                }
            };
            JMenuBar menu = new JMenuBar();
            StructuredMenuHolder menuHolder = new StructuredMenuHolder();
            JMenu mainItem = new JMenu(this.mController.getText("ManagePatternsPopupDialog.Actions"));
            menuHolder.addMenu(mainItem, "main/actions/.");
            JMenuItem menuItemApplyPattern = new JMenuItem(this.mController.getText("ManagePatternsPopupDialog.apply"));
            menuItemApplyPattern.addActionListener(applyActionListener);
            menuHolder.addMenuItem(menuItemApplyPattern, "main/actions/apply");
            JMenuItem menuItemAddPattern = new JMenuItem(this.mController.getText("ManagePatternsPopupDialog.add"));
            menuItemAddPattern.addActionListener(addPatternActionListener);
            menuHolder.addMenuItem(menuItemAddPattern, "main/actions/add");
            JMenuItem menuItemPatternFromNodes = new JMenuItem(this.mController.getText("ManagePatternsPopupDialog.from_nodes"));
            menuItemPatternFromNodes.addActionListener(fromNodesActionListener);
            menuHolder.addMenuItem(menuItemPatternFromNodes, "main/actions/from_nodes");
            menuHolder.updateMenus(menu, "main/");
            this.setJMenuBar(menu);
            this.popupMenu = new JPopupMenu();
            JMenuItem menuItemApply = new JMenuItem(this.mController.getText("ManagePatternsPopupDialog.apply"));
            menuHolder.addMenuItem(menuItemApply, "popup/apply");
            menuItemApply.addActionListener(applyActionListener);
            JMenuItem menuItemAdd = new JMenuItem(this.mController.getText("ManagePatternsPopupDialog.add"));
            menuHolder.addMenuItem(menuItemAdd, "popup/add");
            menuItemAdd.addActionListener(addPatternActionListener);
            JMenuItem menuItemDuplicate = new JMenuItem(this.mController.getText("ManagePatternsPopupDialog.duplicate"));
            menuHolder.addMenuItem(menuItemDuplicate, "popup/duplicate");
            menuItemDuplicate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManagePatternsPopupDialog.this.duplicatePattern(actionEvent);
                }
            });
            JMenuItem menuItemFromNodes = new JMenuItem(this.mController.getText("ManagePatternsPopupDialog.from_nodes"));
            menuHolder.addMenuItem(menuItemFromNodes, "popup/from_nodes");
            menuItemFromNodes.addActionListener(fromNodesActionListener);
            menuHolder.addSeparator("popup/sep");
            JMenuItem menuItemRemove = new JMenuItem(this.mController.getText("ManagePatternsPopupDialog.remove"));
            menuItemRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManagePatternsPopupDialog.this.removePattern(actionEvent);
                }
            });
            menuHolder.addMenuItem(menuItemRemove, "popup/remove");
            menuHolder.updateMenus(this.popupMenu, "popup/");
            this.mList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent me) {
                    this.showPopup(ManagePatternsPopupDialog.this.mList, me);
                }

                @Override
                public void mousePressed(MouseEvent me) {
                    this.showPopup(ManagePatternsPopupDialog.this.mList, me);
                }

                private void showPopup(JList mList, MouseEvent me) {
                    if (me.isPopupTrigger() && !mList.isSelectionEmpty() && mList.locationToIndex(me.getPoint()) == mList.getSelectedIndex()) {
                        ManagePatternsPopupDialog.this.popupMenu.show(mList, me.getX(), me.getY());
                    }
                }
            });
            this.mCardLayout = new CardLayout();
            this.mRightStack = new JPanel(this.mCardLayout);
            this.mRightStack.add((Component)new JPanel(), EMPTY_FRAME);
            this.mStylePatternFrame = new StylePatternFrame(this, this.mController, StylePatternFrame.StylePatternFrameType.WITH_NAME_AND_CHILDS);
            this.mStylePatternFrame.init();
            this.mStylePatternFrame.addListeners();
            this.mRightStack.add((Component)new JScrollPane(this.mStylePatternFrame), STACK_PATTERN_FRAME);
            JScrollPane leftPane = new JScrollPane(this.mList);
            this.mSplitPane = new JSplitPane(1, true, leftPane, this.mRightStack);
            this.jContentPane.add((Component)this.mSplitPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 8.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jContentPane.add((Component)ButtonBarFactory.buildOKCancelBar(this.getJCancelButton(), this.getJOKButton()), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getRootPane().setDefaultButton(this.getJOKButton());
        }
        return this.jContentPane;
    }

    private void addPattern(ActionEvent actionEvent) {
        this.writePatternBackToModel();
        this.setLastSelectedPattern(null);
        Pattern newPattern = new Pattern();
        newPattern.setName(this.searchForNameForNewPattern());
        int selectedIndex = this.mList.getSelectedIndex();
        if (selectedIndex < 0) {
            selectedIndex = this.mList.getModel().getSize();
        }
        this.mPatternListModel.addPattern(newPattern, selectedIndex);
        this.mList.setSelectedIndex(selectedIndex);
    }

    private void duplicatePattern(ActionEvent actionEvent) {
        int selectedIndex = this.mList.getSelectedIndex();
        this.writePatternBackToModel();
        this.setLastSelectedPattern(null);
        Pattern oldPattern = this.mPatternListModel.getPatternAt(selectedIndex);
        Pattern newPattern = (Pattern)Tools.deepCopy((XmlAction)oldPattern);
        newPattern.setName(this.searchForNameForNewPattern());
        this.mPatternListModel.addPattern(newPattern, selectedIndex);
        this.mList.setSelectedIndex(selectedIndex);
    }

    private void insertPatternFromNode(ActionEvent actionEvent) {
        this.writePatternBackToModel();
        this.setLastSelectedPattern(null);
        Pattern newPattern = StylePatternFactory.createPatternFromSelected(this.mController.getSelected(), this.mController.getSelecteds());
        newPattern.setName(this.searchForNameForNewPattern());
        int selectedIndex = this.mList.getSelectedIndex();
        if (selectedIndex < 0) {
            selectedIndex = this.mList.getModel().getSize();
        }
        this.mPatternListModel.addPattern(newPattern, selectedIndex);
        this.mList.setSelectedIndex(selectedIndex);
    }

    private void applyToNode(ActionEvent actionEvent) {
        int selectedIndex = this.mList.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        this.writePatternBackToModel();
        this.setLastSelectedPattern(null);
        Pattern pattern = this.mPatternListModel.getPatternAt(selectedIndex);
        for (MindMapNode node : this.mController.getSelecteds()) {
            this.mController.applyPattern(node, pattern);
        }
    }

    private String searchForNameForNewPattern() {
        String newName = this.mController.getText("PatternNewNameProperty");
        Vector<String> allNames = new Vector<String>();
        for (Pattern p : this.mPatternListModel.getPatternList()) {
            allNames.add(p.getName());
        }
        String toGiveName = newName;
        int i = 1;
        while (allNames.contains(toGiveName)) {
            toGiveName = newName + i;
            ++i;
        }
        return toGiveName;
    }

    private void removePattern(ActionEvent actionEvent) {
        int selectedIndex = this.mList.getSelectedIndex();
        this.setLastSelectedPattern(null);
        this.mPatternListModel.removePattern(selectedIndex);
        if (this.mPatternListModel.getSize() > selectedIndex) {
            this.mList.setSelectedIndex(selectedIndex);
        } else if (this.mPatternListModel.getSize() > 0 && selectedIndex >= 0) {
            this.mList.setSelectedIndex(selectedIndex - 1);
        } else {
            this.mList.clearSelection();
        }
    }

    private JButton getJOKButton() {
        if (this.jOKButton == null) {
            this.jOKButton = new JButton();
            this.jOKButton.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManagePatternsPopupDialog.this.okPressed();
                }
            });
            this.jOKButton.setText(this.mController.getText("ManagePatternsPopupDialog.Save"));
        }
        return this.jOKButton;
    }

    private JButton getJCancelButton() {
        if (this.jCancelButton == null) {
            this.jCancelButton = new JButton();
            this.jCancelButton.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManagePatternsPopupDialog.this.cancelPressed();
                }
            });
            Tools.setLabelAndMnemonic(this.jCancelButton, this.getText("cancel"));
        }
        return this.jCancelButton;
    }

    public int getResult() {
        return this.result;
    }

    @Override
    public String getText(String pKey) {
        return this.mController.getText(pKey);
    }

    public List getPatternList() {
        return this.mPatternListModel.getPatternList();
    }

    private void writePatternBackToModel() {
        if (this.getLastSelectedPattern() != null) {
            String newPatternName;
            Pattern pattern = this.getLastSelectedPattern();
            Pattern resultPatternCopy = this.mStylePatternFrame.getResultPattern();
            String oldPatternName = pattern.getName();
            if (!oldPatternName.equals(newPatternName = resultPatternCopy.getName())) {
                for (Pattern otherPattern : this.mPatternListModel.getPatternList()) {
                    if (otherPattern == pattern || !otherPattern.getName().equals(newPatternName)) continue;
                    JOptionPane.showMessageDialog(this, this.mController.getText("ManagePatternsPopupDialog.DuplicateNameMessage"));
                }
            }
            for (Pattern otherPattern : this.mPatternListModel.getPatternList()) {
                if (otherPattern.getPatternChild() == null || !oldPatternName.equals(otherPattern.getPatternChild().getValue())) continue;
                otherPattern.getPatternChild().setValue(newPatternName);
            }
            this.mStylePatternFrame.getResultPattern(pattern);
            if (pattern.getPatternChild() != null && oldPatternName.equals(pattern.getPatternChild().getValue())) {
                pattern.getPatternChild().setValue(newPatternName);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 27: {
                keyEvent.consume();
                this.cancelPressed();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public Pattern getLastSelectedPattern() {
        return this.mLastSelectedPattern;
    }

    public void setLastSelectedPattern(Pattern pLastSelectedPattern) {
        this.mLastSelectedPattern = pLastSelectedPattern;
        sLastSelectedPattern = pLastSelectedPattern;
    }

    protected final class PatternListModel
    extends AbstractListModel {
        private final List mPatternList;

        public PatternListModel(List patternList) {
            this.mPatternList = new Vector(patternList);
        }

        @Override
        public int getSize() {
            return this.mPatternList.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.getPatternAt(index).getName();
        }

        public Pattern getPatternAt(int index) {
            return (Pattern)this.mPatternList.get(index);
        }

        public List getPatternList() {
            return Collections.unmodifiableList(this.mPatternList);
        }

        public void removePattern(int index) {
            if (index < 0 || index >= this.mPatternList.size()) {
                throw new IllegalArgumentException("try to delete in pattern list with an index out of range: " + index);
            }
            logger.info("Pattern " + ((Pattern)this.mPatternList.get(index)).getName() + " should be removed at " + index);
            this.mPatternList.remove(index);
            this.fireIntervalRemoved(ManagePatternsPopupDialog.this.mList, index, index);
        }

        public void addPattern(Pattern newPattern, int selectedIndex) {
            logger.info("Pattern " + newPattern.getName() + " should be added at " + selectedIndex);
            this.mPatternList.add(selectedIndex, newPattern);
            this.fireIntervalAdded(ManagePatternsPopupDialog.this.mList, selectedIndex, selectedIndex);
        }

        private void printPatterns() {
            int i = 0;
            for (Pattern pattern : this.mPatternList) {
                logger.info("Pattern " + i + " = " + pattern.getName());
                ++i;
            }
        }

        public Pattern getPatternByName(String name) {
            for (Pattern pattern : this.mPatternList) {
                if (!pattern.getName().equals(name)) continue;
                return pattern;
            }
            return null;
        }

        public void add(int i, Object object) {
            String patternName;
            Pattern correspondingPattern;
            if (object instanceof String && (correspondingPattern = this.getPatternByName(patternName = (String)object)) != null) {
                this.addPattern(correspondingPattern, i);
            }
        }

        public void remove(int i) {
            this.removePattern(i);
        }
    }

    private final class PatternListSelectionListener
    implements ListSelectionListener {
        private PatternListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || ManagePatternsPopupDialog.this.mIsDragging) {
                return;
            }
            ManagePatternsPopupDialog.this.writePatternBackToModel();
            JList theList = (JList)e.getSource();
            if (theList.isSelectionEmpty()) {
                ManagePatternsPopupDialog.this.mCardLayout.show(ManagePatternsPopupDialog.this.mRightStack, ManagePatternsPopupDialog.EMPTY_FRAME);
            } else {
                int index = theList.getSelectedIndex();
                Pattern p = ManagePatternsPopupDialog.this.mPatternListModel.getPatternAt(index);
                ManagePatternsPopupDialog.this.setLastSelectedPattern(p);
                ManagePatternsPopupDialog.this.mStylePatternFrame.setPatternList(ManagePatternsPopupDialog.this.mPatternListModel.getPatternList());
                ManagePatternsPopupDialog.this.mStylePatternFrame.setPattern(p);
                ManagePatternsPopupDialog.this.mCardLayout.show(ManagePatternsPopupDialog.this.mRightStack, ManagePatternsPopupDialog.STACK_PATTERN_FRAME);
            }
        }
    }
}

