/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.ReflectionTypes;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IsKPropertyCheck
implements Check {
    @NotNull
    private static final String description = "second parameter must be of type KProperty<*> or its supertype";
    public static final IsKPropertyCheck INSTANCE;

    @Override
    @NotNull
    public String getDescription() {
        return description;
    }

    @Override
    public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
        boolean bl;
        ValueParameterDescriptor secondParameter;
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        ValueParameterDescriptor valueParameterDescriptor = secondParameter = functionDescriptor.getValueParameters().get(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"secondParameter");
        KotlinType kotlinType = ReflectionTypes.Companion.createKPropertyStarType(DescriptorUtilsKt.getModule(valueParameterDescriptor));
        if (kotlinType != null) {
            KotlinType kotlinType2 = secondParameter.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"secondParameter.type");
            KotlinType kotlinType3 = TypeUtilsKt.makeNotNullable(kotlinType2);
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"secondParameter.type.makeNotNullable()");
            bl = TypeUtilsKt.isSubtypeOf(kotlinType, kotlinType3);
        } else {
            bl = false;
        }
        return bl;
    }

    private IsKPropertyCheck() {
    }

    static {
        IsKPropertyCheck isKPropertyCheck;
        INSTANCE = isKPropertyCheck = new IsKPropertyCheck();
        description = description;
    }

    @Override
    @Nullable
    public String invoke(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        return Check.DefaultImpls.invoke(this, functionDescriptor);
    }
}

