/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.gradle.util.ChangeListener;

public class DiffUtil {
    public static <T> void diff(Set<? extends T> newSet, Set<? extends T> oldSet, ChangeListener<T> changeListener) {
        HashSet<T> added = new HashSet<T>(newSet);
        added.removeAll(oldSet);
        for (Object t : added) {
            changeListener.added(t);
        }
        HashSet<T> removed = new HashSet<T>(oldSet);
        removed.removeAll(newSet);
        for (Object t : removed) {
            changeListener.removed(t);
        }
    }

    public static <K, V> void diff(Map<? extends K, ? extends V> newMap, Map<? extends K, ? extends V> oldMap, ChangeListener<? super Map.Entry<K, V>> changeListener) {
        HashMap<K, V> added = new HashMap<K, V>(newMap);
        added.keySet().removeAll(oldMap.keySet());
        for (Map.Entry entry : added.entrySet()) {
            changeListener.added(entry);
        }
        HashMap<K, V> removed = new HashMap<K, V>(oldMap);
        removed.keySet().removeAll(newMap.keySet());
        for (Map.Entry entry : removed.entrySet()) {
            changeListener.removed(entry);
        }
        HashMap<K, V> same = new HashMap<K, V>(newMap);
        same.keySet().retainAll(oldMap.keySet());
        for (Map.Entry entry : same.entrySet()) {
            if (DiffUtil.checkEquality(entry.getValue(), oldMap.get(entry.getKey()))) continue;
            changeListener.changed(entry);
        }
    }

    @VisibleForTesting
    static boolean checkEquality(Object obj1, Object obj2) {
        return ObjectUtils.equals((Object)obj1, (Object)obj2) || DiffUtil.checkEnumEquality(obj1, obj2);
    }

    private static boolean checkEnumEquality(Object obj1, Object obj2) {
        if (!(obj1 instanceof Enum) || !(obj2 instanceof Enum)) {
            return false;
        }
        Enum e1 = (Enum)obj1;
        Enum e2 = (Enum)obj2;
        return e1.getDeclaringClass().getCanonicalName().equals(e2.getDeclaringClass().getCanonicalName()) && e1.ordinal() == e2.ordinal() && e1.name().equals(e2.name());
    }
}

