/*
 * Decompiled with CFR 0.152.
 */
package grails.beans.util;

import groovy.lang.GroovySystem;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaClass;
import groovy.lang.MetaProperty;
import groovy.util.MapEntry;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.grails.datastore.mapping.reflect.NameUtils;
import org.springframework.util.Assert;

public class LazyMetaPropertyMap
implements Map {
    private MetaClass metaClass;
    private Object instance;
    private static List<String> EXCLUDES = Arrays.asList("properties", "id", "version", "domainClass", "dirty", "errors", "dirtyPropertyNames");

    public LazyMetaPropertyMap(Object o) {
        Assert.notNull((Object)o, (String)"Object cannot be null");
        this.instance = o;
        this.metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(o.getClass());
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object propertyName) {
        if (propertyName instanceof CharSequence) {
            propertyName = propertyName.toString();
        }
        Assert.isInstanceOf(String.class, (Object)propertyName, (String)"This map implementation only supports String based keys!");
        String pn = propertyName.toString();
        return !NameUtils.isConfigurational((String)pn) && this.metaClass.getMetaProperty(pn) != null;
    }

    @Override
    public boolean containsValue(Object o) {
        return this.values().contains(o);
    }

    public Object get(Object propertyName) {
        if (propertyName instanceof CharSequence) {
            propertyName = propertyName.toString();
        }
        if (propertyName instanceof List) {
            HashMap submap = new HashMap();
            List propertyNames = (List)propertyName;
            for (Object currentName : propertyNames) {
                if (currentName == null || !this.containsKey(currentName = currentName.toString())) continue;
                submap.put(currentName, this.get(currentName));
            }
            return submap;
        }
        if (NameUtils.isConfigurational((String)propertyName.toString())) {
            return null;
        }
        Object val = null;
        MetaProperty mp = this.metaClass.getMetaProperty(propertyName.toString());
        if (mp != null) {
            val = mp.getProperty(this.instance);
        }
        return val;
    }

    public Object put(Object propertyName, Object propertyValue) {
        if (propertyName instanceof CharSequence) {
            propertyName = propertyName.toString();
        }
        Object old = null;
        MetaProperty mp = this.metaClass.getMetaProperty((String)propertyName);
        if (mp != null && !this.isExcluded(mp)) {
            old = mp.getProperty(this.instance);
            if (propertyValue instanceof Map) {
                propertyValue = ((Map)propertyValue).get(propertyName);
            }
            mp.setProperty(this.instance, propertyValue);
        }
        return old;
    }

    public Object remove(Object o) {
        throw new UnsupportedOperationException("Method remove(Object o) is not supported by this implementation");
    }

    public void putAll(Map map) {
        for (Object key : map.keySet()) {
            this.put(key, map.get(key));
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Method clear() is not supported by this implementation");
    }

    public Set<String> keySet() {
        HashSet<String> names = new HashSet<String>();
        for (MetaProperty mp : this.metaClass.getProperties()) {
            if (this.isExcluded(mp)) continue;
            names.add(mp.getName());
        }
        return names;
    }

    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (MetaProperty mp : this.metaClass.getProperties()) {
            if (this.isExcluded(mp)) continue;
            values.add(mp.getProperty(this.instance));
        }
        return values;
    }

    @Override
    public int hashCode() {
        return this.instance.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LazyMetaPropertyMap) {
            LazyMetaPropertyMap other = (LazyMetaPropertyMap)o;
            return this.instance.equals(other.getInstance());
        }
        return false;
    }

    public Object getInstance() {
        return this.instance;
    }

    public Set<MapEntry> entrySet() {
        HashSet<MapEntry> entries = new HashSet<MapEntry>();
        for (MetaProperty mp : this.metaClass.getProperties()) {
            if (this.isExcluded(mp)) continue;
            entries.add(new MapEntry((Object)mp.getName(), mp.getProperty(this.instance)));
        }
        return entries;
    }

    private boolean isExcluded(MetaProperty mp) {
        return Modifier.isStatic(mp.getModifiers()) || EXCLUDES.contains(mp.getName()) || NameUtils.isConfigurational((String)mp.getName()) || mp instanceof MetaBeanProperty && ((MetaBeanProperty)mp).getGetter() == null;
    }
}

