/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.HBond;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.Logger;

public class AminoPolymer
extends AlphaPolymer {
    private static final float maxHbondAlphaDistance = 9.0f;
    private static final float maxHbondAlphaDistance2 = 81.0f;
    private static final float minimumHbondDistance2 = 0.25f;
    private Map<STR, float[]> structureList;

    AminoPolymer(Monomer[] monomers, int pt0) {
        super(monomers, pt0);
        this.type = 1;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (((AminoMonomer)monomers[i]).hasOAtom()) continue;
            return;
        }
        this.hasWingPoints = true;
    }

    @Override
    protected void resetHydrogenPoints() {
        ProteinStructure psLast = null;
        for (int i = 0; i < this.monomerCount; ++i) {
            ProteinStructure ps = this.getProteinStructure(i);
            if (ps != null && ps != psLast) {
                psLast = ps;
                psLast.resetAxes();
            }
            ((AminoMonomer)this.monomers[i]).resetHydrogenPoint();
        }
    }

    @Override
    protected boolean calcPhiPsiAngles() {
        for (int i = 0; i < this.monomerCount - 1; ++i) {
            this.calcPhiPsiAngles2((AminoMonomer)this.monomers[i], (AminoMonomer)this.monomers[i + 1]);
        }
        return true;
    }

    private void calcPhiPsiAngles2(AminoMonomer residue1, AminoMonomer residue2) {
        Atom nitrogen1 = residue1.getNitrogenAtom();
        Atom alphacarbon1 = residue1.getLeadAtom();
        Atom carbon1 = residue1.getCarbonylCarbonAtom();
        Atom nitrogen2 = residue2.getNitrogenAtom();
        Atom alphacarbon2 = residue2.getLeadAtom();
        Atom carbon2 = residue2.getCarbonylCarbonAtom();
        residue2.setGroupParameter(1111490569, Measure.computeTorsion((T3)carbon1, (T3)nitrogen2, (T3)alphacarbon2, (T3)carbon2, (boolean)true));
        residue1.setGroupParameter(1111490570, Measure.computeTorsion((T3)nitrogen1, (T3)alphacarbon1, (T3)carbon1, (T3)nitrogen2, (boolean)true));
        residue1.setGroupParameter(1111490568, Measure.computeTorsion((T3)alphacarbon1, (T3)carbon1, (T3)nitrogen2, (T3)alphacarbon2, (boolean)true));
    }

    @Override
    protected float calculateRamachandranHelixAngle(int m, char qtype) {
        float psiLast = m == 0 ? Float.NaN : this.monomers[m - 1].getGroupParameter(1111490570);
        float psi = this.monomers[m].getGroupParameter(1111490570);
        float phi = this.monomers[m].getGroupParameter(1111490569);
        float phiNext = m == this.monomerCount - 1 ? Float.NaN : this.monomers[m + 1].getGroupParameter(1111490569);
        float psiNext = m == this.monomerCount - 1 ? Float.NaN : this.monomers[m + 1].getGroupParameter(1111490570);
        switch (qtype) {
            default: {
                float dPhi = (float)((double)((phiNext - phi) / 2.0f) * Math.PI / 180.0);
                float dPsi = (float)((double)((psiNext - psi) / 2.0f) * Math.PI / 180.0);
                return (float)(114.59155902616465 * Math.acos(Math.cos(dPsi) * Math.cos(dPhi) - Math.sin(dPsi) * Math.sin(dPhi) / 3.0));
            }
            case 'C': 
            case 'c': 
        }
        return psi - psiLast + phiNext - phi;
    }

    @Override
    public void calcRasmolHydrogenBonds(BioPolymer polymer, BS bsA, BS bsB, Lst<Bond> vHBonds, int nMaxPerResidue, int[][][] min, boolean checkDistances, boolean dsspIgnoreHydrogens) {
        if (polymer == null) {
            polymer = this;
        }
        if (!(polymer instanceof AminoPolymer)) {
            return;
        }
        P3 pt = new P3();
        V3 vNH = new V3();
        int[][] min1 = min == null ? new int[2][3] : (int[][])null;
        for (int i = 1; i < this.monomerCount; ++i) {
            boolean isInA;
            if (min == null) {
                int n = this.bioPolymerIndexInModel;
                min1[1][0] = n;
                min1[0][0] = n;
                min1[1][1] = Integer.MIN_VALUE;
                min1[0][1] = Integer.MIN_VALUE;
                min1[1][2] = 0;
                min1[0][2] = 0;
            } else {
                min1 = min[i];
            }
            AminoMonomer source = (AminoMonomer)this.monomers[i];
            if (!source.getNHPoint(pt, vNH, checkDistances, dsspIgnoreHydrogens)) continue;
            boolean bl = isInA = bsA == null || bsA.get(source.getNitrogenAtom().i);
            if (!isInA || !checkDistances && source.getCarbonylOxygenAtom() == null) continue;
            this.checkRasmolHydrogenBond(source, polymer, i, pt, isInA ? bsB : bsA, vHBonds, min1, checkDistances);
        }
    }

    private void checkRasmolHydrogenBond(AminoMonomer source, BioPolymer polymer, int indexDonor, P3 hydrogenPoint, BS bsB, Lst<Bond> vHBonds, int[][] min, boolean checkDistances) {
        Atom sourceAlphaPoint = source.getLeadAtom();
        Atom sourceNitrogenPoint = source.getNitrogenAtom();
        Atom nitrogen = source.getNitrogenAtom();
        int i = polymer.monomerCount;
        while (--i >= 0) {
            int[] m;
            Atom targetAlphaPoint;
            float dist2;
            AminoMonomer target;
            Atom oxygen;
            if (polymer == this && (i == indexDonor || i + 1 == indexDonor) || (oxygen = (target = (AminoMonomer)polymer.monomers[i]).getCarbonylOxygenAtom()) == null || bsB != null && !bsB.get(oxygen.i) || (dist2 = sourceAlphaPoint.distanceSquared((T3)(targetAlphaPoint = target.getLeadAtom()))) >= 81.0f) continue;
            int energy = this.calcHbondEnergy((P3)sourceNitrogenPoint, hydrogenPoint, target, checkDistances);
            if (energy < min[0][2]) {
                m = min[1];
                min[1] = min[0];
                min[0] = m;
            } else {
                if (energy >= min[1][2]) continue;
                m = min[1];
            }
            m[0] = polymer.bioPolymerIndexInModel;
            m[1] = energy < -500 ? i : -1 - i;
            m[2] = energy;
        }
        if (vHBonds != null) {
            for (i = 0; i < 2; ++i) {
                if (min[i][1] < 0) continue;
                this.addResidueHydrogenBond(nitrogen, ((AminoMonomer)((AminoPolymer)polymer).monomers[min[i][1]]).getCarbonylOxygenAtom(), polymer == this ? indexDonor : -99, min[i][1], (float)min[i][2] / 1000.0f, vHBonds);
            }
        }
    }

    private int calcHbondEnergy(P3 nitrogenPoint, P3 hydrogenPoint, AminoMonomer target, boolean checkDistances) {
        double distON;
        double distCN;
        double distCH;
        Atom targetOxygenPoint = target.getCarbonylOxygenAtom();
        if (targetOxygenPoint == null) {
            return 0;
        }
        float distON2 = targetOxygenPoint.distanceSquared((T3)nitrogenPoint);
        if (distON2 < 0.25f) {
            return 0;
        }
        float distOH2 = targetOxygenPoint.distanceSquared((T3)hydrogenPoint);
        if (distOH2 < 0.25f) {
            return 0;
        }
        Atom targetCarbonPoint = target.getCarbonylCarbonAtom();
        float distCH2 = targetCarbonPoint.distanceSquared((T3)hydrogenPoint);
        if (distCH2 < 0.25f) {
            return 0;
        }
        float distCN2 = targetCarbonPoint.distanceSquared((T3)nitrogenPoint);
        if (distCN2 < 0.25f) {
            return 0;
        }
        double distOH = Math.sqrt(distOH2);
        int energy = HBond.getEnergy((double)distOH, (double)(distCH = Math.sqrt(distCH2)), (double)(distCN = Math.sqrt(distCN2)), (double)(distON = Math.sqrt(distON2)));
        boolean isHbond = energy < -500 && (!checkDistances || distCN > distCH && distOH <= 3.0);
        return !isHbond && checkDistances || energy < -9900 ? 0 : energy;
    }

    private void addResidueHydrogenBond(Atom nitrogen, Atom oxygen, int indexAminoGroup, int indexCarbonylGroup, float energy, Lst<Bond> vHBonds) {
        int order;
        switch (indexAminoGroup - indexCarbonylGroup) {
            case 2: {
                order = 6144;
                break;
            }
            case 3: {
                order = 8192;
                break;
            }
            case 4: {
                order = 10240;
                break;
            }
            case 5: {
                order = 12288;
                break;
            }
            case -3: {
                order = 14336;
                break;
            }
            case -4: {
                order = 16384;
                break;
            }
            default: {
                order = 4096;
            }
        }
        vHBonds.addLast((Object)new HBond(nitrogen, oxygen, order, 1, 0, energy));
    }

    @Override
    public void calculateStructures(boolean alphaOnly) {
        int start;
        if (alphaOnly) {
            return;
        }
        if (this.structureList == null) {
            this.structureList = this.model.ms.getStructureList();
        }
        char[] structureTags = new char[this.monomerCount];
        for (int i = 0; i < this.monomerCount - 1; ++i) {
            AminoMonomer leadingResidue = (AminoMonomer)this.monomers[i];
            AminoMonomer trailingResidue = (AminoMonomer)this.monomers[i + 1];
            float phi = trailingResidue.getGroupParameter(1111490569);
            float psi = leadingResidue.getGroupParameter(1111490570);
            structureTags[i] = this.isHelix(psi, phi) ? (phi < 0.0f && psi < 25.0f ? 52 : 51) : (this.isSheet(psi, phi) ? 115 : (this.isTurn(psi, phi) ? 116 : 110));
            if (!Logger.debugging) continue;
            Logger.debug((String)(0 + this.monomers[0].chain.chainID + " aminopolymer:" + i + " " + trailingResidue.getGroupParameter(1111490569) + "," + leadingResidue.getGroupParameter(1111490570) + " " + structureTags[i]));
        }
        for (start = 0; start < this.monomerCount; ++start) {
            int end;
            if (structureTags[start] != '4') continue;
            for (end = start + 1; end < this.monomerCount && structureTags[end] == '4'; ++end) {
            }
            if (--end >= start + 3) {
                this.addStructureProtected(STR.HELIX, null, 0, 0, start, end);
            }
            start = end;
        }
        for (start = 0; start < this.monomerCount; ++start) {
            int end;
            if (structureTags[start] != '3') continue;
            for (end = start + 1; end < this.monomerCount && structureTags[end] == '3'; ++end) {
            }
            if (--end >= start + 3) {
                this.addStructureProtected(STR.HELIX, null, 0, 0, start, end);
            }
            start = end;
        }
        for (start = 0; start < this.monomerCount; ++start) {
            int end;
            if (structureTags[start] != 's') continue;
            for (end = start + 1; end < this.monomerCount && structureTags[end] == 's'; ++end) {
            }
            if (--end >= start + 2) {
                this.addStructureProtected(STR.SHEET, null, 0, 0, start, end);
            }
            start = end;
        }
        for (start = 0; start < this.monomerCount; ++start) {
            int end;
            if (structureTags[start] != 't') continue;
            for (end = start + 1; end < this.monomerCount && structureTags[end] == 't'; ++end) {
            }
            if (--end >= start + 2) {
                this.addStructureProtected(STR.TURN, null, 0, 0, start, end);
            }
            start = end;
        }
    }

    private boolean isTurn(float psi, float phi) {
        return AminoPolymer.checkPhiPsi(this.structureList.get(STR.TURN), psi, phi);
    }

    private boolean isSheet(float psi, float phi) {
        return AminoPolymer.checkPhiPsi(this.structureList.get(STR.SHEET), psi, phi);
    }

    private boolean isHelix(float psi, float phi) {
        return AminoPolymer.checkPhiPsi(this.structureList.get(STR.HELIX), psi, phi);
    }

    private static boolean checkPhiPsi(float[] list, float psi, float phi) {
        for (int i = 0; i < list.length; i += 4) {
            if (!(phi >= list[i]) || !(phi <= list[i + 1]) || !(psi >= list[i + 2]) || !(psi <= list[i + 3])) continue;
            return true;
        }
        return false;
    }

    public void setStructureList(Map<STR, float[]> structureList) {
        this.structureList = structureList;
    }
}

