/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubySymbol;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class InstanceSuperInstr
extends CallInstr {
    public InstanceSuperInstr(Variable result2, Operand definingModule, RubySymbol name2, Operand[] args2, Operand closure, boolean isPotentiallyRefined) {
        super(Operation.INSTANCE_SUPER, CallType.SUPER, result2, name2, definingModule, args2, closure, isPotentiallyRefined);
    }

    public Operand getDefiningModule() {
        return this.getReceiver();
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new InstanceSuperInstr(ii.getRenamedVariable(this.getResult()), this.getDefiningModule().cloneForInlining(ii), this.getName(), this.cloneCallArgs(ii), this.getClosureArg() == null ? null : this.getClosureArg().cloneForInlining(ii), this.isPotentiallyRefined());
    }

    public static InstanceSuperInstr decode(IRReaderDecoder d) {
        int argsLength;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding super");
        }
        int callTypeOrdinal = d.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding super, calltype(ord):  " + callTypeOrdinal);
        }
        RubySymbol name2 = d.decodeSymbol();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding super, methaddr:  " + name2);
        }
        Operand receiver2 = d.decodeOperand();
        int argsCount = d.decodeInt();
        boolean hasClosureArg = argsCount < 0;
        int n = argsLength = hasClosureArg ? -1 * (argsCount + 1) : argsCount;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("ARGS: " + argsLength + ", CLOSURE: " + hasClosureArg);
        }
        Operand[] args2 = new Operand[argsLength];
        for (int i2 = 0; i2 < argsLength; ++i2) {
            args2[i2] = d.decodeOperand();
        }
        Operand closure = hasClosureArg ? d.decodeOperand() : null;
        return new InstanceSuperInstr(d.decodeVariable(), receiver2, name2, args2, closure, d.getCurrentScope().maybeUsingRefinements());
    }

    @Override
    public Instr discardResult() {
        return this;
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRubyObject[] args2 = this.prepareArguments(context, self2, currScope, currDynScope, temp);
        Block block = this.prepareBlock(context, self2, currScope, currDynScope, temp);
        RubyModule definingModule = ((RubyModule)this.getDefiningModule().retrieve(context, self2, currScope, currDynScope, temp)).getMethodLocation();
        return IRRuntimeHelpers.instanceSuper(context, self2, this.getId(), definingModule, args2, block);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.InstanceSuperInstr(this);
    }
}

