/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.DeclarationContainerLoweringPass;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.BlockDecomposerTransformer;
import org.jetbrains.kotlin.ir.backend.js.symbols.JsSymbolBuilder;
import org.jetbrains.kotlin.ir.backend.js.symbols.SymbolBuilderKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionBase;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationContainerLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "decomposerTransformer", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerTransformer;", "nothingType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "lower", "", "irDeclarationContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "irField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "container", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "backend.js"})
public final class BlockDecomposerLowering
implements DeclarationContainerLoweringPass {
    private final BlockDecomposerTransformer decomposerTransformer;
    private final IrType nothingType;

    @Override
    public void lower(@NotNull IrDeclarationContainer irDeclarationContainer) {
        Intrinsics.checkParameterIsNotNull(irDeclarationContainer, "irDeclarationContainer");
        List<IrDeclaration> $receiver$iv = irDeclarationContainer.getDeclarations();
        int i$iv = 0;
        while (i$iv < $receiver$iv.size()) {
            List<IrDeclaration> transformed$iv;
            List<IrDeclaration> list2;
            IrDeclaration item$iv = $receiver$iv.get(i$iv);
            IrDeclaration declaration = item$iv;
            IrDeclaration irDeclaration = declaration;
            if (irDeclaration instanceof IrFunction) {
                this.lower((IrFunction)declaration);
                list2 = CollectionsKt.listOf(declaration);
            } else {
                list2 = transformed$iv = irDeclaration instanceof IrField ? this.lower((IrField)declaration, irDeclarationContainer) : CollectionsKt.listOf(declaration);
            }
            if (transformed$iv == null) {
                ++i$iv;
                continue;
            }
            $receiver$iv.addAll(i$iv, (Collection<IrDeclaration>)transformed$iv);
            $receiver$iv.remove(i$iv += transformed$iv.size());
        }
    }

    public final void lower(@NotNull IrFunction irFunction) {
        Intrinsics.checkParameterIsNotNull(irFunction, "irFunction");
        irFunction.accept(this.decomposerTransformer, null);
    }

    @NotNull
    public final List<IrDeclaration> lower(@NotNull IrField irField, @NotNull IrDeclarationContainer container2) {
        block4: {
            IrElementBase initFn;
            IrSimpleFunctionSymbol initFnSymbol;
            IrExpressionBody $receiver;
            block5: {
                IrExpressionBody irExpressionBody;
                Intrinsics.checkParameterIsNotNull(irField, "irField");
                Intrinsics.checkParameterIsNotNull(container2, "container");
                IrExpressionBody irExpressionBody2 = irField.getInitializer();
                if (irExpressionBody2 == null) break block4;
                $receiver = irExpressionBody = irExpressionBody2;
                initFnSymbol = SymbolBuilderKt.initialize$default(JsSymbolBuilder.buildSimpleFunction$default(JsSymbolBuilder.INSTANCE, ((IrSymbolOwner)((Object)container2)).getSymbol().getDescriptor(), irField.getName().asString() + "$init$", null, null, null, 28, null), null, null, null, null, $receiver.getExpression().getType(), null, null, 111, null);
                IrReturnImpl returnStatement = JsIrBuilder.INSTANCE.buildReturn(initFnSymbol, $receiver.getExpression(), this.nothingType);
                IrBlockBodyImpl irBlockBodyImpl = new IrBlockBodyImpl($receiver.getExpression().getStartOffset(), $receiver.getExpression().getEndOffset());
                IrElementBase $receiver2 = irBlockBodyImpl;
                Collection collection = ((IrBlockBodyImpl)$receiver2).getStatements();
                IrReturnImpl irReturnImpl = returnStatement;
                collection.add(irReturnImpl);
                IrBlockBodyImpl newBody = irBlockBodyImpl;
                IrElementBase $receiver3 = $receiver2 = JsIrBuilder.INSTANCE.buildFunction(initFnSymbol, $receiver.getExpression().getType());
                ((IrFunctionBase)$receiver3).setBody(newBody);
                initFn = $receiver2;
                this.lower((IrFunction)((Object)initFn));
                IrStatement lastStatement = CollectionsKt.last(newBody.getStatements());
                if (Intrinsics.areEqual(lastStatement, returnStatement) ^ true) break block5;
                IrStatement irStatement = lastStatement;
                if (irStatement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrReturn");
                }
                if (!(Intrinsics.areEqual(((IrReturn)irStatement).getValue(), $receiver.getExpression()) ^ true)) break block4;
            }
            $receiver.setExpression(JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, initFnSymbol, $receiver.getExpression().getType(), null, 4, null));
            return CollectionsKt.listOf((IrDeclaration)((Object)initFn), irField);
        }
        return CollectionsKt.listOf(irField);
    }

    public BlockDecomposerLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.decomposerTransformer = new BlockDecomposerTransformer(context);
        this.nothingType = context.getIrBuiltIns().getNothingType();
    }
}

