/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.plugin;

import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeFormat;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.joda.time.DateTimeZone;

public class ExporterSpreadsheet
implements GraphExporter,
CharacterExporter,
LongTask {
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("0.######");
    private boolean exportVisible;
    private ExportTable tableToExport = null;
    private char fieldDelimiter = (char)44;
    private LinkedHashSet<String> columnIdsToExport = null;
    private Workspace workspace;
    private Writer writer;
    private boolean cancel = false;
    private ProgressTicket progressTicket;

    public boolean execute() {
        GraphModel graphModel = (GraphModel)this.workspace.getLookup().lookup(GraphModel.class);
        Graph graph = this.exportVisible ? graphModel.getGraphVisible() : graphModel.getGraph();
        graph.readLock();
        try {
            this.exportData(graph);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            graph.readUnlock();
            Progress.finish((ProgressTicket)this.progressTicket);
        }
        return !this.cancel;
    }

    private void exportData(Graph graph) throws Exception {
        CSVFormat format = CSVFormat.DEFAULT.withDelimiter(this.fieldDelimiter);
        try (CSVPrinter csvWriter = new CSVPrinter((Appendable)this.writer, format);){
            boolean isEdgeTable = this.tableToExport != ExportTable.NODES;
            Table table = isEdgeTable ? graph.getModel().getEdgeTable() : graph.getModel().getNodeTable();
            Object[] edgeLabels = graph.getModel().getEdgeTypeLabels();
            boolean includeEdgeKindColumn = false;
            for (Object edgeLabel : edgeLabels) {
                if (edgeLabel == null || edgeLabel.toString().isEmpty()) continue;
                includeEdgeKindColumn = true;
            }
            TimeFormat timeFormat = graph.getModel().getTimeFormat();
            DateTimeZone timeZone = graph.getModel().getTimeZone();
            ArrayList<Column> columns = new ArrayList<Column>();
            if (this.columnIdsToExport != null) {
                for (String columnId : this.columnIdsToExport) {
                    Column column = table.getColumn(columnId);
                    if (column == null) continue;
                    columns.add(column);
                }
            } else {
                for (Column column : table) {
                    columns.add(column);
                }
            }
            if (isEdgeTable) {
                csvWriter.print((Object)"Source");
                csvWriter.print((Object)"Target");
                csvWriter.print((Object)"Type");
                if (includeEdgeKindColumn) {
                    csvWriter.print((Object)"Kind");
                }
            }
            for (Column column : columns) {
                String columnTitle;
                String columnId = column.getId();
                String columnHeader = columnId.equalsIgnoreCase(columnTitle = column.getTitle()) ? columnTitle : columnId;
                csvWriter.print((Object)columnHeader);
            }
            csvWriter.println();
            Object rows = isEdgeTable ? graph.getEdges() : graph.getNodes();
            for (Element row : rows) {
                if (isEdgeTable) {
                    Edge edge = (Edge)row;
                    csvWriter.print(edge.getSource().getId());
                    csvWriter.print(edge.getTarget().getId());
                    csvWriter.print((Object)(edge.isDirected() ? "Directed" : "Undirected"));
                    if (includeEdgeKindColumn) {
                        csvWriter.print((Object)edge.getTypeLabel().toString());
                    }
                }
                for (Column column : columns) {
                    Object value = row.getAttribute(column);
                    String text = value != null ? (value instanceof Number ? NUMBER_FORMAT.format(value) : AttributeUtils.print((Object)value, (TimeFormat)timeFormat, (DateTimeZone)timeZone)) : "";
                    csvWriter.print((Object)text);
                }
                csvWriter.println();
            }
        }
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    public boolean isExportVisible() {
        return this.exportVisible;
    }

    public void setExportVisible(boolean exportVisible) {
        this.exportVisible = exportVisible;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(char fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public LinkedHashSet<String> getColumnIdsToExport() {
        return new LinkedHashSet<String>(this.columnIdsToExport);
    }

    public void setColumnIdsToExport(LinkedHashSet<String> columnIdsToExport) {
        this.columnIdsToExport = columnIdsToExport != null ? new LinkedHashSet<String>(columnIdsToExport) : null;
    }

    public ExportTable getTableToExport() {
        return this.tableToExport;
    }

    public void setTableToExport(ExportTable tableToExport) {
        this.tableToExport = tableToExport;
    }

    static {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(Locale.ENGLISH);
        symbols.setInfinity("Infinity");
        NUMBER_FORMAT.setDecimalFormatSymbols(symbols);
    }

    public static enum ExportTable {
        NODES,
        EDGES;

    }
}

