/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.impl;

import java.util.Set;
import java.util.regex.Matcher;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.api.GraphElementsController;
import org.gephi.datalab.api.SearchReplaceController;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeFormat;
import org.joda.time.DateTimeZone;
import org.openide.util.Lookup;

public class SearchReplaceControllerImpl
implements SearchReplaceController {
    @Override
    public SearchReplaceController.SearchResult findNext(SearchReplaceController.SearchOptions searchOptions) {
        int row = 0;
        int column = 0;
        if (searchOptions.getStartingRow() != null) {
            row = searchOptions.getStartingRow();
        }
        if (searchOptions.getStartingColumn() != null) {
            column = searchOptions.getStartingColumn();
        }
        SearchReplaceController.SearchResult result = null;
        if (searchOptions.isSearchNodes()) {
            result = this.findOnNodes(searchOptions, row, column);
            if (result == null && searchOptions.isLoopToBeginning()) {
                searchOptions.resetStatus();
                return this.findOnNodes(searchOptions, 0, 0);
            }
            return result;
        }
        result = this.findOnEdges(searchOptions, row, column);
        if (result == null && searchOptions.isLoopToBeginning()) {
            searchOptions.resetStatus();
            return this.findOnEdges(searchOptions, 0, 0);
        }
        return result;
    }

    @Override
    public SearchReplaceController.SearchResult findNext(SearchReplaceController.SearchResult result) {
        return this.findNext(result.getSearchOptions());
    }

    @Override
    public boolean canReplace(SearchReplaceController.SearchResult result) {
        Column column;
        GraphController gc = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (result.getFoundNode() != null) {
            Table table = gc.getGraphModel().getNodeTable();
            column = table.getColumn(result.getFoundColumnIndex());
        } else {
            Table table = gc.getGraphModel().getEdgeTable();
            column = table.getColumn(result.getFoundColumnIndex());
        }
        return ((AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class)).canChangeColumnData(column);
    }

    @Override
    public SearchReplaceController.SearchResult replace(SearchReplaceController.SearchResult result, String replacement) {
        if (result == null) {
            throw new IllegalArgumentException();
        }
        if (!this.canReplace(result)) {
            return this.findNext(result);
        }
        GraphController gc = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (!result.getSearchOptions().isUseRegexReplaceMode()) {
            replacement = Matcher.quoteReplacement(replacement);
        }
        try {
            Column column;
            Node attributes;
            if (result.getFoundNode() != null) {
                attributes = result.getFoundNode();
                column = gc.getGraphModel().getNodeTable().getColumn(result.getFoundColumnIndex());
            } else {
                attributes = result.getFoundEdge();
                column = gc.getGraphModel().getEdgeTable().getColumn(result.getFoundColumnIndex());
            }
            GraphModel graphModel = column.getTable().getGraph().getModel();
            TimeFormat timeFormat = graphModel.getTimeFormat();
            DateTimeZone timeZone = graphModel.getTimeZone();
            Object value = attributes.getAttribute(column);
            String str = value != null ? AttributeUtils.print((Object)value, (TimeFormat)timeFormat, (DateTimeZone)timeZone) : "";
            StringBuffer sb = new StringBuffer();
            Matcher matcher = result.getSearchOptions().getRegexPattern().matcher(str.substring(result.getStart()));
            if (matcher.find()) {
                matcher.appendReplacement(sb, replacement);
                int replaceLong = sb.length();
                matcher.appendTail(sb);
                str = str.substring(0, result.getStart()) + sb.toString();
                result.getSearchOptions().setRegionStart(result.getStart() + replaceLong);
                ((AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class)).setAttributeValue(str, (Element)attributes, column);
                return this.findNext(result);
            }
            return this.findNext(result);
        }
        catch (Exception ex) {
            if (ex instanceof IndexOutOfBoundsException) {
                throw new IndexOutOfBoundsException();
            }
            return this.findNext(result);
        }
    }

    @Override
    public int replaceAll(SearchReplaceController.SearchOptions searchOptions, String replacement) {
        int replacementsCount = 0;
        searchOptions.resetStatus();
        searchOptions.setLoopToBeginning(false);
        SearchReplaceController.SearchResult result = this.findNext(searchOptions);
        while (result != null) {
            if (this.canReplace(result)) {
                result = this.replace(result, replacement);
                ++replacementsCount;
                continue;
            }
            result = this.findNext(searchOptions);
        }
        searchOptions.setLoopToBeginning(true);
        return replacementsCount;
    }

    private SearchReplaceController.SearchResult findOnNodes(SearchReplaceController.SearchOptions searchOptions, int rowIndex, int columnIndex) {
        GraphElementsController gec = (GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class);
        SearchReplaceController.SearchResult result = null;
        Set<Integer> columnsToSearch = searchOptions.getColumnsToSearch();
        boolean searchAllColumns = columnsToSearch.isEmpty();
        Table table = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable();
        Node[] nodes = searchOptions.getNodesToSearch();
        TimeFormat timeFormat = table.getGraph().getModel().getTimeFormat();
        DateTimeZone timeZone = table.getGraph().getModel().getTimeZone();
        while (rowIndex < nodes.length) {
            if (gec.isNodeInGraph(nodes[rowIndex])) {
                Node row = nodes[rowIndex];
                while (columnIndex < table.countColumns()) {
                    Column column;
                    Object value;
                    if ((searchAllColumns || columnsToSearch.contains(columnIndex)) && (result = this.matchRegex(value = row.getAttribute(column = table.getColumn(columnIndex)), searchOptions, rowIndex, columnIndex, timeFormat, timeZone)) != null) {
                        result.setFoundNode(nodes[rowIndex]);
                        return result;
                    }
                    searchOptions.setRegionStart(0);
                    ++columnIndex;
                }
                searchOptions.setRegionStart(0);
                columnIndex = 0;
            }
            ++rowIndex;
        }
        return result;
    }

    private SearchReplaceController.SearchResult findOnEdges(SearchReplaceController.SearchOptions searchOptions, int rowIndex, int columnIndex) {
        GraphElementsController gec = (GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class);
        SearchReplaceController.SearchResult result = null;
        Set<Integer> columnsToSearch = searchOptions.getColumnsToSearch();
        boolean searchAllColumns = columnsToSearch.isEmpty();
        Table table = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getEdgeTable();
        Edge[] edges = searchOptions.getEdgesToSearch();
        TimeFormat timeFormat = table.getGraph().getModel().getTimeFormat();
        DateTimeZone timeZone = table.getGraph().getModel().getTimeZone();
        while (rowIndex < edges.length) {
            if (gec.isEdgeInGraph(edges[rowIndex])) {
                Edge row = edges[rowIndex];
                while (columnIndex < table.countColumns()) {
                    Column column;
                    Object value;
                    if ((searchAllColumns || columnsToSearch.contains(columnIndex)) && (result = this.matchRegex(value = row.getAttribute(column = table.getColumn(columnIndex)), searchOptions, rowIndex, columnIndex, timeFormat, timeZone)) != null) {
                        result.setFoundEdge(edges[rowIndex]);
                        return result;
                    }
                    searchOptions.setRegionStart(0);
                    ++columnIndex;
                }
                searchOptions.setRegionStart(0);
                columnIndex = 0;
            }
            ++rowIndex;
        }
        return result;
    }

    private SearchReplaceController.SearchResult matchRegex(Object value, SearchReplaceController.SearchOptions searchOptions, int rowIndex, int columnIndex, TimeFormat timeFormat, DateTimeZone timeZone) {
        boolean found;
        String str = value != null ? AttributeUtils.print((Object)value, (TimeFormat)timeFormat, (DateTimeZone)timeZone) : "";
        Matcher matcher = searchOptions.getRegexPattern().matcher(str);
        if (str.isEmpty() ? searchOptions.getRegionStart() > 0 : searchOptions.getRegionStart() >= str.length()) {
            return null;
        }
        if (searchOptions.isOnlyMatchWholeAttributeValue()) {
            found = matcher.matches();
        } else {
            matcher.region(searchOptions.getRegionStart(), str.length());
            found = matcher.find();
        }
        if (found) {
            searchOptions.setStartingRow(rowIndex);
            searchOptions.setStartingColumn(columnIndex);
            int end = matcher.end();
            if (matcher.start() == end && !str.isEmpty()) {
                return null;
            }
            if (str.isEmpty()) {
                ++end;
            }
            searchOptions.setRegionStart(end);
            return new SearchReplaceController.SearchResult(searchOptions, null, null, rowIndex, columnIndex, matcher.start(), matcher.end());
        }
        return null;
    }
}

