/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.xdevapi;

import com.mysql.cj.api.xdevapi.BaseSession;
import com.mysql.cj.api.xdevapi.DatabaseObject;
import com.mysql.cj.api.xdevapi.DeleteStatement;
import com.mysql.cj.api.xdevapi.InsertStatement;
import com.mysql.cj.api.xdevapi.Schema;
import com.mysql.cj.api.xdevapi.SelectStatement;
import com.mysql.cj.api.xdevapi.Table;
import com.mysql.cj.api.xdevapi.UpdateStatement;
import com.mysql.cj.x.core.DatabaseObjectDescription;
import com.mysql.cj.x.core.MysqlxSession;
import com.mysql.cj.xdevapi.DeleteStatementImpl;
import com.mysql.cj.xdevapi.ExprUnparser;
import com.mysql.cj.xdevapi.InsertStatementImpl;
import com.mysql.cj.xdevapi.SchemaImpl;
import com.mysql.cj.xdevapi.SelectStatementImpl;
import com.mysql.cj.xdevapi.UpdateStatementImpl;
import java.util.List;
import java.util.Map;

public class TableImpl
implements Table {
    private MysqlxSession mysqlxSession;
    private SchemaImpl schema;
    private String name;
    private Boolean isView = null;

    TableImpl(MysqlxSession mysqlxSession, SchemaImpl schema, String name) {
        this.mysqlxSession = mysqlxSession;
        this.schema = schema;
        this.name = name;
    }

    TableImpl(MysqlxSession mysqlxSession, SchemaImpl schema, DatabaseObjectDescription descr) {
        this.mysqlxSession = mysqlxSession;
        this.schema = schema;
        this.name = descr.getObjectName();
        this.isView = descr.getObjectType() == DatabaseObject.DbObjectType.VIEW || descr.getObjectType() == DatabaseObject.DbObjectType.COLLECTION_VIEW;
    }

    @Override
    public BaseSession getSession() {
        return this.schema.getSession();
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DatabaseObject.DbObjectStatus existsInDatabase() {
        if (this.mysqlxSession.tableExists(this.schema.getName(), this.name)) {
            return DatabaseObject.DbObjectStatus.EXISTS;
        }
        return DatabaseObject.DbObjectStatus.NOT_EXISTS;
    }

    @Override
    public InsertStatement insert() {
        return new InsertStatementImpl(this.mysqlxSession, this.schema.getName(), this.name, new String[0]);
    }

    @Override
    public InsertStatement insert(String ... fields) {
        return new InsertStatementImpl(this.mysqlxSession, this.schema.getName(), this.name, fields);
    }

    @Override
    public InsertStatement insert(Map<String, Object> fieldsAndValues) {
        return new InsertStatementImpl(this.mysqlxSession, this.schema.getName(), this.name, fieldsAndValues);
    }

    @Override
    public SelectStatement select(String ... projection) {
        return new SelectStatementImpl(this.mysqlxSession, this.schema.getName(), this.name, projection);
    }

    @Override
    public UpdateStatement update() {
        return new UpdateStatementImpl(this.mysqlxSession, this.schema.getName(), this.name);
    }

    @Override
    public DeleteStatement delete() {
        return new DeleteStatementImpl(this.mysqlxSession, this.schema.getName(), this.name);
    }

    @Override
    public long count() {
        return this.mysqlxSession.tableCount(this.schema.getName(), this.name);
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == TableImpl.class && ((TableImpl)other).schema.equals(this.schema) && ((TableImpl)other).mysqlxSession == this.mysqlxSession && this.name.equals(((TableImpl)other).name);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Table(");
        sb.append(ExprUnparser.quoteIdentifier(this.schema.getName()));
        sb.append(".");
        sb.append(ExprUnparser.quoteIdentifier(this.name));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean isView() {
        if (this.isView == null) {
            List<DatabaseObjectDescription> objects = this.mysqlxSession.listObjects(this.schema.getName(), this.name);
            if (objects.isEmpty()) {
                return false;
            }
            this.isView = objects.get(0).getObjectType() == DatabaseObject.DbObjectType.VIEW || objects.get(0).getObjectType() == DatabaseObject.DbObjectType.COLLECTION_VIEW;
        }
        return this.isView;
    }

    public void setView(boolean isView) {
        this.isView = isView;
    }
}

