/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin;

import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IpAddressValidator
implements Validator<String> {
    IpAddressValidator() {
    }

    @Override
    public boolean validate(Problems problems, String compName, String s) {
        if (s.startsWith(".") || s.endsWith(".")) {
            problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"HOST_STARTS_OR_ENDS_WITH_PERIOD", (Object)s));
            return false;
        }
        if (s.indexOf(" ") >= 0 || s.indexOf("\t") >= 0) {
            problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"IP_ADDRESS_CONTAINS_WHITESPACE", (Object)compName, (Object)s));
            return false;
        }
        String[] parts = s.split("\\.");
        if (parts.length > 4) {
            problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"TOO_MANY_LABELS", (Object)s));
            return false;
        }
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i == parts.length - 1 && part.indexOf(":") > 0) {
                String[] pts = part.split(":");
                try {
                    int addr = Integer.parseInt(pts[0]);
                    if (addr < 0) {
                        problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"ADDR_PART_NEGATIVE", (Object)pts[1]));
                        return false;
                    }
                    if (addr > 256) {
                        problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"ADDR_PART_HIGH", (Object)pts[1]));
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"ADDR_PART_BAD", (Object)(pts.length >= 2 ? pts[1] : "''")));
                    return false;
                }
                if (pts.length == 2 && pts[1].length() == 0) {
                    problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"INVALID_PORT", (Object)compName, (Object)""));
                    return false;
                }
                if (pts.length <= 1) continue;
                try {
                    int port = Integer.parseInt(pts[1]);
                    if (port < 0) {
                        problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"NEGATIVE_PORT", (Object)pts[1]));
                        return false;
                    }
                    if (port < 65536) continue;
                    problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"PORT_TOO_HIGH", (Object)pts[1]));
                    return false;
                }
                catch (NumberFormatException e) {
                    problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"INVALID_PORT", (Object)compName, (Object)pts[1]));
                    return false;
                }
            }
            try {
                int addr = Integer.parseInt(part);
                if (addr < 0) {
                    problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"ADDR_PART_NEGATIVE", (Object)part));
                    return false;
                }
                if (addr <= 256) continue;
                problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"ADDR_PART_HIGH", (Object)part));
                return false;
            }
            catch (NumberFormatException e) {
                problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"ADDR_PART_BAD", (Object)part));
                return false;
            }
        }
        return true;
    }
}

