/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.desktop.tools.MouseSelectionPopupPanel;
import org.gephi.ui.utils.UIUtils;
import org.gephi.visualization.VizController;
import org.gephi.visualization.api.selection.SelectionManager;
import org.jdesktop.swingx.JXHyperlink;
import org.openide.util.NbBundle;

public class SelectionBar
extends JPanel {
    private JXHyperlink configureLink;
    private JSeparator endSeparator;
    private JLabel statusLabel;

    public SelectionBar() {
        this.initComponents();
        VizController.getInstance().getSelectionManager().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SelectionBar.this.refresh();
            }
        });
        this.refresh();
        this.configureLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SelectionBar.this.statusLabel.isEnabled()) {
                    JPopupMenu menu = SelectionBar.this.createPopup();
                    menu.show(SelectionBar.this.statusLabel, 0, SelectionBar.this.statusLabel.getHeight());
                }
            }
        });
        if (UIUtils.isAquaLookAndFeel()) {
            this.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
    }

    public JPopupMenu createPopup() {
        SelectionManager manager = VizController.getInstance().getSelectionManager();
        final MouseSelectionPopupPanel popupPanel = new MouseSelectionPopupPanel();
        popupPanel.setDiameter(manager.getMouseSelectionDiameter());
        popupPanel.setProportionnalToZoom(manager.isMouseSelectionZoomProportionnal());
        popupPanel.setChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SelectionManager manager = VizController.getInstance().getSelectionManager();
                manager.setMouseSelectionDiameter(popupPanel.getDiameter());
                manager.setMouseSelectionZoomProportionnal(popupPanel.isProportionnalToZoom());
            }
        });
        JPopupMenu menu = new JPopupMenu();
        menu.add(popupPanel);
        return menu;
    }

    public void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectionManager manager = VizController.getInstance().getSelectionManager();
                if (manager.isSelectionEnabled()) {
                    if (manager.isRectangleSelection()) {
                        SelectionBar.this.configureLink.setVisible(false);
                        SelectionBar.this.statusLabel.setText(NbBundle.getMessage(SelectionBar.class, (String)"SelectionBar.statusLabel.rectangleSelection"));
                    } else if (manager.isDirectMouseSelection()) {
                        SelectionBar.this.configureLink.setVisible(true);
                        SelectionBar.this.statusLabel.setText(NbBundle.getMessage(SelectionBar.class, (String)"SelectionBar.statusLabel.mouseSelection"));
                    } else if (manager.isDraggingEnabled()) {
                        SelectionBar.this.configureLink.setVisible(true);
                        SelectionBar.this.statusLabel.setText(NbBundle.getMessage(SelectionBar.class, (String)"SelectionBar.statusLabel.dragging"));
                    }
                } else {
                    SelectionBar.this.configureLink.setVisible(false);
                    SelectionBar.this.statusLabel.setText(NbBundle.getMessage(SelectionBar.class, (String)"SelectionBar.statusLabel.noSelection"));
                }
            }
        });
    }

    private void initComponents() {
        this.statusLabel = new JLabel();
        this.configureLink = new JXHyperlink();
        this.endSeparator = new JSeparator();
        this.setPreferredSize(new Dimension(180, 28));
        this.setLayout(new GridBagLayout());
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(10.0f));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 1, 0);
        this.add((Component)this.statusLabel, gridBagConstraints);
        this.configureLink.setText(NbBundle.getMessage(SelectionBar.class, (String)"SelectionBar.configureLink.text"));
        this.configureLink.setClickedColor(new Color(0, 51, 255));
        this.configureLink.setDefaultCapable(false);
        this.configureLink.setFocusable(false);
        this.configureLink.setFont(new Font("Lucida Grande", 0, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.configureLink, gridBagConstraints);
        this.endSeparator.setOrientation(1);
        this.endSeparator.setPreferredSize(new Dimension(3, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.endSeparator, gridBagConstraints);
    }

    @Override
    public void setEnabled(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Component c : SelectionBar.this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        });
    }
}

