/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.conflict.pair.nodes.NodeListTable;
import org.openstreetmap.josm.gui.conflict.pair.relation.RelationMemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.OsmPrimitivesTable;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class ZoomToAction
extends AbstractAction
implements LayerManager.LayerChangeListener,
MainLayerManager.ActiveLayerChangeListener,
ListSelectionListener {
    private final OsmPrimitivesTable table;
    private final String descriptionNominal;
    private final String descriptionInactiveLayer;
    private final String descriptionNoSelection;

    public ZoomToAction(OsmPrimitivesTable table, String descriptionNominal, String descriptionInactiveLayer, String descriptionNoSelection) {
        CheckParameterUtil.ensureParameterNotNull(table);
        this.table = table;
        this.descriptionNominal = descriptionNominal;
        this.descriptionInactiveLayer = descriptionInactiveLayer;
        this.descriptionNoSelection = descriptionNoSelection;
        this.putValue("Name", I18n.tr("Zoom to", new Object[0]));
        this.putValue("ShortDescription", descriptionNominal);
        this.updateEnabledState();
    }

    public ZoomToAction(MemberTable table) {
        this(table, I18n.tr("Zoom to the object the first selected member refers to", new Object[0]), I18n.tr("Zooming disabled because layer of this relation is not active", new Object[0]), I18n.tr("Zooming disabled because there is no selected member", new Object[0]));
    }

    public ZoomToAction(RelationMemberTable table) {
        this(table, I18n.tr("Zoom to the object the first selected member refers to", new Object[0]), I18n.tr("Zooming disabled because layer of this relation is not active", new Object[0]), I18n.tr("Zooming disabled because there is no selected member", new Object[0]));
    }

    public ZoomToAction(NodeListTable table) {
        this(table, I18n.tr("Zoom to the first selected node", new Object[0]), I18n.tr("Zooming disabled because layer of this way is not active", new Object[0]), I18n.tr("Zooming disabled because there is no selected node", new Object[0]));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        int row = rows[0];
        OsmDataLayer layer = this.table.getLayer();
        OsmPrimitive primitive = this.table.getPrimitiveInLayer(row, layer);
        if (layer != null && primitive != null) {
            layer.data.setSelected(primitive);
            AutoScaleAction.autoScale("selection");
        }
    }

    protected final void updateEnabledState() {
        if (MainApplication.getLayerManager().getActiveDataLayer() != this.table.getLayer()) {
            this.setEnabled(false);
            this.putValue("ShortDescription", this.descriptionInactiveLayer);
            return;
        }
        if (this.table.getSelectedRowCount() == 0) {
            this.setEnabled(false);
            this.putValue("ShortDescription", this.descriptionNoSelection);
            return;
        }
        this.setEnabled(true);
        this.putValue("ShortDescription", this.descriptionNominal);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateEnabledState();
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        this.updateEnabledState();
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
        this.updateEnabledState();
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        this.updateEnabledState();
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }
}

