/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.io.AbstractPrimitiveTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.tools.I18n;

public class UpdatePrimitivesTask
extends AbstractPrimitiveTask {
    private final Collection<? extends OsmPrimitive> toUpdate;

    public UpdatePrimitivesTask(OsmDataLayer layer, Collection<? extends OsmPrimitive> toUpdate) {
        super(I18n.tr("Update objects", new Object[0]), layer);
        this.toUpdate = toUpdate != null ? toUpdate : Collections.emptyList();
    }

    protected void initMultiFetchReaderWithNodes(MultiFetchServerObjectReader reader) {
        this.getProgressMonitor().indeterminateSubTask(I18n.tr("Initializing nodes to update ...", new Object[0]));
        for (OsmPrimitive osmPrimitive : this.toUpdate) {
            if (!(osmPrimitive instanceof Node) || osmPrimitive.isNew()) continue;
            reader.append(osmPrimitive);
        }
    }

    protected void initMultiFetchReaderWithWays(MultiFetchServerObjectReader reader) {
        this.getProgressMonitor().indeterminateSubTask(I18n.tr("Initializing ways to update ...", new Object[0]));
        for (OsmPrimitive osmPrimitive : this.toUpdate) {
            if (!(osmPrimitive instanceof Way) || osmPrimitive.isNew()) continue;
            reader.append(osmPrimitive);
        }
    }

    protected void initMultiFetchReaderWithRelations(MultiFetchServerObjectReader reader) {
        this.getProgressMonitor().indeterminateSubTask(I18n.tr("Initializing relations to update ...", new Object[0]));
        for (OsmPrimitive osmPrimitive : this.toUpdate) {
            if (!(osmPrimitive instanceof Relation) || osmPrimitive.isNew()) continue;
            reader.append(osmPrimitive);
        }
    }

    @Override
    protected void initMultiFetchReader(MultiFetchServerObjectReader reader) {
        this.initMultiFetchReaderWithNodes(reader);
        this.initMultiFetchReaderWithWays(reader);
        this.initMultiFetchReaderWithRelations(reader);
    }
}

