(provide 'snd-peak-phases.scm)
(load "primes.scm")

;;; multiply these phases by pi before use as initial-phases (and use sin, not cos -- see tstall below)
;;; to translate these peaks into the more standard crest-factor, (/ (* peak (sqrt 2)) (sqrt N))
;;;   in the all harmonics case, these go from 1.356 (20) to 1.406 (106) leaving aside N<8
;;;   the square root => sqrt(2), so 1.414 is not good. 


;;; ---------------------------------------- all harmonics ----------------------------------------

(define noid-min-peak-phases (vector

(vector 1  1.0    #r(0))
(vector 2  1.76   #r(0 0))

;; the 1.76 can be calculated (given here that 0 is the min)
;;   take derivative of sin(x) + sin(2x) = cos(x) + 2cos(2x)
;;   use cos(2x) = 2cos^2(x) - 1 to turn this into a quadratic polynomial in cos(x)
;;       4cos^2(x) + cos(x) - 2
;;   let x be cos(x), quadratic formula gives (-1 + sqrt(33))/8, [poly-roots #r(-2 1 4) -> (0.59307033081725 -0.84307033081725)]
;;   take acos of that to get cos(x): 
;;      (acos (+ -1/8 (/ (sqrt (+ 1 32)) 8))) -> 0.93592945566133
;;   plug that into the original: 
;;      (+ (sin 0.93592945566133) (sin (* 2 0.93592945566133))) -> 1.7601725930461
;;   see smax in clm.c -- this works for small n
;;
;; for 1+3, diff is 12cos^3x-8cosx so (acos 0) = pi/2 is a red-herring, but 3cos^2x-2 -> x = (sqrt 2/3), (acos (sqrt 2/3)) -> 0.61547970867039
;;    and (+ (sin 0.61547970867039) (sin (* 3 0.61547970867039))) is 1.539600717839 and
;;    1.5396 + 0.4604 * sin(initial-phase) is very close.
;;
;; we can show that phase=0 is the global min by using simultaneous non-linear equations:
;;
;;   let peak-loc = (acos (/ (- (sqrt 33) 1) 8))
;;       peak (+ (sin peak-loc) (sin (* 2 peak-loc)))
;;       and assume we're focusing on the first min (not pi)
;;
;;   sin(peak-loc) + sin(2*peak-loc + phase) <= peak
;;   so sin(2*peak-loc (i.e. 1.8718) + phase) < (peak - sin(peak-loc)) = 0.9551, but that means phase >= 0 (sin is going down at this point)
;;   sin(-peak-loc) + sin(2*(-peak-loc) + phase) >= -peak
;;   so sin(2*(-peak-loc) + phase) >= -(peak - sin(peak-loc)) = -0.9551, so phase <= 0 (sin is going up)
;;   so phase must be 0 [this argument assumes the peak loc is not jumping around randomly]
;;
;;   I think we can play the same game in n=3 case, but now there are 6 (12?) peaks to fiddle with and 4 global mins
;;   so it's messier.


;; there's always an equivalent point found by flipping the even harmonics, and another pair at 2-val (symmetry around 0)
;; so there are 4 equivalent points.  A function that returns the other 3 given 1 is at the end of this file.


;;; 3 all --------------------------------------------------------------------------------
(vector 3  2.1949383250709 #r(0 0 1)

     1.9798054823226 #r(0.0 5.897251124274717204443163609539624303579E-1 3.166675693251937984129540382127743214369E-1) 
     1.9798054823222 #r(0.0 4.102748875720859667026729766803327947855E-1 1.683332430673265878162681019603041931987E0)  
     1.9798054823226 #r(0.0 1.58972511242745917492413809668505564332E0 3.166675693251493894919690319511573761702E-1)
     1.9798054823222 #r(0.0 1.410274887572085966702672976680332794785E0 1.683332430673265878162681019603041931987E0)

     ;; :(tstall #r(0 62/39 19/60))
     ;; (1.979860844111887127172689015942912379187E0 5.5534000000004)
     ;; same for #r(0 23/39 19/60), always the case (it's symmetric in the 2nd), sin(x) +/- sin(2x + a) + sin(3x + b)
     ;; :(tstall #r(0.0 5.897251124274717204443163609539624303579E-1 3.166675693251937984129540382127743214369E-1) 0.0000001)
     ;; (1.979806197137575924716806491964687429097E0 0.1714663000039)

     1.9797181063317 #r(0.0 0.41022177723939 1.6832780274654)
     1.979716725384 #r(0.0 1.5897793760084 0.31672588155614)
     1.9797162690553 #r(0.0 1.4102202429311 1.6832728267862)

     ;; polynomial is surprisingly good:
     ;;  :all 3 #r(1.9797767193773 0.066455282926612 1.7863254855475)

     ;; big fft
     1.979806 #r(0.000000 0.410275 1.683332)
     )


;;; 4 all --------------------------------------------------------------------------------
(vector 4  2.2962718935302 #r(0 1 1 1)

     2.040  #r(0 33/35 67/50 10/9)               ;(vector 0 1/9 17/24 71/36) -- 2.04242
     2.04012799263 #r(0.000 0.072 0.674 1.912)
     2.04012799263 #r(0.000 0.928 1.326 1.088)
     2.04012799263 #r(0.000 1.072 0.674 0.912)
     2.04012799263 #r(0.000 1.928 1.326 0.088)

     2.0392323180235 #r(0.0 9.429973765023149656627765580196864902973E-1 1.340090256365081833322960846999194473028E0 1.112605206055434337031329050660133361816E0)

     2.038956 #r(0.000000 0.944585 1.341508 1.115059)
     2.038954 #r(0.000000 1.055406 0.658486 0.884929)
     2.038954 #r(0.000000 0.055405 0.658485 1.884926)
     2.038954 #r(0.000000 1.944593 1.341515 0.115071)
 
     ;; :all 4 #r(2.060278672942 -0.70579973196553 0.90455920034382)
     ;; big fft
     2.039104 #r(0.000000 0.055486 0.658542 1.885004)
     2.039103 #r(0.000000 0.055488 0.658545 1.885009)
     )

;;; 5 all -------------------------------------------------------------------------------- ; 2.23
(vector 5  2.5405211753511 #r(0 1 0 0 0)

     2.3434929847717 #r(0.0 0.84531772136688 1.6645057201385 1.4203575849533 1.5933285951614)
     2.3434844481891 #r(0.0 1.8453152570243 1.6649825491504 0.42142125263938 1.5942588576594)

     2.343549 #r(0.000000 1.845237 1.664402 0.420189 1.593154)
     2.343533 #r(0.000000 1.154716 0.335535 0.579695 0.406714)
     2.343497 #r(0.000000 0.845320 1.664496 1.420334 1.593308)
     
     2.343527 #r(0.000000 0.154667 0.335503 1.579672 0.406698)
     2.343513 #r(0.000000 0.154687 0.335490 1.579647 0.406677)
     2.343508 #r(0.000000 1.845332 1.664532 0.420369 1.593338)

     ;; pp:
     2.343485 #r(0.000000 1.154683 0.335509 0.579687 0.406716)
     )

;;; 6 all -------------------------------------------------------------------------------- ; 2.4494
(vector 6  2.8200183503167 #r(0 0 0 0 1 0) 

     2.5509102344513 #r(0.0 0.88722838124921 0.26020415169852 1.2966409163042 1.3233535939997 1.15281977798)
     2.5493413065822 #r(0.0 0.88655948906463 0.26426014425456 1.3003055923199 1.3306838066896 1.1573162129407)

     2.549466 #r(0.000000 1.113453 1.735461 0.699472 0.668803 0.842320)
     2.549414 #r(0.000000 0.886661 0.264519 1.300599 1.331194 1.157723)
     2.549386 #r(0.000000 0.113427 1.735535 1.699526 0.668940 1.842412)
     2.549385 #r(0.000000 1.886568 0.264458 0.300485 1.331039 0.157570)
     2.549360 #r(0.000000 0.886491 0.264319 1.300337 1.330828 1.157371)
     
     2.549302 #r(0.000000 0.886538 0.264356 1.300390 1.330858 1.157418)

     ;; random runs:
     2.549303 #r(0.000000 -0.113461 0.264357 0.300392 -0.669139 0.157420)
     2.549303 #r(0.000000 0.113461 -0.264357 -0.300391 0.669139 -0.157420)
     ;; 2.549304 #r(0.000000 0.113458 -0.264363 1.699605 0.669131 1.842572)
     2.549303 #r(0.000000 0.113461 1.735641 -0.300392 0.669137 -0.157422)
     2.549303 #r(0.000000 0.886537 0.264354 1.300389 1.330856 1.157416)
     )

;;; 7 all -------------------------------------------------------------------------------- ; 2.64575
(vector 7  3.072141248417 #r(0 0 0 1 1 0 1)

     2.639426 #r(0.000000 0.904980 0.986109 1.721148 1.291116 1.621443 0.966099)
     2.639402 #r(0.000000 0.095202 1.014213 1.278914 0.709149 1.378847 1.034223)
     2.639371 #r(0.000000 1.095652 1.014884 0.279318 0.709755 0.379605 1.035166)
     2.639364 #r(0.000000 1.904695 0.985719 0.720925 1.290796 0.621014 0.965536)
     )

;;; 8 all -------------------------------------------------------------------------------- ; 2.8284
(vector 8  3.4905790371793 #r(0 1 0 0 1 1 1 0)

     2.795099 #r(0.000000 1.333103 1.192134 0.394213 1.162609 1.955320 1.855302 0.126169)
     2.794748 #r(0.000000 0.333225 1.192073 1.394414 1.162519 0.954914 1.855082 1.126189)
     2.794737 #r(0.000000 1.666686 0.807757 0.605305 0.837099 1.044558 0.144428 0.873255)
     2.794719 #r(0.000000 0.666709 0.807769 1.605408 0.837217 0.044625 0.144433 1.873342)
     2.794585 #r(0.000000 0.666699 0.807707 1.605285 0.837106 0.044540 0.144374 1.873180)

     ;; pp:
     2.880745 #r(0.000000 0.873927 1.696839 1.009332 0.354675 0.227015 0.156852 0.523641)
     ;; big fft
     2.794684 #r(0.000000 0.333223 1.192169 1.394521 1.162690 0.955202 1.855341 1.126445)
     )

;;; 9 all --------------------------------------------------------------------------------
(vector 9  3.5954569026984 #r(0 1 1 0 1 0 1 1 1)

     2.962087 #r(0.000000 0.872517 1.501013 0.464057 -0.056897 1.063020 1.251698 1.436014 1.254131)
     2.962094 #r(0.000000 1.127564 0.498862 1.535743 0.056794 0.936657 0.748023 0.563510 0.745376)
     2.962065 #r(0.000000 -0.127444 1.501316 1.464492 -0.056263 0.063823 1.252240 0.437075 1.255320)
     2.961916 #r(0.000000 0.127632 0.498978 0.536080 0.057253 -0.062716 0.748729 1.564172 0.746161)
     2.961829 #r(0.000000 1.872309 1.500693 1.463585 1.942384 0.062267 1.250564 0.435026 1.252813)
     2.961652 #r(0.000000 1.872337 1.500914 1.463820 1.942618 0.062504 1.251193 0.435609 1.253539)

     ;; pp:
     2.961653 #r(0.000000 0.872337 1.500915 0.463821 1.942617 1.062504 1.251196 1.435614 1.253542)
     )

;;; 10 all -------------------------------------------------------------------------------- ; 3.162
(vector 10 3.7587492407668 #r(0 1 1 0 1 1 1 0 0 0)

     3.102964 #r(0.000000 0.071632 0.396251 0.504925 0.052683 0.212597 1.057168 -0.172275 1.102043 0.501144)
     3.102823 #r(0.000000 1.070629 0.394872 1.503703 0.050925 1.211208 1.054650 0.825637 1.099957 1.498128)
     3.102782 #r(0.000000 0.927743 1.602314 0.494139 -0.054832 0.785103 0.940332 1.169212 0.894844 0.494709)
     3.102734 #r(0.000000 1.928606 1.603786 1.495372 -0.052790 1.786999 0.942669 0.172108 0.897837 1.498611)
     3.102303 #r(0.000000 -0.071891 1.603086 1.494633 -0.053985 1.786024 0.941426 0.170569 0.896122 1.496522)

     ;; pp:
     3.270687 #r(0.000000 1.665169 -0.138115 1.364203 0.226693 -0.150959 1.661874 0.514042 1.098209 1.445028)
     )

;;; 11 all -------------------------------------------------------------------------------- ; 3.31662
(vector 11 3.8018732822274 #r(0 1 0 0 1 0 0 0 1 1 1)

     3.218745  #r(0.000000 1.518100 1.908924 1.617043 1.540909 0.660141 -0.056826 0.670660 1.165195 1.212229 0.198401)
     3.218587 #r(0.000000 0.518100 1.908924 0.617043 1.540909 1.660141 -0.056826 1.670660 1.165195 0.212229 0.198401)
     3.218514 #r(0.000000 0.481786 0.091759 0.383540 0.459429 1.340439 0.058075 1.330988 0.836240 0.789345 -0.196819)
     3.218444 #r(0.000000 0.482127 0.090769 0.383093 0.459045 1.339823 0.056682 1.328792 0.834826 0.787716 -0.199032)
     3.217965 #r(0.000000 0.482287 0.091029 0.383292 0.459507 1.340271 0.057231 1.329368 0.835616 0.788459 -0.198129)
     
     ;; pp:
     3.468683 #r(0.000000 0.627804 1.366835 0.412917 1.258123 0.658181 0.350130 1.736695 1.823585 1.864191 0.254629)
     )

;;; 12 all -------------------------------------------------------------------------------- ; 3.464
(vector 12 3.7616552322386 #r(0 1 1 0 0 1 0 1 0 0 0 0)

     3.389586 #r(0.000000 0.076743 0.348321 0.615321 0.763893 0.188090 0.117764 1.147735 1.461927 0.591300 1.497863 0.867456)
     3.389547 #r(0.000000 -0.079085 1.648740 1.380212 1.228354 1.804105 1.875295 0.844196 0.527781 1.396624 0.490362 1.119947)
     3.389430 #r(0.000000 1.081078 0.354514 1.624157 0.776410 1.200581 0.129241 0.162495 1.480822 1.614178 1.518801 1.892528)
     3.389128 #r(0.000000 1.076659 0.348730 1.615059 0.764020 1.188577 0.117561 0.148053 1.462454 1.591386 1.497945 1.868055)
     3.388654 #r(0.000000 1.076620 0.347797 1.614462 0.764164 1.188107 0.116910 0.147164 1.461571 1.590619 1.496557 1.866148)

     ;; pp:
     3.546003 #r(0.000000 0.813150 -1.878303 1.450426 -0.112095 -1.110299 -0.487466 -0.181683 0.060170 -0.004101 -0.103775 -0.960524)
     )

;;; 13 all -------------------------------------------------------------------------------- ; 3.6055
(vector 13 4.1211657406183 #r(0 0 0 0 0 0 1 1 0 0 1 0 1) 

     3.525309 #r(0.000000 1.051846 0.170520 1.635159 0.455907 1.511384 -0.147127 1.055447 1.000548 0.097871 0.005880 0.160672 0.616896)
     3.525164 #r(0.000000 0.947554 1.827637 0.362791 1.540717 0.485315 0.143016 0.940517 0.994364 1.896615 -0.012058 1.833412 1.375539)
     3.525069 #r(0.000000 0.947187 1.827546 0.362752 1.541123 0.485247 0.142279 0.941021 0.994821 1.896143 -0.012766 1.832600 1.375866)

     ;; tstall (flip odds):
     3.5254909 #r(0.000000 0.051846 0.170520 0.635159 0.455907 0.511384 -0.147127 0.055447 1.000548 1.097871 0.005880 1.160672 0.616896)

     3.525038 #r(0.000000 0.946517 1.827042 0.361916 1.539603 0.484426 0.141403 0.938505 0.992273 1.893878 -0.015423 1.830018 1.372777)
     3.524879 #r(0.000000 0.948502 1.829668 0.364984 1.544240 0.488687 0.147763 0.945396 1.000061 1.903153 -0.004551 1.840699 1.384079)
     3.524127 #r(0.000000 0.948325 1.829839 0.364837 1.544231 0.489035 0.147691 0.944940 1.000036 1.902764 -0.004752 1.840449 1.384160)

     ;; others:
     3.52549096213107 #r(0.0 1.948154 1.82948 1.364841 1.544093 1.488616 0.147127 1.944553 0.999452 0.902129 1.99412 0.839328 1.383104)
     3.52549096875855 #r(0.0 0.948154 1.82948 0.364841 1.544093 0.488616 0.147127 0.944553 0.999452 1.902129 1.99412 1.839328 1.383104)
     3.52549096484103 #r(0.0 0.051846 0.17052 0.63516 0.455907 0.511384 -0.147127 0.055447 1.000548 1.097871 0.00588 1.160672 0.616896)

     ;; pp:
     3.850623 #r(0.000000 0.969515 0.236902 1.700081 1.532485 1.012414 0.716276 0.879825 0.831162 1.111747 1.357361 -0.014630 0.962342)

     ;; random runs:
     3.548466 #r(0.000000 0.145104 0.529448 0.690774 0.918949 0.803743 0.300955 0.527094 1.381692 -0.078636 0.898029 0.095477 1.535845)
     3.551952 #r(0.000000 0.200284 0.556001 0.721731 0.948469 0.867294 0.332298 0.608081 1.523631 -0.027439 1.029613 0.233328 1.650494)
     3.565324 #r(0.000000 1.479692 0.716290 0.470867 1.057103 -0.084215 -0.738273 -0.085308 0.431895 0.677280 0.250455 0.062101 0.461117)
     )

;;; 14 all -------------------------------------------------------------------------------- ; 3.7416
(vector 14 4.1603193984251 #r(0 1 0 1 1 0 1 0 0 0 1 0 0 0) 

     3.613280 #r(0.000000 0.028982 0.530538 0.496734 -0.474935 -0.580078 0.104750 1.488617 -0.565757 -0.157842 -1.258035 -0.057079 0.253472 -0.294346)
     3.613121 #r(0.000000 0.028974 0.530453 0.496128 -0.475742 -0.580534 0.104588 -0.512201 1.433649 1.841085 0.741103 -0.058374 0.252301 -0.295482)
     3.612244 #r(0.000000 0.028654 0.530107 0.495786 -0.476137 -0.581023 0.103729 -0.513152 1.433095 1.840437 0.739729 -0.059420 0.251093 -0.296875)

     ;; pp:
     3.738333 #r(0.000000 0.876144 1.749283 0.255257 1.233908 0.925717 1.713300 0.790918 0.423428 0.079568 -0.060539 0.064404 0.601933 0.291808)

     ;; others:
     3.612481978033266 #r(0.0 0.971346 1.469893 0.504214 0.476137 1.581023 1.896271 1.513152 0.566905 1.159563 1.260271 1.05942 1.748907 1.296875)
     3.612481989948184 #r(0.0 1.971346 1.469893 1.504214 0.476137 0.581023 1.896271 0.513152 0.566905 0.159563 1.260271 0.05942 1.748907 0.296875)
     3.612481914145143 #r(0.0 1.028654 0.530107 1.495786 -0.476137 0.418977 0.103729 0.486848 1.433095 0.840437 0.739729 0.94058 0.251093 0.703125)

     ;; random runs:
     3.650982 #r(0.000000 0.112109 0.601952 0.789556 0.321827 0.641689 1.325218 0.620188 0.862204 0.131948 1.628685 0.381668 1.695079 1.331292)
     3.672439 #r(0.000000 1.298581 0.470888 1.081624 -0.056336 1.648423 0.916941 0.524303 1.082817 1.859457 0.055963 1.803632 1.767059 0.115666)
     3.727206 #r(0.000000 1.840981 0.831398 1.214172 0.497021 1.582168 0.468315 0.998613 1.548880 1.565691 1.193536 -0.412758 1.463929 0.679465)
     )

;;; 15 all -------------------------------------------------------------------------------- ; 3.8729
(vector 15 4.4060654286219 #r(0 1 0 1 0 1 1 1 1 1 0 1 1 0 0) ; 3.87298 (3.8729833462074)

     3.768991 #r(0.000000 0.863434 1.069349 1.651266 0.272078 0.287377 1.735528 1.050008 0.997192 -0.020076 1.092043 1.658049 1.188297 1.641481 1.391589)
     3.768033 #r(0.000000 0.863152 1.069135 1.651353 0.271851 0.287255 1.735115 1.049678 0.996877 -0.020587 1.091869 1.657562 1.187769 1.641176 1.391193)

     ;; pp:
     3.859726 #r(0.000000 0.426404 1.082257 -0.378600 0.672681 0.084435 0.794375 -0.135830 -0.492292 -0.747360 0.439828 0.395595 0.865535 0.672400 -1.271921)
     )

;;; 16 all --------------------------------------------------------------------------------
(vector 16 4.5445760745314 #r(0 1 1 0 1 0 1 0 0 0 1 1 0 0 0 0)

     3.875080 #r(0.000000 0.730612 0.678979 1.195144 1.632126 1.276744 -0.008560 1.467028 0.525375 0.204869 -0.166129 -0.115302 1.317856 1.622654 0.244306 1.412402)
     3.873760 #r(0.000000 0.727564 0.672436 1.188603 1.622426 1.266314 -0.018679 1.451325 0.507181 0.185750 -0.189066 -0.140317 1.293402 1.595942 0.216437 1.382779)

     ;; pp:
     3.898248 #r(0.000000 0.999637 1.627971 0.563839 1.354119 0.602036 1.818873 1.125095 0.889883 0.658070 0.547416 0.178002 0.696357 0.711221 1.277932 1.486763)
     )

;;; 17 all -------------------------------------------------------------------------------- ; 4.1231
(vector 17 4.7654988506492 #r(0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 1 1)

     3.981459 #r(0.000000 0.520484 1.429480 0.505816 -0.891395 0.114390 0.146335 0.416197 0.938893 0.898753 0.507264 0.650687 -0.081499 -0.607990 0.213218 -0.096782 -0.652476)
     3.980210 #r(0.000000 0.519908 1.429364 0.506455 -0.889349 0.115888 0.147799 0.418944 0.941982 0.901488 0.510707 0.653289 -0.078010 -0.603698 0.217190 -0.091931 -0.646982)

     ;; pp:
     4.025451 #r(0.000000 0.806442 1.640772 0.524823 1.518315 0.179778 1.375417 0.889535 -0.006539 1.626695 1.126057 1.328368 0.940320 1.091090 1.265244 1.868967 -0.027469)
     )

;;; 18 all -------------------------------------------------------------------------------- ; 4.24264
(vector 18 4.795  #r(0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0) 

     4.145376 #r(0.000000 0.815970 1.442468 0.022437 0.838057 0.561089 1.647234 0.678944 1.711039 1.021597 1.327383 0.016884 -0.030470 1.937927 0.480054 1.947188 1.779952 1.482341)
     4.139748 #r(0.000000 0.841029 1.468092 0.061368 0.883567 0.618102 1.726318 0.769330 1.807136 1.123961 1.445068 0.140416 0.092314 0.077559 0.642622 0.110176 1.960387 1.676428)
     4.139675 #r(0.000000 0.843694 1.471411 0.063968 0.889446 0.622071 1.732660 0.775711 1.815657 1.135238 1.453657 0.151363 0.100548 0.088867 0.654716 0.119261 -0.025900 1.692198)
     )

;;; 19 all -------------------------------------------------------------------------------- ; 4.35889
(vector 19 4.957  #r(0 1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1) 

     4.220950 #r(0.000000 0.963878 0.724427 1.142775 1.347933 0.681634 0.858134 1.165699 1.071759 -0.202310 0.544201 1.698473 0.575529 0.392352 1.327300 -0.513540 0.980505 1.004716 0.307249)
     4.218225 #r(0.000000 0.975837 0.737298 1.163191 1.372213 0.708367 0.893430 1.205301 1.114000 -0.155007 0.595375 1.754296 0.630178 0.457584 1.398341 -0.439927 1.059040 1.087418 0.391362)

     ;; pp:
     4.321309 #r(0.000000 0.745098 1.155175 -0.037958 0.532342 1.473567 0.665377 -0.049708 1.767937 0.914818 -0.119772 -0.388406 1.775638 1.206519 1.079401 1.118695 1.930701 1.737887 -0.008406)

     ;; 20 - 1
     4.368453 #r(0.000000 1.547665 1.565484 -0.064501 -0.355088 0.488366 0.392690 -0.094784 0.724088 1.208934 0.016380 0.236409 -0.498288 1.627216 1.538939 0.284041 1.423487 0.812330 1.368338)
     )

;;; 20 all -------------------------------------------------------------------------------- ; 4.4721
(vector 20 5.202707605727 #r(0 0 0 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0)

     4.288981 #r(0.000000 1.288096 1.467454 -0.169090 1.858403 0.280935 0.217741 -0.031571 0.876318 1.220549 0.027164 0.381448 1.736192 1.508757 1.292734 0.007137 1.225400 0.645757 1.237414 0.420948)
     4.288007 #r(0.000000 1.310045 1.497604 -0.134812 -0.097725 0.328441 0.281976 0.032570 0.953720 1.303826 0.111501 0.480774 -0.149523 1.625674 1.415263 0.146621 1.360870 0.796858 1.390400 0.590613)
     4.287958 #r(0.000000 1.307843 1.492560 -0.136998 -0.104073 0.320652 0.273544 0.026577 0.942663 1.293828 0.101160 0.467007 -0.161748 1.610386 1.399614 0.127790 1.342419 0.775594 1.372823 0.570440)

     ;; pp:
     4.467948 #r(0.000000 0.926509 1.348679 0.244038 1.242002 0.019828 1.173056 0.068338 1.504010 1.041584 0.276603 1.806452 1.767012 1.665479 1.374797 1.361818 1.827476 0.132481 0.796064 0.727142)

     ;; random runs:
     4.373082 #r(0.000000 1.736543 0.590014 1.257228 0.334821 0.741756 0.000141 0.933820 1.343880 -0.194453 0.086640 0.579672 0.170191 -0.135507 0.196326 1.615939 0.150737 -0.099336 1.018007 0.681284)
     4.391790 #r(0.000000 0.479270 0.750624 0.806661 0.057204 -0.463791 0.651494 0.232581 0.978315 0.716505 0.027486 0.118399 -0.244751 -0.223933 0.200251 0.798723 -0.077942 -1.206866 -0.599515 -1.192337)
     )

;;; 21 all -------------------------------------------------------------------------------- ; 4.5825
(vector 21 5.3164971341632 #r(0 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0)

     4.482399 #r(0.000000 1.397497 1.231727 1.288294 -0.006341 1.417563 -0.224775 1.544084 0.158820 1.058039 0.318600 1.788531 1.041209 0.988222 1.527762 0.536397 0.600751 0.298693 0.721205 1.590350 -0.083320)

     ;; pp:
     4.574194 #r(0.000000 0.830108 1.212818 -0.114835 0.663864 1.570276 0.585550 1.478198 0.603181 0.202958 1.649503 0.901982 0.255866 0.012434 0.019243 -0.386770 -0.332788 -0.375429 0.023280 0.553342 0.478240)

     ;;20+1
     4.446059 #r(0.000000 0.180019 0.218530 0.984925 -0.958137 -0.620910 0.483363 0.553272 0.541028 -0.013728 0.552503 0.454333 1.235179 -1.297121 0.258699 -0.559729 -0.469061 0.813196 -0.429872 0.235309 -0.551694)
     4.442505 #r(0.000000 0.229264 0.300308 1.095021 -0.794869 -0.465067 0.642830 0.761336 0.766200 0.262204 0.844388 0.785992 1.557676 -0.940794 0.628826 -0.139027 -0.056712 1.215181 0.022101 0.740212 -0.084960)
     )

;;; 22 all -------------------------------------------------------------------------------- ; 4.6904
(vector 22 5.292244006282 #r(0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0)

     4.586632 #r(0.000000 -0.097347 1.080504 0.590888 -0.253961 1.023423 0.714156 1.899465 -0.021982 0.277218 1.158938 0.994197 1.053415 1.055197 1.429563 0.904330 0.879709 1.421582 0.356096 1.550705 0.340822 1.056446)

     ;; 20+2
     4.571664 #r(0.000000 1.311821 0.851164 0.580547 0.048402 1.274604 0.456442 1.682804 0.779139 1.627033 1.074351 1.013793 0.652224 0.595232 0.638584 1.055905 1.176957 1.287858 0.085124 0.572185 1.547525 0.045133)
     4.539850 #r(0.000000 1.877088 1.220531 0.766350 0.912511 -0.049264 -0.015453 1.476348 0.128719 1.226510 1.377381 1.241269 1.228768 0.089299 1.482606 0.589500 -0.172007 0.157776 0.679537 0.684018 -0.353829 0.532234)
     )

;;; 23 all -------------------------------------------------------------------------------- ; 4.7958
(vector 23 5.3592889520338 #r(0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 1 1 1)

     4.605166 #r(0.000000 0.690307 -0.223703 0.265767 1.214689 0.913389 0.192629 1.489393 1.370656 0.848931 0.362934 0.592228 0.586290 0.001276 1.085398 1.699229 1.577973 0.044583 0.292577 1.343812 0.079208 -0.074880 0.197817)
     4.603716 #r(0.000000 0.728519 -0.170578 0.343467 1.289714 1.021005 0.302988 1.638069 1.530207 1.013139 0.545865 0.789599 0.817820 0.223908 1.348504 -0.016545 -0.131209 0.351331 0.607617 -0.321862 0.423879 0.291671 0.585222)
     )

;;; 24 all -------------------------------------------------------------------------------- ; 4.89897
(vector 24 5.6358969066981 #r(0 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 0 1 1 0)

     4.728042 #r(0.000000 1.858980 1.366314 1.303093 0.303565 0.363906 -0.013052 0.288365 1.150614 1.733252 0.305478 1.054343 0.956930 0.688496 0.150610 0.766590 0.723928 0.358579 1.444965 0.475911 1.678841 0.331630 0.146133 0.753447)

     ;; 23+1
     4.797502 #r(0.000000 0.815912 -0.489010 0.238747 0.464672 -0.791156 -0.258728 1.104213 0.634676 0.636859 0.115975 -0.179694 0.187452 -0.818880 0.261843 -0.587852 -0.717075 0.590119 -0.373998 0.804963 -0.982681 -0.821174 -0.611885 -0.513579)
     )

;;; 25 all -------------------------------------------------------------------------------- ; 5
(vector 25 5.6488965032573 #r(0 1 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0)

     4.852860 #r(0.000000 0.230967 1.727317 0.450764 0.017370 0.018890 0.465256 0.875082 0.612377 0.658132 0.067557 0.830777 0.581695 -0.075473 -0.106051 1.748399 0.582315 0.898509 1.395989 0.676438 1.853985 1.350704 1.785330 0.662329 1.015229)

     ;; 24+1?
     4.867199 #r(0.000000 0.511988 0.599074 1.109026 -0.258266 -0.311525 -0.180815 0.514703 -0.058310 0.500087 -0.447647 -1.097227 -0.392984 -0.773229 -0.739391 1.039107 0.423028 -0.118139 1.262658 1.681945 -0.043110 1.191717 1.700807 0.042704 -0.767223)
     )

;;; 26 all -------------------------------------------------------------------------------- ; 5.0990
(vector 26 5.7865648269653 #r(0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0)

     5.004963 #r(0.000000 0.356503 0.613044 0.799459 0.607543 -0.552567 0.275717 0.954617 0.539225 0.390115 0.747516 -0.287816 0.661916 1.821078 -0.045167 -0.217306 1.531723 0.896950 0.283527 0.968137 0.942126 0.004913 -0.474898 0.935500 1.374671 0.106691)
     4.982437 #r(0.000000 0.157773 0.357579 0.470573 0.208359 -1.095460 -0.324361 0.305853 -0.246382 -0.421030 -0.124942 -1.314179 -0.526336 0.680713 -1.271118 -1.537428 0.186315 -0.648152 -1.272801 -0.741946 -0.801258 -1.769664 -0.386094 -1.048075 -0.774396 -0.009812)
     4.981911 #r(0.000000 0.114804 0.305276 0.394495 0.122048 -1.227102 -0.469461 0.152164 -0.415952 -0.596715 -0.349375 -1.548844 -0.778154 0.402539 -1.542539 -1.840236 -0.152677 -0.992660 -1.641041 -1.138828 -1.199533 -0.219776 -0.823305 -1.512557 -1.273176 -0.520822)

     ;; pp:
     5.069005 #r(0.000000 0.693839 1.223177 0.171124 0.655819 1.659284 0.862412 0.167152 1.036280 0.233275 1.065043 0.332100 0.088514 1.217811 0.718617 0.463929 -0.022907 0.301609 1.664942 1.593693 1.159306 1.575199 1.658356 1.791865 0.367495 0.523068)
     )

;;; 27 all -------------------------------------------------------------------------------- ; 5.1961
(vector 27 5.8753981590271 #r(0 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0)

     5.063979 #r(0.000000 1.181312 1.011523 -0.037795 0.952214 0.743188 0.046346 -0.011550 1.593930 1.829003 1.926981 0.836368 0.497093 0.820784 0.581154 1.308971 0.813642 0.203348 0.448693 0.869589 1.163120 0.319576 0.498929 -0.074366 0.820574 1.666665 0.421783)

     ;; 26+1
     5.126119 #r(0.000000 0.900772 1.219713 0.169043 1.065297 1.224400 0.165897 0.980264 0.050341 1.214424 0.625722 0.135385 1.464791 0.070454 0.417426 0.174034 0.437373 0.493624 0.582463 1.623009 1.820016 1.778385 0.847413 1.132593 0.293556 1.847407 0.436103)
     )

;;; 28 all -------------------------------------------------------------------------------- ; 5.2915
(vector 28 6.0962085723877 #r(0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1)

     5.157284 #r(0.000000 0.613262 -0.034248 0.167107 1.753362 0.009121 1.168065 1.319935 0.754215 1.452315 0.403030 1.384036 -0.445049 1.700477 0.448730 1.102474 0.302577 0.114957 0.813938 -1.221580 0.733588 -0.228287 1.379195 0.775101 0.357079 0.863661 0.744441 -0.542730)
     5.156726 #r(0.000000 0.621583 -0.025615 0.185073 1.770611 0.035230 1.190822 1.343738 0.783921 1.481359 0.438924 1.421434 -0.401379 1.746999 0.501100 1.159948 0.364927 0.179358 0.879866 -1.146659 0.808429 -0.150109 1.458018 0.864191 0.450456 0.959743 0.840089 -0.445751)
     )

;;; 29 all -------------------------------------------------------------------------------- ; 5.38516
(vector 29 6.168496131897 #r(0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 0 1 0 1)

     5.241325 #r(0.000000 1.424549 1.434579 0.952506 0.877300 1.948583 1.592791 0.964559 0.950012 1.429458 0.788068 0.556113 0.404906 0.813692 1.604109 0.138120 0.925420 1.345282 1.048370 1.281239 1.347177 1.752489 1.781053 0.782127 0.063659 1.163981 0.330203 1.128951 1.871926)

     ;; 28+1
     5.309949 #r(0.000000 0.846874 0.241547 0.392668 0.105733 0.593095 -0.055728 1.769258 1.471201 0.259232 1.487017 0.394902 0.593301 0.594134 1.608339 0.527615 1.618053 1.488443 0.038033 0.264977 0.515061 1.719999 1.612303 0.816240 0.367893 0.553084 0.901271 1.615714 0.762730)
     )

;;; 30 all -------------------------------------------------------------------------------- ; 5.4772
(vector 30 6.257221698761 #r(0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 1 0 1)

     5.361273 #r(0.000000 1.372797 0.670580 1.057136 -0.495516 0.360919 0.095174 0.542106 0.748047 0.327246 -0.458569 -0.196062 0.499790 0.195141 -0.041091 1.640040 0.876134 1.017379 1.243023 0.157336 0.532420 -0.270945 0.222972 -0.454366 0.519190 0.206280 0.985739 0.329627 0.782987 0.753526)

     ;; 29+1
     5.407828 #r(0.000000 1.401096 1.376571 1.008941 1.027589 -0.085696 1.660515 0.983168 0.985870 1.410812 0.796458 0.476205 0.194328 1.091142 1.765086 0.052662 1.081109 1.265325 0.992243 1.285402 1.599846 1.557990 0.374401 1.559263 0.508151 1.671660 0.671171 1.718845 -0.085252 0.533771)
     )

;;; 31 all -------------------------------------------------------------------------------- ; 5.56776
(vector 31 6.3243918418884 #r(0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1)

	5.479252 #r(0.000000 1.715332 0.740879 1.282120 0.005121 1.133820 1.648029 0.843835 0.870127 0.362478 -0.012264 1.508703 0.898921 1.010311 1.653601 0.519170 0.543334 0.643526 1.650052 0.937580 0.006302 1.745072 0.413200 1.629321 0.671152 0.807947 1.140772 1.157434 0.674253 1.101147 1.176272)
	5.478665 #r(0.000000 1.772425 0.803174 1.328405 0.081611 1.219664 1.725421 0.969769 1.009467 0.524607 0.150580 1.691934 1.088386 1.212688 1.849460 0.777872 0.785597 0.893510 -0.072450 1.225337 0.333131 0.071155 0.764064 0.012661 1.020004 1.202423 1.541822 1.587594 1.095956 1.541832 1.635240)

	5.457715 #r(0.000000 0.335441 1.084827 0.018253 0.737437 1.328926 0.232615 1.324648 1.548727 1.102230 0.582938 0.356482 1.414652 1.240061 0.257198 0.650632 1.787556 1.748026 -0.020851 0.033891 1.146224 0.784975 1.568424 1.015644 1.832440 -0.392011 -0.347982 -0.739222 -0.325456 -0.578410 0.397608)
	5.453054 #r(0.000000 0.330034 1.062392 -0.018048 0.701747 1.293007 0.182311 1.269874 1.478913 1.017407 0.501409 0.269712 1.315062 1.138628 0.142159 0.526931 -0.345056 1.613950 -0.162150 -0.111306 0.991533 0.609140 1.408136 0.828750 1.658057 -0.598529 -0.552356 -0.936876 -0.551564 -0.796775 0.156224)
     )

;;; 32 all -------------------------------------------------------------------------------- ; 5.65685
(vector 32 6.4451498985291 #r(0 0 0 0 0 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 0 1 1 1 0 1 0)  

     5.525650 #r(0.000000 -0.351133 1.293972 -0.243467 0.375774 0.341597 0.388720 0.121948 0.157486 1.353778 0.236182 0.278745 0.140738 1.315014 1.717753 1.193420 1.734782 1.635830 0.448546 0.657631 0.934238 0.325644 1.910640 1.330301 0.498135 1.394503 1.747576 0.388629 0.706077 0.075100 0.832948 -0.013902)
     )

;;; 33 all -------------------------------------------------------------------------------- ; 5.74456
(vector 33 6.5579299926758 #r(0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 0)

     5.631190 #r(0.000000 0.097616 0.529848 0.847242 0.662939 0.833596 1.914696 0.035703 0.153599 0.327398 1.407575 -0.021932 0.932495 1.243452 0.370234 0.653095 -0.062589 1.855791 0.441043 0.248847 0.782346 0.465080 -0.161731 0.929949 0.594824 1.321736 1.693332 1.192619 0.260596 1.271517 1.690356 1.109725 0.567421)
     5.610410 #r(0.000000 0.121938 0.577637 0.964946 0.701543 0.945275 0.057342 0.144831 0.337733 0.549414 1.625058 0.265950 1.238074 1.576246 0.724815 0.984490 0.297228 0.251221 0.699155 0.548588 1.186306 0.951889 0.285802 1.345917 1.014217 1.823546 0.088927 1.726245 0.867511 1.795939 0.286630 1.739958 1.218430)
     5.608483 #r(0.000000 0.127672 0.575757 0.971725 0.693309 0.950898 0.070948 0.160557 0.341181 0.560186 1.645087 0.281844 1.260852 1.598287 0.730804 1.014936 0.316122 0.275621 0.725241 0.597914 1.221833 0.996203 0.324966 1.372541 1.062261 1.875167 0.130133 1.748519 0.894847 1.849289 0.335743 1.776799 1.261232)

     ;; 32+1
     5.661968 #r(0.000000 -0.352238 1.421554 -0.062497 0.287660 0.210756 0.410931 0.134572 0.285343 1.484578 0.353937 0.356204 0.097780 1.509309 1.823077 1.336946 1.794210 1.915189 0.597192 0.803204 1.197066 0.523451 0.168550 1.601444 0.858978 1.682815 0.027376 0.555153 1.077928 0.275560 1.108578 0.224908 -0.307634)
     )

;;; 34 all -------------------------------------------------------------------------------- ; 5.8309518
(vector 34 6.6782836914062 #r(0 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 0 0)

     5.716435 #r(0.000000 1.537850 0.239691 0.279680 1.093753 0.273847 0.872235 1.496985 1.522928 0.760723 1.655491 0.025814 1.234543 0.204722 1.320964 0.722548 0.795411 1.810303 1.109323 1.456118 1.072015 0.656715 1.724740 1.409441 -0.521616 1.350972 1.541354 1.489386 0.627886 0.677049 0.878489 -0.127150 -0.020441 0.557443)
     5.715522 #r(0.000000 1.535834 0.312631 0.280224 1.148017 0.182965 0.826725 1.571414 1.581831 0.887796 1.704031 0.067574 1.286355 0.321441 1.363349 0.812149 0.980936 1.891675 1.179822 1.532746 1.177536 0.667908 1.925108 1.578399 -0.430841 1.453028 1.642459 1.613448 0.724642 0.739942 1.051391 0.000286 0.024547 0.665325)
     5.715061 #r(0.000000 1.557376 0.316186 0.303275 1.175381 0.206598 0.863890 1.615342 1.613470 0.958427 1.750728 0.111536 1.351364 0.386942 1.439281 0.903963 1.075401 -0.020759 1.279610 1.643520 1.269919 0.800947 0.050818 1.687932 -0.298939 1.577236 -0.205754 -0.244682 0.852707 0.888744 1.194917 0.175251 0.202437 0.844132)
     )

;;; 35 all -------------------------------------------------------------------------------- ; 5.9160
(vector 35 6.7637429237366 #r(0 1 1 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0)

     5.764294 #r(0.000000 0.100183 1.398707 0.822554 1.459800 0.154045 1.619372 1.535907 1.542373 0.876004 1.322076 1.293113 1.412723 0.146555 1.058946 0.645359 1.390817 1.072269 0.132103 0.365169 1.845456 1.487696 0.791518 1.753949 0.991873 1.205376 0.200418 -0.166259 0.161894 -0.021712 0.362318 0.686081 1.632970 0.565468 0.901578)
     5.761550 #r(0.000000 0.109331 1.415904 0.863973 1.504657 0.200254 1.669142 1.598436 1.595369 0.964840 1.410141 1.378302 1.505772 0.261951 1.178950 0.757734 1.524984 1.223665 0.264922 0.531725 0.000853 1.660270 0.971853 -0.071328 1.201271 1.414050 0.409445 0.053601 0.377052 0.191601 0.609357 0.945758 -0.105595 0.829816 1.179558)
     )

;;; 36 all -------------------------------------------------------------------------------- ; 6
(vector 36 6.8008880615234 #r(0 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1)

     5.926043 #r(0.000000 1.020111 0.677817 0.140140 0.932921 0.775557 0.190635 1.853238 0.762697 0.237889 0.277245 0.161572 1.553054 0.008070 0.283378 1.674361 -0.347149 0.590912 0.944213 0.823255 0.043034 -0.091562 0.229555 1.352871 0.981843 0.171776 0.581947 0.691871 1.000348 0.829120 1.162722 1.690975 0.634924 1.730234 0.452876 1.429867)

     ;; pp:
     5.876240 #r(0.000000 0.880722 1.509714 0.204909 0.817303 1.618536 0.560409 1.279749 0.308262 -0.524358 0.395653 -0.826907 0.386964 -0.034537 1.535549 1.090154 0.375322 1.512598 1.132860 1.558960 0.892393 0.587406 0.099621 0.325394 -0.086852 -0.097620 -0.036583 0.411674 0.423371 -0.013442 0.469946 0.536299 1.271922 -0.393606 -0.170370 0.277903)
     5.871695 #r(0.000000 0.976078 1.428851 0.077798 0.772784 1.602082 0.472100 1.111861 0.058266 -0.754466 0.191131 -1.049850 0.189192 -0.311703 1.251680 0.977617 0.232753 1.137715 0.806190 1.201023 0.616244 0.157943 -0.415443 -0.020130 -0.548605 -0.551223 -0.509170 0.040073 -0.121612 -0.560043 -0.007571 -0.025396 0.766768 -0.951503 -0.743309 -0.341165)

     ;; 35+1
     5.968866 #r(0.000000 0.133611 1.230434 0.841852 1.312856 0.529755 1.370310 1.332590 1.580324 0.930341 1.428865 1.755052 1.561249 -0.230712 1.582178 0.486609 1.188339 0.984457 0.043840 -0.015979 -0.155552 1.235391 0.874947 1.643065 1.184316 0.952918 0.543242 -0.381983 0.458292 0.068269 0.575524 0.723748 -0.044728 0.683083 1.573491 0.035965)
     )

;;; 37 all -------------------------------------------------------------------------------- ; 6.0827
(vector 37 7.0251078605652 #r(0 0 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0 0 0)

     5.927989 #r(0.000000 1.362671 1.825924 0.295316 1.739841 1.835463 1.048945 1.351967 0.301179 0.388225 1.780488 1.534131 0.435239 0.318363 -0.101295 0.220840 0.998360 1.646237 1.362259 0.730890 0.388056 1.327874 0.110340 1.924981 0.324484 0.429209 1.542714 0.665030 0.018148 0.321441 1.812097 0.446891 1.633693 1.056009 1.344989 1.426723 1.818561)
     5.918646 #r(0.000000 1.276868 1.775826 0.292236 1.788221 1.829337 1.043839 1.351449 0.259082 0.375705 1.700935 1.487286 0.337951 0.306327 -0.126317 0.091444 0.949870 1.546870 1.374856 0.654967 0.351723 1.285561 0.074903 1.824326 0.227704 0.400930 1.466430 0.609151 0.009920 0.222861 1.672440 0.383746 1.542055 1.018281 1.254945 1.323042 1.739217)
     5.918139 #r(0.000000 1.268085 1.769551 0.285066 1.784410 1.812873 1.034440 1.342674 0.256292 0.366678 1.679577 1.477236 0.317949 0.294007 -0.148484 0.067735 0.925643 1.526359 1.349946 0.624511 0.326721 1.258438 0.049695 1.798322 0.189031 0.360477 1.435009 0.581192 -0.024865 0.191624 1.638560 0.341145 1.503234 0.980493 1.208657 1.269237 1.688696)
     )

;;; 38 all -------------------------------------------------------------------------------- ; 6.1644
(vector 38 7.0688242912292 #r(0 0 1 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 0)

     6.106333 #r(0.000000 0.434523 1.232452 1.590516 0.836713 0.138216 -0.095509 1.537371 0.469612 0.772082 0.748819 1.723571 1.820323 0.854103 0.903800 0.048646 1.316356 0.369282 0.213334 0.798970 0.966914 1.376827 0.274641 1.618764 1.873131 -0.092091 -0.470518 1.150403 0.773945 1.198395 0.586433 1.306012 0.434228 0.963298 1.320012 1.145313 0.975992 1.528312)
     ;; 37+1
     6.055823 #r(0.000000 1.140317 1.804958 0.269386 1.581973 1.647143 0.908514 1.357676 0.255360 0.413319 1.759464 1.403831 0.462290 0.275768 -0.260643 0.081477 0.945988 1.674168 1.558839 0.619719 0.448569 1.181188 0.261467 0.173066 0.317765 0.523175 1.483135 0.623965 0.065573 0.279749 1.647027 0.558187 1.546480 1.177439 1.567967 1.574734 1.849511 0.049835)
     )

;;; 39 all -------------------------------------------------------------------------------- ; 6.2449
(vector 39 7.1506487936623 #r(0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 0 1)

     6.123916 #r(0.000000 0.040215 0.172894 1.637830 1.177239 0.763654 -0.119272 0.532576 0.565933 -0.105342 -0.131500 0.223610 0.603849 1.034619 1.719874 1.942807 1.262885 -0.012239 1.521972 1.205939 0.909582 1.593149 1.660841 1.495691 0.901808 0.173365 0.594080 1.535985 0.099680 1.416781 0.772460 -0.143795 1.283054 1.611294 1.560252 0.291114 1.497861 0.152708 0.428638)
     6.123617 #r(0.000000 0.022194 0.139382 1.578109 1.109939 0.686598 -0.209261 0.437705 0.449420 -0.232701 -0.273875 0.070822 0.433690 0.853619 1.527629 -0.258054 1.050086 -0.235174 1.275677 0.950078 0.647199 1.303772 1.358361 1.189190 0.591278 -0.165906 0.244128 1.187114 -0.273717 1.031390 0.371517 -0.540240 0.858520 1.177992 1.114387 -0.172733 1.027118 -0.340480 -0.076231)
     )

;;; 40 all -------------------------------------------------------------------------------- ; 6.3245
(vector 40 7.3913831710815 #r(0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 0 0 0 0)

     6.288342 #r(0.000000 1.454424 1.336242 0.229719 0.982419 1.371484 1.659070 1.721074 -0.039860 0.456961 0.523564 1.259764 0.318922 0.087125 -0.000634 1.738216 -0.345360 -0.093074 0.023146 0.160891 -0.147874 1.232278 0.789559 0.888228 0.482450 1.447335 0.166012 1.058063 1.516605 1.834071 1.250289 0.562291 1.417730 1.678824 0.619402 -0.109426 1.547164 0.339656 1.224949 0.726676)
     ;; 39+1
     6.223875 #r(0.000000 0.017488 0.395122 1.676489 1.264189 0.771372 -0.011418 0.532062 0.348765 -0.291944 -0.034478 0.399358 0.691637 1.117218 1.716574 0.114046 1.298557 0.074462 1.617194 1.080550 1.108787 1.427161 1.645893 1.492515 0.908836 0.183198 0.586816 1.733289 0.192174 1.419647 0.686684 -0.174875 1.274049 1.555620 1.606137 0.123322 1.462205 0.157438 0.491542 -0.249961)
     )

;;; 41 all -------------------------------------------------------------------------------- ; 6.4031
(vector 41 7.4106826782227 #r(0 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1)

	6.328763 #r(0.000000 1.142395 1.764533 -0.297234 1.214342 1.074168 0.499096 0.455971 1.425043 1.900660 0.405160 0.299024 -1.901144 1.886599 1.644748 1.176229 0.661037 1.678309 0.464540 0.540147 1.345672 0.396385 -0.079815 0.750463 0.469580 0.512532 0.818295 0.900948 1.176821 -0.024695 0.941067 1.661160 0.722192 0.141569 0.127463 0.210921 0.877068 0.077777 1.493046 0.191845 0.414613)
	6.279752 #r(0.000000 1.039440 1.670537 -0.269122 1.058663 1.073053 0.461356 0.338125 1.379608 1.686032 0.168477 0.220127 -0.046702 -0.025677 1.700045 1.127479 0.601951 1.764849 0.395397 0.778987 1.079511 0.525179 -0.400733 0.741798 0.221415 0.104621 0.721445 0.669340 0.961099 -0.201573 0.643173 1.703776 0.553797 -0.208803 -0.109492 0.033494 0.694117 0.116494 1.191608 0.020301 0.131256)
	6.278483 #r(0.000000 1.038469 1.689102 -0.246889 1.070891 1.081477 0.456681 0.352855 1.380232 1.717208 0.185595 0.242413 -0.037760 -0.028341 1.684169 1.135689 0.606635 1.756147 0.422850 0.765104 1.090059 0.552553 -0.368817 0.733599 0.247441 0.131196 0.725118 0.703272 0.972734 -0.170957 0.673987 1.704514 0.578697 -0.183550 -0.096757 0.046184 0.705164 0.130867 1.217191 0.056397 0.199710)

	;; 40+1
	6.357979 #r(0.000000 -0.014992 0.249240 1.543670 1.126815 0.662312 -0.052816 0.619055 0.369857 -0.115477 -0.003391 0.180442 0.565001 0.924831 1.661456 -0.128503 1.291579 -0.077357 1.542827 0.991944 0.960719 1.395109 1.631218 1.333505 0.925448 -0.150607 0.489479 1.798022 -0.099011 1.252747 0.567676 -0.055660 1.075602 1.407498 1.261622 0.087709 1.323935 -0.086458 0.259809 -0.431448 0.139996)
     )

;;; 42 all -------------------------------------------------------------------------------- ; 6.4807
(vector 42 7.6252284049988 #r(0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)

     6.458009 #r(0.000000 1.779914 1.358689 1.879744 1.431714 1.455314 0.050417 0.106324 1.650278 0.287736 1.685176 1.015814 0.661574 0.193645 0.754970 0.912901 1.865274 -0.192264 1.123351 1.730828 0.304030 1.844656 1.379904 1.178786 0.508869 0.433728 0.920606 1.193377 1.562403 0.705424 1.521220 0.671316 1.715032 0.818246 0.696173 0.646766 1.054986 -0.067193 0.041834 0.484025 0.025667 0.817193)

     ;; 41+1
     6.374134 #r(0.000000 1.160594 -0.035009 -0.337995 1.287896 1.152937 0.370349 0.599654 1.434075 0.331903 0.337639 0.227520 0.031784 0.056373 1.754183 1.233325 0.766762 -0.105337 0.381752 0.608417 1.177813 0.853286 -0.000702 0.980553 0.580193 0.503346 0.721433 1.102554 1.338903 -0.104016 1.021288 -0.193635 0.638903 0.186655 0.282480 0.311801 1.029234 0.514030 1.400087 0.298091 0.559980 -0.413468)
     )

;;; 43 all -------------------------------------------------------------------------------- ; 6.5574
(vector 43 7.6619415283203 #r(0 1 0 1 0 1 1 1 1 0 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1)

	6.474636 #r(0.000000 1.150199 1.694193 1.156056 0.712558 0.642330 1.062359 0.333465 0.208319 1.376434 0.672147 0.421707 0.175691 0.110131 0.012554 0.457050 1.790874 1.449901 0.302494 0.007271 0.824529 0.122259 0.582806 0.097251 0.623774 0.359297 1.299289 0.938333 1.768060 0.180654 1.104716 1.340371 1.395970 0.480619 1.800871 0.228016 0.933560 0.262964 0.673103 1.298731 1.471774 -0.223423 0.770589)

	;; 42+1
	6.484540 #r(0.000000 0.799805 0.296138 -0.181661 1.243255 0.972255 0.211011 0.157981 1.334009 0.607658 0.666111 0.172358 0.489130 0.433262 0.074913 -0.108461 0.327642 -0.177912 0.391650 0.361860 1.366441 1.197611 0.114750 0.879694 0.781347 0.470866 0.964657 1.349973 1.443504 0.050313 1.040919 -0.331503 1.092413 0.101381 0.547246 0.325671 1.577550 0.316146 1.327141 0.900920 0.939639 -0.347989 0.327657)
	)


;;; 44 all -------------------------------------------------------------------------------- ; 6.6332
(vector 44 7.9767818450928 #r(0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1)

	6.544063 #r(0.000000 0.521564 0.221232 0.526957 -0.268317 1.919404 -0.035203 -0.157289 0.069290 1.705251 1.788014 0.459816 0.274398 0.505529 1.163758 0.357930 -1.720040 0.469129 0.146265 1.215606 1.405712 0.742844 1.668145 1.402279 0.067840 0.255308 0.567789 0.756058 -0.027555 1.587315 0.915687 1.314433 0.227656 0.688969 1.566702 0.434208 -0.041884 1.283408 0.878206 0.471503 1.018383 0.062893 1.376612 0.157588)
	
	;; 43+1
	6.617718 #r(0.000000 0.929303 0.214195 -0.305607 1.575411 0.960005 0.543631 0.816651 1.159803 0.112080 0.077010 0.590695 -0.040249 -0.288217 1.448848 1.235788 0.754544 -0.407692 0.476307 0.769330 1.241658 1.259441 0.282090 0.960527 0.572071 0.268642 0.862727 -0.063301 1.181813 0.657762 0.694907 0.056205 0.912295 0.475141 0.694152 0.927496 1.094556 1.105653 1.775202 -0.143116 1.075592 -0.229850 0.469130 -0.375239)
     )

;;; 45 all -------------------------------------------------------------------------------- ; 6.7082
(vector 45 8.1777801513672 #r(0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 1)

	6.629206 #r(0.000000 0.961180 -0.043617 -0.239190 1.278111 0.166389 0.542833 0.768578 1.444629 -0.095831 1.211952 -0.026602 1.739185 0.951577 1.809231 0.253449 0.320575 0.356270 1.309005 0.639731 1.394153 0.026971 -0.051944 0.744827 0.030297 -0.420287 0.144422 1.021322 1.302658 0.297709 -0.048481 -0.152658 1.144902 1.677136 1.170155 1.132592 1.153458 -0.076024 1.369092 1.009916 0.503324 -0.247395 0.103592 1.569752 0.081999)
	6.624045 #r(0.000000 1.027137 -0.006949 -0.241567 1.292392 0.249243 0.688163 0.937733 1.490593 0.055551 1.221039 0.178575 1.739730 1.011821 -0.089036 0.442654 0.375914 0.532475 1.410268 0.844396 1.467724 0.085993 0.105745 0.803510 0.299479 -0.089745 0.369095 1.074672 1.565553 0.558935 0.123221 0.059937 1.431538 -0.190214 1.489626 1.543857 1.489693 0.130690 1.680298 1.260465 0.724859 0.164445 0.433945 -0.212764 0.411030)
	6.612690 #r(0.000000 0.809914 0.760766 -0.199070 0.584393 1.010129 -0.444768 -0.272636 0.950655 0.770420 -0.288810 0.049214 -1.454088 0.191424 -1.076560 -0.306479 -0.326951 -1.245176 0.685415 0.506132 0.101749 0.628099 0.641810 0.560186 1.064779 -0.804404 -0.612448 0.708592 1.898500 0.642577 0.682702 -0.598959 -1.216733 -1.420060 0.084743 0.265460 1.286043 0.185429 1.160604 0.022683 -0.437513 0.122344 -0.218434 -0.653674 -1.002688)

	;; 44+1
	6.714595 #r(0.000000 0.564364 0.130777 0.656228 -0.319916 1.775107 -0.124290 -0.070841 0.124442 1.500414 1.820670 0.445101 0.236733 0.416487 1.155210 0.503587 -1.734245 0.426011 0.254073 1.069259 1.324509 0.611279 1.824321 1.376553 -0.114105 0.172880 0.631450 0.863080 -0.077524 1.662079 0.769087 1.304043 0.122140 0.610255 1.653927 0.326711 -0.168576 1.291324 0.851943 0.606010 1.047149 0.079373 1.047078 0.035371 -0.264517)
     )

;;; 46 all -------------------------------------------------------------------------------- ; 6.7823
(vector 46 8.22203540802 #r(0 1 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0)

     6.691037 #r(0.000000 1.445996 1.082935 1.926602 0.599270 0.110590 0.061353 0.197460 1.126524 0.801213 0.136799 1.544533 0.424316 0.988423 1.042912 0.904549 0.394264 1.877367 1.781398 0.106378 0.814176 1.462479 1.299353 0.505357 0.691608 0.079788 0.741755 1.296349 0.923407 1.954315 1.519832 1.193777 1.868646 1.501978 -0.016089 0.928107 1.377054 1.114171 1.348483 1.466927 0.885968 1.244812 -0.112245 0.649026 0.159882 0.999017)

     ;; 45+1
     6.737496 #r(0.000000 0.891082 0.437629 -0.631499 1.355029 0.088312 0.525030 0.893686 1.472031 -0.146846 0.973741 0.114371 1.794819 1.120888 1.803610 0.267646 0.313821 0.176598 1.483030 0.561548 1.444435 0.111178 -0.116383 0.572485 0.384889 -0.539242 -0.000026 1.504176 1.488659 0.718239 -0.059775 0.251172 1.363526 1.830593 1.709614 1.067908 1.076519 0.522533 1.398513 0.992929 0.954368 -0.123192 0.213695 1.865385 0.089802 -0.018905)
     )

;;; 47 all -------------------------------------------------------------------------------- ; 6.8556
(vector 47 8.3221893310547 #r(0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 0)

     6.827640 #r(0.000000 1.713417 0.880595 0.228916 0.656232 0.000986 0.228917 -0.027955 1.208960 0.359921 0.457263 0.229897 0.942770 1.345553 -0.054940 0.652154 0.967593 1.474188 0.749564 1.214391 0.623653 1.483712 1.914097 -0.195445 1.486123 0.775521 1.114155 1.267810 1.798008 0.660315 0.102413 1.302210 1.004781 1.037205 1.145399 0.299807 1.478644 1.078433 0.364686 1.769537 0.263449 0.339932 0.328599 1.167886 1.782492 1.089675 1.333666)

     ;; pp.scm
     6.756605 #r(0.000000 0.765562 1.030062 1.788209 0.493707 1.020553 1.799942 0.685170 1.481088 0.566613 1.302518 0.066670 1.157386 0.282906 1.328526 0.161298 1.388649 0.879050 1.843229 1.039366 0.409576 -0.055025 1.222366 0.535280 0.169247 1.679128 1.342099 0.894436 0.643082 0.345708 0.301808 -0.401334 0.022950 1.550170 1.565812 1.633017 1.764984 1.880338 1.607034 1.569498 0.111731 0.416082 0.781558 0.894597 1.438223 1.659212 0.166997)
     )

;;; 48 all -------------------------------------------------------------------------------- ; 6.9282
(vector 48 8.4671268463135 #r(0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1)

	6.861797 #r(0.000000 0.598880 1.244788 1.029903 1.049082 0.596958 1.659653 1.333585 0.658254 1.786003 1.335584 0.009329 0.382880 1.914281 0.167535 0.198984 1.572176 1.516863 0.640701 0.516067 0.942009 -0.405338 1.601326 0.836539 0.796978 0.739838 0.171913 0.969497 0.363583 0.469203 1.258504 0.656687 1.162915 0.889585 1.702682 0.725369 0.456133 0.349105 0.208023 0.802519 1.129136 1.479603 0.312580 1.579555 0.353334 0.757965 1.599847 0.626811)

	;; 47+1
	6.892392 #r(0.000000 0.688844 1.275690 -0.029196 0.666687 1.219038 1.796126 0.686703 1.387045 0.299015 1.486000 0.217586 1.168099 0.122356 1.320410 0.506266 1.401144 0.705689 0.099274 1.001293 0.250881 -0.338513 1.011906 0.589633 -0.026149 1.658621 0.999181 0.670111 0.425438 0.181969 0.283085 -0.428382 -0.237009 1.436619 1.467751 1.345785 1.658556 -0.130875 1.611827 1.446511 -0.136029 0.162128 0.614874 0.798756 1.306679 1.726452 0.077838 -0.060906)

	;; 50-2
	6.804078 #r(0.000000 0.874821 0.948620 -0.030050 0.326575 1.258972 -0.088513 0.113859 0.340515 -0.014269 1.691477 0.675893 0.119114 -0.035346 1.426532 1.152480 0.791174 0.976063 0.731143 1.014136 1.203667 0.311022 -0.203371 1.591275 1.628122 -0.181766 0.450459 0.902610 0.339563 -0.440014 -0.112189 0.959920 1.425584 0.089561 1.717366 0.518887 0.024084 1.133195 1.349821 0.385099 1.797184 0.189610 0.147986 1.156584 -0.006309 1.527354 0.195815 0.002013)
     )

;;; 49 all -------------------------------------------------------------------------------- ; 7
(vector 49 8.5157623291016 #r(0 1 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0)

	6.911687 #r(0.000000 1.423917 -0.117078 -0.215912 1.065526 1.018507 0.645263 1.632151 0.540556 0.415851 1.870183 1.161732 0.983376 1.723916 0.372700 0.063452 0.534166 1.512588 1.454603 0.719318 0.962295 1.537720 1.562020 1.433858 0.930756 1.181983 1.504188 -0.167777 1.662278 0.680834 0.246207 0.675469 0.268474 1.089455 0.369548 -0.146942 -0.055836 1.091821 1.976652 0.486415 1.202030 0.175707 0.854435 0.506884 1.646470 0.139127 0.235704 1.857608 0.297006)

	;; 50-1
	6.874368 #r(0.000000 1.204417 0.954334 -0.405108 0.059322 1.004871 -0.307909 0.766418 1.079079 0.002645 1.437193 0.338324 0.101886 -0.559571 1.466710 1.621612 0.973989 1.377429 0.337678 1.035741 0.679343 0.146983 1.275159 -0.370675 -0.331425 0.304277 -0.450477 1.075881 -0.790453 -0.423723 -0.417480 0.648387 -0.501882 -0.980950 -0.159587 0.593728 -0.757113 1.129266 0.980355 0.172786 -0.231542 -0.093435 -0.126900 0.604505 0.503262 0.476708 0.056575 0.183795 0.839623)
	6.871628 #r(0.000000 1.197339 0.943600 -0.418761 0.049685 1.002197 -0.323377 0.763534 1.062841 -0.005796 1.425933 0.322430 0.084053 -0.585670 1.449690 1.603999 0.946354 1.356731 0.301596 1.002372 0.650650 0.119315 1.243049 -0.407370 -0.367523 0.258301 -0.505816 1.032723 -0.832489 -0.467654 -0.467807 0.598599 -0.548874 -1.027291 -0.206361 0.534378 -0.811327 1.081884 0.922436 0.108022 -0.303016 -0.150120 -0.199521 0.546600 0.438688 0.415808 -0.008696 0.110784 0.758574)
     )

;;; 50 all -------------------------------------------------------------------------------- ; 7.071
(vector 50 8.7809114456177 #r(0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 1)

	7.001572 #r(0.000000 1.510483 0.569660 1.177547 -0.063746 1.651491 0.398933 1.945813 1.189455 0.886784 0.877834 1.209513 -0.281791 0.817195 0.562593 1.509576 -0.448618 -0.075249 1.004074 1.022851 1.197099 0.475529 0.725043 0.148549 0.625214 0.676229 0.641014 0.276388 1.297552 1.512294 0.880442 -0.093329 0.470630 1.205879 -0.595773 0.927383 1.198964 0.435022 1.291534 0.884451 -0.190056 1.483748 1.136079 1.665203 0.167401 0.524695 0.182147 -0.336866 0.803181 1.503900)

	;; 49+1
	7.064944 #r(0.000000 1.558009 -0.108565 -0.226913 0.920197 1.180894 0.537671 1.554384 0.613756 0.458358 0.091191 1.387557 0.869986 1.858139 0.547904 0.135691 0.583740 1.710905 1.421339 0.744505 1.032127 1.414994 1.701011 1.686329 0.940524 1.064348 1.388446 -0.279583 1.723434 0.898036 0.320378 0.547937 0.335420 1.264319 0.407052 0.022184 -0.017105 0.905945 1.912730 0.523724 1.239641 0.158867 0.840449 0.693502 1.785642 0.002311 0.342012 1.897108 0.429747 0.359280)

	;; 51-1?
	6.966444 #r(0.000000 0.969561 1.094228 1.889603 0.178237 1.243506 -0.179029 0.498784 0.715615 0.064553 1.519591 0.490911 0.171201 1.825529 1.138600 1.243991 0.920476 1.084610 0.315165 0.739666 0.806931 0.459500 1.392905 1.470398 1.703973 -0.154232 0.175316 0.961121 -0.195877 -0.203581 -0.104914 0.596805 1.500152 -0.064411 1.474852 0.495330 -0.345550 1.291380 1.361659 0.279253 1.587805 0.037979 -0.094175 0.955070 0.189359 0.883451 0.286407 -0.239876 1.359571 1.605865)
	6.966047 #r(0.000000 0.962905 1.097330 1.888512 0.176170 1.249181 -0.168544 0.509171 0.717525 0.069686 1.526076 0.503308 0.181151 1.831084 1.142478 1.254775 0.935821 1.099009 0.324329 0.750637 0.817716 0.473950 1.405312 1.489970 1.715244 -0.138333 0.191055 0.986798 -0.177541 -0.183900 -0.081646 0.626605 1.530354 -0.052123 1.504605 0.533551 -0.327117 1.309658 1.385783 0.305850 1.613358 0.056196 -0.069816 0.982784 0.217704 0.915410 0.315681 -0.214270 1.383464 1.628385)
     )

;;; 51 all -------------------------------------------------------------------------------- ; 7.141
(vector 51 8.8213935921978 #r(0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1)

     7.062061 #r(0.000000 1.277482 1.272374 1.604932 -0.114681 1.091849 -0.113655 0.581995 0.517152 0.112646 1.392203 0.473053 0.525951 1.781540 1.014930 1.311666 0.597941 1.173291 0.649975 0.688396 0.657382 0.570575 1.699334 1.669408 1.662666 -0.233111 0.196711 0.718758 -0.174442 0.105462 -0.039308 0.924279 1.329687 1.401301 1.538357 0.347724 -0.110320 1.449195 1.223831 0.349599 1.470761 0.191238 1.885833 0.819453 0.145490 0.967802 0.015777 -0.014902 1.276127 1.513254 0.227467)
     6.975170 #r(0.000000 1.372924 1.059217 -0.645861 1.097945 1.058807 0.153152 0.527074 0.651159 0.424719 0.459322 0.332180 0.264613 -0.372847 0.683198 1.120562 0.213922 0.685600 0.345552 0.459914 1.129925 0.756644 0.458857 -0.052979 1.594004 -0.921247 0.485511 1.115573 -0.083642 0.773245 0.508692 1.481091 0.025171 1.228864 1.684948 0.240036 0.474172 0.435815 1.326902 1.195703 -0.007047 1.017216 0.874417 1.846797 0.909867 1.892877 1.240478 -0.484663 1.778802 -0.122729 0.589405)
     6.971782 #r(0.000000 1.381134 1.053573 -0.642284 1.106927 1.065731 0.156795 0.531640 0.658480 0.423307 0.458153 0.332929 0.258309 -0.378345 0.690163 1.115051 0.213852 0.690863 0.353610 0.459744 1.132735 0.758828 0.447315 -0.071617 1.577100 -0.919334 0.495653 1.111932 -0.086022 0.770249 0.516654 1.486418 0.018200 1.218929 1.677748 0.244186 0.465632 0.411266 1.326302 1.201131 -0.010901 1.028025 0.862583 1.846154 0.922121 1.887046 1.218211 -0.479984 1.767657 -0.113149 0.573554)
     )

;;; 52 all -------------------------------------------------------------------------------- ; 7.211
(vector 52 8.9920463562012 #r(0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0)

 	7.134954 #r(0.000000 0.621560 1.464578 1.482376 0.135707 1.345519 0.584967 0.540885 1.784345 0.393329 1.745283 0.530433 1.414971 1.247472 1.329889 0.999552 0.933504 1.580199 0.519254 0.315472 0.473007 1.123477 -0.056053 0.241576 0.391709 1.244898 1.883529 1.120931 1.698334 -0.149261 0.218191 1.134898 0.533381 1.222211 0.249553 -0.114715 1.262472 0.846800 0.877356 0.688478 0.673983 1.103698 1.385836 1.036560 1.331275 0.414915 1.604362 0.874160 0.543444 1.406115 1.239524 0.816202)
	7.102459 #r(0.000000 0.648837 1.347937 1.394205 0.228772 1.369761 0.659192 0.578381 -0.056010 0.281439 1.788400 0.481565 1.424466 1.245338 1.307438 1.071654 0.849375 1.612358 0.470180 0.053038 0.353912 1.080684 -0.161116 0.151468 0.433202 1.019193 1.757938 0.968555 1.596947 -0.203879 0.025193 0.991804 0.446937 1.059356 0.023869 -0.400100 1.079870 0.688268 0.741558 0.481001 0.496940 1.006445 1.004308 0.856157 1.144916 0.288878 1.267244 0.487227 0.316277 1.265206 1.008151 0.448535)
	7.101828 #r(0.000000 0.646351 1.348437 1.394446 0.228508 1.370485 0.660337 0.579558 -0.056026 0.283749 1.791709 0.481733 1.428712 1.245523 1.307690 1.074069 0.851835 1.612005 0.472059 0.051512 0.355641 1.080975 -0.158863 0.150463 0.435366 1.019121 1.758753 0.965820 1.596435 -0.205826 0.026983 0.989221 0.450040 1.062201 0.025319 -0.395664 1.085851 0.689762 0.740855 0.484733 0.501691 1.010487 1.006025 0.857003 1.147326 0.289999 1.266663 0.490356 0.319639 1.268445 1.014342 0.448435)

	;; 51+1
	7.145012 #r(0.000000 1.352385 1.096112 -0.482272 0.885332 0.870800 0.112570 0.382211 0.798266 0.531129 0.345406 0.278068 0.081547 -0.522592 0.532216 1.052537 0.102793 0.798891 0.416786 0.277444 0.906912 0.754729 0.700156 -0.252504 1.434329 -1.160114 0.522833 0.926005 -0.230879 0.705542 0.399151 1.195170 -0.005753 1.038829 1.626916 0.206308 0.196067 0.121343 1.290769 1.164188 0.034677 0.629244 0.574748 1.749902 0.694682 1.749273 1.187350 -0.674905 1.512501 -0.358396 0.363063 -0.122492)
	7.144789 #r(0.000000 1.352391 1.096101 -0.482270 0.885354 0.870760 0.112575 0.382220 0.798263 0.531121 0.345380 0.278012 0.081522 -0.522597 0.532194 1.052519 0.102779 0.798921 0.416757 0.277445 0.906956 0.754684 0.700152 -0.252540 1.434318 -1.160054 0.522800 0.925955 -0.230874 0.705534 0.399191 1.195193 -0.005723 1.038783 1.626886 0.206343 0.196079 0.121327 1.290786 1.164142 0.034729 0.629201 0.574727 1.749850 0.694693 1.749269 1.187356 -0.674899 1.512518 -0.358412 0.362988 -0.122524)
     )

;;; 53 all -------------------------------------------------------------------------------- ; 7.280
(vector 53 9.0914754867554 #r(0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0)

	7.198047 #r(0.000000 0.609644 0.849387 1.600527 1.158365 1.715833 0.524245 -0.059778 0.291176 0.319451 0.985683 1.372433 1.089427 1.749317 1.594481 0.166060 0.927925 -0.362027 0.850015 1.635397 0.732972 1.007069 0.880865 0.290674 0.176669 0.886718 1.772633 0.908528 -0.020813 0.082874 0.257671 1.590012 0.330359 1.893554 1.401328 1.102801 0.720925 0.360594 1.357080 1.833049 0.574052 1.403405 1.851942 1.638866 1.670052 -0.125543 1.654904 0.840665 0.189500 1.798641 0.330271 0.101100 1.702877)

	;; 54-1
	7.176884 #r(0.000000 0.737356 0.760874 1.677578 1.139788 1.733776 0.512545 0.168962 0.294969 0.278922 1.229915 1.512859 1.087438 -0.081926 1.604920 0.197320 1.063397 -0.398250 0.879705 1.816289 0.744289 1.022891 1.064721 0.415657 0.347902 0.773736 1.527156 1.136404 0.028489 0.350665 0.276554 1.845571 0.604279 0.038246 1.467967 1.374232 0.791320 0.557650 1.482264 -0.049230 0.938062 1.746697 0.132063 1.652819 1.777078 0.039226 1.666124 1.061506 0.103648 0.026453 0.558713 0.008013 0.082476)
	7.170025 #r(0.000000 0.735367 0.761108 1.674444 1.148859 1.727214 0.506019 0.166885 0.301941 0.289424 1.228914 1.514765 1.088336 -0.084927 1.605465 0.191699 1.059128 -0.394739 0.884851 1.807751 0.747579 1.030098 1.071564 0.404714 0.353145 0.766117 1.522688 1.133668 0.028958 0.353932 0.272825 1.843589 0.590551 0.041758 1.471960 1.368203 0.792332 0.554867 1.486774 -0.039669 0.938500 1.744333 0.139825 1.659686 1.776069 0.036261 1.664792 1.057651 0.104623 0.024123 0.551601 0.015304 0.093561)
	7.168422 #r(0.000000 0.734800 0.755002 1.678637 1.148472 1.726884 0.506566 0.162329 0.304752 0.290731 1.237477 1.522988 1.097235 -0.074667 1.611785 0.203012 1.069009 -0.398864 0.892774 1.815871 0.743283 1.031741 1.066124 0.407989 0.358481 0.762020 1.519272 1.133826 0.019027 0.362472 0.267333 1.835621 0.594226 0.045578 1.461712 1.370620 0.794797 0.554188 1.488530 -0.030031 0.948673 1.753818 0.146713 1.671920 1.781890 0.035858 1.658572 1.054561 0.107770 0.028848 0.546289 0.017191 0.104880)
     )

;;; 54 all -------------------------------------------------------------------------------- ; 7.348
(vector 54 9.1825122833252 #r(0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1)

	7.253898 #r(0.000000 1.663275 -0.127344 1.382101 -0.144643 1.243444 0.071415 0.455351 1.200018 -0.228088 0.114774 0.009236 0.130605 1.041538 -0.220166 0.676007 1.432141 0.450339 0.554653 1.087402 1.040513 0.270076 0.433523 0.188787 1.457394 -0.061608 1.604147 1.071620 1.033490 -0.059301 1.622008 1.136168 0.012303 1.419176 0.768515 0.526817 1.171505 0.678139 1.461086 0.399056 0.554571 0.834287 1.199853 0.770698 1.010430 1.778823 1.630548 0.874770 0.206125 0.453526 0.079377 1.237714 0.535149 0.779971)
	7.246128 #r(0.000000 1.690671 -0.136333 1.336875 -0.134620 1.250743 0.054577 0.501967 1.180021 -0.191687 0.078154 -0.016563 0.154368 1.002103 -0.214317 0.587755 1.338737 0.453959 0.537717 1.091959 0.985931 0.262538 0.420710 0.232601 1.445283 -0.098407 1.587696 0.956027 0.987798 -0.092532 1.496016 1.083347 0.008893 1.420578 0.727868 0.503289 1.042996 0.653965 1.415827 0.315669 0.540912 0.741976 1.142476 0.660826 0.954089 1.754673 1.467880 0.779704 0.086156 0.370375 0.034370 1.174035 0.430349 0.715725)
	7.245591 #r(0.000000 1.686555 -0.134051 1.339159 -0.139744 1.249317 0.052837 0.496203 1.186868 -0.190398 0.085087 -0.014578 0.148546 1.002089 -0.222856 0.596406 1.341405 0.448014 0.534314 1.092500 0.986488 0.256202 0.422281 0.225300 1.439830 -0.098135 1.589744 0.958350 0.982778 -0.091329 1.504731 1.087277 -0.000312 1.417081 0.729922 0.495573 1.045881 0.653448 1.408480 0.315198 0.535103 0.741972 1.142084 0.667364 0.951873 1.748001 1.479988 0.783357 0.087811 0.364817 0.035646 1.164454 0.433389 0.712104)
     )

;;; 55 all -------------------------------------------------------------------------------- ; 7.416
(vector 55 9.0889595835043 #r(0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1)

	7.328036 #r(0.000000 0.947722 0.378414 1.734925 1.134763 1.116950 -0.197611 1.060282 0.984801 1.744033 0.450580 0.852453 1.635373 0.966832 1.084419 1.003901 1.404608 1.476265 -0.291566 1.533682 1.691990 0.972863 0.920394 1.410967 0.405768 0.418479 1.362359 0.024022 1.434953 0.091943 0.952661 1.025574 1.292952 0.834214 1.423909 0.663594 1.666584 0.346034 0.453528 -0.158265 1.069551 0.339500 0.250235 -0.001369 1.635787 0.775741 0.405595 1.391152 1.825120 -0.221132 -0.233774 0.866177 1.169485 0.610484 1.501517)
	7.300139 #r(0.000000 1.020956 0.293768 1.798256 1.119674 1.146994 -0.132937 1.003662 0.949888 1.796803 0.459925 0.880925 1.582417 0.875464 1.100289 0.952720 1.490815 1.407379 -0.298626 1.479744 1.580341 1.028316 0.802627 1.364981 0.250262 0.211014 1.412363 -0.072953 1.428751 0.047277 0.916222 0.964928 1.114795 0.871317 1.452807 0.648605 1.592871 0.307802 0.554241 -0.122514 1.103516 0.321014 0.250400 0.032285 1.623249 0.802559 0.366667 1.421272 1.732780 -0.264221 -0.262668 0.728446 1.186912 0.469786 1.716376)
	7.299987 #r(0.000000 1.020969 0.293796 1.798197 1.119668 1.147020 -0.132959 1.003677 0.949931 1.796829 0.459947 0.880914 1.582469 0.875424 1.100277 0.952769 1.490876 1.407382 -0.298616 1.479769 1.580356 1.028332 0.802614 1.364991 0.250327 0.211041 1.412324 -0.072992 1.428778 0.047292 0.916259 0.964910 1.114739 0.871338 1.452857 0.648648 1.592866 0.307820 0.554266 -0.122522 1.103511 0.320958 0.250360 0.032244 1.623283 0.802510 0.366699 1.421281 1.732770 -0.264247 -0.262690 0.728471 1.186845 0.469835 1.716425)

	;; 54+1
	7.432099 #r(0.000000 1.618747 -0.153449 1.551651 0.057022 0.983319 0.329322 0.592671 1.061368 -0.265451 0.093666 0.073689 0.191970 0.941940 -0.226532 0.630718 1.504459 0.398912 0.677456 0.969759 0.922508 0.474687 0.473824 0.106191 1.485519 0.211317 1.508720 1.087336 1.052013 0.035924 1.550864 1.050089 0.185510 1.339619 0.715238 0.544593 0.922333 0.813638 1.418714 0.428930 0.510114 0.892067 1.174189 0.405049 1.026718 -0.076773 1.305507 0.682450 0.215555 0.324834 -0.145842 1.269187 0.603278 0.899585 -0.345857)
     )

;;; 56 all -------------------------------------------------------------------------------- ; 7.483
(vector 56 9.1394176483154 #r(0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0)

	7.349437 #r(0.000000 1.546087 1.523699 -0.222814 1.563242 0.073887 1.226569 1.346857 0.292837 1.634387 -0.251778 0.060895 -0.022143 1.595396 1.558207 0.543894 0.524391 1.131307 0.107395 0.049540 1.190567 0.105407 1.309188 1.049686 1.847136 1.739252 0.730834 0.631473 0.965848 1.428286 1.258515 1.585209 1.811352 1.268900 -0.020138 0.642231 1.575017 1.141819 0.549674 0.685664 0.941820 0.311404 0.683359 0.230880 0.725054 -0.246162 1.525527 0.596605 1.235099 0.021275 1.782957 1.875900 1.027532 0.553643 1.151157 -1.905652)
     )

;;; 57 all -------------------------------------------------------------------------------- ; 7.5498
(vector 57 9.370246887207 #r(0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0)

	7.442633 #r(0.000000 0.628456 1.084630 0.786609 1.548782 0.496773 0.435493 0.422694 1.803774 0.918361 0.997194 1.049098 0.185525 0.660957 1.525706 1.561906 1.871425 -0.071743 1.628047 1.493214 -0.116955 0.206404 -0.134909 1.268493 0.758821 0.611040 1.564268 1.138473 1.072129 1.438518 1.711282 0.723211 0.929199 1.378242 0.744685 0.403345 1.655964 0.451399 1.464052 1.394001 0.957137 1.897197 1.337811 0.214489 1.090057 0.644474 1.099729 1.418576 0.330091 1.432560 0.258645 0.901692 0.058744 1.707516 1.251524 1.445949 1.245045)
	7.441636 #r(0.000000 0.622348 1.085878 0.781116 1.543398 0.503464 0.436201 0.436360 1.804081 0.922203 0.997170 1.054550 0.182189 0.658266 1.514505 1.560476 1.876098 -0.073438 1.631568 1.494541 -0.115431 0.197586 -0.136568 1.260188 0.759194 0.602693 1.552249 1.137538 1.078917 1.441614 1.707363 0.723396 0.932457 1.367004 0.727498 0.408065 1.643814 0.447632 1.455697 1.392558 0.945330 1.895625 1.343191 0.216675 1.082075 0.643569 1.094957 1.407053 0.340178 1.425341 0.271660 0.889612 0.056066 1.700603 1.245948 1.440641 1.250791)
	7.441467 #r(0.000000 0.622317 1.086709 0.781210 1.543555 0.503242 0.435992 0.435167 1.805588 0.922076 0.997063 1.053812 0.182167 0.657560 1.514895 1.560202 1.875822 -0.073404 1.631644 1.494624 -0.115787 0.198249 -0.137542 1.260390 0.759500 0.603371 1.553048 1.137852 1.078723 1.442159 1.707807 0.723280 0.931846 1.367412 0.727839 0.407781 1.645303 0.447632 1.455182 1.393340 0.945452 1.895842 1.343341 0.216348 1.083126 0.643542 1.095796 1.407207 0.340817 1.425984 0.271019 0.890314 0.056560 1.699782 1.246486 1.440900 1.252017)

	;; 56+1
	7.588529 #r(0.000000 1.559006 1.528143 -0.234828 1.510743 0.072763 1.134383 1.362254 0.303204 1.570684 -0.091506 0.027141 0.127155 1.600459 1.489127 0.559851 0.585109 1.217750 0.060591 0.195572 1.371350 0.291252 1.406886 1.100984 -0.016324 1.766768 0.695302 0.610137 0.999643 1.441896 1.186797 1.655783 1.557906 1.163328 -0.045033 0.552673 1.529458 1.154094 0.507727 0.569429 0.791719 0.355519 0.577628 0.178344 0.617622 -0.241675 1.589877 0.728380 1.261435 0.065292 1.580960 -0.002275 1.148223 0.618586 1.286855 -1.867003 0.103477)
	)

;;; 58 all -------------------------------------------------------------------------------- ; 7.6157
(vector 58 9.4419231414795 #r(0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1)

     7.593225 #r(0.000000 0.986536 1.505069 0.859324 0.384061 0.501999 -0.052945 0.091682 1.243523 1.160936 0.166126 1.095539 1.756174 -0.122227 0.552109 1.557396 0.685859 1.585162 1.476945 1.055076 1.281043 0.783847 1.368420 0.615588 0.179246 0.641014 1.029588 -0.186574 0.302199 -0.049566 0.358796 -0.163645 1.827318 0.906618 1.173192 -0.306816 0.026558 0.176625 -0.050521 -0.001713 0.047940 0.417922 -0.025755 0.782149 0.436145 0.202813 1.499347 0.776547 1.362707 0.702487 -0.159222 1.853688 0.812543 0.355313 1.668872 1.299867 1.606542 0.186584)

     ;; 57+1
     7.533390 #r(0.000000 0.631892 1.030548 0.996535 1.749363 0.527130 0.477024 0.368639 1.802926 1.003296 1.026792 0.861445 0.354012 0.677047 1.520092 1.568568 1.887052 -0.077599 1.681866 1.559188 -0.163779 -0.032281 -0.010624 1.336711 0.753633 0.560677 1.590572 1.250944 1.018806 1.569329 1.806513 0.820053 1.037991 1.389344 0.762236 0.480656 1.661302 0.465658 1.499904 1.500135 0.971523 1.890287 1.276369 0.072382 1.249962 0.582710 1.223535 1.436175 0.383524 1.412000 0.135455 0.769171 0.142483 1.827353 1.151930 1.547046 1.202745 -0.195258)
     7.481139 #r(0.000000 0.494120 0.912027 1.088506 1.796520 0.662315 0.621396 0.504785 1.809811 0.899674 1.186628 0.627937 0.587445 0.746949 1.418182 1.435063 1.844205 -0.044267 1.752818 1.424221 -0.141018 -0.093784 -0.133478 1.461699 0.840220 0.767006 1.740731 1.152491 1.108382 1.653182 1.853596 0.981136 1.198681 1.579726 0.839579 0.463906 1.810603 0.643978 1.514569 1.529989 1.033048 0.123830 1.430921 0.210010 1.371841 0.593103 1.143424 1.331116 0.451352 1.357884 0.020742 0.723087 0.311054 -0.015301 1.089900 1.570530 1.273463 -0.350924)
     7.471443 #r(0.000000 0.426257 0.958229 1.101908 1.838005 0.610307 0.610431 0.402294 1.784945 0.821317 1.119801 0.451192 0.541444 0.688311 1.334853 1.336110 1.825022 -0.121597 1.624253 1.303585 -0.201276 -0.206522 -0.234612 1.368607 0.780881 0.700656 1.644105 0.970363 1.079078 1.564363 1.736314 0.925048 1.037757 1.476082 0.706932 0.300800 1.747548 0.507618 1.347506 1.440798 0.870823 -0.047835 1.238022 0.066382 1.125573 0.437220 0.934851 1.197820 0.289481 1.232537 -0.191118 0.529022 0.086441 -0.284966 0.840338 1.327489 1.118018 -0.608987)
     )

;;; 59 all -------------------------------------------------------------------------------- ; 7.6811
(vector 59 9.4819116592407 #r(0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0)

	7.633759 #r(0.000000 -0.102106 0.411390 1.377383 1.497595 0.124070 0.977823 0.515946 1.620540 0.196166 1.145526 -0.281630 -0.195296 1.404391 0.189637 1.328165 -0.070129 0.678415 0.164240 0.284857 -0.029704 0.602274 0.993542 1.271589 0.492176 0.728322 0.791637 0.338071 1.390375 1.125972 0.444347 0.171840 0.693527 1.264131 0.439002 1.477092 0.989010 0.611429 0.828210 0.480652 -1.722373 1.692898 0.138317 0.412855 0.367615 1.849818 1.092865 1.381771 0.372051 1.523953 1.713816 0.119731 0.675902 0.655871 0.560189 0.993051 1.958772 1.303462 0.504587)

	; 58+1
	7.567729 #r(0.000000 0.753874 1.108606 0.974281 0.283985 0.662033 0.650997 0.171167 1.713034 0.855505 1.018749 0.891985 0.435917 0.540560 1.459830 1.555159 -0.222214 -0.376165 1.777521 1.607719 -0.138482 -0.185224 0.145078 1.584935 1.029502 0.327951 1.867036 1.174458 1.172033 1.652747 -0.202580 1.284972 0.919829 1.617599 1.002052 0.275343 0.183263 0.550709 1.391786 1.438151 1.764529 0.225407 1.674751 0.321832 1.364256 0.748496 1.336450 1.931791 0.857675 1.688807 0.307620 0.802036 0.148078 0.020000 1.074227 1.654778 1.010253 0.016684 -0.457710)
	7.503908 #r(0.000000 0.755402 1.031043 1.054810 0.281310 0.638484 0.678755 -0.061091 1.874942 1.026651 1.013456 0.902683 0.466589 0.656849 1.693231 1.404646 -0.263499 -0.445923 1.593863 1.790864 -0.147432 -0.163796 0.230058 1.683194 1.076008 0.167830 1.806973 1.082076 1.043689 1.852409 -0.288292 1.355796 0.902626 1.723859 1.100962 0.151371 0.713536 0.566031 1.310021 1.519736 1.945202 0.276664 -0.060810 0.310036 1.449414 0.880895 1.568827 0.004992 1.081894 1.776013 0.590232 0.884973 0.104276 0.124961 0.994848 1.794748 0.874122 -0.016952 -0.401667)

	7.474074 #r(0.000000 0.784407 1.041782 1.035925 0.294935 0.427093 0.721984 0.092420 1.735766 1.156420 1.019936 1.054348 0.499760 0.769486 1.715944 1.586067 -0.192704 -0.173666 1.684164 1.921163 0.055086 -0.007516 0.369080 1.699228 1.136967 0.294437 -0.044080 1.192357 1.158602 -0.133550 -0.087984 1.529854 0.947299 1.902997 1.119257 0.426808 0.806222 0.633135 1.477237 1.877676 0.160692 0.419085 0.158979 0.467821 1.632899 1.068960 1.780863 0.236819 1.171400 0.053940 0.893322 1.037749 0.323864 0.262747 1.171663 1.870355 1.006856 0.079239 0.012532)
	7.470479 #r(0.000000 0.785689 1.041036 1.049808 0.305124 0.429787 0.717256 0.088775 1.726292 1.152522 1.020546 1.048587 0.486018 0.780821 1.724902 1.577515 -0.178695 -0.185526 1.691389 1.934796 0.046932 -0.005323 0.368779 1.699941 1.124598 0.296039 -0.054371 1.191052 1.153518 -0.147974 -0.090335 1.539271 0.964525 1.914880 1.137202 0.430133 0.776829 0.627048 1.462344 1.865385 0.169020 0.418703 0.158957 0.462524 1.623646 1.046298 1.759655 0.230031 1.170263 0.041395 0.885317 1.027465 0.314913 0.257396 1.158882 1.872474 1.012965 0.087584 0.001521)
	7.469439 #r(0.000000 0.786053 1.040825 1.050267 0.305344 0.429180 0.717962 0.088837 1.725419 1.152362 1.020784 1.048370 0.486073 0.781280 1.724120 1.577030 -0.178365 -0.185633 1.691507 1.934596 0.047136 -0.005417 0.368219 1.700165 1.124068 0.296017 -0.054066 1.191543 1.153852 -0.148804 -0.090665 1.539214 0.964764 1.914412 1.137764 0.431014 0.776666 0.626264 1.462361 1.865260 0.168893 0.419387 0.159040 0.463215 1.623762 1.046651 1.759104 0.229882 1.170489 0.041888 0.885618 1.026993 0.314162 0.256790 1.158778 1.872242 1.012776 0.087727 0.001263)
     )

;;; 60 all -------------------------------------------------------------------------------- ; 7.7459
(vector 60 9.575254043103 #r(0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1)

	7.588747 #r(0.000000 0.303100 0.261228 0.917131 0.691793 -0.677124 0.027342 -0.014801 1.166154 0.416979 0.851167 1.410955 0.139409 -0.306122 1.416862 1.054300 0.792442 0.062922 1.507148 0.118287 1.375215 1.459904 1.620963 0.828106 -0.237368 0.987982 0.753194 0.096604 1.712227 1.239483 0.673351 0.871862 0.125962 0.260000 0.626286 0.147473 0.131774 0.201212 -0.194457 0.538798 0.418147 1.292448 0.871870 0.794549 0.988888 1.131816 -0.166311 0.052304 0.543793 -0.229410 0.113585 0.733683 0.271039 1.008427 1.788452 0.654055 0.106430 0.828086 0.097436 0.376461)

	7.602978 #r(0.000000 0.343421 0.247838 0.890443 0.690536 -0.636145 0.032627 -0.000378 1.156652 0.432584 0.839393 1.416383 0.127840 -0.292709 1.416467 1.036542 0.772399 0.056651 1.495999 0.127272 1.372797 1.502550 1.644134 0.832570 -0.243375 0.997261 0.769525 0.097453 1.710505 1.253870 0.665368 0.892296 0.140093 0.282802 0.651418 0.158940 0.136050 0.208538 -0.153899 0.575825 0.407418 1.313964 0.907919 0.810047 0.999387 1.167125 -0.147437 0.049028 0.552121 -0.233036 0.124726 0.749826 0.278658 1.024092 1.803794 0.682067 0.122571 0.837344 0.113035 0.386515)
	7.590331 #r(0.000000 0.311984 0.250997 0.912573 0.685307 -0.665850 0.023992 -0.010652 1.155235 0.412085 0.828254 1.410116 0.128955 -0.317825 1.409520 1.027436 0.770269 0.045987 1.490193 0.103477 1.366721 1.457750 1.601967 0.817113 -0.255006 0.965021 0.733462 0.069204 1.685229 1.226151 0.638827 0.852828 0.104728 0.233598 0.610755 0.125702 0.105148 0.180856 -0.214881 0.523640 0.392812 1.269846 0.858737 0.764879 0.959798 1.115862 -0.192768 0.019990 0.508867 -0.268592 0.089478 0.700272 0.229721 0.977531 1.747500 0.628081 0.078292 0.787525 0.066967 0.336229)

	;; 59+1
	7.590282 #r(0.000000 0.733138 1.013982 0.976445 0.137462 0.487623 0.751851 0.069472 1.549481 1.155782 1.046980 1.186482 0.568124 0.803953 1.789655 1.516254 -0.191066 -0.219967 1.700371 -0.224496 0.157791 -0.111548 0.405580 1.483434 1.154097 0.317993 -0.073620 0.992764 1.231445 -0.032509 -0.320514 1.522634 0.865145 1.901286 0.960655 0.354881 0.887935 0.632429 1.539449 1.796728 0.215526 0.494912 0.201957 0.338737 1.611488 0.995308 1.769709 0.293624 1.032457 -0.035773 0.969779 0.986746 0.288318 0.266521 1.043059 1.780802 1.010653 0.120423 -0.003596 0.427001)

	7.603891 #r(0.000000 0.869514 1.080279 1.038282 0.135313 0.502512 0.753215 0.089242 1.596695 1.140586 1.072278 1.110589 0.576325 0.731075 1.742992 1.495632 -0.196475 -0.226828 1.727532 -0.133741 0.230207 -0.117450 0.423631 1.531789 1.092093 0.236032 -0.105598 1.029301 1.286697 -0.074793 -0.255644 1.497986 0.908690 1.870731 1.038299 0.451133 0.829007 0.646965 1.519446 -0.162832 0.219693 0.485075 0.227341 0.372733 1.638093 0.931769 1.686949 0.361408 1.025558 -0.066479 0.903195 0.950470 0.309255 0.305219 1.085274 1.776201 0.968529 0.071917 -0.078070 0.465046)
     )

;;; 61 all -------------------------------------------------------------------------------- ; 7.8102
(vector 61 9.9175914844707 #r(0 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1)

     7.764539 #r(0.000000 0.501749 1.326260 -0.002830 0.440140 1.954758 -0.008202 0.999918 0.013473 0.542424 0.025115 0.566063 0.591900 -0.196853 0.709527 1.494974 0.701049 1.000710 1.261876 0.543883 0.605458 1.371875 -0.020772 0.931648 0.804346 0.926420 0.633175 0.027958 1.257581 0.427959 1.076239 -0.091270 1.537981 0.146252 0.640848 0.257921 1.798714 0.191485 0.663913 1.946117 1.528077 1.065296 -0.320137 1.459211 1.030583 1.751744 1.068882 0.287431 0.162869 0.095930 0.749409 1.433537 1.416981 -0.082974 0.219907 0.200900 1.575224 1.106230 0.733650 1.327996 1.447241)

     ;; 60+1
     7.719726 #r(0.000000 0.495866 0.238287 0.955451 0.664842 -0.741345 -0.016068 0.189591 1.246084 0.190700 0.813293 1.426582 0.137309 -0.550659 1.409544 1.156142 0.580188 0.236603 1.480403 0.143969 1.355902 1.548768 1.667460 1.127939 -0.533143 1.068231 0.694662 0.416966 1.883169 1.321748 0.722703 0.140270 -0.032806 0.383094 0.464150 -0.057082 0.068615 0.492413 -0.310601 0.595711 0.295373 1.620960 0.719532 0.564630 0.996701 1.168180 -0.350959 0.028358 0.396854 -0.442188 -0.001549 0.385465 0.224100 0.834114 -0.091422 1.036164 0.264065 1.003524 -0.049053 0.311309 -0.096718)
     7.718493 #r(0.000000 0.490794 0.242481 0.957898 0.662750 -0.742881 -0.016296 0.184736 1.253821 0.192761 0.810471 1.424644 0.139002 -0.552618 1.410815 1.159145 0.578377 0.235962 1.481912 0.147798 1.356870 1.551452 1.671348 1.124242 -0.535143 1.068113 0.692544 0.422646 1.876765 1.326092 0.722719 0.142011 -0.034790 0.381612 0.462371 -0.053314 0.063624 0.488941 -0.311525 0.596438 0.293354 1.627834 0.719558 0.563559 0.991769 1.160122 -0.358559 0.031628 0.400641 -0.444384 -0.013306 0.380359 0.226825 0.830723 -0.092522 1.028901 0.262077 1.004376 -0.055799 0.311561 -0.101231)
     )


;;; 62 all -------------------------------------------------------------------------------- ; 7.8740
(vector 62 9.9292116165161 #r(0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0)

	7.792971 #r(0.000000 0.798156 1.779815 0.185967 1.670273 1.438952 1.815697 1.053871 0.087440 0.689337 0.052342 1.443903 1.423782 0.060887 1.727890 0.158639 0.952692 0.005318 0.914138 1.225205 0.683016 0.673829 0.109419 1.593849 0.225994 1.125995 0.418481 0.240605 0.743642 0.622844 0.353010 1.543180 1.534972 1.657806 0.217386 1.492286 1.132686 0.760213 1.147881 1.490201 0.001889 1.030507 1.289026 1.160822 0.387338 1.616191 1.464636 1.793960 1.874455 0.680274 1.683218 1.490668 0.689023 0.705366 0.946252 1.171040 0.109657 1.208442 0.793211 0.697986 1.263366 1.490757)
	7.791756 #r(0.000000 0.794255 1.776105 0.184372 1.667961 1.440185 1.817320 1.053449 0.082409 0.687457 0.048164 1.444125 1.423252 0.061081 1.727243 0.162932 0.953680 0.005222 0.917056 1.225176 0.682682 0.672057 0.108792 1.597133 0.224159 1.125545 0.417480 0.240811 0.741742 0.625708 0.356451 1.543976 1.537969 1.658348 0.209650 1.492266 1.130024 0.756184 1.143465 1.484763 0.002845 1.030762 1.291665 1.164813 0.385858 1.615844 1.466799 1.796934 1.874708 0.677123 1.684900 1.485354 0.688305 0.708676 0.948779 1.173098 0.106201 1.209490 0.787951 0.696086 1.257404 1.488223)
     )

;;; 63 all -------------------------------------------------------------------------------- ; 7.9372
(vector 63 9.9555234909058 #r(0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 0 1 0)

     7.900930 #r(0.000000 0.112702 0.086876 0.634314 1.554089 0.214604 -0.203567 1.256800 0.100458 0.246503 1.488987 0.107459 1.914177 1.161772 1.897454 0.320257 1.283205 0.869894 1.466310 1.256681 0.167147 1.720679 0.949230 1.041227 1.129363 1.077459 1.317157 1.129579 0.390441 1.000383 0.208075 1.779398 1.501532 1.375523 -0.023235 1.338796 1.635364 1.234484 1.323162 0.435451 0.903475 1.821268 1.474898 0.271740 1.558504 0.547732 0.837920 0.522756 0.001164 1.566827 1.197274 1.065607 0.155490 1.019206 1.516032 -0.064964 -0.144993 0.026714 1.048953 1.812875 0.299023 0.685547 0.728053)

     7.876881 #r(0.000000 0.730162 1.053547 1.853555 0.252740 0.906538 1.566071 0.152709 1.015626 1.877411 0.660255 1.513063 -0.004442 1.023537 0.043516 0.973208 -0.080949 0.883081 -0.126245 1.080582 0.224101 1.423101 0.674610 1.604094 0.756913 0.381286 1.606872 1.293154 0.397443 1.644011 1.075770 0.644269 0.164589 -0.255888 1.331182 0.886941 0.357762 0.438290 1.706681 1.847928 1.153249 1.311949 1.226087 1.303371 0.783267 0.589091 0.697039 0.351577 0.554862 0.724022 0.729451 0.902218 0.841292 1.194121 1.061823 1.429706 0.001167 -0.011629 0.776088 1.037188 1.244629 1.522995 0.260285)

     ;; 62+1
     7.793784 #r(0.000000 0.604834 1.810468 0.479158 1.833042 1.567985 -0.008145 1.139628 0.500517 1.068759 0.129009 1.082620 1.606832 0.022087 1.588661 -0.153130 0.676199 0.010115 0.698933 1.351365 0.913525 0.821255 0.678484 1.196033 0.336031 0.980483 0.167734 -0.166196 0.584197 0.895241 0.166400 1.887408 1.404231 1.357967 0.000767 1.273439 0.959305 0.625351 1.435222 1.581734 -0.027156 1.322760 1.634581 1.284691 0.324951 1.829465 1.346510 -0.070824 -0.074038 0.522954 1.755297 1.609271 1.147322 0.784177 0.915115 1.284187 -0.070344 1.582369 1.006518 0.377560 1.009520 1.290325 -0.295994)
     7.792658 #r(0.000000 0.604958 1.810993 0.479572 1.832501 1.568102 -0.008375 1.139554 0.500438 1.068891 0.129208 1.082690 1.606602 0.021403 1.588850 -0.152836 0.676059 0.009863 0.698550 1.351044 0.912935 0.821309 0.678462 1.195880 0.335962 0.980439 0.167296 -0.166103 0.584580 0.895326 0.165904 1.888061 1.403790 1.358315 0.000771 1.273834 0.958915 0.625533 1.434996 1.581517 -0.027021 1.322879 1.634409 1.284726 0.325288 1.829740 1.346606 -0.071117 -0.074172 0.523456 1.755231 1.609173 1.147725 0.784584 0.915037 1.284527 -0.069280 1.582487 1.006637 0.377855 1.009315 1.289847 -0.296346)
     )

;;; 64 all -------------------------------------------------------------------------------- ; 8
(vector 64 9.957244923706 #r(0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1)

    7.941887 #r(0.000000 0.078350 0.185008 1.926703 0.321363 1.181646 1.402668 0.610982 0.623089 1.216601 1.332592 -0.291595 1.818855 1.612142 0.352450 -0.172928 1.880133 1.280898 1.910145 0.775896 0.915424 1.581714 0.463086 0.548034 1.045305 1.495776 -1.677351 1.247040 0.522690 1.227534 1.269499 0.212698 -0.052232 1.635256 1.888480 1.734142 1.150438 1.012285 0.389543 -0.097094 -0.358616 1.129328 0.215283 0.611096 0.487394 1.263156 0.637871 1.355777 0.092029 0.148467 1.060411 0.413204 1.241091 0.569303 1.457881 0.998119 0.874341 0.432403 1.077636 0.523921 0.747328 1.722616 0.867015 0.916274)

     ;; 63+1
     7.852593 #r(0.000000 0.825112 1.882318 0.451509 0.012998 1.639009 0.186070 1.361114 0.503493 1.308226 0.187566 1.154228 1.519693 0.016493 1.654055 0.133569 0.677683 0.038167 0.453693 1.326886 0.811770 1.182840 0.767976 1.306039 0.513845 0.875502 0.344585 -0.071461 0.625939 0.904824 0.020665 1.775810 1.364597 1.313323 0.157145 1.372768 1.111614 0.377004 1.340696 1.756191 -0.307041 1.279247 1.512890 1.161668 0.344904 1.870013 1.328981 0.030268 -0.036888 0.551836 1.737903 1.637471 1.164315 0.705326 1.030571 1.361467 -0.181207 1.620264 1.058937 0.469215 1.047362 1.285537 -0.195579 0.052724)
     7.850378 #r(0.000000 0.818256 1.893797 0.447574 0.004615 1.627422 0.174323 1.354149 0.505328 1.291333 0.192178 1.130810 1.484813 -0.020048 1.628923 0.116957 0.662375 0.012432 0.429672 1.291396 0.784440 1.176860 0.720821 1.253711 0.466453 0.835831 0.299457 -0.100473 0.586092 0.852720 -0.020740 1.729307 1.309937 1.257236 0.131855 1.336452 1.066797 0.322890 1.283543 1.689513 -0.371492 1.214117 1.466426 1.111681 0.289267 1.807002 1.269572 -0.053895 -0.092329 0.477788 1.677216 1.588667 1.094746 0.622096 0.954171 1.266653 -0.249077 1.541492 0.994736 0.424957 0.957923 1.192779 -0.269608 -0.039051)
     )

;;; 65 all -------------------------------------------------------------------------------- ; 8.0622
(vector 65 10.157649040222 #r(0 0 1 1 1 0 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 1 0)

     8.034868 #r(0.000000 -0.445401 1.151245 1.279345 1.476130 1.870307 1.647070 -0.199190 0.996479 1.841605 1.029874 1.628641 0.687865 0.948026 1.437242 1.472256 1.713531 0.116128 0.684445 1.801135 -0.030628 1.120947 0.852540 1.164480 1.740537 0.856297 1.486946 0.172686 0.895511 0.630282 1.378315 0.169569 1.750827 0.453225 1.137053 0.474570 0.449455 1.468205 1.690172 0.505222 -0.186497 0.479672 0.299749 1.440549 1.876899 0.243582 0.699167 0.152947 0.932331 0.165767 1.486581 1.086937 1.179952 1.305509 1.186761 0.971873 0.910187 0.131821 0.021623 1.435803 1.077493 0.071755 1.363290 0.536054 0.282812)
     
     ;; 64+1??
     7.989976 #r(0.000000 0.717074 1.790137 0.303763 0.122314 1.682143 0.216359 1.275289 0.381110 1.232945 0.219920 1.195050 1.544622 0.012541 1.697713 0.164535 0.808696 -0.033093 0.436931 1.424336 0.953440 1.075346 0.847229 1.377732 0.455680 0.844396 0.388170 -0.232520 0.566111 1.006265 0.239235 -0.064356 1.478182 1.310771 0.100992 1.360730 1.120501 0.518973 1.403629 1.737998 -0.215831 1.519996 1.486448 1.299685 0.264762 0.058410 1.261254 0.113761 -0.018088 0.416310 -0.086576 1.654308 1.428048 0.818894 0.929752 1.422804 -0.004686 1.681128 1.117926 0.396261 1.114085 1.263468 -0.302127 -0.143751 0.249776)
     7.986549 #r(0.000000 0.705159 -0.181004 0.217327 0.156922 1.778990 0.191147 1.113801 0.272034 1.171044 0.257920 1.334728 -0.188087 -0.096820 -0.018998 0.262759 0.954023 -0.039897 0.341389 1.444996 0.917955 1.089303 1.099624 1.600822 0.474003 1.078678 0.419361 -0.346529 0.769135 1.102121 0.462514 0.194004 1.393289 1.207814 0.168583 1.451937 1.578978 0.606330 1.663672 1.685805 -0.285434 1.500953 1.544223 1.459210 0.522782 0.144120 1.248342 0.284057 0.175310 0.542283 0.012495 1.586311 1.315843 1.018961 1.170529 -0.156886 0.147650 -0.231754 1.368201 0.537962 1.411226 1.416444 -0.114344 -0.050059 0.647067)
     
     7.936705 #r(0.000000 1.517428 0.111828 0.173226 0.840059 0.526041 1.411719 1.400612 -0.303887 0.230833 0.238673 -0.042085 0.173922 -0.488247 -0.875499 0.144489 1.065445 -0.071232 -0.251031 -0.143214 0.545256 1.307426 0.624098 1.604714 0.476813 0.403036 0.397383 -0.691500 1.462074 1.550083 0.768183 0.930280 0.458416 0.838168 0.784667 1.167295 -1.040754 0.791308 -0.864278 0.598538 -1.010391 1.656175 0.144524 -0.290241 0.441806 0.078668 -0.056179 -0.659905 1.071833 0.387457 0.707236 1.208921 0.879213 0.283834 1.382955 0.578802 -0.772961 -0.113529 0.594627 1.029134 1.703053 0.890258 0.476451 -1.188193 0.046657)
     7.935374 #r(0.000000 1.516508 0.110662 0.175958 0.836131 0.527757 1.411364 1.402933 -0.304009 0.233367 0.236759 -0.044789 0.175612 -0.486791 -0.877026 0.147806 1.067130 -0.071661 -0.249068 -0.143232 0.548582 1.308817 0.625581 1.605825 0.476254 0.402177 0.399931 -0.689265 1.463205 1.551126 0.770705 0.932593 0.459681 0.842986 0.780890 1.170908 -1.038140 0.797070 -0.861980 0.600440 -1.006688 1.655334 0.145026 -0.290652 0.442934 0.083346 -0.055655 -0.658549 1.077569 0.388346 0.715047 1.209914 0.883597 0.287116 1.384240 0.580259 -0.768209 -0.114151 0.598252 1.027948 1.705250 0.896332 0.480110 -1.183952 0.051204)
     )

;;; 66 all -------------------------------------------------------------------------------- ; 8.1240
(vector 66 10.208241079264 #r(0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 0 0)

	8.056638 #r(0.000000 1.161331 1.936583 0.473825 1.730430 1.710083 1.722704 0.938539 0.650961 -0.301116 0.711382 0.874289 0.712393 1.263523 0.315048 0.391659 1.059022 0.363325 1.881127 0.161704 0.986800 1.590034 -0.289492 0.615410 -0.014906 1.387045 1.412270 1.265945 0.128543 0.445787 0.121476 1.705959 1.084173 1.066949 0.774156 0.933891 1.279265 0.297308 0.298325 1.512363 0.271282 1.243162 1.580605 1.521644 0.312598 0.465014 1.006013 0.269153 1.083812 0.157700 1.646414 0.707835 0.598039 1.973506 0.954025 0.104991 0.944717 0.038847 0.538283 0.734911 0.143649 0.104089 0.567333 0.271330 0.665962 0.751070)

	;; 67-1
	8.015795 #r(0.000000 0.482185 1.174631 0.006809 0.401780 1.237554 1.609013 0.588930 1.364153 1.497911 0.479714 1.430977 0.382104 1.324174 0.126882 0.919708 -0.100361 0.979679 -0.154974 0.411044 1.431094 0.610463 0.047752 1.055827 0.418075 1.131057 0.351532 -0.093894 1.532471 1.157174 0.298591 -0.302172 1.190200 0.350212 -0.469230 1.440439 1.054072 0.838197 0.416628 0.293297 -0.104136 -0.061434 0.960707 0.489913 0.124304 0.770013 0.316144 0.728268 0.218632 -0.102007 0.074373 -0.213063 -0.207226 0.313323 0.277535 0.498637 0.514308 0.823833 0.726893 1.568923 -0.149485 0.343111 0.825139 1.056977 1.559384 -0.284248)
	8.011520 #r(0.000000 0.479799 1.169638 0.004612 0.402406 1.230765 1.595897 0.593685 1.374878 1.499275 0.489410 1.425320 0.373395 1.315599 0.138105 0.920155 -0.108520 0.991482 -0.149108 0.410130 1.436361 0.601706 0.046153 1.052899 0.424418 1.134897 0.348693 -0.098617 1.547368 1.151172 0.294748 -0.290030 1.189252 0.345030 -0.465760 1.441002 1.060075 0.832617 0.418488 0.293880 -0.106037 -0.059478 0.956595 0.497960 0.117059 0.767911 0.318840 0.717594 0.220912 -0.113412 0.081739 -0.211641 -0.217173 0.315598 0.272673 0.484197 0.526183 0.827437 0.728223 1.566384 -0.150430 0.337045 0.831304 1.069362 1.566148 -0.280307)
     )

;;; 67 all -------------------------------------------------------------------------------- ; 8.1853
(vector 67 10.422191619873 #r(0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 1)

     8.144904 #r(0.000000 0.836848 1.681555 1.191647 0.070261 0.942251 1.797644 1.070294 0.265921 1.462866 0.142770 0.004389 0.118755 0.795004 0.861059 0.364013 1.094070 0.938540 1.352932 1.681133 0.801557 -0.166830 1.660232 1.811404 -0.089491 1.793031 0.410641 1.462829 0.992048 -0.005221 0.624981 -0.049054 -0.100216 0.046599 -0.054149 1.061978 0.471687 -0.484886 1.299787 0.103592 0.873660 1.581185 1.539111 1.747106 0.867454 1.194479 0.984380 1.039016 -0.137566 1.440640 0.758746 0.623227 0.623868 1.161467 1.535042 0.328555 1.691644 -0.115223 0.929805 1.714954 0.103897 1.241682 1.520953 1.062392 0.666399 0.064868 1.788882)

     ;; pp:
     8.047705 #r(0.000000 0.723228 1.099176 -0.100694 0.795584 1.226000 1.797595 0.767514 1.189968 1.770414 0.592457 1.632373 0.568783 1.570965 0.191327 0.911400 -0.022316 0.899532 0.007665 0.667853 1.568194 0.721875 0.202951 1.285669 0.230444 1.429343 0.815993 0.012435 1.649015 1.193109 0.625662 -0.046776 1.588223 0.552563 -0.302890 1.679576 1.260813 0.930680 0.445604 0.348973 1.926722 0.133110 1.169041 0.703410 0.591692 0.750705 0.471868 0.931521 0.435714 0.165223 0.319019 0.050970 0.055362 0.598500 0.290706 1.016017 0.946745 1.221686 1.001124 1.567104 0.056814 0.422743 0.731562 1.013128 1.856895 1.850611 0.319558)
     8.043962 #r(0.000000 0.723361 1.098199 -0.104317 0.796240 1.226712 1.796964 0.767870 1.189764 1.772492 0.590978 1.631570 0.568976 1.570933 0.191811 0.911209 -0.021351 0.900745 0.009021 0.667781 1.566923 0.719770 0.205199 1.286787 0.231357 1.429685 0.816164 0.009201 1.644886 1.192474 0.623028 -0.047424 1.588652 0.551514 -0.304566 1.681018 1.259199 0.930654 0.444058 0.347527 1.926688 0.132038 1.165961 0.703045 0.587795 0.751154 0.472421 0.933684 0.438476 0.165192 0.320128 0.049852 0.054657 0.597137 0.289172 1.017612 0.945610 1.220099 1.001383 1.565341 0.058830 0.420956 0.733110 1.012036 1.857676 1.850677 0.317955)
     )

;;; 68 all -------------------------------------------------------------------------------- ; 8.2462
(vector 68 10.460547747753 #r(0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 0 1)

	8.168157 #r(0.000000 0.354978 1.878673 1.059221 0.759731 0.956747 0.711479 0.720163 0.372733 0.204844 0.455442 0.097446 1.506513 0.919884 0.814781 0.935488 0.786490 1.074073 1.203975 1.052443 0.726494 1.730845 0.062987 1.716136 1.412039 0.233751 0.090641 -0.003605 0.550389 0.691280 1.313887 0.137194 1.521036 1.556316 0.070039 0.198694 1.780701 0.986693 1.284403 1.408455 0.102332 1.273719 0.728671 0.008237 1.436719 1.092816 0.742660 1.480879 0.410157 1.288179 0.559234 1.425899 1.219179 0.189574 0.471285 1.159537 -0.028955 1.469388 0.210392 1.141156 -0.135055 0.687474 1.468060 -0.235268 0.553950 0.681055 0.986756 1.515599)

	;; 69-1
	8.131853 #r(0.000000 0.784104 1.233565 0.461379 1.122608 1.104526 0.722387 1.255939 1.344588 0.136431 0.691426 1.710711 0.131100 0.566340 0.865438 1.537496 0.878693 0.133465 0.855818 -0.432042 0.379762 0.876524 1.602175 1.021625 -0.093271 -0.210101 0.454316 0.002103 0.079420 0.100395 -0.098889 1.625973 -0.047062 1.737996 0.506589 1.792992 0.939323 -0.140724 1.456990 0.171514 0.906369 -0.130797 0.877514 0.626041 0.619243 -0.783477 0.176466 0.146820 -0.143043 1.354027 1.213392 -0.157870 -0.263919 0.335949 0.779235 0.639234 0.011670 1.687112 1.239883 0.625064 0.203838 -0.430763 -0.038392 -0.419755 0.708217 0.793274 0.717371 0.706499)
	8.131379 #r(0.000000 0.777086 1.225294 0.459335 1.120518 1.101510 0.718447 1.262945 1.346941 0.144684 0.695095 1.701131 0.123010 0.559466 0.867624 1.525977 0.858162 0.137330 0.853375 -0.428338 0.368918 0.875336 1.605285 1.009970 -0.095199 -0.219955 0.449222 0.000464 0.090789 0.090543 -0.094428 1.635821 -0.065302 1.739981 0.500960 1.791399 0.927017 -0.130394 1.444057 0.172796 0.901920 -0.118461 0.861131 0.631330 0.620706 -0.801290 0.162692 0.158567 -0.135443 1.344771 1.192462 -0.162338 -0.266366 0.328646 0.783136 0.650960 0.026458 1.672924 1.221292 0.618317 0.191901 -0.429128 -0.026945 -0.415707 0.709906 0.791929 0.708422 0.702801)
     )

;;; 69 all -------------------------------------------------------------------------------- ; 8.3066
(vector 69 10.495518383865 #r(0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0)

	8.197146 #r(0.000000 0.551719 0.168788 -0.171535 0.603472 1.646430 0.831219 -0.112901 1.600971 0.776706 -0.257580 1.457106 0.729936 0.539913 1.421843 0.548661 0.072361 0.728562 0.364648 -0.109430 1.359599 1.471812 0.472868 -0.088533 0.623026 0.167759 1.605110 0.053141 0.996253 1.258861 1.710199 1.079237 0.316774 0.568130 0.226861 -0.084943 1.702544 1.075688 0.298153 0.507109 1.291563 1.177929 1.707324 -0.001439 0.386332 0.512557 0.380487 0.243873 1.516865 0.101344 -0.768813 1.646072 0.275192 0.139649 1.389985 1.576705 0.346880 0.446918 1.441036 0.376743 1.075298 0.134005 0.942798 0.778785 1.014815 1.144279 1.213481 1.047075 1.249788)

	;; 70-1
	8.141488 #r(0.000000 0.574183 1.353612 0.374915 1.030848 1.242040 0.744144 1.258569 1.336700 0.191968 0.691270 1.721372 0.311349 0.667908 0.915341 1.702762 0.832541 0.057365 0.926883 -0.151411 0.409001 1.010518 1.740308 1.032309 0.081237 -0.217082 0.415212 -0.071661 0.155303 -0.089140 -0.060725 1.591797 -0.172680 1.694895 0.543894 1.693239 1.206424 -0.050239 1.924102 0.172957 0.976794 0.085955 0.708872 0.776705 0.648853 -0.409925 0.316385 0.431673 -0.080960 1.419047 1.273976 0.066194 -0.289390 0.572552 1.102567 0.973972 -0.045359 1.746990 1.335632 0.698963 0.200154 -0.171320 0.156816 -0.222154 0.877092 0.959484 0.814725 0.645169 0.000279)
	8.140284 #r(0.000000 0.574274 1.353235 0.374880 1.030900 1.241934 0.744056 1.258652 1.336888 0.191881 0.691290 1.721325 0.311221 0.667796 0.914975 1.702712 0.832796 0.057800 0.926778 -0.151752 0.409056 1.010584 1.740825 1.032269 0.081080 -0.217110 0.415261 -0.071717 0.155276 -0.088899 -0.060899 1.591545 -0.172297 1.695170 0.543998 1.693375 1.206363 -0.050497 1.924309 0.173097 0.976699 0.086114 0.708934 0.776887 0.648438 -0.409990 0.317299 0.431348 -0.080917 1.418905 1.274203 0.066144 -0.289260 0.572513 1.102504 0.974167 -0.045152 1.746839 1.335333 0.699271 0.200129 -0.170859 0.156721 -0.222333 0.876801 0.959324 0.814751 0.645600 0.000208)
     )

;;; 70 all -------------------------------------------------------------------------------- ; 8.3666
(vector 70 10.532930374146 #r(0 1 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0)

	8.176963 #r(0.000000 0.587989 1.431825 0.221285 0.960638 1.245837 0.795275 1.178692 1.324313 0.151685 0.789663 1.805305 0.407280 0.848410 1.089893 1.582619 0.871354 1.940142 1.022672 -0.098747 0.444755 1.081717 1.884930 1.020069 0.094475 0.162127 0.516048 0.043396 0.218952 -0.075886 0.177709 1.517609 -0.008561 1.566136 0.502844 1.768539 1.199988 0.053518 1.941460 0.082194 1.231659 0.182374 0.578473 0.843872 0.777996 -0.220205 0.467426 0.426401 0.154145 1.445497 1.004198 0.090981 -0.148632 0.673583 1.270739 1.002492 -0.085118 1.727335 1.374618 0.568333 0.205667 -0.017872 0.120962 -0.075966 0.957264 1.025234 0.841047 0.662525 -0.011036 1.297608)
     )

;;; 71 all -------------------------------------------------------------------------------- ; 8.4261
(vector 71 10.610488331633 #r(0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0)

	8.319609 #r(0.000000 0.140438 -0.156343 1.390907 0.216508 0.199081 1.047301 1.430567 0.016863 1.549577 0.363516 1.057536 -0.217538 0.646697 0.414461 0.993065 1.127770 0.877766 0.873392 0.440804 0.760841 0.449527 0.494946 1.105821 0.463488 1.200046 1.158237 0.977607 1.309426 0.772719 -0.483517 0.568526 0.817490 0.531524 0.272201 1.656272 -0.164981 0.659567 1.062868 -0.123485 1.015493 0.120132 0.671070 0.461022 1.766703 1.319785 0.775590 0.108288 0.757022 1.176333 1.486331 1.779348 -0.137633 1.540074 -0.041450 0.361903 1.057755 1.116867 0.573932 0.250328 1.480465 0.262890 0.893036 1.148682 1.046983 0.264942 1.618761 0.311598 1.395691 0.570219 0.159607)

	;; 70+1
	8.291682 #r(0.000000 0.876360 1.340339 0.367854 0.833412 1.105639 0.584245 1.188771 0.943418 0.250187 0.630698 -0.068665 0.279948 0.860334 0.732167 1.695945 0.897917 0.078292 1.045266 -0.333182 0.322926 1.637234 0.164051 1.142522 -0.007921 0.252497 0.780763 0.003414 -0.048763 0.073861 0.171499 1.284103 -0.089733 1.440877 -0.081573 1.527112 0.082712 -0.151289 0.255666 0.094915 1.149112 0.413227 0.691320 1.014965 0.789606 -0.102840 0.792525 0.145016 0.117221 1.222312 1.251613 -0.402327 -0.063091 0.826531 0.883896 0.465081 -0.032634 -0.408593 1.616507 0.441444 0.501925 0.126666 -0.391606 0.529294 1.070538 1.229843 1.052507 0.538182 0.119222 0.991880 0.323259)
	8.291337 #r(0.000000 0.876359 1.340283 0.367845 0.833375 1.105664 0.584271 1.188768 0.943451 0.250250 0.630656 -0.068635 0.279930 0.860317 0.732184 1.695932 0.897961 0.078310 1.045223 -0.333231 0.322957 1.637262 0.164086 1.142535 -0.007984 0.252507 0.780797 0.003458 -0.048747 0.073861 0.171483 1.284136 -0.089705 1.440806 -0.081590 1.527122 0.082721 -0.151244 0.255684 0.094848 1.149118 0.413274 0.691318 1.014955 0.789606 -0.102756 0.792501 0.144964 0.117187 1.222333 1.251710 -0.402265 -0.063046 0.826524 0.883969 0.465066 -0.032718 -0.408605 1.616554 0.441389 0.502001 0.126714 -0.391606 0.529285 1.070446 1.229824 1.052451 0.538215 0.119274 0.991866 0.323308)
     )

;;; 72 all -------------------------------------------------------------------------------- ; 8.4853
(vector 72 10.800657366855 #r(0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0)

     8.472893 #r(0.000000 -0.093428 0.860520 0.651650 0.036400 1.174208 -0.214755 0.653075 0.661176 1.355137 1.759893 1.116459 1.283776 0.222435 0.388195 1.541066 0.171819 0.911538 0.292609 1.508023 0.997352 1.385529 0.022962 0.061408 -0.061153 0.241196 0.345845 0.923448 0.626801 0.283115 0.129077 0.499608 0.703807 0.614285 0.908458 0.403245 1.817077 1.458947 0.221667 1.213107 1.163972 1.117128 0.465749 0.627880 0.010093 0.512887 0.278332 0.535697 1.736410 -0.297420 0.467311 1.419905 1.531806 0.300181 0.244309 1.719696 1.200428 1.778805 1.081039 0.613164 1.654092 1.161237 1.675808 0.051072 0.709895 1.432879 0.690303 1.567340 0.453011 1.156931 0.253055 -0.113821)

     ;; pp.scm:
     8.375884 #r(0.000000 0.704287 1.002073 1.665258 0.322937 1.455570 1.095676 0.019520 1.265776 0.283182 0.917991 1.741290 0.286595 0.909432 1.680753 0.853512 1.790234 0.580849 1.462104 0.390604 1.608631 0.491512 1.302107 0.855899 0.376743 0.878628 -0.166734 1.586900 0.799671 -0.063381 1.765431 0.627081 -0.164410 -0.007173 0.940347 0.645761 -0.294937 1.130494 1.024960 0.847385 -0.017840 -0.118371 1.360715 1.113073 0.529708 0.795901 0.574578 0.399736 -0.603738 0.201753 -0.310289 1.521464 1.779789 1.691203 1.658944 1.634184 1.099516 -0.336477 -0.077931 -0.045300 -0.292630 -0.240387 0.307058 0.437574 0.891669 1.282560 1.663663 -0.191286 -0.153149 0.842573 0.846091 1.564507)
     8.367751 #r(0.000000 0.645558 1.020824 1.674879 0.297321 1.478215 1.159425 0.013301 1.239885 0.350033 0.888999 1.831881 0.311808 0.919253 1.727115 0.871519 1.738071 0.513558 1.443664 0.420753 1.667825 0.484271 1.279276 0.823868 0.381782 0.911943 -0.096163 1.562504 0.828536 -0.144974 1.874517 0.768201 -0.125865 0.027788 0.992868 0.715728 -0.253408 1.108264 1.073157 0.786938 -0.002734 -0.154497 1.429041 1.081506 0.490310 0.770013 0.521515 0.288890 -0.695918 0.082180 -0.343666 1.544801 1.719927 1.637916 1.693329 1.678105 1.069958 -0.338832 -0.083132 -0.171885 -0.331886 -0.261796 0.380058 0.414290 0.757097 1.213104 1.511562 -0.172398 -0.158558 0.833537 0.819748 1.537843)

     ;; 73-1
     8.393433 #r(0.000000 -1.651316 0.301642 1.466674 0.575226 1.013593 0.593794 -0.111599 1.175040 -0.036844 0.640902 -0.496840 0.997861 0.882127 1.022937 -0.182002 1.272243 -0.123920 0.043991 1.030819 1.511195 1.158707 -0.310897 1.682674 0.196749 1.379163 0.680074 0.977267 1.032336 1.755391 0.420238 0.127288 -0.116036 1.422986 0.200070 0.221084 0.315906 0.920268 0.575823 0.602266 1.097544 0.016105 0.141377 -0.123217 -0.343006 -0.132707 -0.193667 1.477259 0.489569 1.413642 -0.024032 -0.207016 0.154750 0.997956 -0.351070 0.296357 1.115717 0.543150 0.264016 1.680397 1.236837 0.299616 -0.037861 0.721978 -0.322788 -0.300188 1.010597 0.394676 1.139314 -0.124559 -0.185844 1.210473)
     )

;;; 73 all -------------------------------------------------------------------------------- ; 8.5440
(vector 73 10.773231506348 #r(0 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1)

	8.384025 #r(0.000000 -1.759204 0.258773 1.490961 0.614632 1.064083 0.749896 -0.054942 1.188953 -0.082775 0.873036 -0.312376 1.062898 0.841428 1.045571 -0.065614 1.274975 -1.916910 0.276098 1.092748 1.503967 1.111596 -0.088316 1.884539 0.350921 1.500472 0.770480 1.064780 1.223070 1.884184 0.475186 0.211115 -0.005807 1.621787 0.302411 0.412290 0.527707 1.021672 0.701884 0.707746 1.214077 0.185530 0.223747 0.017949 -0.122008 -0.024415 -0.102678 1.672194 0.539296 1.640314 0.112358 -0.000335 0.417518 1.145914 1.923035 0.558680 1.387459 0.626065 0.470292 1.786608 1.415338 0.546162 0.422057 0.960620 1.843908 -0.193870 1.077382 0.539432 1.348518 0.161710 0.094632 1.427803 0.677105)

	8.371506 #r(0.000000 -1.867938 0.232496 1.586661 0.641992 0.928863 0.649348 -0.044198 1.085010 0.079229 0.862927 -0.237800 1.012094 0.965795 1.257653 -0.154609 1.363426 -0.126060 0.258325 1.241200 1.562391 1.221551 -0.017796 -0.046230 0.396012 1.553068 0.824411 1.145699 1.128785 -0.049237 0.673355 0.304031 -0.042615 1.642256 0.320764 0.567488 0.582997 1.177975 0.715492 0.736721 1.338915 0.369645 0.312354 0.097607 -0.086716 0.014634 0.001469 1.805330 0.848100 1.689101 -0.032587 0.024783 0.624333 1.292453 0.091180 0.653940 1.534562 0.693020 0.501144 0.009915 1.675154 0.697198 0.435218 1.219144 0.148845 0.005218 1.413815 0.712782 1.528783 0.213630 0.113661 1.648322 0.824916)
     )

;;; 74 all -------------------------------------------------------------------------------- ; 8.6023
(vector 74 10.684138298035 #r(0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1)

	8.497103 #r(0.000000 1.325782 0.182538 1.505234 0.945874 -0.041671 1.080868 0.605444 0.042184 0.866151 0.092779 0.735532 1.859565 0.020319 1.317206 0.107906 1.193633 1.487996 0.330731 0.601261 1.523499 -0.092194 -0.139866 0.997309 1.096776 -0.197191 1.061243 0.954641 0.070885 1.639404 0.509022 -0.561148 1.719565 1.632249 0.046116 -0.076359 1.376098 -0.015465 1.245129 0.220256 -0.000849 1.641349 1.603215 1.034336 0.812483 1.278349 1.510965 -0.515530 0.337854 1.060139 1.372801 0.633196 -0.113165 0.038608 0.288776 0.637200 0.027245 0.289307 1.083582 1.060936 0.972742 0.986362 -0.049682 0.384401 -0.025034 0.779020 0.227500 0.842052 1.419898 1.088862 -0.034683 -0.286302 1.416569 1.188508)

	8.468489 #r(0.000000 1.397351 0.199115 1.454114 1.031715 -0.176142 1.092851 0.462165 -0.016726 0.853430 -0.146725 0.811539 1.707371 -0.117500 1.407819 0.198961 1.078765 1.327293 0.331176 0.524536 1.478718 -0.063221 -0.112592 0.975553 1.167568 -0.244228 0.941673 1.029112 0.072643 1.555004 0.515688 -0.520416 1.848291 1.770668 -0.056909 0.037394 1.125814 -0.215204 1.309496 0.093237 -0.026125 1.523106 1.564912 1.107622 0.871096 1.093068 1.436174 -0.591776 -0.083622 0.913864 1.332465 0.538923 -0.091814 0.025942 0.246267 0.665145 0.061016 0.018831 1.154856 0.928981 0.707435 0.975317 -0.203276 0.390356 -0.015578 0.659407 0.326913 0.774677 1.281753 0.892058 0.125387 -0.275161 1.292193 1.029723)
     )

;;; 75 all -------------------------------------------------------------------------------- ; 8.6603
(vector 75 10.935811368418 #r(0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1)

	8.611733 #r(0.000000 1.755991 1.257704 1.380660 0.149810 0.888775 1.327127 0.155263 0.151577 1.307367 0.881185 1.244394 1.574597 0.297434 0.440838 1.532006 1.732873 0.955224 1.870085 1.039379 1.279345 1.370265 1.314175 1.228630 1.384735 1.656856 0.776266 0.604534 0.261984 1.021399 1.199829 0.578676 0.077339 1.180219 1.340992 0.303192 0.817942 1.840717 0.738716 0.586273 0.790045 1.068192 1.408743 0.034139 1.236420 0.200452 1.339574 1.564413 1.584603 1.696238 1.745531 0.073419 1.093015 0.201959 1.123150 0.434940 -0.158552 1.357895 0.030228 1.300705 0.831156 0.431680 0.205560 1.314167 1.822576 0.046350 0.064332 0.206633 1.539706 0.841946 1.061607 0.243862 0.776250 0.362661 1.442056)

	;; 74+1
	8.515318 #r(0.000000 1.389029 0.053243 1.526646 1.085943 -0.014266 1.021845 0.785533 0.105740 1.066202 0.109541 0.721402 1.481339 -0.062236 1.471506 0.193577 1.353902 1.400242 0.278679 0.324177 1.590186 -0.227902 -0.241771 0.976773 0.943703 -0.115168 1.214668 0.867933 0.090538 1.812393 0.551644 -0.544819 1.885995 1.482864 0.072438 -0.206638 1.277003 0.005949 1.175272 0.161211 -0.337581 1.706146 1.432946 0.961103 0.665555 1.251116 1.581164 -0.454588 0.421031 1.091995 1.387656 0.588011 0.099113 -0.117947 0.106565 0.807292 -0.158839 0.438389 0.959674 0.818415 0.684353 0.940338 0.056996 0.185598 0.120952 0.730169 0.579518 0.929526 1.498906 1.051412 -0.221875 -0.584880 1.336940 1.131418 0.326487)
	8.512424 #r(0.000000 1.411165 0.066815 1.545993 0.946095 -0.013826 1.044201 0.645921 0.167534 0.936997 0.015362 0.752008 1.506866 -0.158860 1.516968 0.188211 1.320449 1.416434 0.301211 0.249914 1.630679 -0.182057 -0.250234 1.010984 0.856089 -0.194871 1.267794 0.818904 0.026503 1.685044 0.447764 -0.570160 1.818021 1.556283 0.065474 -0.160812 1.254420 0.015713 1.097954 0.076322 -0.329350 1.595682 1.328596 0.970473 0.523251 1.172474 1.547586 -0.576799 0.315720 1.005997 1.384889 0.446334 0.034057 -0.043520 0.102641 0.907794 -0.217100 0.330956 0.799047 0.751974 0.718734 0.830887 -0.040874 0.108169 -0.077398 0.706941 0.367992 0.821591 1.448143 1.030496 -0.359435 -0.609102 1.208112 1.153589 0.207741)
     )

;;; 76 all -------------------------------------------------------------------------------- ; 8.7178
(vector 76 10.689208030701 #r(0 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0)

	8.622898 #r(0.000000 0.389242 -0.170662 1.421644 1.248164 0.164000 0.718605 1.792721 0.677210 1.518595 0.963267 -0.186472 1.263794 1.595425 0.383743 0.443182 1.535243 0.669172 1.194047 0.802827 1.746269 0.569800 1.408025 1.796723 1.258639 0.620093 0.886554 0.863256 0.711462 1.456391 -0.186271 0.639923 1.414383 -0.059653 0.858601 0.618312 0.847274 0.301714 0.319909 0.359052 0.817062 -0.212571 0.558016 0.169995 1.152558 0.886044 1.332154 0.013242 0.369659 -0.032997 1.710630 1.029547 0.363359 -0.095703 0.197840 0.264645 1.078918 0.774045 1.172991 1.082380 0.650868 1.140749 0.194089 0.747056 0.734148 0.248352 1.094670 0.793873 -0.197763 1.665030 0.915389 0.675623 1.504323 1.585265 1.586133 1.087431)

	8.574100 #r(0.000000 0.381067 -0.272442 1.488465 1.142707 0.360320 0.746704 1.847055 0.740548 1.508045 0.951781 -0.163260 1.230184 1.623769 0.378228 0.442543 1.444666 0.627164 1.121499 0.747522 1.711575 0.455052 1.521242 1.941174 1.200574 0.592945 0.847791 0.979331 0.775371 1.568106 -0.195026 0.565512 1.483676 -0.004045 0.884949 0.722398 0.759194 0.390231 0.390425 0.259838 0.870917 -0.376787 0.551015 0.111447 1.304287 0.854661 1.506961 -0.032845 0.351362 0.031608 1.942972 1.061692 0.389298 -0.107628 -0.038521 0.239436 1.098754 0.925984 1.312533 1.079671 0.638668 1.047785 0.324774 0.836243 0.863976 0.266976 1.127471 0.871925 -0.192469 1.644992 0.941790 0.676374 1.373040 1.680505 1.659912 0.999514)
	8.566643 #r(0.000000 0.381106 -0.266391 1.483482 1.132005 0.371120 0.752013 1.832292 0.729074 1.486332 1.011195 -0.165598 1.221917 1.641575 0.360666 0.433077 1.404878 0.604388 1.104926 0.729165 1.669029 0.450931 1.499767 -0.080683 1.221002 0.625260 0.828962 0.972153 0.755738 1.545260 -0.154840 0.581108 1.513378 0.013021 0.891683 0.702677 0.747453 0.397193 0.417760 0.289893 0.885881 -0.366958 0.566657 0.149934 1.332346 0.845232 1.552276 -0.056636 0.409890 0.036503 -0.043099 1.055520 0.429840 -0.126953 0.004032 0.241993 1.122772 0.921410 1.349658 1.081742 0.615932 1.026733 0.322881 0.803706 0.857043 0.333651 1.097387 0.873399 -0.168242 1.662747 0.934611 0.695385 1.391924 1.697835 1.605684 0.993676)
     )

;;; 77 all -------------------------------------------------------------------------------- ; 8.7750
(vector 77 11.114716461811 #r(0 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0)

	8.693626 #r(0.000000 0.342470 0.518102 0.602103 1.407511 1.793531 0.096346 0.250378 0.943784 0.388159 0.656038 0.296223 1.141950 0.214103 0.212479 0.828756 1.402312 1.692057 0.511954 0.158583 -0.254149 0.373835 0.095344 -0.147316 0.784069 0.081610 -0.056393 0.798330 0.705534 1.696239 0.742515 1.236436 -0.107133 1.590407 0.658892 -0.033009 -0.161883 1.612218 1.476439 0.692575 -0.060023 1.224517 0.875204 0.501273 0.494798 0.327706 1.600469 0.607079 0.567961 0.917115 0.716199 1.138396 0.731691 -0.084350 0.371809 0.181536 0.739186 1.478965 0.762792 0.759384 1.499056 1.662862 1.474568 1.752637 0.981158 1.382311 0.543578 -0.609814 1.825975 0.848970 1.045950 0.310451 0.519502 0.003348 1.354017 -0.105098 1.298274)

	8.657403 #r(0.000000 0.144503 0.521174 0.518787 1.193244 1.814457 -0.020944 0.363643 0.853723 0.860530 0.580514 0.078066 1.010161 0.221441 0.183044 0.759859 1.545184 -0.010635 0.635858 0.285802 -0.330206 0.372074 0.148651 -0.307361 0.733497 -0.192823 -0.013078 0.625648 0.850253 1.811781 0.605791 1.229804 0.065972 1.468728 0.623063 -0.230764 -0.019445 1.531051 1.297899 0.768834 -0.081130 1.071894 0.927752 0.511168 0.237065 0.316832 -0.004891 0.571763 0.647286 1.228392 0.493001 1.368827 0.671571 -0.234110 0.332624 0.387950 0.822479 1.176496 1.091221 0.738538 1.432063 1.421456 1.054724 -0.269734 0.700009 1.401715 0.397450 -0.246031 -0.115146 0.640052 0.961541 0.375597 0.318506 -0.237690 1.548563 -0.512722 1.445228)
	8.655850 #r(0.000000 0.144015 0.521787 0.519011 1.193985 1.813929 -0.020721 0.363063 0.853642 0.859887 0.580896 0.078449 1.009266 0.221508 0.182992 0.759898 1.544517 -0.010376 0.635651 0.285693 -0.330723 0.371939 0.149327 -0.307594 0.733085 -0.192814 -0.013453 0.625868 0.850147 1.811263 0.605103 1.230124 0.065834 1.468308 0.622956 -0.230654 -0.019787 1.531322 1.297364 0.769617 -0.081404 1.071828 0.928156 0.511154 0.237021 0.316908 -0.004413 0.571845 0.646678 1.228590 0.492699 1.369241 0.672452 -0.233665 0.332431 0.388115 0.821896 1.176234 1.091315 0.738910 1.432114 1.421319 1.054889 -0.269641 0.700596 1.402150 0.397349 -0.245474 -0.116062 0.640946 0.961580 0.375676 0.318553 -0.237609 1.548434 -0.512459 1.445327)
     )

;;; 78 all -------------------------------------------------------------------------------- ; 8.8318
(vector 78 11.471938943963 #r(0 1 1 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1)

	8.721647 #r(0.000000 1.249128 1.236819 0.086271 0.084870 1.618123 0.329492 1.828009 1.561909 0.021559 1.381905 1.787354 1.267428 0.679445 0.317703 1.068186 0.771332 1.720040 0.579492 0.551164 0.773425 1.834796 0.776430 1.432091 0.890602 0.586016 1.596666 0.290630 1.219329 1.491675 0.728639 1.708194 1.560487 1.434303 1.462488 0.635070 1.113941 1.563335 1.460331 0.701917 0.605822 1.400388 -0.075938 0.671582 0.475347 1.301044 1.799871 0.995216 1.609922 0.401184 0.764542 1.290171 0.978260 1.880400 0.986160 0.147021 0.340498 0.060183 -0.194639 1.442758 -0.089614 1.632445 0.465746 0.262863 0.032668 -0.154147 0.169869 0.985285 0.862469 0.985943 1.417781 1.577680 0.168817 -0.243252 1.808701 0.241312 1.826852 1.010182)
	8.713157 #r(0.000000 1.185175 1.397998 0.029507 -0.003150 1.681558 0.352287 -0.142980 1.503432 -0.031653 1.606742 1.761627 1.241378 0.692257 0.198504 1.080125 0.928512 1.682058 0.474050 0.647248 0.825797 1.866311 0.823439 1.412665 0.855734 0.627072 1.762849 0.273347 1.224795 1.527402 0.799841 1.826401 1.613076 1.464329 1.459644 0.659045 1.125726 1.685514 1.459290 0.692583 0.629938 1.416569 -0.101579 0.653448 0.364955 1.272692 1.662367 1.045389 1.620168 0.458585 0.835933 1.249466 0.947077 -0.133359 1.014573 0.250790 0.421139 -0.005825 -0.027874 1.307059 0.066093 1.637593 0.497687 0.345017 0.115925 -0.006858 0.311739 1.192497 0.790849 1.021741 1.387921 1.598464 0.189632 -0.083007 1.800753 0.182932 -0.105722 0.993536)
     )

;;; 79 all -------------------------------------------------------------------------------- ; 8.8882
(vector 79 11.334476470947 #r(0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 1 1 0 0 0 0 0 1 0)

     8.845367 #r(0.000000 1.238318 1.165090 1.291700 0.803595 0.614248 1.388497 1.905092 0.146964 0.775475 0.093294 -0.057178 0.069260 0.967289 0.726888 1.927694 0.404014 -0.050125 1.170622 0.795731 0.415661 0.113117 0.949983 0.547877 0.937155 0.147536 1.182414 0.680260 0.043365 0.406697 0.191985 0.520170 0.649818 0.646884 0.567272 1.384599 1.089945 0.420022 1.776381 1.388186 1.481564 0.061642 1.806781 0.638535 0.038366 1.606509 1.826388 1.366478 1.328019 0.480776 1.683074 0.476259 0.537766 1.179629 1.609320 1.234604 0.090600 0.429089 1.028733 0.835166 0.689618 1.227466 0.068475 0.130750 1.461448 1.601183 1.627224 0.857096 1.862391 0.455364 1.260302 0.135047 1.550455 0.219288 0.922341 0.004761 0.651583 1.409352 1.642849)

     ;; pp:
     8.777582 #r(0.000000 0.850012 1.278466 1.671652 0.485604 1.428681 1.798079 0.243483 0.926746 1.779185 0.395714 1.026729 -0.089658 1.070596 1.891094 0.483045 1.500429 0.189865 1.099066 0.205077 0.960527 0.060100 1.107914 0.183231 1.450310 0.468483 1.446982 0.685162 -0.081146 1.099289 0.484068 -0.117908 1.374114 0.639742 1.715595 0.816256 0.293012 1.668108 1.425294 0.747308 0.296172 1.780496 1.411915 0.770108 0.585162 0.343644 1.740454 0.115329 1.259755 1.673967 0.856085 0.577614 0.383167 0.304410 -0.049803 0.056826 -0.212368 1.721031 0.015177 1.660724 1.618929 1.612917 1.203620 1.624606 1.770412 0.046014 0.166329 0.333277 0.356575 0.671429 0.926511 1.256476 -0.022764 0.419017 0.748312 1.255568 1.486031 1.553904 0.445544)
     8.767436 #r(0.000000 0.718403 1.251314 1.486434 0.417739 1.537028 1.781280 0.371804 0.856023 1.697105 0.410324 1.015131 -0.119095 1.081250 -0.157946 0.436892 1.552209 0.310681 1.199628 0.374846 0.988915 0.054273 1.300951 0.365816 1.604177 0.398188 1.427075 0.723659 0.021475 1.135277 0.715183 -0.075549 1.555657 0.584681 1.776086 0.831855 0.296030 1.723871 1.434840 0.893843 0.399844 1.754534 1.625700 0.603594 0.563673 0.311786 1.758993 0.014755 1.458293 1.648023 0.983651 0.560806 0.171502 0.278061 0.103727 -0.090556 -0.256311 1.589447 0.057298 1.706317 1.625686 1.735520 1.218723 1.651189 1.784299 0.256509 0.287738 0.688962 0.644695 0.791051 0.753121 1.204382 -0.074638 0.485008 0.749887 1.461595 1.411150 1.659818 0.509864)
     )

;;; 80 all -------------------------------------------------------------------------------- ; 8.9443
(vector 80 11.30185508728 #r(0 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0)

	8.831605 #r(0.000000 0.718457 0.752874 0.707265 1.105140 1.556866 1.675971 1.743288 1.737050 1.402684 0.726424 0.001544 0.787560 0.610707 0.221912 0.548490 1.255462 0.532840 1.735795 1.159475 0.139393 0.566082 0.477708 1.186070 0.213588 1.697938 1.877210 -0.027617 0.446036 -0.097653 1.420626 0.288659 1.413894 1.358919 0.713009 -0.285435 0.875204 0.375292 0.708148 0.907015 0.596415 1.676708 -0.002236 0.617188 -0.254880 0.679354 1.396570 0.024604 0.491384 1.191175 0.583286 0.255907 0.583959 0.646881 1.743044 0.166682 0.513542 1.079013 0.694687 0.379588 0.528146 0.707196 1.408903 1.510794 1.151055 0.672700 0.297721 -0.154036 1.059849 1.480109 0.687072 0.133333 1.264870 -0.326181 0.342810 1.875130 1.918140 1.634313 0.782341 -0.170226)

	;; 81 - 1
	8.853012 #r(0.000000 0.713664 0.751521 0.448581 1.078712 1.434332 -0.106130 1.560883 1.450760 1.498278 0.937332 -0.045737 0.468326 0.366103 0.320014 0.581407 1.184615 0.699951 1.696540 1.157496 0.135085 0.626551 0.420080 1.134483 0.350026 1.714983 1.594968 0.442820 0.488286 -0.156674 1.134813 0.168151 1.216425 0.905956 0.520243 -0.142318 0.437369 0.180759 0.624230 0.569840 0.172595 1.321073 -0.234574 0.786368 -0.490064 0.447127 1.640821 -0.178464 0.308828 0.997718 0.822718 -0.196077 0.281017 0.757467 1.401582 0.240219 0.552190 0.865559 0.311162 0.036903 0.553601 0.299180 1.009477 1.109391 0.804156 0.557491 0.291292 -0.278325 0.995535 -0.048564 0.514170 -0.227699 1.019707 -0.548622 -0.162405 1.658786 1.315882 1.435095 0.750976 -0.261917)
	;; stopped due to heat wave
     )

;;; 81 all -------------------------------------------------------------------------------- ; 9
(vector 81 11.22668050284 #r(0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1)

     8.961491 #r(0.000000 0.634711 0.914288 0.369120 0.489315 1.342522 0.647705 1.766421 1.148272 1.455934 0.450010 0.224566 1.110702 0.040996 1.346853 1.773154 1.255402 0.752437 1.110884 0.031625 1.597766 0.103816 1.912905 -0.011027 0.863686 0.820253 1.302167 1.352505 1.039370 0.116915 0.947518 1.168519 0.272351 1.514646 1.808891 0.551022 1.359986 0.703545 0.651408 1.697573 1.001093 1.819478 -0.153070 -0.020542 0.748602 1.669047 0.373021 0.491577 0.705265 0.740848 -0.189697 0.502215 0.348836 0.005306 -0.207198 0.930183 -0.631614 1.639932 1.773044 1.357496 1.130593 0.312825 1.896666 0.201668 1.169961 0.899991 0.382267 -0.065252 0.308097 0.095309 1.059630 -0.075945 1.147344 0.303812 -0.113244 -0.220507 0.240152 1.567520 0.130729 0.128142 -0.134246)

     ;; 80+1
     8.798551 #r(0.000000 0.591095 0.766372 0.489633 0.892830 1.470880 0.024266 1.553545 1.397381 1.549957 0.961480 0.030745 0.350509 0.480664 0.324535 0.532859 1.178437 0.600433 1.721653 1.190766 0.203234 0.634172 0.473637 1.167212 0.251931 1.758060 1.536282 0.415486 0.566371 -0.279352 1.143985 0.080086 1.312189 0.802180 0.476214 -0.170351 0.392370 0.054114 0.648162 0.604589 0.159911 1.129280 -0.198924 0.772307 -0.404913 0.496844 1.664189 -0.222495 0.397365 0.945586 0.907997 -0.249926 0.105251 0.650639 1.266007 0.197774 0.522775 0.879085 0.342046 0.049647 0.501455 0.132186 0.903401 1.133013 0.925314 0.555954 0.264446 -0.269660 0.922009 -0.001103 0.579617 -0.224098 1.014084 -0.530017 -0.206754 1.601599 1.281427 1.317681 0.768845 -0.280697 -0.570842)
     8.797329 #r(0.000000 0.593378 0.769030 0.482050 0.894789 1.469434 0.017291 1.548640 1.399875 1.547111 0.960600 0.029476 0.347173 0.479328 0.324764 0.535557 1.181648 0.603853 1.724567 1.184427 0.201520 0.621022 0.466053 1.172410 0.257155 1.744523 1.537620 0.413349 0.571480 -0.275441 1.147662 0.078171 1.318337 0.797128 0.465604 -0.167976 0.389127 0.046196 0.644876 0.600407 0.146824 1.140648 -0.196543 0.766952 -0.405128 0.495879 1.671836 -0.221864 0.393766 0.946119 0.917743 -0.256291 0.111525 0.645632 1.265055 0.181069 0.525294 0.880675 0.348447 0.049079 0.495123 0.135981 0.911089 1.141680 0.914015 0.556460 0.266976 -0.250402 0.919302 -0.007489 0.586097 -0.221631 1.012419 -0.545708 -0.213348 1.601484 1.279462 1.306339 0.757689 -0.274675 -0.570934)
     )

;;; 82 all -------------------------------------------------------------------------------- ; 9.0554
(vector 82 11.601468306037 #r(0 0 0 1 0 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0)

     9.074372 #r(0.000000 1.648602 0.113059 0.965847 0.614379 1.876939 0.598065 0.033495 1.128904 0.535962 0.404933 0.340847 -0.287176 1.664997 0.944124 0.484563 1.365390 -0.175780 1.135023 1.030858 0.610885 1.630994 0.348969 1.892603 0.337558 0.278067 1.048537 1.676406 0.392409 0.207975 0.887089 1.313518 1.800663 1.007393 0.181812 -0.074478 0.144619 1.511865 1.173214 0.664191 1.387698 1.632837 0.132108 0.353188 0.227412 1.024174 1.607289 0.662392 -0.023377 -0.428601 1.063517 1.407784 1.563623 0.788150 1.561202 0.023129 0.361493 1.608137 1.816713 0.962416 0.274252 0.900687 0.860331 0.458473 0.118859 0.572111 0.805640 1.846370 0.649018 0.713232 0.291663 -1.866918 0.486252 0.300849 0.355338 1.356604 0.996671 0.882787 1.511703 1.110696 1.774461 0.441695)

     ;; 81+1
     8.851350 #r(0.000000 0.560616 1.028384 0.602446 0.918314 1.370584 0.032799 1.596301 1.697405 1.496371 0.996676 0.029713 0.420383 0.826586 0.248203 0.575317 1.241662 0.486923 -0.146886 1.026281 0.207970 1.026508 0.554521 1.233144 0.124979 1.629837 1.740416 0.133168 0.934365 -0.707656 0.913598 0.062338 0.910383 1.041029 0.285851 -0.273453 0.668898 0.057418 0.546969 0.703739 0.642923 0.958752 -0.195671 0.682461 -0.471844 0.445399 1.669461 -0.200437 0.550525 0.885547 1.105654 -0.043073 0.307985 0.716590 1.018538 0.595943 0.488507 0.208799 0.077662 0.185943 0.759192 0.106129 0.934593 1.168071 1.038861 0.631960 0.173275 -0.022867 1.092552 -0.449400 0.726450 -0.020524 1.292546 -0.564480 -0.067237 1.491273 1.275468 1.239648 0.821121 -0.291412 -0.449925 0.390998)
     8.850182 #r(0.000000 0.518773 1.039139 0.586918 0.904434 1.417193 0.042683 1.631265 1.694438 1.514894 1.006690 0.003709 0.408784 0.798813 0.249575 0.591222 1.196003 0.490671 -0.162585 1.056459 0.214130 1.070048 0.595570 1.158267 0.152005 1.596646 1.763293 0.137802 1.031270 -0.729765 0.896998 0.017768 0.865646 1.014949 0.251509 -0.314516 0.635325 0.026002 0.490859 0.633543 0.639061 0.944000 -0.171048 0.686904 -0.554012 0.426662 1.660372 -0.276772 0.454353 0.868574 1.080144 0.004571 0.280163 0.786197 1.030805 0.611760 0.535564 0.235350 0.034299 0.186337 0.685227 0.115463 0.933270 1.148318 1.130052 0.634287 0.165289 -0.005574 1.017789 -0.425130 0.702068 -0.051211 1.238786 -0.554979 -0.075667 1.531212 1.295287 1.210341 0.841758 -0.323173 -0.539445 0.363396)
     )

;;; 83 all -------------------------------------------------------------------------------- ; 9.1104
(vector 83 11.429935034332 #r(0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0)

	8.938600 #r(0.000000 0.414028 0.125789 1.159865 0.086238 0.817482 0.340516 1.199339 -0.170286 1.744945 1.587696 1.158800 1.281058 0.190384 1.473320 0.235428 1.621261 0.225261 1.644931 -0.137023 1.525995 0.691219 0.557902 1.528647 -0.234276 -0.009740 0.044217 0.592778 0.909815 0.773874 0.836299 0.726340 0.981312 0.618405 0.408288 0.150201 0.908250 0.109103 0.413166 0.847395 0.541585 1.672450 1.474939 0.635397 0.153870 -0.014899 1.455728 0.983819 0.181154 0.726107 0.638924 1.106663 0.611788 0.238433 0.670956 1.522770 1.842401 0.939513 -0.051810 1.267322 0.323759 1.831419 1.004026 -0.159128 0.287041 0.349723 0.402841 0.045990 0.570998 1.374651 1.603295 0.760887 1.460939 -0.002747 0.693326 1.517648 0.987805 0.554027 0.029827 0.036863 0.188640 0.849464 1.347102)
	8.936213 #r(0.000000 0.408201 0.126040 1.158014 0.083410 0.822392 0.340155 1.194042 -0.172082 1.748578 1.586610 1.161056 1.277534 0.186364 1.476999 0.235823 1.627756 0.227972 1.641505 -0.140011 1.528346 0.692010 0.553694 1.528749 -0.231846 -0.009008 0.040533 0.588403 0.914079 0.778413 0.831073 0.723278 0.978128 0.624349 0.400433 0.146060 0.911725 0.111205 0.414216 0.850529 0.541662 1.663794 1.477328 0.641317 0.149613 -0.013692 1.454096 0.985241 0.185917 0.730787 0.637733 1.097840 0.604584 0.240638 0.678667 1.522252 1.845745 0.944051 -0.047786 1.256053 0.323123 1.836166 1.002122 -0.154558 0.287277 0.348279 0.400131 0.048348 0.573133 1.378950 1.603761 0.771384 1.465373 0.014397 0.693518 1.523180 0.987688 0.553385 0.023434 0.030358 0.189016 0.850384 1.349789)
	8.934963 #r(0.000000 0.388833 0.119269 1.159396 0.084041 0.831926 0.332635 1.176250 -0.176695 1.764815 1.577336 1.167712 1.277058 0.180565 1.483279 0.244455 1.639842 0.231019 1.628465 -0.143232 1.536821 0.704938 0.552153 1.530466 -0.224513 0.010496 0.034106 0.576377 0.939875 0.785468 0.829993 0.715502 0.968124 0.640032 0.396582 0.150458 0.935168 0.123648 0.408167 0.864017 0.545634 1.640474 1.473610 0.636166 0.133436 -0.003429 1.440429 0.982288 0.212836 0.743361 0.639874 1.101557 0.617385 0.271411 0.703361 1.525115 1.857795 0.954785 -0.022712 1.232732 0.327660 1.853705 1.028391 -0.134471 0.306948 0.357972 0.408006 0.063155 0.593195 1.406229 1.598252 0.790489 1.494874 0.055118 0.707198 1.527620 0.974145 0.561751 0.009624 0.051221 0.195975 0.865753 1.371065)
     )

;;; 84 all -------------------------------------------------------------------------------- ; 9.1652
(vector 84 11.774056434631 #r(0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1)

	9.023210 #r(0.000000 0.159304 -0.208530 0.193874 1.193993 0.513874 0.193906 1.420202 1.601162 0.069662 0.596870 0.499106 1.879705 1.298791 1.380896 1.011752 1.567079 1.088823 0.586749 1.189212 0.187019 0.623891 0.443258 1.756821 0.221910 -0.166048 1.505325 1.956699 0.145006 0.858253 1.259810 1.292214 -0.292005 0.449812 -0.218977 -0.354252 1.219999 0.997645 1.646540 1.482430 0.239288 -0.155628 0.755326 1.705293 0.967714 0.360450 0.143064 1.152089 0.481087 0.972815 0.614833 1.330922 0.788019 0.726428 0.572863 1.454284 1.031818 0.764416 0.692179 1.019395 0.005944 0.083543 1.745841 0.713648 0.857380 1.260681 1.338561 0.608841 1.025699 1.518383 0.107569 1.492751 -0.040716 0.923284 0.288212 0.772164 -0.210851 0.728511 0.794985 1.593926 1.082153 1.208449 1.606070 0.581831)
     )

;;; 85 all -------------------------------------------------------------------------------- ; 9.2195
(vector 85 11.927130699158 #r(0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 1 1 0 1)

	9.127702 #r(0.000000 0.377539 0.047529 1.429700 0.417181 1.140688 0.738197 -0.138709 -0.448043 0.627123 1.392127 1.819604 0.611302 1.321770 0.758910 1.628764 1.577483 0.372253 0.761090 0.479480 0.236979 1.110344 0.805106 1.644437 0.008357 0.656171 0.991297 -0.054354 1.739257 1.797129 1.125137 0.066677 1.422676 0.455091 0.389601 0.812550 0.569451 1.358336 1.535806 0.395945 0.917012 1.261389 0.975555 0.676523 1.340562 0.262979 0.348691 0.300647 1.560755 0.036844 0.912709 1.718241 0.914499 1.035722 0.712055 1.556119 1.328161 1.240892 0.216373 0.897089 0.626805 0.862584 0.585791 1.306757 0.828290 1.426360 0.918009 1.215542 0.443071 1.531104 1.274055 0.636447 0.998872 0.647434 1.352131 -0.267987 0.709420 0.317461 -0.001614 0.037126 -0.160098 1.679742 0.637515 0.582751 0.080874)

	;; 84+1
	9.178091 #r(0.000000 0.092570 -0.328688 0.101879 1.164231 0.484791 0.263025 1.451681 1.371169 0.108316 0.583377 0.421708 0.063889 1.308369 1.554699 0.834440 1.382249 1.018775 0.556330 1.227389 0.358177 0.557221 0.316807 0.026851 0.347091 -0.193100 1.503856 1.682820 0.057602 0.906412 1.391283 1.172258 -0.306686 0.435069 -0.568978 -0.558083 1.240277 0.880388 1.809028 1.648747 0.142044 -0.051135 0.843030 1.589081 1.068210 0.522719 0.218341 1.007282 0.577304 0.998448 0.637448 1.458645 0.805087 0.732402 0.662530 1.436936 1.230072 0.780536 0.678657 1.336068 0.047814 0.297831 1.418569 0.786054 0.797109 1.410904 1.430707 0.466713 0.866817 1.332398 -0.186495 1.178146 -0.048740 1.088830 0.300282 0.620896 -0.201097 0.818687 0.773330 1.535207 1.274976 1.303891 1.667213 0.674931 -0.125079)

	;; 86-1
	9.051726 #r(0.000000 0.572406 1.179943 1.764356 0.253870 0.884356 1.651423 -0.098959 0.541959 1.442287 0.010669 0.741083 1.566729 0.635556 1.249696 -0.254695 0.981029 0.111846 1.237031 0.192536 0.720833 1.204618 0.449694 1.251669 0.627009 1.783356 0.920605 0.035741 0.509227 0.126246 1.562523 0.722635 -0.062975 0.946054 0.007605 -0.013358 1.547325 0.495733 1.888355 1.370030 0.430619 1.521378 1.364477 0.899348 0.311412 1.655627 1.393415 1.043374 0.693073 -0.261616 1.347717 1.190412 0.844199 0.765353 0.699908 0.229316 0.525856 -0.265344 1.545983 1.312840 1.172844 1.057530 0.916299 1.790793 0.869579 1.211374 0.681340 1.001931 0.654601 1.101973 1.110746 1.767977 1.334109 1.636297 -0.247626 -0.168731 0.099708 0.647019 1.050047 1.539415 0.008050 0.095956 0.583789 1.020757 1.124846)
	9.049902 #r(0.000000 0.563123 1.178518 1.758860 0.262272 0.883025 1.653154 -0.112442 0.544375 1.449563 0.003632 0.735232 1.565378 0.629399 1.249832 -0.245154 0.975371 0.104021 1.230308 0.204936 0.728896 1.200090 0.453859 1.254730 0.634907 1.785857 0.910526 0.028528 0.512985 0.118173 1.563688 0.727580 -0.060681 0.935698 0.002572 -0.009819 1.543537 0.502740 1.889883 1.378460 0.440088 1.520721 1.385983 0.911951 0.319540 1.661394 1.403090 1.043647 0.698513 -0.258428 1.361759 1.190670 0.827100 0.772203 0.674858 0.223364 0.526333 -0.284078 1.542639 1.309275 1.167224 1.067830 0.912739 1.795861 0.867588 1.204585 0.683869 0.992895 0.650909 1.108031 1.113927 1.766016 1.326795 1.627701 -0.242386 -0.176337 0.105000 0.657052 1.065424 1.542526 0.021830 0.089779 0.582222 1.031000 1.120243)
     )

;;; 86 all -------------------------------------------------------------------------------- ; 9.27362
(vector 86 11.780031204224 #r(0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0)

	9.206953 #r(0.000000 -0.339088 0.933342 -0.128298 1.099279 0.084536 0.851599 -0.014992 1.465425 1.307317 0.418122 0.289943 1.668778 0.506500 1.696171 1.171193 0.792416 0.989400 0.972892 1.055909 1.790099 1.474165 1.862965 1.486120 1.916599 0.452792 1.686062 0.595804 0.951171 -0.158372 0.842834 1.045604 0.896962 0.721188 0.145646 1.627929 1.192540 1.524829 0.808536 1.173303 0.835497 0.870602 1.525244 1.506688 0.379810 0.397104 0.800652 0.803279 1.193873 1.751911 0.273257 0.582749 0.328287 1.542626 0.758388 0.690207 1.020504 0.688526 -0.031652 0.949811 0.197494 0.391786 1.605605 0.223632 0.906957 1.312801 1.428402 0.597149 1.497710 -0.659689 1.704635 0.962819 1.427359 1.450510 1.282944 1.167035 0.635413 0.328489 1.735204 0.771081 1.542497 0.207128 0.104268 1.136822 -0.363620 0.034704)

	;; 87-1
	9.145844 #r(0.000000 0.566683 1.107648 1.906025 0.221947 0.832929 1.646883 0.003598 0.594983 1.443215 0.059329 0.776514 1.650354 0.526476 1.163785 -0.073477 1.002422 -0.002389 1.070033 0.044031 0.784449 1.327277 0.487633 1.314288 0.580998 1.768047 0.897468 -0.079923 0.817793 0.129615 1.548420 0.755157 0.047436 0.933698 0.072836 1.838297 1.394453 0.409694 1.883124 1.411951 0.367286 1.559580 1.347795 0.901907 0.261118 1.614248 1.386396 1.030092 0.495139 -0.244679 1.429057 1.095949 0.954289 0.796818 0.700395 0.130060 0.311501 -0.283703 1.698927 1.200401 1.111917 0.896911 0.863583 1.501476 0.795659 1.065652 0.706914 0.954080 0.738520 1.047306 1.097502 1.582249 1.456216 1.733897 -0.138892 -0.037173 0.099865 0.586472 1.000632 1.405077 0.060430 -0.004754 0.633209 1.032431 1.436909 1.788117)
	9.144898 #r(0.000000 0.553220 1.114143 1.907542 0.232990 0.842372 1.638290 0.002415 0.600151 1.441766 0.072607 0.770701 1.630141 0.524050 1.166300 -0.060704 0.988063 -0.011935 1.056235 0.044313 0.796954 1.351344 0.491264 1.317927 0.594365 1.770310 0.908994 -0.083046 0.803658 0.111996 1.532402 0.759402 0.036170 0.943179 0.079272 1.830583 1.382504 0.397346 1.856130 1.407405 0.379257 1.552501 1.336822 0.894256 0.259512 1.640642 1.404950 1.043723 0.498578 -0.255562 1.439871 1.113214 0.957074 0.794912 0.690668 0.138597 0.312164 -0.286212 1.710429 1.181779 1.119942 0.882351 0.853742 1.507047 0.801407 1.064423 0.722928 0.946894 0.773817 1.034859 1.074112 1.587958 1.477366 1.754829 -0.141780 -0.019862 0.118652 0.596035 1.023862 1.396961 0.052731 -0.006814 0.649298 1.055665 1.431062 1.786776)
     )

;;; 87 all -------------------------------------------------------------------------------- ; 9.3274
(vector 87 11.76194265333 #r(0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1)

     9.336088 #r(0.000000 0.935303 -0.305855 0.639666 -0.205066 0.575166 1.878633 -0.031633 0.332111 0.265245 0.447761 1.471005 0.466239 1.074654 0.243517 0.903095 0.071080 0.582837 0.986978 1.432105 0.143848 1.529993 0.888064 0.154620 1.746534 1.298224 1.092204 0.252914 1.241973 -0.114644 0.118634 1.005127 -0.195946 0.639640 0.754289 -0.065632 0.714364 1.300342 0.839106 1.256746 0.582262 1.885531 1.298010 0.384388 0.185574 1.168220 1.586291 1.242180 1.296083 0.391273 0.262871 0.811036 0.806565 0.431451 1.015342 1.630813 1.685662 -0.062763 0.311437 -0.322103 1.934808 -0.217239 0.478902 -0.218460 1.046362 0.603169 1.523851 1.302931 0.360083 0.678610 0.838126 1.626723 0.408089 0.150785 0.439104 0.575446 0.524826 1.662738 0.111387 1.179455 0.712858 0.531389 0.286195 0.456407 0.251572 1.398780 1.753711)

     ;; pp:start point was (pp.scm, make-pp.scm): pi+pi/87 and -pi/2
     9.188521 #r(0.000000 0.577038 1.207261 1.628557 0.262146 0.801237 1.556050 0.056439 0.667335 1.368629 -0.005675 0.749653 1.604613 0.459413 1.321111 -0.031172 1.051217 -0.021196 1.026933 1.909174 0.730842 1.464699 0.478663 1.424779 0.531386 1.829514 1.099308 0.030309 1.091452 0.183625 1.427990 0.713707 0.072882 0.988307 0.050871 1.569876 1.182625 0.368506 1.869531 1.283013 0.367839 1.495424 1.258194 0.820412 0.120239 1.561194 1.309622 0.929536 0.337985 -0.260353 1.473059 1.175804 1.110077 0.673201 0.814863 -0.004594 0.327741 -0.246652 1.781940 1.248926 1.174864 1.075991 0.895836 1.403691 0.903960 0.895504 0.766042 1.020851 0.881318 1.007885 1.155350 1.590758 1.540581 1.812457 0.004350 -0.049652 0.077880 0.408393 0.883302 1.419937 1.752252 -0.010350 0.469666 0.737948 1.471230 1.731975 -0.094827)
     9.187891 #r(0.000000 0.562265 1.215132 1.639989 0.268408 0.803228 1.556396 0.052662 0.673897 1.370427 -0.013341 0.755625 1.613682 0.464097 1.303388 -0.037077 1.034992 -0.022117 1.014610 1.893157 0.718728 1.483506 0.494314 1.442488 0.545375 1.834445 1.096157 0.044881 1.127012 0.215102 1.425993 0.718653 0.082596 0.974151 0.052799 1.587090 1.187190 0.360476 1.852622 1.250947 0.372936 1.523300 1.264181 0.805702 0.081155 1.558372 1.276806 0.921107 0.347174 -0.241287 1.479655 1.180393 1.125004 0.659710 0.822627 -0.001295 0.310451 -0.262271 1.777140 1.247104 1.177750 1.114372 0.920013 1.374146 0.894221 0.877518 0.741864 1.020196 0.885904 1.001071 1.161793 1.551252 1.536508 1.802169 0.022015 -0.071435 0.050557 0.417817 0.866824 1.426867 1.751719 0.013618 0.498761 0.731015 1.470154 1.720066 -0.074032)
     )

;;; 88 all -------------------------------------------------------------------------------- ; 9.3808
(vector 88 11.638312339783 #r(0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1)

	9.316523 #r(0.000000 0.878486 0.456733 1.616494 0.833842 1.630288 0.213084 0.318066 0.387075 1.258199 0.888074 1.626323 1.385324 1.449641 1.788877 1.459694 0.074476 0.796586 0.333918 0.652336 0.086019 1.093159 0.327760 0.026729 0.468210 0.200167 0.537074 1.539924 -0.274885 1.353211 0.267108 0.236471 1.407050 0.990605 0.724714 0.464124 0.495860 1.314621 -0.030616 0.350065 0.839694 0.794947 -0.082046 0.540462 1.600245 0.715450 0.591095 1.608103 0.808561 1.476715 1.175725 0.089220 0.447550 -0.172825 1.173712 -0.287102 0.416439 1.195370 1.285929 1.007325 0.957271 -0.013128 1.194681 1.765216 1.741310 1.202198 1.235154 1.112410 1.116838 1.017962 0.227564 0.013993 0.930616 0.757675 -0.297628 0.560900 0.173387 0.493968 1.241443 0.533916 1.114281 1.119507 0.538020 0.529723 1.672789 1.594826 0.538626 1.278733)

	;; 87 + 1 (pp)
	9.244078 #r(0.000000 0.694018 1.165822 1.676512 0.096734 0.820300 1.468057 0.088341 0.655120 1.291453 -0.067834 0.750649 1.606715 0.366794 1.199710 0.067953 1.171063 0.125791 1.077914 1.904683 0.572953 1.438964 0.387785 1.361027 0.470626 1.798354 1.025608 -0.183300 0.935453 0.193835 1.423867 0.670497 0.056060 1.040746 0.102123 1.502090 1.195959 0.413063 1.791619 1.270627 0.359281 1.413426 1.078876 0.807816 0.227637 1.617604 1.316579 0.989646 0.288255 -0.228378 1.516380 1.207792 1.225064 0.737215 0.935014 0.031773 0.170020 -0.334787 1.865610 1.331909 1.164836 0.934833 0.925908 1.288654 0.798848 1.076323 0.722509 1.032823 0.879278 0.906937 0.934088 1.637290 1.478240 1.745733 -0.031866 -0.004141 0.054848 0.181925 0.776139 1.296456 1.577696 1.832552 0.546057 0.624987 1.395395 1.680089 -0.150964 0.305296)
	9.243448 #r(0.000000 0.697851 1.166665 1.665599 0.098169 0.813468 1.475112 0.101377 0.652595 1.273039 -0.081569 0.745524 1.591625 0.353099 1.188181 0.067828 1.161595 0.152496 1.082314 1.900802 0.588773 1.446857 0.379192 1.369274 0.475586 1.801340 1.037627 -0.178925 0.939324 0.188566 1.443075 0.665312 0.046982 1.052243 0.101080 1.498797 1.207289 0.409569 1.784327 1.271339 0.376759 1.422106 1.059422 0.802437 0.209481 1.613077 1.299497 0.983704 0.306573 -0.235197 1.532651 1.198072 1.226923 0.712611 0.934064 0.028480 0.165446 -0.347088 1.856068 1.322916 1.165417 0.930692 0.903535 1.267764 0.795402 1.061438 0.706954 1.032722 0.865689 0.907087 0.916387 1.610361 1.471937 1.742343 -0.052496 -0.040631 0.057803 0.155675 0.765103 1.291462 1.566099 1.820302 0.538939 0.627227 1.392483 1.674330 -0.144452 0.267627)
     )

;;; 89 all -------------------------------------------------------------------------------- ; 9.4340
(vector 89 12.148494905477 #r(0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 1)

	9.351480 #r(0.000000 0.115345 0.952969 1.130622 0.084058 0.254252 0.443202 0.470071 0.932794 0.466331 0.591979 0.457396 1.528107 0.715257 1.847307 0.403253 0.673874 1.456603 0.267262 0.304798 0.064020 -0.007350 0.259234 -0.287472 0.913317 0.595047 1.491194 0.951199 1.469407 0.524123 -0.304693 -0.076445 1.827209 1.059199 1.449793 1.495662 0.754984 0.852314 0.216817 0.724819 0.597427 1.273980 0.926620 0.643916 0.066061 0.625597 1.284699 0.657854 0.605911 1.653365 1.442076 1.033587 -0.542590 1.262635 1.257414 1.117301 0.126208 0.112501 1.272548 0.912632 0.005045 0.757226 0.049364 -0.033316 1.800311 -0.300949 0.310947 1.267820 0.529700 0.817110 -0.265053 1.152779 -0.048439 0.296709 1.270792 1.398568 -1.703554 0.050635 0.940556 0.440806 1.384526 0.885947 -0.609539 0.281434 0.391260 0.168064 1.027217 1.891400 0.923378)

	;; 90-1:
	9.316853 #r(0.000000 0.085819 0.605350 0.616151 0.515100 0.192006 1.611678 1.272280 0.904547 0.453867 0.529558 0.437126 -0.275887 1.872898 1.598164 1.418346 1.396886 1.184855 1.082655 1.009362 1.135722 1.346642 1.144862 1.310841 1.530764 1.205966 1.069809 1.617371 1.901283 0.014975 0.548240 0.352080 0.621455 0.621066 1.140982 1.438527 1.367420 1.355216 0.470090 0.621128 1.153118 1.453426 1.808321 0.722632 1.010390 1.016431 1.780248 -0.019572 0.772427 1.493792 0.482571 0.820743 1.364914 -0.136038 0.461117 1.249099 0.311482 0.865776 -0.039503 0.219768 1.361786 0.194309 1.428040 0.130391 0.884203 1.244022 0.541300 1.606196 1.062028 0.148664 0.708408 0.000808 0.975685 0.011180 0.773834 -0.174375 1.225192 0.298080 1.628234 1.104559 -0.010457 1.317133 0.763549 0.343844 1.496091 1.494316 0.445462 0.157345 1.694775)
	9.315509 #r(0.000000 0.124567 0.583351 0.597843 0.508932 0.236340 1.629251 1.260618 0.886324 0.407100 0.532057 0.464552 -0.228622 1.874560 1.586831 1.454279 1.336216 1.166281 1.089863 0.976652 1.146549 1.384070 1.107271 1.259583 1.540352 1.231987 1.112399 1.654619 1.894205 0.035892 0.522606 0.318613 0.597511 0.620237 1.103293 1.435193 1.365285 1.347328 0.516939 0.607227 1.150990 1.407334 1.775681 0.771851 0.945166 0.989030 1.801909 0.000987 0.826555 1.547883 0.480169 0.802373 1.360513 -0.158813 0.514706 1.271439 0.393074 0.883929 -0.039924 0.249141 1.389995 0.169046 1.414692 0.200776 0.896962 1.236745 0.582426 1.647885 1.121990 0.246958 0.721303 0.009183 0.987717 0.027886 0.854020 -0.153681 1.227081 0.324522 1.691772 1.126527 -0.020392 1.310045 0.754076 0.386463 1.500700 1.504277 0.417697 0.239864 1.723507)
     )

;;; 90 all -------------------------------------------------------------------------------- ; 9.4868
(vector 90 12.059710502625 #r(0 0 1 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0)

	9.398614 #r(0.000000 0.892706 1.062256 0.213835 0.203111 1.398668 1.054220 0.038528 1.142619 0.118583 0.457258 1.631677 1.573493 1.353053 0.245939 0.098142 1.245835 1.513894 0.025359 0.747716 0.843192 1.216875 0.015492 0.415459 0.312421 1.153905 1.780617 0.437612 -0.400304 -0.029367 1.378815 -0.215560 0.280582 1.233159 0.249478 0.201675 0.961263 0.048927 0.571980 0.265611 0.963409 1.336060 0.891681 1.142504 1.421083 1.162603 1.027272 0.851118 0.849549 0.034892 1.199036 0.308700 1.882141 0.734414 0.473371 1.758626 0.761172 0.952217 -0.108344 1.230664 0.088942 0.737287 0.280477 0.684695 1.865274 1.638095 0.534719 0.573717 0.414603 0.759210 0.580912 -0.293171 0.034364 1.872658 1.705405 0.725925 -0.286371 0.704217 0.268789 0.757724 0.268458 1.430890 1.325737 1.264595 0.335646 0.223092 0.572527 0.875084 0.723299 0.490792)

	;; 91-1
	9.369284 #r(0.000000 0.030596 0.512977 0.726782 0.477829 0.081885 1.589694 1.322061 1.083902 0.559521 0.448753 0.385931 -0.189736 1.722513 1.513355 1.392162 1.333913 1.122941 1.145305 1.071310 1.267721 1.283537 1.282341 1.395603 1.460843 1.220013 1.214982 1.532704 1.680386 -0.041828 0.369697 0.425933 0.371638 0.589333 1.041407 1.225589 1.172832 1.376354 0.162279 0.498805 1.164883 1.416170 1.867958 0.505897 0.978762 1.054842 1.522372 -0.063766 0.952495 1.463756 0.521257 0.824505 1.179094 1.811681 0.447390 1.180931 0.235815 0.652944 -0.161883 -0.021774 1.283901 -0.087905 1.281512 -0.144202 0.579788 1.336977 0.409226 1.333107 0.963576 0.011530 0.529499 1.655761 0.578200 1.742908 0.613593 -0.239938 1.074047 0.302129 1.602392 0.926017 -0.218685 1.216630 0.428055 0.183727 1.506714 1.185120 0.296902 -0.071562 1.483831 0.585762)
     )

;;; 91 all -------------------------------------------------------------------------------- ; 9.5394
(vector 91 12.130150794983 #r(0 1 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0)

	9.460641 #r(0.000000 0.436117 1.518395 1.686873 0.685584 1.390220 1.721023 1.218901 0.617875 0.942031 0.798753 1.787198 0.914695 1.067725 0.500698 1.164934 1.198775 0.318349 0.110243 1.683123 1.771564 0.104141 0.404057 1.512291 -0.053002 0.635555 0.485286 0.639133 1.522433 0.362468 1.841483 -0.018649 1.636664 1.891231 -0.092223 0.000560 1.591693 0.345850 0.362361 0.150153 0.525106 1.675920 1.376159 0.544954 1.155066 0.115196 0.924275 -0.119311 1.123186 0.422131 1.628623 0.610317 0.891460 1.679635 0.315850 0.345138 -0.095637 1.712298 -0.241584 0.926203 1.708802 0.312769 0.179387 0.288518 0.999840 0.990421 1.415220 1.453610 0.512219 1.890115 0.694941 1.068928 1.023842 0.497685 1.095073 1.132736 1.716879 -0.012368 0.180422 1.245447 0.380145 -0.172552 1.441547 0.152524 1.430740 1.014319 0.944154 0.113921 1.674916 -0.025585 0.846123)

	;; 92-1
	9.406571 #r(0.000000 0.070183 0.558945 0.616954 0.488264 0.097581 1.643944 1.396224 1.158953 0.725014 0.517196 0.327654 -0.169876 1.614114 1.687774 1.412838 1.174539 1.259505 1.130798 1.052361 1.015956 1.267208 1.254231 1.379495 1.394559 1.223329 1.348807 1.448672 1.402107 -0.114780 0.204211 0.407141 0.213819 0.557195 0.878563 1.293773 1.227658 1.440547 0.218508 0.668102 0.992197 1.450344 1.592835 0.514105 0.745631 1.232389 1.450929 -0.020833 0.958476 1.514641 0.316511 0.755172 1.221264 1.755846 0.507669 1.139584 0.110724 0.749907 0.055238 0.050342 1.322976 0.038212 1.303755 -0.169105 0.463456 1.427795 0.697605 1.381025 0.968559 0.022635 0.695622 1.792840 0.529902 1.903317 0.747931 -0.193306 0.982955 0.298689 1.702098 1.077145 -0.265151 1.140052 0.371003 -0.055705 1.235675 1.006638 0.294853 1.755510 1.459678 0.647624 -0.081756)
     )

;;; 92 all -------------------------------------------------------------------------------- ; 9.5917
(vector 92 12.009957507951 #r(0 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 0 1)

	9.517966 #r(0.000000 0.086823 0.747623 -0.085371 0.122456 -0.230268 0.119188 1.361402 1.167782 0.037384 1.047768 0.553092 0.649815 1.008382 0.794506 0.305054 1.023759 0.770450 1.886190 0.685208 0.379196 0.684576 0.589903 0.070635 1.842447 1.673609 -0.393612 0.098157 1.794112 0.846616 0.025307 0.910127 0.590170 1.608490 0.410052 1.692507 -0.369713 0.406231 1.469315 1.471065 0.951373 1.130104 0.531009 1.015991 1.488443 0.280351 0.460606 1.244663 1.053735 0.254819 0.300775 0.994290 1.059430 1.061070 1.049296 1.008564 -0.162768 1.637847 1.291833 1.037154 0.364051 0.144913 0.533100 1.075664 1.325409 -0.343880 0.931404 1.449787 0.745214 0.874779 -0.406152 1.757226 1.474675 0.453343 1.845066 0.544094 1.158828 0.100488 1.840683 0.221106 0.924537 1.893930 0.736114 1.402591 0.613840 0.057492 0.409601 -0.093628 1.271558 0.626825 0.949050 -0.217069)

	;; 93-1
	9.419885 #r(0.000000 0.069529 0.633901 0.633608 0.570434 0.157518 1.715794 1.321616 1.084449 0.794466 0.425008 0.283514 -0.131990 1.646881 1.533838 1.442714 1.177599 1.239726 1.207883 1.015321 0.976921 1.262383 1.278818 1.276322 1.338824 1.226865 1.318320 1.361295 1.375488 -0.072989 0.149612 0.367026 0.181636 0.504697 0.851522 1.286853 1.425655 1.395838 0.306909 0.627046 0.973004 1.385102 1.455309 0.477354 0.684776 1.138509 1.548279 -0.072451 0.798558 1.262715 0.056514 0.791921 1.056616 1.695546 0.434938 1.116470 0.025573 0.789168 -0.006184 0.138467 1.335319 0.002519 1.259750 -0.081984 0.549375 1.443475 0.683161 1.338585 0.966058 1.876977 0.624731 1.787187 0.503447 1.917935 0.840074 -0.187662 1.042424 0.183738 1.737882 1.038721 -0.194530 1.214452 0.488651 0.014114 1.273532 1.004556 0.303820 1.746128 1.409399 0.765865 0.191028 1.596552)
     )

;;; 93 all -------------------------------------------------------------------------------- ; 9.6437
(vector 93 12.125471062226 #r(0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1)

     9.668780 #r(0.000000 1.502492 1.735960 1.811396 -0.104957 0.482636 0.500559 -0.183071 -0.047836 1.299077 0.116243 0.998697 1.692766 0.951722 0.883989 1.357273 1.702880 0.882694 1.095034 1.397512 0.329332 0.527364 0.298917 0.655212 0.187816 0.424294 1.150209 0.114579 0.252718 -0.217705 0.508106 -0.043801 0.270810 1.167969 0.982839 0.517943 0.010809 1.845815 1.098777 0.567160 0.419087 1.030585 1.503183 1.837046 1.638737 1.381290 1.657079 1.137100 1.564675 -0.040237 0.809480 0.832346 1.587671 -0.164235 1.557353 -0.318789 1.412269 1.419735 0.213834 0.923183 0.158106 0.606199 0.283874 -0.361272 1.495430 1.475886 0.334771 1.534489 0.873427 -0.175602 1.422400 0.168157 0.667278 1.332909 0.520912 0.514379 1.506377 1.240021 1.795506 1.354822 0.149370 0.097693 1.231885 1.499794 1.191816 0.402471 1.807112 1.364329 0.383172 1.438070 0.658534 1.737005 0.518886)

     ;; pp:
     9.412639 #r(0.000000 0.102641 0.679230 0.798388 0.598526 0.445036 1.682481 1.416478 1.010866 0.838753 0.518866 0.185140 -0.260801 1.643327 1.645133 1.587871 1.510095 1.367190 1.252764 1.075109 0.997402 1.226792 1.097666 1.109286 1.266675 1.142806 1.396415 1.366757 1.323435 -0.151657 0.110933 0.254314 0.125232 0.426419 0.874355 1.227943 1.386454 1.437438 0.183960 0.673205 0.896736 1.317085 1.421345 0.557215 0.650544 0.979705 1.599286 -0.027664 0.967924 1.389243 -0.027060 0.800953 1.098758 1.686133 0.493843 1.257456 0.105617 0.800125 0.006765 0.139250 1.353019 -0.059007 1.198209 0.066444 0.431719 1.470864 0.547882 1.294688 0.757592 1.690943 0.714913 1.735237 0.542409 1.804533 0.779629 -0.296056 1.090213 0.178123 1.832019 1.000948 -0.131923 1.161644 0.360890 0.065736 1.232224 0.792139 0.176636 1.688866 1.432871 0.734257 0.042563 1.592538 0.764029)
     )

;;; 94 all -------------------------------------------------------------------------------- ; 9.6954
(vector 94 12.510846178591 #r(0 0 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0)

	9.614457 #r(0.000000 0.354827 0.986082 0.678218 0.074619 1.069713 1.084979 -0.010872 1.376391 1.050934 0.019873 0.645649 0.930266 1.023286 -0.324271 0.129791 1.399266 0.790347 1.024795 0.364675 1.268057 0.467841 0.596106 0.634764 0.920301 0.577212 1.246648 0.805833 -0.021659 -0.091918 0.865047 0.408442 1.292571 1.382486 -0.396633 1.688655 0.645075 1.689205 0.543001 -0.020503 1.556121 1.527556 1.671083 1.274725 1.683665 1.385648 1.434218 0.579921 1.533529 0.946387 1.280342 1.067943 -0.140266 0.061709 0.145137 0.716787 0.346453 1.817745 0.110851 1.072741 1.054881 1.191219 0.552352 1.218769 1.077324 -0.052815 -0.201076 1.253349 1.375788 0.845621 0.366991 0.916267 0.628985 1.420824 1.381120 0.247768 0.913794 -0.038130 1.360273 -0.162096 1.251116 1.166185 0.322598 1.024569 1.763375 0.466730 1.066807 0.067495 0.545386 1.308131 1.358919 0.937638 0.693078 0.195493)

	;; 93+1
	9.543681 #r(0.000000 0.070784 0.635867 0.742637 0.475019 0.302813 1.825409 1.378229 1.077426 0.877718 0.610301 0.202771 -0.182277 1.673466 1.553357 1.494058 1.368050 1.336285 1.249015 1.094284 1.026782 1.245912 1.085605 1.018283 1.167850 1.013374 1.392524 1.418879 1.281568 -0.274841 -0.022454 0.129657 0.125509 0.504384 0.935744 1.276977 1.483975 1.477426 0.196761 0.675603 0.862408 1.192185 1.459380 0.549610 0.569998 1.001464 1.695499 0.066362 0.898853 1.281654 0.050116 0.806388 1.047653 1.730201 0.520253 1.351614 0.000078 1.010541 -0.167505 0.168460 1.307105 0.008313 1.198293 0.190292 0.394166 1.604739 0.575546 1.381303 0.832277 1.821709 0.813449 1.752392 0.618919 0.026374 0.880532 -0.283635 1.155422 0.216026 1.884068 1.144874 -0.171918 1.125849 0.302834 -0.082892 1.104687 0.762677 0.111766 1.593198 1.158618 0.738387 -0.017688 1.548369 0.670450 -0.209765)
     )

;;; 95 all -------------------------------------------------------------------------------- ; 9.7468
(vector 95 12.431831359863 #r(0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1)

	9.594917 #r(0.000000 1.389542 1.176101 1.128189 0.857825 0.606938 0.053944 1.193702 0.869053 0.060247 1.681618 -0.018030 0.093189 1.777775 1.314304 1.617940 0.848617 -0.108633 0.918764 1.157666 0.455570 1.631612 1.168101 0.785976 0.402697 1.470789 1.252874 0.702336 1.782377 1.673658 1.631189 1.349352 1.050241 0.712255 1.786745 0.232201 0.625268 1.043139 1.455512 1.195110 0.998337 0.283110 0.709026 0.841439 0.900171 1.560899 0.398341 0.605576 1.226269 0.101415 0.662630 -0.080073 0.123777 0.243381 0.746050 1.688701 0.805710 -0.417799 1.076341 1.138430 0.020724 1.738280 0.026371 0.359523 1.207908 0.092412 0.589896 1.141872 0.833369 1.211938 0.834700 0.366724 0.985159 0.093930 1.781990 0.844009 1.324575 1.222996 -0.119995 1.044915 0.191275 1.202233 0.891410 1.663012 1.114750 1.562345 -0.205599 1.605273 0.019367 1.356810 0.858474 1.006151 -0.416772 0.195895 1.774084)
     )

;;; 96 all -------------------------------------------------------------------------------- ; 9.7980
(vector 96 12.586637130548 #r(0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1)

	9.698754 #r(0.000000 1.686945 0.467972 0.353719 0.039839 1.529803 1.113587 1.518769 0.069518 0.641616 0.744046 1.828910 0.013471 -0.229934 0.181085 -0.011815 0.130449 1.033538 1.435542 1.445735 1.524439 1.088117 0.632800 0.518998 -0.093855 1.447748 -0.258898 0.540666 0.708408 1.141240 0.388952 0.533151 0.107615 0.843908 1.797589 1.037747 1.105446 0.651000 0.775586 -0.512743 0.563193 0.707947 1.740714 1.753866 0.373300 1.459832 0.879332 1.133261 0.035182 1.481640 1.284446 0.744828 1.229402 -0.449568 1.081113 -0.235470 0.939023 1.698241 1.413068 -0.279150 0.681300 1.084041 -0.075079 0.087600 0.709157 -0.062761 0.870661 0.903931 0.019006 1.008038 -0.009901 1.442216 1.097881 0.558710 1.835109 1.151033 1.232982 1.137424 0.991349 -0.312466 0.156001 0.908045 0.922926 1.582365 1.057816 0.119723 1.368068 0.167350 -0.363438 0.279779 0.391520 0.751632 -0.048111 1.271729 1.046123 1.547668)

	;; 95+1
	9.726779 #r(0.000000 1.272536 1.234689 1.036804 0.806804 0.685514 -0.233507 1.195648 0.974626 -0.133690 1.612184 -0.250031 0.153834 1.639158 1.448966 1.429020 0.841318 0.036800 0.809280 1.124317 0.410517 1.790247 0.947605 0.878411 0.284331 1.437808 1.242148 0.609187 1.691642 1.608067 1.542734 1.433245 1.048694 0.695483 1.770228 0.049652 0.565924 1.008807 1.378374 1.235802 0.944856 0.275648 0.688876 0.690791 0.947538 1.724048 0.507279 0.344409 1.011255 0.053102 0.655524 0.015954 -0.000803 0.135128 0.906712 1.703603 0.898426 -0.371698 1.225250 0.634585 -0.033241 1.655363 -0.118205 0.384853 1.242318 0.157876 0.169651 1.065989 0.596048 1.102812 0.663038 0.195163 0.860121 -0.157778 1.681909 0.740009 1.139644 0.978398 -0.218097 0.770242 0.520081 1.060101 0.721838 1.327594 1.028501 1.403966 -0.169752 1.470700 0.038544 1.145229 0.628698 0.803002 -0.539861 0.036303 1.343341 -0.219240)
     )

;;; 97 all -------------------------------------------------------------------------------- ; 9.8489
(vector 97 12.585 #r(0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1)
     
	9.811290 #r(0.000000 1.599348 0.923331 0.142353 1.275817 1.382624 1.510378 0.732924 0.806532 1.015499 0.620826 1.882699 1.212790 0.807183 -0.023255 1.516389 1.732605 -0.201884 -0.277404 -0.055883 0.240940 0.731931 1.673522 0.086425 1.587574 0.602365 1.160815 1.229056 1.456929 0.833735 0.852700 0.201630 1.357627 0.458255 0.370269 1.445354 0.215612 1.445930 1.140683 1.395090 0.893305 1.761792 0.069580 1.477150 1.261329 0.799176 -0.171506 -0.046281 0.037534 0.945505 0.457403 -0.446133 -0.016772 1.686139 0.929506 1.761163 1.283945 0.714187 0.030687 1.699690 1.935312 -0.149630 1.586492 0.783961 1.445990 1.058255 1.383027 0.027818 1.949317 0.450708 0.615659 0.863171 1.311974 0.506328 0.888408 1.633309 0.234089 1.362300 1.207491 0.660429 0.454914 0.801172 1.438508 0.392994 1.045451 0.178268 0.808166 0.169353 0.379391 0.545139 1.796419 0.579129 1.221213 0.829753 -0.091400 0.706540 1.245414)

     ;; 98-1
     9.733625 #r(0.000000 -0.316389 0.763514 1.085136 -0.007054 1.613164 0.368355 0.497362 0.266819 0.792626 1.605095 0.379462 0.795808 0.617439 0.340832 1.408797 0.884588 0.777692 -0.061819 1.329857 1.611199 0.024913 1.778069 1.061965 1.317076 1.286538 -0.063928 0.439816 1.190286 1.720423 -0.281159 0.284236 1.261293 1.715607 1.258044 1.027201 0.992940 1.404704 0.918469 0.571955 0.670954 -0.578424 1.681045 1.759567 -0.365702 0.685884 0.480691 0.685380 0.103522 0.029224 1.512644 0.122325 0.600548 0.070986 0.493468 0.652824 -0.059890 1.290005 1.370566 0.135509 0.143591 -0.197126 0.478025 0.315521 0.839450 0.083388 0.553358 1.161959 0.770340 1.132488 0.641596 1.702281 0.277494 1.930557 0.772636 0.175945 1.352904 0.123527 1.448091 0.194310 0.330488 1.631688 1.302741 0.566332 1.521760 0.740046 0.257004 1.532435 0.681554 0.238673 0.612205 0.128510 1.851063 0.280067 1.237302 -0.034034 0.240185)
     )

;;; 98 all -------------------------------------------------------------------------------- ; 9.8995
(vector 98 12.724907890996 #r(0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1)

	9.767029 #r(0.000000 -0.188323 0.675144 1.162326 -0.152620 1.669640 0.370125 0.494628 0.190555 0.715197 1.719005 0.377693 1.013961 0.545798 0.345914 1.535759 0.968261 0.937780 -0.119329 1.630311 1.635898 0.029531 1.850111 1.208612 1.298337 1.226547 0.020306 0.388794 1.210462 1.649716 -0.158605 0.268380 1.285081 1.672163 1.145021 0.908520 1.140268 1.468740 0.844848 0.440912 0.760836 -0.415872 1.889804 1.724959 -0.229249 0.766901 0.564605 0.613211 0.221081 -0.012880 1.521722 -0.044019 0.593078 0.034669 0.491432 0.559669 -0.045684 1.255880 1.344088 0.070215 0.282883 -0.229690 0.625053 0.504422 0.811212 -0.012186 0.589513 1.241057 0.831526 1.215774 0.684110 1.651422 0.305036 1.891476 0.747710 0.040696 1.539490 0.154881 1.456564 0.357589 0.123799 1.523900 1.179657 0.504889 1.418226 0.850462 0.009923 1.481216 0.600938 0.216302 0.543002 0.255145 1.787452 0.279328 1.172852 -0.085076 0.199219 1.196556)
     )

;;; 99 all -------------------------------------------------------------------------------- ; 9.9499
(vector 99 13.002375571256 #r(0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 0 0 0)

	9.856524 #r(0.000000 0.532142 1.131528 0.051928 1.654946 0.271228 1.101349 1.560647 1.619023 1.108572 0.726033 0.727251 -0.132854 0.360041 0.670224 1.663602 -0.493942 -0.197685 1.604359 1.799803 1.040897 0.122580 0.382051 1.681979 0.430500 1.558581 0.044836 1.543992 1.439831 0.906809 1.334494 1.667502 1.130520 0.467062 1.310080 0.675817 0.797910 0.443927 1.274100 0.336343 0.146059 -0.192316 0.742563 0.471697 1.596436 -0.009686 1.651640 1.837904 0.406037 0.558091 -0.016989 1.479179 0.903735 1.116299 -0.060825 0.179513 -0.026846 1.811414 0.072416 -0.014783 0.060148 0.361427 1.207468 0.945662 0.068194 1.516887 0.004488 0.212016 0.737847 -0.343051 0.746533 0.527238 1.812564 0.462282 1.376985 0.882738 1.070840 1.718397 0.663551 0.922534 1.724192 -0.576637 1.416748 1.206588 0.385428 0.383601 1.504489 1.636715 0.253055 1.809058 0.862228 1.855156 1.029803 0.604391 1.515278 0.827373 1.237016 1.652558 1.330582)

	;; 100-1
	9.837088 #r(0.000000 0.501632 0.934877 -0.406945 1.720666 0.060221 0.986624 1.296415 1.868188 0.930965 0.372307 0.709017 -0.252505 0.160880 0.812384 1.543611 -0.433820 -0.259337 1.687543 1.624404 0.816138 0.040401 0.111607 -0.236070 0.269290 1.314408 0.264913 1.524076 1.510591 0.672939 1.225301 1.486867 1.198432 0.684715 1.400436 0.809536 0.790904 0.226400 1.325157 0.378418 0.148020 -0.182631 0.691385 0.400855 1.875888 -0.034659 1.584706 0.098304 0.424031 0.680276 -0.260219 1.393931 1.457882 1.172138 0.294071 0.176446 -0.047801 -0.268365 -0.154114 0.172473 0.026218 0.381410 0.486670 0.694651 0.137283 1.339580 -0.408431 0.346779 0.297247 -0.681534 0.303276 0.742358 1.426415 0.456204 1.180942 0.678579 1.815369 1.742844 0.288364 0.833505 1.638509 -0.777919 1.367299 1.067232 -0.002137 0.375276 1.602540 1.654913 0.141825 1.294416 0.790392 1.752947 1.096531 0.330167 1.510639 0.495286 1.348117 1.506107 1.279426)
	9.827383 #r(0.000000 0.489851 0.987809 -0.394189 1.760605 0.036969 0.958351 1.266375 1.844806 0.928905 0.347370 0.708814 -0.213250 0.135838 0.840288 1.524164 -0.453078 -0.222429 1.664862 1.650792 0.843217 0.096982 0.106278 -0.254905 0.311964 1.356301 0.208474 1.484260 1.533307 0.693746 1.221284 1.494648 1.192154 0.704448 1.399404 0.773577 0.730819 0.230112 1.305343 0.384931 0.092126 -0.177018 0.678108 0.424573 1.876518 -0.110628 1.580149 0.105746 0.460598 0.667046 -0.301428 1.430147 1.462027 1.200592 0.294468 0.132684 -0.034510 -0.232945 -0.131872 0.235724 -0.003826 0.390220 0.478949 0.708773 0.158613 1.284193 -0.406418 0.372748 0.269091 -0.683069 0.298317 0.742905 1.467502 0.490499 1.200844 0.658586 1.777690 1.768714 0.250192 0.808599 1.653844 -0.705600 1.331238 1.087732 0.038158 0.351212 1.574369 1.702783 0.145504 1.240857 0.779939 1.689313 1.071204 0.299434 1.500921 0.518280 1.343637 1.492826 1.331082)
     )

;;; 100 all -------------------------------------------------------------------------------- ; 10
(vector 100 12.998435541498 #r(0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0)

	9.934540 #r(0.000000 -0.003002 1.124858 1.923310 1.313585 0.903273 0.269057 1.550768 -0.053877 1.309350 0.259003 0.111356 1.649851 -0.475532 0.829676 0.358899 1.751244 0.579333 0.816025 0.729724 0.670859 0.992375 1.547721 -0.006147 1.191599 -0.084864 -0.001041 0.113001 0.580223 -0.405864 1.746923 1.268810 1.705215 1.056469 -0.197189 1.293674 0.934396 0.701720 0.582761 1.455750 1.232104 0.066182 1.464245 1.672004 0.239530 1.711330 -0.092878 0.399845 1.787310 0.046607 0.724822 1.735381 1.288901 0.460956 0.591963 0.996187 1.917259 0.311027 0.319804 1.898631 1.336795 0.632408 0.203462 1.031863 1.346167 0.931351 0.938341 -0.021240 0.003608 0.259606 1.507194 1.470684 0.324860 1.386425 0.298636 1.353945 1.922770 1.226486 0.467967 1.127400 0.946778 1.636808 0.285401 1.555027 1.572734 1.271086 1.042408 1.022431 1.651957 1.039348 0.338431 0.852870 0.945331 1.308135 1.631151 1.286426 0.091020 0.620928 0.894381 1.712980)

	;; 99+1
	9.840430 #r(0.000000 0.622605 0.940347 -0.023879 1.823374 0.046101 0.987386 1.386868 1.714786 1.047746 0.546094 0.770951 -0.265661 0.292412 0.888118 1.675189 -0.427745 -0.167443 1.762203 1.576180 0.923298 0.110300 0.331275 1.952651 0.241655 1.589880 0.276846 1.519665 1.333705 0.834984 1.249804 1.700983 1.188281 0.627881 1.352135 0.781883 0.873102 0.286686 1.236704 0.305170 0.118608 -0.061299 0.746712 0.436256 1.850021 0.025967 1.523851 0.111789 0.590538 0.644667 -0.043430 1.449342 1.285442 1.251443 0.387240 0.168668 -0.008131 -0.077897 -0.090554 0.128941 0.292252 0.590066 0.910912 0.845002 0.114157 1.267409 -0.143231 0.405284 0.467262 -0.510143 0.597548 0.663042 1.615835 0.378343 1.456219 0.634771 1.512841 1.710315 0.498665 0.804929 1.545845 -0.422582 1.525481 1.254165 0.184553 0.563406 1.423281 1.785321 0.228158 1.573508 0.775481 1.683423 1.226447 0.381675 1.467512 0.862051 1.538318 1.641940 1.350297 0.135931)

	9.835590 #r(0.000000 0.570539 0.883467 -0.014746 1.809284 0.037164 0.942356 1.400420 1.689848 1.054845 0.548531 0.724602 -0.281675 0.241599 0.863477 1.691280 -0.386312 -0.167207 1.712242 1.554897 0.916947 0.154344 0.337144 -0.027896 0.191502 1.562234 0.293369 1.468239 1.368021 0.858183 1.215102 1.710412 1.168343 0.641872 1.384374 0.758703 0.847326 0.232955 1.203009 0.285135 0.164856 0.006319 0.731916 0.364606 1.825894 0.043345 1.457606 0.099304 0.693634 0.599315 -0.080515 1.358403 1.276512 1.306804 0.350411 0.153823 -0.066078 -0.056199 -0.130700 0.138204 0.313702 0.671650 0.858922 0.893029 0.081041 1.207722 -0.186661 0.401736 0.459231 -0.571478 0.607326 0.634928 1.590455 0.322847 1.466431 0.635387 1.523516 1.640986 0.518971 0.735455 1.517620 -0.440561 1.538277 1.209947 0.169421 0.568757 1.501995 1.704851 0.248785 1.539090 0.803108 1.622622 1.319362 0.357166 1.483707 0.858733 1.549787 1.667959 1.355314 0.166782)
	9.828147 #r(0.000000 0.606381 0.917097 -0.052963 1.840850 0.076195 1.000382 1.379573 1.713959 1.056049 0.567183 0.755185 -0.243029 0.240141 0.901208 1.696896 -0.401067 -0.172213 1.702278 1.572589 0.995369 0.092107 0.339155 -0.047255 0.209942 1.548195 0.250627 1.493833 1.397582 0.850788 1.234138 1.694866 1.205737 0.609514 1.413541 0.774375 0.843373 0.256747 1.182652 0.287452 0.151651 -0.040175 0.718613 0.370108 1.797287 0.037564 1.483372 0.063366 0.673221 0.647681 -0.130882 1.410330 1.289134 1.259368 0.378589 0.179096 -0.077706 -0.126123 -0.197835 0.087734 0.222460 0.660561 0.798643 0.833272 0.064575 1.260850 -0.205610 0.363184 0.404543 -0.579680 0.559469 0.652793 1.526709 0.333879 1.432283 0.642498 1.543163 1.637538 0.499172 0.795803 1.495177 -0.493071 1.544279 1.224387 0.125780 0.527014 1.451448 1.716932 0.232752 1.503302 0.799684 1.669661 1.257116 0.363202 1.442143 0.833946 1.525977 1.616490 1.388269 0.088027)
      )

;;; 101 all -------------------------------------------------------------------------------- ; 10.0499
(vector 101 13.219774246216 #r(0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0)

	;; 100+1
	9.928334 #r(0.000000 0.665967 0.808488 -0.299452 1.814455 0.103115 0.907176 1.394075 1.630101 0.900795 0.296519 0.962833 -0.433738 0.560295 0.666980 1.835154 -0.279839 -0.031634 1.784110 1.588290 1.067637 -0.084296 0.498781 -0.141826 0.313843 1.417194 0.278161 1.651147 1.555702 0.978173 1.181141 1.302529 1.194189 0.828430 1.413184 0.866774 0.480085 0.297646 1.211562 0.387667 0.067199 -0.347159 0.722985 0.483741 1.855309 -0.030363 1.226310 0.179911 0.429117 0.527809 -0.278101 1.140370 1.021869 1.189527 0.283868 0.208805 -0.049884 -0.127424 -0.115078 0.078040 0.263018 0.600699 1.081708 0.738634 0.138893 1.341511 -0.222681 0.831975 0.385157 -0.493602 0.352038 0.759227 1.590774 0.426044 1.540029 0.849237 1.363690 1.556222 0.415629 0.866591 1.752437 -0.973681 1.445077 1.553262 -0.064956 0.403839 1.648532 -0.192842 0.191551 1.416306 0.656144 1.672848 1.613529 0.059245 1.705726 0.684303 1.153859 1.402257 1.265878 0.157130 -0.103303)

	9.923211 #r(0.000000 0.606742 0.854252 -0.177107 1.717126 0.126638 0.927513 1.476397 1.664457 0.956378 0.451133 0.780343 -0.425380 0.274120 0.819410 1.770573 -0.423863 -0.102054 1.673610 1.665172 0.958864 0.002206 0.371610 0.035190 0.215930 1.472185 0.267288 1.510818 1.485723 0.910446 1.171075 1.613295 1.124870 0.735294 1.425415 0.799763 0.800290 0.148538 1.137687 0.418827 0.153019 -0.025494 0.839196 0.398827 1.841432 -0.009078 1.453123 0.257094 0.733715 0.627138 -0.121791 1.284946 1.399290 1.158477 0.423864 0.225825 -0.032272 -0.147351 -0.167399 -0.074160 0.282590 0.763953 0.741827 0.899306 0.215637 1.297259 -0.216774 0.533894 0.471905 -0.440553 0.570270 0.815305 1.465352 0.243327 1.458778 0.617832 1.630736 1.654231 0.454113 0.835126 1.701784 -0.680319 1.360576 1.516060 0.138474 0.422235 1.535120 1.717955 0.034676 1.563572 0.571682 1.668014 1.359079 0.300267 1.569925 0.710452 1.497267 1.484788 1.467677 0.005121 0.068300)
	9.921866 #r(0.000000 0.609806 0.853415 -0.178376 1.715639 0.125045 0.929898 1.476379 1.662595 0.957740 0.451135 0.781655 -0.427268 0.272758 0.818830 1.769523 -0.423916 -0.099803 1.673197 1.666031 0.957481 0.001110 0.369464 0.033970 0.216228 1.474165 0.268320 1.512523 1.483804 0.905565 1.174848 1.613266 1.125148 0.735425 1.428468 0.800602 0.802242 0.149205 1.137841 0.417883 0.150486 -0.027202 0.838573 0.398456 1.843236 -0.009638 1.452756 0.256842 0.733285 0.629225 -0.121467 1.285077 1.401085 1.159273 0.424114 0.225501 -0.029926 -0.145884 -0.166779 -0.070962 0.279800 0.763832 0.738411 0.899842 0.214924 1.297806 -0.216209 0.533724 0.471481 -0.437480 0.570518 0.814214 1.466310 0.243161 1.457087 0.616447 1.631480 1.653547 0.454623 0.836976 1.700774 -0.681521 1.358712 1.514908 0.139939 0.422637 1.532737 1.719310 0.035224 1.562793 0.575545 1.665604 1.357164 0.300428 1.567753 0.710501 1.494752 1.484684 1.466794 0.007458 0.066101)
      )

;;; 102 all -------------------------------------------------------------------------------- ; 10.0995
(vector 102 13.194128990173 #r(0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 0)

      10.088316 #r(0.000000 0.095626 0.514266 0.420449 0.749499 0.992394 -0.193393 0.039052 0.057117 1.575374 1.352773 1.322452 0.794003 0.750383 0.756593 0.273089 1.675537 0.407815 0.550801 -0.538502 0.957909 1.336960 1.614983 0.508708 1.910222 1.874209 0.940387 0.222605 0.538045 1.356000 1.741919 0.598382 1.550605 1.131133 0.773140 -0.232481 0.055269 1.822145 0.659426 -0.100655 1.261624 0.557410 0.214081 0.588453 0.458097 0.577319 1.055339 1.792023 0.525700 0.097434 0.222735 0.356704 1.885210 0.037676 0.938171 0.984298 1.949046 1.455206 0.941409 1.068679 0.637889 0.330852 0.138031 1.619860 0.674126 -0.251106 1.183963 1.959835 0.213213 0.066073 0.132459 0.329261 0.847485 0.503486 0.122913 0.684764 1.979054 0.659531 0.231782 1.341252 0.124898 0.707447 -0.419234 0.913042 1.413830 0.741236 1.664719 1.833486 -0.410776 0.347702 1.045974 -0.368342 0.123701 1.012180 1.052039 1.226053 0.364036 1.015550 1.423284 1.022491 0.770674 1.877516)

      ;; 100+2
      10.002736 #r(0.000000 0.694136 0.884286 -0.019865 1.949416 0.045647 0.784966 1.485288 1.831237 1.096539 0.463002 1.083013 -0.121170 0.359435 0.652933 1.645807 -0.422716 -0.232256 1.626278 1.440555 0.958131 0.134457 0.490737 0.007571 0.357050 1.752163 0.151816 1.558855 1.454026 0.987545 1.222854 1.687668 1.100248 0.567262 1.370806 0.848200 0.795775 0.373350 1.291901 0.405117 0.336479 0.081039 0.805242 0.490027 1.710694 0.189571 1.425039 0.086172 0.763664 0.606525 0.069586 1.531524 1.275494 1.130168 0.349598 0.298878 -0.039090 -0.285912 -0.120615 0.138896 0.355171 0.409218 0.795399 0.792160 0.288768 1.170359 -0.260392 0.351573 0.565468 -0.250055 0.636086 0.568462 1.596076 0.355472 1.258735 0.969838 1.592115 1.783400 0.530721 0.636731 1.503600 -0.690920 1.599651 1.373458 0.089786 0.445422 1.295129 1.885568 0.290790 1.482001 0.849877 1.956561 1.126285 0.177909 1.515702 0.760935 1.535581 1.648591 1.330225 0.034311 0.125802 -0.263447)

	;; 103-1
      10.005473 #r(0.000000 0.838980 0.811821 0.292160 0.449079 -0.307282 0.933362 1.480374 0.208636 0.701613 0.433885 0.738788 -0.163196 0.069086 0.180351 0.129560 1.658816 0.937982 1.725598 -0.219727 -0.190210 1.475660 0.996768 1.327001 1.275781 -0.030914 0.689923 1.387993 1.194676 1.062303 0.447502 0.886918 1.035286 0.766146 0.099314 0.250142 -0.386195 1.501334 1.121681 1.274635 0.640345 -0.611023 0.450001 1.019627 1.440522 0.697300 -0.023140 1.283472 0.279581 1.393780 1.586139 0.993131 1.208457 1.548968 0.100477 1.174748 1.104071 0.743429 1.496343 0.272839 1.548385 0.798045 1.490342 1.777682 1.368501 0.822008 0.267053 0.794202 0.107460 1.499345 0.867964 1.491427 -0.097215 1.533169 0.402921 0.270250 -0.257992 0.733165 0.362933 1.318893 1.077996 -0.215798 0.338811 0.219994 0.763092 0.618092 0.499119 0.751451 1.206091 1.662182 0.980493 1.134808 0.914764 1.670832 0.950703 1.641772 -0.118915 0.240632 1.010529 0.168161 0.110520 0.996952)

      9.999728 #r(0.000000 0.816321 0.637377 0.345148 0.370938 -0.276054 0.911607 1.500056 0.306062 0.790557 0.435222 0.904894 -0.191779 0.048392 0.194431 0.115956 1.667616 0.992921 1.656976 -0.052697 -0.117059 1.375805 0.940264 1.270518 1.293832 0.011597 0.625970 1.355481 1.224093 1.039601 0.449887 0.805739 0.950859 0.738520 0.174875 0.191457 -0.433487 1.473827 1.049203 1.269233 0.624622 -0.685355 0.429236 0.942447 1.442405 0.657046 -0.121011 1.211024 0.340089 1.400597 1.568255 1.012470 1.153465 1.450019 0.074731 1.166228 1.006182 0.717416 1.410198 0.328986 1.433746 0.699736 1.482788 1.837097 1.328917 0.778439 0.165472 0.752659 0.035502 1.456631 0.791084 1.409037 -0.237446 1.429494 0.422722 0.146817 -0.260727 0.839136 0.358089 1.270740 1.006772 -0.235207 0.256828 0.253288 0.716702 0.519351 0.455918 0.685843 1.184617 1.591454 0.861383 1.138751 0.863117 1.629288 0.841736 1.491610 -0.065444 0.127160 0.950055 0.171078 0.161369 0.979305)
      )

;;; 103 all -------------------------------------------------------------------------------- ; 10.1489
(vector 103 13.435972213745 #r(0 1 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 0 1)

	10.072606 #r(0.000000 0.775992 0.789071 0.551328 0.298530 -0.168268 0.810417 1.541024 0.478641 0.826848 0.407673 0.769783 0.052469 0.071330 0.252339 -0.003477 1.565238 1.042251 1.681717 0.063581 0.058867 1.442741 0.917343 1.448313 1.294486 -0.061724 0.478951 1.132882 1.128620 1.082449 0.123678 0.578486 1.003285 0.918654 0.241363 0.278868 -0.414912 1.418211 0.927244 1.134797 0.489863 -0.664481 0.529310 0.940119 1.393533 0.416277 0.044802 1.197865 0.283028 1.514978 1.590639 1.159829 1.236485 1.237279 0.109313 1.090962 1.341243 0.602478 1.179629 0.285726 1.482652 0.648833 1.308230 1.743441 1.346535 0.727031 0.061582 0.907076 -0.185896 1.479865 0.775766 1.389852 -0.161651 1.518832 0.594834 0.022777 -0.099476 0.851631 0.289254 1.413652 0.958286 -0.309988 0.125895 0.222920 0.633318 0.584266 0.503924 0.660246 1.182087 1.319466 1.213616 1.220516 0.662413 1.589230 0.875855 1.466144 0.036061 0.139801 0.986962 0.226038 0.202950 0.978447 0.999923)
	9.939365 #r(0.000000 0.794367 0.781191 0.495064 0.495230 -0.388009 0.971616 1.347277 0.328242 0.741267 0.530537 1.078181 -0.237622 0.107581 0.258589 0.255024 1.565355 1.278328 1.789249 -0.140007 -0.199710 1.294397 0.953960 1.338212 1.138392 0.017529 0.484971 1.300470 1.202522 0.969811 0.455432 0.750845 0.761123 0.668283 0.289374 0.280222 -0.329630 1.253548 0.930314 1.087111 0.685593 -0.730896 0.513015 0.942289 1.448130 0.624245 -0.099966 1.306897 0.278573 1.322888 1.648294 0.849613 1.245918 1.545777 -0.106941 1.147216 0.903444 0.450981 1.376132 0.256174 1.368394 0.763297 1.355029 1.779789 1.255780 0.812388 0.170237 0.940509 -0.017353 1.623185 0.693251 1.320359 -0.226935 1.435723 0.278225 0.247083 -0.427620 0.856951 0.463721 1.355469 0.897870 -0.255243 0.194551 0.144239 0.768570 0.690462 0.453432 0.766815 1.332179 1.485970 0.855947 1.311144 0.868609 1.737822 0.574654 1.449286 -0.052990 0.247284 0.755917 0.347662 0.133411 0.978837 1.128108)
	9.938814 #r(0.000000 0.794369 0.781179 0.494978 0.495207 -0.387960 0.971662 1.347297 0.328234 0.741307 0.530523 1.078218 -0.237594 0.107602 0.258606 0.255021 1.565400 1.278380 1.789238 -0.140020 -0.199735 1.294381 0.953983 1.338265 1.138336 0.017495 0.485041 1.300450 1.202504 0.969724 0.455427 0.750931 0.761094 0.668250 0.289329 0.280179 -0.329611 1.253574 0.930366 1.087063 0.685627 -0.730833 0.513027 0.942251 1.448095 0.624348 -0.100009 1.306860 0.278533 1.322852 1.648329 0.849694 1.245891 1.545774 -0.106935 1.147152 0.903447 0.451005 1.376091 0.256221 1.368425 0.763333 1.355003 1.779765 1.255779 0.812329 0.170135 0.940480 -0.017373 1.623180 0.693238 1.320324 -0.226936 1.435741 0.278227 0.247217 -0.427735 0.856978 0.463701 1.355420 0.897766 -0.255204 0.194551 0.144265 0.768579 0.690419 0.453417 0.766802 1.332201 1.485955 0.855932 1.311069 0.868635 1.737826 0.574603 1.449298 -0.053025 0.247307 0.755792 0.347674 0.133379 0.978880 1.128060)

	9.936450 #r(0.000000 0.693644 0.706899 0.533961 0.430990 -0.357687 1.008502 1.374702 0.412678 0.741797 0.480081 1.019998 -0.130973 0.053049 0.311034 0.176361 1.575930 1.070088 1.721818 -0.094212 -0.064284 1.475356 0.919353 1.359786 1.249341 0.013083 0.514667 1.199770 1.229977 1.008921 0.437274 0.710316 0.870077 0.789348 0.187900 0.290913 -0.370061 1.358992 0.912977 1.233039 0.528258 -0.736479 0.451532 0.908453 1.426336 0.514161 0.001487 1.299314 0.308671 1.371317 1.605556 0.910902 1.236094 1.469478 -0.163740 1.081131 1.027298 0.436227 1.399959 0.293762 1.463416 0.759976 1.365407 1.783410 1.210381 0.856808 0.150643 0.958655 -0.052444 1.555663 0.803912 1.301037 -0.234888 1.489758 0.433564 0.214734 -0.174858 0.935477 0.468519 1.406960 1.062581 -0.199662 0.290782 0.285152 0.771353 0.684526 0.389441 0.762788 1.291542 1.444611 0.892838 1.229118 0.775000 1.690738 0.620913 1.533937 -0.049548 0.336829 0.889832 0.374353 0.184623 1.007735 1.061825)
      )

;;; 104 all -------------------------------------------------------------------------------- ; 10.1980
(vector 104 13.330215043333 #r(0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0)

	10.124244 #r(0.000000 1.622675 1.706946 0.969141 1.395974 1.097698 0.150298 1.207570 1.449278 0.836769 1.526696 -0.147627 1.089028 1.314193 0.833408 0.265551 0.958522 0.397626 0.447242 0.837858 1.676927 0.883730 1.604731 0.779720 0.388122 0.713835 1.704244 0.052983 0.837107 0.054588 0.549459 0.093126 1.768139 0.144405 0.937970 0.532416 -0.149569 1.622840 1.586484 0.686471 0.830291 0.095651 0.908595 0.259853 -0.301519 0.855324 -0.014912 0.748872 1.538644 -0.030037 0.020462 0.792578 0.531283 0.625746 0.346250 0.434570 0.703831 1.586850 1.489275 1.435865 0.300417 1.125540 0.355002 0.123270 0.728375 0.039493 1.718698 1.307117 0.118823 0.358408 0.405752 1.413026 1.454448 0.630369 0.900592 1.792896 1.090807 1.061221 1.814531 1.630768 0.510555 0.618481 1.214968 0.122072 0.455822 1.727623 0.073245 -0.177442 0.329678 1.542732 1.673278 -0.469931 -0.007785 0.142142 0.231493 0.623628 0.711468 0.673585 0.185009 1.333716 0.659875 0.472080 1.635059 0.745116)

	;; 103+1
	10.017665 #r(0.000000 0.745584 0.754703 0.591172 0.316730 -0.304771 0.899483 1.291576 0.545676 0.772500 0.260173 0.994469 0.010841 -0.025249 0.470119 -0.206891 1.625251 1.051634 1.804633 -0.290226 0.044365 1.520714 1.169280 1.579603 1.507492 -0.098599 0.554837 1.115406 1.434064 1.033197 0.173666 0.501633 0.832630 0.961445 0.155427 0.671127 -0.251235 1.186810 0.870334 0.942028 0.540752 -0.482588 0.541485 1.032711 1.176554 0.575710 0.196807 1.247991 -0.309114 1.373943 1.309961 0.661994 1.095118 1.475934 -0.067967 1.122540 1.395244 0.408007 1.356964 0.251346 1.416704 0.875598 1.007338 1.720110 0.906456 0.746887 0.314809 1.255942 0.123637 1.421756 0.602684 1.336186 -0.397992 1.545369 0.942007 -0.105531 0.032651 0.903727 0.429977 1.262458 1.203957 -0.177847 0.186686 0.130438 0.458904 0.322547 0.256233 0.884282 1.238120 1.393593 1.126188 1.032025 0.626466 1.697238 0.820645 1.808108 -0.040709 0.161290 1.012239 0.476207 0.102979 0.908021 1.239960 0.369493)
	10.017453 #r(0.000000 0.745577 0.754726 0.591226 0.316735 -0.304732 0.899502 1.291541 0.545628 0.772480 0.260199 0.994494 0.010830 -0.025236 0.470134 -0.206891 1.625282 1.051660 1.804596 -0.290274 0.044351 1.520736 1.169238 1.579583 1.507532 -0.098601 0.554891 1.115436 1.434077 1.033226 0.173646 0.501686 0.832596 0.961466 0.155369 0.671140 -0.251224 1.186790 0.870343 0.942036 0.540730 -0.482603 0.541428 1.032737 1.176541 0.575710 0.196818 1.248017 -0.309128 1.373931 1.309926 0.661951 1.095129 1.475952 -0.067947 1.122542 1.395225 0.407986 1.356975 0.251359 1.416747 0.875553 1.007359 1.720145 0.906470 0.746959 0.314821 1.255928 0.123650 1.421810 0.602637 1.336189 -0.398002 1.545393 0.941942 -0.105497 0.032645 0.903719 0.429973 1.262454 1.203968 -0.177843 0.186621 0.130389 0.458896 0.322543 0.256192 0.884272 1.238132 1.393568 1.126227 1.031989 0.626539 1.697275 0.820678 1.808099 -0.040685 0.161330 1.012238 0.476235 0.102962 0.907998 1.239960 0.369514)
      )

;;; 105 all -------------------------------------------------------------------------------- ; 10.2470
(vector 105 13.595993876506 #r(0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 1 0)

	10.169606 #r(0.000000 0.591462 0.235800 1.321672 1.356594 -0.405542 0.538022 0.615762 0.326243 1.062550 -0.153260 -0.031444 1.233243 1.770308 1.085997 1.514420 0.095655 1.000755 -0.065552 -0.053493 1.481942 0.777394 0.483679 1.419470 0.159850 -0.259703 0.126983 0.478035 1.178492 1.111834 1.075738 1.268063 0.962249 1.943997 1.083333 1.538989 0.307093 1.387414 1.941208 1.284189 -0.012780 1.356158 1.317824 1.095171 0.472030 0.459214 1.096373 0.477967 0.565821 1.566421 0.590639 1.381435 1.150189 0.197776 0.315906 0.587160 0.629501 0.853485 0.797405 -0.187739 1.489470 1.296970 0.273664 0.102171 1.749652 1.601370 1.902817 1.658081 0.403983 0.138955 1.356476 1.693746 1.125750 0.916183 1.246086 0.386904 -0.248158 0.148664 0.070783 0.819794 -0.019914 0.547099 0.323707 -0.046514 1.635194 0.435105 0.156523 0.390396 -0.277746 0.665321 0.200546 1.082837 1.059380 -0.041536 0.592565 0.634526 1.116414 0.039718 0.575393 -0.178156 1.655927 0.370318 0.615340 1.693958 1.282592)
	
	;; 103+2
	10.064945 #r(0.000000 0.682652 0.800210 0.421652 0.554062 -0.360055 0.792317 1.465481 -0.019712 0.697608 0.554698 0.858084 0.164354 -0.019234 0.162952 0.345627 1.621651 0.956217 1.656476 -0.303453 -0.187651 1.271041 0.778998 1.434856 1.150013 -0.072967 0.339790 1.321211 1.320212 0.949083 0.543303 0.516765 0.879307 1.039360 0.093945 0.385943 -0.388725 1.561230 1.166808 1.287025 0.753324 -1.134186 0.285245 0.840389 1.554768 0.666549 -0.096352 0.924158 0.213888 1.502858 1.582784 0.980705 1.341049 1.650316 -0.198796 1.508087 1.243789 0.381493 1.651510 0.258432 1.593643 0.607159 1.330584 1.752940 1.190114 0.752124 0.301833 0.828769 -0.217850 1.553288 0.804465 1.268535 -0.132772 1.463816 0.052920 -0.009087 -0.356015 0.855416 0.196469 1.378625 1.182028 -0.269272 0.104746 0.083642 0.567469 0.929739 0.150765 0.641904 1.229939 1.430161 0.787585 1.158738 0.883860 1.662494 0.756218 1.382603 -0.075116 0.404544 1.158715 0.557851 -0.000464 1.098986 0.925246 -0.557344 -0.464571)
	10.063561 #r(0.000000 0.681917 0.800545 0.422200 0.553031 -0.358791 0.792275 1.464678 -0.019974 0.698355 0.554660 0.858955 0.164181 -0.019183 0.163011 0.345816 1.622067 0.956173 1.657341 -0.303259 -0.187543 1.270627 0.778435 1.434875 1.149544 -0.073515 0.340352 1.321088 1.319472 0.949179 0.543646 0.516189 0.877323 1.039058 0.094178 0.386382 -0.389059 1.561917 1.166614 1.288418 0.753780 -1.134975 0.286121 0.840573 1.554402 0.666717 -0.096764 0.924388 0.213118 1.501876 1.581562 0.980168 1.340301 1.650719 -0.197635 1.506340 1.243795 0.380830 1.653721 0.258877 1.593702 0.606867 1.330583 1.752876 1.189965 0.751133 0.302075 0.827786 -0.217646 1.553498 0.803802 1.267631 -0.133418 1.463956 0.053990 -0.008952 -0.356111 0.855322 0.196092 1.378596 1.181998 -0.269211 0.103217 0.082299 0.566694 0.929139 0.150334 0.640354 1.229212 1.430106 0.787460 1.158173 0.885012 1.662401 0.755054 1.382697 -0.076381 0.402460 1.158400 0.558679 0.000097 1.098492 0.924207 -0.557968 -0.463825)
      )

;;; 106 all -------------------------------------------------------------------------------- ; 10.2956
(vector 106 13.200031373463 #r(0 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)

	10.233770 #r(0.000000 0.055119 -0.050942 1.221658 1.069634 0.969833 -0.120088 0.537260 0.774846 1.097793 1.607343 1.125046 1.248849 0.110938 0.000911 -0.176700 1.224234 0.974172 0.258380 0.044520 0.328839 0.706861 1.491508 0.262253 0.850888 0.129635 0.528138 0.085967 1.206179 1.203105 -0.212392 0.552998 1.277370 0.069273 1.300991 0.395491 0.052184 1.017350 -0.139116 0.060719 1.223876 0.765705 1.643712 0.809882 1.480192 -0.160266 1.133315 0.396498 1.706614 0.389700 1.530945 1.033706 0.669577 0.953867 0.549025 0.735362 1.230749 1.732990 0.576594 1.599366 0.250495 1.206074 1.016404 1.623424 1.318513 0.223760 1.354914 1.140942 0.138240 0.414002 0.134404 1.756706 -0.015032 -0.196090 0.317193 0.119056 -0.492220 1.081019 0.025882 -0.092539 1.764132 1.357709 0.458311 1.060374 1.019483 -0.126097 0.259596 0.137076 0.020444 0.418031 0.040745 0.523959 1.133024 0.593829 1.429205 1.802013 0.365195 0.248492 1.498863 -0.344913 0.359725 1.657142 1.374238 1.289802 -0.217105 1.333949)

	;; 105+1 = 103+3
	10.179981 #r(0.000000 0.771266 0.798162 0.574106 0.509046 -0.454532 0.722646 1.382152 0.188134 0.639741 0.416137 0.934678 0.075406 0.041008 0.256970 0.360043 1.637722 1.021983 1.620165 -0.251506 -0.173651 1.345505 0.774331 1.358020 1.178455 0.048273 0.190944 1.354709 1.390135 0.925530 0.585598 0.586646 0.925457 0.930732 0.084979 0.308249 -0.510277 1.508378 1.202203 1.312776 0.712836 -1.217347 0.291576 1.028994 1.475323 0.702825 -0.072470 0.840094 0.187818 1.417625 1.468715 1.001276 1.223171 1.644290 -0.182504 1.499121 1.198948 0.364839 1.508784 0.234796 1.494133 0.521892 1.439752 1.612444 1.042789 0.871256 0.313132 0.872711 -0.384633 1.449440 0.726706 1.126102 -0.147870 1.347148 0.064771 0.128024 -0.342719 0.813697 0.226743 1.421921 1.020328 -0.362916 0.016145 0.192478 0.585608 0.784156 0.021533 0.652162 0.963185 1.437016 0.624122 1.232038 1.005325 1.412486 0.735986 1.181102 -0.186937 0.322568 1.015044 0.519059 0.114269 1.113254 0.730024 -0.587578 -0.573285 0.170710)
	10.179541 #r(0.000000 0.771216 0.798169 0.574042 0.509021 -0.454539 0.722595 1.382180 0.188162 0.639751 0.416025 0.934627 0.075422 0.041033 0.257004 0.360076 1.637659 1.021990 1.620175 -0.251486 -0.173697 1.345557 0.774305 1.358151 1.178428 0.048243 0.190927 1.354610 1.390083 0.925624 0.585662 0.586630 0.925417 0.930772 0.084986 0.308253 -0.510266 1.508313 1.202180 1.312826 0.712764 -1.217280 0.291519 1.029037 1.475318 0.702806 -0.072479 0.840059 0.187882 1.417657 1.468702 1.001289 1.223142 1.644299 -0.182528 1.499144 1.198899 0.364912 1.508768 0.234745 1.494112 0.521884 1.439753 1.612428 1.042749 0.871259 0.313122 0.872774 -0.384718 1.449386 0.726766 1.126118 -0.147831 1.347158 0.064750 0.128074 -0.342700 0.813748 0.226859 1.421859 1.020298 -0.363011 0.016155 0.192420 0.585619 0.784178 0.021472 0.652147 0.963182 1.437033 0.624162 1.231941 1.005289 1.412507 0.736078 1.181129 -0.186935 0.322466 1.015056 0.519117 0.114263 1.113370 0.730072 -0.587500 -0.573316 0.170672)
      )

;;; 107 all -------------------------------------------------------------------------------- ; 10.3441
(vector 107 13.224366750161 #r(0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1)

      10.273899 #r(0.000000 1.285870 0.722685 1.695642 1.789973 0.495199 0.001511 0.648393 1.565696 0.756830 0.421656 -0.184836 0.187469 1.381401 1.501800 0.551266 1.079110 0.129360 0.283265 1.059394 -0.217105 1.758613 1.156467 0.305791 0.018881 1.709795 1.386465 1.716357 0.543922 -0.077767 0.376814 1.917356 1.703183 0.375846 1.314995 1.049255 -0.015490 1.182770 0.105614 1.125738 1.580574 0.196175 0.043631 0.176951 1.523484 1.504279 0.024743 0.233174 0.051990 0.885176 0.485127 0.978870 1.366279 1.841166 1.225239 0.599047 0.937430 1.422432 0.950869 1.195765 0.360876 1.187450 1.491233 0.274262 0.123358 1.276789 1.498182 1.151090 1.495794 1.385360 0.511524 1.320969 1.040843 1.323508 0.526850 1.486006 0.358172 -0.084804 0.784722 0.263761 0.033435 1.669885 0.179635 1.097636 0.771172 0.674320 0.095788 1.426496 1.763465 0.078301 1.972016 1.520526 1.431005 0.272982 0.550020 1.118797 -0.453975 1.686563 1.286924 1.481496 1.458102 0.550556 0.115818 1.002355 0.493193 0.718245 1.621218)

      ;; 105+2 = 103+4
      10.254504 #r(0.000000 0.484824 0.645093 0.484448 0.357958 -0.306335 0.781266 1.722221 -0.020523 0.622664 0.475686 0.971485 -0.081828 -0.221731 0.023546 0.160724 1.699779 0.877022 1.571254 -0.219251 0.072417 1.464813 0.631200 1.379055 1.117758 -0.133773 0.232309 1.351525 1.269800 0.970127 0.241075 0.257607 1.000838 1.216076 0.053471 0.232020 -0.359907 1.509993 1.179694 1.054758 0.827030 -1.018435 0.149201 0.847612 1.252524 0.455297 0.005091 0.938550 0.112714 1.231427 1.569945 0.646140 1.306245 1.559100 -0.235326 1.424717 1.086220 0.226398 1.287381 0.237597 1.562146 0.408642 1.239694 1.521425 0.873908 0.443864 0.122845 0.794034 -0.670208 1.201438 0.763367 1.019610 -0.305283 0.938173 0.223614 0.151118 -0.405317 0.789769 0.185696 1.705170 1.080972 -0.394578 -0.084190 0.462333 0.451070 0.732074 -0.196625 0.882445 1.029212 1.285492 0.753537 1.256080 0.793604 1.367897 0.491589 1.208211 -0.307546 0.448608 0.892802 0.520730 -0.067668 1.081080 0.866532 -0.521852 -0.524522 -0.470753 -0.243216)
      10.250733 #r(0.000000 0.483912 0.644703 0.485457 0.358095 -0.305666 0.780949 1.722379 -0.020746 0.621961 0.474887 0.971799 -0.081593 -0.221790 0.024110 0.159431 1.699382 0.876421 1.571715 -0.219801 0.072621 1.464672 0.630752 1.380382 1.117163 -0.134137 0.232594 1.352288 1.269630 0.968806 0.240910 0.258155 1.001406 1.216432 0.053369 0.232245 -0.359904 1.509850 1.180087 1.054981 0.826371 -1.018830 0.149841 0.846847 1.251712 0.455512 0.004303 0.938417 0.112890 1.231211 1.569892 0.646448 1.305537 1.558830 -0.235146 1.425032 1.086297 0.226783 1.288076 0.237137 1.561589 0.408735 1.240009 1.521331 0.873481 0.444503 0.123500 0.794180 -0.670582 1.202161 0.762118 1.019326 -0.305420 0.938305 0.222385 0.150427 -0.405430 0.790658 0.185984 1.703676 1.080860 -0.394708 -0.083973 0.462509 0.451296 0.730919 -0.196866 0.882952 1.029031 1.285788 0.753984 1.256801 0.794497 1.368238 0.490612 1.208438 -0.307623 0.448339 0.892856 0.519789 -0.067328 1.081789 0.866642 -0.521116 -0.524606 -0.471314 -0.243671)
      )

;;; 108 all -------------------------------------------------------------------------------- ; 10.3923
(vector 108  13.534 #r(0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 1)

	10.312988 #r(0.000000 1.293654 0.754043 1.806542 1.109001 0.766775 1.436021 1.627340 0.528605 1.806494 1.181378 0.013554 0.353388 0.092480 0.431618 0.200495 0.904126 0.741464 0.675051 -0.110957 1.146773 1.810641 0.552983 0.275055 0.835876 1.123930 -0.182193 -0.339155 0.645146 0.163632 0.868047 1.269556 0.830686 1.219557 1.665806 1.060039 1.944315 -0.011848 0.365415 0.718256 0.624511 1.571990 0.113371 0.572031 1.797961 0.876379 0.068642 0.072119 0.553161 0.329387 0.545574 0.337595 1.647194 1.034042 0.468339 1.774314 0.240404 1.846502 1.142528 1.223731 0.832499 0.428931 0.643890 1.257704 1.085969 0.643637 0.429070 0.971966 0.109095 0.689833 0.417898 1.804672 1.346983 0.150026 0.404292 0.575881 1.441149 0.533070 -0.177095 0.298641 0.921545 1.086883 0.410704 0.849120 1.518187 1.874571 0.517824 1.242109 -0.053714 0.834159 0.276990 1.956354 1.765190 1.537622 1.530954 -0.106766 1.325278 -0.071959 1.045056 0.533410 0.699958 0.068418 0.070057 1.204618 1.620552 1.072110 1.372120 0.848823)

	;; 103+5
	10.360302 #r(0.000000 0.551674 0.684121 0.443843 0.328287 -0.382856 0.742347 1.553271 0.100438 0.588495 0.564972 0.863601 0.125393 0.057318 -0.071985 0.287901 1.600093 0.971407 1.645285 -0.209518 -0.381267 1.448278 0.742196 1.379192 1.304893 -0.172568 0.425075 1.236069 1.368334 0.874268 0.672828 0.415281 0.726658 0.862117 0.109198 0.219337 -0.244418 1.532842 1.163405 1.346937 0.978237 -0.950485 0.281930 0.924923 1.513033 0.583840 -0.415504 1.174086 0.188477 1.112313 1.589792 0.899949 1.271439 1.538926 -0.265428 1.460427 1.161403 0.396214 1.349937 0.135151 1.479429 0.399645 1.649047 -0.124860 1.280184 0.464971 0.347605 0.600275 -0.139067 1.236147 0.852840 0.641047 -0.107564 1.211289 -0.076869 0.330831 -0.638295 0.950296 0.142049 1.425529 1.211169 -0.161554 0.129139 0.243541 0.647760 0.753493 0.224072 0.686712 1.456555 1.430413 0.867180 1.349952 0.357062 1.696651 0.627351 1.338698 0.006006 0.515509 1.152554 0.609264 -0.153967 1.271052 0.732750 -0.451261 -0.621127 -0.054294 -0.063774 0.634645)
	10.344504 #r(0.000000 0.554177 0.686603 0.442963 0.330457 -0.383506 0.740825 1.555486 0.100826 0.588922 0.565702 0.862938 0.127067 0.056740 -0.069899 0.290177 1.602316 0.972504 1.644788 -0.208407 -0.383569 1.450051 0.741146 1.377401 1.305410 -0.168825 0.428117 1.236110 1.367696 0.873985 0.672701 0.413093 0.726218 0.861358 0.109862 0.215210 -0.240642 1.530834 1.163848 1.343976 0.980851 -0.948698 0.281660 0.923527 1.516228 0.584674 -0.414222 1.172500 0.191678 1.113538 1.586368 0.900806 1.270747 1.537958 -0.265025 1.461949 1.160460 0.395671 1.350152 0.136808 1.485285 0.401359 1.654233 -0.123106 1.280806 0.466879 0.345278 0.597993 -0.139606 1.239204 0.851600 0.644182 -0.102185 1.210948 -0.076698 0.332547 -0.640955 0.952129 0.142937 1.428164 1.214644 -0.163426 0.128350 0.239573 0.645480 0.752936 0.225706 0.687169 1.460909 1.432454 0.869137 1.348779 0.361743 1.699109 0.623957 1.337938 0.001013 0.515906 1.149085 0.609013 -0.152564 1.271041 0.737876 -0.454840 -0.623700 -0.054225 -0.061354 0.631795)
      )

;;; 109 all -------------------------------------------------------------------------------- ; 10.440306508911
(vector 109 13.496821304096 #r(0 0 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0)

	10.432370 #r(0.000000 0.222737 0.395964 0.267704 0.984627 0.196896 1.257313 -0.049947 0.063508 1.503629 1.207170 0.259470 1.634989 1.732463 0.102120 1.779072 -0.448069 1.030982 -0.170238 0.241134 1.050790 1.545206 1.217799 1.632326 -0.260618 1.981321 1.563052 0.646224 0.963725 1.195450 1.382468 0.912278 -0.055446 -0.043084 1.544497 1.444807 0.819657 0.741044 0.122396 1.518758 -0.047192 1.432176 0.150062 1.445372 1.689041 1.538858 1.607305 0.672865 0.037321 1.002894 0.706157 0.845104 0.402627 1.438914 1.038104 1.050343 0.380185 1.252881 -0.144926 -0.130041 -0.022885 1.740880 1.268140 -0.038596 0.221618 0.937959 1.603605 0.465293 -0.010315 0.708519 1.255289 0.623840 0.892628 0.632806 0.245713 1.831669 -0.020202 0.561348 0.735902 1.121505 0.850852 0.147905 1.162108 1.085140 0.352699 1.043580 0.226572 1.785966 0.379633 0.873437 1.384309 1.785370 1.080206 1.256403 1.169325 0.672865 1.444061 0.325194 0.278183 1.165719 -0.193709 1.182201 0.138301 0.079081 1.231522 0.798589 -0.014107 0.372822 1.050722)
      ;; [checked]

      ;; 110-1
      10.317140 #r(0.000000 0.466349 1.223037 -0.048547 0.323977 1.203657 1.367719 0.187630 0.657819 1.251362 0.086519 0.614105 1.466130 0.119399 0.944664 1.740988 0.506084 1.149516 -0.030954 0.628514 1.494005 0.524832 1.717562 0.517597 1.425941 0.137206 1.081399 0.061277 1.144121 0.221716 1.237433 0.317276 1.420766 0.500184 -0.036811 1.170497 0.081161 0.970515 -0.023715 1.079773 0.402574 -0.076358 0.951794 0.085641 1.507539 0.981921 0.150846 1.328708 0.618279 0.035311 1.211298 0.994117 0.364832 0.177592 1.691178 1.236486 0.735313 -0.167267 1.196100 0.966444 0.565143 0.158981 1.675120 1.645837 1.195019 1.267396 0.458918 -0.062222 -0.191658 1.389608 1.410277 1.396420 0.888634 1.096165 0.607965 1.202499 0.534216 0.611126 -0.033770 -0.109171 -0.080915 -0.138588 0.061623 0.262473 0.091042 -0.019937 0.028635 0.201372 0.434309 0.265176 0.227450 0.679082 0.941635 1.249687 1.479264 1.715302 -0.073877 -0.121298 0.329766 0.557230 1.127078 1.604542 1.610922 0.215699 0.843190 1.390034 1.611440 0.159691 0.162556)
      10.316139 #r(0.000000 0.467860 1.225582 -0.051091 0.323359 1.199983 1.366975 0.187719 0.660883 1.253225 0.082708 0.616737 1.474208 0.120695 0.946148 1.740641 0.509628 1.149625 -0.031684 0.627981 1.494201 0.523906 1.719545 0.517678 1.423044 0.134403 1.080799 0.058887 1.146126 0.223450 1.240782 0.320888 1.420488 0.499238 -0.036895 1.166877 0.079242 0.965835 -0.026305 1.082043 0.407016 -0.078901 0.951307 0.084236 1.509812 0.984128 0.155672 1.326788 0.624829 0.033701 1.214113 0.999905 0.359963 0.181048 1.698251 1.226178 0.741043 -0.169162 1.197122 0.969420 0.565193 0.157309 1.679759 1.648950 1.194633 1.269799 0.462660 -0.066040 -0.191739 1.394509 1.412861 1.398929 0.890176 1.092218 0.605306 1.201780 0.531418 0.616650 -0.032708 -0.104746 -0.085490 -0.136596 0.060249 0.261684 0.098136 -0.024191 0.030064 0.203361 0.438227 0.265314 0.225969 0.675420 0.938390 1.248614 1.479216 1.714123 -0.073635 -0.128780 0.326731 0.554524 1.126561 1.604426 1.604094 0.214665 0.842457 1.393251 1.611608 0.158085 0.161986)
      )

;;; 110 all -------------------------------------------------------------------------------- ; 10.4881
(vector 110 13.592092514038 #r(0 0 1 0 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1)

      10.443826 #r(0.000000 0.966857 -0.310939 0.754018 -0.215289 0.050408 1.345912 1.407669 0.917300 1.537339 0.464664 1.377382 -0.129707 1.562018 0.873176 0.378480 1.188634 1.002593 1.467403 -0.157591 0.611052 1.240086 1.200021 0.642960 0.011727 1.278266 0.757206 1.221576 1.173971 1.148607 0.352945 0.591698 0.569729 0.204560 1.805523 0.091751 0.494475 0.741755 1.173490 0.125853 1.836232 0.189233 1.047389 0.359034 0.299905 1.335669 1.331935 0.866342 1.429328 0.175988 0.321575 0.808716 0.418347 0.305766 
0.587213 0.859103 1.233827 1.612185 0.649515 1.232962 0.438531 1.088539 1.160206 1.276056 0.991705 0.605889 1.920272 1.294151 0.591700 0.477186 -0.114311 0.103729 0.053546 1.057780 1.113226 0.935069 0.869987 0.585069 1.193799 0.314064 1.564843 1.009796 1.434593 -0.061294 0.394207 1.540076 0.463315 1.070060 1.005570 -0.247697 1.209164 0.032912 1.882456 0.617912 -0.419949 0.119714 0.033254 -0.149035 1.146172 0.301556 1.043038 0.611637 1.119274 -0.185496 1.474180 0.910726 0.869288 0.008729 1.113223 0.605574)

      ;; 109+1
      10.387950 #r(0.000000 0.515686 1.264891 -0.055069 0.324088 1.179085 1.335788 0.136489 0.919154 1.188155 -0.141610 0.717958 1.358218 0.093185 0.896015 1.671807 0.471790 1.141052 0.051579 0.537490 1.459698 0.584651 1.830808 0.363032 1.369938 0.000274 0.907004 -0.093829 1.224177 0.475784 1.246547 0.352307 1.450525 0.675832 0.013928 1.051336 -0.056690 0.739815 -0.043085 0.988473 0.181872 -0.198536 1.207807 0.272700 1.535978 1.102951 0.131450 1.223792 0.690160 0.142129 1.227746 0.844209 0.420668 0.245746 1.521870 1.240517 0.759658 -0.189023 1.110249 0.975685 0.561038 0.208456 1.726728 1.762213 1.410558 1.390253 0.568141 0.009314 -0.066588 1.510186 1.490948 1.223995 0.684559 1.083791 0.423654 1.233083 0.433267 0.557294 -0.196449 -0.046355 -0.048752 0.047230 -0.047134 0.493004 0.400752 0.312416 0.075458 0.155296 0.421062 0.311827 0.162606 0.700352 0.907002 1.326783 1.485723 -0.152238 -0.031436 -0.145811 0.279371 0.397448 1.049233 1.455768 1.607980 0.104646 0.721954 1.211206 1.533891 0.073983 0.190426 0.414118)
      10.384532 #r(0.000000 0.497058 1.308854 -0.040087 0.317842 1.212991 1.348869 0.169218 0.937322 1.141868 -0.161541 0.702285 1.374915 0.105577 0.895118 1.715852 0.486357 1.126045 0.027516 0.506764 1.422714 0.578087 1.785847 0.360577 1.340809 0.040639 0.924986 -0.064845 1.218475 0.441481 1.282493 0.367747 1.417112 0.662713 0.020057 1.075916 -0.019298 0.721943 -0.067674 0.989188 0.221610 -0.166666 1.205634 0.245282 1.512389 1.116780 0.133433 1.209361 0.683941 0.136270 1.207963 0.840404 0.407464 0.237523 1.553628 1.290834 0.738111 -0.201487 1.118700 0.992136 0.530099 0.232821 1.709001 1.753916 1.400184 1.373110 0.591245 -0.001719 -0.097997 1.485341 1.510549 1.267389 0.699366 1.037211 0.446472 1.249648 0.436481 0.541104 -0.183563 -0.029851 -0.044651 0.058473 -0.046411 0.519596 0.324425 0.295881 0.020130 0.121258 0.421385 0.343422 0.175010 0.744278 0.928241 1.278265 1.460120 -0.158640 -0.046458 -0.164552 0.259068 0.355794 1.089478 1.431301 1.606926 0.103582 0.653958 1.133151 1.513113 0.087404 0.126034 0.426687)
      )

;;; 111 all -------------------------------------------------------------------------------- ; 10.5357
(vector 111 13.80813938144 #r(0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1)

	10.489680 #r(0.000000 1.276377 0.968620 -0.218445 1.901880 0.088071 1.832261 1.338375 0.312772 1.516596 -0.040044 1.173079 0.061551 1.259985 1.326413 -0.075796 1.430603 0.457729 0.555673 0.169939 0.778858 0.499517 1.015059 1.507495 0.252622 0.024778 0.982934 -0.060048 0.808349 1.306234 -0.213685 0.893109 1.680180 0.816232 1.412440 1.447865 1.309405 0.967681 0.468074 1.167299 -0.294730 0.516281 1.115680 1.346378 1.503302 1.329509 0.069846 0.507313 -0.050602 1.169163 1.172511 1.329654 1.283831 1.273536 0.082962 0.472668 1.944396 -0.083515 1.629124 1.133239 1.648857 0.792610 0.954204 1.052081 0.877455 0.393129 1.388896 0.794997 1.052606 1.611060 1.743638 -0.167971 0.888631 0.570983 1.576402 0.843125 0.114093 0.127173 -0.133155 0.386550 0.090826 -0.017777 0.548430 0.313331 0.380367 1.607846 1.086331 0.772909 1.643444 0.182619 1.863239 1.234660 1.568659 0.555853 0.450573 1.731233 0.287714 1.462361 1.635622 0.921500 0.450553 1.230974 -0.314374 1.516211 0.633822 0.309849 1.238687 0.080817 0.340326 0.819921 0.108053)

	;; 112-1
	10.443480 #r(0.000000 -0.037648 1.480547 0.898464 0.849030 0.715984 0.623417 1.093452 1.045921 0.246543 -0.344784 0.997605 0.429765 1.643868 1.074256 0.709084 1.236163 1.022832 0.593800 1.797589 1.639095 0.499474 0.451589 0.525734 0.819269 1.059245 1.215835 0.300337 0.312343 0.508727 1.809376 1.802285 0.733765 0.697253 0.213017 0.226942 0.966882 -0.054080 1.879864 1.400510 1.357810 0.290115 0.291026 1.461469 1.516948 0.034933 0.486567 0.403300 0.540306 0.175821 0.605359 0.053443 -0.120390 0.105172 0.600333 0.664197 1.296750 -0.152576 0.244035 0.980125 0.718707 -0.396109 0.441995 0.857389 0.411314 0.615877 0.959296 0.472542 0.178066 1.504140 1.379940 1.172606 -0.073019 1.778815 0.168644 0.842220 -0.533009 0.218109 1.118845 -0.068508 0.820652 0.991755 -0.019081 1.121993 1.252324 1.508966 1.128293 0.270315 0.609971 -0.037115 1.065942 0.157780 1.138199 0.066912 1.242092 -0.087703 0.391351 0.761091 0.405427 0.623899 1.599600 0.333353 -0.321760 0.806575 1.571941 1.193797 1.308207 1.479299 1.022704 -0.056211 1.366886)
      )

;;; 112 all -------------------------------------------------------------------------------- ; 10.5830
(vector 112 13.719 #r(0 1 1 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0)

	10.459590 #r(0.000000 -0.062913 1.592216 0.942127 0.779122 0.819196 0.718354 1.051311 1.122277 0.289276 -0.312849 0.932738 0.364926 1.651917 1.193754 0.735359 1.259741 0.983056 0.504666 1.898067 1.619072 0.449638 0.460210 0.529471 0.685535 0.885439 1.297728 0.246636 0.353836 0.474674 1.786116 1.844574 0.794031 0.522576 0.168364 0.225941 0.884728 0.029172 1.770209 1.576812 1.352123 0.112130 0.389134 1.458224 1.532633 -0.027079 0.404717 0.274263 0.478667 0.228414 0.618491 0.032636 -0.068031 -0.092335 0.583363 0.722295 1.283590 -0.207344 0.372473 0.858879 0.815320 -0.324439 0.478159 0.803167 0.466456 0.633813 0.914568 0.438946 0.113725 1.518872 1.409010 1.227714 -0.134104 1.718626 0.277412 0.813327 -0.439158 0.260660 1.183284 -0.118611 0.754421 1.157336 0.232930 1.195932 1.264381 1.427453 1.112389 0.316426 0.581550 -0.107354 0.998672 0.153435 1.101697 1.916684 1.183525 -0.016743 0.301725 0.815282 0.398182 0.676231 1.536900 0.451259 -0.254624 0.791021 1.692791 1.255094 1.233704 1.361151 1.046040 0.024905 1.319507 0.390306)
      )

;;; 113 all -------------------------------------------------------------------------------- ; 10.6301
(vector 113 14.027848738379 #r(0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 1 1 1)

      10.600374 #r(0.000000 0.803646 1.150583 -0.063719 0.153874 1.101937 1.517661 1.839236 0.205434 0.503789 1.408027 1.282481 0.272193 0.581489 0.335632 0.191891 1.772311 1.188767 0.099798 1.108690 0.011443 -0.134966 0.851026 0.685097 0.180285 -0.598894 0.447561 0.453948 1.859577 0.373971 -0.017010 1.368747 0.811506 1.286383 1.607236 0.428535 0.456478 0.425986 0.560105 1.702212 1.615194 -0.029581 1.141022 0.404596 0.679875 1.483164 0.383858 0.334137 1.078889 1.358586 1.100321 0.206891 -0.260760 1.245372 1.320253 -0.104904 0.095400 0.153720 1.818561 0.632022 0.857521 -0.124243 1.123425 -0.152970 0.639127 0.101388 0.775543 0.547622 0.403455 1.168990 1.099889 1.089210 1.061140 1.095647 -0.008863 1.297497 0.125060 1.432503 0.841141 0.967915 1.177416 0.211122 0.724975 0.094432 1.035737 1.190949 0.605535 -0.311727 1.252767 0.699524 1.428815 0.329899 0.934047 0.582587 0.113129 0.668360 0.786133 0.103091 0.745732 1.809761 0.414589 0.231740 -0.023699 1.470163 1.649059 1.087085 1.691589 1.869557 0.611645 1.538351 0.985815 1.244743 0.786305)
      
      ;; pp:
      10.533209 #r(0.000000 0.701701 1.023037 1.805117 0.325103 0.864669 1.301988 0.041817 0.605545 1.212149 1.794798 0.682259 1.361354 0.200642 1.040014 1.570001 0.413916 1.135956 1.836914 0.609510 1.482300 0.433561 1.396354 0.242061 1.189941 0.064290 0.924650 1.865499 0.844070 1.972890 1.045011 0.019512 1.010788 0.256118 1.454283 0.372006 1.414933 0.757156 1.833026 0.854510 0.058898 1.301933 0.794807 0.059810 1.092848 0.343912 1.857250 1.216439 0.367607 1.585969 1.093436 0.524265 1.847968 1.349059 0.839561 0.495981 1.801236 1.298227 0.638863 0.266374 1.658935 1.480658 0.907119 0.639357 0.037985 1.986216 1.525743 1.288722 0.717261 0.704091 0.182223 0.044649 1.629714 1.819647 1.366848 1.330078 1.172022 1.015716 0.897536 0.806098 0.193895 0.422839 0.374579 0.235069 0.423986 0.463374 0.446056 0.493571 0.177728 0.437229 0.621846 0.665477 0.619012 0.807147 1.289974 1.297164 1.517281 1.924928 0.144210 0.370826 0.244142 0.591610 0.749322 1.350513 1.818547 -0.017393 0.517731 1.113988 1.244052 1.823099 0.067707 0.517248 0.930474)

      ;; 112+1
      10.576527 #r(0.000000 -0.099725 1.731869 1.126572 0.894565 0.787291 0.763373 1.116837 1.193937 0.158815 -0.328224 1.005844 0.228474 1.576738 1.262088 0.726943 1.268236 1.028150 0.589551 1.934756 1.609372 0.549105 0.446947 0.675880 0.714883 0.715628 1.363097 0.197217 0.353490 0.498917 1.784841 1.858473 0.777450 0.430951 0.142623 0.145377 1.039521 0.058101 1.806559 1.621009 1.395572 0.126961 0.400552 1.407730 1.420143 0.113046 0.482937 0.384809 0.357336 0.283000 0.705514 -0.045003 0.046604 -0.167904 0.589381 0.672696 1.241252 -0.116645 0.444533 0.866902 0.717018 -0.308546 0.397419 0.905566 0.584026 0.513164 0.877715 0.340382 0.028422 1.468619 1.404513 1.266203 -0.129199 1.813800 0.484278 0.806396 -0.359344 0.323726 1.188865 -0.113226 0.736080 1.212752 0.152030 1.358239 1.256305 1.492197 1.073162 0.176415 0.460366 -0.046759 0.938493 0.111495 1.045740 -0.030211 1.265442 0.071430 0.331346 0.715146 0.333258 0.829360 1.647336 0.578653 -0.323225 0.799001 1.641979 1.340856 1.121452 1.538434 1.235479 0.162729 1.417493 0.473155 0.256349)
      )

;;; 114 all -------------------------------------------------------------------------------- ; 10.6771
(vector 114 13.847382931726 #r(0 1 1 1 1 1 0 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 0 1)

      10.628224 #r(0.000000 0.615672 0.948130 0.747004 0.833637 0.289537 1.854717 0.930205 1.803295 1.161499 -0.674663 0.075654 -0.069447 1.150337 -0.219431 0.096417 1.741068 -0.016217 1.826914 -0.308775 0.152833 0.789042 0.803929 0.462314 0.626523 1.267262 0.400780 0.962101 1.687986 0.905206 0.268457 0.651715 0.114771 1.475643 0.044755 0.228029 0.514674 0.188213 -0.185396 1.589097 0.877857 -0.230405 1.243228 1.194822 1.559225 1.498045 0.808593 -0.017518 1.442649 1.211002 1.811223 0.625459 1.384771 0.613911 0.308197 1.431371 1.357215 1.098185 0.214395 1.664025 1.740860 1.399478 0.567842 0.816563 1.298643 1.214440 0.204096 1.160510 1.171795 0.002888 0.712001 0.408799 0.129596 0.526919 1.018226 1.540087 1.326981 1.269312 0.284234 1.408491 0.614427 1.282597 0.201606 0.407636 1.049940 -0.424432 1.688488 0.609780 -0.014895 -0.443393 1.774217 1.192149 -0.353060 1.542744 1.597711 0.829765 0.335469 0.940418 1.687078 -0.157090 1.505994 0.110351 1.069331 0.286269 -0.198482 1.240708 -0.041616 1.268700 0.079424 0.525193 1.036769 0.352036 1.456021 -0.218427)

      ;; pp: 
      10.517948 #r(0.000000 0.513150 0.874296 0.883964 0.730138 0.492200 1.910349 0.914831 -0.079055 1.078332 -0.626669 0.137543 -0.184379 1.218055 -0.394114 -0.038192 1.661163 0.020764 -0.078690 -0.096176 0.170832 0.906574 0.889519 0.505117 0.670269 1.228477 0.365822 0.917034 1.728829 0.934323 0.199610 0.715554 0.056223 1.583731 0.085811 0.136885 0.354627 0.123817 -0.315376 1.492556 0.991663 -0.233639 1.201411 1.218512 1.753756 1.719460 0.679044 -0.197393 1.570682 1.193787 1.873756 0.557014 1.432466 0.588568 0.309382 1.651394 1.357542 1.190693 0.264093 1.733513 1.676510 1.179474 0.616239 0.734925 1.107757 1.048586 0.066290 1.132123 1.205852 -0.090603 0.754355 0.838256 -0.013038 0.421890 0.968163 1.389079 1.284090 1.323690 0.432981 1.323326 0.730210 1.395732 0.109710 0.246664 1.169930 -0.449126 1.545991 0.365384 0.076032 -0.458822 1.876049 1.124853 -0.255218 1.423147 1.451143 0.955505 0.281503 0.928421 1.983790 -0.130994 1.684131 0.142847 1.010533 0.452692 -0.386536 1.218551 -0.132981 1.371320 0.120371 0.410528 1.083879 0.496636 1.350228 -0.127680)
      )

;;; 115 all -------------------------------------------------------------------------------- ; 10.7238
(vector 115 14.359978160099 #r(0 0 0 0 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 0)

	10.651124 #r(0.000000 0.205632 0.521043 1.123267 0.039976 1.837568 0.645276 0.444856 1.235953 1.614101 0.576705 -0.032817 0.913102 0.971540 0.123207 0.744147 0.392163 1.071292 -0.098894 1.183735 0.447902 1.029195 1.008083 1.241655 1.280374 0.851598 0.236819 1.816127 -0.109787 0.735910 1.359965 1.270732 -0.070459 0.794811 1.337404 0.069925 0.240715 0.381811 0.943512 0.073841 0.371201 0.917351 1.527618 1.440973 1.203354 1.349081 1.416186 1.496910 0.596478 1.312074 0.317957 1.177389 1.248077 0.233191 1.529687 -0.003737 0.662497 0.466830 0.261424 0.663736 1.797196 0.273538 -0.239584 0.345229 -0.159975 1.144743 1.462922 0.849868 0.439184 0.064973 -0.068494 1.400482 0.060773 0.986838 0.519130 0.531890 1.046288 1.063229 -0.449183 0.987082 0.473670 0.722114 1.227775 0.954889 0.100062 1.512033 0.697126 0.308149 0.914574 -0.044099 1.083776 1.037385 0.163494 1.178786 0.886753 1.659086 0.598578 0.720776 -0.009109 0.443556 -0.035564 0.124043 0.119757 0.888837 0.603645 0.075938 0.648026 1.218123 0.325603 0.011855 -0.390969 1.523387 0.517639 0.461045 0.382395)

      ;; 114+1
      10.621744 #r(0.000000 0.519128 0.786784 0.918158 0.650178 0.457293 1.964414 0.915637 -0.037992 1.187864 -0.612331 0.073197 0.008576 1.197804 -0.364310 0.047620 1.612311 0.098163 -0.054077 -0.087970 0.039413 0.986129 0.969342 0.451170 0.648283 1.253012 0.349815 0.949459 1.680558 0.960988 0.220312 0.666892 -0.069695 1.584459 0.070346 0.154295 0.414900 0.222762 -0.268103 1.413909 0.961497 -0.210113 1.203087 1.172411 1.792543 1.742069 0.706989 -0.208070 1.562128 1.211841 0.011662 0.482644 1.455971 0.642656 0.264522 1.637721 1.461442 1.154901 0.149110 1.871307 1.810194 1.307963 0.530941 0.678563 1.057540 1.204932 0.204765 1.173394 1.102820 -0.082769 0.639150 0.715081 -0.172130 0.444439 1.033638 1.431627 1.223005 1.352911 0.473564 1.345853 0.701386 1.441324 0.065510 0.263153 1.148218 -0.395379 1.422829 0.339640 0.186555 -0.374702 1.783978 1.192276 -0.175028 1.327174 1.534754 1.031453 0.306400 0.980338 0.017668 -0.122396 1.685264 0.121507 0.952038 0.457874 -0.310268 1.350976 -0.129566 1.387678 0.182170 0.404390 1.132228 0.552993 1.477216 -0.117535 0.087972)
      )

;;; 116 all -------------------------------------------------------------------------------- ; 10.7703
(vector 116 14.175787507646 #r(0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 0 0 0 1 0 1 1 0)

	10.666895 #r(0.000000 0.794041 0.130396 1.155449 0.575356 1.670182 1.438030 0.802411 -0.073881 0.612189 1.011030 0.243247 1.424701 1.360754 0.519915 1.303274 0.114440 0.486440 1.248641 -0.062831 1.818237 1.003329 1.774020 0.995383 0.217514 0.236196 0.918414 0.251978 0.240543 1.203872 1.193015 1.546847 0.668684 0.276657 0.720261 0.041331 0.124685 1.052830 -0.470877 1.036338 0.454033 1.208580 1.059685 0.252464 0.910634 -0.469687 1.282886 1.260566 1.714177 0.148852 1.558794 0.117249 1.208112 1.206944 1.379709 1.280227 -0.397300 1.912745 1.609055 0.469506 1.102260 0.207876 1.456855 1.808614 1.436770 0.080959 1.197513 1.183739 1.574767 0.068412 1.162064 0.609158 0.566278 1.029997 1.123257 -0.210554 1.006729 1.012851 0.184672 1.531574 1.788773 1.233395 0.609493 0.767948 1.753741 1.423961 0.953617 0.300031 0.940377 0.324215 0.472402 0.042965 0.104811 0.217444 1.091263 1.136923 1.660947 0.519559 1.199475 -0.360436 1.523678 1.224456 -0.014998 1.278905 -0.475457 -0.462757 0.028990 0.974163 1.009397 0.422500 0.343570 0.466660 0.909671 0.746952 -0.297506 0.078048)
      )

;;; 117 all -------------------------------------------------------------------------------- ; 10.8167
(vector 117 14.136 #r(0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1)

	10.740323 #r(0.000000 1.376267 1.204802 1.617264 0.013985 1.562933 1.297010 -0.381289 0.175690 0.812406 0.271907 -0.572032 0.505210 1.569967 0.483045 1.266493 1.587294 0.516881 0.600232 0.990644 0.302416 1.037870 1.417076 1.853643 -0.147420 0.890223 1.567662 0.981809 0.815941 1.608390 -0.281550 0.201337 1.556451 1.125175 -0.236163 1.445336 0.258466 0.600771 0.570165 0.048623 0.131732 0.130088 0.167451 1.924952 -0.030799 0.148010 1.615329 0.361965 0.025922 1.817684 1.449080 1.328054 1.692177 0.082231 0.922069 0.868297 0.602630 -0.302067 1.498947 0.796296 -0.211597 1.912831 0.263824 1.087462 0.264795 1.339326 0.746964 1.555264 0.991573 0.792728 0.572734 0.831900 1.561482 0.487864 1.625032 1.584684 1.155708 1.141107 1.673417 0.421621 -0.187613 1.264593 1.627549 0.823098 0.254093 0.097500 0.358549 1.789940 1.103526 1.081236 0.794597 1.136333 1.473853 1.388624 -0.112319 0.798455 -0.090384 -0.176678 0.782426 -0.241572 0.802635 1.296656 0.310053 1.464029 0.628323 1.034158 1.019782 -0.078897 0.005414 1.234988 0.557243 0.357637 -0.491315 0.727622 1.220297 0.073271 0.925087)
      )

;;; 118 all -------------------------------------------------------------------------------- ; 10.8628
(vector 118 14.207115029287 #r(0 1 1 1 1 1 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0)

	10.789998 #r(0.000000 -0.175913 -0.143823 0.018273 0.027771 0.767311 -0.171214 1.636246 0.351281 1.388337 0.882351 1.707573 0.469183 0.078893 1.085758 0.618150 0.277129 0.703491 1.759709 -0.452169 1.251866 0.357896 0.724274 0.269975 1.838904 1.530293 1.426834 1.312699 0.647676 1.426356 1.595332 0.060341 0.690735 0.318521 0.226388 0.557313 0.682546 0.405400 0.629229 1.956450 1.295086 1.263226 1.531833 -0.446064 1.088083 -0.430622 1.100111 0.930366 1.309892 0.353356 1.791502 1.255481 1.229378 1.253262 1.406532 0.024314 1.063085 1.088221 0.123383 1.238746 1.005923 0.642418 1.110925 0.453476 -0.290616 1.496832 1.287503 0.244996 1.530267 0.834163 0.976178 0.556214 0.154839 1.049337 1.096181 0.549254 -0.047077 0.951697 1.030491 0.147772 0.888048 0.978379 -0.017946 1.704759 1.894288 0.751630 1.629711 1.581497 1.015790 1.546094 0.769995 1.519488 -0.226811 0.116498 -0.232287 0.274508 1.259352 1.098443 1.128583 0.216589 1.343006 0.117206 0.662844 -0.110291 1.010752 0.251673 1.029907 -0.274450 1.835049 0.199877 0.646328 1.080725 0.210236 1.055491 1.898124 0.072310 0.796446 1.191135)
      )

;;; 119 all -------------------------------------------------------------------------------- ; 10.9087
(vector 119 14.502624011553 #r(0 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0)

      10.894037 #r(0.000000 0.630386 0.843125 1.285949 0.340650 -0.017357 0.327019 1.384996 1.081793 1.397782 0.680727 0.599720 0.760758 1.651799 1.943215 0.601150 0.438753 0.220032 0.283706 0.321338 1.848806 -0.818805 1.279239 0.233383 -0.265065 0.149488 0.866113 1.211455 -0.153192 1.086507 -0.117739 0.108345 0.296077 0.924788 0.407609 0.257469 1.108157 0.337516 1.501434 -0.160734 0.937661 1.194914 0.677862 1.064411 -0.083066 0.280209 0.164734 0.604351 1.488726 0.546557 -0.173942 0.258452 -0.144704 1.931749 1.121694 0.070973 1.246077 0.433607 -0.015989 1.447158 1.307009 0.290513 1.032586 0.483509 0.866614 0.896091 0.118763 0.703456 1.160811 -0.272718 1.618947 0.922379 0.186934 0.444686 0.391527 -0.170445 0.686201 0.072390 -0.083273 0.261424 1.315326 1.343146 -0.078550 0.581799 0.100158 0.342044 0.531455 0.823995 0.311378 0.398507 -0.067564 1.021721 0.099971 0.375472 1.694822 -0.129069 0.760774 0.760279 0.907128 1.373425 1.265414 0.699858 -0.214864 -0.228584 1.101084 1.533737 1.209100 1.477560 0.508584 0.989498 0.862450 0.271802 1.549833 0.881136 1.017209 0.041014 1.240632 1.019564 1.718786)

      ;; pp:
      10.835933 #r(0.000000 0.654099 1.035661 1.681354 0.271205 0.793039 1.296335 0.060400 0.653112 1.232942 1.881379 0.620355 1.199841 0.014260 0.823834 1.413032 0.189484 0.947478 1.588848 0.403300 1.280378 0.215388 1.137801 1.956237 0.732861 1.657436 0.792204 1.789188 0.703767 1.598762 0.539735 1.541253 0.421443 1.469357 0.779053 -0.021286 1.026341 0.083226 1.233425 0.357509 1.441485 0.752264 1.858411 1.012419 0.073105 1.341491 0.748507 0.322726 1.533912 0.715880 0.027861 1.454725 0.694006 -0.082536 1.358750 0.823835 0.158492 1.802363 1.289166 0.871603 0.288280 1.653699 1.258131 0.754564 0.197129 -0.135159 1.406727 1.305489 0.902560 0.505625 0.165621 1.980298 1.711088 1.181402 1.035732 0.515951 0.573196 0.077979 0.369360 -0.029664 0.027976 1.710591 1.639472 1.419449 1.489927 1.072898 1.080212 0.909135 0.903629 1.096948 0.947039 1.126463 1.358955 0.953854 1.137457 1.170488 1.431020 1.393091 1.493097 1.708464 0.028863 0.359918 0.447603 0.693507 1.013920 0.980939 1.193095 1.522944 -0.124582 0.421795 0.849849 1.081289 1.559178 0.036966 0.454552 0.747770 1.437228 1.496079 0.068555)
      )

;;; 120 all -------------------------------------------------------------------------------- ; 10.9545
(vector 120 14.534638752286 #r(0 0 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0)

	10.877907 #r(0.000000 1.760966 1.432317 0.661698 0.093764 0.677833 1.324379 0.560678 0.084000 1.893101 0.982568 0.231983 0.030976 1.869849 0.114160 0.803943 1.697252 0.187259 0.348967 1.325837 0.129934 0.628168 -0.292961 -0.172670 0.424548 1.491809 -0.230282 0.327899 -0.371234 1.709483 0.949653 0.922124 1.730156 1.323261 1.332457 0.313981 1.342414 0.100580 0.697678 0.026744 -0.054235 1.341652 -0.009876 1.698348 0.248931 -0.183551 1.470018 1.710913 1.251473 0.727247 1.872729 0.011341 0.025061 0.694946 1.531659 0.478715 1.097259 0.657341 1.219034 0.633776 0.382770 0.377028 0.092620 0.800796 0.434789 0.301288 0.942251 -0.118601 -0.116547 1.180657 1.270834 0.986907 0.237837 0.780073 1.628870 -0.280374 -0.194405 0.622013 0.090032 1.411166 0.490814 -0.298299 1.291149 1.730249 1.587675 1.193266 0.285035 0.236562 1.437795 0.582458 1.521211 0.605547 0.877830 1.441130 1.061898 0.936396 1.257893 0.016398 -0.126771 0.102714 1.392810 1.183106 1.832099 1.740994 0.232560 0.367779 0.656921 -0.130561 0.093991 0.079826 0.694300 1.076720 1.076648 -0.154506 1.074489 -0.219932 0.141670 -0.212932 0.458505 1.362796)
      )

;;; 121 all -------------------------------------------------------------------------------- ; 11
(vector 121 14.184466362 #r(0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)

	10.924906 #r(0.000000 1.021993 1.334449 0.689448 0.491891 0.317117 0.185100 1.316740 0.942417 -0.055518 1.467945 1.216575 0.460144 1.613483 1.346938 0.351666 1.534737 1.166463 0.663385 1.751743 0.887304 0.686057 0.353407 0.640903 0.247744 0.051185 1.683771 0.607042 -0.642997 1.586265 1.428130 1.293714 0.376348 1.687396 1.342115 1.114987 0.421788 0.173805 0.664896 0.744172 1.338635 0.611663 0.948619 1.727026 0.108093 1.757613 1.759583 0.684030 0.701845 0.897975 1.291554 1.678993 -0.010218 1.672340 1.419180 0.531998 1.055064 0.071044 -0.158722 1.660752 -0.273616 1.601063 0.212433 0.488138 0.674057 0.101023 0.258204 0.323292 0.370652 0.521650 1.206457 1.206236 0.768851 0.204856 0.771378 0.971274 -0.207666 0.711434 0.295654 1.831769 0.464965 1.896472 0.968538 0.024673 1.250922 1.351355 0.486851 0.833273 1.147617 1.669210 0.770997 -0.072413 0.463363 1.323688 1.050580 1.732192 0.819244 0.777660 1.040697 0.078135 0.787038 1.358361 0.700196 0.074501 0.587042 0.515371 1.216302 0.852496 0.581485 0.849691 1.814480 1.077357 0.162962 0.766524 -0.151640 0.240975 0.296067 0.314628 1.286198 0.210485 0.583580)
      )

;;; 122 all -------------------------------------------------------------------------------- ; 11.0454
(vector 122 14.536 #r(0 1 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0)

	10.949841 #r(0.000000 1.704153 0.121290 0.688837 1.244030 1.262068 -0.197896 0.413249 1.197451 1.272156 0.642587 1.292432 1.783982 0.043702 1.158291 1.164647 1.692639 1.493672 1.007369 1.436042 1.725774 0.880017 0.375925 1.616969 0.128447 1.149978 1.084930 0.463608 1.105848 1.530070 1.424718 0.719589 0.763768 0.288678 1.156946 0.691396 0.064365 0.469636 1.091974 0.426323 1.090313 0.491849 0.938048 1.656418 0.459182 0.976494 0.376276 1.451323 1.601769 -0.407170 0.538990 1.732338 0.050678 1.192103 0.536699 0.739148 1.592439 -0.026377 0.032581 0.995911 0.348311 -0.030558 1.293098 0.192261 0.610689 1.016189 0.912642 1.102218 1.291663 0.930392 1.417016 1.312774 1.826696 0.250091 0.993926 0.681381 0.628174 0.441959 1.489842 0.532045 1.179384 0.517873 0.125155 1.064841 1.980073 0.744857 1.235778 1.280286 1.634199 -0.058763 1.206383 1.265460 1.054717 0.853628 1.196638 0.872935 -0.314369 0.468836 0.081998 0.420778 1.325508 1.934649 1.587718 1.251054 -0.176641 -0.893762 0.381112 0.198904 0.283702 1.674181 1.521739 0.754893 1.659031 0.756575 0.235790 -0.129516 1.697508 -0.350053 0.868125 -0.095111 1.099831 0.951722)
      )

;;; 123 all -------------------------------------------------------------------------------- ; 11.0905
(vector 123 14.67458183944 #r(0 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1)

      11.089811 #r(0.000000 -0.095705 0.502046 0.843201 1.262416 0.051297 -0.136069 1.229943 0.769550 -0.394544 1.202311 0.030935 0.212789 0.180234 1.202646 1.847334 1.298798 1.298567 0.826116 1.899995 0.130966 0.229988 0.849236 1.354957 0.175337 -0.090289 1.376955 0.986456 0.858952 -0.348674 -0.073167 -0.218495 1.696358 1.036669 1.130688 0.308330 0.510630 1.786938 -0.105214 0.654929 1.564764 1.314058 0.677163 -0.213165 1.538085 0.616182 0.862650 0.165337 -0.034200 1.035704 0.813627 1.106006 1.740931 0.014126 1.052235 0.657556 1.858826 0.165758 0.630519 0.409633 -0.040211 1.543795 1.391268 -0.071463 1.608090 0.360070 -0.066709 0.298864 0.437480 -0.144723 -0.061475 0.229100 1.150525 0.049068 -0.178297 1.796933 1.253507 1.460767 1.254789 1.053122 -0.014640 1.158719 1.833281 -0.100606 1.043660 0.125118 1.383020 0.234098 0.814218 -0.263454 1.710640 0.541462 0.096383 0.540963 -0.022417 0.505975 1.860187 1.286017 0.269581 0.338845 0.988364 0.065927 0.952682 1.381585 1.156408 1.384314 0.622434 1.536785 0.876899 0.457680 0.787662 1.764741 0.741434 -0.166817 0.104157 0.779344 1.374068 1.055092 1.250202 1.254085 1.185506 -0.050283 -0.314919)

      ;; pp:
      11.016135 #r(0.000000 0.647630 1.074276 1.756268 0.251422 0.804135 1.421127 0.040524 0.665959 1.111755 1.848209 0.635476 1.226811 0.078653 0.744267 1.473903 0.238865 0.830996 1.602610 0.483888 1.291535 0.032720 0.918740 1.769630 0.682055 1.658606 0.644590 1.383351 0.360438 1.331009 0.396705 1.499558 0.394585 1.332297 0.284286 1.367163 0.697156 1.873754 1.072911 0.259822 1.429562 0.401628 1.434105 0.713387 0.052744 1.073687 0.172805 1.418890 0.502359 0.008598 1.451186 0.715950 -0.032063 1.332938 0.645483 -0.170523 1.375389 0.799087 0.277881 1.623936 1.051516 0.728226 0.326139 1.759949 1.287776 0.814001 0.247394 -0.079677 1.277221 1.247278 0.815434 0.548501 0.120625 1.806890 1.668828 1.491775 0.975860 0.670802 0.343501 0.107101 -0.116370 1.739084 1.782173 1.584916 1.517015 1.084964 1.270093 0.937194 1.142225 0.603049 0.902612 0.582213 0.697513 0.723238 0.854795 0.946568 1.173389 0.894182 1.104017 0.982296 1.332899 1.077929 1.505566 1.771677 1.766832 0.125556 0.284805 0.740017 0.785432 0.946551 1.254134 1.343675 1.825955 0.281285 0.688963 0.928919 1.510642 0.002528 0.243797 0.692027 1.356775 1.422418 -0.003671)
      )

;;; 124 all -------------------------------------------------------------------------------- ; 11.1355
(vector 124 14.607 #r(0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1)

	11.060270 #r(0.000000 0.155441 1.710148 0.675606 0.991885 0.930398 0.521431 0.244313 1.630742 0.168790 0.137270 0.000305 -0.043062 0.897696 0.964832 0.045064 0.425268 0.964217 1.290413 0.929170 0.235812 1.335949 0.057667 0.001006 1.068524 0.446791 1.393120 0.549817 1.466180 -0.642251 1.637204 0.595543 0.457077 0.355722 0.196249 1.437718 -0.302241 1.024336 1.392207 1.340742 0.398137 0.737820 0.315317 0.261053 0.730496 0.895111 0.489074 0.360451 1.441085 0.496392 1.486058 1.322042 1.007323 -0.126599 0.931744 1.784266 0.161232 0.306266 0.415406 0.681040 1.790701 0.980642 -0.005904 1.343074 0.136975 0.027551 -0.124807 1.525812 0.151673 1.852354 0.924568 1.280951 0.029602 0.736180 1.201925 0.667470 1.226105 0.326690 0.609507 -0.393588 1.467285 1.671123 1.358186 0.541731 1.122604 1.867616 -0.473631 -0.417534 0.660754 1.837680 1.546497 0.596764 1.110785 0.215660 0.434300 0.180279 1.110604 0.505631 1.274765 1.668673 0.193680 0.673308 0.543007 1.365849 -0.310522 0.237117 0.174423 1.731063 0.766964 0.281277 -0.402143 0.989963 0.637238 0.526844 0.787012 1.257855 0.717061 0.758671 0.882050 1.342356 0.626910 1.083549 0.608055 0.472324)
      )

;;; 125 all -------------------------------------------------------------------------------- ; 11.1803
(vector 125 14.985 #r(0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0)

      ;; 11.16794 
      11.160786 #r(0.000000 1.015332 1.208067 1.409127 0.622612 0.043137 0.789070 0.545823 0.370412 0.925346 1.157620 0.165772 1.424901 0.898702 1.656211 0.988303 1.801194 1.470568 1.745983 0.609307 -0.597689 0.731241 -0.142723 0.984230 0.073162 1.875752 0.335696 1.602183 0.142368 0.017160 0.448032 0.120103 0.041279 0.523055 0.073650 1.053879 -0.306921 1.513911 1.101021 1.602539 -0.121119 0.641316 -0.004631 1.595461 1.743817 0.418939 0.589672 1.179156 0.811957 1.197450 1.342788 1.287174 1.574681 1.241671 0.609625 0.929510 0.079585 0.612922 1.100363 0.431650 -0.459913 0.120058 0.264463 0.028955 1.140993 0.787792 1.007154 0.514281 1.114045 1.286846 1.241625 0.916235 0.449091 1.255016 0.869776 0.016192 1.421914 1.225032 1.302610 0.650162 0.956126 0.761196 -0.213826 0.222275 -0.426223 1.123082 0.506980 1.405113 0.081703 0.828457 1.262806 1.843366 0.399948 0.473729 -0.529905 1.215838 1.003418 1.687511 0.432881 1.055890 1.071502 1.087648 0.147867 -0.002533 0.317269 1.612891 -0.180768 1.003458 1.820527 0.761821 1.137143 0.352919 -0.090034 1.456553 0.819912 0.115658 0.246973 0.936701 1.319554 0.851128 1.479387 0.046130 1.488656 0.854373 0.867709)

      ;; pp.scm:
      11.105486 #r(0.000000 0.668250 1.004851 1.665604 0.270207 0.823031 1.317389 1.895775 0.442735 1.092420 1.706335 0.316469 1.053513 1.851731 0.426377 1.214568 0.111950 0.768130 1.567897 0.318224 1.096474 0.028789 0.851033 1.730934 0.518266 1.394840 0.485490 1.534760 0.346603 1.302654 0.195595 1.075240 0.149474 1.131730 0.186045 1.296000 0.352391 1.439364 0.663850 1.837274 0.958873 0.121068 1.316333 0.242865 1.517748 0.747235 1.882566 1.040766 0.534079 1.729417 0.993163 0.496721 1.811700 1.002981 0.317419 1.678987 0.959753 0.256596 1.817235 1.299690 0.756280 0.292629 1.822282 1.254136 0.905795 0.232927 1.675869 1.252625 0.924210 0.377830 0.081344 1.650592 1.565111 1.210398 0.823930 0.495597 0.170992 -0.097351 1.629713 1.238397 1.141529 0.804262 0.860680 0.603481 0.666502 0.428034 0.395443 0.132689 1.849680 0.035737 1.395931 1.824957 1.358060 1.651982 1.606952 1.718179 1.670215 1.887548 1.688422 1.844666 -0.292284 0.050366 -0.101906 0.075572 0.305815 0.606639 0.913420 1.030088 1.512470 1.549064 1.827384 0.007726 0.106419 0.461039 0.753337 1.221334 1.792974 0.097112 0.617097 1.170484 1.176316 1.664541 0.165974 0.635539 1.022624)

      ;; pp1:
      11.114689 #r(0.000000 0.681978 1.028261 1.706912 0.292133 0.848775 1.343922 1.911777 0.451105 1.069054 1.693074 0.301918 1.035579 1.825832 0.435611 1.230581 0.111624 0.750696 1.574421 0.321180 1.071098 -0.013053 0.852483 1.783026 0.524168 1.371392 0.475241 1.562570 0.337915 1.270461 0.221125 1.100498 0.123076 1.107894 0.160645 1.270692 0.306224 1.479440 0.658107 1.838424 0.945824 0.091726 1.332313 0.238983 1.552958 0.749521 1.839061 1.045392 0.486297 1.712081 0.982243 0.539957 1.767541 0.934362 0.293124 1.675620 0.993763 0.206674 1.792070 1.270778 0.729123 0.284390 1.801314 1.282266 0.918468 0.252050 1.650401 1.232066 0.903570 0.313672 0.087588 1.657912 1.543341 1.232872 0.839991 0.464849 0.196039 -0.147366 1.653544 1.258396 1.123045 0.770121 0.900031 0.618800 0.692026 0.397188 0.475351 0.152075 1.894219 0.030184 1.418582 1.854056 1.299662 1.631587 1.652019 1.730754 1.687797 1.916199 1.730490 1.823361 -0.277080 0.063403 -0.121338 0.021902 0.284828 0.586626 0.860176 0.999715 1.490642 1.510249 1.792225 0.008814 0.113621 0.391836 0.733891 1.237143 1.809005 0.128227 0.638952 1.175937 1.156619 1.663599 0.187027 0.654280 1.021025)
      )

;;; 126 all -------------------------------------------------------------------------------- ; 11.224972
(vector 126 14.67419786533 #r(0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0)

      11.145483 #r(0.000000 0.899293 0.378495 1.289186 0.777288 0.858338 1.619831 1.737202 1.951674 0.835017 -0.087625 1.707725 0.328507 0.828194 -0.110415 0.084984 1.000160 0.933659 1.329981 0.403112 1.465299 0.867776 0.736209 0.286670 0.614444 0.936369 0.873213 0.123325 0.103437 0.033532 0.337773 1.704277 1.195946 1.204920 1.015411 0.867778 0.772767 0.521662 1.281071 0.987342 0.207100 0.684428 0.579999 1.230109 0.833339 0.874869 1.325709 1.214223 -0.039340 1.273384 0.554903 0.324879 0.897065 0.122734 0.357179 1.405113 1.382262 1.052698 1.093027 0.696151 1.256101 1.113094 1.329670 0.549960 1.774690 1.419208 1.188823 1.415491 0.266597 0.476692 0.360990 0.613975 1.834829 -0.016278 0.893804 0.177235 -0.162182 0.465943 0.846924 0.105182 0.478317 0.762411 0.169998 0.509253 1.306498 1.829812 0.517679 0.137251 1.279904 1.030500 -0.049960 1.650399 1.720514 0.164442 0.994973 1.525343 0.937775 1.609285 1.534911 -0.677300 0.133781 0.129445 0.518965 -0.144758 1.037002 1.052666 0.841376 0.157786 1.034141 0.219735 1.379782 0.222272 1.298276 0.072801 0.604052 1.220954 0.022881 1.817683 0.809301 0.789103 1.114921 0.656136 -0.111384 0.132814 1.271527 0.712891)
      )

;;; 127 all -------------------------------------------------------------------------------- ; 11.269427
(vector 127 14.851 #r(0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0)

	11.176112 #r(0.000000 1.071888 1.248428 0.289874 1.246619 0.289572 1.760445 0.245569 1.154033 1.309416 0.081159 1.849794 1.710269 1.368867 1.052576 -0.398246 -0.001522 1.370275 0.292491 1.626710 1.166078 1.755696 1.227481 0.377631 0.354241 0.127104 0.305667 -0.167076 0.018149 1.234977 0.220914 0.373111 0.199191 1.136953 0.209502 1.631334 0.736118 -0.280026 0.637855 0.997502 0.069226 0.738973 1.836372 1.422035 0.641751 0.717645 0.227787 1.627490 0.896625 1.164185 1.181473 0.283052 0.793654 1.893617 0.958053 1.877395 0.211241 0.448741 0.465207 1.415492 1.261864 1.182640 0.217781 0.211053 1.936678 0.848219 1.690040 -0.183682 -0.275325 0.916325 0.426519 1.353568 0.171309 0.590049 0.503441 0.438773 0.014163 -0.062159 0.869887 -0.128424 0.144319 1.756020 1.717018 -0.046012 0.125572 0.279523 0.175456 1.083651 1.091291 1.212635 1.168385 1.392580 -0.189037 0.240170 0.866374 1.580620 1.749254 1.502399 1.243019 0.251600 -0.018231 1.414780 0.773115 0.067214 1.323483 0.617886 1.663914 0.351482 0.571589 1.123483 1.679985 0.501109 1.035832 1.346170 1.289512 1.663306 0.584848 0.500505 -0.031006 0.055228 0.131713 1.510949 0.309811 1.293736 1.414224 0.248635 1.517857)
      )

;;; 128 all -------------------------------------------------------------------------------- ; 11.313708498985
(vector 128 15.138 #r(0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1)

      11.309209 #r(0.000000 1.243323 0.073338 1.687189 1.124666 1.389841 0.847573 1.018728 0.290645 0.447958 0.152825 0.408946 1.554733 1.027824 0.742595 1.417320 1.174719 0.230635 0.137711 0.205770 -0.223930 -0.484352 0.868175 0.460794 0.073208 1.470166 -0.048840 -0.141098 1.057707 1.534980 0.337573 1.200647 1.372018 -0.041548 0.602859 1.849030 -0.103678 0.815675 0.107720 0.796671 0.027496 0.761821 1.113332 0.855622 0.650295 0.713381 0.490023 1.179238 -0.088446 0.282357 -0.437849 1.210715 1.321994 0.443637 1.300839 1.352381 -0.001933 0.442309 -0.088426 0.287664 0.126405 -0.108646 0.637631 0.580452 1.256195 1.182134 1.382836 1.180662 1.171900 0.353945 1.569554 0.076717 1.316852 1.092094 0.641656 0.578236 1.268290 1.296116 0.291194 1.287832 1.351802 0.877933 0.046043 0.135350 0.952936 1.137202 0.623256 -0.396801 0.327118 0.077316 0.800999 0.673083 1.387941 0.952139 1.436716 0.326423 0.697455 0.564179 1.047968 0.663414 0.327317 0.386236 0.415974 0.266450 1.112215 0.646830 0.208505 1.019398 -0.208967 0.964650 0.120229 1.347295 1.011374 1.053660 1.549663 0.688863 1.745386 0.772703 1.031951 0.182902 0.350269 0.873751 1.129081 1.610214 -0.035633 1.365829 0.190640 1.177284)

      ;; pp:
      11.210356 #r(0.000000 0.529477 1.092204 1.655320 0.240176 0.840083 1.290316 0.036113 0.414482 1.184815 1.733487 0.475904 1.226699 -0.054687 0.544000 1.373024 0.096261 0.605273 1.510542 0.229851 0.972933 -0.008717 0.768966 1.800241 0.536684 1.336088 0.309226 1.164728 0.254148 1.069819 0.021808 0.945032 -0.039508 0.972460 -0.067607 1.002895 0.197048 1.366967 0.351763 1.540663 0.648980 1.698360 0.730857 0.118485 1.274417 0.283223 1.327398 0.691807 0.012365 1.128647 0.533746 1.871605 1.252479 0.321809 1.476722 1.286815 0.557929 1.863054 1.365020 0.715719 -0.012609 1.699347 1.092581 0.354365 -0.098429 1.602411 1.106114 0.622866 0.186170 1.647857 1.109362 0.904818 0.566992 0.283406 1.734276 1.302248 1.135583 0.996099 0.637141 0.319233 -0.334659 -0.051454 1.363705 1.553533 1.027907 1.065457 0.795998 0.486251 0.704843 0.431262 0.496789 0.160271 0.268391 -0.277422 -0.064873 -0.149375 -0.202682 0.078495 -0.086833 -0.064332 0.234996 -0.109719 0.180200 0.196396 0.559877 0.436602 0.563596 0.942230 1.157161 1.450532 1.353287 1.969232 0.307428 0.330752 0.455679 0.656549 1.076389 1.439415 1.817226 0.185723 0.623808 1.021760 1.554273 1.872894 0.258818 0.595831 0.908779 1.816125)
      )

;;; 256 all -------------------------------------------------------------------------------- (16)
(vector 256 23.353 #r(0 0 1 1 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1)

	15.997488 #r(0.000000 0.925209 0.360087 -0.109255 -0.863041 -0.029912 -0.483289 0.303463 0.008649 0.031617 0.487041 0.145598 0.992492 -0.713096 0.834493 0.846857 -0.131376 0.542717 0.203811 -0.433766 -0.763755 0.238727 -0.473870 0.868120 -0.040586 -0.462669 0.740771 -0.227132 -0.000692 0.548464 -0.055270 -0.035150 0.172840 -0.630429 -0.054024 -0.934698 -1.031001 0.790052 -0.042240 -0.412997 -0.220043 -0.508562 -0.002888 -0.453454 0.339759 0.518676 0.788804 -0.251741 -0.227551 -0.779613 0.734751 0.789576 0.367904 -0.617440 0.581096 0.338718 0.846175 -1.028326 0.259730 0.848625 0.330154 -0.124923 -0.130656 -0.899763 -0.617228 0.785884 -0.310990 0.157588 0.054106 0.868737 -0.143871 -0.227180 -0.267827 -0.544386 0.833457 -0.192646 0.531361 0.900376 0.172583 0.028556 -0.603550 0.718142 -0.997946 0.928971 -0.598759 -0.564692 0.183693 -0.203720 0.320101 0.732178 0.707159 -0.345178 -0.790224 -0.362108 0.317265 0.458201 0.831535 -0.431642 0.893792 -0.522325 -0.951966 -0.916656 0.233541 -0.532295 -0.365198 -0.656087 -0.172799 -0.786128 -0.707188 0.943130 -0.849431 -0.253384 -0.006071 0.913388 -0.612860 0.748864 -0.097659 0.450043 -0.692859 -0.884034 0.489241 0.243506 0.522701 0.974734 -0.768569 0.798343 0.726708 0.380364 0.170048 0.841302 -0.054785 0.610401 -0.858315 1.073514 -0.296883 -0.115618 0.015515 -0.916509 0.161588 0.652650 -0.008712 -0.505409 -0.067911 0.429313 0.399063 -0.573262 0.915841 -0.103864 0.624139 -0.134372 0.295426 0.204203 -0.479147 -0.159602 0.734669 0.642734 0.736135 -0.448600 -0.458950 0.777967 0.430117 0.669953 -0.339677 -0.689474 0.053281 -0.192783 0.913617 -0.878687 -0.069834 -0.145159 -0.823861 0.329716 -0.294470 0.392295 0.367988 0.287467 -0.889937 0.108498 0.753099 -0.487972 0.879263 -0.711295 0.729063 -0.025027 -0.771617 0.605944 0.271222 0.007411 -0.020393 -0.014302 0.113553 0.177385 -0.916189 -0.023264 0.032699 -0.714380 -0.890488 0.792318 -0.352445 -0.636838 0.505157 -0.746916 0.517505 0.224781 0.219031 -0.868947 0.454389 0.941008 -0.592372 -0.021442 -0.833651 -0.129261 0.460929 0.851936 -0.513944 0.084364 0.670315 -0.849612 0.625818 -0.181003 0.557575 -0.773073 -0.289191 -0.114786 -0.181584 0.600972 0.053488 0.794901 0.364604 0.191088 0.638262 -0.049402 0.312362 -0.070807 0.780925 0.495453 0.069458 0.847189 -0.191235 0.133528 -0.011930 0.216808 -0.015570 -0.171022 0.292597 0.777578 -0.642052 -0.866010 0.781770 0.651970 0.854285 0.022232 0.692772 0.892370 -0.002656 0.427419)
      )

;;; 512 all -------------------------------------------------------------------------------- (22.627)
(vector 512 34.212551772691 #r(0 0 1 1 0 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1)

      ;; from (try-all :all 512 513 1.0491155462743 0.38189660798029) = 28.3830
	23.193557 #r(0.000000 0.399524 1.646843 1.351441 1.823025 1.171664 0.729762 1.252339 0.515366 0.097810 0.678860 1.897564 1.521972 0.077160 1.268239 0.901387 1.473972 0.667619 0.325795 0.891195 0.034697 1.747321 0.304383 1.443541 1.218449 1.726491 0.863719 0.680079 1.128978 0.311069 0.196787 0.556014 1.793127 1.682138 0.091227 1.306646 1.129016 1.728414 0.837183 0.599682 1.287968 0.345234 0.102947 0.801742 1.877781 1.640902 0.226585 1.396671 1.220080 1.697547 0.969679 0.798912 1.198292 0.544854 0.387407 0.843207 0.103104 0.019694 0.521433 1.661229 1.605311 0.102635 1.157349 1.118566 1.621512 0.723027 0.643827 1.145388 0.314572 0.219869 0.805329 0.006517 1.887267 0.542204 1.747666 1.567711 0.215067 1.350972 1.245790 1.775378 0.951723 0.849293 1.321284 0.601644 0.485751 0.980152 0.390476 0.169629 0.740840 0.138612 1.874833 0.431461 1.718986 1.629368 0.185469 1.331734 1.411703 1.891639 1.004555 1.106306 1.573401 0.791502 0.797704 1.330552 0.584117 0.488052 1.067741 0.317339 0.306746 0.813570 0.066066 0.099246 0.601862 1.795337 1.820144 0.357783 1.595461 1.579848 0.166240 1.466895 1.372961 1.975436 1.317740 1.164009 1.808486 1.102608 1.000643 1.677368 0.956636 0.852478 1.469074 0.760365 0.712295 1.292807 0.555832 0.598457 1.095907 0.430216 0.458751 0.920706 0.270682 0.325363 0.899970 0.173408 0.209294 0.791701 0.094244 0.099310 0.651989 0.010325 0.059977 0.633756 1.963936 1.969054 0.569597 1.790777 1.878600 0.394074 1.703161 1.833624 0.356313 1.832144 1.719691 0.364860 1.791309 1.591331 0.325750 1.506205 1.612715 0.346965 1.508845 1.699526 0.386824 1.730166 1.703816 0.326924 1.872117 1.631584 0.317289 1.789232 1.607605 0.374082 1.631752 1.631313 0.329336 1.648447 1.650306 0.278736 1.778750 1.729896 0.463903 1.802895 1.856258 0.641877 1.756090 1.948418 0.623347 1.897074 0.008893 0.584650 0.086280 0.140431 0.786527 0.276359 0.275548 0.890444 0.265676 0.359419 0.986176 0.297235 0.384001 1.124805 0.481466 0.539550 1.333854 0.750170 0.752600 1.511725 0.897055 1.008348 1.699392 1.038121 1.079651 1.845917 1.287855 1.140400 -0.023963 1.424874 1.286171 0.046406 1.501434 1.602452 0.321371 1.613120 1.908418 0.550743 0.056408 0.227804 0.949635 0.326223 0.264086 1.026683 0.610891 0.620381 1.372120 0.688350 0.735802 1.527568 0.943792 1.417684 1.984600 1.245909 1.375474 0.090665 1.720888 1.763305 0.482303 1.883338 -0.178312 0.672709 0.264609 0.438174 1.152965 0.399187 0.537181 1.442530 0.925288 1.039187 1.777755 1.171305 1.241651 0.077408 1.688521 1.746073 0.572899 -0.031503 -0.054512 0.780914 0.307130 0.377248 1.309947 0.620593 0.647805 1.391170 1.029083 1.242972 0.116208 1.541926 1.636274 0.424680 1.866792 0.180934 0.849061 0.502513 0.547097 1.479781 0.744568 0.922805 1.664208 1.208223 1.492285 0.310325 1.796293 1.840468 0.650666 -0.003684 0.367553 1.063204 0.897182 0.882506 1.810738 1.199687 1.212082 0.105635 1.548127 1.862122 0.788103 0.377315 0.334679 1.391247 0.571526 0.899589 1.716512 1.284574 1.499212 0.368896 1.983312 -0.072073 0.796638 0.291665 0.571920 1.379773 1.116573 1.278689 0.104734 1.567264 1.692617 0.700433 0.303656 0.546992 1.300072 0.627106 1.095583 1.891866 1.555661 1.482424 0.421620 -0.134218 0.292813 0.972962 0.668941 0.743333 1.620423 1.399574 1.499004 0.392218 1.901237 0.163106 1.106102 0.699633 0.986320 1.808714 1.394696 1.548913 0.474054 -0.027677 0.241989 1.194987 0.769790 0.950308 1.843451 1.415095 1.579444 0.593829 0.178033 0.440985 1.381496 0.829738 1.153720 0.108138 1.828197 0.001844 0.921711 0.414644 0.675207 1.622384 1.277034 1.537018 0.449889 -0.054593 0.361449 1.247168 0.802724 1.022726 -0.128510 1.566174 1.841023 0.681270 0.418525 0.594178 1.582797 1.100574 1.498480 0.655383 0.155173 0.411660 1.181526 0.925382 1.328843 0.200473 0.006382 -0.032565 0.991390 0.602529 0.861632 0.041638 1.598274 1.969261 0.977268 0.407970 0.890370 1.757901 1.546776 1.739700 0.530734 0.183300 0.478294 1.491451 1.214965 1.389695 0.474622 0.044001 0.456977 1.479471 1.191919 1.480834 0.363164 0.026157 0.326380 1.336734 0.979602 1.357294 0.319255 -0.203247 0.232685 1.294416 0.948903 1.261622 0.286100 0.092358 0.283080 1.307747 0.989432 1.460487 0.426459 0.073741 0.571242 1.354082 1.101710 1.376656 0.361569 0.296231 0.370466 1.428620 1.084242 1.395303 0.541609 0.189775 0.582146 1.678645 1.102096 1.654581 0.664775 0.425971 0.691471 1.780798 1.653163 1.949891 0.862761 0.598617 0.939898 -0.013960 1.746087 0.153754 1.148094 0.828305 1.259992 0.328347 0.016434 0.376838 1.474740 1.157589 1.534525 0.553645 0.312251 0.866668 1.864799 1.615591 0.009649 1.062077 0.859238 1.148430 0.325782 0.130284 0.468434 1.557339 1.318502 1.816657 0.825796 0.532150 1.028089 0.092303)
	)

;;; 1024 all -------------------------------------------------------------------------------- (32)
(vector 1024 54.490282136658 #r(0 0 0 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 1 0 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 1 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0)

       ;; from (try-all :all 1024 1025 0.0030465754082342 1.0966230312279) = 39.6408 -- starting point for next
	33.039411 #r(0.000000 0.217793 0.607931 0.967301 1.354927 1.688792 0.066020 0.465453 0.813538 1.195967 1.586820 1.919936 0.299575 0.725651 1.032687 1.433171 1.819098 0.244740 0.528317 0.952329 1.310902 1.725001 0.085841 0.510316 0.883137 1.295552 1.666836 0.117054 0.474142 0.872700 1.255713 1.736490 0.230501 0.606393 1.028728 1.384711 1.863816 0.246036 0.645348 1.117262 1.521884 1.949367 0.365316 0.819118 1.259784 1.743406 0.114681 0.574578 1.046246 1.450509 1.894899 0.336945 0.760564 1.253808 1.716849 0.137592 0.574609 1.042959 1.454824 1.936275 0.419190 0.895894 1.333121 1.844487 0.342502 0.853474 1.292439 1.765609 0.256321 0.692309 1.243113 1.739348 0.172472 0.653116 1.166058 1.631859 0.132258 0.625602 1.076819 1.598670 0.096980 0.577179 1.131695 1.647014 0.164193 0.685727 1.180440 1.702228 0.253302 0.776491 1.309535 1.816332 0.293105 0.852900 1.367077 1.898589 0.432535 0.975988 1.514584 0.043794 0.598139 1.166870 1.714281 0.266095 0.804942 1.357597 1.876090 0.428324 1.001268 1.559200 0.115044 0.618374 1.228782 1.804413 0.389816 0.962363 1.537898 0.140277 0.731613 1.282939 1.840202 0.414673 1.053184 1.588446 0.180107 0.790891 1.387213 -0.009395 0.568597 1.191263 1.801067 0.427802 0.974450 1.619591 0.210665 0.773393 1.392904 -0.016901 0.587123 1.244552 1.854155 0.531939 1.150600 1.768916 0.425159 1.016110 1.610621 0.256880 0.882893 1.538835 0.168686 0.850037 1.472174 0.113856 0.750967 1.406035 0.025255 0.666491 1.359993 -0.031664 0.678754 1.326832 0.026196 0.743883 1.382070 0.030677 0.675957 1.328756 -0.030041 0.654962 1.338458 0.006642 0.677619 1.397568 0.072976 0.783665 1.485790 0.155299 0.853843 1.533492 0.215188 0.953020 1.662973 0.324497 1.041673 1.733423 0.464213 1.243765 1.976367 0.647067 1.345559 0.012662 0.749316 1.489879 0.227914 0.990029 1.690002 0.448728 1.143221 1.859234 0.555390 1.286313 0.069809 0.857122 1.602468 0.322019 1.025459 1.824398 0.578707 1.342375 0.081518 0.784165 1.566385 0.361863 1.106400 1.887522 0.638616 1.404257 0.152091 0.938889 1.721031 0.472675 1.317728 0.043634 0.856009 1.629652 0.437257 1.252987 0.025923 0.794582 1.591058 0.358955 1.166057 -0.002682 0.789366 1.590794 0.386834 1.197846 -0.015623 0.838634 1.655025 0.464895 1.274773 0.058585 0.894215 1.742143 0.557596 1.374194 0.194745 1.055319 1.890167 0.712487 1.581920 0.405773 1.241666 0.042804 0.908599 1.766456 0.617833 1.493265 0.307493 1.185078 0.036343 0.890918 1.784268 0.650479 1.475522 0.339344 1.199572 0.068327 0.952306 1.802580 0.674951 1.547061 0.454334 1.314247 0.208419 1.097577 -0.012428 0.845084 1.764257 0.654064 1.576753 0.430900 1.360385 0.263013 1.142109 0.042247 0.938246 1.849738 0.741581 1.702585 0.626406 1.511517 0.417933 1.342045 0.316150 1.213121 0.129925 1.075504 -0.003643 0.933032 1.855128 0.813392 1.710572 0.687979 1.624093 0.550720 1.484789 0.449410 1.417809 0.352332 1.315385 0.258678 1.242081 0.191596 1.148327 0.128590 1.076998 0.033930 1.000429 0.021446 0.946529 1.911603 0.939668 1.905600 0.832070 1.835891 0.886734 1.814841 0.754215 1.792786 0.817776 1.802122 0.767172 1.771516 0.795570 1.799934 0.749664 1.758097 0.790279 1.789090 0.815718 1.817512 0.821594 1.856689 0.844107 1.876263 0.932131 -0.033027 0.954137 0.041708 1.057579 0.049376 1.112654 0.124479 1.141145 0.189700 1.275163 0.277220 1.352019 0.398622 1.416087 0.471721 1.586811 0.571617 1.636154 0.762022 1.797974 0.792648 1.906186 0.988600 0.048590 1.117019 0.191210 1.280035 0.315709 1.415404 0.523510 1.606178 0.659612 1.735274 0.864437 1.945756 1.038500 0.170782 1.263877 0.328664 1.441094 0.489608 1.619075 0.742578 1.862330 0.978201 0.057087 1.210985 0.315699 1.369242 0.526287 1.686926 0.800561 1.894467 1.020909 0.151248 1.280756 0.415349 1.596186 0.691380 1.812268 1.014468 0.168469 1.246068 0.390545 1.566257 0.763068 1.867617 1.029661 0.210896 1.365853 0.504713 1.668265 0.840178 0.022534 1.175174 0.314446 1.504725 0.644912 1.845437 1.051148 0.239535 1.418245 0.575431 1.755543 0.953544 0.111610 1.291718 0.538603 1.737364 0.920094 0.118883 1.329289 0.551068 1.736946 0.926920 0.119899 1.396472 0.622946 1.774495 1.009428 0.218937 1.460574 0.709308 1.920305 1.134568 0.362724 1.629463 0.871987 0.063242 1.265435 0.549715 1.760983 1.012786 0.268911 1.522067 0.763077 0.022908 1.247788 0.504920 1.737386 1.031185 0.261825 1.506968 0.798277 0.037126 1.317026 0.616309 1.881979 1.132622 0.426461 1.688910 1.015193 0.274225 1.537279 0.814374 0.149856 1.426047 0.681353 -0.011757 1.281532 0.621978 1.877128 1.198275 0.515804 1.781604 1.083809 0.389698 1.722708 1.042047 0.317721 1.608635 0.970703 0.267024 1.600821 0.938556 0.289874 1.584459 0.919633 0.284753 1.600381 0.933102 0.261783 1.593563 0.959453 0.292896 1.637129 0.988883 0.310816 1.649207 1.029681 0.428735 1.766336 1.074255 0.425825 1.799718 1.186541 0.578329 1.932767 1.284594 0.645241 0.041167 1.417411 0.762799 0.172464 1.567570 0.948839 0.309276 1.682672 1.082892 0.477564 1.843514 1.286204 0.670132 0.088133 1.474563 0.903587 0.268966 1.703975 1.091807 0.536262 1.919539 1.329738 0.736390 0.166515 1.568791 1.004973 0.446544 1.857922 1.311269 0.705281 0.113389 1.613060 1.013345 0.476671 1.865416 1.350997 0.757344 0.262328 1.668639 1.135990 0.558918 0.027836 1.482954 0.914355 0.405589 1.877877 1.360731 0.810998 0.261169 1.717993 1.198951 0.681506 0.179681 1.611818 1.116720 0.625715 0.079133 1.554344 1.057016 0.585836 0.021762 1.535703 0.980063 0.485380 0.023651 1.496565 1.028428 0.487728 0.020140 1.532761 1.069147 0.588821 0.060395 1.588111 1.115999 0.646374 0.167975 1.648612 1.193869 0.741882 0.253118 1.790842 1.314892 0.853281 0.414998 1.902434 1.497942 0.990639 0.539224 0.088219 1.622741 1.249411 0.768538 0.343660 1.876211 1.447300 0.997098 0.572570 0.125439 1.644200 1.256400 0.781270 0.404111 1.972536 1.519066 1.186994 0.692860 0.307855 1.854938 1.403699 1.042965 0.597213 0.196180 1.805940 1.398784 1.006898 0.632978 0.181333 1.843721 1.376232 1.022246 0.627057 0.282029 1.859980 1.453595 1.114534 0.674237 0.375415 1.952743 1.558682 1.184653 0.810882 0.444428 0.106739 1.741825 1.353026 1.026092 0.582251 0.277743 1.909713 1.508437 1.193737 0.825066 0.511191 0.176031 1.828730 1.506285 1.153197 0.831714 0.439990 0.170522 1.814214 1.446970 1.128077 0.779419 0.473478 0.119366 1.886969 1.516342 1.219164 0.893550 0.538641 0.258090 1.907636 1.650718 1.360545 1.059180 0.717874 0.414278 0.126132 1.813306 1.573338 1.212731 0.957830 0.622823 0.405985 0.047971 1.825807 1.472501 1.214098 0.947606 0.683963 0.437446 0.175854 1.851289 1.610406 1.357047 1.067661 0.887867 0.554044 0.356299 0.048031 1.779486 1.512616 1.305755 1.022671 0.791907 0.573078 0.247923 0.119906 1.758763 1.585160 1.362276 1.088615 0.895722 0.676468 0.417579 0.164979 0.011350 1.734305 1.546690 1.358415 1.118376 0.926783 0.705220 0.499448 0.315880 0.060118 1.859929 1.723958 1.477160 1.277193 1.104744 0.894346 0.689756 0.496369 0.300553 0.144892 -0.011520 1.749426 1.580379 1.412973 1.276473 1.000323 0.931770 0.729465 0.533414 0.419059 0.232436 0.058428 1.969516 1.749659 1.610372 1.410459 1.309106 1.065622 0.979337 0.814584 0.691674 0.530372 0.424815 0.245987 0.170699 -0.012271 1.879045 1.724963 1.634668 1.453532 1.447115 1.205718 1.100546 1.013892 0.909214 0.720956 0.667663 0.509508 0.398085 0.299597 0.141309 0.034226 1.956289 1.852003 1.769280 1.663148 1.617078 1.511929 1.436643 1.410262 1.252755 1.184206 1.076318 1.039369 0.873633 0.816231 0.737137 0.775666 0.640014 0.552292 0.523393 0.428824 0.414378 0.217133 0.262402 0.171984 0.134805 0.021929 -0.016668 -0.002532 1.951963 1.878249 1.806236 1.774365 1.771348 1.716161 1.642886 1.609487 1.620321 1.591158 1.518580 1.544276 1.464162 1.456414 1.419358 1.466609 1.458320 1.401454 1.399278 1.426924 1.401560 1.354162 1.404450 1.362904 1.311124 1.352591 1.363770 1.369722 1.388055 1.409894 1.360470 1.454066 1.459673 1.429927 1.441529 1.468345 1.425679 1.473974 1.493508 1.543234 1.585340 1.561861 1.660910 1.693672 1.740824 1.797921 1.806792 1.947948 1.869546 1.958885 -1.809691 0.050061 0.129496 0.155639 0.222149 0.330732 0.332881 0.439984 0.450928 0.497058 0.602728 0.660842 0.709316 0.790306 0.877580 0.936659 1.013168 1.033489 1.176399 1.283407 1.410743 1.421371 1.612205 1.634881 1.767582 1.841030 1.986537 0.040900 0.175181 0.251008 0.355412 0.463047 0.575760 0.756405 0.796567 0.934654 1.053898 1.201705 1.308357 1.442561 1.601781 1.682620 1.834403 1.974673 0.095088 0.213066 0.321956 0.432642 0.606311 0.752450 0.885724 1.060880 1.156449 1.343737 1.489563 1.604293 1.789993 -0.034383 0.172034 0.387110 0.514056 0.654408 0.867467 1.034492 1.235624 1.438767 1.575002 1.788990 1.943738 0.058572 0.291200 0.483921 0.638776 0.832612 1.050861 1.244085 1.359691 1.596226 1.736323 -0.038252 0.190511 0.356074 0.569407 0.813994 1.022213 1.253582 1.468846 1.662905 1.861495 0.114564 0.373869 0.577453 0.821773 1.098180 1.315326 1.545147 1.813394 -1.760253 0.188066 0.496257 0.708472 0.960343 1.163646 1.367710 1.703944 1.909640 0.175717 0.454540 0.705636 0.980211 1.195148 1.488818 1.733289 0.044144 0.287687 0.548395 0.800132 1.070146 1.361090 1.590773 1.900706 0.207641 0.451405 0.799749 1.114584 1.405580 1.699154 -0.017363 0.294048 0.624527 0.934607 1.198245 1.538180 1.866634 0.125428 0.487573 0.742561 1.066865 1.413340 1.684269 0.002780 0.341594 0.693237 1.047393 1.377687 1.696633 0.122200)
       )

;;; 2048 all -------------------------------------------------------------------------------- (45.254)
(vector 2048 89.570060996356 #r(0 1 1 0 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 0)

       ;; from (try-all :all 2048 2049 1.0476749041086 0.34832901677121) = 55.7655 start for next
	48.912580 #r(0.000000 0.406191 1.571222 1.324352 1.767953 0.979432 0.645316 1.072933 0.307523 -0.006830 0.429598 1.629742 1.321856 1.789090 0.948639 0.659472 1.185844 0.275840 0.043526 0.535787 1.608328 1.327933 1.861905 0.990752 0.754681 1.206977 0.305120 0.061328 0.581025 1.669710 1.452403 1.912822 1.065903 0.848067 1.271702 0.391351 0.211337 0.658611 1.785726 1.542707 0.009828 1.143314 0.894669 1.411239 0.518389 0.298753 0.797599 1.856758 1.670585 0.127417 1.235819 1.041104 1.493864 0.611105 0.418250 0.856199 0.023591 1.791596 0.243219 1.392118 1.182495 1.621162 0.815424 0.573950 1.045734 0.179846 -0.011740 0.397461 1.591356 1.377407 1.770896 0.992884 0.736888 1.216386 0.375958 0.093457 0.659235 1.799077 1.546913 0.035541 1.156106 0.949113 1.456680 0.580496 0.396636 0.839156 1.970011 1.764954 0.259631 1.402450 1.235513 1.665268 0.802889 0.612179 1.080194 0.243851 0.033698 0.524441 1.632459 1.472504 1.937992 1.081214 0.895527 1.392463 0.490775 0.298952 0.848041 1.940015 1.697128 0.254886 1.363141 1.185209 1.674161 0.754353 0.584453 1.124171 0.218773 0.062549 0.501841 1.721185 1.522306 -0.011264 1.118394 0.954685 1.439352 0.591738 0.371757 0.869250 0.042776 1.854684 0.328663 1.487720 1.303540 1.767044 0.926877 0.768318 1.234739 0.344224 0.148203 0.734719 1.848251 1.666347 0.165845 1.305628 1.131506 1.581607 0.773670 0.602498 1.032746 0.206676 0.025789 0.525359 1.697045 1.491236 0.006067 1.157340 0.978202 1.432630 0.633904 0.463727 0.915073 0.136775 1.934553 0.449219 1.608946 1.400864 1.903340 1.104467 0.913316 1.423138 0.563023 0.421698 0.906311 0.042618 1.884435 0.353035 1.528090 1.400284 1.860470 1.056296 0.879850 1.360318 0.548407 0.355386 0.843594 0.054287 1.917796 0.421397 1.573605 1.376465 1.903586 1.040984 0.912919 1.385171 0.528382 0.385365 0.914024 0.074561 1.958625 0.435783 1.533400 1.404863 1.940839 1.078533 0.957812 1.432858 0.604078 0.458623 0.957412 0.074668 0.021379 0.505128 1.645197 1.507154 0.028563 1.162070 1.067003 1.575471 0.748734 0.543707 1.108070 0.268942 0.110324 0.662470 1.828468 1.624640 0.187065 1.331570 1.147382 1.736105 0.865091 0.726072 1.245124 0.416319 0.264801 0.752834 1.965567 1.806660 0.355442 1.521647 1.342631 1.872277 1.048328 0.925565 1.417457 0.605412 0.503590 0.988848 0.155690 0.061738 0.517338 1.734308 1.628685 0.110629 1.328278 1.135437 1.680377 0.900316 0.685554 1.274225 0.484818 0.264611 0.823309 -0.012476 1.892571 0.412240 1.581692 1.445345 1.975313 1.109805 1.037725 1.569414 0.730752 0.580175 1.087771 0.304244 0.165561 0.668198 1.865434 1.724763 0.256454 1.484639 1.316097 1.889804 1.052136 0.940054 1.485916 0.660978 0.513405 1.016794 0.271618 0.113291 0.699468 1.883353 1.697658 0.287173 1.441048 1.317570 1.891729 1.047267 0.924739 1.457503 0.662877 0.571505 1.085156 0.285180 0.182148 0.680150 1.907607 1.776846 0.319446 1.520063 1.391770 1.909887 1.070834 1.012523 1.560234 0.710505 0.637244 1.163898 0.361809 0.260891 0.792021 -0.002646 1.915735 0.448091 1.650389 1.455234 0.098320 1.335316 1.102915 1.689190 0.904169 0.760599 1.291880 0.565336 0.373847 0.959477 0.151438 0.066696 0.585592 1.786560 1.701372 0.269783 1.439620 1.314610 1.890517 1.116366 1.015440 1.537388 0.781052 0.657438 1.222475 0.421271 0.290978 0.844255 0.113418 1.953291 0.477222 1.752801 1.589696 0.143048 1.383416 1.256774 1.832008 1.025996 0.975654 1.480532 0.706039 0.665919 1.152186 0.397585 0.311147 0.818759 0.079814 1.971864 0.463244 1.772747 1.631091 0.174216 1.406999 1.308602 1.908188 1.116707 1.000234 1.570856 0.801592 0.675215 1.258336 0.475955 0.351308 0.893503 0.169935 0.040565 0.589687 1.831710 1.716063 0.309405 1.551585 1.424155 -0.045850 1.247666 1.120801 1.686003 0.953420 0.833871 1.438461 0.685501 0.503777 1.139421 0.351523 0.243123 0.816021 0.039340 1.954813 0.490909 1.776479 1.668893 0.253246 1.479286 1.356669 1.967955 1.183863 1.087426 1.650758 0.894976 0.782311 1.353499 0.626342 0.522722 1.092135 0.369898 0.266360 0.834130 0.080569 0.005775 0.542941 1.796238 1.699666 0.241560 1.504104 1.484222 0.032073 1.255830 1.205661 1.789656 1.001107 0.967756 1.497970 0.783176 0.636911 1.259869 0.545735 0.373839 1.011186 0.272028 0.151976 0.748500 0.014880 1.945933 0.489769 1.718186 1.658729 0.250486 1.442769 1.433264 0.014094 1.245910 1.228473 1.771898 1.042707 0.955409 1.505865 0.788550 0.734037 1.286003 0.564007 0.456383 1.065157 0.335180 0.228061 0.870648 0.093922 0.023354 0.576772 1.854178 1.777321 0.335212 1.621830 1.561687 0.135260 1.404301 1.350298 1.956880 1.186886 1.104559 1.714095 0.951528 0.920945 1.461081 0.804510 0.681049 1.312778 0.563439 0.457734 1.075598 0.365917 0.241630 0.874250 0.122074 0.005779 0.650916 1.945221 1.836522 0.468772 1.677228 1.672584 0.293095 1.517182 1.455416 0.053637 1.335082 1.271498 1.868840 1.148849 1.077614 1.699114 0.957242 0.909773 1.507937 0.819325 0.745911 1.300424 0.660914 0.517071 1.148393 0.477391 0.395797 0.992991 0.203675 0.148285 0.804528 0.037856 -0.014517 0.623928 1.896158 1.831163 0.465744 1.775829 1.684243 0.342873 1.546884 1.523172 0.121875 1.367734 1.346790 1.930162 1.206271 1.218126 1.773034 1.016484 1.026597 1.674483 0.905385 0.916720 1.485218 0.768102 0.744963 1.314328 0.586805 0.545982 1.178451 0.409765 0.433562 1.059854 0.322599 0.301006 0.916953 0.191015 0.128175 0.773432 0.041189 -0.011679 0.641082 1.919177 1.876122 0.477836 1.800998 1.713310 0.360551 1.618561 1.586732 0.234982 1.510384 1.461807 0.078303 1.367947 1.315052 1.991170 1.253947 1.231856 1.896522 1.128052 1.155558 1.742518 1.011682 0.992129 1.662757 0.917069 0.896647 1.517467 0.811142 0.801561 1.378074 0.655532 0.693384 1.297052 0.556003 0.554461 1.164163 0.527254 0.443564 1.067518 0.388431 0.377943 0.971307 0.279656 0.268793 0.914615 0.183053 0.173290 0.821793 0.119888 0.042577 0.739360 -0.024743 0.017796 0.627830 1.942015 1.875957 0.534582 1.819727 1.814671 0.403721 1.735475 1.749556 0.364544 1.666765 1.664891 0.276730 1.634983 1.588897 0.223175 1.525575 1.484917 0.145258 1.452132 1.399860 0.090030 1.397517 1.355974 -0.034624 1.338547 1.273596 1.930895 1.242771 1.254138 1.905566 1.184827 1.219335 1.805937 1.162198 1.116031 1.764533 1.065430 1.009257 1.775295 1.066032 1.038606 1.641549 1.041898 0.960719 1.627839 0.969805 0.902364 1.579999 0.892329 0.902171 1.570211 0.897949 0.866559 1.482042 0.900082 0.780517 1.461278 0.804689 0.806384 1.410132 0.758253 0.751432 1.412057 0.723690 0.709708 1.400611 0.700896 0.672911 1.401525 0.653242 0.664420 1.350315 0.698208 0.650691 1.280581 0.655540 0.616367 1.280676 0.602731 0.614946 1.258268 0.603698 0.642570 1.221613 0.583910 0.616706 1.268164 0.597953 0.583180 1.246490 0.574921 0.568672 1.255518 0.575806 0.599224 1.253773 0.549216 0.577963 1.247391 0.569771 0.574035 1.270112 0.614544 0.574061 1.273756 0.583289 0.616309 1.266492 0.569886 0.615711 1.272438 0.619450 0.645946 1.293968 0.642458 0.707103 1.326902 0.669023 0.642822 1.320030 0.679797 0.645973 1.313508 0.724171 0.723240 1.381045 0.771880 0.740016 1.399210 0.757225 0.771410 1.407267 0.783100 0.799508 1.465164 0.859352 0.841945 1.532188 0.913246 0.871331 1.537090 0.908429 0.900221 1.650122 0.948282 0.965209 1.696275 1.010851 1.033511 1.664455 1.015256 1.065206 1.764137 1.100371 1.077922 1.790519 1.159470 1.166742 1.832273 1.239082 1.219133 1.930069 1.302577 1.256500 -0.021545 1.336756 1.331054 0.034311 1.441197 1.417316 0.137786 1.481529 1.521120 0.202087 1.542597 1.571662 0.295858 1.591897 1.660559 0.313018 1.701454 1.690928 0.425890 1.757131 1.802075 0.481081 1.823268 1.879869 0.529398 1.942196 -0.104161 0.686421 0.028566 0.039450 0.715639 0.124191 0.184523 0.844150 0.225394 0.234188 0.984354 0.297195 0.396756 0.994292 0.435308 0.442504 1.137196 0.516791 0.527372 1.267992 0.612693 0.645644 1.385057 0.758119 0.766676 1.476839 0.821885 0.869275 1.594978 0.963530 0.987568 1.669866 1.079496 1.155656 1.839522 1.212988 1.246034 1.947217 1.305186 1.309691 0.098384 1.450688 1.481289 0.178624 1.559605 1.643638 0.347419 1.664667 1.743632 0.428933 1.818788 1.870218 0.560631 1.948613 -0.011843 0.777861 0.080127 0.154586 0.839652 0.196466 0.282481 0.957553 0.340829 0.403666 1.108289 0.545143 0.538837 1.292227 0.678913 0.711835 1.453776 0.780670 0.890231 1.548796 0.963266 1.005475 1.737788 1.087466 1.225642 1.893128 1.300457 1.358812 0.024348 1.424356 1.460530 0.224234 1.618453 1.666722 0.343925 1.767952 1.822981 0.569961 1.939773 0.024092 0.687672 0.135982 0.168979 0.887089 0.250556 0.330854 1.115214 0.490537 0.505411 1.250038 0.672497 0.708858 1.425896 0.821232 0.917125 1.657089 1.027860 1.100856 1.804912 1.191320 1.250219 -0.006220 1.418603 1.467061 0.213773 1.606183 1.636475 0.405709 1.775379 1.864571 0.624949 -0.014333 0.062564 0.785868 0.202947 0.277056 0.998039 0.434555 0.480421 1.227774 0.624588 0.718366 1.454454 0.810668 0.924628 1.646734 1.018705 1.128135 1.855184 1.288883 1.297621 0.068784 1.471600 1.536704 0.255149 1.708446 1.788384 0.463683 1.933788 -0.000038 0.725740 0.140321 0.213798 1.003405 0.397360 0.469361 1.169053 0.599535 0.692197 1.446163 0.799853 0.883834 1.658705 1.074539 1.176457 1.923671 1.352300 1.433363 0.149415 1.657619 1.683235 0.391516 1.815683 1.879275 0.635249 0.081799 0.206289 0.940691 0.263188 0.401681 1.116696 0.596207 0.656586 1.405166 0.837494 0.928763 1.677113 1.133720 1.172730 1.991454 1.381035 1.421679 0.171329 1.639925 1.725656 0.474989 1.882339 0.003906 0.712210 0.204212 0.202458 1.020564 0.426698 0.531716 1.326400 0.740237 0.806894 1.551518 0.993769 1.081852 1.869691 1.301434 1.377997 0.145967 1.551525 1.640145 0.422739 1.827654 1.952291 0.683508 0.127895 0.249322 1.016083 0.471475 0.500905 1.267206 0.741473 0.794288 1.582219 1.014601 1.124374 1.905414 1.353891 1.423560 0.241946 1.650894 1.746478 0.503791 1.940446 0.041814 0.804964 0.216401 0.394304 1.109293 0.552834 0.669914 1.481121 0.828721 0.957897 1.761608 1.222432 1.335754 0.076544 1.506225 1.599501 0.429100 1.837764 1.930577 0.752221 0.168250 0.271562 1.045906 0.532696 0.607367 1.341518 0.793425 0.971695 1.746184 1.171372 1.223953 0.017149 1.515353 1.600778 0.424233 1.844262 1.950604 0.703514 0.202516 0.311247 1.094672 0.528121 0.636494 1.420834 0.847273 0.999876 1.809074 1.209665 1.372894 0.143017 1.541402 1.676204 0.476818 1.930006 0.041953 0.823503 0.302195 0.436852 1.186491 0.631667 0.752662 1.538347 0.938088 1.125460 1.968773 1.390508 1.501794 0.228821 1.771158 1.899479 0.674328 0.118589 0.240925 1.037784 0.525024 0.602522 1.407320 0.858143 0.986379 1.789617 1.288988 1.369825 0.158488 1.618315 1.794862 0.520342 0.001747 0.103222 0.954880 0.418698 0.561204 1.353641 0.776085 0.911039 1.688476 1.226116 1.327644 0.121659 1.559436 1.738373 0.489852 0.063512 0.117870 0.911495 0.357778 0.572301 1.361657 0.806404 0.972579 1.752803 1.222290 1.329391 0.157629 1.567367 1.747794 0.559238 0.059573 0.169284 0.988028 0.438989 0.623787 1.375884 0.900337 1.022860 1.824981 1.290197 1.426269 0.256438 1.724623 1.841038 0.655059 0.186359 0.251151 1.100432 0.570595 0.728804 1.554644 0.999376 1.151832 1.950849 1.460972 1.572660 0.419464 1.869333 0.047131 0.828318 0.318898 0.440175 1.255889 0.775898 0.898221 1.702696 1.199271 1.338448 0.161966 1.635455 1.784190 0.605231 0.095832 0.290129 1.117456 0.547716 0.673198 1.529969 0.965891 1.209578 1.955898 1.491112 1.663426 0.431485 1.944215 0.128344 0.882309 0.456278 0.561031 1.404429 0.826539 1.015348 1.892161 1.344198 1.494721 0.331297 1.812823 -0.015001 0.794288 0.292917 0.481668 1.328555 0.759727 0.966608 1.770740 1.277919 1.386449 0.246883 1.722362 1.931131 0.696251 0.293064 0.387873 1.225170 0.692607 0.878803 1.741354 1.220710 1.403575 0.241520 1.765476 1.872696 0.727165 0.197200 0.371031 1.201221 0.707874 0.809360 1.675835 1.192315 1.373973 0.207378 1.725547 1.909529 0.740964 0.241014 0.433456 1.234344 0.720309 0.925979 1.797743 1.255413 1.411569 0.270029 1.783668 1.944479 0.794326 0.277781 0.428656 1.309389 0.810089 0.971388 1.845971 1.329918 1.570803 0.356532 1.867078 0.044842 0.853254 0.426411 0.598447 1.391850 0.948856 1.063476 1.956889 1.460999 1.651516 0.511051 0.038002 0.168508 1.069052 0.568041 0.715068 1.615777 1.097648 1.245991 0.140051 1.648069 1.853329 0.616334 0.174774 0.367767 1.251431 0.700255 0.996063 1.782508 1.356497 1.480600 0.386578 1.846100 0.064014 0.873015 0.459470 0.629788 1.477031 0.991240 1.156497 0.044005 1.550915 1.734822 0.584616 0.115280 0.302430 1.205940 0.673952 0.912732 1.750313 1.291346 1.475249 0.316775 1.812006 0.069025 0.943785 0.434689 0.648424 1.459022 1.037998 1.211306 0.111399 1.569613 1.817596 0.636751 0.201419 0.388806 1.255314 0.787497 0.989232 1.871524 1.335013 1.561767 0.445929 1.928262 0.158825 1.014269 0.562638 0.760419 1.645204 1.169421 1.388485 0.191067 1.752438 -0.024100 0.845124 0.381480 0.571144 1.458835 1.024359 1.183886 0.060958 1.587218 1.805775 0.709368 0.247607 0.395912 1.292130 0.842392 1.023063 1.888636 1.494685 1.645564 0.538850 0.085302 0.280482 1.142282 0.708370 0.931529 1.808452 1.343008 1.539180 0.459023 1.927814 0.185018 1.021331 0.569656 0.831189 1.708913 1.252835 1.452189 0.330235 1.859469 0.159849 0.964616 0.519451 0.774263 1.576172 1.196850 1.392715 0.233945 1.833148 0.073523 0.907215 0.470724 0.682727 1.553906 1.121187 1.355311 0.226476 1.754616 0.001494 0.895872 0.454236 0.669508 1.577899 1.062194 1.296602 0.191628 1.755727 -0.009671 0.886879 0.448163 0.663507 1.527260 1.142344 1.351997 0.210087 1.738981 0.003528 0.912004 0.461486 0.710442 1.554385 1.104392 1.344043 0.256462 1.775924 0.034483 0.910869 0.511777 0.733471 1.625816 1.208073 1.396269 0.313025 1.872219 0.119690 0.987498 0.562358 0.751670 1.679723 1.303479 1.492065 0.427319 1.929671 0.230296 1.076040 0.656729 0.868646 1.812623 1.309246 1.606815 0.489455 0.113032 0.292634 1.246510 0.738616 0.958174 1.914204 1.555499 1.767896 0.639309 0.178743 0.408993 1.352238 0.925628 1.160646 0.064889 1.690097 1.909990 0.777835 0.323085 0.577979 1.483106 1.097949 1.319323 0.227061 1.790227 0.049977 0.952004 0.562086 0.829262 1.711539 1.212348 1.534928 0.433446 -0.001360 0.228513 1.213421 0.754722 1.057379 1.894685 1.504575 1.751368 0.667825 0.162153 0.478972 1.413148 1.000008 1.265230 0.136421 1.706337 1.977898 0.887381 0.450949 0.728542 1.637577 1.233876 1.463407 0.399481 -0.007967 0.277514 1.195158 0.736559 1.030179 1.960792 1.534456 1.743747 0.699904 0.291454 0.566972 1.433236 1.068488 1.391113 0.250394 1.853964 0.061307 0.999178 0.590021 0.891401 1.737309 1.367606 1.650381 0.551623 0.150310 0.422291 1.352180 0.937947 1.171585 0.139951 1.754581 0.009605 0.937315 0.554798 0.783179 1.760270 1.293734 1.576954 0.541696 0.180468 0.380050 1.264962 0.879397 1.186434 0.111263 1.745295 1.978802 0.932911 0.503099 0.754427 1.681236 1.291466 1.560939 0.497922 0.106245 0.355058 1.331592 0.950830 1.220173 0.170662 1.733732 -0.018846 0.976683 0.563880 0.817264 1.780655 1.410617 1.641377 0.650872 0.170922 0.475384 1.369650 1.023658 1.264911 0.227846 1.872082 0.113171 1.057105 0.638601 0.971923 1.863338 1.482023 1.805204 0.705593 0.310248 0.585584 1.592180 1.174217 1.436329 0.387040 -0.015390 0.311556 1.255617 0.859239 1.136281 0.106573 1.709231 0.000318 0.939254 0.585578 0.873469 1.786898 1.377529 1.679152 0.669303 0.280462 0.522984 1.484678 1.099251 1.467137 0.396482 0.018246 0.320214 1.231930 0.888072 1.140183 0.058265 1.712151 0.027694 0.976204 0.556271 0.832763 1.821553 1.438215 1.765643 0.640146 0.314562 0.621793 1.531334 1.188605 1.486379 0.463368 0.110380 0.354361 1.355491 0.974671 1.279553 0.216308 1.793152 0.099032 1.091098 0.683398 1.045593 0.006816 1.635578 1.920263 0.835165 0.521196 0.738706 1.773273 1.343787 1.668486 0.609763 0.275879 0.560761 1.568491 1.165177 1.429892 0.443415 0.120321 0.395840 1.352127 0.957318 1.267366 0.254258 1.907347 0.214182 1.229376 0.817606 1.131516 0.164505 1.738709 0.090499 1.028463 0.688843 0.959213 1.909343 1.616375 1.886117 0.859206 0.529326 0.833652 1.803686 1.398494 1.712108 0.669655 0.347420 0.678066 1.647195 1.244393 1.564168 0.586067 0.180938 0.492611 1.540408 1.136838 1.450202 0.424046 0.092526 0.366519 1.307532 0.995326 1.361717 0.311475 1.934991 0.284046 1.272294 0.973979 1.258353 0.209195 1.868734 0.201537 1.201644 0.795360 1.145795 0.164350 1.806004 0.134413 1.096604 0.748369 1.058650 0.019679 1.709209 0.068329 0.926905 0.705475 0.961878 1.942717 1.660047 1.946289 0.932519 0.587790 0.910040 1.953023 1.524533 1.821891 0.893432 0.528469 0.868922 1.860995 1.461965 1.803173 0.815825 0.494511 0.784392 1.851184 1.476207 1.825260 0.809120 0.453936 0.773272 1.758895 1.437402 1.751861 0.698476 0.409155 0.724619 1.736522 1.410414 1.730203 0.738437 0.421779 0.732038 1.811893 1.430613 1.777831 0.738310 0.428109 0.776318 1.770757 1.464084 1.783535 0.801562 0.495390 0.801159 1.822204 1.485508 1.859280 0.806665 0.521142 0.830945 1.850586 1.519076 1.846549 0.856088 0.525267 0.876877 1.918498 1.490968 1.838152 0.877215 0.609460 0.933076 1.837986 1.594347 1.894422 0.908902 0.579201 0.899244 1.942437 1.621161 0.005048 0.986429 0.686035 0.999192 -0.045831 1.691579 0.027162 1.067166 0.659329 1.053194 0.104698 1.758351 0.094679 1.148583 0.786246 1.159486 0.167858 1.807592 0.213250 1.217453 0.973788 1.299992 0.312204 1.939281 0.336640 1.316467 1.036816 1.357972 0.386323 0.042508 0.423504 1.502732 1.149762 1.491690 0.537106 0.270349 0.561229 1.615120 1.349201 1.683516 0.641827 0.335373 0.725612 1.726801 1.441311 1.791055 0.806381 0.584462 0.860760 1.894136 1.539482 1.965064 1.024760 0.664374 0.992274 0.051706 1.774286 0.076073 1.151246 0.884845 1.235892 0.205524 1.870257 0.324541 1.305557 0.974227 1.319180 0.434759 0.150373 0.453586 1.518819 1.237399 1.540077 0.554367 0.330500 0.649448 1.653711 1.405191 1.820126 0.819095 0.500609 0.861715 1.886210 1.635394 1.974957 0.981757 0.689690 1.049353 0.133023 1.811506 0.237887 1.243048 0.948642 1.288161 0.326484 -0.006897 0.454932 1.463114 1.186909 1.492877 0.592384 0.273198 0.660187 1.714676 1.403786 1.875933 0.867744 0.587276 0.948265 -0.011903 1.690116 0.067984 1.168897 0.844068 1.220962 0.272163 1.916245 0.300654 1.443525 1.120250 1.442074 0.542063 0.234368 0.611463 1.715978 1.430854 1.802136 0.860066 0.535626 0.974335 -0.841543 1.681087 0.070778 1.067073 0.836680 1.215935 0.244870 0.065478 0.359141 1.423200 1.140746 1.557939 0.637289 0.358189 0.702516 1.773086 1.517553 1.870779 0.930619 0.671519 1.022308 0.089428 1.838749 0.223674 1.257595 1.046712 1.446823 0.427766 0.176904 0.607697 1.685824 1.365927 1.793906 0.871828 0.592604 1.016618 0.022209 1.825894 0.178342 1.235409 0.979002 1.373816 0.427129 0.169258 0.570594 1.650797 1.414013 1.767321 0.889539 0.635953 1.015373 0.027452)
       )


))

;; :all 65536 (320.768635104 1.6604741485419 0.83776099628482) 0.52033682944489
;; :all 65536 (309.91637906494 0.64007539845073 4.5547029008803e-05) 0.5172334495671 (0)
;; :all 65536 (303.64661814299 1.3570805366568 -4.6971909684279e-05) 0.5153905931919 (200)

;; :all 131072 (438.77509431894 1.4462367399126 2.0944027696821) 0.51631398987158  (sqrt: 362)



;;; ---------------------------------------- odd numbered harmonics ----------------------------------------

(define nodd-min-peak-phases (vector

(vector 1  1.0   #r(0)
     )

(vector 2  1.539 #r(0 0)
     )

;;; 3 odd --------------------------------------------------------------------------------
(vector 3  1.7548747062683 #r(0 1 1)

     1.7393749801561 #r(0.0 1.205686890924528215096600547440175432712E0 1.297035953235478072942399307976302225143E0)
     1.7387926578522 #r(0.0 1.2094986438751 1.3025436401367)
     1.7387455701828 #r(0.0 0.79018270969391 0.69699490070343)

     1.738745 #r(0.000000 1.209826 1.303017)
     1.738744 #r(0.000000 0.790172 0.696980)
     )

;;; 4 odd --------------------------------------------------------------------------------
(vector 4  2.19460272789 #r(0 1 0 0)

     2.050 #r(0 39/25 26/29 27/22)
     2.048743724823 #r(0 111/256 281/256 195/256)
     2.0466175079346 #r(0 223/512 563/512 49/64)

     2.045218 #r(0.000000 1.563819 0.899661 1.233860)
     2.045217 #r(0.000000 0.436172 1.100327 0.766122)
     )

;;; 5 odd -------------------------------------------------------------------------------- ; 2.2360679
(vector 5  2.7317879199982 #r(0 1 1 0 0)

     2.3731805734023 #r(0 7/16 7/4 5/8 7/16)

     2.307252 #r(0.000000 0.393369 1.754476 0.596108 0.424804)
     2.307253 #r(0.000000 1.606636 0.245540 1.403918 1.575230)
     )

;;; 6 odd -------------------------------------------------------------------------------- ; 2.44948
(vector 6  2.8638670444489 #r(0 0 0 0 1 0)

     2.522759 #r(0.000000 1.360421 1.129847 1.035439 1.320248 0.102465)
     2.522749 #r(0.000000 0.639403 0.869779 0.964074 0.679243 -0.103102)
     )

;;; 7 odd -------------------------------------------------------------------------------- ; 2.64575
(vector 7  2.9204399585724 #r(0 0 0 1 1 0 1)

     2.618497 #r(0.000000 1.527527 0.524623 0.177241 0.453108 1.577456 1.970355)
     2.618376 #r(0.000000 0.474123 1.477585 1.824644 1.552691 0.429533 0.035303)
     2.618302 #r(0.000000 0.474154 1.477730 1.824846 1.552894 0.429720 0.035636)
     )

;;; 8 odd -------------------------------------------------------------------------------- ; 2.828427
(vector 8  3.2507002353668 #r(0 1 1 0 1 1 1 0)

     2.8071956634521 #r(0 109/128 7/4 1 13/16 123/64 21/128 43/128)

     2.790858 #r(0.000000 0.802399 1.672681 0.887888 0.680265 1.767889 0.004580 0.126233)
     2.790799 #r(0.000000 1.197514 0.327251 1.112061 1.319778 0.232086 -0.004810 -0.126263)
     2.790663 #r(0.000000 1.196617 0.325818 1.109894 1.316877 0.229200 -0.008217 -0.130363)
     )

;;; 9 odd -------------------------------------------------------------------------------- ; 3
(vector 9  3.4140722751617 #r(0 0 1 1 1 1 0 1 0)

     2.886575 #r(0.000000 0.394663 0.625974 1.648922 0.070810 1.803585 1.908749 0.903752 0.378081)
     2.886464 #r(0.000000 1.605518 1.374012 0.351118 1.929257 0.196622 0.091381 1.096286 1.622082)
     2.886241 #r(0.000000 1.605727 1.374318 0.351747 1.930232 0.197770 0.092557 1.097753 1.623786)
     )

;;; 10 odd -------------------------------------------------------------------------------- ; 3.162277
(vector 10 3.5391488075256 #r(0 0 1 1 0 1 0 0 0 0)

     3.054055 #r(0.000000 0.508058 0.119325 0.663858 1.627094 1.847660 0.043999 1.283121 0.512586 0.295891)
     3.054035 #r(0.000000 0.528914 0.163543 0.741593 1.737455 -0.019531 0.179460 1.441592 0.691200 0.513749)
     3.054019 #r(0.000000 1.467927 1.828996 1.243932 0.242207 -0.005741 1.795358 0.528965 1.275954 1.445527)

     3.053923 #r(0.000000 0.530606 0.167556 0.749983 1.748996 -0.005015 0.193787 1.458258 0.709754 0.536958)
     3.053807 #r(0.000000 0.524885 0.155185 0.727764 -0.282439 -0.043214 0.155190 1.412864 0.658810 0.474600)
     3.053435 #r(0.000000 0.525383 0.155614 0.727601 -0.282536 -0.043650 0.155330 1.412909 0.659050 0.474369)
     )

;;; 11 odd -------------------------------------------------------------------------------- ; 3.31662
(vector 11 3.6182308197021 #r(0 0 0 1 1 1 0 1 1 0 1) ; 3.31662

     3.177383 #r(0.000000 1.758655 0.386236 -0.008172 1.159122 0.785208 0.739625 0.606297 1.367332 0.311355 0.827147)
     3.177220 #r(0.000000 0.232935 1.599549 -0.005436 0.822576 1.185453 1.230375 1.357659 0.594255 1.644007 1.122113)
     3.177201 #r(0.000000 1.748294 0.370273 -0.021500 1.141958 0.751903 0.709536 0.566072 1.323348 0.262962 0.769859)

     3.177182 #r(0.000000 1.764972 0.396592 0.001274 1.171590 0.806702 0.760785 0.632485 1.395663 0.343598 0.864498)
     3.177098 #r(0.000000 1.745038 0.362715 -0.030740 1.128748 0.736155 0.690326 0.545405 1.303285 0.236832 0.743503)
     3.176608 #r(0.000000 1.744464 0.362417 -0.030039 1.129933 0.735652 0.691339 0.545454 1.302582 0.237082 0.742494)
     )

;;; 12 odd -------------------------------------------------------------------------------- ; 3.464101
(vector 12 4.0 #r(0 0 1 1 0 0 0 0 0 1 0 1)

     3.363698 #r(0.000000 0.073271 0.585961 0.960666 0.978302 0.113696 1.500041 1.186734 1.772452 0.944338 1.321484 0.602060)
     3.362737 #r(0.000000 -0.077029 1.405769 1.027930 1.006574 1.870564 0.481680 0.791450 0.202834 1.026360 0.648485 1.363973)
     3.361884 #r(0.000000 -0.077168 1.405944 1.028559 1.007566 1.871331 0.482574 0.792122 0.203932 1.027727 0.649507 1.365630)
     )

;;; 13 odd -------------------------------------------------------------------------------- ; 3.60555
(vector 13 3.8778836727142 #r(0 0 1 1 0 0 1 0 1 0 0 0 0) 

     3.476053 #r(0.000000 0.380793 0.961293 0.353157 0.446308 0.965358 0.539394 0.172183 -0.067910 0.976833 -0.486927 1.072643 -0.036066)
     3.475486 #r(0.000000 1.620375 1.040657 1.650169 1.557159 1.039441 1.466014 -0.165746 0.075570 1.032228 0.496820 0.937529 0.047188)
     3.475452 #r(0.000000 1.620672 1.042066 1.652912 1.561748 1.044454 1.472771 -0.159565 0.082334 1.041828 0.507070 0.948164 0.058404)
     3.474532 #r(0.000000 1.621213 1.042646 1.653413 1.561849 1.044891 1.473168 -0.158623 0.083544 1.042513 0.507800 0.949479 0.059341)
     )

;;; 14 odd -------------------------------------------------------------------------------- ; 3.741657
(vector 14 4.2842662512094 #r(0 1 1 0 0 1 1 1 0 1 0 0 0 0)

     3.606512 #r(0.000000 0.785150 1.482463 -0.077041 0.773052 0.357080 1.202237 -0.069790 1.584889 0.769902 0.652503 0.409520 0.740393 0.675317)
     3.600425 #r(0.000000 1.139545 0.351170 -0.114733 0.966482 1.234831 0.292454 1.539190 0.009726 0.589539 0.769919 0.798632 0.417679 0.467195)
     3.599409 #r(0.000000 0.851134 1.636505 0.091221 1.006010 0.744090 1.678264 0.418648 -0.048848 1.351639 1.174737 1.143087 1.519418 1.448182)
     3.598494 #r(0.000000 0.850577 1.637081 0.089423 1.006545 0.749551 1.681409 0.420517 -0.044040 1.351533 1.177890 1.148728 1.524043 1.447267)
     )

;;; 15 odd -------------------------------------------------------------------------------- ; 3.872983
(vector 15 4.4701427567987 #r(0 1 0 0 1 0 1 1 1 1 1 0 0 1 1)

     3.739752 #r(0.000000 1.191367 0.176518 1.591145 1.710423 1.309889 1.422724 0.785426 1.754948 1.707551 1.122738 1.744847 0.127913 0.663567 0.776627)
     3.738430 #r(0.000000 1.190239 0.174514 1.589466 1.706591 1.305812 1.416225 0.779885 1.746839 1.699566 1.113488 1.734421 0.117674 0.652032 0.763074)
     )

;;; 16 odd -------------------------------------------------------------------------------- ; 4
(vector 16 4.5778832343715 #r(0 1 1 0 0 0 0 1 0 0 1 1 1 0 1 0)

     3.858242 #r(0.000000 0.144652 0.676444 0.017002 0.269119 1.012194 1.772841 1.585260 1.809100 0.289620 1.399960 0.670537 0.175237 0.296937 -0.017357 1.108803)
     3.857020 #r(0.000000 0.144607 0.675956 0.016527 0.269112 1.012147 1.772535 1.584482 1.808783 0.289484 1.400085 0.669674 0.174650 0.295492 -0.017769 1.108482)
     )

;;; 17 odd -------------------------------------------------------------------------------- ; 4.12310
(vector 17 4.5790815353394 #r(0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 0 0)

     3.927805 #r(0.000000 0.618908 0.864629 1.180783 1.677629 1.929621 0.580975 1.820904 0.468136 1.289907 0.485211 0.029658 1.160895 0.856998 0.644358 0.814931 0.296558)
     3.926355 #r(0.000000 0.619515 0.864447 1.181990 1.677700 1.930862 0.582927 1.823955 0.470265 1.290931 0.488790 0.031736 1.163146 0.861017 0.648828 0.818286 0.301049)
     )

;;; 18 odd -------------------------------------------------------------------------------- ; 4.2426406
(vector 18 4.801501750946 #r(0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 0)

     4.071185 #r(0.000000 0.956640 1.083713 0.493342 0.797185 0.138960 0.613585 0.388904 -0.007616 0.968034 0.616152 1.753096 0.351362 1.174080 1.220111 1.511627 0.186455 1.775153)
     4.069528 #r(0.000000 0.956814 1.082990 0.493213 0.796608 0.137780 0.611831 0.387091 -0.011186 0.965014 0.614046 1.752338 0.348807 1.169857 1.216059 1.508238 0.182073 1.770765)
     )

;;; 19 odd -------------------------------------------------------------------------------- ; 4.358898
(vector 19 4.8924918279945 #r(0 1 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1)
     
     4.173923 #r(0.000000 0.329738 1.407540 1.252167 0.448297 0.551162 1.341659 1.859617 1.357020 0.222879 0.553639 1.254187 0.641694 -0.208417 1.489583 1.646436 1.391179 1.758274 1.299312)
     4.171858 #r(0.000000 0.330499 1.406874 1.250304 0.450026 0.551790 1.342413 1.858827 1.359366 0.223792 0.553485 1.256415 0.641759 -0.208630 1.490602 1.646088 1.388713 1.758053 1.297635)
     )

;;; 20 odd -------------------------------------------------------------------------------- ; 4.472135
(vector 20 5.043 #r(0 1 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 1 0)

     4.357980 #r(0.000000 0.074668 -0.007236 0.182274 -0.090904 0.683075 1.087950 1.620610 1.402047 0.349796 1.096502 -0.498958 0.949574 -0.321894 1.411823 0.831379 -0.654670 0.294879 -0.284984 1.407225)
     4.300525 #r(0.000000 1.454922 0.306846 1.245703 0.207273 -0.248151 0.165464 0.618585 -0.103207 0.155791 -0.136302 0.476852 0.390970 -0.309608 1.166284 1.108669 -0.452208 0.338277 0.424300 -0.136694)
     4.300411 #r(0.000000 1.455414 0.307661 1.246638 0.208834 -0.246349 0.167594 0.620918 -0.100474 0.159208 -0.133203 0.480470 0.395357 -0.304743 1.170590 1.114440 -0.446663 0.344322 0.430311 -0.130164)
     )

;;; 21 odd -------------------------------------------------------------------------------- ; 4.5825756
(vector 21 5.1372244578347 #r(0 1 1 1 0 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1)

     4.448460 #r(0.000000 1.232455 0.090847 0.908719 0.292484 1.788804 -0.065161 1.337389 1.076226 0.741452 1.053336 1.212537 1.463874 0.812811 1.503269 1.665124 0.651549 0.032446 1.058206 1.235365 -0.036822)
     4.400133 #r(0.000000 1.421969 0.432928 1.323306 0.852962 0.504322 0.760610 0.255553 0.174738 -0.050501 0.443901 0.710959 1.135718 0.433735 1.396810 -0.270794 0.666555 0.133068 1.539972 -0.289562 0.510759)
     4.398753 #r(0.000000 1.496452 0.530521 1.466840 1.037430 0.768041 1.062178 0.568630 0.521390 0.318401 0.839156 1.187950 1.614960 0.975948 -0.029541 0.335933 1.354945 0.841788 0.263047 0.509077 1.300143)
     )

;;; 22 odd -------------------------------------------------------------------------------- ; 4.6904157
(vector 22 5.1805551751198 #r(0 1 0 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0)

     4.581017 #r(0.000000 0.180996 0.414015 1.937535 0.354831 0.584078 1.521008 1.778595 1.533807 1.338106 -0.034930 1.700610 0.808153 0.348626 1.850606 -0.102689 0.038967 0.664253 1.395687 0.513457 1.627689 0.472162)
     4.559399 #r(0.000000 0.818164 -0.192940 0.348191 -0.389846 0.508891 0.493197 0.093591 -0.504577 -0.897041 -0.065084 0.067843 -0.236861 0.107466 -0.207423 -0.742951 0.106255 0.956224 0.876829 -0.230549 0.370673 0.390286)
     4.519002 #r(0.000000 -0.221397 1.057824 1.492981 -0.263486 0.870091 -0.528249 -0.376750 0.756810 0.176851 -0.090091 1.600251 -0.084632 0.635148 0.821442 1.002126 0.978361 0.034872 -0.759728 0.321190 0.972421 0.245173)
     )

;;; 23 odd -------------------------------------------------------------------------------- ; 4.7958315
(vector 23 5.4125407453101 #r(0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1)

     4.661614 #r(0.000000 0.402662 0.143299 -0.307618 -0.213995 0.796949 1.006633 1.285380 1.569840 0.564104 0.342477 0.293161 1.200899 0.723618 0.539973 0.518746 0.907665 0.184015 1.163786 0.995418 -1.860771 1.039418 -0.124574)
     4.634825 #r(0.000000 0.336809 0.806144 -0.062567 0.702047 1.353357 1.333544 1.711363 1.335973 0.156420 1.259722 0.268353 0.775391 0.709193 0.489222 -0.013866 0.215803 1.155224 0.942400 0.393893 0.015582 0.693933 0.411664)
     4.634407 #r(0.000000 0.337913 0.805462 -0.065533 0.702753 1.354327 1.334664 1.709523 1.331667 0.152462 1.257186 0.263947 0.769802 0.707842 0.485157 -0.009174 0.212207 1.154954 0.942106 0.386101 0.011788 0.687978 0.407297)
     )

;;; 24 odd -------------------------------------------------------------------------------- ; 4.89897948
(vector 24 5.6193280144865 #r(0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1)

     4.786434 #r(0.000000 0.498846 1.191572 1.399155 0.479838 1.497230 -0.058887 0.823598 0.010384 0.864577 0.051220 1.057330 0.998513 1.799328 -0.041050 0.199658 0.646825 0.272218 0.034139 0.159133 0.043804 -0.115906 1.177655 0.690674)
     4.783029 #r(0.000000 0.726248 0.856709 1.665477 0.271147 1.375734 -0.206610 0.592121 -0.087409 0.530646 -0.360424 0.901293 1.188841 1.262301 0.080781 0.071714 0.339949 -0.286037 -0.360911 0.038946 0.015798 -0.483821 0.695754 0.114401)
     4.782962 #r(0.000000 0.726238 0.856679 1.665577 0.271280 1.375871 -0.206382 0.592175 -0.087179 0.530852 -0.360257 0.901705 1.189234 1.262764 0.081277 0.072171 0.340463 -0.285522 -0.360411 0.039578 0.016656 -0.483158 0.696443 0.115110)
     )

;;; 25 odd -------------------------------------------------------------------------------- ; 5
(vector 25 5.7220960914079 #r(0 1 0 0 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1)

     4.886819 #r(0.000000 -0.128793 0.647898 0.792536 -0.285146 0.144218 1.160103 1.183437 -0.004858 -0.239530 1.215352 0.277973 0.699697 1.110172 0.616181 1.458993 0.406636 0.121039 0.182656 -0.085662 1.058149 0.147121 0.546131 0.378165 0.309175)
     4.833870 #r(0.000000 0.682487 0.229329 1.065182 1.133347 0.718396 -0.534947 0.962349 0.109795 -0.506458 1.066135 -0.520472 -0.571394 0.037503 0.493262 0.263583 -0.535314 -0.444645 1.130989 -0.865083 -0.231904 -0.824110 -0.626051 0.420930 0.748241)
     4.833585 #r(0.000000 0.684418 0.231543 1.068448 1.131681 0.716084 -0.543413 0.960963 0.108056 -0.510271 1.064008 -0.527153 -0.574236 0.032340 0.486849 0.263393 -0.542768 -0.456188 1.134973 -0.877871 -0.236595 -0.839653 -0.635589 0.413586 0.738028)
     )

;;; 26 odd -------------------------------------------------------------------------------- ; 5.0990
(vector 26 5.8537594936002 #r(0 0 0 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1)

     5.006443 #r(0.000000 1.694135 1.368613 1.372881 0.625230 0.749494 1.218456 1.691757 1.088538 0.652397 -0.134215 1.088115 0.314540 0.197061 0.715518 1.230349 1.542812 -0.159343 1.427261 1.767442 0.867761 1.850745 0.671024 -0.112496 0.172562 0.147817)
     4.996915 #r(0.000000 1.742755 1.471776 1.501254 0.794548 0.943595 1.463682 -0.050384 1.394006 0.990276 0.231933 1.492372 0.767814 0.678653 1.249512 1.790068 0.139370 0.475758 0.085016 0.469457 1.614468 0.612558 1.488941 0.735631 1.061318 1.072925)
     4.996683 #r(0.000000 1.740815 1.471360 1.504333 0.793966 0.944959 1.469851 -0.050031 1.395444 0.990928 0.238054 1.493878 0.769155 0.680547 1.256014 1.792102 0.136976 0.478247 0.085153 0.474291 1.616841 0.617611 1.491514 0.741599 1.059794 1.082318)
     )

;;; 27 odd -------------------------------------------------------------------------------- ; 5.196152
(vector 27 5.8637111082051 #r(0 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1)

     5.088823 #r(0.000000 0.108028 1.216984 1.164689 0.975005 -0.022884 0.035464 -0.148996 0.575654 1.005987 1.378471 0.117457 0.956928 1.741009 0.131397 -0.243584 0.873140 0.514628 1.810242 0.918281 0.161062 1.222969 1.595595 1.233298 1.211975 1.332117 1.297417)
     5.085571 #r(0.000000 0.134554 1.259859 1.228144 1.060230 0.079084 0.158344 0.004220 0.734810 1.196702 1.588244 0.348524 1.210515 0.009117 0.409728 0.061105 1.186771 0.849208 0.158894 1.297636 0.556923 1.631224 0.049754 1.687106 1.701477 1.830544 1.814985)
     5.085376 #r(0.000000 0.134436 1.259874 1.228201 1.060157 0.078706 0.158097 0.004323 0.734629 1.196644 1.588020 0.348173 1.210355 0.008907 0.409496 0.060743 1.186070 0.848591 0.158658 1.296780 0.556238 1.631048 0.049386 1.686839 1.701113 1.829904 1.814076)
     )

;;; 28 odd -------------------------------------------------------------------------------- ; 5.291502
(vector 28 6.0276107788086 #r(0 0 1 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1)

     5.088899 #r(0.000000 1.695594 -0.042323 0.221585 0.121059 0.906440 0.747864 0.144725 -0.170880 0.198031 0.623261 -0.016920 1.187997 1.805776 0.526952 0.257290 0.181436 1.671568 1.634262 0.482276 1.385748 1.687591 0.368532 1.304502 0.925524 0.205838 0.775793 0.352193)
     )

;;; 29 odd -------------------------------------------------------------------------------- ; 5.385164
(vector 29 6.0348020511367 #r(0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 1 1 1 1)

     5.263365 #r(0.000000 0.151064 0.558177 0.735081 1.367806 -0.011277 1.649265 0.435302 1.718318 1.203162 0.977127 1.010028 0.703023 1.591655 0.710208 0.371369 0.285721 1.400549 0.654738 0.961707 0.849244 0.833954 0.047113 1.107680 1.103136 1.834278 0.611441 1.521356 0.107658)
     5.257572 #r(0.000000 0.173145 0.594158 0.795369 1.446698 0.086774 1.773903 0.563415 1.870889 1.380641 1.174997 1.216907 0.933657 1.828478 0.975502 0.657848 0.586415 1.721400 0.987820 1.313934 1.233706 1.234202 0.445482 1.535953 1.550258 0.283390 1.091724 0.021764 0.624654)
     5.257294 #r(0.000000 0.173417 0.594854 0.796262 1.448087 0.088760 1.776024 0.565819 1.873894 1.383720 1.178388 1.220868 0.937816 1.832318 0.979592 0.662513 0.591751 1.726716 0.993575 1.320249 1.240786 1.241192 0.451577 1.543498 1.557502 0.291356 1.099404 0.030228 0.632911)
     )

;;; 30 odd -------------------------------------------------------------------------------- ; 5.4772255
(vector 30 6.2357559204102 #r(0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1)

     5.353062 #r(0.000000 -0.273797 0.780589 0.428126 1.742006 0.813705 1.826779 0.243133 0.799231 0.444552 0.600071 1.280010 -0.037027 0.801371 0.587721 1.132556 0.784854 1.819749 1.361833 1.646165 1.057885 0.274456 0.188906 0.072120 0.645190 1.511097 1.900389 1.698668 1.288971 1.535352)
     5.352588 #r(0.000000 -0.273931 0.766389 0.417785 1.759969 0.852970 1.831793 0.250419 0.820927 0.459290 0.634623 1.258292 -0.010367 0.819856 0.603568 1.142686 0.772733 1.853850 1.422248 1.684383 1.092051 0.281817 0.215433 0.103401 0.692837 1.549368 1.938793 1.739493 1.350311 1.578167)
     )

;;; 31 odd -------------------------------------------------------------------------------- ; 5.56776
(vector 31 6.1342258453369 #r(0 0 1 0 0 0 0 0 1 0 1 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 1 1)

     5.418933 #r(0.000000 1.386056 -0.055103 1.470738 1.133338 0.301486 1.278842 0.118113 0.785586 0.164711 0.277129 1.264947 0.805303 0.592921 0.251470 0.348783 0.666372 0.600263 0.392807 1.237206 -0.185182 1.790868 1.684032 0.764715 0.385641 1.091814 0.146242 0.339596 0.884327 1.106807 0.158763)
     )

;;; 32 odd --------------------------------------------------------------------------------  ; 5.65685
(vector 32 6.3532226957365 #r(0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1)

     5.563263 #r(0.000000 0.861343 1.208721 0.520795 1.054113 1.500902 0.176395 1.932292 0.475897 1.249746 1.078677 0.960255 1.432432 1.363500 0.301492 1.951062 1.402695 1.767079 1.762968 0.052405 1.191435 0.031852 1.950934 1.508841 1.124488 1.063642 0.897258 1.672866 0.358501 1.273522 0.844792 1.935288)
     5.554944 #r(0.000000 0.821925 1.149412 0.436869 0.935301 1.352676 0.015414 1.734986 0.256637 1.005075 0.807193 0.669815 1.109111 1.009353 -0.080026 1.547110 0.960552 1.325068 1.277626 -0.461257 0.639054 -0.523486 1.366433 0.893040 0.492473 0.397673 0.220314 0.941114 -0.385517 0.492662 0.047909 1.104691)
     5.554282 #r(0.000000 0.816259 1.135795 0.419505 0.912392 1.329202 -0.011674 1.699095 0.214307 0.958468 0.757524 0.614160 1.049094 0.938482 -0.150346 1.472378 0.880973 1.239494 1.186161 -0.560917 0.537372 -0.630416 1.261165 0.779340 0.375126 0.275636 0.093262 0.807297 -0.527117 0.344669 -0.098528 0.951269)
     )

;;; 33 odd -------------------------------------------------------------------------------- ; 5.74456
(vector 33 6.4944429397583 #r(0 1 0 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 1 1 0)
     
     5.602961 #r(0.000000 1.602314 1.153414 1.251950 1.483737 0.842898 0.331110 1.775787 1.322292 1.204304 1.308143 0.894156 0.779513 0.992393 1.543652 0.196767 0.377438 0.791269 1.809959 1.067569 0.948715 1.605054 1.761811 1.528262 1.622887 0.603858 1.560497 -0.275070 0.725193 1.894504 0.570411 -0.063928 0.717166)
     5.597136 #r(0.000000 1.557449 1.088288 1.150465 1.337871 0.662053 0.113020 1.530031 1.050090 0.909972 0.971771 0.522071 0.385177 0.561017 1.072763 -0.306711 -0.153565 0.216767 1.206455 0.419699 0.268764 0.907465 1.030833 0.764615 0.842050 -0.267857 0.704934 -1.182847 -0.198387 -1.081887 -0.424937 -1.088630 -0.351619)
     5.596725 #r(0.000000 1.566022 1.098312 1.164250 1.358443 0.666170 0.123772 1.539713 1.080327 0.949887 1.000744 0.558327 0.425174 0.601125 1.113026 -0.252224 -0.088541 0.265061 1.258875 0.446564 0.313471 0.950131 1.109618 0.844385 0.897432 -0.212241 0.780013 -1.109704 -0.115786 -1.020678 -0.360032 -1.011400 -0.261343)
     )

;;; 34 odd --------------------------------------------------------------------------------  ; 5.8309518
(vector 34 6.5771403312683 #r(0 0 1 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0)

     5.736524 #r(0.000000 1.147547 0.291150 -0.006695 0.331715 0.598656 0.377280 0.313054 0.385030 0.054407 1.121795 0.464840 1.643084 0.588724 1.379213 1.083268 0.685423 0.507435 1.364150 0.564530 0.787739 0.046245 1.602176 0.800707 1.479490 1.714846 0.475118 0.321271 0.414765 1.347014 1.695461 1.159002 1.635795 0.467652)
     5.735124 #r(0.000000 1.151079 0.303275 0.009213 0.352648 0.621401 0.398500 0.340493 0.415657 0.089181 1.158671 0.503098 1.689244 0.630365 1.437198 1.139624 0.747050 0.574490 1.429562 0.636715 0.861565 0.124539 1.677944 0.886280 1.563928 1.805767 0.564016 0.418044 0.516828 1.455556 1.805244 1.274392 1.750370 0.585946)

     5.726128 #r(0.000000 0.519262 0.843138 -0.272736 0.110364 0.591254 0.911401 0.339314 0.071814 -0.106840 1.749427 0.267319 -0.401502 1.147737 1.215276 1.316991 0.274119 0.224585 0.821139 0.266527 1.091525 0.636427 0.946267 0.942533 1.378305 -0.065901 1.245114 1.081747 0.487545 1.575194 -0.165766 0.869153 -0.260145 0.981852)
     5.725987 #r(0.000000 0.519367 0.839823 -0.270825 0.109454 0.590467 0.913562 0.338240 0.071129 -0.105723 1.750935 0.267748 -0.404466 1.149320 1.216044 1.315944 0.273465 0.224953 0.819588 0.266322 1.090176 0.636294 0.946461 0.941057 1.379249 -0.063333 1.242866 1.083182 0.490025 1.577337 -0.166600 0.867461 -0.258069 0.984239)
     )

;;; 35 odd -------------------------------------------------------------------------------- ; 5.9160
(vector 35 6.7392678260803 #r(0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 1 0 1 0 0)
     
     5.833275 #r(0.000000 0.446552 1.591598 1.665970 0.393066 0.930519 1.356028 1.466278 0.225797 1.216894 0.009583 0.233020 1.866671 1.148796 1.079614 1.602870 0.201424 1.366765 -0.045388 1.214248 0.402056 0.196949 1.726073 1.538289 -0.146596 -0.105825 1.452686 0.350527 1.133547 0.212285 1.683225 0.967867 0.587559 1.049939 0.968758)
     5.829080 #r(0.000000 0.497100 1.491890 1.596922 0.345822 0.905314 1.289198 1.408451 0.175537 1.253647 0.017296 0.308648 1.866063 1.066612 1.036810 1.601555 0.120109 1.362578 -0.137194 1.172758 0.396767 0.181785 1.659182 1.493825 -0.172588 -0.136985 1.413668 0.161393 1.212058 0.116371 1.561298 0.937104 0.534780 0.940796 0.811381)
     5.801532 #r(0.000000 0.927725 1.438033 1.774007 -0.034765 1.171294 1.852476 0.032758 0.171011 1.057321 0.072523 0.411003 0.226068 0.608849 1.088831 1.232775 0.200272 1.575286 -0.349548 0.605647 0.182255 -0.103231 1.616568 1.743988 -0.717919 -0.725884 1.098676 0.041994 0.836925 -0.062098 1.045714 0.845090 -0.268575 1.174773 0.082224)
     5.800689 #r(0.000000 0.926939 1.434899 1.770213 -0.032113 1.166817 1.853226 0.033896 0.174661 1.059390 0.075778 0.414951 0.221172 0.607934 1.085944 1.232679 0.199374 1.572200 -0.354520 0.604613 0.181334 -0.101308 1.619435 1.744803 -0.721948 -0.722569 1.107370 0.041999 0.835091 -0.057731 1.047643 0.849970 -0.264010 1.176630 0.079939)
     )

;;; 36 odd -------------------------------------------------------------------------------- ; 6
(vector 36 6.8277182579041 #r(0 1 1 0 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 0 0)

     5.976745 #r(0.000000 -0.073257 1.533876 0.975969 0.478187 1.010858 1.535830 1.689302 1.568605 0.651527 -0.024395 0.862716 1.478779 -0.214334 0.406925 1.426003 0.719408 0.448022 1.710025 0.750736 0.773696 1.092187 1.101088 1.282764 0.068797 1.243309 1.489191 1.468200 0.785508 0.637704 1.113799 0.348302 0.603604 -0.148385 1.352941 -0.104705)

     5.956329 #r(0.000000 0.042967 1.563281 0.854602 0.627582 1.339171 0.177574 -0.252844 1.689298 0.657857 0.519548 1.113253 1.833323 0.244152 0.704834 1.614850 0.831222 0.909626 0.121497 1.172463 1.129980 1.502200 1.729294 1.614280 0.561677 1.710852 0.238342 -0.114120 1.453896 1.330709 1.559571 1.318964 1.396357 0.806978 -0.250327 0.682275)
     5.955517 #r(0.000000 0.055570 1.549922 0.853737 0.624076 1.334199 0.184749 -0.259730 1.683917 0.658119 0.518031 1.114143 1.834748 0.240135 0.686226 1.594355 0.818362 0.911264 0.125798 1.176687 1.122947 1.481670 1.730422 1.606173 0.555515 1.695824 0.234706 -0.125347 1.452732 1.327862 1.547467 1.305954 1.401386 0.797969 -0.255922 0.677864)
     )

;;; 37 odd -------------------------------------------------------------------------------- ; 6.0827
(vector 37 7.0 #r(0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0)

     6.019116 #r(0.000000 1.198867 1.849092 0.935330 1.781957 0.496846 0.026335 0.303736 1.089299 1.074310 1.006658 1.377317 0.271438 1.654659 0.071833 0.494433 1.198697 -0.081156 0.936704 0.883271 1.529398 0.425484 0.218240 1.480439 1.569267 1.446099 0.465358 0.265303 1.385278 0.810099 0.212275 0.106695 0.522036 0.380536 0.175723 0.325421 -0.016008)
     5.959431 #r(0.000000 0.917251 1.846780 0.915358 -0.021856 0.521783 -0.142997 0.591405 1.163982 0.976796 0.745905 1.382648 0.071937 1.553077 0.022305 0.451986 0.865411 -0.136619 0.852363 0.871696 1.449655 0.285076 0.325361 1.247695 1.415225 1.246701 0.373242 0.070772 1.174626 0.661467 -0.036150 -0.075470 0.390142 0.182855 0.213495 0.048530 -0.173825)
     5.958733 #r(0.000000 0.917663 1.844637 0.917064 -0.023000 0.522084 -0.140968 0.590202 1.162918 0.977399 0.746122 1.380937 0.072636 1.554351 0.021676 0.452021 0.866436 -0.137694 0.850594 0.868352 1.449562 0.284332 0.323347 1.249529 1.414413 1.248087 0.371239 0.070568 1.173801 0.662841 -0.037509 -0.074833 0.387956 0.180917 0.212366 0.047055 -0.176085)
     )

;;; 38 odd -------------------------------------------------------------------------------- ; 6.1644
(vector 38 7.027690410614 #r(0 0 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 0 0 0 0 0)

     6.144266 #r(0.000000 0.459111 0.978423 1.181967 1.503059 1.306778 0.862780 1.146756 1.405445 1.059554 0.793798 1.421482 1.624819 0.940808 1.764974 -0.199270 0.756440 1.330911 0.861332 0.933256 0.734269 -0.017456 1.393657 0.220679 1.806219 0.259427 -0.110057 1.180170 1.136238 0.286941 1.541821 0.220515 1.089015 1.358525 1.068195 1.590398 0.413700 0.247552)

     ;; 37+1
     6.138688 #r(0.000000 1.046261 1.784835 0.956057 1.812170 0.474533 0.170721 0.206638 1.084578 1.210612 0.877325 1.304868 0.216526 1.666615 0.017582 0.377950 1.122637 -0.152317 0.759942 0.908307 1.610556 0.619180 0.252252 1.289240 1.682699 1.456452 0.437125 0.204631 1.313659 1.057657 0.251390 0.015459 0.426277 0.374256 0.211841 0.291412 0.083784 0.055093)
     6.071192 #r(0.000000 0.940257 1.605649 0.794643 1.716848 0.415861 -0.070422 0.262049 1.139575 0.918835 0.812529 1.191545 -0.001925 -0.235160 -0.407750 0.430854 1.210825 0.197239 0.282594 0.966031 1.603055 0.618511 0.387609 1.148863 1.547245 1.342558 0.329760 -0.175102 1.122736 0.874532 0.093959 -0.102716 0.220424 -0.141270 -0.115620 -0.175392 -0.276776 -0.104039)
     6.070762 #r(0.000000 0.941112 1.606275 0.795569 1.716377 0.414621 -0.069599 0.261380 1.139598 0.918794 0.811587 1.190473 -0.001751 -0.235083 -0.407937 0.429904 1.210405 0.197484 0.283645 0.965951 1.603201 0.617843 0.387138 1.148979 1.545047 1.341130 0.328130 -0.176365 1.121055 0.874462 0.091608 -0.104011 0.218759 -0.142526 -0.118310 -0.176000 -0.278677 -0.106141)
     )

;;; 39 odd -------------------------------------------------------------------------------- ; 6.2449
(vector 39 7.2362656593323 #r(0 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0)

     6.181539 #r(0.000000 0.390214 1.432668 1.784856 0.372658 0.651343 0.590730 1.420862 1.232876 1.274776 1.031604 0.648830 1.314325 1.550338 0.798266 0.829350 0.920173 0.286182 1.175424 0.776791 1.481341 -0.170207 1.810272 0.591377 1.604472 0.287027 1.660006 1.308050 0.895442 0.027306 0.915319 0.337380 0.586293 1.687170 1.285611 1.205943 1.760871 1.039296 0.923977)
     6.168200 #r(0.000000 0.381775 1.454935 1.814403 0.398564 0.697479 0.558864 1.481835 1.237160 1.266386 1.075040 0.611438 1.386693 1.563073 0.754834 0.848982 0.969933 0.242588 1.250658 0.716314 1.559259 -0.161914 1.840309 0.618465 1.616822 0.275923 1.613382 1.346746 0.955815 0.024617 0.939581 0.484552 0.627049 1.599410 1.353605 1.268412 1.756052 1.090300 0.972610)
     6.167830 #r(0.000000 0.381682 1.454889 1.813827 0.398778 0.697480 0.558162 1.483181 1.237051 1.265786 1.074761 0.610761 1.386966 1.563268 0.753925 0.849282 0.970201 0.241940 1.250845 0.715139 1.559620 -0.163681 1.839963 0.617302 1.618908 0.275318 1.613093 1.347193 0.955958 0.023995 0.940280 0.483611 0.627383 1.598354 1.353819 1.269307 1.755190 1.092076 0.973923)
     )

;;; 40 odd -------------------------------------------------------------------------------- ; 6.3245
(vector 40 7.5038495063782 #r(0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 1)

     6.272478 #r(0.000000 1.284197 1.055354 1.062168 0.387815 0.825054 0.121504 1.716073 1.070732 1.544312 0.376494 1.037163 0.380448 0.304545 1.428265 0.150454 0.740589 -1.906896 0.496136 -0.130727 1.453974 1.546206 0.424585 1.220704 1.332527 1.409234 0.400583 1.072058 1.397035 -0.550500 0.327899 1.771283 0.928925 0.550551 1.392166 1.184654 1.462753 1.291611 1.910777 1.578007)
     6.269331 #r(0.000000 1.294861 1.141313 1.106097 0.405055 0.791716 0.150416 1.755897 1.078717 1.540848 0.420537 1.081697 0.464806 0.321274 1.347064 0.195720 0.731658 -0.009086 0.519341 -0.124695 1.424567 1.540630 0.338763 1.279036 1.364830 1.454130 0.302572 1.113714 1.404052 -0.565630 0.324138 1.812694 0.904341 0.525469 1.406208 1.209965 1.471676 1.353706 1.903755 1.597218)
     6.265198 #r(0.000000 1.305916 1.193211 1.131633 0.400580 0.759598 0.164070 1.799072 1.091771 1.559662 0.436556 1.108470 0.518624 0.349203 1.311455 0.208409 0.728546 -0.009336 0.551231 -0.062893 1.432448 1.592165 0.332763 1.326264 1.383816 1.474947 0.298106 1.148715 1.434554 -0.546890 0.369301 1.865917 0.945786 0.522218 1.444025 1.269985 1.507602 1.425880 1.940882 1.667877)
     )

;;; 41 odd -------------------------------------------------------------------------------- ; 6.4031
(vector 41 7.7093445316966 #r(0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 1)

     6.321636 #r(0.000000 0.581881 1.284007 1.435590 0.968036 0.414485 0.203921 -0.085398 1.011694 1.215509 0.697775 0.907045 0.006237 0.289299 0.751565 0.182523 1.917428 0.830815 0.908047 0.267572 -0.061197 0.319855 0.591342 1.699511 1.912692 1.683447 0.192711 0.461781 0.828435 1.122559 0.524721 1.057548 0.753199 0.901168 -0.077807 0.957092 -0.092721 1.453709 0.349112 1.539336 1.035529)
     )

;;; 42 odd -------------------------------------------------------------------------------- ; 6.4807
(vector 42 7.77445936203 #r(0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1)

     6.403222 #r(0.000000 0.615457 1.471291 0.696790 0.198813 1.064683 0.257669 1.499443 1.009189 1.331704 -0.126692 0.668087 -0.151536 1.235993 1.351147 1.834812 1.622001 1.575606 0.387431 1.123625 1.738720 0.186291 -0.093048 -0.362694 1.268339 0.808624 0.147243 0.174237 0.939940 0.098301 1.557405 1.899768 1.063327 1.398074 1.503515 -0.309876 1.592871 1.047295 0.347548 0.500256 0.502585 1.050388)
     )

;;; 43 odd -------------------------------------------------------------------------------- ; 6.5574
(vector 43 7.7573688953539 #r(0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 1)

     6.474181 #r(0.000000 0.163031 0.868018 0.644438 0.499955 0.314476 0.501651 0.136276 0.115801 1.311189 1.257885 1.003167 1.668510 0.653556 0.900535 0.185303 1.792109 1.097281 0.880040 0.351492 0.533331 1.402396 1.722630 -0.341451 0.699659 1.677594 1.684893 1.301554 -0.032447 0.458521 1.242927 0.587312 1.726991 0.987710 0.168427 1.112409 0.233710 0.476465 1.063291 1.023410 1.387257 1.104431 1.814614)
     )

;;; 44 odd -------------------------------------------------------------------------------- ; 6.6332
(vector 44 7.9338580613871 #r(0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0)

     6.599250 #r(0.000000 0.351178 1.306835 1.466283 1.319851 0.565360 0.401323 -0.237018 1.055625 0.418518 0.685726 1.681541 1.845435 1.019294 1.472175 1.617323 0.599443 0.202024 1.548869 0.896807 1.498980 -0.449736 0.958935 0.672395 0.465421 0.363298 0.745996 0.800573 1.320237 0.704768 1.103042 1.233693 0.653096 1.449790 0.411870 1.110453 0.556583 1.736823 0.345497 0.024788 0.937504 1.224464 1.559019 1.346766)
     )

;;; 45 odd -------------------------------------------------------------------------------- ; 6.7082
(vector 45 8.1351366043091 #r(0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0)

     6.624897 #r(0.000000 1.004365 0.475962 1.144412 0.404466 0.708852 0.590380 0.024072 1.172296 1.113281 1.630362 1.256665 1.314082 0.342438 0.579726 1.460036 0.838934 0.298273 1.354989 1.643563 1.558056 1.967600 0.749164 1.349815 0.523705 0.276619 1.145711 1.733713 1.155806 1.020242 0.468578 1.677226 1.799379 1.623813 1.799356 0.670303 1.547676 1.429802 1.095547 0.114545 0.743241 1.141259 0.963105 1.247487 0.978965)
     )

;;; 46 odd -------------------------------------------------------------------------------- ; 6.7823
(vector 46 8.1455316543579 #r(0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1)

     6.709237 #r(0.000000 0.588728 0.764172 0.948247 0.778447 1.268756 0.080491 -0.381973 0.448541 1.688302 0.583900 0.609230 0.913000 1.244782 0.098190 0.458033 0.787717 0.012905 0.854674 1.035325 1.255759 0.507374 1.208176 0.514489 0.741105 1.441899 0.585374 1.583344 0.643511 1.525932 1.201616 0.846916 0.319659 0.030560 0.895113 0.341984 -0.007305 1.588064 0.007988 0.334683 0.349739 -0.215667 -0.068989 1.488454 0.988215 0.867211)
     )

;;; 47 odd -------------------------------------------------------------------------------- ; 6.8556
(vector 47 8.336971282959  #r(0 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 1 0)

     6.785244 #r(0.000000 0.898263 0.698671 0.821497 0.370262 0.536725 0.016930 1.555315 1.553643 1.249848 -0.203480 1.765177 0.026588 0.111231 -0.039332 0.662791 0.096267 1.286138 1.353013 0.226230 0.057438 1.648120 -0.088502 0.524016 1.306955 -0.084552 0.350695 1.753518 1.303444 0.678968 0.693452 0.498589 1.005882 1.660165 0.430707 0.068634 0.587061 1.130543 1.939600 0.152146 1.459634 0.723147 1.428638 0.763075 1.800028 1.481715 0.488673)
     )

;;; 48 odd -------------------------------------------------------------------------------- ; 6.9282
(vector 48 8.35563071219336 #r(0 1 0 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1)

     6.828028 #r(0.000000 0.998004 1.077433 0.148071 1.527370 -0.144913 1.645316 1.723923 0.412024 1.174877 0.494923 1.411660 0.605628 1.628272 1.064698 1.228914 0.098971 0.692407 0.395792 1.297327 -0.001580 1.140646 1.342219 1.577941 0.241000 1.510351 1.184692 1.697190 1.378912 1.591005 -0.082196 0.468455 0.883072 0.625939 0.755107 0.095773 0.293743 0.637279 1.770381 1.345208 0.924216 0.393583 0.137327 1.278382 0.157871 0.442417 0.371701 -0.029442)
     )

;;; 49 odd -------------------------------------------------------------------------------- ; 7
(vector 49 8.57458718352971 #r(0 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0)

	6.988750 #r(0.000000 -0.166791 0.066489 1.162315 1.337152 0.223301 0.045811 -0.093825 1.332601 1.728915 0.870363 0.493056 0.773831 1.546388 0.179602 0.790122 1.699394 1.317163 1.725149 1.408847 1.015662 0.639057 1.163324 0.986617 1.318547 -0.170292 0.080070 1.239083 1.484292 1.779081 0.940479 0.037560 -0.006305 1.151063 0.903661 1.767180 1.162011 1.427957 0.814000 1.843040 0.477534 1.459006 0.756363 0.414970 1.321498 0.061120 0.265825 0.092137 0.202930)
	6.985814 #r(0.000000 1.352748 1.065088 0.376466 1.263775 1.869507 0.064753 1.165618 0.141890 0.638515 0.828094 1.038958 1.583826 1.734755 1.477486 1.795519 0.004163 0.751410 1.671716 1.124011 0.269271 1.493917 0.669031 1.045125 0.496799 1.530976 1.616053 1.745132 0.120791 1.586151 1.862818 1.592630 1.615032 1.872559 1.107306 1.049698 0.182616 1.894893 0.054689 0.854276 1.308061 1.075982 0.240671 0.749058 1.273625 0.766343 0.677203 0.139645 1.215492)
     )

;;; 50 odd -------------------------------------------------------------------------------- ; 7.07
(vector 50 8.711 #r(0 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1)

     6.947137 #r(0.000000 1.361221 1.058873 0.255818 1.371652 1.848584 -0.002271 1.052656 0.139885 0.680884 0.885258 1.006144 1.663943 1.665052 1.470510 1.693036 0.091983 0.825894 1.755289 1.033123 0.055566 1.508725 0.691199 1.233170 0.641006 1.442066 1.557992 1.909688 0.175284 1.577225 1.678517 1.358807 1.558359 1.883371 1.133931 1.053187 0.137949 1.901321 0.058023 0.971798 1.378739 0.843519 0.357409 0.498187 1.235125 0.734586 0.653589 0.242791 1.085625 -0.043484)
     )

;;; 51 odd -------------------------------------------------------------------------------- ; 7.141
(vector 51 8.5829010009766 #r(0 1 0 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0)

     7.087726 #r(0.000000 0.875029 0.865937 0.367918 1.900818 0.762934 0.081270 0.353365 0.070375 -0.037477 1.275772 -0.100171 1.088567 1.481918 0.798713 1.260047 0.731048 1.035501 1.384103 0.728234 0.608922 1.769831 1.228331 0.727930 1.038826 -0.062865 0.731133 1.490525 1.564219 0.530975 0.845759 -0.127106 1.209031 0.537607 1.042200 0.906452 -0.105250 0.353212 0.368083 1.395843 1.206034 1.694293 0.348968 0.222228 0.523051 0.375570 0.283017 1.406111 0.934909 0.587260 0.940073)
     )

;;; 52 odd -------------------------------------------------------------------------------- ; 7.211
(vector 52 8.8599758148193 #r(0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 1 0 1 1 0 1 0 0 0 1)

     7.080087 #r(0.000000 0.216994 0.815073 0.651401 0.471967 0.035007 -0.067747 0.660856 0.580235 0.052345 1.785696 0.529423 0.205578 -0.247148 1.238971 0.096672 0.952857 0.166426 0.759284 1.719458 0.161518 1.592928 0.883009 0.245604 1.208605 0.995562 0.029395 0.487673 1.152615 0.362903 0.721410 0.862934 0.090743 0.014994 0.082182 0.993529 1.056537 1.708353 0.746025 -0.333233 1.155949 0.740213 0.619117 1.020646 1.502770 1.347142 1.371490 1.480724 0.363059 1.828476 0.147552 0.424061)
     )

;;; 53 odd -------------------------------------------------------------------------------- ; 7.280
(vector 53 9.037 #r(0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0)

     7.252601 #r(0.000000 1.316368 0.101159 0.287376 -0.120486 -0.146148 -0.293575 0.279566 1.566833 0.692861 -0.116203 1.111486 1.592177 1.082742 0.010661 0.754630 0.400780 0.795713 1.670109 1.185717 1.226796 -0.120012 0.262637 0.206364 0.738299 0.157263 0.604374 0.683095 1.946305 -0.043066 0.580881 1.320138 -0.043078 1.307240 1.171743 0.356072 0.398418 -0.096678 0.059824 1.235855 0.057573 -0.031810 1.322088 0.600804 1.405030 -0.237620 -0.007423 -0.083489 1.021491 1.628805 -0.222749 0.516076 0.301362)
     )

;;; 54 odd -------------------------------------------------------------------------------- ; 7.348
(vector 54 9.025 #r(0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0)

     7.328138 #r(0.000000 0.352535 1.363504 0.096670 1.597330 -0.030072 1.222144 1.243528 0.696875 0.968663 0.162138 1.056566 0.539804 0.008667 0.316670 -0.098837 1.225380 -0.112322 0.244903 0.436331 1.746403 0.122260 0.091220 1.558109 1.217585 1.412994 0.339182 0.690620 1.846588 1.658518 0.529876 1.420789 0.398352 0.612668 1.926173 0.676632 0.529358 1.076039 0.628593 -0.021834 1.281928 0.607717 0.819453 1.795488 1.260788 0.439390 0.834961 1.345636 1.190831 1.783406 -0.135996 0.097131 0.579836 0.358027)
     )

;;; 55 odd -------------------------------------------------------------------------------- ; 7.416
(vector 55 9.2039985656738 #r(0 0 1 1 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1)

     7.364233 #r(0.000000 0.395190 -0.153867 1.307052 0.778840 1.201427 1.584425 -0.091689 1.563398 0.221226 1.485388 0.595790 -0.041635 0.380534 0.103234 0.445988 1.706774 1.178799 1.315522 1.096083 0.260274 -0.072891 0.228062 0.239593 1.575799 0.203611 0.427975 1.251992 1.620128 0.666682 0.636489 0.025180 0.388251 0.546392 1.107252 0.996609 1.708598 0.607806 -0.354744 1.114522 1.187212 0.060556 1.020751 1.136440 0.719385 1.579705 0.166783 0.736570 0.421572 0.534881 0.141987 1.649951 0.500500 0.386302 -0.074892)
     )

;;; 56 odd -------------------------------------------------------------------------------- ; 7.483
(vector 56 9.3816785812378 #r(0 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 0)

     7.419120 #r(0.000000 0.417128 1.082491 1.276854 0.765982 1.295111 1.835030 1.786443 0.675192 1.020185 0.394420 0.359608 0.697463 1.166247 0.564899 1.087103 0.889865 0.844186 1.419287 1.562675 0.248998 1.869468 1.111986 1.294693 1.863255 0.052934 0.338636 1.626312 1.601681 -0.021561 1.462490 1.791020 0.409025 1.675990 1.011444 1.359048 1.605820 1.247285 1.024241 0.457113 0.153603 0.242127 1.175155 0.206257 1.412766 1.496703 -0.140135 1.270904 0.393803 1.315634 0.897708 1.585792 0.563930 1.722379 1.612675 1.047507)
     )

;;; 57 odd -------------------------------------------------------------------------------- ; 7.549
(vector 57 9.3903837203979 #r(0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 0)

     7.488896 #r(0.000000 -0.127939 1.380652 0.701541 0.779535 0.090662 1.662797 0.879717 1.570316 1.307786 1.211090 0.971455 0.738042 1.474139 1.501173 1.322773 -0.333947 0.651999 1.407414 0.559437 0.970911 0.613447 1.441437 0.387240 1.769723 0.695953 -0.175580 0.102181 0.180022 1.529463 0.468743 0.084931 0.062956 0.298511 0.524008 0.924744 1.286647 1.428978 0.334028 1.302926 0.807711 0.283976 0.097723 1.284073 0.038191 0.329167 1.275797 0.351298 1.518403 1.571791 0.227818 0.842734 0.707030 0.435243 0.618490 0.867851 1.852691)
     )

;;; 58 odd -------------------------------------------------------------------------------- ; 7.6157
(vector 58 9.5893135070801 #r(0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 0 0)

     7.585947 #r(0.000000 0.517595 -0.138781 1.328351 0.394157 0.908218 0.526218 1.063012 1.239066 1.277916 1.783309 1.590363 0.539572 1.425376 1.601385 0.376842 0.888852 1.358950 1.916790 1.468314 0.490842 0.036065 1.359391 1.047397 0.699655 1.225098 0.065253 0.350008 0.483077 1.188989 1.002860 0.893562 0.202836 0.208109 1.801392 1.050084 -0.102454 1.813439 1.482474 -0.166271 1.426695 0.563055 -0.225427 0.436837 1.102639 0.467507 0.283291 1.511898 0.400494 1.606371 -0.049354 1.495330 -0.267319 0.336083 0.925094 0.220186 1.902233 -0.035784)
     )

;;; 59 odd -------------------------------------------------------------------------------- ; 7.681
(vector 59 9.5173864364624 #r(0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0)

     7.617785 #r(0.000000 1.762340 0.513621 1.350480 0.395272 0.369068 0.305583 0.831518 1.232517 0.676844 0.014044 1.888953 1.633364 1.298874 0.424500 1.402106 0.715815 1.275937 1.488547 1.873193 1.738228 0.570388 0.057875 1.975863 0.297300 1.563912 0.772704 0.090655 0.241787 1.145030 0.785784 1.432008 1.006607 1.408581 0.812224 0.224382 0.926131 0.944185 -0.064326 0.205583 1.060366 0.673429 1.237483 1.421583 0.464247 1.651757 1.984268 1.030220 1.489122 1.350599 0.646010 1.371095 0.262034 0.720620 1.557135 1.181053 0.745491 0.926931 1.443337)
     )

;;; 60 odd -------------------------------------------------------------------------------- ; 7.7459
(vector 60 9.6560277938843 #r(0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 1 1 1 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0)

     7.699628 #r(0.000000 -0.021305 0.599580 1.675097 0.724803 0.358532 0.890770 0.765518 0.237166 0.821603 0.185949 0.996346 -0.076908 1.733595 1.718331 -0.080896 1.631867 0.229557 1.219113 -0.444442 1.509828 0.286787 0.741904 1.151478 1.816287 -0.008152 -0.169986 1.514652 0.248473 1.296089 1.211441 0.399013 0.342384 1.801962 0.377537 0.181714 1.809056 1.599925 0.494049 0.298590 0.110648 0.855221 1.804868 0.666943 1.224265 1.636192 1.425598 0.559152 0.087897 0.972335 -0.105600 1.103327 1.345409 0.428767 -0.084957 1.609410 0.060258 0.846549 0.678506 0.580784)
     )

;;; 61 odd -------------------------------------------------------------------------------- ; 7.8102
(vector 61 9.6689287776524 #r(0 0 0 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1)

     7.775467 #r(0.000000 -0.343145 0.781525 1.809127 0.251480 0.512435 0.079273 1.157280 0.819596 0.391398 -0.518556 1.678636 0.560600 0.125318 0.035700 1.744672 1.824327 1.087291 1.692006 0.706036 0.269610 1.403225 1.233897 0.487088 1.476172 -0.284871 0.794501 1.368364 0.656660 0.974817 1.000338 0.175726 1.024682 0.865508 0.404847 0.718158 0.071740 1.457732 -0.480756 0.735357 1.217441 0.811494 1.022056 0.829877 1.509011 1.174960 1.639594 0.781475 -0.011943 1.221853 -0.208689 0.133149 0.650142 1.217107 -0.446658 0.092120 -0.062880 0.676055 0.910707 0.946198 0.780527)
     )

;;; 62 odd -------------------------------------------------------------------------------- ; 7.8740
(vector 62 9.7982149124146 #r(0 0 1 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 0)

     7.816985 #r(0.000000 0.185485 -0.254761 0.263400 0.632430 0.127767 1.483161 1.282005 1.556675 0.709224 0.293439 0.049467 -0.087443 1.425471 0.595679 0.678957 0.447779 0.382124 0.717681 0.082649 -1.563917 -0.140691 0.229960 0.339346 0.083428 0.640485 0.923623 -0.076532 1.385224 0.166806 1.518517 1.222370 1.575074 0.899045 0.324075 1.508603 -0.064272 0.115115 0.407781 0.298344 1.252368 1.084082 0.264721 0.922346 1.331199 0.689780 0.795795 1.526817 0.163429 0.888100 0.510259 1.478381 0.318687 1.341508 1.785614 0.798865 0.525568 1.053899 1.308203 0.410567 -0.026960 1.103176)
     )

;;; 63 odd -------------------------------------------------------------------------------- ; 7.9372
(vector 63 9.8550319671631 #r(0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 1 0)

     7.904133 #r(0.000000 1.545501 0.155683 0.898914 0.625696 0.564119 0.345790 0.703891 0.981672 1.014462 1.740323 0.008567 -0.039871 0.470077 1.202746 0.366398 0.367999 1.293490 0.310624 1.016687 1.843528 0.474437 1.864085 0.859066 0.880435 1.525047 0.949229 0.065485 0.658928 0.625456 0.890422 0.157110 0.668174 1.537633 -0.133525 1.887056 1.094821 1.580831 1.506736 1.621226 1.791740 1.492769 0.830911 0.166732 1.797834 0.044991 1.834240 1.000450 1.479368 0.610232 0.816463 1.240492 0.107919 -0.111385 1.348751 1.167090 0.907202 0.154866 1.422414 0.720983 0.430601 -0.041659 0.656229)
     )

;;; 64 odd -------------------------------------------------------------------------------- ; 8
(vector 64 10.0 #r(0 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0)

     7.957414 #r(0.000000 0.941670 0.218463 1.054436 0.821282 0.779097 1.084317 0.220811 0.530574 -0.001214 1.277468 1.056444 1.434429 0.244804 0.635637 0.374642 1.294283 0.051882 1.563945 0.856817 0.659797 0.848723 0.789207 0.004337 0.642492 -0.752744 0.794434 0.546992 1.340010 0.716341 1.722360 1.081100 1.009399 0.345867 1.393328 1.377443 1.264631 0.487017 1.142544 0.031648 0.469271 -0.098334 -0.019627 0.567023 1.791954 0.511740 0.421519 0.992945 1.133377 1.668348 -0.054246 0.158608 -0.042808 1.772093 0.331126 0.762153 1.499580 1.813299 1.079657 1.088576 0.368377 1.519001 0.864479 0.914946)
     )

;;; 65 odd -------------------------------------------------------------------------------- ; 8.0622
(vector 65 10.169842720032 #r(0 0 1 1 0 0 1 0 1 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1)

     8.040855 #r(0.000000 1.507786 1.415372 1.703926 1.500233 1.179747 -0.086038 1.271067 0.241330 1.453321 1.112825 0.408932 0.079619 0.501656 0.792814 1.679514 -0.023064 0.144220 0.265584 0.573417 1.899192 0.051511 1.631616 1.086663 1.410383 1.613900 0.536011 1.591177 0.698399 1.181483 1.728211 0.256554 -0.283132 0.355776 1.802436 1.248796 1.634590 1.262544 1.397780 0.053710 1.072831 0.031772 0.078446 0.128037 0.853258 1.218686 1.277789 0.847077 0.934403 1.722304 0.163187 0.957497 1.531555 1.320004 0.466076 -0.023032 1.791699 1.045097 0.495828 1.812354 0.196561 1.248643 0.569902 0.907793 0.854507)
     )

;;; 66 odd -------------------------------------------------------------------------------- ; 8.1240
(vector 66 10.212840820553 #r(0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 0)

     8.137089 #r(0.000000 0.867002 -0.091284 0.941017 0.985813 1.124822 -0.061065 0.794288 1.395872 1.715915 0.180754 1.493753 0.091406 -0.059796 0.775109 -0.175925 1.503403 0.926368 0.549523 0.719653 -0.225722 0.805496 0.016786 1.138759 0.185499 1.460462 1.586490 0.459741 1.668207 1.371214 0.709682 0.824263 0.306383 0.060221 1.519433 1.454263 1.678352 0.268698 0.281303 0.104475 0.990641 -0.061422 1.164978 0.345674 0.648924 1.140977 0.632657 0.963358 1.933250 0.002500 1.501010 0.074909 0.787595 1.107851 1.157288 1.691148 1.812947 1.291647 1.327838 1.731755 1.607111 1.129367 0.868934 1.256116 1.509418 0.963219)

     8.095195 #r(0.000000 0.946051 -0.069946 0.931149 1.114323 1.098389 -0.039332 0.877524 1.318916 1.775911 0.245290 1.539842 0.131201 -0.108794 0.748602 -0.153383 1.475925 0.851225 0.482687 0.831474 -0.195116 0.598903 -0.150418 1.241002 0.075671 1.415619 1.425349 0.401276 1.645496 1.378829 0.717955 0.820749 0.280776 0.102463 1.505118 1.466659 1.804612 0.370381 0.198640 0.039917 0.927835 0.130993 1.362388 0.264055 0.657827 1.168088 0.670275 0.998910 -0.080695 -0.000494 1.446059 0.092607 0.764024 1.120077 1.135001 1.626300 -0.038234 1.325677 1.373468 1.689492 1.591066 1.008988 0.840459 1.246657 1.459948 0.945345)
     )

;;; 67 odd -------------------------------------------------------------------------------- ; 8.1853
(vector 67 10.209677696228 #r(0 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 1 0 1)

     8.127999 #r(0.000000 0.156189 0.759312 0.316632 1.612933 0.605013 0.952530 0.423099 -0.112233 1.447269 0.863131 0.200670 1.538179 0.172873 0.737196 0.916694 1.524894 1.423218 1.337268 0.799228 0.023760 0.359774 1.033535 1.252717 0.399347 1.736421 0.199827 0.358145 1.847858 -0.157369 -0.118965 -0.296280 1.764663 0.918422 0.547247 0.781682 -0.101912 1.939111 1.078792 1.928250 0.777073 0.358591 1.566766 0.658960 0.895914 1.285541 1.636763 -0.098157 1.684110 0.891684 1.386081 0.068089 0.497477 0.528377 0.140207 0.953073 0.655659 0.018618 0.774991 0.503967 1.384065 0.100041 0.959741 0.153740 0.654728 0.200720 0.384936)
     )

;;; 68 odd -------------------------------------------------------------------------------- ; 8.24621
(vector 68 10.359804316765 #r(0 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 0 0 1 0)

     8.204414 #r(0.000000 0.279095 1.647677 0.913913 0.663406 0.323080 0.240930 0.148599 0.780719 0.015227 1.335435 0.919514 1.070941 0.877126 0.293550 1.686752 0.481693 0.755701 0.785320 0.815615 1.595420 1.293383 0.426688 0.494705 1.026142 0.549725 1.259770 -0.007824 0.278489 0.224750 0.082547 0.719555 0.355973 0.908801 0.541094 0.432336 1.241602 1.708744 0.772870 1.505613 -0.137480 0.654507 1.657469 0.849573 0.009380 1.611286 1.676352 1.046709 1.432096 0.979028 1.747525 0.522938 0.318568 1.148496 -0.245690 0.703484 0.171945 1.485079 1.659272 -0.006233 0.283657 1.852744 1.398727 0.371514 0.974831 1.325922 0.719933 0.483798)
     )

;;; 69 odd -------------------------------------------------------------------------------- ; 8.3066
(vector 69 10.452348709106 #r(0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1)

     8.274908 #r(0.000000 1.788801 1.283513 -0.242756 0.145250 0.146755 0.584479 1.353542 0.821070 0.189803 1.413669 0.749926 1.058442 1.185407 1.095039 1.015258 0.161858 0.034929 0.498704 0.198138 1.711445 0.157768 0.616185 1.421248 1.168404 0.254474 1.519482 -0.175837 0.581687 0.194579 0.931780 -0.336100 0.287461 1.495068 0.039168 1.507647 0.993152 1.382317 1.231363 0.721890 1.622206 1.080570 0.186638 0.155662 0.909604 1.203958 1.050254 1.890059 0.428940 0.701250 -0.160137 0.279994 1.502298 0.567568 0.585424 0.686015 -0.246566 0.662061 0.986133 1.103373 0.572438 0.607162 -0.159332 0.926622 1.112278 0.937694 0.624990 1.345312 0.670451)
     )

;;; 70 odd -------------------------------------------------------------------------------- ; 8.3666
(vector 70 10.431521047498 #r(0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 1 1)

     8.328488 #r(0.000000 1.209391 0.655351 -0.224668 0.270551 0.912782 1.006468 0.115362 1.639506 1.394128 1.775544 -0.158964 -0.191285 0.916307 -0.148807 -0.343643 0.171981 0.447415 0.684977 -0.187759 0.122627 0.642332 0.846737 0.920787 0.824105 -0.455822 1.004331 0.650453 0.327784 -0.378239 0.335174 0.883411 0.475111 1.924029 1.429019 1.351303 -0.183533 1.395982 0.599233 0.896200 1.135652 0.575692 1.213789 1.853140 0.377792 1.790714 0.835251 1.493542 0.305236 1.538414 0.647163 0.263422 1.348466 1.037276 0.893701 1.108073 -0.492190 -0.249170 1.081128 0.973414 0.593299 0.786885 0.003725 0.855855 1.605169 1.050037 0.831705 1.193285 0.128148 0.709803)
     )

;;; 71 odd -------------------------------------------------------------------------------- ; 8.4261
(vector 71 10.642364501953 #r(0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 0 0)

	8.383514 #r(0.000000 1.185298 0.116042 1.091638 0.092095 0.944947 0.102271 0.915149 1.750053 0.485778 1.383200 0.211530 0.862686 1.607558 0.338543 1.220252 1.822776 0.384578 0.842174 1.479065 0.101864 0.525001 0.798322 0.852215 1.596297 0.205674 0.038735 0.440702 1.266574 1.519994 1.627453 -0.116698 0.274743 -0.092846 0.414048 0.680894 0.850034 0.611891 0.773865 0.799723 0.948168 0.795050 0.386289 0.687156 0.139254 0.239355 0.431827 1.449182 1.225677 1.018884 0.815038 0.231330 0.044514 0.056652 1.511296 0.700931 0.111889 -0.266780 1.539396 0.924047 0.245892 -0.239038 1.134806 0.447706 -0.314739 1.073421 0.342294 1.686009 0.291079 -0.242099 1.241743)
     )

;;; 72 odd -------------------------------------------------------------------------------- ; 8.4853
(vector 72 10.880306243896 #r(0 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 0 0 0 1)

     8.366430 #r(0.000000 1.529157 0.709835 0.191619 0.777505 1.673931 1.052039 1.157229 0.197845 1.188203 0.205209 0.808312 1.907251 0.734102 1.471024 1.752009 0.976735 0.215092 1.669497 0.039070 0.308185 0.805661 0.414650 0.685942 0.933087 1.104471 0.869537 0.010581 1.431457 1.039490 0.654718 0.051163 1.637896 0.041328 0.434461 1.596916 0.630066 0.513683 1.126090 1.472280 0.029687 0.729904 0.900726 0.364456 0.829387 0.775767 0.087943 1.122617 0.054278 0.980310 0.814649 1.331669 0.404897 1.438813 0.751132 1.069103 1.033498 0.950755 0.588560 0.206118 0.697556 1.364322 0.007771 0.225318 -0.029948 1.266843 1.008881 -0.515131 0.251545 0.235634 0.009431 1.881826)
     )

;;; 73 odd -------------------------------------------------------------------------------- ; 8.5440
(vector 73 10.907942771912 #r(0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1)

     8.514653 #r(0.000000 1.403201 0.376583 -0.053235 1.209136 1.524715 0.146380 -0.261365 0.834173 1.272975 1.772227 0.023615 0.314599 1.515420 0.115615 0.532763 0.813612 1.148749 0.624829 1.610666 0.428301 0.533410 1.364035 0.688805 -0.345103 -0.033075 0.031988 1.294508 1.610808 0.200563 1.512417 1.458407 0.018985 0.336604 -0.051222 0.346655 1.033154 0.703796 1.103730 1.139661 0.592095 0.478459 0.370549 0.620498 -0.386452 0.468708 0.040902 1.488975 0.539537 0.999795 0.347372 0.354446 0.387241 1.176009 1.306213 0.778993 0.280166 0.010910 0.034863 0.320352 1.620759 0.391262 0.863014 -0.075789 1.338588 1.092040 0.260638 1.463660 0.169121 0.826134 0.241084 1.728130 -0.116721)
     )

;;; 74 odd -------------------------------------------------------------------------------- ; 8.6023
(vector 74 11.262331896     #r(0 0 1 1 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0)

     8.487915 #r(0.000000 0.229202 0.328610 0.886519 0.913243 -0.092303 1.469261 1.392280 0.102684 0.875868 1.119399 -0.375546 1.138609 1.792722 0.270873 0.158504 1.300583 0.337402 0.457798 0.994721 0.720190 1.266403 1.157785 0.204200 0.832717 1.368187 -0.207911 0.551921 0.143469 0.767289 -0.041673 0.248888 0.686134 1.808117 1.719833 1.634354 -0.372228 1.923379 1.132948 1.667043 0.857041 1.387145 0.637791 -0.326159 0.280564 1.478231 0.572776 0.063470 1.115045 1.234238 1.093760 0.166042 1.189669 0.933614 0.159392 1.594960 1.079073 1.251388 1.747471 1.137640 1.343339 1.096317 0.655141 0.037576 1.286106 -0.396608 1.310863 1.072774 0.013655 0.220749 -0.215382 0.087335 1.489739 0.952386)
     )

;;; 75 odd -------------------------------------------------------------------------------- ; 8.6603
(vector 75 10.942812919617 #r(0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 0 1 1)

     8.649507 #r(0.000000 1.109688 1.876179 -0.024908 0.874394 0.094974 0.967726 0.182001 1.798004 0.764080 1.705983 0.246581 0.919892 -0.031641 0.074543 1.466120 -0.542452 1.308866 1.354893 0.937217 0.141091 0.972731 1.649929 0.076730 0.306081 1.082330 -0.056612 -0.033267 0.417204 0.002975 0.510299 0.334065 0.921554 0.578842 0.861949 0.516829 0.507298 0.089901 1.846522 0.266232 1.636125 0.773196 1.708397 0.143239 0.982116 1.755516 1.504659 0.043743 0.095624 0.325057 0.879744 1.064185 1.252657 0.311473 1.870059 0.309527 1.581011 1.908962 0.734045 1.785988 0.038323 0.023116 0.922283 0.858183 0.320752 1.741469 1.289108 0.871189 -0.238214 1.531119 1.355752 0.609175 0.669122 0.984951 0.033177)
     8.620700 #r(0.000000 0.323248 0.317594 0.968808 0.994561 -0.104573 1.389992 1.355213 0.030411 0.985652 1.052974 -0.337840 1.125354 1.829155 0.220921 0.163351 1.380268 0.348537 0.468289 0.962643 0.656934 1.260196 1.184202 0.082746 0.792199 1.382268 -0.060133 0.610903 0.048226 0.758166 0.111389 0.445353 0.626919 1.823766 1.919332 1.584236 -0.359706 1.902296 1.227860 1.813879 0.850492 1.501670 0.807199 -0.423864 0.375418 1.410233 0.564183 -0.023510 1.218078 1.230705 1.078769 0.189372 1.076681 0.977493 0.096444 1.695019 1.093760 1.247664 1.799255 1.288227 1.524084 1.110414 0.566556 -0.036346 1.348516 -0.372587 1.315425 1.037394 0.060664 0.095602 -0.073853 0.261074 1.444286 1.030300 -0.139619)
     )

;;; 76 odd -------------------------------------------------------------------------------- ; 8.7178
(vector 76 11.21743106842 #r(0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 0 0 0 0)

     8.651279 #r(0.000000 0.173353 0.839453 0.789458 1.213196 0.485342 1.020793 1.079117 1.510944 0.872759 1.658963 0.469539 1.282086 0.224500 1.187595 1.001928 0.601189 0.457802 1.523606 0.013310 0.486526 1.038767 0.887428 0.818932 0.429987 0.518887 0.949464 1.376735 0.275451 0.805159 0.132159 1.431344 0.575428 0.009721 1.711880 1.360202 0.416637 0.859810 0.491831 0.882963 0.253397 0.012929 1.530000 0.177927 1.883242 1.959160 0.357646 1.604277 0.939839 1.031583 0.502599 0.924357 -0.060587 1.148550 0.762073 0.585290 1.515308 1.022656 0.505967 0.958132 1.937796 0.289650 0.388753 1.349929 0.430727 1.688517 1.350532 0.156971 0.890960 0.708951 1.606885 1.582622 1.628222 1.565608 0.127771 0.825769)
     )

;;; 77 odd -------------------------------------------------------------------------------- ; 8.7750
(vector 77 11.192246437073 #r(0 1 0 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0)

     8.707019 #r(0.000000 1.733898 1.602888 1.700625 0.951967 1.205480 0.494785 0.079322 1.861432 1.411332 0.615577 0.456043 0.176616 0.522662 0.530871 0.948923 1.312747 1.035434 -0.217439 1.260792 0.366350 -0.233439 0.849314 1.174459 -0.193276 1.451248 0.290403 1.453670 0.668542 0.644436 1.306523 1.198202 0.657361 0.888118 1.964614 0.824349 -1.765380 0.784141 0.143386 -0.053030 0.033585 0.726269 -0.055055 0.121221 1.064245 1.578078 0.715470 -0.211778 1.194974 -0.095151 0.313319 0.914111 -0.007802 0.154723 0.086177 1.895682 1.191957 -0.344176 -0.285803 0.072705 0.944928 0.649978 0.107843 0.251480 -0.267013 1.016287 0.107966 1.055797 1.067984 1.857635 0.230948 0.492625 0.104053 0.572353 1.732176 0.353482 0.821975)
     )

;;; 78 odd -------------------------------------------------------------------------------- ; 8.8318
(vector 78 11.455265310659 #r(0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 0 0)

     8.715270 #r(0.000000 1.669247 0.757594 0.165819 0.288294 0.684770 0.557521 0.680526 1.097350 0.470057 1.849497 1.090608 0.922922 1.129049 0.104794 -0.129005 0.326960 -0.051784 1.142568 0.483331 0.896117 0.813482 0.302867 0.073158 -0.168821 0.656167 0.700004 1.004810 -0.007423 -0.189996 0.560929 0.412734 0.830296 1.110767 -0.043008 0.613326 0.576197 0.610404 1.233787 0.583712 0.887457 1.853983 1.162911 1.497407 0.204463 1.117898 1.731543 1.711291 0.816677 1.207698 1.691953 0.214296 -0.046452 0.692536 0.108168 0.208702 0.459557 1.630550 -0.229002 1.446147 1.208030 -0.028606 1.708585 1.336818 1.004606 0.393864 1.182948 -0.208442 1.255124 0.056920 1.572769 0.643674 1.170025 0.291140 1.025254 0.562266 0.633856 0.124004)
     )

;;; 79 odd -------------------------------------------------------------------------------- ; 8.8882
(vector 79 11.54291004024 #r(0 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0)

     8.864559 #r(0.000000 0.357256 0.036759 1.292339 -1.618603 1.176406 0.544736 0.398074 0.109043 0.617241 0.697903 1.118083 1.422870 1.215951 0.004362 1.621202 0.264308 0.010496 1.213090 1.597753 -0.054911 1.223572 0.202448 0.615339 0.757193 0.130847 1.245098 1.256256 1.117774 0.701640 1.170787 1.057213 -0.087146 1.024522 1.105914 1.493238 0.672326 0.950638 -0.158430 0.266150 1.329043 0.773121 1.527296 -0.078973 1.669452 1.490229 0.141063 1.057903 0.727028 1.146281 0.010335 0.602841 1.428986 1.325796 1.320411 -0.094534 0.491229 0.443206 1.223761 0.317919 0.333487 -0.004296 1.074159 1.511918 1.245758 0.213171 1.140531 1.245789 0.552067 1.083032 0.600490 0.777304 0.106919 1.336123 1.060329 1.059212 0.289692 1.668881 1.086200)
     )

;;; 80 odd -------------------------------------------------------------------------------- ; 8.9443
(vector 80 11.122416496277 #r(0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 1 1)

     8.870144 #r(0.000000 0.655710 0.591720 1.625031 0.418269 1.346736 0.349691 1.735905 1.181438 1.185938 0.537355 1.048431 0.310338 0.725392 0.138830 -0.162626 -0.012235 1.033480 1.181949 0.616925 1.912794 0.918753 0.626238 0.223870 0.664522 -0.078088 0.256973 1.394811 0.721353 1.350998 0.870615 0.111718 1.175636 1.041732 -0.087582 0.658928 1.024480 -0.106481 0.957206 0.153547 0.343423 1.369668 0.634606 0.765343 -0.148776 0.328436 0.827668 1.133483 1.461950 0.929478 0.348570 1.212214 0.446866 0.848436 0.219387 1.773456 1.168998 0.793903 0.614230 1.089360 1.446367 1.640320 0.120507 0.926616 0.816912 0.468029 0.525200 0.868913 1.510302 1.541893 -0.030330 0.055242 0.070867 0.042035 1.687456 0.144651 -0.241563 0.096801 -0.095086 0.917714)
     )

;;; 81 odd -------------------------------------------------------------------------------- ; 9
(vector 81 11.372210502625 #r(0 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1)

     8.926326 #r(0.000000 0.164735 -0.380225 0.081555 1.097918 1.524480 0.077656 0.977304 0.407700 0.831319 0.533822 0.615403 1.642513 -0.058036 0.444751 1.446330 0.995710 0.841112 0.528746 0.832226 0.248085 0.502898 1.190162 0.745146 -0.208212 0.492995 1.110378 0.980131 0.817203 1.338834 1.000001 1.336192 1.804389 0.900670 0.555661 1.748659 0.603816 0.728857 -0.167279 1.058563 1.176033 1.277029 1.122180 1.127499 -0.224172 0.316000 1.080199 0.508511 0.252234 0.338999 0.400496 1.857653 0.607017 0.245631 0.807136 -0.037588 -0.063570 1.552479 1.126540 0.180335 0.976685 0.410774 1.244176 1.541645 1.450598 0.050542 0.208414 1.102430 0.959489 0.189328 0.354550 1.724776 1.384943 0.545643 1.965929 0.479461 0.756949 1.038515 -0.004640 1.477899 0.906680)
     )

;;; 82 odd -------------------------------------------------------------------------------- ; 9.0554
(vector 82 11.662058134504 #r(0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 0 0)

     8.895498 #r(0.000000 1.650756 0.929235 0.669074 0.458613 1.575883 1.406092 1.106790 0.596730 0.021347 1.134970 0.616933 1.701827 0.504785 1.614982 1.519418 0.470952 1.289129 0.059550 0.427695 0.231422 1.559220 0.383709 0.161407 0.068209 -0.031038 1.865998 -0.109083 1.124535 0.249567 0.520329 0.463755 1.759816 0.122747 -0.063135 1.879507 0.089457 0.845717 1.061947 -0.248630 -0.240924 0.207853 1.548893 0.621489 0.599673 1.031885 -0.104736 1.726398 0.898686 0.128558 0.928155 1.723232 0.730130 1.329452 0.779285 1.207734 0.370523 1.269134 1.812531 0.562255 0.696469 1.440871 0.214062 1.838981 0.082605 1.605017 1.504365 0.122097 0.273097 0.895327 0.555120 -0.358045 0.959494 0.864915 1.049696 1.458692 1.063317 -0.105762 0.240946 0.516137 0.295184 -0.035654)
     )

;;; 83 odd -------------------------------------------------------------------------------- ; 9.1104
(vector 83 11.732900669843 #r(0 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1)

     9.060733 #r(0.000000 0.847614 1.074595 0.345210 0.202371 1.511917 1.112425 0.572830 1.582187 0.218687 0.979697 0.829284 0.504832 0.409321 1.581223 1.031036 0.666780 1.347208 1.680503 1.486577 0.618089 -0.256946 0.905019 0.230952 0.059969 -0.145434 0.545921 0.384376 1.384380 0.665205 1.583895 0.055621 1.669433 1.386960 1.917214 0.552314 1.477586 0.229404 -0.049820 0.210015 -0.192839 1.819422 0.656731 1.258726 0.062676 0.649682 -0.033937 1.076469 0.763030 0.654748 1.032680 0.850557 0.101236 1.303860 1.683735 0.917766 1.133625 0.788918 0.091033 0.752267 0.650807 0.661591 0.956487 -0.151184 1.699725 0.067039 0.562858 0.669739 1.945082 0.507537 0.168655 1.291963 1.367257 0.073343 1.018407 0.584241 1.284655 0.733315 0.794277 0.838058 0.819351 1.776021 0.236189)
     )

;;; 84 odd -------------------------------------------------------------------------------- ; 9.1652
(vector 84 11.626023292542 #r(0 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1)

     9.185550 #r(0.000000 -0.021653 -0.040601 1.163796 1.903509 0.943755 0.646624 1.866284 1.925515 0.123826 0.553199 0.965947 -0.075756 1.082744 1.817561 1.285536 1.050220 0.807240 0.605743 0.429498 0.508235 1.302559 1.611197 -0.514061 0.753992 1.700832 1.582166 0.521137 0.493019 0.834823 1.698189 0.272829 1.846496 1.874128 0.834101 0.281869 1.080560 1.438521 0.953941 1.280344 1.022208 1.661905 1.607595 1.126422 0.777808 0.689451 0.023149 0.691721 0.542242 0.838865 0.011483 1.098563 0.333470 0.611697 0.199907 -0.091248 0.912993 0.515958 1.079940 1.005613 0.731323 0.930947 0.301128 0.363360 0.978049 -0.000124 -0.516420 0.523117 0.574889 0.270432 1.275532 0.818251 1.531964 1.322842 0.207974 1.087144 1.315578 0.094014 1.345898 1.884730 0.414183 1.230212 1.440972 0.367718)

     ;; #r(10.778808034738 -0.227659005925 3.1786048937356)
     ;; 10.7788 #r(0.0000 0.9393 1.9022 0.8886 1.8986 0.9322 1.9893 1.0700 0.1743 1.3021 0.4535 1.6284 0.8269 0.0490 1.2946 0.5638 1.8566 1.1729 0.5128 1.8762 1.2632 0.6738 0.1079 1.5656 1.0469 0.5517 0.0801 1.6320 1.2075 0.8066 0.4292 0.0754 1.7452 1.4385 1.1554 0.8959 0.6599 0.4474 0.2586 0.0933 1.9515 1.8334 1.7387 1.6677 1.6202 1.5963 1.5959 1.6191 1.6659 1.7362 1.8301 1.9476 0.0886 0.2531 0.4413 0.6530 0.8882 1.1471 1.4295 1.7354 0.0649 0.4180 0.7947 1.1949 1.6186 0.0660 0.5368 1.0313 1.5493 0.0909 0.6560 1.2448 1.8570 0.4929 1.1522 1.8352 0.5417 1.2718 0.0254 0.8027 1.6034 0.4278 1.2757 0.1471 )

     9.165706 #r(0.000000 0.934656 0.009740 0.892912 1.914788 0.817407 -0.047164 1.003969 0.164884 1.249319 0.380071 1.616476 0.954376 0.202231 1.312292 0.604557 -0.077459 1.312472 0.754364 -0.003767 1.276135 0.650523 0.170854 1.618591 1.053160 0.577476 -0.205916 1.453889 1.286143 0.889924 0.243897 -0.239706 1.833300 1.444468 1.151374 0.857183 0.586020 0.323924 0.036983 0.119493 -0.037558 1.940953 1.593882 -0.092635 1.798428 1.555339 1.399215 1.467642 1.835150 1.833867 -0.004678 -0.067916 0.264183 0.072836 0.826599 0.656778 1.089237 1.011513 1.337524 1.652586 0.118011 0.621082 0.947811 1.150679 1.538842 -0.108726 0.395215 0.886557 1.570811 -0.049501 0.809380 1.348209 1.743527 0.295071 1.055258 1.946886 0.463731 1.299054 0.188329 0.827519 0.037317 0.845744 1.341936 0.257273)

     9.138477 #r(0.000000 1.077136 0.063003 0.974335 0.001930 0.872203 0.017246 1.080670 0.235219 1.252888 0.378851 1.612382 0.956324 0.200975 1.336006 0.666511 -0.109401 1.250621 0.645704 -0.034379 1.373066 0.621844 0.153419 1.662637 1.014313 0.564772 -0.158790 1.458303 1.312400 0.935605 0.228083 -0.303405 1.933909 1.508310 1.203183 0.851210 0.700949 0.260045 0.137593 0.186330 -0.029149 0.093187 1.669321 -0.022893 1.804433 1.569916 1.547568 1.535838 1.866608 1.883016 0.163191 -0.079249 0.336381 0.043460 0.741963 0.718443 1.177177 1.028118 1.387506 1.729902 0.144100 0.716901 1.003307 1.132902 1.504355 -0.063217 0.409728 0.962060 1.632348 0.020339 0.842809 1.386919 1.688164 0.250155 0.883600 1.992873 0.466027 1.340844 0.278519 0.955099 -0.020386 0.926876 1.398431 0.248264)

     9.133456 #r(0.000000 1.059401 0.031287 0.939386 -0.017860 0.901644 0.001799 1.027990 0.230681 1.311963 0.341928 1.644077 0.966811 0.236475 1.300649 0.692497 -0.027953 1.347389 0.723063 -0.003313 1.322772 0.582050 0.159545 1.703814 1.026586 0.555590 -0.158337 1.444034 1.321735 1.003900 0.274358 -0.325622 1.927342 1.457207 1.230507 0.919830 0.720469 0.244803 0.085297 0.173845 -0.048361 0.080359 1.671325 0.039907 1.736091 1.631912 1.486133 1.471880 1.784848 1.922823 0.107240 -0.103436 0.280519 -0.025774 0.700275 0.720167 1.157653 1.036798 1.295565 1.717341 0.156191 0.724169 1.042098 1.172208 1.529978 -0.089227 0.426393 0.952547 1.692201 0.117254 0.809203 1.354853 1.694705 0.278490 0.926144 0.035100 0.434956 1.402186 0.356337 0.912787 0.017302 1.021860 1.401595 0.333844)
     
     )

;;; 85 odd -------------------------------------------------------------------------------- ; 9.2195
(vector 85 11.829360154975 #r(0 0 0 1 0 0 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1)

     9.172932 #r(0.000000 1.198268 -0.046093 0.496651 0.155499 0.438914 1.717129 -0.153996 0.255959 0.942459 -0.112043 1.664994 1.597976 1.071752 0.293731 1.489898 -0.088206 1.402767 1.814932 1.099748 -0.400724 1.351064 1.265640 1.075629 0.060651 -0.371046 0.814537 0.326687 0.633977 1.654428 1.582553 0.618025 1.054016 1.391986 1.098803 0.284271 1.476963 1.042434 1.922088 0.305413 -0.626240 1.791879 1.777727 0.678099 1.505684 1.182071 0.629820 1.357783 0.665420 0.341784 0.926591 0.193623 1.006880 1.192651 -0.116178 0.080172 1.591790 1.522361 0.438822 1.766471 0.395503 1.446548 -0.046614 0.961931 0.316539 0.616763 1.087859 0.290761 0.142685 0.155135 0.508154 0.686168 1.471184 1.165229 0.372220 0.294409 0.404832 -1.767095 1.243980 0.993281 1.007462 0.784244 1.104711 1.671816 0.086342)
     )

;;; 86 odd -------------------------------------------------------------------------------- ; 9.2736
(vector 86 12.140432277993 #r(0 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1)

     9.213343 #r(0.000000 0.676268 0.369198 1.486263 -0.026625 0.678855 0.928889 1.200870 0.763422 0.131815 -0.064018 0.334478 0.754549 0.549209 0.781916 -0.164085 1.831169 -0.359871 0.452632 0.395640 1.217523 1.666783 1.263104 0.462675 0.487261 1.713262 0.419400 0.982422 0.818648 0.009279 0.749148 0.986045 1.410580 0.251205 1.543152 0.685375 0.249458 0.699138 0.175620 0.312944 1.884362 1.099441 1.640835 1.728596 -0.397229 1.509431 0.364317 1.073248 1.571193 0.690550 1.201949 -0.104903 0.984182 0.850373 -0.106842 1.582861 -0.052279 0.837387 1.423896 1.118738 -0.077783 0.539913 1.394923 -0.009295 1.541216 0.438460 0.217352 0.527395 0.855264 0.357004 0.424674 0.870332 0.435096 0.770273 0.096843 1.702425 0.991351 1.315154 1.133850 0.440564 0.044541 0.788769 0.138246 -0.080948 1.096067 0.575869)
     )

;;; 87 odd -------------------------------------------------------------------------------- ; 9.32737905
(vector 87 11.937030388359 #r(0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 1)

	9.317037 #r(0.000000 1.269780 0.764198 1.382169 0.560101 1.397366 0.619615 1.110127 1.074742 0.786154 0.097129 0.187903 1.280480 1.001234 0.625991 -0.253578 0.524611 0.642531 0.754319 1.395067 1.865340 0.173765 1.213561 0.413784 0.704706 0.640451 1.483492 1.299442 0.783307 0.912207 0.977809 1.588075 -0.173310 1.063721 0.534821 0.450809 0.251070 0.792950 1.489833 1.745329 1.098607 0.960633 0.682333 0.343541 0.677820 0.343804 -0.007548 0.114569 1.083276 0.044826 0.931689 1.109596 -0.582840 1.287598 0.295851 -0.261696 1.183896 0.581304 -0.088958 1.623439 0.434479 0.025514 0.230711 1.672013 0.717129 1.395826 0.682208 -0.299168 -0.096350 -0.604219 1.679467 0.411395 0.711815 1.234251 0.324421 0.995113 0.167630 0.383406 0.968742 0.310771 0.425004 0.820195 0.922682 1.343873 0.606017 -0.248788 1.112139)
     )

;;; 88 odd -------------------------------------------------------------------------------- ; 9.3808
(vector 88 12.128922775356 #r(0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1)

     9.324023 #r(0.000000 0.720070 1.146170 1.623229 0.919914 1.475051 1.669418 0.417706 1.222880 1.077800 0.636671 0.109954 0.709268 0.401961 1.342317 0.470950 1.038199 -0.014165 -0.223115 1.401527 0.255061 -0.053613 1.038430 1.524899 0.900064 0.540757 0.958685 1.268571 0.665381 1.798791 1.658869 0.625852 0.519615 0.589311 -0.003435 1.345809 -0.056260 0.616788 0.290786 1.478184 0.854964 0.750706 1.853143 1.837616 0.068009 0.196260 1.496079 0.820255 1.744388 0.146057 0.230788 1.434358 -0.205448 1.616936 0.981163 0.921532 1.591565 1.188825 -0.476209 1.518808 0.443241 0.115647 0.334751 1.367563 0.160132 1.179927 1.012776 0.498582 1.276116 0.704338 1.396987 -0.001804 0.959954 1.167324 1.287070 1.914346 1.400505 1.413492 1.484414 -0.463663 0.122173 0.488918 -0.038072 1.041389 -0.101511 -0.067115 1.661217 1.643428)
     )

;;; 89 odd -------------------------------------------------------------------------------- ; 9.4340
(vector 89 12.362 #r(0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0)

     9.331615 #r(0.000000 0.049094 0.763150 0.136548 0.483778 0.759076 0.333224 1.220929 0.134557 0.764345 0.615745 -0.054859 0.470862 1.549452 1.042755 0.304443 0.281140 1.178803 1.496311 1.304814 1.254180 1.214938 -0.188361 1.642263 1.456263 1.200682 1.159330 0.518402 1.259168 1.450349 0.156876 1.423052 0.526144 0.557187 0.211944 1.876505 0.927439 -0.029530 0.421763 1.206664 0.690297 1.789526 1.067082 0.003086 0.897179 1.065326 1.434687 0.576391 -0.150316 1.287422 1.126966 1.259277 1.431443 0.305104 0.343134 0.824875 1.068860 1.722713 1.668311 0.909968 1.314221 0.346498 0.614998 0.306500 1.059400 1.495807 -0.733779 1.277563 0.627585 1.184462 -0.276841 0.360604 0.535684 -0.101891 0.124422 1.197248 0.778353 1.945787 1.307086 0.922575 0.921600 0.870062 1.105219 1.606237 0.868032 -0.120196 0.316193 -0.191814 0.432808)
     )

;;; 90 odd -------------------------------------------------------------------------------- ; 9.4868
(vector 90 12.309 #r(0 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 0 0 0 1)

     9.421684 #r(0.000000 0.773463 -0.034237 0.815187 0.818292 -0.048506 -0.025177 1.145716 1.124687 -0.087471 0.982715 1.911529 0.885016 -0.169554 0.478422 0.410159 1.012688 0.169228 0.764485 0.758910 1.289872 0.618276 -0.229660 1.549110 0.758331 0.279930 1.553579 0.672439 0.162166 0.690601 0.847281 1.562839 1.023152 1.146052 1.063766 0.943600 -0.316637 0.816595 1.430319 0.223152 0.862408 0.935019 0.764642 0.942440 1.888157 1.614273 1.641359 1.139335 1.700104 1.516977 1.001915 0.698936 0.890613 1.412580 1.482707 0.374132 0.486389 0.409585 0.664613 0.728056 0.135717 1.017586 1.427256 0.114262 0.459920 0.985474 0.828118 0.029864 1.115880 0.182529 0.074455 0.121011 1.384155 1.498024 1.812648 0.488592 0.254186 1.880026 1.059948 0.152702 0.760476 0.236696 1.396118 1.492214 0.743805 1.035917 1.060796 0.484826 0.509085 -0.305704)
     )

;;; 91 odd -------------------------------------------------------------------------------- ; 9.5394
(vector 91 12.351367950439 #r(0 1 0 1 1 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0)

     9.456608 #r(0.000000 0.103422 0.965610 0.946880 1.775735 -0.122619 1.034051 0.168472 0.730448 0.272671 0.778481 0.021689 0.033093 0.984786 1.059637 0.145824 1.327186 1.317989 0.064861 1.738590 0.743092 0.115729 -0.009073 0.235258 1.253963 0.597261 1.473274 1.451939 1.654969 1.556762 -0.031925 0.584248 1.188923 1.752060 0.699420 0.272619 1.021928 1.546707 1.001394 0.687724 1.015815 0.834084 -0.085438 1.600278 0.991105 1.336531 1.547902 0.640465 0.462581 1.062100 1.213310 0.321259 0.291622 0.063730 0.566090 0.852786 0.847201 -0.174185 1.395263 1.222072 0.870150 0.708746 0.513822 0.978903 0.739358 1.760219 0.991895 1.423353 0.493188 0.952658 -0.084183 1.857020 1.060335 -0.192588 0.702407 1.144217 1.162221 1.656319 1.357097 0.810997 -0.196628 1.185541 1.692605 1.048778 1.191279 0.597890 1.575870 0.403387 0.283378 0.378021 0.172627)
     )

;;; 92 odd -------------------------------------------------------------------------------- ; 9.5916630
(vector 92 12.280749613899 #r(0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 0 1)

     9.552661 #r(0.000000 1.217977 1.385618 0.939614 0.500483 1.851006 0.319542 1.708679 0.556310 0.891376 0.674923 0.365733 -0.175465 0.892985 1.540146 0.973262 0.317469 1.925159 0.685389 1.371188 0.200154 1.709968 0.177693 -0.300538 0.695154 0.829261 0.826887 0.518213 1.033752 1.220316 0.472703 1.153927 1.069740 0.054639 0.285291 1.692400 0.723359 -0.010143 1.422901 0.759732 0.421539 1.178988 0.292771 1.282542 0.969261 0.723210 1.587532 1.451565 0.985309 0.576854 0.032105 1.279589 0.637040 0.836814 1.053214 1.607968 0.083343 0.618958 1.664826 -0.072056 0.366474 1.110340 1.463534 0.789016 1.455017 1.061490 0.999534 0.659448 0.541265 1.191626 1.594463 0.899514 1.279707 0.844186 0.855539 -0.116804 0.909316 1.750334 1.598414 1.853269 0.368452 0.535158 0.818452 1.438032 0.503813 0.301666 0.154109 0.506999 0.079492 -0.057406 1.894913 0.600742)
     )

;;; 93 odd -------------------------------------------------------------------------------- ; 9.6437
(vector 93 12.403578299298 #r(0 1 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1)

     9.628761 #r(0.000000 1.192712 1.317592 0.793671 0.099933 -0.070495 0.916675 1.443504 0.876536 1.333886 0.502339 0.879490 0.963974 1.813405 1.616449 1.406560 0.249623 1.099165 1.684130 0.971324 1.504790 0.210004 -0.334645 1.442259 0.574758 1.021850 0.284510 0.399479 0.184247 1.487488 1.612401 -0.235561 -0.129797 0.178650 -0.371978 0.920412 -0.107159 0.561074 0.178586 0.184745 -0.019738 0.790773 0.250122 1.738768 1.375989 -0.216295 -0.331946 0.885688 1.988915 0.048056 0.095104 0.757409 -0.209034 0.574534 0.777126 1.337323 -0.015675 1.471677 1.723082 0.373584 0.844517 1.228790 1.358490 1.817661 1.097143 1.261125 0.949204 1.719884 0.720744 1.257519 0.078221 -0.091904 0.999562 0.486340 0.282135 0.639284 -0.163690 1.618168 0.349231 0.088441 0.985965 0.932832 1.613134 0.712978 1.300533 1.211114 1.605834 1.719815 0.768198 -0.076989 1.468170 1.231822 0.852206)
     )

;;; 94 odd -------------------------------------------------------------------------------- ; 9.6954
(vector 94 12.789479876738 #r(0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1)

     9.653914 #r(0.000000 1.588712 0.970594 0.765681 0.768893 0.708013 1.088997 0.348116 1.304828 0.302466 0.484457 0.598101 1.195823 1.750495 0.723696 -0.394564 1.399290 0.440079 0.957225 0.110914 1.178680 -1.746723 0.306178 1.424281 0.083938 -0.026412 0.531864 1.282735 0.186630 0.411663 1.537740 0.224065 -0.422374 0.338118 1.366092 0.348038 0.469097 0.358167 1.178154 1.072296 0.953715 0.778556 0.718707 0.831159 0.966980 0.639988 0.294231 -0.156503 1.325326 0.192979 0.424804 0.332961 0.198719 0.405180 1.172779 0.251315 0.565156 0.903572 0.754645 0.195819 1.584153 1.274227 0.370217 1.346701 0.041617 1.218979 0.515044 1.085194 0.964032 1.907141 0.492814 1.684100 -0.290159 1.467461 0.104316 0.280575 0.761449 1.432721 1.137691 0.132533 1.823280 1.230711 -0.052109 1.493267 1.265211 0.071008 1.206644 0.630379 0.639830 0.932228 -0.085525 1.738146 1.623323 0.751204)
     )

;;; 95 odd -------------------------------------------------------------------------------- ; 9.7468
(vector 95 12.575266058635 #r(0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 0 0)

     9.716924 #r(0.000000 1.295576 0.051583 -0.370221 1.659103 1.560139 0.883258 1.136184 1.446082 0.336165 0.984827 1.426922 1.840974 1.223315 0.635432 0.990680 0.332450 0.247993 0.361771 1.193162 0.200656 1.699397 1.071493 0.299430 0.743325 0.167398 0.140913 0.844624 1.382714 1.375685 0.647006 0.229451 0.386840 1.780080 0.889230 1.061105 0.116922 0.567648 1.435830 1.255231 0.833620 1.820993 1.158323 0.868650 0.833531 0.419654 1.734245 1.273400 1.062531 1.460253 0.175543 0.639252 0.712611 1.085237 0.872288 1.639660 -0.093743 0.087045 -0.323684 1.687923 1.002234 -0.168363 1.044853 -0.114093 1.195353 -0.026012 0.883764 1.512322 0.102179 0.114077 1.256119 1.084835 0.251990 0.992344 0.663746 0.903707 0.809231 1.141845 1.353235 1.559958 0.119755 1.444404 1.912417 1.220976 -0.164602 -0.295612 1.393445 0.425402 1.426929 1.201811 0.614353 -0.027563 1.025805 1.054465 0.134046)
     )

;;; 96 odd -------------------------------------------------------------------------------- ; 9.7980
(vector 96 12.803173065186 #r(0 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 1 0)

     9.759447 #r(0.000000 0.435576 1.538976 0.230825 0.102821 0.263319 0.997316 0.091618 0.472323 -0.103132 0.585027 1.906149 0.670612 1.002137 1.281685 0.083578 0.271396 0.433634 0.733402 0.099534 0.807149 -0.070119 0.575530 -0.103613 0.335070 1.262648 1.473382 0.330894 0.589593 0.216256 0.350636 1.350446 1.836442 1.560161 1.205882 0.649393 0.812682 0.141066 1.111869 -0.141497 1.693969 1.777393 0.080165 0.375196 0.449681 -0.067423 0.754077 0.868345 1.797143 0.793576 0.568117 0.646818 1.350309 1.187659 1.791215 0.862642 1.742949 1.213798 0.583814 0.650546 0.965237 1.015772 0.605956 0.144297 0.285298 -0.351085 1.282066 0.474001 0.642725 0.511289 1.457452 0.929763 1.241810 0.227521 0.228779 1.199150 1.811444 -0.006366 0.744946 0.179491 1.361847 -0.378016 1.423650 1.452225 1.393417 1.335482 0.037183 1.548694 0.890495 0.461455 1.744132 0.896894 0.307836 1.812808 0.221251 0.928513)
     )

;;; 97 odd -------------------------------------------------------------------------------- ; 9.8489
(vector 97 12.837450993031 #r(0 0 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 0 1 1 0 0 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1)

     9.832277 #r(0.000000 0.379259 1.470054 0.135241 -0.137798 1.476571 0.223942 1.269139 1.617761 0.578479 1.659896 0.192321 0.628723 1.030748 0.068332 0.935772 0.702035 -0.308246 0.093619 0.687832 0.312122 0.952725 0.646784 0.815901 0.600402 0.700649 0.257079 0.728929 1.512814 0.133748 -0.161439 1.667289 1.756964 0.419090 1.460039 1.221568 0.216587 0.357346 0.560096 0.621329 1.423958 -0.140419 -0.285305 1.752977 0.296245 1.796763 0.502171 1.837539 -0.068388 -0.176521 1.655407 0.652714 1.571976 1.231728 0.781936 1.899698 1.696905 1.070324 0.093931 0.071079 0.376824 0.772939 1.099059 0.004831 0.221806 1.727680 0.800189 0.011067 0.690398 0.512420 0.475317 0.941280 1.720146 1.587206 0.923080 0.792083 0.180477 -0.133205 1.214230 1.814657 0.679279 0.282075 1.334889 1.751170 1.536951 0.882536 0.418450 0.834681 -0.026902 0.654794 0.680161 1.077779 1.525535 0.824205 1.102618 0.673911 -0.106249)
     )

;;; 98 odd -------------------------------------------------------------------------------- ; 9.8995
(vector 98 12.972 #r(0 0 1 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 0)

     9.918320 #r(0.000000 1.126272 0.810135 -0.157043 -0.284411 1.014546 1.656515 0.886620 0.589412 -0.165849 0.041656 1.689870 -0.133502 1.386309 0.753684 1.607028 0.455527 0.729530 1.603812 -0.176801 0.980471 1.557823 1.120428 0.608500 -0.040856 1.654422 1.694414 1.546900 1.545046 0.721205 0.133219 1.189224 1.204719 1.195353 1.299299 -0.156627 0.826681 -0.088693 0.692437 1.036020 0.358333 1.488711 1.027717 0.069063 1.141577 0.328360 0.719016 0.851669 0.356065 0.712122 1.039551 1.236061 1.577925 0.317909 -0.158255 0.050224 -0.509790 1.519264 0.203085 -0.063235 0.037529 0.962155 1.059331 0.698574 0.810336 0.743673 1.683751 0.457113 0.419520 0.759860 1.462788 1.502247 0.636526 0.416346 0.963144 1.154048 0.694553 0.104918 -0.349860 1.108892 1.631062 0.589884 1.392769 1.258082 0.568391 0.753256 1.211016 0.009043 0.817095 0.265385 1.455548 1.585953 1.547698 1.855964 1.737942 0.229735 1.055700 1.696455)

     ;; pp:
     9.852643 #r(0.000000 0.515219 1.262972 1.697020 0.335436 0.889905 1.519089 0.044736 0.650497 1.270750 -0.178917 0.674989 1.450432 0.254900 1.097572 -0.107043 0.651195 1.335130 0.272796 1.297874 0.224159 0.962708 0.053062 1.193382 0.101327 0.836439 -0.105754 1.215012 0.128574 1.109391 0.442046 1.523411 0.553345 1.725474 0.541762 -0.127793 1.417975 0.631717 1.576620 0.767281 0.059112 1.609436 1.033347 0.556109 1.727081 1.010442 0.702568 -0.141336 1.349027 0.669399 0.583528 0.147350 1.497924 0.934945 0.610721 0.101044 -0.019997 1.772284 1.165297 0.883648 0.540756 0.695909 0.051843 0.036770 1.823953 1.940217 1.253231 1.381574 1.135330 0.962885 1.084109 1.188033 1.135270 0.827723 0.748628 1.126276 1.272339 0.770370 1.246808 1.223016 1.570254 1.399310 1.628085 1.829166 -0.154940 0.353005 0.721669 0.726808 0.892330 1.197955 1.533013 0.212675 0.669097 1.140181 1.156217 1.790457 0.422623 0.510791)
     )

;;; 99 odd -------------------------------------------------------------------------------- ; 9.9499
(vector 99 13.000000000002 #r(0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0)

     9.927757 #r(0.000000 0.612324 0.079141 1.434202 1.000660 0.891242 1.012263 -0.017562 0.996629 0.611063 1.321217 1.621637 1.504948 1.624898 0.001412 0.412734 0.326019 1.366721 1.072960 0.116515 0.715979 -0.740444 1.161301 1.297736 1.041757 0.027020 1.458453 1.107119 0.363908 1.415543 1.763457 0.255777 0.686434 -0.085735 0.651473 1.217063 -0.047283 1.151992 0.790695 -0.152103 1.647917 0.508714 0.628648 1.408143 1.292464 0.474000 1.003650 0.520847 0.629804 0.218082 0.785490 -0.232867 0.391411 1.172299 0.273141 1.313231 0.427739 0.013232 0.516032 0.610598 1.282766 1.029342 0.967918 1.073490 0.454858 0.915907 0.522595 0.274119 0.827376 0.861574 -0.158909 -0.432703 1.871750 1.122982 0.647824 -0.195710 0.262542 1.053968 0.565099 0.024117 0.401586 0.264805 1.587960 -0.370184 1.152346 1.774247 0.242656 0.316777 1.195086 1.067518 1.112347 0.688842 1.446613 0.608318 1.321142 -0.167020 0.907334 1.022140 1.062351)
     )

;;; 100 odd -------------------------------------------------------------------------------- ; 10
(vector 100 13.117680368039 #r(0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0)

      9.967820 #r(0.000000 1.016486 1.075466 0.675161 0.574401 1.527303 0.369311 1.093743 1.758162 0.649535 1.329616 0.683289 -0.464743 0.488528 0.846167 1.093202 0.188464 -0.009742 1.328398 -0.092736 0.866724 1.306141 0.236206 -0.048398 0.065984 1.250377 0.880265 0.529903 1.908284 0.909975 0.870318 1.170730 0.401807 0.051428 1.546047 -0.084383 1.553645 1.723234 -0.192262 -0.005451 0.846559 1.396413 0.793410 1.734419 0.268618 0.782362 0.300041 0.085963 0.406528 -0.058412 0.759019 0.311738 0.688186 1.163736 0.207596 0.957152 0.518038 -0.238894 1.966069 0.254028 0.497859 0.406362 0.948142 0.108565 0.809242 0.618274 0.008503 1.224166 0.619792 -0.063172 1.170177 1.631095 0.360399 0.496092 1.173684 1.571576 1.461266 0.250954 0.485376 0.293914 0.241987 0.266855 1.299097 1.747740 -0.157940 1.025403 0.055859 0.443647 -0.030039 1.366811 0.369467 1.523632 1.262832 1.148761 0.265795 -0.397124 0.678718 0.978216 1.111928 1.121642)
      )

;;; 101 odd -------------------------------------------------------------------------------- ; 10.0499
(vector 101 13.28250751675 #r(0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1)

      9.964634 #r(0.000000 -0.073111 1.535769 -0.102555 0.949824 0.661791 1.376397 0.389320 1.429271 1.382915 0.702074 0.190023 0.165010 0.880936 1.053717 0.381858 1.515003 1.204543 0.504035 0.920455 0.391206 0.949414 1.113429 0.554900 1.897469 1.768789 1.766679 1.550589 0.402518 0.254763 0.394916 1.625563 0.833640 0.744524 0.452145 -0.082936 0.892795 1.873582 1.781184 -0.418454 1.636196 -0.022737 0.903335 -0.412208 1.924024 0.194797 -0.087158 0.651748 1.188278 0.341571 0.583987 1.814760 1.207941 1.789448 0.551284 0.991618 0.259118 0.282624 1.011184 1.611901 1.372798 1.012968 0.839711 1.331909 1.264042 0.325794 0.343316 -0.075857 -0.460634 0.488689 1.512646 1.806638 1.012723 -0.303497 1.575625 0.027198 0.002241 1.290806 1.657896 1.438044 0.654010 1.150362 0.652919 1.476118 -0.053999 -0.024155 0.726437 0.454484 1.497660 0.765182 0.287065 1.425963 0.079052 0.750136 1.836142 1.337567 -0.185862 1.924720 -0.153672 0.400041 1.450120)
      )

;;; 102 odd -------------------------------------------------------------------------------- ; 10.0995
(vector 102 13.159336831147 #r(0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0)

      10.045766 #r(0.000000 -0.279070 0.173878 0.081403 1.768938 1.607495 0.603256 0.555897 0.375867 1.098499 0.557935 1.658062 0.679353 0.435605 1.704584 0.882188 0.675710 1.226519 -0.017413 0.221732 -0.211376 1.307302 0.689909 0.655783 0.993058 0.615004 1.764502 1.131327 0.119482 0.185094 1.035751 1.439320 1.373211 1.418236 0.503946 0.310742 0.195150 1.345393 1.645648 0.392993 0.050135 0.685592 0.243679 0.754096 0.965418 1.162001 1.767714 0.912263 1.540226 0.989163 0.153496 1.180193 0.495181 0.826820 -0.194339 1.268780 1.482827 -0.154668 1.003093 0.057371 1.563631 1.606126 0.908893 1.017810 0.439667 -0.174146 0.280275 0.399111 1.342959 -0.098826 1.087834 1.050762 0.557805 0.752893 -0.400427 0.095731 0.689016 0.552247 0.778927 0.058727 0.428406 0.269116 0.480708 0.192361 0.563638 0.686642 0.128600 1.864221 -0.045520 1.018032 1.780635 -0.005046 0.881801 1.021244 0.513775 1.482476 0.956890 0.518235 1.186738 -0.018819 1.609204 0.515712)
      )

;;; 103 odd -------------------------------------------------------------------------------- ; 10.1489
(vector 103 13.142812158651 #r(0 0 0 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1)

      10.102476 #r(0.000000 1.369258 0.406430 1.487363 1.300312 1.174178 0.725871 1.118946 0.567934 1.507074 1.421940 0.060397 1.553534 0.366960 0.264364 -0.027869 1.681923 0.350717 1.364154 0.204515 -0.180262 0.842363 0.287472 1.198426 1.756374 1.259211 0.898266 0.187309 0.401610 0.535873 0.048012 0.851696 1.323060 0.925186 0.678890 0.097118 1.570744 0.545725 0.858166 1.853728 0.291531 1.096726 1.166849 -0.045402 1.179837 -0.111020 0.643454 0.486562 1.084325 0.673411 1.808268 0.331853 0.761303 0.506929 0.948787 0.125433 1.093138 1.172704 1.300823 -0.087765 1.061422 -0.231489 1.345595 1.007175 0.463207 0.567128 0.417701 0.867458 1.827132 1.618306 -0.235698 1.268358 1.413906 0.291274 -0.510359 1.287040 0.555326 0.694591 1.555786 1.225983 1.844314 0.908000 0.867329 0.232081 1.454227 0.972019 1.069240 0.133107 0.915878 0.821231 0.471133 1.434428 0.215881 0.667043 0.772841 0.944850 1.153588 0.551253 0.882554 1.134378 0.032596 -0.042233 1.758816)
      )

;;; 104 odd -------------------------------------------------------------------------------- ; 10.1980
(vector 104 13.176067352295 #r(0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)

      10.168550 #r(0.000000 0.863337 -0.113966 0.952335 1.179324 1.344589 0.086001 1.784568 0.040939 -0.278342 0.492392 1.373041 1.589416 0.305140 1.040154 0.306852 0.639739 1.605433 -0.082316 1.171614 0.018705 0.877480 0.742834 1.013469 -0.394587 0.679538 1.685340 1.015860 0.451982 1.273683 0.656961 1.380347 0.930414 0.629931 0.875751 1.106458 0.854029 1.097615 0.942886 1.634232 -0.087153 1.214976 0.912099 1.026106 0.377766 0.938615 0.980356 0.179306 0.223817 1.145177 1.622990 0.100820 0.989970 1.826246 0.934306 0.310115 -0.012658 0.179983 -0.026220 0.755024 0.027968 0.662514 0.819461 1.633236 1.403644 1.156857 1.356308 1.542286 1.253871 1.012715 0.852908 0.924116 0.022097 0.368327 -0.090612 1.052696 -0.034185 0.655336 -0.097080 -0.157717 1.261805 0.337757 0.457703 1.158886 1.296591 0.128958 1.630443 0.809473 0.920747 1.393423 0.696288 0.328360 1.336354 1.510499 1.486152 1.947494 0.779240 0.349685 0.612445 1.433252 1.461547 0.826387 0.679858 -0.337976)
      )

;;; 105 odd -------------------------------------------------------------------------------- ; 10.2470
(vector 105 13.491228801467 #r(0 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0)

      10.115828 #r(0.000000 0.049019 1.344835 1.091641 0.665700 0.968893 0.648602 0.707898 1.514354 1.538919 0.526334 1.493761 1.624995 0.707437 0.593803 0.874212 1.543010 1.853745 0.426397 0.026573 1.615940 1.506593 0.465693 1.159200 -0.404908 1.664358 0.782410 1.352302 -0.234654 1.360029 1.390064 0.562127 0.900595 -0.305834 1.198378 1.369945 1.005775 0.397773 0.628843 1.626964 0.837449 1.061154 1.446306 1.380391 1.599960 0.270806 1.328543 -0.187842 -0.215850 0.275407 1.674813 1.481684 0.685411 -0.076514 1.172112 0.021028 -0.282040 0.805083 0.169438 0.519532 1.238467 0.912197 -0.108203 0.770912 1.223603 1.260598 0.243317 1.416653 -0.085803 1.793597 1.018898 0.209596 0.637018 0.680644 1.218601 -0.251927 1.342315 0.794662 0.530948 1.151958 0.965018 0.768542 0.003792 0.487969 1.528116 0.185132 1.582165 0.376426 0.269883 0.979543 1.678175 1.757906 1.492507 0.386900 1.219606 0.328787 1.292795 -0.100060 0.401454 0.164930 0.339091 0.226350 0.418706 -0.115549 1.296351)
      )

;;; 106 odd -------------------------------------------------------------------------------- ; 10.2956
(vector 106 13.091135978699 #r(0 0 0 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0)

      10.198335 #r(0.000000 0.831679 1.059524 0.595983 0.203261 1.202829 1.655547 1.163399 0.731912 1.050991 -0.085268 1.049064 0.669107 0.707558 1.587356 0.103456 0.095032 1.177165 1.677580 0.458849 0.488238 1.294418 -0.328225 1.742764 0.960376 0.232688 1.221102 1.139466 1.165521 0.274312 -0.217213 1.769983 -0.106435 0.980799 0.424668 1.120797 1.738923 1.408831 0.326124 1.349134 0.307375 0.275240 0.392410 1.221176 0.352509 0.866366 0.344959 0.656333 0.909394 0.940268 0.976614 0.141881 0.684412 0.786921 -0.062121 -0.010568 1.690036 -0.088688 1.427313 -0.052874 1.785355 0.109989 0.958795 1.179624 0.324837 1.229886 1.616903 1.768092 1.318950 1.675999 1.563712 0.225381 0.575251 0.774252 -0.022742 1.783220 1.405786 0.332796 1.613495 1.352845 1.308309 0.373980 1.918112 1.162561 0.910064 1.737277 1.152808 -0.033675 0.058425 1.406045 -0.253836 0.991335 1.479963 0.005130 1.832773 0.614974 0.073456 1.352269 1.161897 0.192184 0.857686 0.091488 0.263380 1.392944 0.202339 1.603064)
      )

;;; 107 odd -------------------------------------------------------------------------------- ; 10.3441
(vector 107 13.537808159641 #r(0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 1 0 1)

      10.295953 #r(0.000000 1.453513 1.655211 0.102988 0.785431 1.249929 -0.025066 1.750838 0.347673 1.604380 1.551092 0.115495 1.639861 1.667898 0.228709 1.701673 0.201321 1.045139 -0.312647 0.175688 0.855996 0.160415 1.472612 0.763114 0.800624 0.361142 1.295288 0.490786 -0.039842 -0.032740 0.339591 1.592008 0.669279 0.117545 -0.109117 1.018536 0.901071 0.716433 0.346971 1.020475 -0.173945 0.889314 0.077058 1.765220 1.318363 1.591641 1.626283 0.012132 1.508938 0.471426 0.670071 1.171727 0.339306 0.138717 0.336161 0.439088 1.260263 -0.187548 0.396198 0.258209 0.100455 1.039650 0.818140 1.958400 1.117502 0.697124 1.567939 -0.332396 0.783424 1.205431 0.709006 -0.344647 0.483889 0.499549 -0.063258 0.695169 0.972581 0.387305 1.779513 -0.022586 1.856190 0.369348 0.297097 0.538965 0.115827 0.894957 1.816307 1.006210 1.611567 -0.212466 -0.136556 0.733243 0.881259 0.131239 1.843996 -0.064517 1.632049 0.217595 1.203085 0.867259 0.064249 0.691138 1.782204 1.811114 1.580857 1.070340 1.558270)
      )

;;; 108 odd -------------------------------------------------------------------------------- ; 10.3923
(vector 108 13.472808406168 #r(0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0)

      10.325467 #r(0.000000 1.823999 0.121670 1.358801 0.589768 1.029967 -0.433790 1.041582 -1.274122 0.780646 -0.169734 1.604597 1.010159 1.810789 0.632723 -0.206688 0.463178 1.073646 1.521165 -0.178712 1.523791 0.423100 0.144424 0.899019 -0.452142 0.547962 0.895764 1.662227 0.346193 1.471302 -0.164671 -1.901696 0.406602 0.262326 0.474119 -0.030228 1.801622 1.325384 1.588387 0.343116 0.445611 0.273212 0.831258 1.871029 -0.312461 1.896993 1.025139 0.721577 0.726171 0.338346 0.861017 1.378901 0.847116 0.469202 -0.383235 0.452023 -0.496006 1.102062 1.102044 1.646809 0.311243 -0.456688 0.949926 0.520943 0.921326 0.643117 0.781598 1.182150 0.966506 0.456713 0.498859 1.075971 1.927079 0.160322 0.159648 0.419881 0.925743 0.446322 0.326978 1.459788 0.903977 -0.021458 1.063237 1.175806 1.223175 0.258595 0.623246 1.572004 0.621332 1.978290 1.546402 1.672410 0.423727 1.205710 1.436589 0.182917 0.251425 0.718333 -1.375705 0.497395 0.186440 0.550196 0.272118 1.380692 1.012574 0.305814 1.433937 0.098087)
      )

;;; 109 odd -------------------------------------------------------------------------------- ; 10.4403
(vector 109 13.798 #r(0 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 1 0 0 1 1 0 0)

      10.413972 #r(0.000000 -0.329332 1.852441 0.301192 0.479205 1.938689 1.086891 1.271023 0.729396 1.367900 1.483662 1.203078 1.940935 0.158023 0.999249 1.513297 0.973974 0.871966 0.600005 0.917499 0.064963 1.625056 1.204390 0.450307 0.459827 1.379619 0.277893 0.390957 1.292297 1.095127 0.941246 0.509853 0.476400 1.479425 1.214972 0.999425 1.144172 0.402758 1.277806 -1.541834 1.224224 0.408937 -0.140267 1.012505 1.167342 0.593542 1.500901 0.801861 0.428256 0.363108 1.278773 0.897271 1.754344 0.238279 0.787476 1.405582 1.439989 1.293816 1.237720 0.491493 1.514000 1.092355 0.055457 1.477338 0.699004 0.040279 0.957508 1.786210 0.481649 0.726028 0.215740 0.216870 1.343437 -0.395385 1.669265 -0.047054 1.724398 0.984510 0.441756 -0.012720 0.257871 1.485641 -0.121426 0.687863 0.835502 1.004805 1.663485 0.780698 1.042433 1.097029 1.089236 1.689246 1.096756 0.293532 0.899560 -0.005695 0.471699 1.241990 1.396400 -0.542444 0.294633 1.091314 0.356171 0.908370 0.648337 1.936350 -0.128643 0.053871 0.188853)
      )

;;; 110 odd -------------------------------------------------------------------------------- ; 10.4881
(vector 110 13.576010454591 #r(0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0)

      10.408073 #r(0.000000 1.583299 1.129147 0.924363 0.405386 0.106463 0.654471 1.235816 1.676675 1.424024 -0.320821 -0.106137 1.651584 1.223458 1.376470 0.070578 0.035561 0.618393 1.591071 1.247092 1.420738 1.407145 1.068993 1.180774 1.368120 -0.309458 -0.227815 -0.257077 0.341569 0.189699 1.898096 1.209271 -0.362341 0.480813 1.176223 1.497789 1.567432 0.970389 -0.047452 0.764481 1.364232 1.546603 0.838685 0.519999 0.785088 1.840526 0.201375 0.694162 0.995107 0.138310 0.417265 -0.004223 1.430441 0.548174 0.456155 0.879102 0.021026 0.612402 1.448544 1.143273 1.475463 0.804075 0.821149 0.175404 1.164546 0.079156 1.149637 1.448505 1.656091 1.757415 0.521205 0.257194 1.707629 0.482292 1.377093 0.507438 0.991226 -0.612661 0.868064 0.306724 0.414844 0.138628 0.061298 1.129023 1.487975 0.706799 -0.099480 1.383589 0.290834 1.123787 -0.072238 0.982011 0.038233 1.760058 0.405531 0.016972 -0.604791 1.005236 1.670267 -0.215358 1.779967 0.879139 0.413047 1.290874 0.860692 0.804540 1.190191 0.135277 0.110128 0.732322)
      )

;;; 111 odd -------------------------------------------------------------------------------- ; 10.5357
(vector 111 13.709900383304 #r(0 0 0 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0)

      10.588903 #r(0.000000 0.083293 0.444830 -0.213766 0.524915 -0.005956 1.175907 0.783294 -0.343790 -0.015069 1.676924 0.021997 -0.012805 1.023472 0.864450 1.922773 1.431731 1.374839 1.561767 1.633583 0.198147 0.245727 1.910466 0.995751 0.091514 1.666123 0.750477 1.953152 1.512135 0.025831 0.969938 0.804619 0.507564 0.688555 -0.027332 1.433090 0.812479 0.893934 1.245019 0.835304 0.404414 0.839838 0.338429 -0.112731 0.636982 0.099621 1.080987 1.292673 0.177317 1.292327 1.284755 0.253860 0.748555 1.591323 1.605479 0.445460 1.332537 -0.181589 1.668331 0.627699 0.074537 0.208177 0.135644 0.846946 0.614940 0.479986 0.443281 0.299879 1.767930 1.411021 -0.391645 0.057816 1.376551 1.471560 -0.203049 0.453124 0.061036 0.704839 1.379390 1.848624 0.771131 -0.036797 0.007834 1.611881 1.733830 0.412751 1.415257 0.544650 1.539165 0.414455 1.242586 0.195280 0.522916 0.859907 1.238816 -0.090313 -0.027707 -0.025034 0.375248 1.748950 1.440534 1.222909 0.018270 -0.118073 0.275708 1.112569 0.089742 1.167857 1.617530 0.755934 0.450427)

      ;; pp:
      10.417134 #r(0.000000 0.334233 1.073081 1.649039 0.219597 0.888802 1.379829 0.088335 0.555458 1.328032 1.801862 0.615319 1.429043 0.326004 0.993452 1.804613 0.545160 1.317910 1.885616 0.678140 1.509274 0.323491 1.236504 0.282786 1.199970 0.195704 1.232493 0.160017 0.897560 -0.082586 1.086392 0.182366 1.277299 0.339072 1.485948 0.630905 1.802953 0.832621 -0.132126 1.110982 0.486291 1.681037 0.774846 -0.032051 1.638442 0.870514 -0.093334 1.333411 0.747525 0.167590 1.347374 0.845491 0.233833 1.720211 1.112373 0.655737 0.273424 1.815808 1.225426 0.609827 0.164644 -0.241753 1.556306 1.087036 0.843899 0.560878 -0.058558 1.838311 1.465620 1.239758 1.091378 0.528065 0.791149 0.332440 0.584210 0.055836 0.449981 1.753070 0.093654 1.657239 1.503059 1.399887 1.433488 1.544146 1.513188 1.637379 1.822882 1.796041 1.687813 1.720729 1.754274 -0.098151 -0.072877 0.197474 0.504171 0.827563 1.033490 1.323144 1.356797 1.748728 -0.150347 0.352269 0.632744 0.932570 1.684081 0.187586 0.495859 1.035344 1.327590 1.648341 0.358056)
      )

;;; 112 odd -------------------------------------------------------------------------------- ; 10.5830
(vector 112 13.92684841156 #r(0 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 0 0 1)

      ;; 10.58293147
	10.582025 #r(0.000000 0.311823 0.137469 0.765085 0.247252 0.880370 1.452735 0.240993 1.506478 0.780197 1.183194 1.086565 0.032933 1.780577 0.281098 0.764676 0.712557 1.579682 1.277796 1.238223 1.014207 -0.140323 1.716730 1.644672 1.253593 0.578221 0.527661 0.367318 1.131386 1.012757 0.285059 0.010509 0.097401 1.699590 0.802620 1.600737 0.550167 1.026747 0.562219 0.378187 0.150437 0.522055 0.022316 1.717789 0.186746 1.186644 0.914782 0.563095 1.653911 0.869696 0.117700 1.053735 0.935756 -0.055221 0.653101 1.059195 -0.397205 1.469022 0.238158 0.393902 0.410251 0.955768 1.001018 1.337003 0.602349 0.798689 0.307413 -0.479763 0.463243 1.296128 0.608105 0.417995 0.073111 0.291455 0.483686 0.231728 0.630836 1.131231 -0.228753 0.669521 1.185569 -0.089761 1.130815 0.778132 1.502582 1.555252 1.149912 0.577946 0.284522 1.467470 0.172271 0.275044 1.633737 1.228854 0.152388 0.342365 1.574177 0.099351 0.042391 1.025180 1.146998 1.437785 0.647927 1.566576 1.091754 1.532311 1.602420 0.887895 1.387294 0.660060 1.356768 -0.056782)
      )

;;; 113 odd -------------------------------------------------------------------------------- ; 10.6301
(vector 113 13.825498858186 #r(0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0)

      10.586426 #r(0.000000 0.880973 0.176609 1.175777 0.325354 1.332354 0.320489 -0.071032 0.810398 1.764286 1.047524 1.891121 1.274870 -0.462450 -0.016593 1.802245 -0.046896 0.623724 0.697636 1.104725 0.928560 1.531658 1.767776 1.410783 1.560300 0.841358 1.754992 0.695860 1.109332 0.811865 0.787805 0.897767 0.126996 1.290009 1.439543 1.231735 0.428818 0.217484 1.274411 0.676699 0.491905 0.907831 0.251383 0.502017 0.436195 1.271188 0.390987 0.252204 1.423164 1.333446 1.284283 0.685749 0.387192 1.752967 0.379905 1.873082 0.147356 1.600693 0.620101 0.533661 0.873916 1.687058 0.856213 0.905702 0.279125 1.651302 0.425155 1.158445 0.384556 1.685623 1.738609 0.620191 0.166765 0.760816 0.887704 1.876641 1.612703 0.207434 0.310898 1.383166 0.834523 0.489910 -0.069256 0.030910 0.047326 1.374933 1.678060 0.495762 1.058376 0.337747 0.859288 0.994496 0.384200 0.735993 0.843904 0.381801 0.488130 0.839325 0.731059 1.159772 1.973051 0.569688 1.423018 1.561321 1.485614 0.834971 1.215611 1.015531 -0.080496 -0.203441 0.704520 0.652007 1.385821)
      )

;;; 114 odd -------------------------------------------------------------------------------- ; 10.6771
(vector 114 13.920305720092 #r(0 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 0 0)

      10.620769 #r(0.000000 -0.265733 0.572658 0.316585 0.923883 1.614948 0.728669 0.692865 0.985653 1.596503 0.291068 0.153708 1.761462 0.140269 1.183433 -0.379854 1.503387 1.143776 0.747711 1.619251 0.404594 1.157009 0.378840 0.537946 0.751007 0.739900 0.914353 1.624008 0.450778 0.962869 0.588872 1.869278 0.721483 1.557011 0.902276 0.776013 1.285044 0.345048 1.685952 1.091106 0.263288 1.107778 -0.009439 0.420734 1.806464 1.410193 1.769595 1.251788 0.691963 1.604897 1.666646 1.531003 0.963757 -0.680527 1.705352 1.126307 -0.203837 0.277321 0.178995 1.809866 0.763029 0.031476 0.539819 0.755127 0.685061 1.837935 0.717076 1.848829 1.364997 0.950055 -0.061791 1.853324 0.123916 -0.136693 1.146568 0.362176 0.781284 1.598429 1.120688 1.139170 0.560329 -0.015310 0.331374 1.472918 0.199430 0.303861 1.321918 1.569172 1.548780 -0.090459 1.912266 0.810039 -0.152547 1.372081 1.425080 0.264711 1.614349 0.175290 0.789472 1.260114 1.370945 1.918464 1.489942 1.397616 0.963993 0.516634 0.516943 1.244942 0.283787 1.709141 1.616073 0.810759 1.316742 1.696489)
      )

;;; 115 odd -------------------------------------------------------------------------------- ; 10.7238
(vector 115 14.20306968689 #r(0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1)

      10.674304 #r(0.000000 0.789887 -0.303859 -0.033056 0.759195 0.636525 0.248364 0.847489 1.259597 0.571635 0.950311 0.503307 0.311625 1.283873 0.845368 0.051963 1.567172 1.288876 0.243542 0.283164 1.566596 0.754789 1.490536 0.039434 0.168217 0.197813 0.961175 1.000724 0.173724 1.453836 -0.299975 0.087165 1.672267 1.098120 1.146505 0.379755 1.328375 0.651767 1.173825 0.650295 0.441141 0.865349 1.257754 -0.111945 0.068441 1.538745 0.068967 1.734610 1.208209 0.079563 -0.236732 0.216584 0.140036 0.340430 0.008574 0.036605 0.315028 0.890542 0.307266 0.065201 -0.267238 -0.016662 1.283003 0.528002 -0.402562 1.186323 0.829551 0.025932 0.882753 0.264357 1.091661 1.076730 -0.001406 0.040934 0.042083 1.567774 0.906679 0.687134 0.720339 0.063372 0.406664 1.457338 1.400253 1.359707 1.217492 0.090043 -0.918052 0.816288 1.443080 -0.046946 0.555663 0.622694 1.800570 0.513267 0.655836 0.746318 1.849833 1.129389 1.637640 0.403829 -0.005965 0.883415 0.100025 0.540813 0.541888 0.996530 1.501665 1.855318 1.257420 0.578586 0.925447 0.264080 0.596871 0.828008 0.353618)
      )

;;; 116 odd -------------------------------------------------------------------------------- ; 10.7703
(vector 116 13.887789451571 #r(0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0)

      10.733274 #r(0.000000 0.476000 1.878001 1.180059 0.831300 1.453614 0.786219 1.052031 1.218138 0.179523 0.743868 1.265853 0.031570 1.636184 -0.152324 0.778296 0.271634 1.469546 0.565495 1.807809 0.217280 0.159382 1.049221 0.170285 0.221763 0.774648 0.398259 0.637279 -0.107284 0.312805 1.776901 0.160502 1.717634 1.119938 1.391025 0.105351 1.023277 1.530674 1.548380 -0.251006 0.488559 1.544222 0.177807 0.661206 0.257716 1.053732 0.893027 1.445098 1.722088 0.002770 1.151812 1.061439 0.110999 0.865286 0.781438 1.277991 0.502793 0.943734 0.798521 1.333645 1.654972 1.679619 0.259243 0.886975 0.069664 1.517348 1.237826 1.551946 0.514540 1.258563 1.258071 1.027685 1.355844 1.909459 1.281504 1.171068 0.250655 1.622642 0.211675 1.522349 -0.092396 0.705855 1.861520 0.183629 0.746566 0.759808 0.250024 -0.159043 1.664858 0.237853 -0.217693 1.217376 1.459590 1.517349 1.206266 0.478670 -0.380779 0.210779 0.338305 1.433407 1.043804 0.854323 0.392836 1.702198 1.439694 -0.141576 1.283279 0.715495 0.734335 1.585749 1.775978 1.654290 -0.315773 0.174327 1.442380 0.993240)
      )

;;; 117 odd -------------------------------------------------------------------------------- ; 10.8167
(vector 117 14.427604264985 #r(0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1)

      10.783290 #r(0.000000 0.108967 0.680440 -0.039849 1.073915 0.982905 0.909467 1.470260 1.730853 0.840580 1.309090 0.612716 1.548112 -0.231227 1.489945 0.841297 1.245447 0.244987 0.849971 -0.022279 0.452974 0.810744 1.489407 1.567278 1.188237 0.772892 0.113419 0.906478 1.169175 -0.156676 0.507744 1.684543 1.686412 1.219650 1.843836 0.541605 0.346082 0.043904 -0.079283 1.469849 1.567795 0.179241 -0.068928 0.912255 0.602511 1.574715 0.695060 1.133392 -0.425958 0.610886 1.496396 0.865636 0.895412 1.362633 1.653811 1.404165 0.041681 1.692317 1.094403 0.739550 1.239428 0.479228 1.439160 0.986149 0.801910 1.514113 0.963332 0.281851 0.106127 1.599308 -0.004925 1.893302 1.411671 1.244923 0.383170 0.517813 0.421067 1.058052 0.153400 0.778671 0.754438 1.880309 0.023746 1.476647 0.081600 1.798573 0.432245 0.735923 0.440628 -0.064421 1.249491 0.136405 1.735439 1.868665 1.565831 0.435031 0.537457 0.904590 1.634892 1.124196 0.408216 0.769901 0.281419 1.398400 0.260352 0.021213 0.275268 0.681889 -0.074136 0.502025 0.237163 1.241676 1.638668 0.242962 0.026823 1.133262 1.452416)
      )

;;; 118 odd -------------------------------------------------------------------------------- ; 10.8628
(vector 118 14.399567650824 #r(0 1 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1)

      10.812235 #r(0.000000 1.507972 1.809575 1.323971 0.671235 0.977919 0.397118 0.294709 0.400614 1.800046 0.492728 1.565979 -0.363038 1.100463 1.075231 0.502016 0.457037 0.406728 0.228418 0.756367 1.513939 0.347068 1.450936 0.868009 1.501709 0.352220 -0.413052 -0.148923 0.240400 1.115439 0.653043 -0.505473 -0.021974 1.853042 0.586305 0.428092 0.050201 0.752546 1.451411 1.228490 1.754283 1.881544 0.485306 1.754300 0.007006 0.163634 0.582385 0.998129 -0.090614 0.952205 1.425714 1.513296 1.570494 -0.259048 0.529336 1.498547 1.326491 -0.594238 1.538496 0.728657 0.444244 1.055319 1.385207 0.874327 0.074427 1.100816 1.734905 0.605814 1.533043 1.017063 0.482871 0.438583 1.108829 1.808956 0.029357 0.297016 -0.063569 0.780909 1.283400 0.359665 -0.032425 1.363808 0.687851 1.190450 1.438414 1.141910 1.126025 1.239471 0.136191 1.489911 1.026641 0.526687 0.890040 -0.022700 0.140687 -0.353757 1.164330 1.005641 0.099661 1.220163 1.081145 1.773078 1.376716 1.458019 0.703593 0.987305 1.493840 1.628605 0.957392 -0.054994 1.652856 0.431213 1.736293 -0.162073 0.279632 -0.110283 1.166212 1.877544)
      )

;;; 119 odd -------------------------------------------------------------------------------- ; 10.9087
(vector 119 14.464 #r(0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1)

	10.915923 #r(0.000000 1.468971 -0.070109 0.743471 0.865207 0.740713 1.375563 1.856253 1.493876 0.001446 1.555119 1.873527 0.486379 1.616655 0.160602 1.367247 0.912321 0.764636 0.328487 -0.313335 0.385982 0.645370 0.408989 -0.210208 1.638205 0.329206 1.585495 1.658528 -0.015737 0.563000 0.062305 -0.007952 1.615694 0.120849 0.556636 1.351804 1.028805 0.044823 -0.249641 0.450875 -0.188130 1.054822 1.658005 0.732611 1.051144 0.181032 -0.061461 0.014104 0.174656 1.497989 1.287601 1.362445 0.209461 0.902894 1.389971 0.577406 1.285084 1.677882 0.836076 1.093131 -0.061912 0.754157 0.925122 0.984483 0.745399 1.783690 0.907228 0.093044 0.001514 0.775385 1.257954 1.480444 1.312457 1.195686 1.427916 1.726017 1.291212 1.845006 1.072451 0.380596 -0.077482 -0.030557 0.660125 1.346002 0.823989 0.235481 1.377946 1.450150 0.552324 0.398627 1.336527 0.073526 0.466630 0.590308 0.928946 0.828743 -0.154986 1.149963 0.492935 1.772069 0.204388 1.490853 -0.315475 0.097407 1.157089 0.698006 1.513716 1.488764 0.923673 0.108745 1.168110 0.729608 1.392132 1.740139 1.454066 0.757828 1.227068 0.584339 1.581610)

      ;; pp:
	11.037707 #r(0.000000 0.330663 0.977506 1.486310 0.146671 0.619852 1.212563 1.835260 0.429131 1.137767 1.722966 0.554725 1.336956 0.080712 0.852554 1.473118 0.165981 0.811544 1.502696 0.343077 1.371306 0.205531 0.905257 1.934366 1.020467 1.933150 0.730878 1.550089 0.565733 1.543669 0.452622 1.507940 0.734165 1.641237 0.799367 0.020448 1.044223 0.039537 1.305538 0.570880 1.458969 0.622353 1.797356 0.986890 0.251789 1.442933 0.753665 0.270337 1.533653 0.647011 -0.011278 1.435253 0.493723 -0.176024 1.395851 0.880365 0.222324 1.709439 1.376910 0.824516 0.330942 1.733291 1.350769 0.852276 0.247847 -0.101792 1.361637 1.450559 0.694333 0.792939 0.273393 1.916534 1.612649 1.136729 1.027650 0.745376 0.479123 0.468161 -0.088607 0.141257 1.721063 1.745485 1.474071 1.547129 1.195469 1.231545 0.976850 0.989136 1.181833 0.899203 1.200899 1.168317 1.143250 1.360858 1.307442 1.171633 1.402153 1.656644 1.531180 1.874515 0.028657 0.416186 0.465448 0.590264 1.056005 1.152867 1.387578 1.553815 0.076236 0.350372 0.561320 1.007917 1.385094 1.972832 0.449173 0.459147 1.193699 1.594244 0.056947)

	;; 118+1
	10.815476 #r(0.000000 1.511627 1.860509 1.251771 0.680390 0.954029 0.497464 0.422082 0.549359 1.789096 0.627036 1.559684 -0.285316 1.102920 1.110972 0.497639 0.358913 0.339963 0.170351 0.820368 1.613321 0.311453 1.667587 0.845824 1.477518 0.323382 -0.462336 -0.121701 0.278431 1.251253 0.730313 -0.512813 0.050332 1.905719 0.581701 0.491221 0.037053 0.850077 1.454447 1.218666 1.827857 1.931466 0.444700 1.716033 0.031317 0.208955 0.719947 1.025308 -0.162952 0.941579 1.416409 1.490055 1.661028 -0.177347 0.601149 1.427738 1.318738 -0.598055 1.513344 0.818145 0.331744 0.938565 1.416971 0.755203 0.134509 1.154206 1.729909 0.622158 1.596632 1.050190 0.348364 0.402844 1.083937 1.814009 0.098380 0.333506 -0.078532 0.814360 1.186888 0.456002 0.118529 1.475204 0.706833 1.153688 1.398936 1.202344 1.140027 1.452557 0.124581 1.538313 1.096684 0.449897 0.816791 -0.073645 0.157032 -0.377184 1.176926 0.948380 0.061745 1.231800 0.991632 1.829471 1.268286 1.394920 0.669763 0.966107 1.360959 1.524586 1.033990 0.094975 1.707832 0.468762 1.695289 -0.249729 0.213611 -0.109788 1.260368 1.791243 -0.325923)
      )

;;; 120 odd -------------------------------------------------------------------------------- ; 10.9545
(vector 120 14.530112637252 #r(0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0)

      10.908578 #r(0.000000 1.631022 1.381443 1.212465 0.280876 1.393291 0.111686 0.270527 0.978937 1.227425 0.890939 1.651369 1.764648 0.695615 1.236913 0.727116 0.698874 1.130809 0.997193 1.306023 0.313921 0.604505 1.499034 1.434773 -0.031959 0.721966 0.805711 1.401787 1.847562 -0.006201 0.484669 -0.092885 0.221199 -0.183123 0.140129 0.993753 0.357992 0.281932 0.966898 0.230227 1.509169 0.180321 0.405315 1.445457 0.491155 0.993111 -0.061813 1.514617 0.638001 0.451798 1.136956 1.109239 0.762301 -0.132886 1.231861 1.405253 0.200172 0.005626 1.367415 0.727395 0.860721 1.277905 0.564602 1.311600 0.590071 0.237783 1.173320 1.731939 0.366179 -0.147635 0.520386 1.741652 0.218116 1.635795 0.602629 0.928717 0.628620 0.437182 1.782199 0.939080 1.479011 0.992710 1.705346 0.225711 0.000961 0.770434 1.683323 1.555459 0.976408 0.318440 0.438208 0.262452 1.689840 0.975712 0.209291 0.727490 0.382719 1.065032 0.672130 0.702874 0.107185 1.755713 1.841965 0.283698 0.562788 -0.058140 0.525625 0.471391 -0.086606 1.741760 0.455380 1.248256 1.359448 0.404279 1.132787 1.054875 0.443335 0.808907 0.713857 0.102341)
      )

;;; 121 odd -------------------------------------------------------------------------------- ; 11
(vector 121 14.355115628334 #r(0 0 1 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0)

	10.999150 #r(0.000000 0.719860 0.938641 0.400955 1.830792 0.217487 1.930089 0.909842 0.382707 1.104036 1.362552 1.609877 0.538869 1.202159 1.228082 0.918074 0.761902 0.900279 1.079854 0.387994 0.099489 0.100875 1.443224 0.976872 1.189188 0.334621 0.186401 1.007773 1.759908 1.802561 0.304789 0.800487 0.421388 1.531470 0.342409 1.763739 0.609609 0.238091 0.387711 0.077698 1.394770 1.550045 1.073770 -0.012632 0.461456 0.365441 0.558370 -0.144510 0.377065 -0.136065 0.495723 0.024372 0.599268 0.707454 1.784582 0.849322 0.801737 -0.000698 0.370684 -0.319990 0.047344 1.411089 -0.180064 1.795978 1.184028 0.211991 0.750419 1.558447 0.936061 0.770891 0.210380 0.477885 0.773230 1.314821 1.776398 0.360518 0.353595 1.763194 0.626584 0.453820 1.817369 0.757593 0.448588 0.747723 1.349523 0.084314 0.839331 0.432101 1.175829 -0.480593 1.521898 1.472118 0.461937 -0.352155 0.231781 1.128258 1.179502 -0.264358 1.594681 1.130852 1.819287 1.407276 0.357399 0.261689 0.296975 1.241018 0.528908 0.936623 1.018062 1.507272 1.409703 0.904346 -0.089508 0.657699 0.797276 1.771059 0.906319 0.794023 0.195827 -0.015182 1.382236)

      ;; pp:
	10.964853 #r(0.000000 0.398403 0.789366 1.639224 0.095384 0.603386 1.413253 -0.024715 0.418890 1.292082 1.611148 0.340631 1.108765 1.695063 0.580930 1.343797 0.280670 0.901558 1.616611 0.471137 1.087682 0.133909 0.906863 1.859279 0.568482 1.631317 0.654611 1.507476 0.361682 1.510922 0.499281 1.470975 0.300411 1.347262 0.617157 1.704177 0.828780 1.880799 1.043180 0.289911 1.416774 0.542005 1.546439 0.900363 0.167177 1.249035 0.407571 1.759267 1.085148 0.584948 1.716513 0.882082 0.508912 1.827501 0.986992 0.387974 1.888925 1.337010 0.836823 0.307293 1.641585 1.441301 0.767423 0.352201 1.694822 1.489433 0.858014 0.699679 0.213088 1.881335 1.746103 0.996170 1.013175 0.481879 0.378821 0.145113 1.583267 1.647206 1.099338 0.993610 1.018212 0.718965 0.851336 0.334482 0.624100 0.047757 0.264635 -0.323610 -0.302771 0.007865 1.748671 1.715799 0.102814 0.097582 0.089500 0.089824 -0.047495 0.097783 0.230671 0.371131 0.395035 0.485871 1.031900 1.248794 1.442726 1.594017 1.850116 0.167236 0.339312 0.429488 0.766566 1.120859 1.686086 0.133797 0.674257 1.033037 1.205258 1.718874 0.166520 0.534447 1.081831)
      )

;;; 122 odd -------------------------------------------------------------------------------- ; 11.0454
(vector 122 14.266534958875 #r(0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 0 1)

	11.010771 #r(0.000000 1.285362 1.109765 1.769522 1.118511 0.025809 1.380894 -0.023810 -0.040154 0.477589 1.538986 0.261754 1.175104 0.132069 1.284014 1.937597 1.377797 1.405930 1.758393 1.282889 1.486625 -0.056321 1.528467 0.214498 1.235960 0.342086 0.501436 1.266150 1.154766 0.072612 1.295064 1.657622 1.389498 0.272462 0.259989 -0.421623 0.539671 -0.109400 1.457518 0.782406 0.238503 1.568707 0.742855 0.582523 1.544996 0.568221 1.469856 -0.013151 1.702120 1.738232 0.495569 1.623452 0.280213 1.398587 0.655444 -0.357815 -0.175614 -0.641353 0.853648 0.913786 0.039735 0.805399 0.987536 1.353101 0.200447 1.531233 0.925738 1.853509 -0.339223 0.575217 0.991404 0.868567 0.980697 0.661437 0.825668 0.642114 1.923343 0.222086 1.058889 0.329972 0.424129 1.343097 -0.325621 0.616372 0.777895 1.290746 0.563995 1.114886 -0.032692 0.303925 0.022515 1.568213 1.005956 0.993523 0.945016 1.316628 1.600265 0.004312 0.404044 0.508968 1.509703 1.266589 -0.292614 0.449335 0.327309 -0.027947 0.095691 -0.305771 -0.038174 1.851423 0.567671 0.373102 0.032065 1.664572 1.263320 0.558380 0.899406 0.824927 1.437277 1.639347 0.806318 0.739271)
      )

;;; 123 odd -------------------------------------------------------------------------------- ; 11.0905
(vector 123 14.795100232697 #r(0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0)

	11.117974 #r(0.000000 1.262698 1.743243 1.074484 0.862475 0.785191 0.510312 0.582728 0.572628 -0.088059 1.664778 1.092330 -0.084164 1.734977 0.143912 0.402913 0.514775 1.115307 1.630947 0.922571 1.361065 0.426472 0.818315 0.052105 0.105138 1.201879 0.422607 1.251988 1.202423 -0.257950 0.069201 -0.064548 0.721964 0.891435 1.163338 0.489652 0.800922 1.113478 0.729679 1.592733 0.127179 0.300890 1.709393 0.172666 1.452078 -0.215073 0.642218 0.228379 0.403691 1.149702 0.347815 1.145024 0.203450 1.473310 1.349864 0.832166 1.109084 1.584188 0.087952 0.610084 0.356770 0.605944 1.021694 0.463739 1.799512 1.527466 0.330450 0.923701 1.275830 1.440075 0.070553 0.931440 1.867718 1.401219 0.527205 0.524478 1.943022 1.358574 1.765573 0.269987 0.599212 0.397347 0.099304 -0.004043 0.750837 0.311340 0.977644 0.259270 0.829971 0.677623 1.491913 0.411691 1.356052 1.394632 0.542733 1.451416 1.005068 0.285973 0.960285 1.132877 -0.136129 0.201370 1.788028 -0.448022 -0.229434 1.007668 -0.665334 0.552776 -0.103552 1.183857 -0.521659 1.255730 0.912247 1.532970 1.479294 1.441480 1.200164 0.598200 1.369457 1.661067 0.851812 0.484837 1.318223)

      ;; pp:
	11.220425 #r(0.000000 0.365848 1.054393 1.548722 0.083290 0.846622 1.243796 1.975082 0.530118 1.107798 1.698368 0.394906 1.261238 1.932773 0.709817 1.516065 0.289612 0.915816 1.713378 0.516514 1.369027 0.084750 0.935528 1.825369 0.700695 1.570817 0.581567 1.522187 0.450938 1.444224 0.424228 1.427039 0.366241 1.246498 0.294330 1.489859 0.444710 1.600045 0.769131 1.818819 0.882796 0.180405 1.318163 0.438713 1.518577 0.911091 0.311354 1.423178 0.560415 -0.093959 1.444287 0.598087 1.777270 1.408474 0.711081 0.112383 1.490437 0.904666 0.286560 1.771712 1.145544 0.724678 0.267468 1.796311 1.311228 0.841811 0.365537 1.880834 1.503328 1.287234 0.819314 0.526370 -0.077772 1.787440 1.491417 1.044589 1.141961 0.479419 0.379101 0.330996 -0.143470 1.807816 1.736856 1.461325 1.278241 1.506158 1.106149 1.221780 0.919096 1.122923 0.682195 0.948573 0.684101 0.822257 0.900682 0.969747 0.998896 1.031330 0.981000 1.116626 1.207464 1.514496 1.484110 1.685927 -0.131788 0.102608 0.256377 0.543811 0.846258 1.358549 1.270751 1.590115 -0.239901 0.243476 0.677754 0.899634 1.476294 1.901976 0.254194 0.661350 1.294177 1.496684 0.048409)

	;; 122 + 1
	11.250448 #r(0.000000 1.302757 1.104016 1.882979 1.077650 0.053765 1.380440 0.003809 -0.046007 0.495357 1.519889 0.149797 1.197260 0.142817 1.219075 1.962202 1.461975 1.397810 1.755477 1.312034 1.459888 0.010987 1.489492 0.259453 1.259472 0.317472 0.521518 1.299213 1.226523 0.026938 1.296841 1.668722 1.337105 0.314301 0.330300 -0.438601 0.526089 -0.123698 1.469579 0.756219 0.172470 1.621261 0.778923 0.588722 1.542018 0.631414 1.527628 -0.038678 1.791364 1.687889 0.422304 1.584058 0.300597 1.413330 0.639674 -0.328087 -0.133739 -0.644241 0.881718 0.903075 -0.003259 0.764074 1.053115 1.364090 0.158374 1.544589 0.996921 1.813142 -0.279028 0.566236 1.039397 0.862143 0.979166 0.609771 0.860576 0.627137 1.959235 0.243884 1.018838 0.390319 0.475059 1.332423 -0.275526 0.611933 0.766476 1.331409 0.615945 1.094395 -0.004564 0.363420 -0.045135 1.527572 1.077299 0.997558 1.035936 1.286389 1.540261 0.059435 0.352601 0.552519 1.479640 1.199179 -0.317815 0.440438 0.336153 -0.013127 0.157566 -0.304297 -0.069647 1.901289 0.528335 0.359084 -0.007292 1.702466 1.215578 0.562997 0.913601 0.801948 1.409876 1.632172 0.750795 0.670695 -0.003034)

	;; 124 - 1
	11.087851 #r(0.000000 0.624121 0.261315 1.181018 0.329816 0.723473 -0.058557 1.121126 0.418750 -0.560184 0.201221 -0.009188 0.964547 0.675383 0.540517 1.692402 0.238659 0.271713 0.649234 1.358679 -0.523949 0.096515 1.070752 0.415974 1.194076 0.398537 0.119705 1.390687 1.865110 0.657711 0.628353 0.094042 -0.039698 0.818092 0.264925 1.627819 0.564214 1.707948 1.323380 0.532853 1.528599 0.040464 0.169356 1.020624 1.633435 0.566927 0.135046 0.139973 1.154314 0.011466 -0.490861 0.640253 0.477507 1.036610 0.601286 0.864853 1.673244 0.103614 0.490773 0.239735 1.004984 0.751604 0.598287 0.049449 -0.383209 0.952738 0.587827 1.358167 1.134886 0.996730 1.062079 1.715631 0.870675 -0.669782 1.719322 1.286177 0.181430 1.375280 1.727572 0.723568 0.180864 0.793875 1.229108 1.479462 0.352987 0.476172 0.647844 0.506675 0.826807 0.037970 0.147029 -0.376170 -0.079080 -0.448861 -0.361893 0.784673 0.253239 1.081508 0.018537 1.194702 1.598635 -0.278698 1.403864 0.071060 0.431595 1.221066 1.608714 0.689332 0.715718 0.497216 1.832187 1.548074 1.325487 -0.697479 1.412701 -0.064789 1.545460 1.865863 0.574246 1.018052 0.826593 0.850894 0.538141)
      )

;;; 124 odd -------------------------------------------------------------------------------- ; 11.1355
(vector 124 14.82254124518 #r(0 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0)

	11.133385 #r(0.000000 0.737767 0.242894 1.222279 0.471270 0.719745 -0.111581 1.125372 0.519029 -0.602995 0.207831 -0.019375 0.977253 0.730038 0.549277 1.736357 0.178856 0.378067 0.703036 1.285405 -0.440424 0.022976 1.081105 0.394590 1.176445 0.423028 0.024758 1.348044 1.875622 0.693243 0.631295 0.154785 -0.072026 0.840426 0.310333 1.680668 0.596016 1.796624 1.329261 0.552169 1.550621 -0.029191 0.120286 1.042346 1.643782 0.557105 0.100245 0.192082 1.115887 -0.044021 -0.568040 0.660295 0.446779 0.996296 0.543383 0.887166 1.696504 0.164237 0.565638 0.240616 0.980219 0.676086 0.528834 0.128308 -0.348116 0.973101 0.673237 1.259063 1.135685 0.928208 1.088345 1.731248 0.837036 -0.669991 1.701824 1.338691 0.198045 1.382482 1.748178 0.598583 0.174133 0.840707 1.239171 1.490991 0.324491 0.560298 0.680939 0.488255 0.866976 0.067351 0.114746 -0.374109 -0.011129 -0.482864 -0.335823 0.770685 0.238886 1.104919 -0.086380 1.175827 1.697828 -0.309033 1.420456 0.050528 0.410791 1.224188 1.576124 0.696620 0.749167 0.492507 1.752832 1.565235 1.317346 -0.708509 1.533585 -0.144615 1.567818 1.921771 0.617703 1.048643 0.900156 0.810098 0.470909 -0.287077)

      ;; pp:
      11.348159 #r(0.000000 0.420291 0.994113 1.605062 0.142556 0.741991 1.232518 1.818784 0.570117 1.112532 1.715041 0.498288 1.242193 1.903819 0.738569 1.440312 0.052035 0.859274 1.700608 0.416370 1.222707 0.007385 0.792200 1.771446 0.548685 1.661284 0.559436 1.442669 0.358986 1.258045 0.260744 1.254293 0.320180 1.305252 0.361287 1.403913 0.572629 1.603076 0.693636 1.846854 1.012682 0.188863 1.352443 0.397048 1.645973 0.881785 0.066704 1.295103 0.504646 1.870898 1.303297 0.570018 1.829957 1.080888 0.545590 1.923840 1.269013 0.679145 0.161303 1.594647 0.985227 0.464326 0.012233 1.568478 1.180634 0.730528 0.110665 1.618518 1.175834 0.879996 0.432189 0.136812 1.777876 1.490107 1.188949 0.907621 0.550479 0.242984 -0.059790 1.929821 1.371631 1.423168 1.146477 0.972409 0.858534 0.924887 0.595740 0.679411 0.488048 0.636418 0.072322 0.281040 0.204879 0.089915 0.287853 0.416670 0.453983 0.352329 0.503511 0.432486 0.571020 0.790600 0.687796 1.008010 1.155356 1.385540 1.648000 1.747132 0.045146 0.425981 0.717415 0.741128 1.002981 1.282324 1.660931 0.156386 0.411627 0.950904 1.417985 1.747974 0.260323 0.677519 1.016797 1.669557)

      ;; 125-1
      11.120334 #r(0.000000 0.836933 0.196277 0.584882 0.301240 1.853484 1.324094 0.689541 0.969365 0.207127 0.815576 1.493174 1.646002 1.091372 1.338767 0.007260 0.223249 1.375996 0.396818 0.809290 0.595471 0.291935 0.828280 1.079040 -0.045835 0.055676 0.687157 1.387372 0.387604 1.113048 0.635795 -0.184152 0.086995 0.683755 -0.523880 0.957683 0.004250 0.887892 -0.247566 0.473338 0.863028 1.537875 1.279363 1.883742 -0.079415 1.606587 1.410357 1.815201 1.258365 -0.140836 0.062288 -0.117723 0.136197 0.025366 0.240444 0.337975 0.245314 1.565210 1.190385 0.061707 1.059358 1.066927 -0.243845 -0.140470 0.080704 -0.220916 0.436644 1.755266 1.123977 1.300903 1.292668 0.127266 0.478120 0.197515 0.674823 1.740766 0.286316 1.346417 -0.000673 0.759878 1.360448 0.328373 -0.116210 1.391350 1.022226 1.179474 0.838754 0.041237 0.614743 0.475843 0.203018 1.724933 1.421322 0.133569 1.485945 -0.070709 -0.071535 1.023240 0.511154 0.013014 1.379753 0.972914 1.226974 1.882336 0.135006 1.035934 -0.225880 1.034246 0.410768 0.390305 1.143196 1.223233 0.144114 1.611032 0.509896 1.218446 0.494123 -0.071045 0.511805 0.489583 0.116710 1.542243 0.745207 0.200411)
      )

;;; 125 odd -------------------------------------------------------------------------------- ; 11.1803
(vector 125 14.82163143158 #r(0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 1 0 0 1 1 1 0 0)

      11.122080 #r(0.000000 0.847003 0.165605 0.564848 0.227076 1.866949 1.345525 0.694388 0.959809 0.220564 0.772501 1.602410 1.604719 1.034958 1.311625 0.093909 0.283228 1.337145 0.377730 0.845137 0.466461 0.350583 0.723543 1.140286 -0.106738 0.112805 0.654453 1.405583 0.488341 1.115481 0.791692 -0.180702 0.024701 0.675117 -0.401907 0.966930 1.823188 0.970009 -0.163692 0.487827 0.774136 1.664048 1.147399 1.934923 -0.055579 1.590906 1.404741 1.937024 1.297324 -0.074406 0.012276 -0.101828 0.157087 0.049344 0.227099 0.402796 0.390545 1.452083 1.063131 0.134397 1.038993 1.058234 -0.172834 -0.157850 -0.051398 -0.166122 0.368524 1.765197 1.164117 1.233067 1.255917 0.100656 0.389203 0.162934 0.701475 1.871318 0.234658 1.379710 -0.022077 0.663615 1.352469 0.392445 -0.083922 1.307168 0.973714 1.219169 0.823481 0.152576 0.585169 0.393119 0.296805 1.754607 1.427512 0.110549 1.353534 -0.062637 0.005406 0.988733 0.551978 -0.032302 1.396422 1.051496 1.232496 1.873765 0.104448 1.090614 -0.186610 1.107217 0.405013 0.371843 1.166939 1.223105 0.199359 1.547104 0.541567 1.118832 0.462118 -0.111041 0.497800 0.551619 0.175381 1.513543 0.771791 0.282381 0.491699)
      )

;;; 126 odd -------------------------------------------------------------------------------- ; 11.2250
(vector 126 14.961482935205 #r(0 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1)

	11.217157 #r(0.000000 1.333463 1.865492 -0.356718 0.933752 -0.563391 0.868454 1.227379 1.262853 1.734302 0.789925 0.887286 1.032388 0.794621 1.230657 -0.133505 -0.396357 0.347068 1.645124 0.776662 -0.030992 0.148253 0.191160 1.597265 0.105283 0.900423 1.230893 1.571345 0.370052 -0.251197 0.174670 0.404122 -0.082381 0.889967 -0.215160 -0.008260 -0.099660 1.159763 0.889422 1.423884 0.871705 1.850409 0.087109 1.706676 0.622672 0.936165 1.688780 1.528677 0.346829 0.012071 -0.088550 -0.030577 -0.043782 -0.058951 0.933603 1.070465 1.475594 1.531127 0.991234 0.010808 0.356054 0.157103 0.451907 -0.030459 -0.024818 0.523063 -0.129422 0.815521 1.075724 0.055269 0.750932 1.244054 1.306512 0.899391 -0.257291 1.664054 0.588171 1.065503 1.219153 1.371075 1.522174 0.737588 1.228742 1.773501 0.629941 0.387629 0.029457 1.398967 0.393091 1.680074 1.275817 0.905734 0.977246 -0.221887 1.339886 1.268897 1.260526 0.645165 1.510347 1.465708 0.394415 0.283387 1.630537 1.623821 0.888008 0.433073 0.790823 0.410278 1.398034 -0.237262 0.505122 -0.149516 0.721213 -0.202493 0.454561 1.014466 0.552452 1.112325 -1.848818 1.758603 1.154778 1.507049 0.724439 0.691362 -0.014103 1.227764)
      )

;;; 127 odd -------------------------------------------------------------------------------- ; 11.2694
(vector 127 14.695912364919 #r(0 0 1 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0)

	11.267676 #r(0.000000 0.469645 0.796786 0.361018 -0.201613 1.310280 0.989111 0.525386 1.353693 0.378912 -0.241786 1.383164 1.533963 0.433890 0.325960 -0.352400 0.296358 0.481541 1.224829 0.787501 0.393768 1.211089 1.363561 0.247670 0.870376 1.154368 0.308126 1.041640 0.835212 1.804302 0.606799 0.022246 1.619342 1.154695 0.087857 0.758989 -0.028398 1.810844 1.763099 -0.171773 1.163226 0.592499 1.004685 0.695738 1.351120 0.977805 1.234286 1.609466 1.168845 1.598062 -0.321012 0.375057 0.817093 1.176853 0.878725 0.404937 0.672879 0.953648 1.504900 1.779440 0.534644 1.065489 -0.364994 1.703967 1.257601 -0.285618 0.908588 1.590737 1.087624 0.949190 1.204116 1.100315 0.879186 1.728483 1.796612 1.248626 1.298091 0.553842 1.379947 1.414383 0.591234 -0.228889 0.158060 -0.027394 0.157851 1.486700 0.372769 1.034786 0.707926 1.165159 0.328389 0.640197 0.421469 0.024384 1.129354 0.412245 0.531741 0.551732 0.008170 1.397227 1.653335 0.820170 0.216962 1.538735 0.975199 1.704359 0.157705 -0.426269 0.813101 0.999429 0.880927 1.743457 1.627725 0.094175 0.211869 0.002839 0.900464 1.204980 1.320644 1.281147 0.386967 0.783858 1.096686 0.213553 1.120859 -0.145308 0.996884)
      )

;;; 128 odd -------------------------------------------------------------------------------- ; 11.3137
(vector 128 14.876242756695 #r(0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1)

      11.261196 #r(0.000000 0.166552 0.658187 0.892812 0.275075 0.681304 0.935134 0.976324 1.751013 1.223679 0.531374 0.670158 0.738172 0.131342 0.784571 -0.001918 0.261947 -0.271711 1.074675 0.180917 0.495904 1.378525 0.720362 0.537440 1.116473 -0.311806 0.462073 0.021129 0.764859 1.361657 1.645691 -0.164691 0.135735 1.576068 0.824450 0.335134 1.099359 0.719625 0.791638 0.999013 0.348593 0.103014 1.062792 0.739933 1.675943 0.488371 0.860700 0.759566 1.276788 -0.135237 0.780818 -0.165115 1.024663 -0.327864 0.608127 1.454969 0.958609 0.555060 1.331156 0.762777 0.625297 1.411237 1.470303 1.190821 0.207444 0.108639 1.023133 1.165243 1.464221 1.564262 0.616076 0.019451 0.729986 0.402652 0.078552 0.454134 0.152695 0.263463 0.361958 1.475980 0.276689 1.365673 0.254488 -0.143709 1.946127 0.309551 1.760348 1.294342 0.981564 0.863637 1.477654 -0.019128 0.751338 0.878849 0.050601 0.063334 1.353561 1.669390 1.451518 0.535767 0.012898 0.428045 -0.011136 0.975409 -0.201088 0.677802 0.866124 0.188482 0.625213 1.342113 1.315837 0.879874 0.445664 1.081775 0.978490 1.662778 0.529736 1.946523 1.542905 0.571344 1.054205 0.430980 0.402697 -0.095096 1.487261 1.198691 1.754313 1.700742)
      )

;;; 256 odd --------------------------------------------------------------------------------
(vector 256 22.546259712247 #r(0 1 1 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 1)
      
	16.242714 #r(0.000000 0.456765 1.687442 -0.133608 1.552599 -0.613047 1.706678 -0.197704 1.654787 0.529802 0.170660 0.135433 1.658670 1.698648 0.767088 1.301406 0.072253 0.476358 0.596769 -0.161294 0.942271 0.141352 1.436652 1.643811 0.711837 1.661608 0.292891 0.496011 0.570892 -0.057105 0.008577 0.821922 1.955586 1.410339 1.633963 1.332570 1.268156 1.838835 -0.014565 0.036112 1.408847 1.075934 0.772389 0.927611 0.964694 0.879860 1.198268 -0.017267 1.071348 0.983689 0.081986 1.232821 1.836590 0.078982 0.150405 0.057144 -0.028459 1.640374 0.117296 0.509253 0.034274 1.251076 1.666299 0.636454 0.070866 0.250422 0.251555 1.243143 1.717552 0.229561 1.056311 0.626892 0.597129 -0.064840 0.471253 0.539823 0.749620 -0.039923 -0.017559 0.905904 1.781183 -0.268850 0.444667 1.472167 -0.120773 1.508667 0.576704 0.190821 0.031775 0.977332 0.331054 0.133008 1.714274 0.283852 1.733589 0.115558 0.190647 0.489017 1.626356 -0.022764 1.166070 1.294472 1.460567 1.611249 0.195899 0.253585 1.347105 -0.078993 0.130173 0.912817 0.964692 0.885152 1.258931 1.388653 1.650194 0.235883 1.663345 1.842430 1.319909 1.713528 0.620667 1.392726 1.013169 1.477128 0.621189 1.077956 0.543032 0.888456 0.042982 1.359273 1.559111 1.621257 0.591536 0.749566 0.237130 0.812394 1.915485 1.675409 0.729778 1.807112 0.444639 0.263269 0.234148 1.382586 1.333218 1.787206 1.277283 1.183815 0.149095 0.419090 1.473544 1.406915 1.202522 1.868149 1.020969 -0.045252 1.105307 1.674286 0.206629 0.156758 1.600082 0.575703 1.357007 1.083986 0.555958 1.714543 1.238085 0.073643 0.928632 0.308256 1.159789 0.654285 0.303936 0.270252 1.370202 0.573369 1.870207 -0.136125 -0.422795 1.529175 0.874024 0.635637 0.622640 1.897396 0.953754 -0.038905 -0.106898 0.731592 0.357232 -0.379996 0.759113 -0.047250 1.159218 0.023363 0.669566 0.142465 0.537408 0.716957 1.180514 -0.500928 0.201921 0.443439 1.263347 1.460836 1.185016 0.463869 0.066634 0.429278 1.842397 1.200918 1.176436 1.836250 0.343392 1.007719 0.145775 0.944929 1.470897 0.823433 1.575221 1.393215 0.741031 0.954913 0.749002 -0.503842 0.746699 1.594650 0.624635 0.030293 -0.141514 -0.043721 1.501023 0.452048 0.783944 1.767362 1.023058 1.013821 0.069368 0.704589 1.140414 1.200862 0.439104 1.571509 1.588482 -0.148788 0.464366 1.259220 1.171049 1.708986 1.838157 1.901193 1.603280 0.692670 0.209609 -0.174803 0.734982 0.637445)
      )

;;; 512 odd --------------------------------------------------------------------------------
(vector 512 35.541 #r(0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0)

      ;; from (try-all :odd 512 513 0.0057812032540294  1.0142361702487) = 28.7291 start for next
	23.517222 #r(0.000000 1.402699 0.710345 -0.021085 1.303265 0.609795 -0.055093 1.273980 0.672866 0.041691 1.435237 0.833333 0.177771 1.557793 0.888029 0.266694 1.601636 0.994383 0.362007 1.768513 1.197208 0.583281 0.011702 1.381174 0.763027 0.183382 1.606551 1.040600 0.477119 1.923178 1.369819 0.792169 0.178553 1.629573 1.034315 0.478164 -0.081089 1.418536 0.887290 0.381127 1.895987 1.355960 0.854141 0.315774 1.806788 1.269839 0.710345 0.227969 1.714895 1.219933 0.726588 0.231920 1.744568 1.236271 0.737525 0.277218 1.814731 1.361079 0.932165 0.497427 0.034546 1.602648 1.145984 0.711934 0.241767 1.746697 1.282443 0.813937 0.405377 -0.003145 1.638937 1.232256 0.776859 0.375329 1.954103 1.570681 1.177312 0.771946 0.323958 1.915835 1.547043 1.221818 0.852761 0.480068 0.080191 1.705724 1.374295 1.022717 0.641880 0.266807 -0.019746 1.657995 1.299812 0.936909 0.560316 0.229354 1.913978 1.628717 1.360548 1.043780 0.694284 0.371393 0.091836 1.781024 1.475139 1.143091 0.887315 0.654255 0.413241 0.096729 1.827160 1.546134 1.259736 0.984485 0.720505 0.479935 0.222855 1.957332 1.713443 1.465983 1.221933 0.974101 0.749838 0.570861 0.355512 0.110081 1.879010 1.698138 1.524456 1.303746 1.053758 0.872614 0.718600 0.489729 0.294072 0.169464 -0.008641 1.716597 1.555215 1.482842 1.313357 1.111118 0.984889 0.843561 0.630709 0.517262 0.429517 0.280257 0.116909 -0.064022 1.760658 1.627087 1.529461 1.467770 1.396158 1.304189 1.117557 1.012430 0.976655 0.904092 0.752674 0.668762 0.594300 0.513063 0.429396 0.350144 0.313792 0.237384 0.161762 0.078927 0.030013 -0.028713 1.908143 1.946999 1.965070 1.850959 1.822037 1.819046 1.768467 1.744088 1.747536 1.739553 1.690772 1.677619 1.699147 1.681872 1.696594 1.708371 1.713610 1.700981 1.734874 1.774538 1.788305 1.870747 1.913146 1.910801 -0.053276 0.030275 0.095182 0.114923 0.179027 0.206687 0.261459 0.359354 0.439539 0.512740 0.597853 0.719374 0.776363 0.812727 0.905050 1.042484 1.186129 1.269711 1.333701 1.424911 1.553872 1.687013 1.801276 1.950940 0.086688 0.232883 0.419857 0.514985 0.609768 0.813745 0.975824 1.151646 1.269800 1.410488 1.593948 1.788204 1.941630 0.108898 0.263435 0.475794 0.665644 0.867939 1.051137 1.262422 1.451178 1.717053 1.916711 0.139994 0.314093 0.578658 0.772182 1.044568 1.198730 1.543408 1.714573 0.013984 0.198055 0.520182 0.671418 0.986593 1.194118 1.506815 1.764656 0.095617 0.341591 0.625517 0.946734 1.201184 1.474512 1.720383 0.073895 0.317397 0.725186 0.992559 1.377583 1.626110 0.003566 0.250956 0.632946 0.949417 1.301286 1.632717 1.932081 0.363954 0.637141 1.073768 1.334285 1.711744 0.080174 0.434897 0.848893 1.206593 1.600075 0.085497 0.381469 0.875100 1.088754 1.613253 1.960304 0.421052 0.808109 1.175350 1.622670 -0.036371 0.508443 0.863928 1.390892 1.718539 0.229695 0.617597 1.093996 1.518104 0.013362 0.447575 0.956936 1.392740 1.810661 0.309626 0.728227 1.352118 1.754330 0.317267 0.680872 1.238974 1.718025 0.277956 0.771535 1.318514 1.714467 0.282761 0.804627 1.302132 1.938769 0.395052 0.940173 1.468943 -0.014609 0.541180 1.164931 1.594420 0.340967 0.702104 1.381646 1.956724 0.497344 1.081234 1.763306 0.169300 0.815546 1.474038 -0.014390 0.585876 1.248625 1.762636 0.350603 1.010949 1.661136 0.230843 0.942664 1.597953 0.139804 0.831684 1.415720 0.088760 0.710682 1.379888 0.021593 0.668775 1.335611 -0.046174 0.663997 1.412792 -0.004588 0.665452 1.416035 -0.001854 0.771289 1.446169 0.148939 0.918062 1.589163 0.225892 0.991443 1.642378 0.370987 1.113986 1.831948 0.675919 1.327289 0.125468 0.818337 1.616012 0.320288 1.044035 1.790147 0.553501 1.421273 0.048576 0.901459 1.688401 0.374639 1.235535 1.953418 0.752982 1.585223 0.371192 1.194520 0.000910 0.866066 1.545698 0.475364 1.238947 0.121924 0.812102 1.781933 0.540653 1.437672 0.190971 1.127229 1.876709 0.785495 1.565095 0.460687 1.346422 0.194134 1.044974 -0.000786 0.851783 1.729420 0.621621 1.519370 0.444818 1.235551 0.155576 1.068174 0.047946 0.843245 1.776499 0.729201 1.725183 0.565033 1.539334 0.468775 1.422298 0.275576 1.294730 0.256389 1.096067 0.100795 1.052508 0.044185 0.982109 1.901358 0.979933 1.947925 0.997989 1.873802 0.865698 1.886318 0.917516 1.900182 0.947143 1.869354 0.923820 1.868569 0.889420 1.915703 0.927504 -0.032180 1.004125 0.038894 1.035409 0.138211 1.212806 0.268373 1.315550 0.416377 1.412739 0.443529 1.530553 0.592477 1.711606 0.789422 1.898523 0.946240 0.008297 1.128249 0.246651 1.322741 0.381772 1.520393 0.587169 1.757969 0.892136 0.040723 1.141435 0.279184 1.405474 0.518808 1.665159 0.803241 0.008814 1.138954 0.331217 1.446175 0.661772 1.770763 1.037963 0.209348 1.326639 0.543787 1.778195 0.997105 0.276219 1.473564 0.746719)
      )

;;; 1024 odd --------------------------------------------------------------------------------
(vector 1024 52.508 #r(0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0)

       ;; pp:
	33.731805 #r(0.000000 1.370212 0.671835 1.979533 1.256307 0.547000 1.839039 1.186176 0.487605 1.797303 1.173776 0.466642 1.823481 1.128837 0.467938 1.760924 1.093317 0.461225 1.782715 1.093212 0.429043 1.789339 1.140073 0.476633 1.850678 1.178025 0.576571 1.897685 1.262302 0.625005 1.943855 1.337977 0.719244 0.082649 1.459935 0.790343 0.156330 1.505943 0.909984 0.272880 1.675146 1.075839 0.411793 1.833500 1.232403 0.563963 1.931807 1.343030 0.758667 0.159837 1.564815 0.992052 0.388242 1.760196 1.192189 0.592719 1.970338 1.410368 0.801251 0.210784 1.646824 1.022558 0.448607 1.875654 1.292715 0.712237 0.125676 1.608135 1.045171 0.436715 1.873163 1.278482 0.709385 0.177064 1.602491 1.062826 0.517757 1.947217 1.354102 0.847659 0.276664 1.752364 1.204548 0.650689 0.109608 1.587706 1.083437 0.539598 1.984967 1.477957 0.899166 0.370963 1.803043 1.284948 0.786778 0.260596 1.768847 1.215028 0.740736 0.252436 1.715104 1.238493 0.718229 0.183768 1.681958 1.143815 0.651634 0.165892 1.711201 1.197307 0.677887 0.184368 1.673895 1.198937 0.721693 0.265417 1.794629 1.316621 0.811679 0.286054 1.826832 1.390193 0.900472 0.435323 1.956798 1.483989 1.029112 0.591138 0.146425 1.707034 1.235604 0.730109 0.306495 1.850428 1.422165 0.988767 0.510166 0.070134 1.633988 1.186344 0.780035 0.346594 1.896631 1.475819 1.041466 0.576051 0.149590 1.722081 1.302959 0.879668 0.464676 0.039872 1.638050 1.198697 0.790190 0.379077 1.987011 1.559936 1.162219 0.781504 0.407663 1.969448 1.556813 1.169132 0.770928 0.374829 0.020110 1.596576 1.238937 0.854939 0.460431 0.085099 1.706281 1.300222 0.927732 0.559179 0.239629 1.872610 1.465453 1.045780 0.703338 0.377682 0.030250 1.664065 1.252535 0.884999 0.563545 0.227737 1.853518 1.451585 1.133147 0.877731 0.527835 0.180220 1.835477 1.456268 1.119599 0.805772 0.492621 0.162291 1.827507 1.464925 1.158435 0.824690 0.523040 0.230107 1.887871 1.568157 1.258794 0.968526 0.644419 0.338262 0.026159 1.711491 1.432175 1.129821 0.831738 0.548799 0.261200 1.963754 1.649906 1.335794 1.068648 0.810198 0.493904 0.208190 1.907327 1.632120 1.352046 1.106569 0.826180 0.578875 0.298689 0.028548 1.770807 1.510490 1.247708 0.964511 0.715862 0.452803 0.215707 1.945943 1.681274 1.455190 1.246153 0.967229 0.700318 0.465676 0.218910 1.944795 1.737675 1.544070 1.308648 1.026908 0.797908 0.609050 0.390121 0.167834 1.934224 1.698339 1.494702 1.291379 1.066622 0.839493 0.633883 0.428272 0.228852 0.031894 1.798114 1.604041 1.437540 1.244577 1.021504 0.870122 0.648353 0.448666 0.295448 0.129748 1.921344 1.714794 1.552357 1.361095 1.173297 1.009050 0.832750 0.655483 0.467656 0.327053 0.146586 1.971854 1.809466 1.667185 1.540763 1.343406 1.204878 1.065193 0.899514 0.720551 0.584039 0.445402 0.291893 0.130186 0.021889 1.908994 1.756876 1.591085 1.510675 1.332569 1.178168 1.082919 0.958025 0.844567 0.705136 0.581567 0.485790 0.369647 0.203987 0.117600 0.017249 1.891189 1.798975 1.711581 1.590570 1.512659 1.409341 1.272146 1.224326 1.103452 1.018558 0.923687 0.793930 0.747761 0.677442 0.580557 0.516523 0.423706 0.348812 0.274140 0.153166 0.086689 0.040523 1.951538 1.926899 1.867660 1.803382 1.711484 1.633477 1.611507 1.560118 1.488679 1.447546 1.398911 1.345678 1.306790 1.262823 1.189476 1.143672 1.122951 1.084936 1.023355 1.030247 1.005872 0.938826 0.903646 0.897067 0.862358 0.855742 0.832854 0.806028 0.788929 0.761767 0.796682 0.801524 0.742663 0.712320 0.780134 0.772607 0.717159 0.733945 0.746604 0.724065 0.752883 0.739661 0.698321 0.739401 0.795184 0.799374 0.776791 0.810519 0.818835 0.843051 0.861052 0.895346 0.982765 0.963587 0.961483 1.011942 1.084979 1.112948 1.106604 1.186418 1.247283 1.261730 1.274300 1.355070 1.433013 1.465995 1.480352 1.543098 1.642385 1.698334 1.687267 1.769680 1.864022 1.943324 0.002948 0.077547 0.149328 0.178650 0.221277 0.365760 0.480443 0.514088 0.549956 0.673135 0.789121 0.835699 0.902665 1.031035 1.161159 1.208491 1.299584 1.408202 1.513543 1.592772 1.685849 1.835442 1.930203 0.054832 0.198507 0.267540 0.398561 0.487225 0.613373 0.757486 0.862206 1.028826 1.099444 1.187898 1.396998 1.517782 1.628808 1.760722 1.908698 0.083610 0.204032 0.324060 0.467042 0.621252 0.759970 0.892160 1.083999 1.201283 1.366279 1.524154 1.721450 1.896541 0.034282 0.170329 0.351660 0.531271 0.710363 0.862515 1.047442 1.227829 1.411733 1.573706 1.771862 1.946461 0.101906 0.296593 0.466130 0.676527 0.890226 1.106401 1.298094 1.455085 1.675622 1.851465 0.073179 0.294749 0.484690 0.682578 0.954411 1.126179 1.330232 1.551633 1.757809 -0.003821 0.192239 0.401554 0.668984 0.901732 1.116669 1.350355 1.598428 1.836454 0.077980 0.301297 0.530379 0.764782 1.062998 1.306431 1.501633 1.747376 -0.005734 0.288823 0.514016 0.791568 1.024571 1.267580 1.543158 1.843292 0.108801 0.339134 0.622261 0.875948 1.163174 1.433876 1.712790 0.012941 0.282224 0.558159 0.847047 1.124186 1.398180 1.733616 0.014885 0.340282 0.568342 0.878867 1.201846 1.496936 1.808357 0.081364 0.435994 0.702633 1.022885 1.288095 1.648645 1.962947 0.298323 0.609916 0.930860 1.266904 1.579015 1.906669 0.219249 0.579089 0.854735 1.221076 1.542849 1.944684 0.200142 0.564464 0.873457 1.239949 1.574656 1.954506 0.288618 0.647758 1.040022 1.373181 1.754081 0.115543 0.428745 0.770303 1.204300 1.561665 1.930000 0.274290 0.657101 1.013957 1.442640 1.804521 0.161574 0.521123 0.906394 1.302720 1.714218 0.094487 0.484306 0.855625 1.295713 1.679060 0.064559 0.423297 0.873261 1.233438 1.700407 0.095070 0.499247 0.902178 1.315862 1.781088 0.154286 0.571431 0.988458 1.455057 1.862560 0.250947 0.715824 1.073857 1.538417 1.980290 0.472951 0.845632 1.308697 1.729536 0.186406 0.643411 1.074956 1.556176 -0.015170 0.423108 0.865847 1.359798 1.786901 0.239562 0.715538 1.161031 1.654105 0.127671 0.570171 1.088014 1.490140 0.021600 0.488272 0.914558 1.492604 1.873761 0.419953 0.895570 1.318383 1.833551 0.363750 0.806107 1.359281 1.818243 0.351549 0.789961 1.375158 1.815330 0.356645 0.849039 1.361991 1.852460 0.354014 0.875769 1.414631 1.886214 0.441432 0.925468 1.465867 1.985318 0.511981 1.077440 1.593888 0.123374 0.663425 1.186232 1.761522 0.305868 0.816538 1.370138 1.872335 0.471724 0.996969 1.537520 0.122604 0.642210 1.214546 1.770073 0.275516 0.897750 1.424936 0.037805 0.580711 1.155954 1.699258 0.334889 0.862875 1.390381 0.075248 0.585858 1.213894 1.775311 0.381455 0.909914 1.524337 0.129218 0.711160 1.306275 1.948775 0.515718 1.119798 1.701108 0.321255 0.868285 1.525781 0.140320 0.732154 1.340707 1.957371 0.589810 1.213094 1.863861 0.456199 1.083969 1.703729 0.339824 0.979382 1.592207 0.246499 0.842524 1.521112 0.106287 0.767233 1.401085 0.041591 0.695825 1.349403 0.025626 0.676137 1.344048 1.915440 0.668761 1.255920 1.962520 0.647971 1.259627 1.968512 0.615735 1.276549 -0.027317 0.631525 1.302319 1.978895 0.683033 1.353748 0.051124 0.717700 1.434431 0.089439 0.779075 1.509871 0.209280 0.824919 1.583538 0.233242 0.963327 1.643651 0.371820 1.106405 1.767900 0.532921 1.205227 1.935747 0.669913 1.391392 0.115968 0.843040 1.566155 0.263444 0.980822 1.695078 0.446317 1.216631 1.873835 0.711338 1.417010 0.151605 0.931701 1.600766 0.364812 1.111608 1.862495 0.607562 1.341223 0.147461 0.860078 1.646578 0.381740 1.157969 1.916823 0.712188 1.453971 0.215755 0.966795 1.778153 0.595423 1.341094 0.072267 0.863999 1.695548 0.403785 1.227574 -0.005852 0.846737 1.590415 0.450973 1.215624 1.959836 0.803012 1.587925 0.393015 1.197005 -0.010300 0.832366 1.600709 0.454463 1.246709 0.049479 0.875284 1.704860 0.492891 1.345114 0.125258 1.025693 1.801848 0.667812 1.472838 0.301784 1.150247 -1.860016 0.781391 1.659846 0.509465 1.383307 0.272354 1.052898 1.919580 0.794949 1.642447 0.488408 1.322762 0.218270 1.059511 1.918954 0.774049 1.614128 0.570460 1.403259 0.270587 1.134561 0.033089 0.864284 1.788160 0.649416 1.539170 0.350725 1.298719 0.180612 1.068719 1.971778 0.879592 1.801590 0.719091 1.639475 0.491312 1.424295 0.293905 1.230206 0.162120 1.024769 1.930470 0.838803 1.747737 0.698268 1.607125 0.537609 1.444946 0.393225 1.321328 0.231684 1.159169 0.094826 1.036450 1.967168 0.895560 1.802236 0.762060 1.702387 0.652066 1.628468 0.563836 1.562526 0.514139 1.450677 0.415960 1.384552 0.344230 1.309940 0.232009 1.232825 0.164566 1.142350 0.143463 1.076795 0.062270 1.028443 -0.005068 1.039396 -0.005955 0.977298 -0.012381 0.934874 1.940100 0.960167 1.895041 0.937458 1.927212 0.869949 1.889882 0.848756 1.913904 0.885287 1.918623 0.941468 1.958283 0.995516 -0.038713 1.004378 0.038097 1.090272 0.073925 1.124867 0.163621 1.159145 0.225641 1.268090 0.310339 1.344014 0.367938 1.441281 0.475569 1.546526 0.481429 1.521137 0.618336 1.630470 0.706958 1.774715 0.836108 1.878673 0.910649 -0.042056 1.037029 0.118989 1.169653 0.267076 1.347713 0.437911 1.483852 0.582048 1.690159 0.765404 1.825111 0.941665 -1.646553 1.030663 0.158388 1.238492 0.403172 1.483557 0.514482 1.672483 0.795688 1.875478 0.918494 0.066695 1.170268 0.259601 1.342609 0.521838 1.522640 0.712790 1.793078 0.936976 0.046162 1.227280 0.356686 1.372702 0.557174 1.669051 0.825772 -0.016897 1.109943 0.246113 1.363033 0.538749 1.746537 0.844635 -0.020265 1.137180 0.257073 1.484766 0.580482 1.752370 0.887480 0.066364 1.225269 0.406482 1.520341 0.747661 1.922173 1.102346 0.287499 1.481763 0.683883 1.825360 1.021003 0.291213 1.525660)
       ) 

;;; 2048 odd --------------------------------------------------------------------------------
(vector 2048 83.108 #r(0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 0 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0)

       ;; pp:
	48.227113 #r(0.000000 1.168317 0.306246 1.389577 0.542102 1.674988 0.818333 1.926918 1.078044 0.217665 1.353520 0.500540 1.626923 0.742401 1.922073 1.074748 0.164099 1.323654 0.479484 1.604173 0.769584 1.923601 1.070452 0.211220 1.344193 0.520400 1.658847 0.813441 1.966518 1.135574 0.307855 1.466544 0.608733 1.760589 0.907749 0.087388 1.273022 0.385732 1.563888 0.759841 1.911479 1.112696 0.283511 1.427125 0.572863 1.745375 0.943211 0.078793 1.276160 0.429327 1.615575 0.806047 1.936112 1.156276 0.314019 1.531610 0.698400 1.882336 1.080304 0.237932 1.428581 0.596742 1.783820 0.947006 0.175729 1.360030 0.551014 1.732450 0.955448 0.146372 1.294755 0.509920 1.723667 0.938282 0.142004 1.309291 0.529710 1.713674 0.952922 0.123674 1.321953 0.521504 1.752822 0.942666 0.138890 1.363812 0.553881 1.786174 0.995148 0.180285 1.431995 0.639219 1.854394 1.055776 0.302312 1.468308 0.725553 1.901723 1.156769 0.367516 1.582233 0.822104 0.019673 1.261974 0.496270 1.700635 0.934955 0.159818 1.435670 0.623317 1.860237 1.101005 0.308823 1.540667 0.801723 0.011650 1.280499 0.495682 1.755193 0.968256 0.236164 1.459478 0.704829 1.989888 1.178349 0.438350 1.697294 0.944546 0.194696 1.451346 0.663978 1.943319 1.191823 0.452622 1.710112 0.945986 0.204960 1.443959 0.731448 1.970523 1.217575 0.507907 1.763899 1.011318 0.292054 1.534453 0.832330 0.077808 1.367518 0.608810 1.904125 1.149629 0.408994 1.655379 0.940574 0.266377 1.504265 0.793913 0.048299 1.344985 0.646981 1.875181 1.183234 0.443765 1.720531 1.019592 0.331108 1.590199 0.901478 0.183385 1.464038 0.748269 0.042630 1.346372 0.635054 1.908096 1.185690 0.499692 1.750318 1.026586 0.382831 1.678990 0.993445 0.274091 1.596602 0.890156 0.197906 1.492421 0.821509 0.078215 1.411481 0.694635 0.037213 1.295547 0.640279 1.930358 1.243925 0.584393 1.889574 1.225251 0.507470 1.827694 1.176372 0.473580 1.765964 1.102374 0.440836 1.732410 1.084466 0.376220 1.719835 1.064446 0.366495 1.685578 1.063307 0.402332 1.681610 0.999459 0.344383 1.666837 1.032386 0.358642 1.697177 1.038944 0.381494 1.693490 1.039095 0.376976 1.748876 1.087718 0.427548 1.757247 1.059224 0.433919 1.777650 1.145464 0.503754 1.856424 1.178800 0.556734 1.886511 1.227333 0.589276 -0.022390 1.297253 0.646962 0.043143 1.389542 0.763298 0.115321 1.471341 0.838914 0.196445 1.557865 0.950851 0.310176 1.667695 1.055790 0.416940 1.767689 1.151732 0.538435 1.899615 1.270249 0.641957 0.014343 1.411152 0.792288 0.164929 1.547637 0.924720 0.311118 1.700183 1.057406 0.462083 1.849189 1.219231 0.606808 1.987575 1.370607 0.807407 0.180555 1.579550 0.946003 0.351616 1.760861 1.156246 0.561939 1.963796 1.338476 0.733233 0.123247 1.528858 0.945638 0.326526 1.752055 1.118276 0.564754 1.966174 1.360653 0.795094 0.184246 1.600768 1.020490 0.436375 1.853021 1.256158 0.653237 0.087608 1.514736 0.932669 0.328868 1.745125 1.137068 0.578418 0.034201 1.444543 0.855253 0.284775 1.739677 1.145730 0.575272 -0.004364 1.430306 0.870180 0.311030 1.733238 1.176505 0.602219 0.028793 1.473922 0.950318 0.348153 1.802878 1.230777 0.686801 0.117086 1.561601 0.993103 0.438254 1.905274 1.333157 0.776611 0.250979 1.696691 1.145714 0.611411 0.030994 1.496787 0.953772 0.379694 1.842697 1.329874 0.801928 0.264756 1.692445 1.130857 0.615056 0.088705 1.563367 0.998066 0.467025 1.933470 1.398509 0.857143 0.356442 1.804424 1.300280 0.745897 0.244718 1.748771 1.210504 0.673592 0.140058 1.597772 1.080916 0.587561 0.077840 1.542030 1.009429 0.522307 -0.000056 1.436503 0.940130 0.437605 1.984120 1.427314 0.931342 0.428012 1.912917 1.416992 0.880655 0.380403 1.880685 1.383538 0.867671 0.368131 1.892479 1.383225 0.879089 0.366102 1.839023 1.377889 0.879854 0.376468 1.886474 1.390371 0.940835 0.443496 1.958787 1.471799 0.950318 0.500039 -0.011229 1.527188 1.022190 0.533931 0.052605 1.599781 1.095423 0.602610 0.143802 1.651249 1.205823 0.718069 0.233649 1.740574 1.292139 0.839145 0.341835 1.886988 1.404975 0.933186 0.476123 0.023826 1.559196 1.105493 0.607299 0.150153 1.659551 1.228117 0.765112 0.339360 1.850900 1.406555 0.924679 0.480984 0.033995 1.591237 1.146466 0.656464 0.218486 1.777789 1.306662 0.878227 0.423185 1.974433 1.558975 1.079281 0.643215 0.214042 1.786003 1.351333 0.897376 0.449675 0.028960 1.571798 1.121839 0.714210 0.291421 1.860717 1.427285 0.990236 0.539700 0.117803 1.671110 1.254758 0.857819 0.415841 1.985858 1.530794 1.138555 0.747952 0.333304 1.869740 1.469237 1.049188 0.664405 0.213570 1.803327 1.395247 0.985342 0.571291 0.155815 1.755907 1.322303 0.901588 0.523484 0.113705 1.715574 1.300165 0.934659 0.513736 0.098249 1.704761 1.298516 0.892573 0.505157 0.116030 1.715673 1.303505 0.911483 0.508360 0.143977 1.764846 1.340507 0.946823 0.550061 0.205364 1.803547 1.389263 1.021582 0.634347 0.236078 1.861085 1.487942 1.111133 0.741943 0.366272 1.970097 1.598842 1.226364 0.879271 0.490214 0.109838 1.735628 1.333998 0.988702 0.614503 0.257080 1.879639 1.504049 1.150371 0.773859 0.414304 0.062984 1.701620 1.382217 0.996126 0.617361 0.272861 1.893463 1.560657 1.200707 0.868961 0.516225 0.125963 1.822441 1.430276 1.082899 0.723046 0.396823 0.046831 1.707508 1.386557 1.001909 0.646194 0.332450 1.975799 1.632954 1.299789 0.931751 0.625882 0.303247 1.963155 1.629440 1.296889 0.967411 0.626221 0.300321 1.967353 1.648897 1.345838 1.027882 0.675008 0.321351 0.022317 1.678150 1.357619 1.020882 0.736948 0.408148 0.061601 1.767679 1.431665 1.113088 0.833006 0.503146 0.188085 1.876872 1.567128 1.261742 0.968748 0.635229 0.335738 0.032119 1.742659 1.421860 1.107756 0.788215 0.522537 0.205328 1.923461 1.604514 1.323170 1.016884 0.719319 0.438605 0.130295 1.805776 1.531438 1.261048 0.954981 0.676310 0.388724 0.079063 1.804892 1.526197 1.254508 0.977687 0.648902 0.341485 0.094756 1.841373 1.561772 1.292322 0.992083 0.698121 0.451906 0.143374 1.870199 1.603694 1.364999 1.075742 0.815389 0.553544 0.268996 0.000727 1.737559 1.479085 1.197721 0.953347 0.679263 0.408268 0.185847 1.891475 1.611957 1.389386 1.148960 0.877330 0.604851 0.346255 0.084281 1.865712 1.633767 1.325100 1.114411 0.882320 0.606513 0.351186 0.094528 1.854618 1.621726 1.413460 1.133037 0.910941 0.676742 0.456305 0.180579 1.940045 1.715998 1.462157 1.223030 1.018029 0.784133 0.542296 0.285281 0.054632 1.876312 1.612670 1.393364 1.173270 0.954452 0.734897 0.501428 0.268962 0.069793 1.823261 1.568122 1.368643 1.165946 0.965253 0.748901 0.530965 0.320594 0.105719 1.866585 1.692148 1.468994 1.249454 1.044969 0.830411 0.630540 0.461665 0.228870 0.012140 1.807284 1.617014 1.444688 1.190845 0.993321 0.820464 0.608044 0.453116 0.226882 0.012133 1.828909 1.656023 1.450055 1.267860 1.076105 0.889806 0.716539 0.496108 0.330973 0.162863 1.951183 1.800256 1.583636 1.406521 1.255381 1.022486 0.871202 0.701516 0.507004 0.332260 0.150721 -0.002128 1.823793 1.632902 1.480078 1.314496 1.142324 0.980866 0.820566 0.607045 0.483612 0.320727 0.154000 1.979072 1.814901 1.662573 1.503362 1.339343 1.169011 1.030104 0.878419 0.722819 0.589452 0.415141 0.274655 0.117264 1.955311 1.787296 1.670429 1.489169 1.342707 1.211162 1.074498 0.921436 0.775211 0.636280 0.492743 0.369610 0.252303 0.069227 1.912745 1.788463 1.671289 1.528221 1.394403 1.292770 1.115402 0.999283 0.891973 0.746624 0.623268 0.496207 0.390412 0.215531 0.092167 0.002717 1.845674 1.729630 1.627200 1.494372 1.374852 1.294258 1.176735 1.024290 0.946137 0.831475 0.703048 0.605515 0.485586 0.377314 0.259681 0.153212 0.032281 1.929963 1.815612 1.714396 1.627201 1.507008 1.384297 1.310471 1.193377 1.117079 0.998396 0.887744 0.821126 0.734174 0.600962 0.526171 0.425608 0.324660 0.275890 0.169065 0.067891 1.975530 1.894981 1.818302 1.735006 1.666100 1.579114 1.473354 1.403392 1.325330 1.281410 1.164799 1.051104 1.011484 0.942671 0.869224 0.782063 0.718474 0.635085 0.568865 0.492717 0.411139 0.362916 0.295926 0.226301 0.144636 0.111457 0.064984 1.967115 1.914045 1.842114 1.799009 1.756090 1.648521 1.598965 1.565256 1.479075 1.422306 1.408081 1.327297 1.279328 1.239448 1.180976 1.121178 1.066645 1.042279 1.011730 0.949439 0.923035 0.862231 0.826468 0.800271 0.762902 0.704107 0.668185 0.616637 0.600870 0.538814 0.517347 0.473381 0.435567 0.421434 0.394626 0.340875 0.294824 0.305847 0.251356 0.215528 0.228342 0.210152 0.173176 0.117382 0.130300 0.135612 0.064060 0.079236 0.039917 0.000238 0.008649 0.042736 1.973388 1.938761 1.942577 1.941009 1.957497 1.951341 1.934370 1.906453 1.906833 1.917222 1.922619 1.886032 1.885060 1.883358 1.886549 1.869144 1.876837 1.899705 1.923877 1.922553 1.936993 1.888962 1.891913 1.919717 1.921148 1.938022 1.966323 1.952309 1.959025 1.990549 0.012675 0.035053 0.031608 0.050042 0.083227 0.092153 0.105573 0.134948 0.125957 0.176587 0.185471 0.204322 0.261569 0.273640 0.284012 0.298114 0.324672 0.360851 0.384940 0.449023 0.474747 0.506366 0.529303 0.566701 0.622958 0.626227 0.680778 0.709152 0.772202 0.827865 0.862462 0.880081 0.916483 0.976921 1.013455 1.069330 1.114285 1.174231 1.213849 1.271723 1.303532 1.369007 1.448529 1.472482 1.515571 1.578755 1.646710 1.738489 1.774171 1.797146 1.890847 1.940881 0.020649 0.072879 0.139929 0.182390 0.209886 0.326191 0.382486 0.425900 0.540702 0.616996 0.678182 0.750428 0.794260 0.865408 0.965569 1.048545 1.107883 1.195979 1.283795 1.333994 1.436326 1.529028 1.616353 1.698761 1.750842 1.828290 1.921743 0.049342 0.123287 0.209422 0.309851 0.414990 0.502111 0.553095 0.653375 0.777183 0.869256 0.948034 1.044442 1.171310 1.264893 1.345447 1.432910 1.549417 1.671562 1.762223 1.863727 1.984252 0.094653 0.198185 0.306593 0.422184 0.525892 0.647520 0.752478 0.826458 0.982719 1.100357 1.191979 1.301388 1.435162 1.561190 1.673969 1.790460 1.901855 0.050777 0.159378 0.299610 0.406584 0.531754 0.655075 0.806854 0.929849 1.049975 1.207823 1.347869 1.449601 1.575474 1.758607 1.892381 0.004930 0.130673 0.270015 0.441355 0.574708 0.695792 0.860090 0.993985 1.132285 1.285849 1.436160 1.567180 1.744349 1.852595 0.033525 0.155222 0.336308 0.486468 0.651217 0.796126 0.935129 1.084880 1.257417 1.437881 1.582941 1.742552 1.889776 0.068448 0.190714 0.390719 0.579355 0.708667 0.872693 1.063031 1.239548 1.394871 1.569833 1.730941 1.912983 0.061212 0.243580 0.439972 0.588625 0.785652 0.974364 1.127181 1.275869 1.478474 1.659190 1.874523 0.064297 0.223418 0.395858 0.616556 0.790036 0.987887 1.154860 1.361679 1.550801 1.764317 1.946070 0.130535 0.347569 0.509355 0.719236 0.933185 1.092519 1.310376 1.527506 1.721998 1.915202 0.116142 0.316124 0.487346 0.719614 0.932913 1.164396 1.375972 1.555859 1.802488 1.978037 0.219995 0.410757 0.622871 0.835298 1.088037 1.271197 1.509088 1.719229 1.916070 0.150023 0.364108 0.579880 0.831184 1.068853 1.292719 1.489706 1.746235 1.963527 0.190920 0.428107 0.642351 0.907857 1.074150 1.348019 1.592123 1.807540 0.052656 0.304815 0.522733 0.792374 0.994126 1.278625 1.482316 1.735180 1.955994 0.219874 0.472919 0.702846 0.965167 1.232652 1.430683 1.724849 1.986773 0.237795 0.514117 0.719670 1.006150 1.264305 1.477181 1.737883 0.008926 0.290213 0.544623 0.781773 1.052173 1.338676 1.604580 1.886346 0.118265 0.408062 0.657571 0.937844 1.201387 1.465611 1.733956 0.013918 0.299912 0.579557 0.850655 1.129403 1.372816 1.689083 1.945596 0.224903 0.529709 0.796738 1.094651 1.359214 1.660137 1.960396 0.224278 0.521571 0.806539 1.099062 1.424568 1.689522 1.982850 0.268190 0.559653 0.861361 1.146896 1.477966 1.741980 0.053382 0.349098 0.688539 1.000222 1.250416 1.577274 1.834251 0.141193 0.507980 0.786888 1.090646 1.412231 1.708758 0.027318 0.336402 0.678597 0.916820 1.294060 1.582637 1.949886 0.228557 0.567190 0.891101 1.183031 1.530731 1.817504 0.169718 0.521842 0.790390 1.161161 1.454943 1.815854 0.126094 0.459359 0.804588 1.105927 1.437290 1.807607 0.094556 0.453338 0.788704 1.149350 1.495317 1.823638 0.157325 0.501258 0.811832 1.190106 1.534293 1.876344 0.211783 0.538765 0.905521 1.252711 1.623240 1.988093 0.306241 0.679166 1.033001 1.363443 1.716883 0.085600 0.452308 0.756560 1.147338 1.521961 1.900316 0.237755 0.619619 0.951324 1.349485 1.714521 0.070574 0.444120 0.776501 1.168625 1.522564 1.913665 0.232705 0.646874 1.029779 1.402019 1.759231 0.147507 0.548504 0.919313 1.286667 1.673775 0.036322 0.431638 0.828071 1.223760 1.597702 1.980240 0.365390 0.773972 1.158473 1.536172 1.947866 0.324629 0.719059 1.063251 1.510483 1.875147 0.276965 0.684852 1.070129 1.483532 1.900568 0.276534 0.680041 1.126493 1.480584 1.852259 0.313927 0.701732 1.132366 1.524427 1.924541 0.348120 0.725660 1.165443 1.576621 -0.009231 0.381895 0.825512 1.210577 1.665160 0.081962 0.513425 0.924128 1.327985 1.764610 0.180712 0.619123 1.055957 1.479029 1.905906 0.347879 0.757692 1.192410 1.635110 0.042459 0.486922 0.909473 1.346774 1.752851 0.232134 0.638118 1.138576 1.537690 1.964179 0.425654 0.850882 1.303969 1.769972 0.194988 0.621398 1.082861 1.506125 1.975330 0.441476 0.895664 1.337341 1.799664 0.228745 0.677589 1.144096 1.605883 0.058156 0.542269 1.003925 1.453853 1.931168 0.358276 0.837539 1.285172 1.777278 0.234523 0.688245 1.162262 1.625042 0.088142 0.570914 1.066484 1.510798 1.990992 0.425130 0.950624 1.399806 1.896205 0.359127 0.845513 1.315589 1.769059 0.265825 0.772079 1.251452 1.769709 0.242244 0.710520 1.175463 1.662431 0.170697 0.653244 1.144150 1.633263 0.129847 0.621139 1.110393 1.623075 0.122561 0.625007 1.087307 1.604000 0.080667 0.612860 1.086331 1.588476 0.103441 0.624693 1.124829 1.607042 0.144109 0.627168 1.145780 1.678098 0.164835 0.677344 1.207860 1.707729 0.226275 0.782289 1.259909 1.801961 0.306170 0.818420 1.345932 1.871996 0.378053 0.897527 1.393827 1.958497 0.477787 0.984022 1.549623 0.052260 0.602910 1.129143 1.628488 0.205399 0.736135 1.260001 1.775946 0.350518 0.856300 1.417899 1.950957 0.474346 1.029451 1.566670 0.106394 0.660581 1.237067 1.763092 0.293778 0.836217 1.382231 1.985804 0.503120 1.039518 1.610723 0.097075 0.693947 1.276094 1.821418 0.396218 0.936863 1.496460 0.019929 0.625652 1.175521 1.746747 0.314277 0.870948 1.443053 0.005544 0.546328 1.144312 1.688262 0.262182 0.850669 1.405154 -0.000658 0.562957 1.101778 1.704565 0.299478 0.868760 1.469853 0.010945 0.599216 1.187264 1.775758 0.359806 0.934819 1.538265 0.067333 0.710610 1.258221 1.871266 0.462355 1.054525 1.638419 0.184084 0.822073 1.415164 0.010641 0.632972 1.225855 1.811322 0.415242 1.008735 1.610749 0.213145 0.807753 1.415926 0.038013 0.594074 1.227073 1.842047 0.428644 1.062844 1.677889 0.293326 0.891257 1.526966 0.114549 0.721394 1.340176 1.962919 0.586227 1.216803 1.807718 0.437672 1.063170 1.690155 0.326192 0.944095 1.581807 0.177941 0.812497 1.437636 0.080649 0.673520 1.327856 1.968496 0.598693 1.242579 1.853887 0.532455 1.155054 1.760001 0.426900 1.024725 1.691162 0.333110 0.979270 1.615095 0.257188 0.908641 1.539823 0.219938 0.837482 1.470271 0.146057 0.796825 1.480682 0.113938 0.740862 1.396853 0.056800 0.728510 1.338403 0.019439 0.703417 1.356703 -0.000485 0.694774 1.340647 1.979194 0.676405 1.331445 0.010697 0.684224 1.350121 0.000324 0.672710 1.355042 0.032760 0.684788 1.340586 0.032175 0.737622 1.393281 0.057678 0.742968 1.425580 0.134510 0.775660 1.449152 0.119946 0.835818 1.519941 0.188817 0.906539 1.602464 0.256547 0.980502 1.645949 0.328929 1.002129 1.676848 0.429123 1.110714 1.838422 0.518189 1.210349 1.916801 0.625118 1.321040 -0.018850 0.686840 1.413612 0.127117 0.829738 1.512840 0.254093 0.956824 1.651495 0.363728 1.103225 1.784336 0.518227 1.249191 1.908490 0.631120 1.362014 0.072631 0.823296 1.501579 0.249972 0.955754 1.685113 0.433044 1.161269 1.852396 0.572688 1.275133 0.019600 0.794492 1.527841 0.200304 0.939592 1.720048 0.448635 1.195371 1.856714 0.630159 1.327899 0.094836 0.846745 1.552659 0.320159 1.026333 1.816267 0.566629 1.324272 0.035271 0.813512 1.538062 0.281141 1.025596 1.778805 0.542682 1.259785 0.026438 0.808474 1.506059 0.279101 1.093308 1.853907 0.566733 1.374828 0.094789 0.849733 1.631339 0.397387 1.160329 1.899860 0.686540 1.388703 0.190909 0.996676 1.760603 0.545392 1.314539 0.067945 0.833259 1.645942 0.398206 1.161634 1.985875 0.709933 1.494067 0.272499 1.058444 1.880854 0.655889 1.400049 0.216370 1.043283 1.758548 0.570975 1.380243 0.144541 0.911783 1.724627 0.508892 1.289896 0.102976 0.890141 1.680272 0.489587 1.300515 0.078447 0.871195 1.684896 0.526015 1.319081 0.054994 0.916061 1.725978 0.544137 1.316295 0.100896 0.932631 1.782723 0.537374 1.356760 0.165104 0.990989 1.806104 0.650146 1.435302 0.268252 1.100804 1.898788 0.746485 1.556202 0.358007 1.158510 0.028559 0.805273 1.637582 0.490621 1.317100 0.136628 0.976421 1.801083 0.649459 1.467310 0.312931 1.143276 1.987858 0.811396 1.656230 0.496143 1.334263 0.173784 0.996785 1.855458 0.705703 1.545706 0.371771 1.215496 0.026029 0.911612 1.724119 0.627201 1.477956 0.304956 1.156798 0.030582 0.865966 1.719610 0.591973 1.458006 0.290281 1.157882 0.017384 0.885498 1.738467 0.581073 1.433098 0.284432 1.167912 0.053599 0.879867 1.793832 0.638041 1.524373 0.382684 1.277612 0.140944 1.016123 1.916052 0.786822 1.685224 0.544975 1.423711 0.262486 1.169663 0.063323 0.943321 1.771343 0.694592 1.596440 0.458398 1.340718 0.239579 1.146492 0.015933 0.909836 1.757783 0.693966 1.577603 0.452517 1.373250 0.249503 1.161629 0.057120 0.992282 1.875135 0.775061 1.661715 0.587914 1.502767 0.367476 1.268996 0.214207 1.099644 -0.008379 0.891700 1.795258 0.750777 1.635972 0.554520 1.447942 0.363274 1.273223 0.192076 1.091137 0.054395 0.996724 1.871563 0.810283 1.739596 0.632267 1.569710 0.524572 1.424198 0.365509 1.310664 0.237929 1.185473 0.067107 1.002651 1.963840 0.926319 1.858448 0.748124 1.730812 0.618387 1.571237 0.510008 1.420078 0.375693 1.304253 0.269438 1.201637 0.113081 1.047053 0.039842 0.927604 1.913755 0.862597 1.790456 0.758761 1.745011 0.666053 1.617486 0.588493 1.536786 0.503303 1.484659 0.452545 1.400677 0.356820 1.336308 0.301777 1.240077 0.199755 1.184817 0.153212 1.113229 0.080137 1.069531 0.016251 0.978648 1.941501 0.927146 1.897775 0.843674 1.871302 0.856274 1.802893 0.784304 1.756263 0.691920 1.721252 0.711231 1.639916 0.648393 1.633802 0.618752 1.613282 0.594744 1.598892 0.588364 1.536859 0.519453 1.521018 0.492560 1.510798 0.481693 1.483141 0.495336 1.498852 0.474824 1.493774 0.479351 1.524678 0.479630 1.480028 0.482361 1.534165 0.514986 1.507683 0.557884 1.570134 0.603507 1.595319 0.593091 1.624948 0.586857 1.633954 0.606518 1.639853 0.685068 1.675324 0.693151 1.719727 0.759162 1.759364 0.815815 1.820281 0.848602 1.880307 0.951274 1.956977 1.000125 -0.757271 0.989561 0.049572 1.103902 0.098759 1.192978 0.194067 1.285824 0.297162 1.342475 0.411952 1.487264)
       )
))


;; :odd 65536 (311.51645615075 1.5666759234657 2.0944106499714) 0.51769778542275 (100)



;;; ---------------------------------------- prime-numbered harmonics (and first) ----------------------------------------

(define primoid-min-peak-phases (vector

(vector 1  1.0   #r(0)
     )

(vector 2  1.76  #r(0 1)
     )

;;; 3 prime --------------------------------------------------------------------------------
(vector 3  2.1949384212494 #r(0 0 1)
     1.980 #r(0 62/39 13/41) ; 1 2 3 -- same as :all in this case
     1.9798574987316 #r(0.0 1.5896952797511 0.31654707828801)
     1.9798030853271 #r(0.0 1.5897271633148 0.31667485833168)
     )

;;; 4 prime --------------------------------------------------------------------------------
(vector 4  2.5978584289551 #r(0 0 1 1)
     
     ;2.2039985204158 #r(0 0 12 4) / 20
     2.1930510997772 #r(0.000 0.996 0.596 0.217)
     2.1930510997772 #r(0.000 1.996 0.596 0.217)
     2.1930510997772 #r(0.000 0.004 1.404 1.783)

     2.1927945613861 #r(0.0 1.0065363103693 1.4072853370949 1.7873527125308)
     2.1921416218407 #r(0.0 1.0052774357064 1.4058145325161 1.7854903085184)
     2.1921210289001 #r(0.0 1.0052587985992 1.4057868719101 1.7854607105255)
     )

;;; 5 prime --------------------------------------------------------------------------------
(vector 5  2.7172040939331 #r(0 0 1 0 0)

     2.476848 #r(0.000000 1.577434 0.385232 1.294742 1.022952)
     2.476837 #r(0.000000 0.422530 1.614642 0.705077 0.976763)
     )

;;; 6 prime --------------------------------------------------------------------------------
(vector 6  3.1241359710693 #r(0 0 0 1 0 0)

     2.805574 #r(0.000000 1.568945 0.034019 1.082417 0.900415 0.797509)
     2.805492 #r(0.000000 0.431060 -0.033992 0.917551 1.099550 1.202470)
     2.805413 #r(0.000000 0.431110 -0.033974 0.917615 1.099635 1.202594)
     )

;;; 7 prime --------------------------------------------------------------------------------
(vector 7  3.4886319637299 #r(0 1 1 0 0 0 0)

     3.061861 #r(0.000000 0.715739 0.261422 0.169339 0.062479 1.180650 0.330190)
     3.061763 #r(0.000000 0.715523 0.261251 0.168577 0.061828 1.179155 0.328665)
     )

;;; 8 prime --------------------------------------------------------------------------------
(vector 8  3.7088720798492 #r(0 0 0 0 0 0 1 0)

     3.263115 #r(0.000000 0.207652 0.035023 1.752163 0.064249 0.346105 1.403170 0.065734)
     3.262977 #r(0.000000 0.792550 1.965637 0.248661 1.936840 1.655647 0.598935 1.936915)
     3.262789 #r(0.000000 0.792261 1.965087 0.247823 1.935907 1.654053 0.597010 1.934463)
     )

;;; 9 prime --------------------------------------------------------------------------------
(vector 9  3.9154822826385 #r(0 0 0 1 1 1 0 0 0)

     3.382645 #r(0.000000 0.562589 0.520940 1.521127 1.682374 0.721497 0.805534 1.254209 0.726847)
     3.382399 #r(0.000000 1.437745 1.479554 0.480268 0.319088 1.280870 1.197460 0.749784 1.277141)
     3.382150 #r(0.000000 1.437471 1.479039 0.479171 0.317977 1.279012 1.195104 0.746644 1.274032)
     )

;;; 10 prime --------------------------------------------------------------------------------
(vector 10 4.1209712028503 #r(0 0 1 0 0 0 1 0 0 0)

     3.602602 #r(0.000000 1.405079 0.694565 0.388252 0.756491 1.849937 0.076683 1.023761 0.374165 1.226329)
     3.602329 #r(0.000000 0.594431 1.305346 1.611464 1.243212 0.149889 1.922392 0.975619 1.625276 0.772405)
     3.601897 #r(0.000000 0.594605 1.305309 1.611462 1.242927 0.149405 1.922318 0.974872 1.624292 0.771826)
     )

;;; 11 prime --------------------------------------------------------------------------------
(vector 11 4.4176635742188 #r(0 0 1 0 0 0 0 0 0 1 0)

     3.779046 #r(0.000000 0.211414 1.453486 1.827574 1.811694 1.949216 1.313595 0.823256 1.334141 0.127849 0.824659)
     3.778444 #r(0.000000 0.211392 1.453207 1.827566 1.811268 1.948666 1.312975 0.822389 1.333108 0.126706 0.823083)
     )

;;; 12 prime --------------------------------------------------------------------------------
(vector 12 4.3595271110535 #r(0 0 0 0 0 0 1 0 1 1 0 1)

     3.936657 #r(0.000000 0.367346 0.997085 1.763425 1.295636 0.140826 0.757652 1.565853 1.284651 0.304758 0.331248 0.325474)
     3.936584 #r(0.000000 0.366730 0.995852 1.762390 1.293763 0.137304 0.753397 1.560313 1.278944 0.297723 0.322472 0.315856)
     3.935928 #r(0.000000 0.367095 0.996695 1.763345 1.295131 0.139476 0.755820 1.563961 1.282494 0.302360 0.327995 0.321982)
     )

;;; 13 prime --------------------------------------------------------------------------------
(vector 13 4.8980793952942 #r(0 0 0 1 0 0 1 1 1 1 1 1 0)

     4.155503 #r(0.000000 1.115751 0.463368 0.110540 0.613302 1.581997 1.394002 -0.005270 1.724217 0.023531 1.743892 0.616897 0.124222)
     4.155104 #r(0.000000 0.888606 1.516761 -0.128988 1.376524 0.383262 0.572385 -0.041726 0.228441 1.918487 0.187862 1.304384 1.779710)
     4.154486 #r(0.000000 0.888925 1.516611 -0.128449 1.377349 0.383874 0.573640 -0.040502 0.230047 1.920090 0.190320 1.307111 1.782269)
     )

;;; 14 prime --------------------------------------------------------------------------------
(vector 14 4.827317237854 #r(0 0 0 0 1 0 0 0 0 1 1 0 0 0)

     4.325356 #r(0.000000 0.359558 1.885647 0.244632 1.221244 1.839379 1.316045 0.525308 0.483244 1.183590 1.084986 0.271051 0.780356 0.855105)
     4.324364 #r(0.000000 0.359123 1.885242 0.244967 1.221612 1.840358 1.317076 0.526663 0.485486 1.185929 1.087828 0.273652 0.783599 0.859686)
     )

;;; 15 prime --------------------------------------------------------------------------------
(vector 15 5.116711139679 #r(0 0 0 0 1 1 0 0 1 0 0 0 1 1 1)

     4.467959 #r(0.000000 1.165302 0.822381 1.719844 1.177673 0.000074 -0.047034 0.249259 0.174863 0.272306 -0.034377 1.204925 0.800910 1.798882 0.085175)
     4.465870 #r(0.000000 1.195783 0.875671 1.808021 1.309702 0.184662 0.170474 0.531131 0.521153 0.683109 0.474077 -0.194026 1.432983 0.523484 0.889349)
     )

;;; 16 prime --------------------------------------------------------------------------------
(vector 16 5.2015118598938 #r(0 0 0 0 1 1 0 0 1 0 0 0 1 1 1 1)

     4.602505 #r(0.000000 0.065822 0.364277 0.133567 0.202441 1.541212 1.225002 0.832999 1.687176 1.503245 1.015565 1.715739 1.103351 1.602678 1.102870 1.723542)
     4.600306 #r(0.000000 0.087862 0.378855 0.177701 0.258884 1.624830 1.330220 0.960734 1.836164 1.680878 1.236729 1.958382 1.391766 1.922763 1.425076 0.083217)
     )

;;; 17 prime --------------------------------------------------------------------------------
(vector 17 5.5318970680237 #r(0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1)

     4.719141 #r(0.000000 0.742295 1.745265 1.857635 0.393094 0.085265 0.379253 1.692020 1.022244 0.008090 1.067230 1.241546 0.650781 0.027258 1.334059 1.354939 0.974983)
     4.718649 #r(0.000000 0.751159 1.770960 1.891296 0.451714 0.167219 0.486669 1.820262 1.171314 0.188288 1.302438 1.491326 0.945450 0.342701 1.668608 1.730493 1.394926)
     )

;;; 18 prime --------------------------------------------------------------------------------
(vector 18 5.518 #r(0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 0)

     4.855354 #r(0.000000 0.761212 1.399765 1.386893 -0.022155 1.259519 0.806762 0.461717 0.840663 0.867450 0.860949 1.743030 1.407070 0.651538 1.045391 1.279111 0.110257 1.307989)
     4.855108 #r(0.000000 0.750207 1.384561 1.357598 -0.059069 1.202337 0.735689 0.367843 0.732570 0.743255 0.704408 1.570924 1.212329 0.426050 0.813634 1.013534 -0.181098 0.979190)
     )

;;; 19 prime --------------------------------------------------------------------------------
(vector 19 5.7069295560724 #r(0 1 1 0 1 1 0 1 0 1 1 1 0 1 0 0 0 1 1)

     5.015020 #r(0.000000 1.616061 1.626145 1.313686 1.626275 1.187207 1.456980 0.377509 -0.071549 0.474989 0.997350 1.285450 0.372950 1.499943 0.593785 0.033723 1.161466 0.319734 1.064282)
     4.998754 #r(0.000000 1.645363 1.697584 1.402853 1.761967 1.410480 1.731078 0.730841 0.373575 0.971264 1.632848 -0.032567 1.185342 0.399132 1.548900 1.042245 0.314528 1.610838 0.400814)
     )

;;; 20 prime --------------------------------------------------------------------------------
(vector 20 5.8879864574703 #r(0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 1)

     5.188618 #r(0.000000 1.304708 0.831211 0.731788 0.021326 1.272273 1.777479 0.002778 1.612017 0.397413 0.057603 1.250739 0.234023 0.556087 0.011742 0.753589 1.624826 0.625035 1.017719 0.079500)
     5.182566 #r(0.000000 1.263246 0.762194 0.608532 -0.162633 0.980718 1.431801 -0.440489 1.122128 -0.196813 -0.666076 0.455149 -0.710850 -0.505486 -1.097448 -0.446751 0.276095 -0.871587 -0.537639 -1.622748)
     )

;;; 21 prime --------------------------------------------------------------------------------
(vector 21 6.1138607493652 #r(0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0)

     5.324980 #r(0.000000 0.284388 0.190620 0.601870 1.760108 0.865412 0.509624 0.391482 -0.117180 0.413220 1.669494 1.501699 0.066514 0.632948 0.866546 1.073191 0.975355 1.318609 0.054208 1.081180 1.759607)
     5.323612 #r(0.000000 0.280854 0.184723 0.594540 1.747745 0.845155 0.483640 0.360116 -0.153262 0.371609 1.613941 1.441516 -0.006745 0.553330 0.784905 0.983522 0.871481 1.204293 -0.066217 0.952578 1.624372)
     )

;;; 22 prime --------------------------------------------------------------------------------
(vector 22 6.3374844973589 #r(0 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0)

     5.444390 #r(0.000000 1.499825 1.282805 1.145752 0.718322 0.527629 0.660515 1.924701 0.466877 0.510672 0.652853 0.187109 1.099971 0.084112 0.857217 -0.068874 1.056229 1.751779 1.460546 0.258516 0.957206 1.594508)
     5.433554 #r(0.000000 1.486514 1.390599 1.149545 0.921462 0.702749 0.884951 0.283286 0.900936 0.913025 1.182081 0.780309 1.832213 0.822636 1.714820 0.783014 0.057705 0.842269 0.698584 1.561603 0.224265 0.995298)
     )

;;; 23 prime --------------------------------------------------------------------------------
(vector 23 6.5309901747782 #r(0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1)

     5.563562 #r(0.000000 0.281094 0.583074 0.221311 1.169287 1.340406 0.217839 0.992042 0.637288 1.632696 0.471670 0.404966 0.171954 0.469626 0.291125 0.731904 1.276906 1.527897 0.612764 0.143351 1.082353 1.486999 1.452340)
     5.562290 #r(0.000000 0.285874 0.595224 0.235000 1.193968 1.380397 0.263651 1.051885 0.699527 1.708311 0.571007 0.512971 0.292952 0.607887 0.434888 0.887469 1.457277 1.731817 0.825388 0.371687 1.321790 1.739434 1.728651)
     )

;;; 24 prime --------------------------------------------------------------------------------
(vector 24 6.5623834870329 #r(0 0 1 1 0 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0)

     5.645656 #r(0.000000 0.825211 1.870903 1.169702 1.224751 0.476917 -0.084281 -0.215343 1.779853 1.403261 0.289331 1.689966 -0.267939 1.131483 1.839470 1.455399 1.365050 0.422908 0.906355 0.161003 0.266551 0.763039 1.248766 1.436520)
     5.642196 #r(0.000000 0.890373 -0.094314 1.286595 1.344700 0.673123 0.114259 0.064347 0.093887 1.778664 0.785400 0.193244 0.317478 1.782787 0.521724 0.200559 0.236076 1.409678 1.913185 1.269474 1.450265 -0.052106 0.501351 0.830713)
     )

;;; 25 prime --------------------------------------------------------------------------------
(vector 25 6.635721206665 #r(0 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1)

     5.810785 #r(0.000000 0.563705 1.200194 1.330185 1.448503 0.304746 -0.097873 1.178970 1.307797 0.187993 1.570595 0.364607 -0.021932 1.552639 -0.223928 1.041142 1.388107 1.015775 1.883861 0.551891 1.621094 0.871585 1.482986 0.450455 0.538066)
     )

;;; 26 prime --------------------------------------------------------------------------------
(vector 26 6.8401503562927 #r(0 1 0 0 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1)

     6.056645 #r(0.000000 -0.016558 0.026579 0.448353 1.015651 0.876809 0.043994 1.754158 0.381360 0.275434 1.572444 0.558006 0.419413 0.493841 0.110178 0.066677 0.147843 0.710739 1.703199 1.084656 1.051087 0.819777 1.096976 1.639534 0.286953 0.830565)
     6.055996 #r(0.000000 -0.016268 0.026203 0.449734 1.018710 0.881734 0.049135 1.760926 0.387504 0.283173 1.580172 0.572083 0.436296 0.505403 0.123142 0.081364 0.170694 0.728335 1.724322 1.110985 1.075642 0.847570 1.124886 1.668312 0.321527 0.862927)
     )

;;; 27 prime --------------------------------------------------------------------------------
(vector 27 6.9491486549377 #r(0 1 0 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1)

     6.133994 #r(0.000000 1.619323 0.268498 0.605329 0.261788 1.741906 1.690385 1.044397 0.095253 1.526766 0.682732 1.844188 1.227922 -0.046848 0.854154 -0.053734 1.525611 0.460071 0.230079 1.191101 1.252287 1.704028 -0.029667 1.798141 1.802482 1.571525 0.379519)
     )

;;; 28 prime --------------------------------------------------------------------------------
(vector 28 7.1576952934265 #r(0 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0)

     6.190947 #r(0.000000 0.460822 1.000235 0.802902 1.169351 0.023696 1.059034 0.557253 0.339303 -0.037893 0.757652 1.745281 0.808299 1.572816 1.228654 0.154747 0.925847 0.957314 0.565556 0.484885 0.864794 1.110639 0.659146 1.596331 1.587743 0.524304 1.470688 0.086831)
     )

;;; 29 prime --------------------------------------------------------------------------------
(vector 29 7.2415904369233 #r(0 0 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0)

     6.364996 #r(0.000000 0.899299 0.027883 1.660781 0.583908 0.594226 1.394105 1.009420 -0.076432 0.063436 1.779221 1.537249 1.002516 1.590894 -0.057219 1.023692 1.515341 1.279493 0.140022 -0.035094 0.723643 0.484040 0.612756 1.373872 1.209603 1.304864 0.985337 0.845953 0.581252)
     )

;;; 30 prime --------------------------------------------------------------------------------
(vector 30 7.1189651489258 #r(0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 0)

     6.451812 #r(0.000000 1.683608 0.803658 0.933316 0.850814 1.701341 1.277986 1.473972 1.214431 1.898492 0.954836 1.784293 1.951482 1.381903 0.107238 0.105553 1.260609 1.566570 0.409971 0.385253 1.590967 0.968660 0.054889 0.914665 1.664915 1.656054 1.094096 1.343614 0.650979 0.864222)
     )

;;; 31 prime --------------------------------------------------------------------------------
(vector 31 7.4906754493713 #r(0 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 1)

     6.615976 #r(0.000000 1.619082 0.923169 1.083084 0.781957 1.611725 1.231796 1.488577 1.226090 0.083999 1.020558 1.699217 -0.014673 1.346295 -0.063182 -0.022308 1.145334 1.655017 0.305814 0.373230 1.594198 0.992544 0.008700 0.844473 1.661053 1.801356 0.850925 1.501091 0.639723 0.929876 0.176165)
     6.615530 #r(0.000000 1.619420 0.923847 1.082825 0.781141 1.610656 1.231074 1.487481 1.224879 0.083506 1.018988 1.699276 -0.015436 1.345804 -0.063558 -0.024175 1.143421 1.653947 0.304635 0.370982 1.593152 0.991610 0.007662 0.843108 1.659562 1.800094 0.848731 1.499297 0.637649 0.927864 0.174683)
     )

;;; 32 prime --------------------------------------------------------------------------------
(vector 32 7.6309351921082 #r(0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0)

     ;; 33-1
     6.772281 #r(0.000000 -0.104424 1.369006 0.833384 0.832316 0.684545 1.080484 0.996539 1.125140 0.264781 0.104162 1.034076 1.132845 0.966270 -0.147521 -0.070104 -0.108305 0.137329 0.336575 0.120508 -0.030229 1.160998 -0.149314 0.018366 1.122475 -0.088339 0.190809 0.749038 -0.017283 -0.181633 0.895249 0.011511)
     6.771875 #r(0.000000 -0.104918 1.369126 0.835707 0.832591 0.686962 1.078953 0.996442 1.123899 0.265649 0.104756 1.033734 1.127023 0.969497 -0.146560 -0.074679 -0.108563 0.138500 0.334066 0.125954 -0.029234 1.158087 -0.155039 0.017563 1.122941 -0.091297 0.191584 0.742695 -0.018956 -0.183574 0.889830 0.007141)
     )

;;; 33 prime --------------------------------------------------------------------------------
(vector 33 7.7389698028564 #r(0 1 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 1 0)

     6.846444 #r(0.000000 1.540730 1.269040 0.749184 0.961715 0.756150 0.876752 0.416027 1.022774 0.964239 1.083376 0.550495 1.494046 0.196678 0.925862 0.362000 0.602774 1.401166 0.181115 1.142230 0.264880 0.003237 0.994773 0.034504 0.433160 0.985315 1.781928 0.301442 1.605371 1.626266 0.719713 0.024414 0.683173)
     )

;;; 34 prime --------------------------------------------------------------------------------
(vector 34 7.9624452590942 #r(0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 1 0 0 0)

     6.991192 #r(0.000000 1.753519 0.200582 1.709673 0.364080 0.826783 0.339745 0.629017 1.916751 1.209744 1.171294 -1.878381 1.379347 0.682133 1.526150 -0.403398 1.590798 1.225400 1.046260 0.612397 0.683970 1.216405 0.626313 0.038228 1.289324 1.063867 0.495350 0.036835 0.806562 1.424403 1.251942 0.446062 1.562643 0.395827)
     )

;;; 35 prime --------------------------------------------------------------------------------
(vector 35 8.0019035339355 #r(0 0 1 1 0 0 0 1 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 0 0)

     7.163607 #r(0.000000 1.266503 0.439150 0.502027 -0.033212 1.025554 1.236433 1.852606 1.521580 0.894650 0.982935 1.338812 0.175216 1.929333 1.483026 0.812681 0.144350 1.543173 0.347773 0.191753 0.996456 1.584603 0.595312 0.526825 0.409349 0.179419 0.765371 0.331481 0.734526 0.534073 1.395010 0.148584 0.213643 0.199292 1.071967)
     )

;;; 36 prime --------------------------------------------------------------------------------
(vector 36 8.3031883239746 #r(0 0 0 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0)

     7.274340 #r(0.000000 0.295214 1.648256 0.584870 0.666257 0.185867 0.791897 0.205307 0.094941 1.078003 0.393529 1.106172 0.869922 0.874970 0.914168 -0.075429 0.352173 -0.206951 1.433194 0.016874 1.804925 1.769354 0.780563 1.415336 1.733698 0.569376 0.514365 1.527457 0.738716 1.585860 0.004452 0.303849 0.468887 1.200500 1.687045 -0.272506)

     ;; 34+2
     7.326328 #r(0.000000 0.224320 -0.145696 0.800619 0.068109 0.664686 1.202282 -0.026091 0.124729 1.390134 0.094406 0.787084 -0.284049 0.196932 0.011705 -0.061258 1.288162 0.209106 0.650222 0.837106 1.144479 -0.004444 -0.079317 -0.252873 1.282751 1.105461 -0.151235 -0.220044 0.048391 0.784914 0.800542 0.208916 -0.135577 0.180326 -0.083829 0.058422)

     ;; 37-1
     7.188203 #r(0.000000 1.311785 0.710177 0.919863 0.806114 1.220385 0.913244 1.649138 1.158903 -0.117650 1.420543 0.532433 1.420824 0.031354 1.130470 1.529113 0.851075 0.566610 -0.022612 1.109803 -0.179865 -0.219467 1.014788 0.671450 1.268941 0.095596 0.593655 0.518696 1.410763 0.018554 0.158212 0.022548 1.368086 1.347905 1.919434 1.204584)
     7.186926 #r(0.000000 1.311697 0.709034 0.915159 0.808357 1.216359 0.908904 1.653810 1.153635 -0.112872 1.420407 0.530751 1.421444 0.032676 1.128541 1.530326 0.851662 0.568834 -0.029131 1.109353 -0.183737 -0.219083 1.023414 0.677153 1.272442 0.088978 0.599298 0.521683 1.413826 0.024834 0.156538 0.023610 1.364547 1.354715 1.925796 1.201076)
     )

;;; 37 prime --------------------------------------------------------------------------------
(vector 37 8.4775905609131 #r(0 0 1 0 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1)

     7.291595 #r(0.000000 1.385574 1.094219 1.256844 0.579410 1.074351 0.652085 1.737017 1.132509 0.023783 1.497034 0.201580 1.618763 0.156207 1.295800 1.067404 0.684624 0.145230 1.829069 1.057901 0.013674 0.026959 0.892842 0.719241 1.431201 0.175608 0.784924 0.608541 1.031616 0.099402 0.526982 -0.079447 1.301608 1.399791 1.919478 1.303159 1.654914)
     7.291028 #r(0.000000 1.386217 1.094361 1.257532 0.577473 1.074473 0.649002 1.737811 1.130373 0.024521 1.494005 0.197512 1.617094 0.155699 1.295012 1.066519 0.684029 0.142939 1.826382 1.056446 0.014744 0.023675 0.889872 0.717012 1.430015 0.171959 0.779260 0.605221 1.025774 0.091866 0.523473 -0.085992 1.295536 1.395504 1.915353 1.295483 1.645052)
     )

;;; 38 prime --------------------------------------------------------------------------------
(vector 38 8.5527725219727 #r(0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0)

	7.395907 #r(0.000000 0.229361 1.165787 -0.110257 0.360118 0.958030 0.069946 0.724227 0.169462 0.629891 1.545997 1.736970 0.340776 1.117984 1.362890 -0.333746 0.304546 0.284267 1.101870 -0.220411 1.748591 0.492644 0.009938 0.667006 1.844837 0.974373 0.297199 0.452149 0.892727 0.659717 0.488303 1.523287 0.213584 0.164389 -0.141331 1.392379 0.641595 0.183921)
     )

;;; 39 prime --------------------------------------------------------------------------------
(vector 39 8.8173857964668 #r(0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0)

     7.452083 #r(0.000000 -0.003327 0.916189 -0.059920 1.642633 1.388547 0.951086 0.403885 -0.174730 0.969870 0.918579 1.463076 0.392796 0.310790 1.322505 1.568519 -0.013721 1.080957 1.546749 1.334291 1.196748 1.241477 0.666226 0.658367 0.483066 0.709740 0.970447 1.021587 1.015221 1.154977 1.464323 0.177481 1.236124 1.797764 1.373028 0.022625 0.381731 1.433474 1.548372)
     )

;;; 40 prime --------------------------------------------------------------------------------
(vector 40 8.9134502410889 #r(0 0 1 0 1 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1)

     ;; 39+1
     7.542973 #r(0.000000 -0.041200 1.048990 -0.088096 1.469596 1.426659 0.704430 0.532863 -0.271666 1.021284 0.854349 1.691302 0.165173 0.234052 1.293759 1.553143 -0.290199 1.111317 1.388897 1.428535 1.198923 1.295686 0.607124 0.554003 0.553080 0.829915 1.372981 1.113790 0.892248 1.036179 1.715559 0.155629 1.485519 1.734906 1.416427 0.111242 0.390867 1.435517 1.580034 0.394829)
     7.527357 #r(0.000000 -0.041087 1.082980 -0.093124 1.499791 1.383311 0.718904 0.489319 -0.257293 1.006861 0.883213 1.690326 0.205410 0.260914 1.292500 1.587749 -0.303320 1.082377 1.409161 1.434549 1.191417 1.318848 0.621381 0.567262 0.550734 0.858772 1.350282 1.126944 0.892895 1.019108 1.688302 0.184002 1.501241 1.748989 1.428674 0.055963 0.395694 1.443878 1.622997 0.400248)
     )

;;; 41 prime --------------------------------------------------------------------------------
(vector 41 9.1567583084106 #r(0 1 0 0 0 1 0 1 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0)

	;; 40 + 1
	7.720320 #r(0.000000 -0.115191 1.182807 0.023805 1.562688 1.390669 0.693038 0.384401 -0.432021 0.902901 0.808566 1.764939 0.071559 0.180956 1.306988 1.386263 -0.325917 1.184850 1.379486 1.267820 1.088531 1.531591 0.443244 0.383528 0.465953 0.767254 1.394223 1.223657 0.755343 1.085342 1.737843 0.118005 1.556067 1.593289 1.235706 0.152645 0.264917 1.446707 1.588810 0.262147 0.136941)
	7.719171 #r(0.000000 -0.110559 1.169832 0.019267 1.569538 1.391236 0.694144 0.382873 -0.434147 0.899794 0.796750 1.764903 0.072953 0.169200 1.308106 1.377558 -0.321540 1.193116 1.367694 1.264151 1.089800 1.528123 0.443624 0.385073 0.475316 0.761014 1.403127 1.224672 0.762422 1.106345 1.735876 0.113473 1.574540 1.593168 1.251644 0.163982 0.277984 1.443096 1.591883 0.269490 0.133208)
     )

;;; 42 prime --------------------------------------------------------------------------------
(vector 42 9.2193641662598 #r(0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0)

	;; 41+1
	7.869767 #r(0.000000 -0.061943 1.138293 -0.062352 1.677941 1.387789 0.696129 0.354209 -0.606277 0.820682 0.889412 1.749845 0.156626 0.153950 1.241240 1.226387 -0.243954 1.180563 1.446765 1.133383 1.088516 1.534516 0.379614 0.441871 0.531294 0.625705 1.211996 1.249505 0.811274 1.137271 1.690807 0.091208 1.719416 1.589298 1.288167 0.231299 0.255350 1.544776 1.691946 0.324682 0.145604 -0.146627)
	7.863440 #r(0.000000 0.000769 1.150871 -0.051305 1.664510 1.429789 0.722933 0.399494 -0.606818 0.831602 0.900728 1.776906 0.150722 0.134795 1.253546 1.193712 -0.262236 1.189543 1.508651 1.128437 1.157241 1.619877 0.419663 0.456760 0.533746 0.713555 1.247278 1.303816 0.804519 1.178273 1.682452 0.160111 1.739510 1.661450 1.323262 0.256316 0.252559 1.582882 1.741592 0.288988 0.170566 -0.163586)
     )

;;; 43 prime --------------------------------------------------------------------------------
(vector 43 9.4329051971436 #r(0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 1)

     ;; 44-1
     7.936372 #r(0.000000 0.547620 0.739031 1.442428 0.549512 0.577585 0.459986 1.527195 1.215306 0.359566 1.254454 1.014209 0.650822 0.596119 0.113760 0.896295 1.336762 1.511746 1.057661 0.208519 1.475881 1.168554 0.473943 0.693948 1.550424 1.853884 0.945372 1.595949 0.778275 1.634785 0.682180 0.046625 1.212650 1.360060 1.301003 1.439535 -0.124409 0.942540 0.731761 1.333209 0.714942 0.471897 0.650290)
     )

;;; 44 prime --------------------------------------------------------------------------------
(vector 44 9.6263332366943 #r(0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 1 0 1)

	;; 45-1
	8.096356 #r(0.000000 0.562197 0.780059 1.445061 0.297993 0.361779 0.450977 1.579753 1.251177 0.406295 1.140037 1.270462 0.688429 0.742666 0.310753 0.814792 1.242058 1.590925 1.239292 0.244955 1.563091 1.453652 0.466187 0.926031 1.420624 1.869915 0.975705 1.750035 0.662252 1.713066 0.628893 0.005473 1.403763 1.231668 1.313745 1.548647 0.181657 1.165934 0.757198 1.479137 0.584746 0.478571 0.777834 -0.217890)
	8.065176 #r(0.000000 0.563555 0.779322 1.450405 0.275074 0.391802 0.387823 1.577539 1.258354 0.397778 1.137367 1.281084 0.645440 0.730897 0.278341 0.818073 1.295213 1.625353 1.186058 0.165619 1.608086 1.447235 0.501075 0.919785 1.379913 1.874147 1.032912 1.672344 0.731435 1.654856 0.658603 0.012492 1.389929 1.303561 1.262036 1.561506 0.211052 1.124543 0.750294 1.584352 0.635996 0.491882 0.766257 -0.195962)
     )

;;; 45 prime --------------------------------------------------------------------------------
(vector 45 9.7923860549927 #r(0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1)

     8.156599 #r(0.000000 0.504922 0.822887 1.454973 0.213937 0.312131 0.458345 1.480849 1.269108 0.365243 1.136961 1.370780 0.828694 0.744612 0.260671 0.781252 1.246491 1.660559 1.261864 0.159271 1.560422 1.570906 0.366422 0.845904 1.468563 1.922211 0.928352 1.793476 0.526909 1.787205 0.580505 0.086715 1.290991 1.241712 1.319383 1.542592 0.148589 1.164537 0.833531 1.339389 0.578898 0.484755 0.736594 -0.242427 0.801799)
     8.154882 #r(0.000000 0.547055 0.828620 1.474483 0.214823 0.306420 0.447495 1.488329 1.261803 0.345092 1.182890 1.386590 0.858672 0.731925 0.282394 0.780789 1.264715 1.682259 1.297583 0.185487 1.597229 1.573595 0.381047 0.857783 1.470813 1.918333 0.941697 1.783877 0.578177 1.822867 0.620428 0.083071 1.307746 1.280532 1.325459 1.568372 0.174238 1.183235 0.845621 1.354666 0.647886 0.538852 0.752105 -0.233702 0.820105)
     )

;;; 46 prime --------------------------------------------------------------------------------
(vector 46 9.7220277786255 #r(0 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0)

     8.261457 #r(0.000000 0.441366 0.083292 1.447582 1.080353 0.774431 1.031820 0.396571 -0.029186 1.855247 0.017145 1.352007 1.097546 -0.117433 1.240120 0.492762 0.418188 1.012485 1.839598 0.629307 1.143304 0.248686 0.786166 1.148481 0.944111 0.160389 0.887598 1.383912 1.951363 0.089194 -0.493379 0.490615 1.318218 0.811054 1.210433 0.709880 -0.035076 1.496491 0.871523 0.967276 1.296575 1.252407 1.309942 0.517653 0.515382 1.088417)
     8.260478 #r(0.000000 0.440515 0.082713 1.448951 1.078725 0.771700 1.031434 0.396514 -0.027342 1.856363 0.018402 1.350717 1.098982 -0.118233 1.240721 0.493205 0.418152 1.012778 1.839650 0.630433 1.143338 0.246746 0.786146 1.150744 0.946120 0.158315 0.887480 1.385932 1.950117 0.090680 -0.492965 0.491998 1.315319 0.809995 1.210707 0.709458 -0.036266 1.497891 0.868872 0.966405 1.296051 1.252832 1.310296 0.520024 0.516227 1.087381)
     )

;;; 47 prime --------------------------------------------------------------------------------
(vector 47 10.0            #r(0 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 0)

     ;; 46+1
     8.268289 #r(0.000000 0.357443 0.232912 1.380147 1.115226 0.794363 1.003118 0.354162 -0.098010 1.882974 0.011731 1.431470 1.060533 -0.173886 1.243389 0.433576 0.427301 0.932883 1.964789 0.661151 1.135623 0.224910 0.703565 1.198466 0.988252 0.007869 0.877345 1.478313 1.822166 0.223930 -0.274799 0.527743 1.328214 0.957522 1.199220 0.836897 0.009700 1.499725 0.828964 0.836474 1.158394 1.390117 1.252214 0.607531 0.602372 1.108309 -0.308979)
     8.247198 #r(0.000000 0.355740 0.242039 1.389357 1.131106 0.777738 0.991848 0.374463 -0.088156 1.878905 0.017085 1.432086 1.041936 -0.151670 1.244610 0.482711 0.411519 0.932572 1.984708 0.662503 1.111503 0.232597 0.710598 1.210987 0.961984 -0.005659 0.863659 1.482536 1.845680 0.226808 -0.224546 0.479683 1.343625 0.977816 1.164714 0.894614 0.015854 1.538081 0.814650 0.817623 1.136662 1.395888 1.254222 0.623425 0.572065 1.084636 -0.341926)
     )

;;; 48 prime --------------------------------------------------------------------------------
(vector 48 10.073040962219 #r(0 0 0 1 1 1 1 1 0 1 0 0 1 1 1 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1)

     8.468727 #r(0.000000 0.332125 1.567930 1.667264 0.442332 0.427404 0.736248 1.688653 -0.012194 0.001963 0.946717 0.783117 0.528363 1.021452 0.764794 0.424311 0.975629 0.318718 -0.017782 0.452256 -0.011646 0.634442 1.620045 1.251183 1.855810 -0.212250 0.823868 1.371356 1.272442 0.687371 1.532020 1.114788 -0.144494 0.601199 1.707870 0.646890 1.378450 0.845449 0.429827 0.928104 1.365712 1.152987 1.849756 1.181620 0.737310 0.960075 0.285625 -0.264250)
     8.468134 #r(0.000000 0.334994 1.563192 1.664486 0.442532 0.427441 0.733762 1.689726 -0.011266 0.003688 0.946684 0.784545 0.529116 1.024632 0.761914 0.427223 0.972240 0.316523 -0.022749 0.454239 -0.013268 0.630760 1.620596 1.250013 1.856322 -0.212807 0.823587 1.369668 1.269762 0.685581 1.533564 1.112823 -0.144562 0.600770 1.707468 0.649243 1.377651 0.846771 0.426248 0.926088 1.367077 1.152360 1.849396 1.177150 0.734262 0.957954 0.284186 -0.267591)
     )

;;; 49 prime --------------------------------------------------------------------------------
(vector 49 10.209 #r(0 1 1 0 0 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 0)

     ;; 51-2
     8.582839 #r(0.000000 1.015072 1.263701 0.053109 -0.198567 -0.119876 -0.074305 0.688310 -0.022609 -0.056918 -0.335561 1.264545 0.175435 0.115160 0.045329 0.044221 0.357377 1.286502 1.011774 0.136492 0.790313 1.216480 1.412877 1.287840 -0.457032 1.185491 0.632250 1.022556 0.092623 0.762340 0.282587 1.173246 0.884457 -0.232556 1.275664 0.026771 1.001804 1.127230 -0.112893 0.390785 1.060560 -0.011579 0.935318 0.798092 1.155912 -0.045270 0.311662 -0.007451 -0.291556)
     )

;;; 50 prime --------------------------------------------------------------------------------
(vector 50 10.402973175049 #r(0 0 1 0 0 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1)

     8.676090 #r(0.000000 1.487746 1.059441 1.025372 1.327289 1.088034 0.562677 1.658212 1.275003 1.216651 1.253782 1.464671 0.843363 1.799547 0.053937 0.685289 -0.108899 0.042484 1.103905 1.939714 1.165290 1.002239 0.949057 0.182130 0.764686 0.473808 0.974801 0.114296 0.831687 0.096978 1.328258 1.232106 1.944542 0.907302 0.451517 -0.196659 0.834303 1.063413 0.149435 1.600622 0.877347 1.358710 0.921698 1.475066 0.048402 1.601242 0.635073 1.286124 0.058142 1.221762)
     8.675945 #r(0.000000 1.487738 1.059001 1.025159 1.326266 1.088841 0.562097 1.657096 1.275489 1.216835 1.254334 1.464943 0.843263 1.800742 0.055052 0.684906 -0.108959 0.041753 1.103420 1.939373 1.165276 1.002506 0.948093 0.181706 0.765909 0.473183 0.975672 0.113670 0.830920 0.097015 1.328852 1.230698 1.944548 0.905867 0.451107 -0.197043 0.836092 1.063417 0.149456 1.602251 0.877744 1.357979 0.922281 1.474686 0.047418 1.602488 0.635135 1.284876 0.058592 1.221991)
     )

;;; 51 prime --------------------------------------------------------------------------------
(vector 51 10.5841327092253 #r(0 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1)

     8.652946 #r(0.000000 0.552138 1.581370 0.856634 0.465868 0.045489 1.205822 1.403218 0.756158 -0.011738 -0.321071 1.578958 0.777145 -0.086815 1.971735 0.371739 1.194751 0.827647 1.040995 0.971514 -0.103101 0.019110 0.372121 0.808088 0.569420 0.781614 0.253334 1.524564 0.516258 0.490039 0.356392 1.792991 0.344408 0.177045 1.267803 0.433404 0.355268 0.458783 0.927023 0.366207 1.155001 1.183690 0.095395 1.563819 1.892864 1.168287 1.234142 0.740278 0.190550 0.004346 0.616333)
     8.651647 #r(0.000000 0.556638 1.587356 0.852726 0.469643 0.042055 1.208512 1.399736 0.760751 -0.012268 -0.323685 1.582069 0.778343 -0.079378 1.972223 0.369847 1.192503 0.823552 1.044143 0.973458 -0.110183 0.024158 0.377921 0.805953 0.568593 0.790820 0.251813 1.523516 0.522377 0.493450 0.360345 1.793822 0.342779 0.174655 1.264727 0.440710 0.362796 0.457837 0.932721 0.365495 1.158324 1.184201 0.095227 1.560717 1.899717 1.167635 1.237541 0.747136 0.193982 0.005527 0.619867)
     )

;;; 52 prime --------------------------------------------------------------------------------
(vector 52 10.64324760437 #r(0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0)

     8.817479 #r(0.000000 0.192798 -0.100823 0.105700 1.730433 1.638226 1.781516 0.446103 1.408775 0.715209 0.415865 -0.245030 1.066219 1.674348 0.092550 0.243790 1.271420 0.492458 1.433072 -0.090924 1.409056 0.418163 -0.043783 1.528262 0.043370 1.470310 -0.026080 0.499433 0.961527 0.302716 0.768317 0.686930 1.132134 1.628592 0.701543 1.788137 -0.034028 1.911798 1.160323 1.534119 1.837005 0.994515 0.926867 1.263245 0.147467 1.441753 0.596623 1.430563 0.749640 0.874777 1.097276 0.882051)
     )

;;; 53 prime --------------------------------------------------------------------------------
(vector 53 10.678050692694 #r(0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 1 1 1 0)

     8.953081 #r(0.000000 0.788009 1.225451 0.347894 0.336100 0.208645 0.898104 1.918038 1.003547 1.827170 1.665391 0.306753 1.689654 -0.198226 0.387896 0.060438 0.532055 0.677523 0.983575 1.778621 1.222864 0.337168 0.648048 -0.059018 1.548622 0.344050 1.142170 1.624821 1.518580 1.046929 0.925606 0.370284 1.876402 0.554168 0.470781 0.776401 0.841340 0.579159 -0.039732 0.259208 1.047217 1.262845 0.826737 1.840523 0.361249 1.360958 0.974324 0.708988 1.467968 0.681409 0.951917 1.111614 0.104759)
     8.948229 #r(0.000000 0.787671 1.214299 0.345505 0.345590 0.190835 0.899719 1.924062 1.005486 1.819127 1.667353 0.313283 1.676358 -0.196379 0.370203 0.063166 0.527189 0.665913 0.973996 1.778624 1.196159 0.320936 0.633606 -0.058826 1.545537 0.333346 1.131604 1.624560 1.499303 1.035205 0.913874 0.357831 1.867167 0.548213 0.451795 0.773618 0.822115 0.562194 -0.064080 0.250241 1.035409 1.249220 0.799272 1.817083 0.333133 1.343883 0.955871 0.688843 1.459698 0.659209 0.918731 1.093360 0.071038)
     )

;;; 54 prime --------------------------------------------------------------------------------
(vector 54 10.582709312439 #r(0 0 1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1)

     ;; 53+1:
     8.998093 #r(0.000000 0.833931 1.255875 0.472195 0.500550 0.340958 0.889757 0.121823 0.999320 0.070168 1.822021 0.295115 1.599399 -0.278061 0.379867 0.053981 0.523149 0.552145 1.083746 1.542483 1.125023 0.280437 0.929583 0.145648 1.540352 0.570681 1.206535 1.391546 1.500834 1.280825 0.880416 0.297287 1.694488 0.607699 0.578077 0.733733 1.017737 0.538903 -0.079031 0.194742 1.159273 1.400820 0.893900 1.836755 0.359898 1.011475 0.991536 0.601097 1.637805 0.711833 1.160027 0.904915 0.240256 -0.100113)
     8.995507 #r(0.000000 0.839135 1.254099 0.463483 0.514525 0.350912 0.899447 0.126295 0.986278 0.081710 1.819693 0.302485 1.593021 -0.282752 0.380427 0.052239 0.519444 0.556490 1.080868 1.545771 1.120954 0.293847 0.936235 0.147086 1.535291 0.575895 1.214419 1.380708 1.495242 1.280520 0.877830 0.287337 1.699747 0.613667 0.574556 0.740251 1.006199 0.542800 -0.075818 0.193623 1.165170 1.401348 0.898072 1.831420 0.345266 1.018036 0.991280 0.598983 1.655723 0.693822 1.150649 0.904779 0.247656 -0.082849)
     )

;;; 55 prime --------------------------------------------------------------------------------
(vector 55 10.806410031758 #r(0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0)

     9.146479 #r(0.000000 0.967563 0.927691 -0.360864 0.609958 0.765470 0.915027 1.392793 0.614248 0.953214 1.344500 -0.018857 0.737576 1.736931 1.631618 1.349440 1.307993 0.206073 1.281714 1.103145 0.628925 0.887703 0.370354 -0.354414 1.471798 1.220261 -1.840190 0.459998 0.319058 1.569823 -0.402409 1.289240 1.207248 1.401276 1.334659 0.647076 0.124770 0.659947 1.220235 0.570854 1.506684 0.326123 0.300730 0.226766 1.668245 0.069090 1.091084 1.792555 0.448614 1.706735 1.552724 -0.117313 1.845004 0.249242 0.002966)
     9.142966 #r(0.000000 0.967967 0.932119 -0.365688 0.605957 0.768411 0.916284 1.389357 0.615451 0.948447 1.347949 -0.020883 0.740497 1.738244 1.630415 1.355535 1.302800 0.208142 1.280645 1.101851 0.623974 0.888122 0.368490 -0.355015 1.472177 1.224855 -1.834858 0.458535 0.318212 1.572912 -0.403676 1.290151 1.207553 1.396897 1.328635 0.637492 0.123034 0.656353 1.219027 0.568146 1.509385 0.321881 0.299954 0.224712 1.667006 0.065718 1.090053 1.794304 0.447059 1.706061 1.555246 -0.117663 1.847453 0.249418 0.005444)
     )

;;; 56 prime --------------------------------------------------------------------------------
(vector 56 10.976176261902 #r(0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1)

	; 55+1
	9.213442 #r(0.000000 0.950801 0.904714 -0.508703 0.661009 0.831586 0.884308 1.497773 0.634206 0.800998 1.332469 0.044201 0.725326 1.681333 1.804312 1.427989 1.278065 0.225748 1.222051 1.044010 0.570030 1.029930 0.330187 -0.354523 1.385937 1.248658 -1.994529 0.420806 0.301325 1.707662 -0.449043 1.164884 1.219283 1.466837 1.371490 0.636485 0.172055 0.643834 1.272809 0.563267 1.543526 0.353044 0.368529 0.213972 1.758208 0.147525 1.155503 1.739729 0.512727 1.742754 1.612106 -0.186498 1.717200 0.213592 0.028127 -0.105694)
	9.111752 #r(0.000000 1.026221 0.818731 -0.610671 0.641008 0.771905 0.862753 1.439699 0.748472 0.833370 1.358412 0.135868 0.775219 1.661446 1.803820 1.421172 1.314079 0.319408 1.356828 1.160309 0.509330 0.960224 0.392092 -0.392072 1.394882 1.222461 -0.085405 0.430754 0.230356 1.841682 -0.419967 1.090454 1.277759 1.613601 1.335900 0.582820 0.127798 0.624304 1.290684 0.637216 1.522455 0.377024 0.425050 0.197535 1.787765 0.141260 1.140648 1.868949 0.494561 1.671471 1.615285 -0.069002 1.824079 0.328533 -0.037887 -0.113326)
     )

;;; 57 prime --------------------------------------------------------------------------------
(vector 57 11.247724533081 #r(0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1)

	;; 56+1
	9.246042 #r(0.000000 1.068254 0.912344 -0.579409 0.699964 0.833848 0.899690 1.280880 0.729555 0.772814 1.165620 0.113563 0.958418 1.776654 1.746943 1.402708 1.254651 0.244552 1.303164 0.938450 0.572896 0.902407 0.419733 -0.424031 1.525432 1.318732 -1.856680 0.294120 0.271355 1.825185 -0.454382 1.066744 1.206377 1.513453 1.348624 0.487546 0.090590 0.574392 1.204512 0.396962 1.588976 0.339722 0.399778 0.196224 1.725471 0.086935 1.086444 1.835851 0.439978 1.611137 1.567240 -0.063335 1.719558 0.447194 0.045334 -0.250234 0.164616)
	9.216795 #r(0.000000 1.072761 0.871199 -0.606073 0.764898 0.818155 0.856948 1.266251 0.788121 0.752453 1.187859 0.151465 0.915565 1.748861 1.701837 1.347840 1.287842 0.215117 1.354195 0.928170 0.565855 0.863918 0.440092 -0.495226 1.605042 1.291620 -1.894193 0.283411 0.299633 1.865832 -0.437707 1.008848 1.124017 1.503496 1.376197 0.470803 0.020499 0.556017 1.215134 0.396497 1.579026 0.315841 0.419729 0.134341 1.733012 0.052783 1.070736 1.848233 0.408553 1.555037 1.556946 0.013508 1.738431 0.466962 -0.002830 -0.264635 0.171355)
     )

;;; 58 prime --------------------------------------------------------------------------------
(vector 58 11.261419321863 #r(0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1)

     ;; 57+1
	9.428825 #r(0.000000 1.018908 0.901444 -0.615819 0.860485 0.681403 0.932140 1.367257 0.748226 0.856986 1.087905 -0.048047 0.777707 1.778584 1.735112 1.472731 1.253932 0.300987 1.373471 0.844264 0.566375 0.847406 0.280264 -0.528105 1.424599 1.371262 -0.084608 0.304532 0.358385 1.652997 -0.476953 1.150522 1.226908 1.441019 1.199333 0.513348 0.039957 0.545771 1.150857 0.473094 1.508935 0.466022 0.322870 0.315957 1.725788 0.047786 1.078150 1.717254 0.429354 1.592876 1.500586 -0.142982 1.851065 0.442979 -0.034671 -0.282154 0.042441 0.094078)
	9.425110 #r(0.000000 1.014642 0.897681 -0.614752 0.857488 0.672358 0.933264 1.368100 0.738356 0.851112 1.091971 -0.046416 0.783945 1.771194 1.742854 1.472547 1.252201 0.294865 1.370781 0.846564 0.564021 0.837110 0.293848 -0.524970 1.413989 1.388993 -0.083061 0.313273 0.349050 1.659880 -0.480731 1.156810 1.222406 1.439052 1.206808 0.511500 0.038734 0.548247 1.157825 0.466797 1.504635 0.461147 0.331822 0.307462 1.725368 0.053845 1.085006 1.721043 0.438415 1.587368 1.505023 -0.148334 1.858057 0.439342 -0.041501 -0.290056 0.032928 0.094227)
     )

;;; 59 prime --------------------------------------------------------------------------------
(vector 59 11.34253692627 #r(0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1)

     9.424456 #r(0.000000 0.987831 1.263819 0.296674 0.942023 0.441708 0.159032 1.836629 0.018568 -0.056141 1.409550 -0.045051 1.184001 1.106575 0.859402 0.865929 1.344330 -0.022715 1.852739 1.494636 -0.146236 1.538496 0.317717 1.985293 0.734507 0.982797 0.398619 1.595615 1.945403 0.701589 1.197367 1.012887 0.543978 1.174908 1.430788 -0.128888 0.147545 0.984537 1.324816 1.549298 0.656696 -0.006636 1.201874 1.148588 0.795564 1.108773 1.687645 0.571018 0.266043 1.954157 1.006840 0.084613 0.524554 1.761460 0.208641 0.094850 0.141845 0.437731 0.909728)
     9.417799 #r(0.000000 0.989030 1.275806 0.299889 0.939823 0.448310 0.148809 1.843192 0.023356 -0.063408 1.405105 -0.049862 1.187648 1.091982 0.853309 0.863106 1.359373 -0.018851 1.860938 1.494969 -0.151810 1.541448 0.318470 1.997712 0.738388 0.967399 0.394475 1.599906 1.940413 0.688306 1.198223 1.027861 0.543845 1.170045 1.435957 -0.128548 0.141886 0.974484 1.320679 1.553379 0.657280 -0.006776 1.188506 1.153960 0.797906 1.107872 1.697661 0.579656 0.259938 1.959400 0.997474 0.078631 0.520560 1.756406 0.198078 0.082904 0.134773 0.431815 0.919925)
     )

;;; 60 prime --------------------------------------------------------------------------------
(vector 60 11.512454032898 #r(0 0 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0)

     ;; 59+1
     9.567932 #r(0.000000 0.987181 1.155730 0.332214 0.959672 0.422609 0.139164 1.858170 1.971933 -0.085625 1.367690 0.092445 1.162248 1.070252 0.880093 0.923540 1.286688 -0.075166 1.802993 1.583654 -0.058064 1.544851 0.459865 -0.017801 0.622918 1.081434 0.420245 1.717169 1.954432 0.771937 1.209324 0.923890 0.475411 1.176878 1.472899 -0.165713 0.114758 1.012016 1.333064 1.459949 0.672973 0.014198 1.279333 1.152000 0.797283 1.103957 1.630723 0.491103 0.146670 1.964833 1.081703 0.052456 0.483259 1.761154 0.245675 0.138222 0.019396 0.460673 0.907223 -0.053470)
     9.529131 #r(0.000000 0.993590 1.164157 0.290844 1.042801 0.369324 0.080143 1.893493 1.949205 -0.095560 1.325881 0.157042 1.109339 1.086368 0.905155 0.977024 1.260686 -0.016062 1.828182 1.614075 -0.014518 1.545044 0.439925 -0.081486 0.578895 1.179965 0.427010 1.706349 0.024219 0.749847 1.267270 0.839364 0.455231 1.246595 1.494210 -0.158936 0.112811 1.066790 1.292394 1.447816 0.800830 0.073649 1.261763 1.207061 0.771891 1.108173 1.623292 0.487925 0.232144 1.880207 1.080714 0.089063 0.391169 1.784626 0.272458 0.159146 -0.056599 0.452568 0.943658 -0.111770)
     )

;;; 61 prime --------------------------------------------------------------------------------
(vector 61 11.850807189941 #r(0 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1)

     ;; 60+1
     9.674304 #r(0.000000 0.942988 1.185184 0.401228 0.922656 0.384439 0.124613 1.797598 1.871679 -0.085568 1.287716 0.127521 1.211990 1.110404 1.018269 0.906936 1.241998 -0.006224 1.802916 1.625042 -0.136580 1.655334 0.507522 0.019978 0.578715 1.045428 0.440588 1.674467 1.983824 0.788229 1.261730 0.967897 0.387538 1.232060 1.526658 -0.187478 0.170755 1.104323 1.383734 1.532583 0.668063 0.082609 1.255511 1.174792 0.795177 1.135630 1.640793 0.324749 0.311806 1.930005 1.005470 -0.027359 0.440238 1.824355 0.182093 -0.005304 0.026835 0.470199 0.945827 0.102044 -0.110982)
     9.597113 #r(0.000000 0.971231 1.304763 0.348110 1.067056 0.387911 0.081123 1.853366 1.983392 -0.039753 1.223396 0.179283 1.164777 1.154984 0.937227 0.823520 1.227844 0.034480 1.818337 1.655061 -0.098774 1.660591 0.459686 -0.048010 0.694006 1.048441 0.467529 1.454975 0.016059 0.770137 1.418302 0.858801 0.431966 1.226715 1.621523 -0.240963 0.187668 1.281591 1.385352 1.562607 0.731351 0.081273 1.114425 1.175335 0.798504 1.208038 1.525646 0.402825 0.416766 1.868720 1.058943 -0.114172 0.285787 1.878637 0.307505 0.055166 0.065670 0.529996 1.046895 0.078416 0.000029)
     )

;;; 62 prime --------------------------------------------------------------------------------
(vector 62 11.709966659546 #r(0 0 0 0 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 0 1 0)

     ;; 63-1
	9.733736 #r(0.000000 -0.139952 0.119957 0.369616 1.566294 0.358962 1.150575 0.658899 1.145823 0.565498 0.818035 -0.078756 0.339361 0.036853 -0.081445 1.284492 0.104736 1.510521 0.937147 0.788271 1.526814 1.396514 1.280490 1.469510 1.789649 0.285213 0.650226 0.881585 0.728974 1.810762 -0.044930 1.659215 0.713447 0.623929 1.496774 0.951425 0.357075 1.369241 1.674041 0.637986 0.902200 0.722908 0.299878 -0.044061 0.733643 0.407073 1.473577 0.408899 -0.199740 0.425185 0.345580 1.674452 0.584665 1.350356 0.031128 1.247150 0.256688 0.635884 0.503839 0.135030 0.263417 1.006656)
	9.696963 #r(0.000000 -0.126832 0.087192 0.382393 1.557355 0.387687 1.189270 0.660922 1.155295 0.559376 0.807863 -0.103042 0.340858 0.062386 -0.104919 1.226211 0.078110 1.498681 0.933245 0.790005 1.495720 1.419833 1.320095 1.468182 1.807395 0.292395 0.644975 0.868706 0.736750 1.862687 0.041507 1.640983 0.682467 0.630402 1.510321 0.943895 0.394562 1.366941 1.708129 0.624670 0.880953 0.745775 0.285877 -0.038411 0.735668 0.390581 1.472054 0.430218 -0.178134 0.395802 0.288189 1.693314 0.570204 1.312470 0.015755 1.262523 0.253116 0.659738 0.530772 0.136895 0.299742 1.054296)
     )

;;; 63 prime --------------------------------------------------------------------------------
(vector 63 11.975765228271 #r(0 0 0 1 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0)

     9.712956 #r(0.000000 -0.211512 0.128156 0.205336 1.631792 0.223993 1.120077 0.677974 1.189520 0.635587 0.786994 -0.140042 0.270508 0.031528 -0.026718 1.271754 0.161836 1.519308 0.919403 0.725190 1.656604 1.430895 1.216006 1.507263 1.740613 0.380045 0.740422 0.860394 0.644699 1.785241 -0.063336 1.757196 0.670969 0.631113 1.432730 0.929994 0.449373 1.355893 1.665671 0.697673 0.900343 0.706516 0.261640 0.022846 0.779166 0.410962 1.451999 0.372853 -0.213671 0.428231 0.418722 1.770544 0.502738 1.423557 0.029160 1.322724 0.247556 0.608992 0.392989 0.101597 0.240746 1.015503 0.321046)
     9.693247 #r(0.000000 -0.214108 0.131421 0.202301 1.638942 0.220854 1.110715 0.697059 1.206875 0.663993 0.745920 -0.122836 0.272685 -0.017037 -0.046871 1.270138 0.138706 1.510472 0.884803 0.722898 1.649368 1.432030 1.208395 1.495491 1.756739 0.407459 0.750264 0.893441 0.644649 1.806450 -0.086753 1.774024 0.679919 0.602645 1.428125 0.942638 0.441081 1.332580 1.671327 0.694821 0.867415 0.710167 0.279926 0.033959 0.788479 0.389797 1.452066 0.352545 -0.215836 0.435427 0.411560 1.777773 0.495583 1.413317 0.048036 1.325135 0.239570 0.625882 0.381467 0.091137 0.245018 1.010220 0.326741)
     )

;;; 64 prime --------------------------------------------------------------------------------
(vector 64 11.932915769505 #r(0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1)

     9.911897 #r(0.000000 -0.176519 0.277243 1.457679 0.409823 0.492128 1.258703 0.953828 0.451970 -0.035755 1.413815 0.576790 1.007663 1.557197 0.406393 0.901721 0.935399 0.344434 0.058666 -0.004874 0.033568 0.266354 0.964058 1.260921 0.110946 0.586184 1.551133 0.560107 1.655832 1.431146 0.094791 0.726936 0.404173 1.258539 0.363860 0.287498 0.704556 1.358694 0.848351 1.352219 1.358382 1.634548 0.646434 0.536511 1.151363 1.507902 0.370229 -0.111562 0.018845 1.351430 0.613337 0.524145 0.030867 1.602701 0.958191 0.774983 0.900142 1.319974 1.665985 0.954409 0.571244 0.683517 0.257283 0.560359)
     9.904870 #r(0.000000 -0.164225 0.273975 1.461444 0.422513 0.492395 1.248622 0.971394 0.458132 -0.046445 1.414427 0.584229 0.967141 1.558509 0.394722 0.903497 0.940076 0.324113 0.053268 -0.024522 0.041062 0.281887 0.962890 1.227975 0.135414 0.598845 1.556506 0.526124 1.661213 1.420935 0.090290 0.679152 0.391769 1.289421 0.343796 0.304279 0.680212 1.322656 0.808370 1.338618 1.350277 1.651671 0.649112 0.545474 1.151919 1.505597 0.322896 -0.128068 -0.000209 1.363363 0.627954 0.514237 0.047970 1.605733 0.945254 0.790625 0.898519 1.323254 1.650334 0.927509 0.574149 0.657507 0.234406 0.524987)
     )

;;; 65 prime --------------------------------------------------------------------------------
(vector 65 12.264873504639 #r(0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 1 1 1 0 1 0)

	;; 64+1
	10.041913 #r(0.000000 -0.231597 0.347996 1.329229 0.210946 0.358775 1.318136 0.940959 0.423445 -0.059602 1.487652 0.528102 0.959962 1.627507 0.242008 0.890416 1.013953 0.381481 0.048421 0.000955 0.073351 0.222260 0.956448 1.250606 0.032874 0.581396 1.552144 0.533024 1.803356 1.588620 0.155988 0.709145 0.416103 1.098822 0.371144 0.488313 0.641224 1.409761 0.769076 1.378012 1.338517 1.672969 0.693576 0.622573 1.111879 1.498797 0.384021 -0.285902 0.098531 1.294593 0.540682 0.514444 0.031708 1.544980 0.882941 0.833995 0.886145 1.471130 1.590019 0.959450 0.407950 0.787696 0.104075 0.545846 0.096608)
	10.031321 #r(0.000000 -0.272551 0.376749 1.333244 0.218725 0.345977 1.314485 0.982213 0.427625 -0.065599 1.515427 0.508158 0.913799 1.657763 0.172645 0.893548 1.045679 0.355730 0.027581 0.041761 0.082561 0.209873 0.920555 1.285192 0.041833 0.572322 1.559879 0.525050 1.767677 1.615275 0.160499 0.644324 0.441443 1.110153 0.327368 0.527348 0.566684 1.364227 0.733403 1.384463 1.363114 1.623118 0.669559 0.652798 1.037660 1.423834 0.345719 -0.269580 0.049255 1.244435 0.520436 0.525551 0.012583 1.505200 0.886496 0.816798 0.876113 1.467201 1.600992 0.961581 0.410364 0.759664 0.138406 0.484445 0.049688)
     )

;;; 66 prime --------------------------------------------------------------------------------
(vector 66 12.090668678284 #r(0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0)

     10.065843 #r(0.000000 -0.332278 0.420111 1.296912 0.003400 0.570050 1.383101 1.228319 0.329402 0.002928 0.332461 0.786693 1.331535 0.237292 1.020996 0.126259 1.613105 1.241426 -0.367526 0.057745 0.063068 1.144890 0.058649 0.546763 0.792290 0.527577 1.597907 0.336733 0.558202 0.349266 0.412838 -0.066236 0.132007 1.032081 0.645360 0.084627 0.218015 0.961024 1.464682 1.216442 1.186753 0.039444 1.139907 1.145545 1.026317 1.617341 0.492061 1.804706 -0.218027 0.872723 0.567401 1.745335 1.259266 0.682677 1.100993 1.200392 1.089304 0.237539 0.552581 0.047166 0.743492 0.228597 1.363708 0.915715 -0.032741 0.312099)
     10.040611 #r(0.000000 -0.405880 0.403815 1.296291 -0.023571 0.665033 1.385081 1.219553 0.309245 0.020606 0.300153 0.822670 1.338967 0.273696 1.044177 0.099862 1.487075 1.221027 -0.344403 -0.045799 0.094066 1.108269 0.044014 0.617491 0.852992 0.558738 1.622399 0.310181 0.588841 0.323443 0.414056 -0.129711 0.220239 1.055039 0.615124 0.167536 0.224686 1.003767 1.449721 1.185187 1.215242 0.034353 1.113707 1.123233 1.095536 1.625500 0.489513 1.839019 -0.309733 0.833070 0.569096 1.721184 1.298143 0.637885 1.087460 1.191842 1.159182 0.195251 0.633434 0.099181 0.758141 0.218475 1.417590 0.992859 -0.046035 0.285532)
     )

;;; 67 prime --------------------------------------------------------------------------------
(vector 67 12.20425496356 #r(0 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1)

	;; 66+1
	10.270103 #r(0.000000 -0.339086 0.529826 1.196633 0.017211 0.503338 1.254976 1.117868 0.397424 -0.207937 0.422035 0.795324 1.396533 0.167749 1.073809 0.015795 1.618310 1.175144 -0.342555 0.080333 0.003741 1.084430 -0.010093 0.560025 0.867130 0.369945 1.456200 0.444129 0.652644 0.167650 0.320656 -0.145242 0.307342 1.062944 0.883767 0.299612 0.277397 1.030332 1.417097 1.462867 1.323580 0.189769 1.089141 0.993348 0.915509 1.413244 0.654039 1.674522 -0.169566 0.974872 0.769627 1.866694 1.124536 0.783559 1.039716 1.307670 1.055658 0.169272 0.711344 0.060085 0.731555 0.347823 1.529167 0.605251 0.021941 0.493045 -0.306702)
	10.265959 #r(0.000000 -0.317437 0.528596 1.208530 0.019668 0.509206 1.284064 1.148532 0.419242 -0.198735 0.425155 0.767445 1.408450 0.160053 1.092975 0.032386 1.619472 1.183809 -0.361482 0.071106 0.009871 1.093315 0.027109 0.560654 0.879407 0.374417 1.487442 0.453563 0.647125 0.176974 0.322367 -0.143328 0.282015 1.077805 0.896816 0.316444 0.296705 1.010969 1.434391 1.469703 1.337586 0.187007 1.082850 1.009796 0.918602 1.416386 0.666312 1.700486 -0.149081 0.977019 0.786356 1.876858 1.104648 0.776752 1.040755 1.317706 1.081692 0.200422 0.704910 0.071311 0.744990 0.367563 1.551133 0.626292 0.053508 0.492611 -0.327592)
     )

;;; 68 prime --------------------------------------------------------------------------------
(vector 68 12.466281890869 #r(0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 0 1)

     ;; 69-1:
	10.294332 #r(0.000000 1.774482 1.200978 1.227268 1.382220 0.282793 1.553903 1.732456 0.753211 0.760153 1.851640 1.366776 1.204200 0.843725 0.253043 0.277483 0.103836 -0.065448 1.410455 0.651921 1.994318 0.062621 0.954681 0.275021 0.597686 1.119852 0.016268 -0.163905 1.984242 1.567894 0.922417 -0.007109 1.063508 1.828059 0.334844 1.052665 1.253633 1.262611 1.579598 0.998618 1.505098 1.876188 0.866523 -0.096826 0.810066 0.678537 0.661302 -0.487197 0.199269 0.661440 1.362169 1.024823 0.238200 0.872311 1.253153 1.455210 0.266625 1.222868 1.015892 1.101616 1.115849 0.596998 1.881890 -0.207678 1.082090 0.165311 1.300155 1.153433)
	10.261600 #r(0.000000 1.771081 1.184318 1.217409 1.329949 0.267230 1.509883 1.778448 0.681595 0.738174 1.861103 1.336495 1.215872 0.818117 0.255500 0.299960 0.113725 -0.077146 1.405250 0.666595 0.037892 0.067257 0.915472 0.235386 0.607945 1.117038 0.060775 -0.156333 1.956471 1.527902 0.871638 -0.006865 1.033595 1.874143 0.354606 1.054570 1.217089 1.263859 1.531522 0.948658 1.506335 1.858536 0.864867 -0.107940 0.824426 0.664413 0.614081 -0.522301 0.170031 0.618192 1.363753 1.018532 0.255610 0.918599 1.224294 1.455436 0.286646 1.200372 1.019211 1.039060 1.103305 0.582967 1.867745 -0.265217 1.084430 0.130212 1.269409 1.132275)
     )

;;; 69 prime --------------------------------------------------------------------------------
(vector 69 12.29846572876 #r(0 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0)

     10.373386 #r(0.000000 1.755739 1.344798 1.270777 1.245975 0.212147 1.637341 1.674637 0.780881 0.678256 0.020823 1.453992 1.251154 0.906274 0.263210 0.219658 0.201277 -0.006107 1.482279 0.690309 1.943780 0.107940 0.891912 0.210217 0.501788 1.062586 1.748465 -0.256216 1.793890 1.653062 0.760504 1.930618 1.125386 1.733012 0.392253 1.017032 1.329369 1.438951 1.614342 0.946373 1.511397 1.735151 0.924137 -0.243047 0.908372 0.619579 0.722525 -0.263766 0.070586 0.505534 1.390127 1.112173 0.360123 0.888486 1.115007 1.574719 0.192671 1.168644 1.072297 1.024494 1.027776 0.495929 1.728234 0.030466 1.010825 0.303774 1.356890 1.301979 0.677665)
     10.358295 #r(0.000000 1.762304 1.329967 1.274727 1.243024 0.209299 1.634178 1.655523 0.780487 0.675373 0.009379 1.466876 1.260691 0.892375 0.253485 0.204944 0.184632 -0.020054 1.479361 0.680774 1.947746 0.085018 0.887454 0.202001 0.508666 1.061812 1.760817 -0.258898 1.789067 1.670818 0.746822 1.923843 1.147917 1.717791 0.387724 1.021038 1.318304 1.434180 1.603007 0.933831 1.516314 1.736887 0.932240 -0.250999 0.908525 0.598332 0.699524 -0.251071 0.060976 0.494007 1.385962 1.112068 0.358110 0.879637 1.108400 1.579544 0.192858 1.157165 1.062829 1.022502 1.013651 0.487217 1.715356 0.029780 1.002970 0.289498 1.337863 1.300987 0.690487)
     )

;;; 70 prime --------------------------------------------------------------------------------
(vector 70 12.665026664734 #r(0 1 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 0 0)

     10.403198 #r(0.000000 0.659269 0.149246 -0.229331 0.464031 1.037303 0.297808 1.605092 1.041553 1.638786 0.968456 1.081487 0.986031 0.766531 0.645236 0.176746 0.062926 0.650627 0.887571 0.432390 0.968052 1.660369 1.053082 0.034606 1.910731 1.746043 1.683430 0.821251 1.040772 1.932221 1.382437 0.501614 -0.111054 0.532350 0.190557 0.045053 1.319570 -0.066664 0.486188 1.777508 1.395223 0.491473 0.176001 0.623855 1.347864 1.207736 1.451417 1.558733 1.414717 1.920228 0.418857 1.530616 0.099510 0.214659 0.967449 -0.145006 1.519241 0.691963 1.366826 0.718889 0.337519 0.685633 1.635424 0.816319 0.060380 1.097292 0.149441 0.900329 0.876399 0.145344)
     10.362146 #r(0.000000 0.645075 0.144761 -0.255891 0.476895 1.023278 0.226232 1.569382 1.010047 1.598756 1.002276 1.069510 0.991228 0.875395 0.620600 0.146676 0.001456 0.640256 0.920988 0.405395 0.929569 1.637203 1.048641 -0.005834 1.951040 1.773501 1.763294 0.813650 1.073299 1.971995 1.378517 0.509283 -0.138231 0.486487 0.186594 0.024921 1.361733 -0.054931 0.452684 1.768706 1.403207 0.493486 0.160262 0.623486 1.333422 1.171179 1.417368 1.493662 1.431973 1.962729 0.473768 1.578443 0.146983 0.257457 0.922711 -0.127966 1.530877 0.689093 1.402346 0.698388 0.371420 0.673779 1.623279 0.869055 0.060960 1.114977 0.136968 0.887721 0.930015 0.191902)
     )

;;; 71 prime --------------------------------------------------------------------------------
(vector 71 12.609085083008 #r(0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 0)

     10.523064 #r(0.000000 0.688011 0.968837 0.940634 1.605222 0.888784 0.799658 0.986589 0.551066 0.615309 0.653186 0.893971 1.635005 0.515944 0.737309 0.499869 0.965484 1.166543 1.233403 1.277963 0.357632 0.184373 0.829321 0.533549 0.654127 1.345320 0.132782 0.366320 0.049851 1.315507 0.714178 1.332359 1.090257 0.069099 0.561445 1.760121 1.667327 0.986854 0.112329 0.614048 1.104774 0.212197 1.392955 0.553988 0.863015 1.668891 1.231650 0.232935 1.786061 0.865166 0.966113 0.257005 0.993747 -0.000704 1.235807 0.060112 1.258818 1.073792 0.276968 0.278092 1.838200 0.920318 1.799026 1.603861 0.357301 0.246709 0.264914 0.955910 0.731514 1.325161 1.347000)
     10.407485 #r(0.000000 0.658867 0.945182 1.008506 1.648242 0.849410 0.789076 0.860371 0.625610 0.678091 0.677156 0.952896 1.661882 0.468446 0.648245 0.553746 1.164588 1.217555 1.304818 1.253766 0.415819 0.177362 0.870813 0.537584 0.684099 1.231697 0.205944 0.313681 0.033795 1.304229 0.634137 1.288505 1.050312 0.068587 0.578801 1.748737 1.670966 0.963745 0.157496 0.747319 1.117879 0.224088 1.431805 0.565143 0.847971 1.619314 1.299282 0.286944 1.729721 0.792086 0.957060 0.103543 1.002065 0.024409 1.327043 0.059946 1.189105 1.073824 0.296154 0.377112 1.822909 0.902196 1.929038 1.562848 0.385236 0.148366 0.174788 0.969726 0.746509 1.400690 1.282292)
     )

;;; 72 prime --------------------------------------------------------------------------------
(vector 72 12.708446502686 #r(0 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 0 1 0 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 1)

     10.579571 #r(0.000000 1.526666 1.114036 -0.188699 1.569783 1.061483 1.461941 0.746029 1.509803 1.264040 0.039120 0.005480 1.670375 0.087176 1.602839 1.411297 1.630968 0.248800 0.070549 1.021733 -0.228089 1.869979 1.152734 0.098898 0.604652 0.265485 1.435929 0.170559 0.737250 0.104974 0.731428 1.774793 1.550528 -0.147974 1.870001 1.248377 1.256893 0.177185 1.205217 1.218210 1.654506 -0.048160 1.262662 0.659765 1.099483 0.193101 1.327235 0.693549 1.139270 0.170053 0.767850 1.284172 -0.044820 1.663616 1.015434 0.890883 1.694823 0.554893 0.622406 0.662793 0.328828 0.995738 1.236624 0.150517 1.587539 1.302619 0.103369 0.398303 0.131685 0.921928 1.168883 0.112924)
     10.496982 #r(0.000000 1.577140 1.146293 -0.139228 1.523478 1.074777 1.483287 0.662248 1.518460 1.358355 0.041669 -0.050825 1.633955 0.197302 1.628681 1.406765 1.599699 0.116714 0.102433 1.063359 -0.147037 1.816452 1.121083 0.122390 0.742457 0.181771 1.441622 0.172190 0.732537 0.047111 0.764854 1.749139 1.387157 -0.078027 1.839767 1.313819 1.301810 0.133381 1.152104 1.136084 1.760093 -0.040936 1.318430 0.739766 1.052638 0.175449 1.273552 0.687602 1.060057 0.117723 0.884432 1.344726 -0.002641 1.640974 1.031637 0.883501 1.787709 0.532454 0.578078 0.643118 0.404748 0.878255 1.298175 0.117038 1.624847 1.295336 0.039560 0.420808 -0.013827 0.878965 1.254788 0.161686)
     )

;;; 73 prime --------------------------------------------------------------------------------
(vector 73 12.877750118249 #r(0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0)

     ;; 72+1
     10.689130 #r(0.000000 1.525750 1.157802 -0.130495 1.566135 1.068083 1.436324 0.699061 1.496431 1.345845 -0.045471 -0.032146 1.656974 0.163846 1.519166 1.394757 1.503557 0.183007 0.248242 1.068642 -0.134987 1.855031 1.116717 -0.022218 0.511499 0.347386 1.347662 0.149072 0.778251 0.082394 0.706357 1.835299 1.598933 -0.137332 1.800937 1.334976 1.258225 0.107942 1.165982 1.097698 1.720927 -0.060245 1.266550 0.522159 1.151393 0.179388 1.306382 0.759803 1.190783 0.160999 0.709993 1.280967 -0.169862 1.562918 1.019413 0.839429 1.731380 0.566096 0.647229 0.704371 0.329975 1.072857 1.320759 0.275029 1.479112 1.297543 0.103782 0.366305 0.194503 1.011614 1.086013 0.243622 -0.036669)
     10.424692 #r(0.000000 1.554014 1.052186 -0.086200 1.476351 1.224926 1.580661 0.637756 1.422927 1.516582 -0.013111 -0.069153 1.566827 0.301765 1.594981 1.454270 1.439078 0.053331 0.299149 1.030104 -0.048066 1.777424 0.985794 0.000633 0.702766 0.173634 1.368758 0.222346 0.786334 0.080834 0.716179 1.776274 1.616019 -0.113541 1.676208 1.494328 1.439541 0.055619 0.983919 1.123924 1.848565 -0.036510 1.436326 0.574953 1.019118 0.214244 1.115597 0.860645 1.198449 0.197190 0.778351 1.383645 -0.195100 1.543792 1.148480 0.893946 1.917170 0.612713 0.688674 0.645993 0.415091 1.119089 1.442261 0.184218 1.468700 1.212357 0.199763 0.454337 0.103961 1.020748 1.089579 0.296783 -0.106516)
     )

;;; 74 prime --------------------------------------------------------------------------------
(vector 74 13.115156173706 #r(0 1 1 0 0 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 1 1 1 1 0 0 0 0 0 1)

     10.649887 #r(0.000000 0.311188 1.290942 0.614169 0.538966 0.384100 0.109850 0.021551 0.798332 1.375278 0.593955 1.270048 0.158912 1.156782 1.030374 0.821590 0.254106 0.736652 -0.160646 1.527962 0.008622 1.070061 1.131441 1.654723 1.927687 1.286729 -0.139272 1.540344 0.234722 1.262327 0.958913 0.415825 0.099669 0.142462 -0.047631 -0.219606 0.497897 0.164613 1.298918 -0.030959 0.077929 0.023069 -0.048674 1.490524 1.421741 1.027040 1.916604 1.756080 0.253777 0.507377 0.665062 0.691819 1.450238 1.738862 1.010067 1.810972 1.515691 0.044783 0.082536 1.267984 0.419709 0.481882 1.832483 1.839130 0.674123 0.733681 1.236692 0.099256 1.206529 1.152388 -0.150515 0.755739 -0.177039 0.279539)
     10.645980 #r(0.000000 0.311650 1.280848 0.611958 0.562391 0.394077 0.103205 0.008568 0.817187 1.367252 0.596140 1.287960 0.175350 1.148539 1.041198 0.821079 0.245783 0.725100 -0.171308 1.536345 0.020047 1.082763 1.136937 1.647863 1.919963 1.278757 -0.129192 1.538754 0.220953 1.263827 0.945051 0.419785 0.111579 0.140279 -0.056385 -0.214011 0.504195 0.169718 1.297017 -0.039788 0.085951 0.026379 -0.042190 1.504313 1.415242 1.036770 1.935911 1.763171 0.268139 0.498510 0.658810 0.698991 1.452795 1.747788 0.995160 1.796367 1.535056 0.043981 0.090892 1.265806 0.402298 0.496068 1.847177 1.828232 0.685895 0.730616 1.243411 0.093164 1.207951 1.153047 -0.163119 0.756812 -0.182692 0.296379)
     )

;;; 75 prime --------------------------------------------------------------------------------
(vector 75 13.254356384277 #r(0 0 0 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1)

     ;; 74+1
     10.845278 #r(0.000000 0.303549 1.218741 0.552551 0.569127 0.472240 0.245073 0.036162 0.777257 1.317108 0.637687 1.223165 0.113140 1.175025 0.935816 0.812633 0.204261 0.775370 -0.063348 1.606612 -0.062866 1.039670 1.212702 1.714844 1.899468 1.335566 -0.020119 1.590425 0.290190 1.193213 1.001576 0.516379 0.026311 0.170930 -0.096650 -0.315084 0.554428 0.144183 1.271300 0.005031 0.147859 0.041442 -0.048782 1.533805 1.480719 1.134329 1.851707 1.704199 0.286268 0.581546 0.690124 0.731502 1.497188 1.734408 1.013517 -0.010349 1.506433 0.024492 0.040181 1.200857 0.486442 0.422051 1.858040 1.837071 0.586958 0.629092 1.226159 0.139529 1.240473 1.272372 -0.245955 0.719958 -0.223615 0.281302 0.252047)
     10.728934 #r(0.000000 0.319906 1.183822 0.470461 0.553071 0.558322 0.240393 0.036866 0.834403 1.306075 0.639501 1.156931 0.131640 1.232771 0.859368 0.705663 0.237380 0.745032 -0.025724 1.667265 -0.112461 1.089983 1.220375 1.725435 1.917328 1.264565 0.041607 1.662792 0.234857 1.186979 1.051440 0.530773 -0.049988 0.142301 -0.159714 -0.311512 0.553213 0.109766 1.263045 0.012668 0.132405 0.025382 -0.046342 1.549557 1.414619 1.136704 1.834421 1.703381 0.363733 0.499672 0.660724 0.818632 1.487689 1.724136 0.974920 0.033975 1.567287 0.122631 0.037040 1.212978 0.445691 0.550630 1.935380 1.805163 0.633422 0.566599 1.268418 0.116152 1.266782 1.256257 -0.199735 0.730751 -0.178681 0.296223 0.384273)
     )

;;; 76 prime --------------------------------------------------------------------------------
(vector 76 13.288178191792 #r(0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1)

     ;; 75+1
     10.919127 #r(0.000000 0.249051 1.283752 0.578538 0.465889 0.328282 0.397520 0.048700 0.732044 1.506763 0.870470 1.024466 0.125905 1.199969 1.200490 0.828996 0.327349 0.743916 -0.083081 1.581866 -0.022026 1.010771 1.314126 1.641110 1.977207 1.418126 -0.002727 1.553515 0.292061 1.103162 1.068475 0.567360 0.089633 0.183619 -0.243814 -0.246117 0.459882 0.118225 1.182209 0.017390 0.042772 0.114593 -0.081235 1.493721 1.405420 1.147867 1.909741 1.653034 0.237976 0.515913 0.601555 0.768092 1.451311 1.697940 1.055226 -0.095470 1.438708 0.052821 -0.122724 1.275935 0.441115 0.338376 1.822506 1.852761 0.555244 0.752898 1.362553 0.167682 1.066534 1.298923 -0.414288 0.895495 -0.078589 0.121695 0.415788 -0.032714)
     10.773166 #r(0.000000 0.201922 1.470715 0.636128 0.479807 0.182336 0.489746 -0.031316 0.670193 1.592382 1.066940 0.948022 -0.036816 1.198638 1.350990 0.747493 0.325762 0.715896 -0.102405 1.561943 0.009585 1.062252 1.395815 1.768190 -0.043534 1.482072 -0.001794 1.483462 0.157255 1.169128 1.009563 0.483780 0.060058 0.224370 -0.093213 -0.150562 0.299988 0.186265 1.109939 0.037835 0.063477 0.120364 -0.104932 1.261680 1.363550 1.249465 -0.070936 1.540722 0.209914 0.543128 0.585021 0.745504 1.384715 1.632179 1.125276 -0.108742 1.334210 -0.037982 -0.082542 1.084030 0.463687 0.200417 1.666770 1.741346 0.354672 0.872840 1.236363 -0.005541 0.889944 1.400912 -0.351050 0.975108 -0.113186 0.166344 0.530700 -0.174117)
     )

;;; 77 prime --------------------------------------------------------------------------------
(vector 77 13.158900260925 #r(0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 1 1 1 1)

     10.802937 #r(0.000000 1.170348 0.872365 1.938370 0.176318 1.425001 1.816351 0.600885 0.838206 0.617008 0.862854 1.459906 1.685266 -0.294339 0.340282 0.188975 1.272363 0.222263 0.754500 0.303643 1.420294 0.520239 1.223316 1.153660 0.209190 1.335123 1.331714 0.719154 0.909245 -0.009852 0.827474 -0.139034 0.531790 0.623898 0.587466 0.935238 0.452213 -0.149439 0.923750 0.885640 -0.429219 0.037445 0.354080 0.150061 0.302072 1.423031 0.130250 -0.009435 0.571653 0.410660 0.194501 1.802956 0.455392 0.509514 1.619972 1.373513 1.082720 1.024058 0.798330 0.005055 0.529388 0.193199 0.652877 0.658529 1.505933 1.232728 0.171053 1.366924 1.004855 0.355582 1.506276 0.574068 1.502183 1.005869 -0.239104 1.730993 -0.006156)
     10.787093 #r(0.000000 1.149443 0.839971 1.956305 0.168601 1.427588 1.800892 0.609682 0.814947 0.631205 0.873403 1.488539 1.665370 -0.309318 0.332414 0.201227 1.240570 0.267709 0.720021 0.301507 1.431244 0.535840 1.193228 1.164152 0.191654 1.320111 1.339133 0.720237 0.902284 -0.025313 0.876522 -0.150998 0.539439 0.632152 0.598019 0.925249 0.453321 -0.170091 0.923681 0.879763 -0.459931 0.014839 0.344599 0.118045 0.294786 1.397001 0.097630 -0.060819 0.573635 0.376236 0.149790 1.819557 0.472911 0.520765 1.611957 1.363729 1.059191 1.015359 0.784191 0.007017 0.526385 0.177402 0.653955 0.630819 1.506190 1.214284 0.142017 1.368482 0.988751 0.343026 1.474912 0.576723 1.482195 0.984766 -0.259805 1.708315 0.031304)
     )

;;; 78 prime --------------------------------------------------------------------------------
(vector 78 13.498236182018 #r(0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1)

     ;; 77+1
     11.104393 #r(0.000000 1.124037 0.854979 1.945811 0.208140 1.468398 1.815990 0.611918 0.912844 0.730140 0.961369 1.376309 1.803559 -0.243021 0.398976 0.193476 1.338837 0.340346 0.793855 0.341671 1.410779 0.565778 1.176931 1.048390 0.277106 1.445162 1.185150 0.642492 0.933385 0.019030 0.859542 -0.113411 0.532157 0.598476 0.550518 0.931780 0.311264 -0.108835 0.867767 0.932278 -0.351004 0.021213 0.390636 0.076987 0.338139 1.457487 0.082705 1.889708 0.513158 0.413795 0.138548 1.809057 0.494899 0.552125 1.690745 1.358244 1.250637 0.989495 0.775385 1.847135 0.528873 0.242941 0.558866 0.669472 1.484739 1.334473 0.249966 1.409992 1.022049 0.346238 1.534652 0.641930 1.394789 0.932978 -0.210333 1.769933 -0.083609 -0.106856)
     10.978554 #r(0.000000 1.096768 0.888550 1.947239 0.181155 1.436514 1.814166 0.609633 0.891320 0.659350 0.972721 1.468447 1.646059 -0.390883 0.349403 0.190468 1.286125 0.375446 0.793806 0.337362 1.378321 0.647016 1.173848 1.022068 0.190156 1.504099 1.351392 0.578668 0.934287 -0.058591 0.870464 -0.121287 0.523546 0.687399 0.529897 0.922200 0.431176 -0.056191 0.754863 0.891222 -0.326946 0.005264 0.363921 0.137521 0.399466 1.549811 0.144317 1.805962 0.610952 0.389712 0.143450 1.855414 0.481342 0.544731 1.670447 1.340333 1.179027 1.030541 0.783467 1.922631 0.500265 0.196650 0.571085 0.717767 1.534607 1.401419 0.181832 1.507521 1.055075 0.386262 1.543298 0.667522 1.460252 0.875356 -0.193185 1.822363 -0.120925 -0.088087)
     )

;;; 79 prime --------------------------------------------------------------------------------
(vector 79 13.178678233398 #r(0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1)

     11.177833 #r(0.000000 1.310798 1.470398 1.323367 0.553981 1.135824 0.783258 1.090444 0.524280 1.788975 1.639185 0.764585 0.676397 1.561727 -0.046007 0.428923 1.763449 0.011640 0.636361 1.341212 0.004579 1.608860 0.575061 0.243266 0.907181 0.977184 1.726699 0.431482 0.140827 0.464141 1.057140 1.400168 0.289408 0.838151 1.631807 1.530460 1.501458 0.566438 1.487014 0.015110 1.680036 1.296993 1.364424 0.039821 1.528230 0.589464 0.715462 0.552663 -0.017058 1.149326 1.516482 -0.030051 0.582733 -0.149911 0.234725 0.517539 1.013720 0.964483 -0.295150 -0.068887 -0.069035 1.472439 0.368231 1.600803 0.316013 0.723864 0.014324 0.524613 1.419685 1.673198 -0.043005 -0.029455 1.487321 1.686189 1.173017 1.833259 1.763911 1.426155 0.892867)
     10.999617 #r(0.000000 1.347638 1.481865 1.267885 0.720556 1.195414 0.753438 1.098720 0.495501 1.797982 1.642962 0.601320 0.733508 1.623968 0.011622 0.555415 1.687686 0.033994 0.666502 1.354310 -0.062776 1.702810 0.530396 0.338013 0.545697 0.903827 1.624803 0.452440 0.102085 0.589641 1.075934 1.462201 0.377420 0.723141 1.637868 1.442214 1.376332 0.574016 1.429444 0.048675 1.824423 0.994761 1.202853 -0.088838 1.572593 0.683487 0.821830 0.608958 -0.019919 1.128671 1.564127 -0.024601 0.496124 -0.264208 0.364120 0.445910 1.094455 1.000778 -0.275483 -0.106836 -0.068847 1.489050 0.299418 1.609451 0.481299 0.720974 0.061435 0.470166 1.313720 1.731595 -0.046698 0.033686 1.464911 1.633519 1.188988 1.851117 1.709574 1.472512 0.989145)
     )

;;; 80 prime --------------------------------------------------------------------------------
(vector 80 13.547472953796 #r(0 1 1 1 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 1)

     ;; 79+1
     11.248369 #r(0.000000 1.320660 1.562587 1.230907 0.791500 1.111831 0.776332 1.212269 0.471199 1.929248 1.797736 0.814341 0.620835 1.395121 -0.166860 0.291055 1.737100 0.070444 0.531137 1.293083 0.075352 1.711864 0.539841 0.274514 0.922582 0.992421 1.608388 0.391268 0.216699 0.537576 0.886521 1.411196 0.301396 0.827503 1.619143 1.601542 1.558307 0.639158 1.445488 -0.167072 1.736837 1.279584 1.414784 0.077225 1.537483 0.689000 0.730293 0.519349 -0.104713 1.140696 1.722734 -0.057361 0.493518 -0.183111 0.352303 0.572659 0.917617 1.016232 -0.317574 -0.040058 -0.065357 1.491653 0.416263 1.654521 0.241001 0.536870 0.065165 0.568896 1.612372 1.840754 0.054958 0.057425 1.377368 1.668931 1.097005 1.763836 1.887359 1.244817 0.894926 -0.107373)
     11.124609 #r(0.000000 1.320780 1.601769 1.212780 0.925936 1.150272 0.779842 1.132278 0.433186 0.139791 1.855510 0.984204 0.587965 1.275520 -0.336181 0.027669 1.507412 0.083629 0.532076 1.243939 0.164559 1.877439 0.451029 0.134435 0.917256 1.191050 1.717198 0.311344 0.139463 0.522509 0.832256 1.355200 0.464307 0.658935 1.684435 1.657016 1.566402 0.678177 1.345914 -0.411327 1.726908 1.256822 1.382264 0.197288 1.663654 0.681666 0.826275 0.390159 -0.131622 0.991840 1.745403 0.052203 0.397755 -0.135974 0.449565 0.653214 0.884195 1.036845 -0.214613 -0.022842 -0.045826 1.524990 0.542288 1.697273 0.124559 0.683912 0.114180 0.529112 1.689881 1.816455 0.164399 -0.036640 1.454681 1.789629 1.043242 1.803429 -0.026605 1.256594 0.922085 0.128868)
     )

;;; 81 prime --------------------------------------------------------------------------------
(vector 81 13.652944564819 #r(0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 1)

     ;; 80+1
     11.318789 #r(0.000000 1.312875 1.595991 1.250300 0.860994 1.125394 0.798611 1.212371 0.450471 1.878426 1.854513 0.914795 0.516574 1.401974 -0.113348 0.191503 1.535380 0.090102 0.579969 1.358286 0.094046 1.749820 0.409421 0.342346 0.891748 1.034938 1.701846 0.411592 0.161183 0.550475 0.945261 1.433769 0.390250 0.782945 1.725670 1.526810 1.626189 0.651868 1.370885 -0.153655 1.876481 1.236862 1.409437 0.102929 1.494796 0.718278 0.752798 0.534726 -0.125235 1.053652 1.624242 -0.009527 0.513674 -0.193412 0.274147 0.590252 0.888478 1.001277 -0.294725 -0.017970 0.022617 1.502755 0.474472 1.669991 0.292823 0.423633 -0.068585 0.472411 1.717891 1.789153 0.120369 -0.013158 1.253256 1.671744 1.049132 1.799303 1.831390 1.289936 0.966946 -0.056458 0.096803)
     11.310930 #r(0.000000 1.338496 1.618662 1.258204 0.891699 1.165718 0.809579 1.213708 0.463435 1.847107 1.877094 0.887680 0.518124 1.428458 -0.093788 0.177741 1.547353 0.147919 0.591101 1.362498 0.128273 1.749927 0.385360 0.363540 0.893754 1.012364 1.709135 0.377311 0.132445 0.548112 0.972027 1.427773 0.398203 0.797906 1.737369 1.502566 1.622093 0.644136 1.374056 -0.140256 1.875110 1.255940 1.364448 0.121294 1.485291 0.710718 0.734848 0.549536 -0.134214 1.064920 1.565350 -0.009589 0.522300 -0.211877 0.234875 0.550469 0.900507 1.016853 -0.289771 -0.050216 0.013259 1.497164 0.470306 1.682199 0.310878 0.400752 -0.073850 0.501083 1.721610 1.757416 0.086836 -0.012437 1.234361 1.696764 1.030486 1.800768 1.816277 1.295973 0.965902 -0.050332 0.065058)
     )

;;; 82 prime --------------------------------------------------------------------------------
(vector 82 14.126787045134 #r(0 1 0 1 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0)

     11.462533 #r(0.000000 1.174537 -0.036810 1.449073 0.002634 1.412064 0.527823 1.690777 0.901678 -0.091711 1.027422 0.397477 1.526657 0.088004 0.143741 1.426347 1.215238 1.051627 0.132305 0.242096 1.932884 0.204037 1.515523 0.068047 0.117753 1.158626 0.459284 1.081363 0.079849 0.326802 0.035989 0.012387 0.861938 0.605551 1.407324 0.411725 0.979703 0.090881 0.271335 0.152506 0.410872 1.149930 0.566324 1.611304 1.416641 0.010695 1.743925 0.323768 0.693725 0.691039 0.186118 0.191067 0.629603 -0.034867 0.109309 0.522152 1.478755 1.337464 1.245454 -0.020762 0.796712 1.449381 1.763960 0.000713 0.577015 1.247460 1.754051 1.376869 0.724941 0.407841 1.068454 1.226119 0.726352 1.657000 0.543820 1.177669 0.881363 0.120220 0.019239 0.418519 0.727327 0.208388)
     11.386457 #r(0.000000 1.184234 0.006185 1.471909 -0.020737 1.446959 0.527864 1.725003 0.958833 -0.183759 1.087116 0.362689 1.480740 0.156332 0.170868 1.516744 1.299390 1.020445 0.102346 0.190152 1.932659 0.191092 1.540988 0.054252 0.058332 1.143228 0.532621 1.103901 0.155802 0.259232 0.085821 -0.014535 0.917981 0.747767 1.437555 0.498491 1.005960 0.024742 0.278586 0.123254 0.358645 1.153761 0.644707 1.717819 1.457212 -0.016722 1.757337 0.168836 0.613830 0.731386 0.184591 0.125826 0.694463 -0.160662 0.133275 0.594504 1.448950 1.320971 1.379627 0.024099 0.749678 1.395049 1.707113 0.063661 0.577678 1.276404 1.735192 1.396486 0.777297 0.406175 1.037567 1.241034 0.810533 1.704071 0.626515 1.230799 0.928665 0.102631 -0.064751 0.376824 0.691188 0.213400)
     )

;;; 83 prime --------------------------------------------------------------------------------
(vector 83 14.019070339131 #r(0 1 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1)

     11.495305 #r(0.000000 0.489724 1.459665 0.744876 0.880930 1.487259 1.179525 0.143969 1.398705 1.711637 1.229644 1.599300 1.480153 1.405136 0.390934 1.640936 1.928348 1.588509 0.860260 0.449815 0.093357 1.993956 0.692831 1.455573 0.371844 0.551569 -0.014841 0.652289 1.000821 1.372208 -0.157122 1.697110 0.020676 1.736939 1.000046 1.712927 0.862704 1.740081 0.913067 1.344458 1.894797 0.629049 1.175321 0.159464 0.992773 0.367516 1.362985 0.576721 1.753109 0.776625 0.227603 0.452205 0.315264 0.636900 1.541376 1.554828 0.983967 1.431020 1.527430 0.561443 -0.018728 0.579720 0.634527 0.252657 1.931947 0.472631 0.403447 1.506115 1.700022 0.443875 1.857223 0.863365 0.830784 0.658374 1.791596 1.216322 0.200510 1.645886 1.544611 0.129139 0.651447 1.366065 0.329410)
     11.400086 #r(0.000000 0.459417 1.478222 0.664125 0.852104 1.386067 1.283493 0.160768 1.308022 1.604094 1.126193 1.566269 1.568738 1.342738 0.419858 1.658792 -0.011036 1.552713 0.806931 0.444376 0.128892 -0.001775 0.815035 1.540336 0.477288 0.476633 -0.083853 0.616178 1.184762 1.390709 -0.175824 1.637740 -0.077982 1.657633 1.020322 1.773148 0.845120 1.747456 0.992318 1.275075 1.939061 0.605573 1.185358 0.167572 0.913732 0.299104 1.406457 0.569969 1.649279 0.703090 0.103735 0.654783 0.341905 0.575994 1.616954 1.462440 1.014559 1.425017 1.529452 0.557680 0.075790 0.545195 0.626721 0.258881 0.008660 0.415987 0.379632 1.492871 1.695672 0.532611 1.883431 0.970952 0.710469 0.791296 1.620061 1.265893 0.186190 1.675885 1.429872 0.222912 0.694823 1.504249 0.295556)
     )

;;; 84 prime --------------------------------------------------------------------------------
(vector 84 14.024940956301 #r(0 1 0 1 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 0 1 1 0 1 1 1 0)

     11.536851 #r(0.000000 1.288171 1.222912 1.421316 0.994256 1.309106 0.862461 -0.365885 -0.460542 0.530989 0.804830 1.140139 0.788715 0.769440 0.941320 -0.061500 1.897753 1.285116 0.647118 0.948482 1.478812 1.645309 -0.360540 1.475165 0.480180 0.398442 1.131834 0.453887 0.828958 0.223971 1.033478 0.103677 1.715711 0.595485 0.422094 0.246530 1.081093 0.706350 0.534924 0.737096 0.520740 1.348231 0.027898 1.430351 0.071366 0.456025 1.024992 0.563780 1.148663 1.244878 0.023430 1.078768 -0.035007 1.108834 0.481954 -0.628990 0.715248 0.675907 1.709977 0.563135 1.037605 0.888801 0.556599 0.958729 0.571715 1.126122 -0.072129 1.378438 0.187340 0.783805 0.989989 0.112073 -0.183972 1.388719 1.544777 0.651714 0.568338 1.234814 0.056527 0.901152 1.674263 0.800528 0.192396 0.655541)
     11.487189 #r(0.000000 1.278944 1.148531 1.401192 0.987704 1.327417 0.829579 -0.354298 -0.446197 0.541522 0.846600 1.167524 0.744313 0.737800 0.828061 -0.053765 1.861119 1.325767 0.672993 0.966357 1.445826 1.688836 -0.450107 1.471053 0.516894 0.367519 1.174937 0.437379 0.853702 0.209199 1.035157 0.082435 1.740685 0.596247 0.399331 0.200076 1.109361 0.675003 0.521122 0.756143 0.565837 1.380232 -0.008543 1.422785 0.040780 0.501067 0.990564 0.571111 1.127444 1.211055 0.008227 1.058879 -0.148477 1.162238 0.462774 -0.644672 0.689412 0.695705 1.693384 0.526716 1.043108 0.834911 0.565280 0.892133 0.579137 1.124242 -0.026948 1.358422 0.140470 0.718068 0.974714 0.118003 -0.283224 1.394974 1.520860 0.584840 0.604388 1.176504 0.054703 0.967857 1.645062 0.782868 0.226688 0.643857)
     )

;;; 85 prime --------------------------------------------------------------------------------
(vector 85 14.253310943921 #r(0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1)

     11.588928 #r(0.000000 0.051144 0.232251 1.722677 0.580164 1.682133 1.175152 1.551429 1.040385 1.746433 0.629958 1.774843 0.701195 0.931344 1.300787 -0.092863 1.300643 1.259885 1.530011 1.258206 1.393028 0.930782 0.485840 1.244517 -0.032618 0.062247 0.154622 1.065009 0.904299 1.262092 0.852812 0.408235 0.633914 1.770716 1.085864 1.265219 1.003699 1.255985 1.195701 1.382932 0.704891 0.246143 0.639193 1.457010 0.146909 1.982729 0.165366 1.294717 0.624758 1.669440 0.868773 0.953753 0.230896 0.915079 -0.212743 0.773612 0.218470 1.122339 1.601419 1.730078 1.474786 -0.488722 1.796889 1.514239 1.703114 -0.437786 0.743917 1.859124 1.287147 1.160254 0.159597 0.817545 1.148746 -0.204270 1.716652 0.382598 -0.057580 0.598631 0.343212 0.230053 1.103741 1.603024 0.720362 -0.247891 -0.077598)
     11.570507 #r(0.000000 0.047594 0.231800 1.737716 0.592145 1.652212 1.192054 1.567404 1.046450 1.723115 0.587946 1.782686 0.701038 0.897285 1.336786 -0.109574 1.277555 1.261601 1.545663 1.233661 1.363878 0.922445 0.511703 1.220970 -0.070567 0.088051 0.176020 1.072453 0.914377 1.232116 0.840227 0.412088 0.628076 1.768879 1.075555 1.220311 1.034101 1.263906 1.221853 1.406941 0.716926 0.235511 0.642674 1.462473 0.183537 -0.009850 0.175206 1.304723 0.625192 1.685015 0.888960 0.987176 0.229156 0.906130 -0.208521 0.759860 0.236964 1.148836 1.618089 1.690238 1.469450 -0.451721 1.792831 1.505055 1.723875 -0.409424 0.740127 1.856282 1.278624 1.171755 0.169482 0.793153 1.150142 -0.196592 1.722287 0.369994 -0.051653 0.593145 0.312913 0.205677 1.134911 1.617687 0.708755 -0.258596 -0.058071)
     )

;;; 86 prime --------------------------------------------------------------------------------
(vector 86 14.017106967247 #r(0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 1 1 0 0 0 0 1 0 1 1 1)

	11.517897 #r(0.000000 1.259153 0.753054 1.764686 1.049517 1.125067 1.190973 0.991011 1.742456 0.708907 0.178161 0.559310 1.128716 0.240782 0.729992 0.303371 0.569838 1.273658 0.861674 0.290602 0.694623 0.362989 0.243116 1.696103 0.326714 1.481176 0.105867 1.763155 0.389638 1.096089 1.860461 0.384795 1.595111 0.327309 0.224303 1.457357 0.863276 1.221159 0.474861 0.148710 1.484645 1.778010 1.802629 1.714822 1.122256 0.709074 0.540633 -0.317254 0.997156 1.115917 0.123376 1.869025 1.339712 0.876345 1.682733 0.893530 0.998209 1.642978 1.224902 0.836368 1.948885 0.464451 1.058190 1.080864 1.538683 1.521142 0.009248 0.654339 -0.126350 0.282369 0.636445 1.771914 0.323435 1.302976 0.483884 1.466774 1.898584 0.571020 1.479654 0.824385 0.735539 0.638514 1.340179 1.302713 1.869702 1.497079)
	11.464026 #r(0.000000 1.241236 0.735036 1.768547 1.022146 1.158298 1.183137 0.968670 1.691321 0.680729 0.175789 0.559083 1.034407 0.262233 0.715208 0.394477 0.568287 1.225764 0.839690 0.246790 0.703772 0.272543 0.240951 1.762450 0.355652 1.467532 0.066482 1.711928 0.362496 1.105319 1.848902 0.391341 1.590736 0.360815 0.274201 1.466380 0.854785 1.225119 0.526056 0.183082 1.503310 1.755183 1.757420 1.681676 1.139772 0.722094 0.514930 -0.299099 1.017929 1.152013 0.153296 1.883541 1.305369 0.813266 1.721262 0.869359 0.984240 1.647146 1.176821 0.799554 0.018930 0.425544 1.045905 1.125325 1.538483 1.465973 0.064269 0.652429 -0.179189 0.307284 0.665917 1.822483 0.377774 1.365596 0.523452 1.459586 1.934048 0.590056 1.391427 0.798023 0.719605 0.666459 1.328349 1.280789 1.829329 1.518014)
     )

;;; 87 prime --------------------------------------------------------------------------------
(vector 87 13.98394199918 #r(0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0)

	;; 86 + 1
	11.612976 #r(0.000000 1.296504 0.726706 1.718822 1.046681 1.126904 1.153426 0.940241 1.708793 0.818644 0.107576 0.530980 1.122499 0.334577 0.735679 0.325192 0.616360 1.132997 0.845995 0.287311 0.640223 0.397260 0.270000 1.691583 0.368381 1.503691 0.176791 1.719860 0.415279 1.070108 1.956631 0.329587 1.654694 0.271910 0.194847 1.468802 0.897532 1.267673 0.483007 0.130123 1.446495 1.802533 1.802082 1.708319 1.123221 0.822012 0.552025 -0.324423 0.903301 1.074684 0.198879 1.961955 1.280447 0.787297 1.695626 0.996555 1.020892 1.595011 1.302967 0.813723 1.889725 0.419999 1.093466 1.051442 1.549928 1.587010 -0.012516 0.597662 -0.094834 0.261495 0.632231 1.919100 0.281141 1.272306 0.493568 1.244869 1.877721 0.661378 1.459138 0.814695 0.650143 0.614249 1.318253 1.365141 1.852338 1.532615 -0.014292)
	11.586549 #r(0.000000 1.319934 0.683556 1.736385 1.027728 1.173837 1.184698 0.961791 1.704376 0.843318 0.132911 0.584467 1.141938 0.321037 0.779862 0.299234 0.629450 1.094141 0.844655 0.288940 0.660398 0.439375 0.314691 1.666921 0.322593 1.512703 0.231385 1.704505 0.421557 1.039389 1.946760 0.308796 1.609358 0.203579 0.177237 1.506281 0.894308 1.216342 0.501064 0.160715 1.429269 1.812129 1.767937 1.687170 1.113267 0.850769 0.563496 -0.346176 0.899849 1.098438 0.221013 1.948980 1.291389 0.764823 1.684795 1.017892 1.076383 1.610312 1.306587 0.796716 1.904904 0.399772 1.098544 1.053384 1.502425 1.612650 0.040403 0.594147 -0.060080 0.267263 0.625776 1.885933 0.279953 1.237545 0.539981 1.187985 1.832449 0.645047 1.471522 0.838324 0.594444 0.547162 1.351894 1.374768 1.850180 1.530619 -0.004121)
     )

;;; 88 prime --------------------------------------------------------------------------------
(vector 88 14.825139803345 #r(0 0 0 0 1 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0)

     ;; 87+1
     11.814735 #r(0.000000 1.368148 0.691154 1.687498 1.039684 1.203556 1.189736 1.006697 1.714307 0.763256 0.064985 0.571039 1.207048 0.283865 0.790295 0.371929 0.626841 1.136922 0.897180 0.250579 0.703180 0.367153 0.285039 1.638464 0.403793 1.574680 0.178418 1.768394 0.361495 1.131365 1.971622 0.329290 1.677397 0.231014 0.189969 1.483487 0.936641 1.267305 0.514462 0.133317 1.438805 1.804423 1.766680 1.772823 1.080035 0.819063 0.520465 -0.385910 0.897901 1.088041 0.197160 0.026953 1.297496 0.779688 1.684839 1.075719 1.000862 1.653028 1.332924 0.886650 1.939949 0.418280 1.124021 1.085155 1.563576 1.537898 -0.095926 0.685710 -0.089908 0.297752 0.611005 1.863915 0.336806 1.344864 0.522590 1.267887 1.872098 0.632836 1.388439 0.783559 0.644197 0.609366 1.338438 1.322505 1.876261 1.537568 -0.063978 -0.021791)
     11.779236 #r(0.000000 1.385571 0.664473 1.673357 1.051668 1.283568 1.183264 1.016197 1.723437 0.762491 0.080885 0.614460 1.223750 0.274564 0.777149 0.392993 0.636161 1.138986 0.921669 0.256330 0.732496 0.422658 0.283548 1.588340 0.390676 1.581671 0.216287 1.805018 0.433400 1.120574 1.990633 0.309428 1.679712 0.246719 0.166510 1.528330 0.978160 1.240452 0.514802 0.152836 1.444098 1.821338 1.741079 1.773767 1.043953 0.834341 0.516037 -0.399761 0.912297 1.152952 0.174890 0.026661 1.322705 0.774691 1.684626 1.143688 1.039299 1.661069 1.354440 0.852909 1.920418 0.430453 1.107020 1.077494 1.563179 1.550268 -0.081456 0.683010 -0.070683 0.331375 0.596427 1.840076 0.338343 1.322910 0.555709 1.250193 1.863877 0.674355 1.444116 0.822161 0.611094 0.594036 1.361289 1.319723 1.893231 1.511485 -0.082819 0.004110)
     )

;;; 89 prime --------------------------------------------------------------------------------
(vector 89 14.69031483888 #r(0 1 0 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 0 1 1 1)

	;; 88+1
	11.787567 #r(0.000000 1.314164 0.689513 1.628993 1.144940 1.224705 1.150205 1.016059 1.723195 0.713105 0.005841 0.484975 1.239550 0.341275 0.773786 0.398433 0.655094 1.170929 1.038464 0.301899 0.723090 0.410530 0.287119 1.633201 0.260609 1.623354 0.115980 1.879009 0.455545 1.070015 0.017172 0.270422 1.692490 0.233092 0.152980 1.556192 0.883089 1.261531 0.502559 0.146173 1.438907 1.785157 1.804773 1.715166 1.064977 0.807912 0.565628 -0.439659 0.842957 1.290534 0.179519 -0.023924 1.443203 0.792272 1.565433 1.032012 0.991867 1.644953 1.337404 0.854036 0.023578 0.413260 1.087165 1.065012 1.583652 1.496116 -0.065654 0.692422 -0.146363 0.297624 0.616209 1.798178 0.385485 1.334745 0.400370 1.168196 1.828136 0.707167 1.548668 0.793572 0.670466 0.690206 1.451727 1.295947 1.819151 1.442501 -0.262177 -0.013858 0.006952)
	11.717244 #r(0.000000 1.280725 0.700931 1.629705 1.163151 1.211354 1.207252 1.060983 1.712704 0.662868 -0.016763 0.498571 1.267459 0.312897 0.767566 0.410010 0.682476 1.218973 1.054977 0.335114 0.679822 0.393095 0.285333 1.677466 0.239158 1.657543 0.032877 1.927114 0.412277 1.077579 0.008670 0.301197 1.684983 0.240202 0.156897 1.606919 0.823204 1.224785 0.501380 0.130080 1.461540 1.762701 1.835008 1.675241 1.038261 0.735592 0.567192 -0.407994 0.837736 1.380388 0.177627 -0.022504 1.469278 0.779168 1.535080 1.038856 0.995420 1.647674 1.355912 0.876113 0.054090 0.389662 1.144932 1.056502 1.575441 1.489827 -0.110244 0.716187 -0.131679 0.333903 0.610945 1.724426 0.397732 1.321937 0.382935 1.129101 1.811728 0.678299 1.566954 0.796249 0.670060 0.655543 1.461691 1.275113 1.756029 1.461135 -0.299838 -0.035286 0.000240)
     )

;;; 90 prime --------------------------------------------------------------------------------
(vector 90 14.831111851861 #r(0 1 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1)

     12.022848 #r(0.000000 0.304537 1.829033 1.070382 1.207038 0.596236 0.255424 0.517237 0.518037 0.555724 0.263998 -0.092809 0.086181 1.031798 1.764620 1.155127 1.629595 1.381762 0.374989 1.817825 0.178145 1.717460 -0.421617 0.620765 1.435692 1.136975 0.618586 -0.142602 0.257261 0.632270 1.492625 0.098530 0.089288 1.438957 0.096419 -0.388671 1.239417 1.591519 1.418382 0.224847 0.327382 1.847389 0.645292 1.057386 0.245292 0.974759 0.113802 0.520412 0.536708 1.166960 -0.123664 0.466667 1.597708 0.387840 1.876598 1.035063 1.402503 0.035393 0.945965 1.170137 1.338358 1.449697 1.072439 0.060883 1.296995 1.652836 0.462073 1.502645 1.166005 1.209720 0.739421 0.202107 1.382598 0.210680 0.451167 1.145693 0.222332 1.637533 0.245553 0.987799 0.980876 1.068255 -0.276826 -0.417000 1.573560 0.382232 0.604329 -0.155944 1.170763 0.979682)
     12.010075 #r(0.000000 0.289300 1.832922 1.070239 1.205484 0.597335 0.259099 0.516756 0.523199 0.558359 0.261269 -0.093471 0.091555 1.026569 1.764353 1.165043 1.625073 1.367145 0.390616 1.810113 0.170758 1.725462 -0.432160 0.619320 1.432134 1.135451 0.622029 -0.140800 0.265663 0.646502 1.478885 0.092838 0.097129 1.423593 0.105782 -0.396526 1.242030 1.582773 1.419516 0.220782 0.301291 1.858293 0.628982 1.058543 0.245743 0.972819 0.098124 0.519322 0.530548 1.160427 -0.112417 0.449410 1.615706 0.389137 1.897853 1.035391 1.417866 0.069531 0.947681 1.163554 1.338073 1.463063 1.073234 0.051149 1.312831 1.657798 0.463060 1.514199 1.171371 1.210700 0.729398 0.209824 1.373915 0.222980 0.439816 1.139754 0.233806 1.619610 0.249310 0.991440 0.962827 1.082853 -0.260360 -0.422197 1.563482 0.371912 0.596682 -0.164379 1.163630 0.978379)
     )

;;; 91 prime --------------------------------------------------------------------------------
(vector 91 14.702056847646 #r(0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0)

     12.084424 #r(0.000000 1.661963 0.526933 0.737897 1.547408 1.147810 -0.075617 1.067829 0.852458 1.831985 1.111705 1.210703 0.536594 1.562730 1.564495 0.931257 1.183443 1.206159 1.917460 -0.142965 1.673803 1.211553 1.446589 0.613092 0.971147 0.710033 1.752892 1.683084 1.418254 1.337958 1.028503 0.530465 0.358051 0.607198 0.374767 1.422247 1.801820 -0.023693 0.571429 0.547868 -0.171993 -0.069230 0.452658 0.503964 0.822577 0.139237 1.564879 1.109027 0.054201 0.693725 1.047747 0.930670 0.524559 -1.746051 0.764531 1.459015 0.440040 0.505370 1.433135 1.753190 0.597210 0.403986 1.752023 0.224587 -0.006227 1.424459 1.006632 1.837329 0.717913 1.423544 0.374217 1.561701 0.508321 0.662754 0.466739 0.959175 1.632864 0.950048 1.612332 0.591280 -0.303047 1.088472 1.746777 0.350796 0.275475 0.538357 0.642430 0.726819 1.423969 -0.019252 0.614624)
     12.056772 #r(0.000000 1.655088 0.517836 0.742391 1.553836 1.162637 -0.077411 1.048600 0.851499 1.804505 1.097395 1.199642 0.530523 1.555993 1.539108 0.928585 1.175325 1.218294 1.913706 -0.145100 1.654830 1.196352 1.426305 0.610652 0.984222 0.709877 1.751766 1.683581 1.417526 1.351157 1.037687 0.553812 0.363840 0.597935 0.376221 1.427159 1.809952 -0.020459 0.565337 0.534117 -0.167923 -0.069576 0.459886 0.512230 0.816240 0.138359 1.569795 1.116274 0.057908 0.694326 1.041241 0.942380 0.527543 -1.743134 0.777250 1.461333 0.452094 0.513036 1.432829 1.766487 0.603280 0.413368 1.755261 0.231818 0.002160 1.426191 1.003354 1.838835 0.738780 1.414162 0.356902 1.595753 0.520756 0.659422 0.469426 0.967763 1.639486 0.962864 1.607159 0.579828 -0.304063 1.112041 1.741897 0.354450 0.265311 0.520828 0.654197 0.708473 1.450883 -0.011585 0.618821)
     )

;;; 92 prime --------------------------------------------------------------------------------
(vector 92 14.556435035882 #r(0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0)

     12.111629 #r(0.000000 1.123677 1.203180 1.174948 1.560019 1.384341 0.367155 0.099459 1.212291 0.682305 1.716557 0.261123 0.730999 0.903465 1.369526 0.155486 0.590372 -0.569988 0.244209 0.083007 1.764474 0.389454 0.365639 1.245993 1.816418 0.730704 -0.475666 0.929928 1.528963 0.279291 0.611191 0.845099 1.029972 1.753120 1.126371 1.838017 0.163977 1.146545 0.659479 1.341785 0.566953 0.273863 0.527929 0.012905 1.508411 1.113794 0.790470 1.810888 0.619444 1.306005 1.764955 0.757522 1.532832 1.638004 1.292139 -0.220293 1.326791 0.207925 0.021426 0.636407 0.595067 0.920176 1.364542 1.317600 0.792553 1.523336 0.199497 1.310295 1.126679 1.660906 0.580494 1.441629 1.307014 -0.149187 1.422606 1.228427 0.874268 1.519111 1.056591 1.949465 -0.426058 1.208008 1.301151 1.521711 0.452094 0.671757 0.665097 0.498102 0.181724 0.953835 0.725167 1.124133)     
     12.075526 #r(0.000000 1.123598 1.193091 1.162854 1.556015 1.385136 0.373893 0.081063 1.212819 0.694745 1.718839 0.266461 0.726169 0.892207 1.351775 0.144414 0.589340 -0.570586 0.268316 0.061288 1.759098 0.388617 0.377421 1.234990 1.827295 0.724396 -0.465270 0.930440 1.534793 0.257684 0.627163 0.833483 1.044113 1.751578 1.109125 1.844390 0.169117 1.138039 0.649457 1.366943 0.573643 0.242840 0.540792 0.017459 1.521836 1.109627 0.802063 1.807991 0.595427 1.299129 1.756899 0.748037 1.502111 1.622950 1.285663 -0.246472 1.357737 0.239598 0.032152 0.607989 0.609551 0.939174 1.354903 1.317361 0.768523 1.528914 0.200319 1.313758 1.141251 1.676784 0.560291 1.441914 1.313018 -0.133439 1.430794 1.213400 0.892695 1.529053 1.049502 1.952389 -0.415140 1.195279 1.322523 1.513989 0.451494 0.663841 0.647377 0.517098 0.189973 0.957286 0.751889 1.107131)
     )

;;; 93 prime --------------------------------------------------------------------------------
(vector 93 14.994668960571 #r(0 1 0 1 0 0 1 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1)

     ;; 92+1
     11.941773 #r(0.000000 1.137688 1.089778 1.068356 1.532544 1.432457 0.360804 -0.026160 1.251592 0.723161 1.753475 0.321792 0.652597 0.831785 1.248203 0.098788 0.605754 -0.620144 0.303325 -0.047105 1.719165 0.369582 0.426774 1.169373 1.859324 0.741230 -0.571365 0.881904 1.545056 0.328084 0.606744 0.850606 0.996606 1.766597 1.046556 1.767688 0.237622 1.228793 0.632423 1.337245 0.542894 0.162245 0.534219 0.069759 1.516061 1.102446 0.948393 1.619738 0.549855 1.379503 1.785272 0.859611 1.503940 1.656139 1.246212 -0.223489 1.412206 0.325338 0.101699 0.705391 0.747074 0.979316 1.385520 1.241306 0.625921 1.535144 0.140376 1.223617 1.154594 1.635856 0.580110 1.431599 1.354268 -0.085341 1.513604 1.083083 0.960280 1.481804 1.049034 1.936911 -0.305123 1.144650 1.328494 1.401780 0.463677 0.612788 0.648525 0.589928 0.274669 0.913704 0.769534 1.048236 -0.031107)
     11.931432 #r(0.000000 1.127121 1.091593 1.074474 1.518423 1.420959 0.367784 -0.031145 1.245698 0.718599 1.759333 0.327616 0.650594 0.826820 1.252842 0.094439 0.598513 -0.628081 0.312528 -0.042538 1.709518 0.360880 0.417736 1.158073 1.859130 0.742443 -0.590341 0.883615 1.547983 0.331996 0.607099 0.858658 0.982640 1.780772 1.053553 1.779575 0.248732 1.238805 0.629558 1.331255 0.542830 0.166132 0.543100 0.084654 1.514081 1.107074 0.941695 1.619752 0.544647 1.387487 1.785411 0.861481 1.504001 1.648884 1.253810 -0.229729 1.410403 0.327050 0.103463 0.711689 0.750628 0.980202 1.376285 1.250430 0.632392 1.537616 0.141022 1.212057 1.154123 1.625689 0.577285 1.439125 1.351858 -0.078966 1.506889 1.067426 0.976028 1.474839 1.064130 1.937182 -0.294264 1.134037 1.342796 1.406874 0.460202 0.605755 0.645016 0.599008 0.283392 0.923416 0.764482 1.047804 -0.027728)
     )

;;; 94 prime --------------------------------------------------------------------------------
(vector 94 14.811392756555 #r(0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0)

     ;; 93+1
     12.114932 #r(0.000000 1.123175 1.150884 1.058343 1.465121 1.413282 0.350764 0.114071 1.226428 0.791079 1.790932 0.440109 0.565381 0.734544 1.327723 -0.001005 0.566798 -0.729477 0.316829 -0.017120 1.801895 0.389351 0.381914 1.198959 1.820572 0.721571 -0.570163 0.955754 1.536499 0.370558 0.593528 0.885066 1.037479 1.768525 1.105455 1.756351 0.226836 1.186245 0.651550 1.384674 0.494435 0.218370 0.473389 0.034709 1.487137 1.083964 0.911945 1.641974 0.559886 1.326260 1.842092 0.870886 1.399307 1.629693 1.284916 -0.226560 1.347506 0.289919 0.059989 0.740638 0.739763 0.950849 1.395859 1.190558 0.656884 1.519451 0.124394 1.191107 1.225318 1.686413 0.517977 1.395642 1.256343 -0.098747 1.532037 1.044403 0.978522 1.573287 0.994934 1.946711 -0.367453 1.259056 1.292220 1.531327 0.451283 0.592779 0.641359 0.711046 0.198007 0.990565 0.746192 1.039960 -0.062670 0.073205)
     12.063356 #r(0.000000 1.124387 1.148425 1.077009 1.423246 1.454158 0.377397 0.116816 1.223497 0.805851 1.840371 0.475054 0.538543 0.730079 1.357591 -0.026639 0.553556 -0.723795 0.338462 -0.003368 1.800373 0.438787 0.356688 1.180952 1.812837 0.722623 -0.587707 0.941760 1.545941 0.389036 0.558326 0.895630 1.046280 1.758975 1.120601 1.741528 0.219958 1.181120 0.639472 1.364073 0.463498 0.216377 0.442986 -0.001743 1.468625 1.046547 0.916821 1.593206 0.526381 1.338955 1.862715 0.877679 1.369107 1.631507 1.266899 -0.215052 1.329372 0.281978 0.048082 0.785280 0.768628 0.956020 1.392470 1.204621 0.631233 1.535895 0.131857 1.192075 1.224164 1.684701 0.500264 1.375276 1.252852 -0.109159 1.538680 1.038924 0.981664 1.575269 1.030449 1.937374 -0.364520 1.280526 1.302231 1.562944 0.441438 0.578616 0.642906 0.698052 0.190738 1.003981 0.735507 1.008243 -0.057952 0.063187)
     )

;;; 95 prime --------------------------------------------------------------------------------
(vector 95 15.240 #r(0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 0 0 1)
     
     12.114676 #r(0.000000 1.049345 1.220803 1.147373 1.381621 1.355515 0.454825 -0.009436 1.057569 0.663900 1.874811 0.433507 0.556807 0.623352 1.242792 0.067786 0.465225 -0.661340 0.331985 0.032227 1.933091 0.432343 0.547379 1.107124 1.846431 0.517946 -0.547570 0.897607 1.611921 0.403112 0.647511 0.899598 0.890804 1.716130 0.996200 1.713540 0.243854 1.180551 0.688999 1.559934 0.583466 0.197293 0.600073 0.000101 1.458490 0.994760 0.956495 1.648139 0.660393 1.228976 1.774516 0.893844 1.390831 1.720570 1.135089 -0.091470 1.277862 0.255881 0.036343 0.799886 0.761090 0.891306 1.295964 1.096543 0.475861 1.537136 0.091181 1.218377 1.140426 1.690539 0.527790 1.400945 1.266740 -0.072678 1.541904 1.035302 1.038433 1.493972 1.075712 0.036991 -0.268077 1.190854 1.324282 1.468048 0.376266 0.545926 0.611626 0.692246 0.190910 0.902204 0.677044 1.063647 0.021187 0.238133 0.189775)
     12.102996 #r(0.000000 1.053379 1.217949 1.137927 1.384535 1.349778 0.463558 -0.010260 1.057532 0.665445 1.866856 0.427071 0.563187 0.615086 1.243285 0.062201 0.467234 -0.670352 0.336199 0.037536 1.926620 0.433348 0.553630 1.106915 1.851706 0.523846 -0.543537 0.899573 1.614386 0.420495 0.636659 0.901650 0.889715 1.718336 0.994182 1.714253 0.246933 1.187179 0.699574 1.575128 0.583206 0.192622 0.596446 0.003876 1.473130 0.995421 0.966459 1.639275 0.657013 1.231103 1.782317 0.885694 1.385326 1.727412 1.135182 -0.098770 1.292439 0.252373 0.026356 0.801416 0.763298 0.894370 1.292631 1.102167 0.473381 1.536082 0.105048 1.220848 1.133560 1.695717 0.532931 1.401250 1.266569 -0.071853 1.548314 1.031492 1.038241 1.503020 1.084476 0.038588 -0.266750 1.196314 1.329340 1.458468 0.372373 0.553066 0.604708 0.697990 0.197544 0.902523 0.679295 1.069238 0.016864 0.231698 0.198931)
     )

;;; 96 prime --------------------------------------------------------------------------------
(vector 96 15.135 #r(0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 0)

	12.292710 #r(0.000000 0.988646 1.162429 1.171314 1.353255 1.405759 0.327802 0.036207 1.152154 0.760541 1.790856 0.433527 0.499858 0.656756 1.296573 0.100791 0.476489 -0.653216 0.158372 -0.037710 1.892726 0.409386 0.436140 1.049351 1.766476 0.708019 -0.505881 0.843836 1.661627 0.229932 0.569810 0.855526 0.889991 1.754840 1.079009 1.690629 0.282542 1.176826 0.695771 1.456983 0.462708 0.168189 0.469857 -0.027597 1.521311 1.099282 0.982686 1.576751 0.669770 1.287335 1.818933 0.859497 1.442403 1.798895 1.290873 -0.254434 1.216440 0.266504 0.064071 0.816920 0.860902 0.922870 1.417663 1.159681 0.595958 1.424400 0.223626 1.172296 1.139585 1.606147 0.520047 1.392856 1.257846 -0.113917 1.518583 1.050121 0.979442 1.573289 0.984941 0.063610 -0.290095 1.277068 1.272139 1.596596 0.361931 0.600022 0.601776 0.740696 0.153344 0.997841 0.670149 1.019583 -0.020870 0.222109 0.072606 -0.120463)
	12.284416 #r(0.000000 0.985176 1.161564 1.176347 1.353504 1.404109 0.330233 0.031792 1.150619 0.758888 1.789204 0.432717 0.497069 0.654441 1.292635 0.101896 0.478444 -0.652485 0.154110 -0.040109 1.893719 0.409680 0.436978 1.043297 1.763501 0.711778 -0.506535 0.844419 1.654050 0.227802 0.567302 0.855167 0.890860 1.752121 1.077239 1.686073 0.279934 1.180661 0.698275 1.454983 0.465316 0.170199 0.476329 -0.031009 1.526687 1.099252 0.981217 1.572027 0.670966 1.291176 1.817470 0.861791 1.441336 1.801757 1.289745 -0.255254 1.214358 0.275328 0.059616 0.816537 0.855662 0.921220 1.414814 1.162892 0.597217 1.419677 0.225472 1.173480 1.136986 1.606084 0.518822 1.386403 1.257137 -0.111261 1.518707 1.049913 0.978737 1.568781 0.991568 0.062369 -0.286584 1.278245 1.268444 1.597763 0.356563 0.599967 0.593619 0.741471 0.149387 0.994201 0.665222 1.019552 -0.014253 0.225160 0.077905 -0.118814)
     )

;;; 97 prime --------------------------------------------------------------------------------
(vector 97 15.404807595571 #r(0 0 0 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1)     

	12.398175 #r(0.000000 0.974270 1.133417 1.101751 1.279979 1.359434 0.467927 0.007144 1.127487 0.748820 1.781756 0.396487 0.493733 0.688975 1.203401 0.019970 0.359263 -0.697201 0.166440 -0.073865 1.841340 0.479438 0.471569 1.120468 1.818011 0.722611 -0.578854 0.797365 1.619794 0.192675 0.470320 0.880530 0.894647 1.773867 1.129911 1.684306 0.298114 1.192448 0.753562 1.463120 0.415850 0.230519 0.523840 -0.047429 1.497367 1.045637 0.968082 1.645436 0.623475 1.314407 1.792633 0.841218 1.383624 1.923347 1.362714 -0.210443 1.197651 0.311815 0.117464 0.802332 0.840490 0.962756 1.351153 1.154240 0.658169 1.483444 0.257624 1.139948 1.196778 1.594898 0.489729 1.391360 1.298495 -0.114146 1.474319 1.038981 0.962592 1.548377 0.947581 0.030073 -0.290725 1.335845 1.310097 1.567936 0.325931 0.520450 0.493969 0.704044 0.140441 0.974535 0.754580 0.981153 0.043144 0.213245 0.187923 -0.104791 0.154449)
	12.384667 #r(0.000000 0.975695 1.127420 1.110615 1.276733 1.357962 0.468780 0.006023 1.133530 0.748870 1.783033 0.394659 0.490197 0.687751 1.198827 0.018181 0.361788 -0.697109 0.167360 -0.074347 1.844514 0.476805 0.473376 1.120668 1.821321 0.727898 -0.574279 0.787062 1.620139 0.188988 0.467305 0.880062 0.892789 1.776936 1.130816 1.681262 0.303760 1.191683 0.751533 1.461366 0.416577 0.235098 0.525676 -0.047645 1.493738 1.041953 0.963083 1.650264 0.624410 1.316609 1.793613 0.840558 1.389176 1.922817 1.370939 -0.210985 1.197880 0.319285 0.117836 0.799359 0.840660 0.959676 1.348326 1.152326 0.660424 1.483420 0.261589 1.140378 1.196884 1.598862 0.483134 1.393420 1.302113 -0.116172 1.469354 1.035497 0.962804 1.549389 0.943060 0.022640 -0.292031 1.338600 1.303534 1.569685 0.327654 0.516548 0.490864 0.713692 0.139053 0.968173 0.762721 0.984191 0.050836 0.216294 0.195699 -0.108283 0.164812)
     )

;;; 98 prime --------------------------------------------------------------------------------
(vector 98 15.435913738557 #r(0 0 0 0 1 1 1 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0)

	12.554819 #r(0.000000 0.994754 1.201978 1.095875 1.228090 1.349063 0.520404 -0.005278 1.113744 0.684830 1.821835 0.418458 0.556811 0.671609 1.340860 -0.027127 0.490888 -0.669559 0.196112 -0.069433 1.791636 0.479800 0.480819 1.161113 1.931188 0.706820 -0.575437 0.825517 1.635684 0.154310 0.437054 0.834616 0.805687 1.760916 1.041481 1.654400 0.268843 1.252679 0.716018 1.507696 0.427453 0.212559 0.610822 -0.045110 1.474585 1.069280 0.938458 1.658424 0.606033 1.274272 1.871557 0.851412 1.378375 1.849718 1.305539 -0.196977 1.250436 0.271972 0.159635 0.861188 0.835566 1.009947 1.382413 1.136755 0.601730 1.508016 0.177040 1.096731 1.112114 1.556213 0.514409 1.424495 1.306796 -0.096547 1.551938 0.983953 0.982538 1.547826 0.947292 0.070780 -0.301979 1.274952 1.268078 1.506608 0.343339 0.539960 0.515360 0.716545 0.138903 1.075775 0.830359 1.045994 0.028008 0.165284 0.183640 -0.064893 0.128193 -0.025514)
	12.539708 #r(0.000000 0.994226 1.200017 1.095819 1.228236 1.355299 0.521773 -0.002074 1.107865 0.680481 1.822134 0.418065 0.553805 0.678471 1.337266 -0.030658 0.490617 -0.664373 0.195876 -0.066120 1.790697 0.483893 0.486152 1.162937 1.932919 0.705377 -0.572332 0.821343 1.643614 0.155779 0.441217 0.827102 0.795037 1.761740 1.039029 1.652139 0.270202 1.256660 0.711567 1.510064 0.422680 0.222819 0.614144 -0.037945 1.467210 1.061048 0.929992 1.658660 0.609380 1.270920 1.872806 0.851172 1.376052 1.854914 1.306784 -0.192901 1.250581 0.271723 0.161747 0.856687 0.835383 1.015338 1.378386 1.131169 0.599779 1.507287 0.174934 1.095747 1.106842 1.550862 0.511964 1.428557 1.310593 -0.098137 1.547680 0.981641 0.986472 1.548382 0.946853 0.072684 -0.304887 1.273656 1.267872 1.507747 0.342997 0.541311 0.508477 0.719455 0.138559 1.068554 0.826665 1.045262 0.032412 0.163587 0.183832 -0.062957 0.140274 -0.027792)
     )

;;; 99 prime --------------------------------------------------------------------------------
(vector 99 15.391923904419 #r(0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0)

	12.671121 #r(0.000000 1.578825 0.666211 0.726552 1.538384 1.791570 0.099320 -0.160491 0.989473 0.596822 1.035192 0.247178 0.628445 0.721303 0.845175 1.341449 0.627742 1.157974 1.573300 1.577559 1.146243 0.642518 1.253235 0.873141 0.677674 1.983841 -0.058813 1.145842 1.258749 1.002052 1.540728 1.596826 0.319265 -0.110992 0.873225 1.001714 0.958663 0.883044 0.804615 1.392171 -0.105346 1.566142 0.586138 0.950489 1.209868 1.332589 1.087730 0.608633 0.545623 0.189852 1.681493 0.487350 0.405093 1.121113 0.988264 0.089589 1.002114 0.406924 0.857351 -0.106561 0.434389 0.315978 0.874454 0.677274 1.738995 0.126523 0.418419 -0.034288 -0.514474 0.544729 1.186629 0.091214 1.023974 0.889868 1.105258 -0.014030 1.568529 1.019817 1.384214 0.868550 0.027819 0.525808 1.447056 0.636493 0.394992 1.091277 -0.079518 0.886075 0.569418 -0.004838 1.104104 1.810908 0.227707 1.565455 0.923044 1.560572 1.031354 0.513130 1.131259)
	12.663719 #r(0.000000 1.577842 0.667142 0.727325 1.538401 1.792923 0.097855 -0.162006 0.991571 0.598181 1.033827 0.249597 0.623415 0.722785 0.842216 1.342657 0.627819 1.157418 1.571021 1.575709 1.147151 0.642254 1.250997 0.868506 0.677357 1.986386 -0.061693 1.145297 1.255589 0.998107 1.544640 1.594823 0.320406 -0.113231 0.879818 1.003302 0.959170 0.886107 0.805076 1.393380 -0.102159 1.564447 0.588178 0.951668 1.203657 1.328929 1.088697 0.608781 0.545925 0.190088 1.685573 0.484513 0.402525 1.122389 0.991200 0.087094 1.004946 0.407620 0.855360 -0.111015 0.436605 0.317924 0.877372 0.673838 1.735223 0.124953 0.421851 -0.036545 -0.516946 0.543716 1.185009 0.091727 1.024410 0.890320 1.107208 -0.019109 1.570175 1.021876 1.382970 0.869571 0.025469 0.523802 1.448280 0.638991 0.395657 1.088677 -0.081859 0.888438 0.569099 -0.003359 1.104332 1.811588 0.221741 1.566209 0.927582 1.564184 1.031663 0.509062 1.129176)
     )

;;; 100 prime --------------------------------------------------------------------------------
(vector 100 15.637986183167 #r(0 1 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 0 1 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1)

	12.716986 #r(0.000000 1.614268 0.794652 0.719356 1.522693 1.839206 0.053187 -0.216045 1.077547 0.626072 0.992447 0.258424 0.613665 0.666154 0.797791 1.297151 0.666442 1.138663 1.568655 1.598721 1.081507 0.701607 1.189990 0.875992 0.670799 0.120588 0.002798 1.147193 1.214233 0.961367 1.487074 1.498267 0.315736 -0.163747 0.892348 0.853335 0.781180 0.904959 0.815695 1.365580 -0.161311 1.770543 0.467808 0.858870 1.202500 1.263259 1.179260 0.605694 0.567979 0.170780 1.783259 0.557899 0.419137 1.246376 1.015382 0.060732 1.143789 0.421313 0.784488 -0.191174 0.582308 0.326318 0.868037 0.700245 1.775099 0.084259 0.487674 0.052341 -0.505041 0.601192 1.234546 0.060079 0.970347 0.831571 1.221404 0.028687 1.689191 1.030841 1.384017 0.852184 0.054733 0.492124 1.493372 0.743678 0.351949 0.983070 -0.060785 0.924421 0.622513 0.041911 1.106639 1.715696 0.158455 1.595681 0.922989 1.564481 1.036395 0.544443 1.152503 -0.027178)
	12.710330 #r(0.000000 1.612903 0.793605 0.722268 1.528576 1.838263 0.045630 -0.218021 1.077133 0.628536 1.001909 0.262367 0.615117 0.665501 0.800624 1.302452 0.666116 1.141449 1.570059 1.602121 1.081515 0.701889 1.190937 0.873787 0.668727 0.125356 0.007484 1.146818 1.218983 0.958964 1.485650 1.495519 0.314812 -0.161541 0.886201 0.853016 0.776644 0.906328 0.814462 1.363830 -0.164932 1.772191 0.465163 0.867387 1.203973 1.263527 1.181348 0.604412 0.569759 0.169467 1.792019 0.553683 0.421128 1.250563 1.006470 0.062791 1.141779 0.430964 0.782750 -0.195751 0.587808 0.329180 0.873200 0.704426 1.777043 0.082359 0.493763 0.054295 -0.502398 0.599881 1.230969 0.061048 0.971295 0.838181 1.224320 0.031032 1.692535 1.034335 1.381126 0.850276 0.060588 0.496582 1.500551 0.745941 0.354659 0.989256 -0.057648 0.922376 0.618307 0.040999 1.111195 1.710706 0.158062 1.602717 0.918103 1.566463 1.031029 0.547004 1.151612 -0.026497)
      )

;;; 101 prime --------------------------------------------------------------------------------
(vector 101 15.735968313601 #r(0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 1)

	12.909758 #r(0.000000 0.720714 -0.182655 1.565457 0.753622 0.130143 0.334294 1.650697 0.417832 0.048827 0.344422 1.486401 0.292931 1.799521 1.111655 1.558792 -0.221559 1.531040 0.348578 0.973695 0.761485 1.268033 0.273978 1.313895 1.704221 0.068165 0.481602 0.743938 -0.351235 -0.099468 0.085867 1.467502 0.670175 1.060411 0.557784 1.309992 0.991970 0.107757 0.556296 0.077508 1.974081 0.189947 1.303789 1.238050 0.718111 0.534076 0.252095 1.598289 1.547761 1.182866 0.464613 1.755609 0.089102 1.246032 0.080260 1.036577 0.473927 0.107892 0.368036 0.986840 0.765140 -0.036059 1.290823 0.227451 0.726294 -0.006595 0.616819 -0.359117 0.861664 1.267742 1.139832 0.077396 1.257827 0.004277 1.664182 0.904514 1.106007 1.213475 0.580481 1.709443 0.640563 0.036194 0.492519 1.274675 0.574901 0.832654 0.371185 0.344722 0.998543 0.576680 0.369414 0.177252 0.865880 0.137875 0.239059 0.486022 1.121460 0.939339 0.230403 0.470154 0.464729)

	;; 102-1
	12.654378 #r(0.000000 0.039802 1.217841 -0.018794 -0.264350 1.648606 -0.106572 1.436093 1.744759 1.197340 1.116039 0.322269 -0.319802 1.429760 1.337731 1.367755 1.294986 0.934427 1.178285 0.242928 0.397639 0.030160 0.470705 0.489509 0.721431 0.877160 0.586365 1.300090 0.056753 0.396042 0.694396 -0.123538 0.601882 1.828235 1.061453 1.208202 1.515734 1.300848 0.385739 1.295236 0.466727 1.125610 1.584167 0.360500 0.430768 1.515128 1.002486 1.429469 1.701067 0.146032 1.922601 1.668726 1.734188 0.898236 1.467655 0.751985 1.587598 0.572766 0.063367 1.242347 -0.141898 0.518327 1.188113 1.385035 1.498198 -0.400261 -0.058961 1.288706 1.366806 0.035365 1.606021 -0.052356 0.617357 0.512726 0.520602 1.405519 1.969640 -0.459289 0.438819 1.509996 1.047832 0.536024 0.230428 0.540739 1.290987 1.664498 0.615778 1.436029 1.298481 1.467348 0.158627 0.119363 1.098827 0.065055 0.380410 0.835569 0.455358 0.512707 1.391092 0.922515 1.335905)
      )

;;; 102 prime --------------------------------------------------------------------------------
(vector 102 15.374809992584 #r(0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 0 1)

	13.125163 #r(0.000000 0.284570 1.185932 0.254020 0.458026 1.777924 0.273972 0.352012 0.871247 1.673334 1.496604 0.270045 1.591827 -0.188397 0.589501 1.091682 1.741121 0.196787 0.525310 1.321393 1.205053 -0.057392 1.556520 -1.961535 1.179860 1.122770 0.814829 1.500056 -0.069946 0.070497 1.237530 1.280644 0.820936 1.402645 0.152660 1.210341 0.842206 0.369359 0.105608 0.811471 0.529059 0.041857 1.655756 0.893298 1.337926 1.496211 1.428234 0.556092 0.432069 0.925348 1.205854 1.544664 1.704644 1.229630 0.303212 1.758935 1.188278 1.467436 1.586279 1.260300 1.300112 1.011729 1.695629 1.060370 1.604385 0.957028 1.624378 0.311506 0.745336 0.578867 0.572336 1.655636 0.424967 1.250130 0.974803 1.251963 1.312562 0.463398 -0.038700 1.540879 0.156800 0.564982 0.689178 0.544052 1.778377 0.813450 0.561441 0.695184 0.270384 1.438063 0.744019 1.224468 0.148794 1.411742 1.416148 0.158444 1.282043 0.332184 1.434585 0.991269 -0.118131 -0.014118)

	;; 103-1
	12.631141 #r(0.000000 0.074843 1.219158 -0.027199 -0.254073 1.624605 -0.135701 1.453877 1.755897 1.198675 1.090421 0.272002 -0.249474 1.447439 1.360955 1.341148 1.290153 0.969167 1.135329 0.243792 0.418984 1.946250 0.601544 0.456951 0.765282 0.872982 0.576621 1.365615 0.094262 0.399525 0.677984 -0.086420 0.567433 1.780255 1.046981 1.205389 1.534885 1.234066 0.439028 1.336514 0.490354 1.104410 1.622676 0.382214 0.417306 1.496561 0.975909 1.398390 1.624475 0.141661 1.921427 1.688187 1.741843 0.901238 1.419496 0.813192 1.607447 0.585967 -0.020824 1.251511 -0.203691 0.513177 1.192285 1.326136 1.473869 -0.455142 -0.016589 1.259703 1.293519 0.048863 1.685391 -0.099881 0.662916 0.500247 0.557103 1.438861 1.941547 -0.474933 0.373608 1.542760 1.006189 0.593009 0.247793 0.539650 1.340923 1.675659 0.620550 1.469642 1.328665 1.442498 0.149610 0.049207 1.111223 0.085126 0.353623 0.826677 0.461777 0.518667 1.404379 0.899861 1.337308 0.525132)
      )

;;; 103 prime --------------------------------------------------------------------------------
(vector 103 16.296298498866 #r(0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 1 1 1)

	13.256855 #r(0.000000 0.253687 0.364122 0.283681 0.599056 0.452778 1.412525 1.578158 0.723002 1.502688 0.469327 0.823618 0.138223 0.170924 -0.041881 1.730522 0.763213 0.124296 1.756004 0.298966 0.867744 1.163387 -0.026926 0.637630 1.135341 0.124472 0.638511 0.161082 1.417534 1.311969 1.355755 0.769867 -0.015620 1.263904 0.253925 1.195956 0.435477 0.207251 1.875570 0.589212 -0.141939 1.489218 1.811390 0.546189 -0.100127 1.137591 0.512565 0.982503 0.208205 0.661546 0.459680 0.647870 0.862493 1.703684 1.626808 1.293610 1.244032 1.833651 0.313984 0.098233 0.713078 -0.030639 0.471225 0.283054 1.436428 1.697146 0.363648 0.928407 1.232119 0.232840 0.986487 -0.076225 0.058237 1.691889 0.445904 1.400974 1.534686 0.353656 1.081845 0.844988 1.752497 1.490478 0.820514 0.624503 1.244095 0.481359 1.092852 1.038822 0.122193 0.306870 1.545599 1.882053 0.840143 1.618524 0.664876 1.172112 0.425428 1.063389 1.459465 1.132826 0.707914 0.476065 0.729618)

	;; 104-1
	12.891616 #r(0.000000 0.020230 1.100455 -0.027655 -0.341498 1.573639 -0.166459 1.336909 1.614334 1.265242 1.070753 0.200336 -0.139945 1.315758 1.256048 1.330780 1.163466 0.897749 1.119686 0.362299 0.301310 1.883571 0.506864 0.431140 0.779158 0.861103 0.563763 1.317182 0.358448 0.581384 0.662511 -0.059228 0.585764 1.735705 1.134223 1.253804 1.488711 1.296145 0.401006 1.318547 0.409838 1.063168 1.784758 0.605346 0.454705 1.514331 1.036227 1.443746 1.590100 0.152638 1.937048 1.659118 1.596372 0.834928 1.202317 0.791629 1.638040 0.394481 0.036287 1.308852 -0.027851 0.483382 1.137070 1.471797 1.436021 -0.339247 1.959465 1.416371 1.274782 -0.056416 1.618621 0.073487 0.645516 0.465048 0.562814 1.499952 1.962975 -0.425202 0.177209 1.576794 1.092923 0.684292 0.216536 0.469811 1.278388 1.697283 0.494244 1.421192 1.305461 1.352595 0.145716 0.152674 1.146529 0.138563 0.239706 0.891463 0.397696 0.605319 1.317917 0.759776 1.395135 0.600443 1.308594)
      )

;;; 104 prime --------------------------------------------------------------------------------
(vector 104 15.919013023376 #r(0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 0 1)

	12.987392 #r(0.000000 0.019656 1.020820 -0.122857 -0.383416 1.743762 -0.077551 1.285344 1.556500 1.347778 1.007108 0.271391 -0.017599 1.323289 1.224441 1.254961 1.192419 0.950226 1.083964 0.356128 0.296702 1.898956 0.423819 0.431784 0.740632 0.838009 0.555934 1.287966 0.437690 0.641910 0.602950 -0.082685 0.609730 1.650999 1.107220 1.287768 1.459073 1.340092 0.368618 1.276887 0.523746 1.035407 1.951274 0.598910 0.440828 1.523180 1.064599 1.442876 1.610632 0.084831 1.933213 1.678415 1.492367 0.869607 1.168981 0.759731 1.683066 0.461763 1.964877 1.344876 -0.085783 0.568560 1.208659 1.424190 1.445388 -0.303350 1.915514 1.421848 1.165687 -0.066096 1.641117 0.068094 0.584541 0.457188 0.559162 1.501643 1.956646 -0.560037 0.043217 1.538096 1.142301 0.678432 0.239030 0.380298 1.373491 1.617773 0.449327 1.348144 1.243227 1.328890 0.139617 0.253213 1.094223 0.214901 0.235818 0.939054 0.321415 0.563100 1.348449 0.703267 1.435425 0.687968 1.242454 -0.344280)
      )

;;; 105 prime --------------------------------------------------------------------------------
(vector 105 16.038356734428 #r(0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0)

	13.058436 #r(0.000000 0.018841 0.195855 0.206420 0.065633 1.458550 0.564954 0.584050 0.255393 0.821477 0.473289 1.497087 0.488701 0.595510 1.763919 1.795152 1.020709 0.148507 1.419452 -0.190874 1.252819 -0.115417 1.572364 1.086172 1.203320 0.123978 1.519196 1.337538 1.222474 1.661628 1.792441 1.530814 0.073522 0.146382 0.880812 1.383907 1.455106 1.313842 0.612949 1.097744 0.661951 0.056058 0.292577 0.309700 1.553938 1.839317 1.798626 0.412574 -0.220475 0.391331 1.230536 1.329793 -0.061036 0.863566 1.369439 -0.108592 1.446517 1.870258 0.562986 0.909666 0.015512 0.313473 0.325423 1.421234 1.107012 0.906081 -0.185513 0.052032 0.945263 0.140137 1.151954 1.558716 1.433167 -0.154754 1.358982 -0.108152 1.794830 0.776903 1.411273 0.506284 0.746113 0.870064 0.655404 0.430773 1.492137 1.947814 1.106281 1.476409 1.624757 1.670125 1.262143 0.090556 0.017948 1.208649 1.518613 0.097884 0.893396 1.883764 0.459504 1.072858 0.258050 0.025247 0.792929 1.431035 1.911968)
      )

;;; 106 prime --------------------------------------------------------------------------------
(vector 106 15.730461834714 #r(0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1)

	13.079950 #r(0.000000 0.991683 1.667079 0.952198 -0.158134 0.908256 -0.128985 1.883696 0.540349 0.614398 0.596989 0.783975 1.428368 1.597136 0.736884 1.252068 1.305873 0.231319 1.020117 1.388373 0.377031 1.796792 1.091025 -0.916486 1.247592 1.449627 1.096507 0.594132 -0.088485 1.169711 1.329459 0.003695 0.368539 -0.180221 0.842521 1.314435 1.291992 1.272149 0.292625 1.025337 1.197144 0.687141 1.597409 1.201509 1.264866 0.210655 0.462014 0.072105 1.054043 0.490923 0.945944 1.071461 0.064888 0.965001 1.073253 1.205548 1.546442 0.256599 0.512902 -0.205146 0.188856 1.063444 0.616804 1.743279 0.914154 0.807038 1.016753 1.132350 0.990751 0.400337 1.345943 0.880688 0.534474 0.323663 1.462334 0.913980 0.240611 1.904272 0.651788 0.182999 -0.180558 -0.266742 1.405697 0.476547 1.309300 1.415664 1.075072 1.577006 1.108476 0.911007 -0.337178 0.168855 1.245061 1.768086 1.542431 1.828360 0.829179 1.275739 -0.086776 0.463079 -0.336090 0.362914 1.505253 0.753982 0.654367 1.043320)
      )

;;; 107 prime --------------------------------------------------------------------------------
(vector 107 16.2013 #r(0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1)

	13.454325 #r(0.000000 0.389504 0.200622 1.043121 0.761894 1.811391 1.013338 -0.029178 1.657156 0.071414 1.541808 1.697328 1.530731 0.828486 0.142611 0.827276 0.363623 0.731067 0.344946 0.056374 1.429426 0.761263 0.713573 1.043714 1.789986 0.913538 0.284688 1.632024 0.219315 1.596281 0.482719 0.716103 0.082813 0.889064 1.454911 -0.018694 1.031913 0.769500 1.225826 1.094301 0.011285 1.403439 1.540236 1.228421 1.198312 0.763787 1.489126 0.037842 1.393526 1.595697 1.484515 1.699381 0.910044 0.346999 1.483481 0.762896 0.323372 1.323234 0.494595 1.056252 0.710041 0.505300 0.227945 0.637730 1.459638 1.234710 0.493803 1.016315 0.230683 0.093113 0.713556 0.351744 1.777886 0.983943 0.185348 0.658457 0.665347 0.215532 0.767846 1.194595 0.781272 1.709017 0.088709 0.815194 0.381579 0.627948 1.674861 0.568794 1.433122 0.535438 1.473475 1.534920 1.207161 0.582128 0.284193 0.977855 0.959238 0.627080 0.292937 0.193644 0.627895 1.586822 1.256893 1.318535 0.663707 0.022219 1.167626)

	;; 106+1
	13.202367 #r(0.000000 1.000613 1.684756 1.030591 -0.144674 0.930087 -0.073206 1.869216 0.492462 0.667691 0.532693 0.721976 1.419258 1.577138 0.740297 1.322068 1.346534 0.154223 1.065715 1.368889 0.410182 1.822841 1.125450 -0.885511 1.290555 1.433074 1.046721 0.707499 -0.124656 1.201693 1.347393 0.018662 0.502177 -0.078873 0.756433 1.230311 1.259142 1.367069 0.315216 1.023759 1.259356 0.661168 1.411343 1.215010 1.266771 0.189892 0.505302 -0.011494 1.187732 0.519532 0.949942 1.050962 -0.019894 1.078182 0.992807 1.143414 1.633065 0.324324 0.492441 -0.218768 0.188780 0.963413 0.578702 1.692089 1.002935 0.841457 1.096611 1.231089 0.982778 0.479408 1.297577 0.816566 0.491832 0.381540 1.447787 0.924630 0.221301 1.796849 0.662118 0.111778 -0.098285 -0.205921 1.443651 0.375879 1.302820 1.419045 1.157539 1.514324 1.141534 0.934891 -0.258550 0.136149 1.293417 1.740995 1.504775 1.852338 0.849037 1.301984 -0.143638 0.497510 -0.382560 0.320355 1.490322 0.666001 0.663075 0.925267 0.075096)
      )

;;; 108 prime --------------------------------------------------------------------------------
(vector 108 16.517358779907 #r(0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1)

	13.566156 #r(0.000000 0.728699 0.665336 1.259359 0.312955 1.409197 -0.227152 1.537467 1.153791 1.627076 -0.109225 0.091841 1.196044 0.651957 1.667279 0.297872 1.708304 1.600040 1.279774 0.976975 0.859888 1.094622 0.659631 0.928550 0.001741 -0.027962 0.214582 0.238151 1.673247 1.887884 0.736064 0.892280 0.140937 0.557264 1.253347 0.704162 0.470712 1.242786 0.158371 0.301659 0.524953 1.272263 1.156799 -0.239176 0.540826 0.229025 0.331628 1.768533 0.578592 1.809543 0.717505 1.699923 1.628036 -0.006910 1.357544 -0.139327 0.574888 1.440391 0.790214 1.511908 0.799982 0.339724 0.692982 0.670833 0.340679 0.340555 1.796897 1.303289 0.258157 0.027036 0.818761 0.552085 1.636862 0.719532 0.280874 1.446822 1.675335 0.170540 0.167079 0.487215 1.068313 1.129396 0.130584 -0.078228 1.601308 0.067975 0.896148 0.221651 0.232515 0.805049 1.470867 0.339643 0.563679 1.554585 0.968287 0.574484 1.097469 1.601363 0.583017 1.789341 1.359201 1.858560 0.117486 0.025512 1.678463 -0.072670 -0.213093 1.615471)
	
	;; 107+1
	13.161718 #r(0.000000 0.987739 1.733133 1.054188 -0.119939 0.910849 0.010896 1.915591 0.510331 0.662472 0.507733 0.711187 1.421434 1.531951 0.698359 1.366502 1.433114 0.162830 1.031829 1.385260 0.380744 1.872146 1.120453 -0.900242 1.311562 1.361998 1.093182 0.717990 -0.097277 1.161510 1.367817 0.082904 0.485601 -0.064734 0.731587 1.181418 1.308157 1.250173 0.316423 1.011227 1.301355 0.644463 1.445963 1.205118 1.208647 0.244654 0.589262 -0.059634 1.176596 0.571146 1.043371 1.083159 0.006076 1.077933 0.991663 1.165270 1.605164 0.390047 0.441435 -0.106544 0.175661 1.010931 0.543321 1.751721 0.965777 0.870079 1.024670 1.181296 0.990067 0.440808 1.351390 0.806214 0.421993 0.407648 1.468845 0.828507 0.187943 1.771172 0.634836 0.107090 -0.067569 -0.177001 1.469562 0.463678 1.334677 1.387523 1.126011 1.572881 1.170585 1.010919 -0.335535 0.129689 1.331430 1.676924 1.536965 1.783188 0.838550 1.260495 -0.084649 0.463288 -0.384118 0.341860 1.494266 0.699617 0.647486 0.913118 0.121686 0.025406)
      )

;;; 109 prime --------------------------------------------------------------------------------
(vector 109 16.726722717285 #r(0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 1 1)

	13.649150 #r(0.000000 1.372685 -0.023096 0.764121 0.652451 1.161206 0.008161 0.316013 0.797732 0.714473 0.487368 1.050633 1.595865 0.070630 1.790292 1.172057 1.415647 1.153468 1.827169 0.230707 0.215213 0.858764 0.278893 1.454000 0.649000 1.487731 -0.093971 1.467452 0.578832 1.089439 0.854711 1.680527 0.623468 0.213876 1.468708 0.944679 1.289165 0.802006 0.813501 1.223343 1.569276 1.613534 0.610297 0.672562 1.232493 0.103141 1.459267 0.251097 0.877797 0.013403 1.560238 0.500350 1.399744 0.774367 0.659639 0.252122 0.824594 0.812839 0.861276 1.156805 0.833828 1.345402 0.790424 1.718416 0.402535 0.733335 1.522110 0.842132 1.600144 1.051832 -0.203657 0.911191 0.314178 0.284195 1.331343 0.434428 0.490954 1.410099 0.311769 1.658687 1.103289 1.173009 0.197955 0.613754 0.369986 0.003017 -0.302157 0.765490 1.656484 0.479210 0.563523 0.438269 0.714490 -0.012143 1.495468 -0.063161 0.479473 0.509000 1.902431 1.448189 0.587148 0.187985 1.316513 1.133117 1.008029 0.693260 0.907818 1.116038 0.394946)

	;; 108+1
	13.143741 #r(0.000000 0.981295 1.812666 1.117956 -0.185500 0.887133 -0.042123 1.869958 0.605292 0.660698 0.487240 0.624166 1.449694 1.534689 0.782613 1.451064 1.414295 0.227989 1.073340 1.379009 0.377980 1.849622 1.090582 -0.935851 1.300468 1.325519 1.018826 0.640677 -0.151618 1.157148 1.372788 0.030561 0.535214 0.003928 0.716545 1.230702 1.288510 1.214069 0.401399 1.044897 1.420969 0.699802 1.461844 1.182797 1.140031 0.222134 0.599399 -0.075721 1.205878 0.475321 1.079680 1.212881 -0.096955 1.107746 1.109769 1.169670 1.644352 0.462528 0.400247 -0.075889 0.244499 0.883273 0.555132 1.799341 1.047944 0.815280 0.989170 1.236643 1.002684 0.340197 1.339964 0.830022 0.342213 0.420385 1.313509 0.797027 0.138670 1.741420 0.612419 0.142853 -0.104009 -0.165428 1.519255 0.376528 1.265335 1.374075 1.080427 1.589793 1.292179 1.057071 -0.356737 0.109826 1.273643 1.715122 1.539078 1.804591 0.847821 1.225593 -0.104087 0.410682 -0.411370 0.366927 1.453570 0.665830 0.721383 0.960549 0.197868 0.027654 -0.001988)
      )

;;; 110 prime --------------------------------------------------------------------------------
(vector 110 16.455888332339 #r(0 1 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1)

      13.753511 #r(0.000000 0.848399 0.494893 1.537753 0.056503 1.192968 1.014976 1.000380 0.176221 0.063643 0.945853 -0.068422 1.888547 0.530097 1.932585 0.363227 0.205713 0.801411 0.700920 0.687774 0.323313 0.855436 1.706412 1.023431 1.539017 1.189953 0.005598 1.402697 1.398321 0.097413 0.650843 0.983076 -0.039672 1.076216 1.303860 0.579074 0.077434 1.403649 0.444054 1.850591 1.616413 0.004099 1.016957 0.276287 0.460935 1.424558 0.455559 1.774494 1.736742 0.257321 1.711197 0.589769 0.080807 0.068711 1.794312 0.030231 1.983460 1.792079 0.697501 1.563642 0.912299 1.306605 0.631662 1.306070 -0.020912 0.369231 0.339819 1.307905 -0.099842 0.333029 0.056818 -0.061161 0.558252 1.627518 -0.126860 1.759233 1.646547 0.826803 -0.148545 1.670003 1.989516 1.496557 0.799184 0.829408 0.352552 1.567755 1.722037 1.366413 1.337959 0.542553 0.828268 -0.090626 1.570252 0.921528 0.763668 1.791188 0.313328 1.353716 0.012540 0.577255 1.197100 -0.067959 0.264526 0.484251 0.882328 0.325360 0.489410 0.497137 1.466498 0.363086)

      ;; 109+1
      13.385857 #r(0.000000 1.005423 1.782283 1.037310 -0.213053 0.879928 -0.046517 1.873303 0.602952 0.747924 0.548631 0.551919 1.533520 1.564233 0.767686 1.439845 1.429058 0.210745 1.048360 1.272572 0.420497 1.907528 1.007798 -0.875985 1.280681 1.283565 1.002224 0.663448 -0.175829 1.191021 1.396519 0.008645 0.463633 -0.035145 0.773513 1.183723 1.280027 1.209216 0.370736 1.024088 1.346178 0.572424 1.493165 1.210957 1.190749 0.243885 0.627363 -0.093472 1.163170 0.538660 1.062757 1.203025 -0.076830 1.020755 1.065456 1.180141 1.616909 0.426164 0.442881 -0.033300 0.224949 0.880028 0.544694 1.835856 0.965989 0.842443 0.993190 1.292542 0.995849 0.354562 1.374934 0.864622 0.357717 0.414238 1.429257 0.844435 0.199497 1.704803 0.599091 0.164856 -0.041591 -0.188982 1.576927 0.379552 1.197978 1.412448 1.100509 1.573418 1.244031 1.006949 -0.394739 0.102675 1.270463 1.672535 1.525836 1.772058 0.832852 1.187053 -0.004100 0.474378 -0.431920 0.321063 1.410302 0.680526 0.673358 0.951529 0.162772 0.079611 0.022569 0.116743)
      )

;;; 111 prime --------------------------------------------------------------------------------
(vector 111 16.6662 #r(0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 1 0 0)

	13.722535 #r(0.000000 0.609754 0.477824 0.498205 -0.160828 1.311478 1.827872 1.163524 0.877088 0.528558 0.012460 0.425841 0.347225 1.111527 1.506620 1.410636 0.996952 -0.131493 1.544916 1.238729 0.920166 1.777555 1.246912 0.483008 1.025725 -0.124782 0.923160 0.448660 1.543112 1.342373 1.038202 0.935130 1.601650 0.963178 1.878258 0.588174 1.312098 0.758893 0.091784 1.903351 1.707234 0.845481 0.771218 1.534277 0.275800 0.904288 0.700394 1.584631 1.096911 0.048546 1.076681 -0.004790 1.712699 1.002701 0.028040 0.631055 0.000599 0.321247 1.728365 1.696152 0.050007 0.370978 0.617539 1.556864 1.281962 1.845086 1.923574 1.593500 1.577659 0.887043 0.956244 1.403764 1.038378 1.157002 1.529481 1.305687 0.017547 0.326930 0.654165 -0.007752 -0.267214 1.694215 0.852596 1.259529 0.832944 0.035647 0.361584 1.075053 1.075715 1.409307 1.062617 -0.201186 0.434486 -0.180399 1.188883 -0.221873 1.452975 -0.020938 0.072031 0.208492 1.474047 1.409906 0.615391 1.726165 0.685592 0.292682 1.428870 0.069915 -0.271563 0.353890 1.174756)

	;; 110+1
	13.484289 #r(0.000000 0.995043 1.654854 0.951488 -0.186960 0.850693 -0.104052 1.791806 0.632389 0.741244 0.372539 0.536429 1.585222 1.564873 0.754743 1.533715 1.436886 0.265913 1.082971 1.345237 0.422609 1.896766 1.047262 -0.941259 1.315104 1.247825 1.012008 0.626763 -0.163895 1.147771 1.361070 0.089508 0.489357 -0.001980 0.747126 1.129161 1.312043 1.244841 0.335129 1.099634 1.435470 0.558588 1.594865 1.187385 1.215330 0.231616 0.653215 -0.079848 1.147198 0.522561 1.074244 1.189158 0.024016 1.002127 1.145705 1.183921 1.636771 0.398476 0.358443 -0.058263 0.246181 0.942683 0.482681 1.823368 1.038771 0.798364 0.979012 1.260203 1.008839 0.331481 1.329527 0.889282 0.388705 0.378727 1.394091 0.860317 0.191774 1.792101 0.682065 0.246000 -0.121897 -0.155296 1.603714 0.392748 1.177859 1.362462 1.085317 1.557823 1.337471 1.045764 -0.299177 0.095852 1.207771 1.749557 1.574722 1.798042 0.795838 1.277804 -0.046897 0.399079 -0.477065 0.322241 1.436449 0.774690 0.635047 0.952898 0.197693 0.020089 0.072586 0.105711 -0.061722)
      )

;;; 112 prime --------------------------------------------------------------------------------
(vector 112 16.697049415765 #r(0 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1)

	13.804835 #r(0.000000 0.660626 0.012013 1.067055 1.731382 0.878320 0.900685 1.333334 0.681047 1.863220 1.352916 0.703854 1.515374 0.461716 0.898953 1.919840 0.286167 0.735654 -0.086197 0.617448 0.511110 1.353376 1.062165 1.636012 0.515505 1.399695 1.421287 -0.379478 0.731516 0.180102 1.567557 1.923199 -0.007316 1.368320 1.294564 0.578724 1.657029 0.985867 0.321763 1.643211 0.183594 -0.095598 1.792723 0.880687 0.335377 0.402596 1.614065 0.786600 0.590837 0.174605 0.357314 0.363837 -0.136455 0.186803 1.076928 1.936757 0.633832 1.217976 0.067642 0.078632 0.866945 1.729624 0.916168 1.228002 1.090442 0.162856 0.012895 1.357444 0.829157 1.905883 0.224325 1.392049 1.223672 1.768609 0.413025 0.871017 1.661030 1.831359 0.223665 1.475164 0.272068 0.564210 0.622152 1.113002 0.676345 -0.006078 1.737306 1.187465 0.535707 1.077110 1.810506 1.386823 0.000557 1.452387 1.030585 0.842150 -0.158625 1.174437 0.579578 -0.079023 1.196883 0.846201 0.482764 0.945473 0.701184 0.898505 0.170202 0.481114 0.605193 0.955521 -0.054086 0.358715)

	;; 111+1
	13.560854 #r(0.000000 0.996200 1.682628 0.999634 -0.183169 0.941340 -0.063380 1.872352 0.588785 0.718316 0.404204 0.564721 1.640073 1.488214 0.688322 1.540833 1.402097 0.325664 1.088557 1.271965 0.430614 -0.023931 1.082172 -0.819505 1.289052 1.272358 1.016703 0.615500 -0.063492 1.173776 1.419856 0.160057 0.471424 0.025687 0.794626 1.093604 1.347648 1.313640 0.365769 1.198433 1.539259 0.590650 1.625522 1.236869 1.255735 0.261849 0.614310 -0.133810 1.106507 0.525198 1.040282 1.242100 -0.009151 0.940124 1.120632 1.244098 1.583333 0.484225 0.270298 -0.091909 0.275038 0.915341 0.498191 1.846447 1.147765 0.805686 0.960525 1.293095 0.980148 0.249336 1.277364 0.859717 0.447170 0.347316 1.500244 0.749545 0.120155 1.639932 0.628998 0.242589 -0.052482 -0.149374 1.587211 0.461604 1.136482 1.323997 1.019660 1.587802 1.220439 1.097627 -0.381422 0.113408 1.209314 1.808025 1.585895 1.749582 0.823561 1.289475 0.074159 0.350519 -0.613785 0.308515 1.554187 0.783853 0.541355 0.955629 0.179584 0.128995 -0.001165 0.025208 -0.107472 -0.097625)
      )

;;; 113 prime --------------------------------------------------------------------------------
(vector 113 16.203890830538 #r(0 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1)

	13.613456 #r(0.000000 0.554013 -0.189590 1.040342 1.895741 0.972257 1.983763 0.925350 1.413107 1.187039 0.890581 -0.092527 0.648924 0.275297 1.034974 0.578278 1.412961 1.217860 0.290211 0.146756 1.277989 1.797973 1.243546 0.309623 0.588952 0.766281 1.732300 0.158146 0.970241 1.057713 0.155581 0.740347 -0.278224 0.813051 0.090610 1.633987 0.141253 1.362430 1.811341 0.106172 0.560908 0.975141 0.414465 1.325189 1.317848 1.670918 1.310037 0.138103 1.544695 0.427642 0.688876 1.115251 0.104011 1.249484 1.283379 -0.217415 1.248803 -0.055143 1.377781 1.794050 -0.051929 -0.190679 -0.001958 1.872135 1.015649 0.017838 -0.117121 0.829495 -0.198380 0.905735 0.272607 0.619166 1.647347 0.816228 0.007369 0.650952 0.045714 0.308454 0.434057 0.201848 1.245915 0.933121 1.619736 1.351637 0.362509 1.868147 1.070766 1.188359 0.400988 0.049686 0.087230 0.628970 0.077489 1.262876 0.220162 0.869503 1.130712 0.267514 1.396227 1.721653 1.550102 1.446927 1.155950 0.841581 0.384623 1.977430 1.631746 0.006140 0.715062 1.236385 1.051311 0.995413 0.371400)
      )

;;; 114 prime --------------------------------------------------------------------------------
(vector 114 16.442732865586 #r(0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1)

	14.166020 #r(0.000000 1.038356 0.826275 1.128674 -0.125090 1.829063 1.262013 1.160559 1.519516 1.502014 1.857796 1.525394 0.946893 1.361851 0.493317 1.621550 0.040839 0.825455 1.881008 1.165270 1.273827 0.159303 1.756090 1.393155 1.413051 0.957215 0.252091 1.226129 -0.094317 0.742943 1.002043 1.336572 1.592258 -0.082802 1.594640 0.366562 0.390860 1.427038 1.739079 0.663205 0.933325 1.484965 0.194283 0.375410 0.493300 0.605961 1.748551 0.279636 1.804517 0.357640 0.998348 0.681772 0.367098 0.467866 1.810315 1.933552 1.894370 1.189828 1.415118 1.834729 1.938426 1.415450 0.009074 1.747634 1.249287 0.770928 -0.115261 1.409451 1.246513 0.675514 1.266338 1.477875 -0.114148 0.185420 0.629532 1.098645 0.874254 0.446592 0.243371 0.516051 1.248852 0.028651 -0.007127 1.709807 1.312205 0.257361 1.279674 0.901557 0.855388 1.469222 1.328726 1.208217 1.433035 1.922664 0.274941 0.148828 0.367238 -0.254062 1.751340 0.773665 1.053171 0.567664 1.773987 1.113690 1.183578 1.066952 0.102607 0.071815 1.625657 1.255723 1.028659 0.085305 0.356288 0.418655)

	;; 113+1
	13.529505 #r(0.000000 0.609603 -0.150717 1.144620 1.885952 1.029695 -0.017328 1.023651 1.375935 1.049542 0.876959 -0.157071 0.712430 0.086142 1.092731 0.678537 1.443976 1.204147 0.360088 0.209607 1.268934 1.814390 1.230253 0.384833 0.625288 0.787682 1.706820 0.104070 0.975842 1.091508 0.162798 0.719194 -0.185681 0.851344 0.004406 1.551988 0.158850 1.400167 1.727125 0.074860 0.565161 0.958867 0.364724 1.349213 1.351889 1.679509 1.314199 0.132307 1.403589 0.369532 0.648564 1.160585 -0.009001 1.392847 1.218123 -0.146011 1.322032 -0.127699 1.286444 1.741589 -0.086769 -0.151954 0.062929 1.896116 1.063027 0.005563 -0.069693 0.819283 -0.185224 0.958608 0.217640 0.593867 1.814658 0.753485 -0.046094 0.586286 0.067659 0.127457 0.558174 0.155027 1.389478 0.905687 1.516935 1.472391 0.370204 1.903438 1.085058 1.201428 0.394426 0.093638 0.098055 0.586236 0.108735 1.290199 0.287019 0.975146 1.134274 0.275315 1.391551 1.689333 1.493530 1.402264 1.275785 0.772955 0.474442 0.009426 1.766587 0.112461 0.593436 1.228805 0.896377 1.061049 0.277890 -0.013199)
      )

;;; 115 prime --------------------------------------------------------------------------------
(vector 115 16.774665887963 #r(0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 0 1 0)

	14.106616 #r(0.000000 1.570092 0.362453 1.337474 0.264875 0.921400 0.355874 1.476538 0.382397 0.690102 0.627233 1.283297 1.585161 0.461353 0.250428 0.070613 -0.478768 0.954888 0.726879 1.251951 0.417891 0.945598 0.563852 0.084589 0.533104 0.472131 1.084144 1.608792 0.044337 1.518184 0.783171 0.484129 1.900804 -0.149622 0.399475 1.517825 0.218983 1.531509 -0.230530 0.567148 1.520162 -0.082961 1.681948 0.292123 0.756368 0.448131 1.473802 1.014666 -0.012646 1.572834 1.242744 0.425093 -0.031699 0.769537 1.112143 1.298398 0.333581 1.945824 -0.101577 1.894990 1.397266 1.272345 1.210062 1.810802 0.715502 0.534600 1.359024 1.288083 -0.103335 0.078475 0.156596 1.496646 1.076856 0.312782 0.361663 1.568537 1.496774 0.979145 1.697729 0.843520 0.130906 1.341892 0.946201 1.950539 0.684184 1.344931 0.821452 1.479748 1.308019 0.296269 1.793184 0.500147 0.839533 0.057599 0.886809 0.752434 1.587024 1.203157 1.022448 0.212093 1.492893 0.209714 0.165780 1.402030 -0.307350 0.474032 1.513784 1.517441 1.459089 1.632203 1.421380 1.032369 0.154966 0.002531 0.304007)

	;; 114+1
	13.732359 #r(0.000000 0.572178 -0.139025 0.983887 1.920434 1.123578 1.978353 0.968214 1.349051 1.117228 0.839675 -0.190533 0.694004 0.125250 1.107764 0.641260 1.405169 1.199788 0.276763 0.250348 1.204416 1.682914 1.257883 0.312057 0.695310 0.801198 1.682635 0.125698 0.950119 1.070718 0.245730 0.776193 -0.167540 0.949181 -0.042356 1.548062 0.106820 1.334788 1.742804 0.109905 0.567469 0.997715 0.375385 1.298162 1.314791 1.688434 1.235156 0.141282 1.427214 0.400188 0.631107 1.144708 -0.003109 1.362927 1.143332 -0.234998 1.276203 -0.143654 1.307422 1.689156 -0.014380 -0.262664 0.075462 1.880295 1.062640 0.101776 -0.026648 0.801460 -0.217311 0.971985 0.270988 0.672521 1.816202 0.778522 0.051104 0.549038 0.052885 0.201837 0.612616 0.180579 1.355932 0.900040 1.595492 1.482393 0.476525 1.886230 0.983641 1.114556 0.404677 0.048952 0.080076 0.569993 0.080539 1.262764 0.266797 0.946313 1.101489 0.203645 1.377876 1.725578 1.491484 1.434839 1.127583 0.826060 0.448266 0.008333 1.780636 0.098825 0.586600 1.122038 0.995066 1.017216 0.354291 0.057246 0.069092)
      )

;;; 116 prime --------------------------------------------------------------------------------
(vector 116 16.812931137234 #r(0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0)

	14.328742 #r(0.000000 0.856207 0.986788 0.751460 1.884184 1.255896 0.144210 1.208511 0.255866 1.782286 0.019244 0.566742 0.407768 -0.089210 1.344767 1.018853 -0.034882 0.530119 1.597864 0.501326 -0.230774 -0.097023 -0.000389 0.665472 1.635375 1.228232 1.206358 0.850292 0.888987 0.993112 0.654339 0.818974 0.003413 1.565831 0.042608 0.878547 0.321526 0.088958 0.292372 -0.331777 0.700821 0.894714 0.005944 -0.346944 0.114845 1.049758 0.798720 0.790858 0.117448 1.021841 0.389934 0.399103 0.195343 1.878118 1.577823 0.477002 0.256545 1.229924 -0.002011 0.133077 0.537008 0.396216 0.701816 0.985840 1.738910 0.328555 0.541523 0.876819 0.876185 0.445666 0.685165 1.594949 0.620581 -0.127456 0.921400 0.311110 1.793307 0.275641 1.366815 0.824915 0.239454 0.832837 1.417323 1.769240 0.980992 1.239944 1.591029 -0.051475 1.486421 1.525417 -0.025657 0.653170 1.313243 1.650610 1.580897 1.618532 0.633267 0.393928 1.496919 -0.276408 0.878277 0.281939 0.351152 0.468289 1.618075 1.571369 0.984717 1.909405 0.851519 1.720488 0.929949 1.296555 1.289941 0.911398 0.225491 0.695200)

	;; 115+1
	13.782751 #r(0.000000 1.670105 0.303378 1.514771 0.060477 0.906403 0.370378 1.628880 0.301098 0.717479 0.564448 1.198544 1.701046 0.489974 0.092684 0.106689 -0.600359 0.960290 0.727113 1.181333 0.468036 0.933578 0.612714 0.102105 0.439119 0.536613 0.989488 1.668598 -0.080124 1.683573 0.654250 0.599004 1.870044 -0.069895 0.298556 1.555710 0.285805 1.565873 -0.205135 0.563645 1.519179 -0.152285 1.687696 0.402404 0.955645 0.241673 1.401865 1.046960 -0.019116 1.640885 1.197901 0.505391 0.095168 0.718441 1.181463 1.406618 0.309258 1.952979 -0.107329 1.969648 1.502137 1.090118 1.043918 1.702710 0.780485 0.583772 1.473922 1.490931 -0.163373 0.133574 0.135840 1.533071 1.015158 0.398692 0.320450 1.364722 1.538313 0.970480 1.636937 0.963390 0.136800 1.340905 1.204598 0.054477 0.486418 1.417827 0.808183 1.530254 1.191144 0.320075 1.853919 0.467453 0.809752 0.120164 0.781600 0.697424 1.379599 1.216021 0.948183 0.099657 1.566373 0.116729 -0.093843 1.319423 -0.420543 0.691568 1.660724 1.496943 1.401099 1.619305 1.446415 0.867038 0.105822 0.158044 0.282349 -0.011943)
      )

;;; 117 prime --------------------------------------------------------------------------------
(vector 117 17.5997 #r(0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 1)

	14.497812 #r(0.000000 0.224426 0.992019 0.138711 1.176503 1.236445 0.315077 1.906428 0.448900 0.678218 -0.088951 0.205668 0.157937 1.760779 0.121986 1.314615 1.230068 1.510274 1.468208 1.579772 0.156575 1.223695 1.547174 0.976223 0.294979 0.682844 1.254567 0.255930 0.581609 0.421918 0.606116 0.691338 0.828316 1.627063 1.800785 0.001165 -0.086581 0.763116 0.639955 0.291470 1.735899 0.422553 0.362144 1.186351 1.590842 0.426463 0.245182 0.967296 0.891425 0.519158 0.866605 1.346855 0.815662 0.075921 1.039570 1.274467 1.634408 1.602113 1.536366 0.552713 0.810604 0.673899 0.744845 0.479678 1.304967 1.905715 1.460213 0.317282 1.748084 -0.013722 -1.881692 0.174856 -0.080552 1.785033 0.698053 0.094949 0.417990 0.698446 0.985481 1.584075 1.403772 0.388703 0.009472 1.646671 1.128281 1.234472 1.443078 1.392782 1.271405 0.499301 0.604344 -0.127230 1.264738 1.785688 0.416206 1.113044 0.215095 1.469439 0.236533 0.117496 0.271632 1.034059 1.537681 0.722701 1.631698 0.103905 0.435634 0.027785 0.196356 1.018099 1.623844 0.142536 1.403226 -0.013797 0.598011 1.913682 0.626571)

	;; 116 + 1
	13.889211 #r(0.000000 1.679442 0.299199 1.367111 0.052770 0.927297 0.328215 1.615881 0.302404 0.707696 0.516039 1.151316 1.673258 0.534217 0.190986 0.074151 -0.598397 0.913919 0.765928 1.260413 0.423264 1.023745 0.609735 0.153506 0.453539 0.468256 1.018228 1.788765 -0.068307 1.692855 0.624116 0.609141 1.910624 -0.022395 0.256365 1.514074 0.233219 1.516754 -0.154609 0.590788 1.514050 -0.043651 1.742187 0.341087 0.951970 0.371363 1.447587 1.079612 0.057107 1.623815 1.214707 0.567773 0.057804 0.791128 1.221209 1.383201 0.340554 -0.013292 -0.005609 1.947264 1.370803 1.062963 1.024336 1.739421 0.767066 0.671699 1.426918 1.511148 -0.149781 0.104225 0.061945 1.535119 0.940075 0.392689 0.259023 1.411809 1.598917 0.941897 1.683270 0.884953 0.108874 1.319701 1.100749 -0.050961 0.639728 1.429813 0.861586 1.511163 1.232212 0.240917 1.860927 0.406637 0.844627 0.125914 0.873615 0.651653 1.385473 1.135755 0.994702 0.030143 1.590457 0.161005 0.055154 1.334956 -0.459106 0.663912 1.678280 1.514956 1.365867 1.519273 1.441132 0.891112 0.176832 0.115181 0.351957 -0.175561 0.176948)
      )

;;; 118 prime --------------------------------------------------------------------------------
(vector 118 17.181785583496 #r(0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 0)

	14.497443 #r(0.000000 1.591354 0.741888 1.722967 -0.237709 0.685421 0.503550 1.254854 0.808656 0.911251 0.050157 0.861734 0.314280 1.341176 0.379991 0.875641 1.466708 0.300573 0.954767 1.385324 0.125132 0.348374 0.577011 1.655837 0.564307 0.582376 1.167510 0.907420 0.444532 0.218679 1.737312 0.252903 0.411946 1.083113 -0.185163 0.978023 -0.109963 1.511202 0.503851 1.662809 0.033875 0.523452 0.521481 0.883976 -0.357599 0.187161 0.880047 1.490736 0.844255 0.801313 0.683070 1.279258 1.624126 0.834042 1.570571 1.331665 0.812207 0.082063 -0.178779 0.727851 0.635760 0.472598 0.529740 1.710166 0.757477 0.262267 0.672628 0.403198 0.034164 -0.022037 0.130101 1.350219 1.105735 1.695932 0.323683 1.252068 0.744970 1.161905 1.322245 0.994864 0.697837 1.637816 0.396302 1.702348 -0.270747 -0.077800 0.225947 1.713037 1.228521 1.665048 1.679022 1.393803 0.704244 0.296414 -0.016270 0.947613 1.856633 1.384283 0.527416 0.984409 1.396798 0.351021 0.292270 0.549569 1.663499 0.778229 0.016680 1.156232 0.122381 0.159439 0.648535 0.193057 0.084166 -0.213455 0.477204 0.673154 0.992874 0.783540)

	;; 117+1
	13.955663 #r(0.000000 1.656893 0.312860 1.406022 0.045609 0.940726 0.323204 1.558622 0.313593 0.699110 0.536076 1.119751 1.657613 0.469730 0.215020 0.137907 -0.614064 0.902352 0.821797 1.171991 0.441310 1.059221 0.661850 0.277594 0.394536 0.546400 0.968850 1.793240 -0.073575 1.622506 0.677941 0.641837 1.952355 -0.044282 0.215122 1.490798 0.302768 1.506837 -0.235108 0.508030 1.520891 -0.097109 1.755394 0.256002 1.007243 0.327520 1.464098 1.079175 0.017892 1.590910 1.290254 0.601225 -0.032662 0.654468 1.229419 1.312262 0.353655 -0.032649 0.034883 1.896617 1.433210 1.047605 1.126390 1.674282 0.764405 0.618210 1.508232 1.671380 -0.173491 0.106521 0.149565 1.507742 0.949278 0.443666 0.317362 1.314645 1.634673 0.873102 1.588608 0.915021 0.172843 1.351037 1.151673 -0.042685 0.619993 1.550214 0.823729 1.429222 1.211772 0.248747 1.864022 0.374155 0.849134 0.123908 0.792603 0.736151 1.435290 1.198233 1.078587 0.058874 1.626102 0.122469 0.017624 1.330950 -0.499655 0.706598 1.629594 1.438050 1.370171 1.549897 1.430173 0.915025 0.119087 0.070759 0.413439 -0.125417 0.236481 -0.031842)
      )

;;; 119 prime --------------------------------------------------------------------------------
(vector 119 17.167841346875 #r(0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1)

      14.390682 #r(0.000000 1.375664 1.071878 1.242281 0.449872 0.997239 0.326902 1.844870 0.041292 1.299611 1.550408 0.729190 0.953350 0.209856 0.257680 0.853205 0.858641 1.807278 0.814295 0.490323 1.317949 0.220101 1.124178 0.689692 0.845713 1.610142 0.807190 0.053107 0.167263 1.261235 1.535767 1.158168 0.246566 1.099513 1.210170 1.481156 0.887639 1.096230 0.144442 0.446125 0.627726 -0.213400 0.869947 0.988021 1.647446 0.493250 1.672678 1.658411 -0.130924 1.196700 0.900590 0.905506 1.144054 1.144682 1.583644 1.532418 1.405419 1.861571 1.337158 1.938890 1.060547 0.949400 1.139259 1.324089 1.811791 1.700889 0.580433 -0.043873 0.685223 0.393731 1.345217 0.593893 0.307423 0.675865 1.845148 0.894101 0.377727 1.240396 0.150868 0.234381 0.772691 0.408668 1.155960 1.889975 0.784676 1.158424 1.614216 1.924591 0.178912 0.577105 0.980476 1.603643 0.495073 -0.104468 1.507041 0.927685 1.105445 1.078554 0.022413 0.000361 0.338859 1.519222 0.863311 0.615320 0.570559 1.762687 0.669024 0.026456 1.421100 1.955221 0.629611 -0.125129 1.900181 -0.021163 -0.020189 1.567842 0.924421 1.826999 0.630355)

      ;; 118+1
      14.018618 #r(0.000000 1.667367 0.322872 1.356274 0.058995 0.960979 0.391067 1.596203 0.294396 0.668831 0.482386 1.201983 1.684789 0.511518 0.202150 0.119421 -0.566103 0.969879 0.710276 1.185777 0.439002 1.081943 0.730732 0.236637 0.526675 0.480731 1.028367 1.739731 -0.138846 1.593254 0.713861 0.553938 1.957692 0.049573 0.238503 1.491899 0.251089 1.428730 -0.126673 0.452175 1.482756 -0.053077 1.780248 0.323594 0.960159 0.318559 1.403830 1.045323 0.072970 1.671965 1.340192 0.627012 0.093313 0.726626 1.260031 1.369364 0.271099 0.039064 -0.011301 1.960494 1.463622 1.056374 1.121811 1.627859 0.817517 0.663209 1.409881 1.612732 -0.152806 0.038886 0.274896 1.521348 0.915556 0.404329 0.221685 1.199737 1.694611 0.915335 1.572323 0.961485 0.112089 1.311173 1.127868 -0.177640 0.609597 1.415894 0.807680 1.506084 1.239635 0.162405 1.866700 0.317949 0.857946 0.112683 0.879435 0.694750 1.339170 1.270491 1.111213 0.092592 1.497893 0.151420 0.069449 1.319832 -0.496262 0.680555 1.680836 1.536147 1.322680 1.555058 1.410956 0.888418 0.228998 0.018175 0.403145 -0.128572 0.219741 -0.075154 -0.155224)
      )

;;; 120 prime --------------------------------------------------------------------------------
(vector 120 17.067 #r(0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0)

	14.458666 #r(0.000000 1.293108 0.698019 1.317447 0.029496 0.078825 1.245576 0.933427 0.917420 1.172126 0.357395 1.156156 0.879865 0.129592 1.181392 0.882110 0.690853 1.687107 0.025873 0.234607 1.243328 0.528035 0.272217 0.646247 0.920540 -0.212257 1.217024 1.877596 1.938817 0.737497 0.901785 1.059044 1.128268 0.954000 0.339889 0.097863 -0.055556 1.539115 0.342970 1.531145 0.894486 1.025619 0.519579 0.900743 0.956748 -0.133937 0.256714 0.139176 0.495069 1.185608 1.684763 0.822374 0.580038 0.873037 1.366028 1.356196 1.900731 0.458911 0.428437 1.433784 -0.025135 1.471236 0.210352 1.314750 0.475084 0.493167 0.205827 0.317580 1.227052 1.530659 1.302191 0.347571 0.409940 0.502737 1.688087 1.230409 1.337757 1.342952 1.903513 0.955786 -0.215055 0.487009 1.948923 1.411678 0.225274 0.421106 0.203875 0.568136 0.977570 1.560054 1.164692 1.211841 0.037236 1.165323 0.284280 0.274360 0.776762 0.207157 -0.008462 -0.022949 0.633618 1.519303 0.349119 1.348337 0.561608 1.136896 0.486384 1.690665 0.939858 1.037942 0.628883 1.115783 0.551269 0.261357 0.835768 0.754522 0.995311 0.736018 1.536035 -0.082119)
	
	;; 119+1
	14.042466 #r(0.000000 1.695702 0.296711 1.338908 -0.078265 1.044647 0.445401 1.570773 0.356080 0.726875 0.562835 1.121698 1.696368 0.511401 0.207025 0.089500 -0.565140 0.942644 0.652808 1.167682 0.412919 0.987661 0.705879 0.198820 0.440865 0.512441 1.083421 1.751114 -0.069762 1.661970 0.763824 0.509555 1.981466 0.038582 0.269865 1.492095 0.267412 1.351405 -0.147933 0.429115 1.485596 -0.131353 1.737203 0.373649 0.934842 0.295981 1.401570 1.025505 0.159868 1.751013 1.267064 0.606930 0.033477 0.655345 1.307003 1.298431 0.292781 -0.055933 0.016301 1.947579 1.426247 1.012103 1.014686 1.610683 0.794183 0.636102 1.398468 1.630487 -0.106933 0.019245 0.234173 1.454561 0.871538 0.489427 0.182807 1.191314 1.653186 0.812730 1.596587 0.968349 0.144419 1.254337 1.168160 -0.201543 0.642098 1.430541 0.891933 1.544951 1.231299 0.070309 1.961946 0.325740 0.895972 0.097452 0.983847 0.726652 1.390398 1.237569 1.108864 0.162933 1.463000 0.108857 0.104118 1.340850 -0.457424 0.750886 1.757915 1.530952 1.370214 1.508778 1.434766 0.846018 0.114800 0.004043 0.307829 -0.143116 0.279204 -0.090078 -0.107619 0.067028)
      )

;;; 121 prime --------------------------------------------------------------------------------
(vector 121 17.782977183017 #r(0 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 0 1 0 1 0 0)

      14.145310 #r(0.000000 -0.025891 1.793636 0.033424 0.540007 1.698366 1.937124 -0.609559 0.386368 0.372251 1.167122 0.009884 1.449702 0.151646 0.129257 0.221923 0.286263 0.194141 1.256596 -0.022208 0.587239 1.364223 1.036771 0.840539 0.300738 0.487086 1.849878 -0.356013 -0.244608 -0.042719 1.244769 1.401449 0.301842 1.027056 1.091793 0.623370 1.184562 0.517907 0.649838 0.331082 0.619154 1.467356 0.525086 0.836576 0.132708 0.186394 1.646954 1.207107 -0.124102 1.434383 0.438192 1.403615 1.086842 1.456374 0.098749 0.654033 1.469902 -0.092397 0.999549 0.914715 1.334656 0.842194 0.762721 1.400578 1.518574 1.628966 0.557815 0.576931 -0.575198 0.632751 1.009717 1.185394 -0.060402 1.274789 1.032399 -0.216393 1.814193 1.597562 0.558478 0.044897 1.319287 0.285577 -0.020660 1.082584 0.821657 1.849151 0.241943 0.297525 1.569624 1.593287 0.604518 1.347238 0.159734 0.361474 0.136103 1.298636 0.140131 1.192829 1.398339 0.674275 0.995843 0.943454 0.693721 0.589259 1.642401 1.051611 -0.266130 0.115428 0.439245 0.514540 1.691776 1.063362 0.306592 0.883309 1.563638 -0.186910 0.971866 0.448146 0.177042 1.080065 0.466207)
      )

;;; 122 prime --------------------------------------------------------------------------------
(vector 122 17.876078447724 #r(0 1 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 1)

	14.809716 #r(0.000000 0.670494 1.886159 1.577487 1.777777 0.820522 0.567040 1.808673 1.691383 1.749354 0.999669 0.365962 -0.283305 1.315547 1.858625 0.083801 0.099076 1.593409 0.962399 0.938500 1.204685 1.174037 0.436114 0.616669 1.449802 0.424694 -0.043743 0.290754 0.536765 1.858591 1.302286 0.144562 1.898540 1.713336 0.304273 0.606056 -0.343580 1.320384 1.725243 1.070484 1.043894 1.041218 1.783423 1.623935 -0.119894 0.812509 0.330462 0.830339 1.651746 1.473863 0.826929 0.035844 0.962490 1.154392 0.108692 0.207697 -0.125372 0.785657 0.181654 0.507958 -0.099870 0.817795 0.576379 1.616959 1.203159 1.408060 0.803943 1.042280 0.347552 1.737313 1.151753 0.038129 1.376834 1.472899 0.308707 -0.055847 1.688664 1.527458 1.503192 0.428260 1.398802 0.697613 0.797253 1.257898 1.721624 0.405578 1.003490 0.227680 1.041522 0.134919 1.342074 1.464937 0.605066 -0.038087 1.389658 0.040933 0.121007 0.729584 0.212582 0.373515 1.668140 -0.235335 0.732650 0.289389 1.049347 -0.077662 0.429686 0.147005 1.585407 1.353860 1.815248 1.314972 0.285783 1.787337 1.040122 0.959573 1.461408 0.006176 1.591906 -0.004243 1.203878 1.856838)

	;; from 121+1
	14.077769 #r(0.000000 -0.102882 1.749236 -0.004117 0.483853 1.765874 1.938255 -0.600392 0.405831 0.339694 1.084448 1.949979 1.449950 0.179825 0.196465 0.250508 0.230057 0.267538 1.186702 -0.013547 0.609348 1.275263 1.002412 0.929479 0.351264 0.550827 1.866085 -0.207369 -0.221459 -0.043981 1.181650 1.372732 0.322165 0.950666 1.016902 0.608561 1.206924 0.503654 0.566235 0.334378 0.545128 1.400875 0.599963 0.865496 0.228459 0.195440 1.563459 1.162224 -0.092823 1.463200 0.340144 1.432985 0.949791 1.498279 0.068471 0.623276 1.392543 -0.178909 0.913012 0.880422 1.353490 0.813253 0.747974 1.430440 1.480413 1.631261 0.640181 0.621156 -0.581884 0.645199 1.046241 1.177765 0.048757 1.254481 1.019786 -0.266200 1.761071 1.575419 0.546658 -0.000712 1.213661 0.352510 -0.036380 1.089333 0.735910 1.940744 0.321816 0.327061 1.683870 1.638125 0.601090 1.278317 0.270163 0.360522 0.023473 1.250704 0.243204 1.199993 1.329172 0.588810 0.966119 0.939463 0.761317 0.553614 1.599868 1.062777 -0.228048 0.241966 0.388550 0.647592 1.729999 1.118550 0.325131 0.887699 1.516026 -0.170170 1.006043 0.421332 0.259983 1.062250 0.497913 0.166635)
      )

;;; 123 prime --------------------------------------------------------------------------------
(vector 123 17.273 #r(0 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 0 0)

      14.606318 #r(0.000000 0.018375 0.589471 0.983384 0.991984 0.372395 -0.040275 0.299423 1.756771 0.367581 1.925315 0.431987 -0.091930 1.365768 0.790238 1.730935 1.453895 0.945086 0.541022 0.665855 -0.133333 1.898784 1.614955 0.125913 -0.075642 1.042483 1.409785 1.598074 0.355453 1.697472 1.704234 0.447761 0.702787 1.037349 1.268895 1.641450 0.389018 0.691038 0.964549 0.799007 -0.028923 0.682141 1.218121 0.346438 0.248506 0.187480 1.166792 0.799601 1.529262 1.053370 1.663430 1.815223 1.438810 1.297963 0.281072 0.228128 0.996820 1.126305 0.635366 1.152238 1.612305 0.687034 0.492102 0.223406 1.290673 0.404319 0.673144 1.585101 1.003033 0.671106 0.630415 0.262596 -0.092794 0.970586 -0.143151 1.120737 0.513895 1.346570 0.209142 0.468700 0.483816 0.465304 -0.188333 0.812984 1.400518 1.773921 1.423889 0.414054 -0.317948 0.988906 0.349734 -0.120165 0.609604 -0.196752 0.649574 0.752742 0.402866 1.001890 0.667657 -0.097642 -0.022329 0.780061 0.422052 0.637506 0.933615 0.491032 1.329969 0.891484 0.826863 0.432342 1.071482 1.483913 0.545228 0.886707 1.473772 1.459843 1.911936 0.601733 -0.070730 1.820410 1.529051 0.044995 0.589246)

      ;; 122+1
      14.218431 #r(0.000000 -0.071277 1.809148 -0.020616 0.407111 1.755823 1.904945 -0.715971 0.341233 0.449964 1.085208 0.031030 1.532200 0.268807 0.148267 0.268084 0.272209 0.202242 1.223891 -0.064002 0.629461 1.331632 1.050525 0.887285 0.370000 0.565442 1.910419 -0.226719 -0.262129 -0.049320 1.111879 1.377442 0.321129 0.921437 0.982936 0.703155 1.229920 0.446816 0.492798 0.314076 0.541522 1.414758 0.522185 0.801174 0.218712 0.168371 1.631951 1.208384 -0.085808 1.408101 0.423643 1.324899 0.982011 1.466628 0.095538 0.635570 1.314596 -0.072617 1.020892 0.911989 1.330565 0.770391 0.725410 1.510974 1.479974 1.759621 0.639552 0.614948 -0.510015 0.641435 0.965296 1.113277 0.074254 1.206499 1.003706 -0.366482 1.772703 1.570225 0.592942 0.091270 1.226107 0.311704 0.007633 0.964361 0.718780 1.974845 0.242071 0.343141 1.709800 1.693786 0.483738 1.265900 0.338851 0.340533 0.047929 1.263159 0.240281 1.186223 1.427920 0.613439 0.969107 0.960914 0.712662 0.596951 1.686986 1.021249 -0.262802 0.214377 0.402786 0.561682 1.740484 1.058116 0.341115 0.933358 1.469760 -0.231395 1.023135 0.404403 0.200269 1.060708 0.484072 0.072981 0.045518)
      )

;;; 124 prime --------------------------------------------------------------------------------
(vector 124 17.868420183527 #r(0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 0 1 1 0 0 1)

	14.790618 #r(0.000000 1.222162 0.999539 1.142487 1.505674 0.123191 1.078191 1.428308 0.398665 0.193203 0.342797 1.160548 0.272137 0.744922 1.397108 1.629980 0.516700 0.161533 1.540757 0.951466 1.306414 1.131481 0.340080 0.022600 1.902411 0.678905 -0.266096 0.618248 -0.195173 1.348860 1.656222 0.843246 1.086674 0.610041 0.732222 1.576567 -0.001222 1.325305 -0.206092 0.061466 0.937472 0.938375 0.951723 1.351728 0.822770 1.101763 0.749753 0.602996 1.016336 0.240295 1.282512 0.877283 1.675716 1.308583 0.020424 0.112525 1.125186 0.567562 1.325344 0.286941 1.392684 1.457107 1.070715 1.116929 0.019425 1.553921 0.611895 0.374394 1.517480 0.357614 0.351325 1.265831 1.671035 0.028656 0.694185 0.608779 0.968580 0.705917 0.557377 -0.050792 0.760543 1.517363 0.410154 1.478833 1.629314 1.203011 0.602580 1.412252 0.251943 1.776030 1.689098 1.335837 1.695826 1.914988 1.139727 1.661355 -0.008029 1.815582 0.952555 0.813836 0.589787 1.222025 1.184138 0.133013 1.235368 -0.243658 1.554911 0.580687 0.939871 0.323060 0.942785 1.574937 1.605974 1.858030 0.079942 -0.197497 0.010513 0.448075 -0.013192 0.950902 1.198378 1.685266 1.111201 1.137042)
	
	;; 123+1
	14.279834 #r(0.000000 -0.081380 1.782165 -0.062634 0.363611 1.777729 1.870086 -0.748456 0.397000 0.457689 1.108119 0.004930 1.540452 0.247288 0.180358 0.333199 0.182296 0.178249 1.230554 -0.108533 0.646062 1.305622 0.825072 0.858877 0.381906 0.623442 1.836712 -0.249134 -0.191182 -0.125952 1.112553 1.374523 0.342721 0.833331 0.944734 0.720943 1.282090 0.390216 0.453997 0.358637 0.493600 1.372859 0.624272 0.735874 0.299299 0.184937 1.617155 1.281616 -0.070863 1.469387 0.307926 1.334541 0.930607 1.487203 0.131059 0.597353 1.290211 -0.242352 1.036453 0.942866 1.246650 0.636276 0.826032 1.531105 1.485955 1.813085 0.625741 0.627771 -0.579465 0.642188 0.969289 1.138476 0.074565 1.189823 0.939892 -0.416570 1.739435 1.565378 0.588268 0.099664 1.234765 0.379725 -0.063217 0.934469 0.845969 1.930710 0.181988 0.295750 1.696778 1.677311 0.505493 1.249700 0.433102 0.439581 0.020795 1.231023 0.285770 1.217649 1.421529 0.551828 0.924619 0.972048 0.789871 0.556108 1.717849 1.016229 -0.325643 0.376556 0.293594 0.487260 1.648794 1.072609 0.281420 0.961161 1.519437 -0.241812 1.031705 0.425825 0.197195 1.096632 0.361878 0.106170 -0.074233 0.005979)
      )

;;; 125 prime --------------------------------------------------------------------------------
(vector 125 17.637776156888 #r(0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 0 1 1 1)

      14.772411 #r(0.000000 1.488367 0.539453 0.636319 1.701536 0.864646 0.653079 -0.015234 -0.146959 -0.016393 1.159310 0.253720 0.483376 0.791134 0.148523 1.139178 0.651015 0.419622 1.011424 1.343222 0.375202 1.487445 1.136349 1.264222 1.195821 1.118452 0.058438 0.180283 -0.364874 1.141390 0.108460 0.432578 1.082489 -0.344327 0.561149 -0.050777 0.153514 0.046289 0.013379 0.201861 0.723817 0.636257 0.099730 -0.252366 1.579710 1.247947 0.727318 0.604484 0.768675 1.814508 0.866882 0.945446 1.203952 0.553202 1.570818 0.438899 1.210503 0.074303 1.805294 1.142851 0.477720 0.743449 -0.030259 0.761798 0.442190 0.180723 0.743309 -0.143585 1.116545 1.404371 0.204979 0.238499 1.331119 1.234638 1.176686 1.242725 0.433339 0.737611 -0.052694 0.108421 1.540317 0.211091 1.637087 0.618282 0.999958 1.643481 0.805826 1.863967 0.824505 0.797379 0.836059 -0.009548 1.065334 1.608230 -0.042496 0.454917 0.581669 0.915626 0.146732 0.685151 0.520442 1.115897 0.367688 0.129909 1.145807 0.921815 0.252576 -0.010734 0.180757 1.854774 0.546533 1.532747 1.382619 0.143523 0.214257 0.954384 0.657013 1.826584 1.432640 0.172761 -0.181378 1.290872 1.519863 0.506886 0.104986)

      ;; 124+1
      14.335616 #r(0.000000 -0.073704 1.756721 -0.027521 0.555274 1.787030 1.851198 -0.739687 0.444117 0.371512 1.030097 0.041170 1.545538 0.189519 0.163161 0.279241 0.173564 0.127795 1.239047 -0.127708 0.674274 1.329026 0.927305 0.921971 0.291034 0.575583 1.919448 -0.265928 -0.189299 -0.242314 1.071327 1.320148 0.401414 0.885029 1.046562 0.775451 1.215839 0.374013 0.421290 0.242139 0.417910 1.413086 0.643233 0.744664 0.179383 0.219870 1.572661 1.345306 -0.060756 1.371806 0.318705 1.344767 0.903717 1.446972 0.029587 0.642047 1.254548 -0.199918 1.025990 0.987502 1.268140 0.763438 0.716412 1.540475 1.448750 1.854247 0.619685 0.691226 -0.557884 0.607847 0.974173 1.151524 -0.000158 1.208581 0.923167 -0.344361 1.808080 1.613014 0.625897 0.097908 1.229154 0.352252 -0.000924 0.978476 0.892610 1.915124 0.237884 0.295218 1.727938 1.672743 0.433468 1.238004 0.487776 0.417610 0.023342 1.153124 0.251246 1.196960 1.459291 0.552975 0.974914 0.953186 0.742186 0.557329 1.742338 1.006012 -0.331621 0.294231 0.321006 0.465332 1.742325 1.134043 0.251983 0.900167 1.477710 -0.206427 1.075443 0.425293 0.211597 1.112385 0.321994 0.162492 -0.098661 0.047474 0.072546)
      )

;;; 126 prime --------------------------------------------------------------------------------
(vector 126 18.284595039843 #r(0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1)

      14.919977 #r(0.000000 1.469803 0.590807 0.764079 1.791170 0.333377 0.787711 1.497688 1.425800 1.198769 -0.142602 1.315353 -0.073058 1.238142 -0.046252 1.358363 0.881227 0.034517 0.376307 0.332870 0.693500 1.217503 0.199404 -0.446423 0.007791 1.544042 1.693684 1.705920 0.539256 1.329303 -0.184478 1.516336 1.012314 1.494800 1.597619 0.336783 1.080235 0.583130 1.276101 1.725256 0.652789 1.276830 1.460138 1.593259 0.514539 1.170620 1.278633 0.619783 1.325249 1.591358 0.207365 1.060129 0.815013 0.040269 1.468914 0.227402 0.515366 0.731820 0.621073 0.837063 1.275146 0.259307 0.585385 0.909317 0.921047 0.261764 0.230595 1.268807 1.340737 0.628738 0.406147 1.678580 0.814730 0.487283 1.140440 0.869819 1.474812 0.775855 -0.116531 0.130586 0.641169 1.517310 1.370799 1.423659 0.321563 0.178649 1.411675 1.146911 0.966764 1.521079 1.121859 -0.427787 0.506332 1.644605 1.138614 1.523684 0.664505 0.648038 0.075277 0.416802 0.443365 1.235830 1.173282 1.107298 0.136026 -0.032457 1.449977 -0.023926 1.087880 -0.136228 1.342249 1.136201 1.846662 0.865407 0.833970 1.810099 1.018847 -0.107251 0.065627 1.367299 0.507024 0.142912 1.416639 0.609252 0.711456 0.417251)

      ;; 127 - 1
      14.478183 #r(0.000000 0.930861 1.435103 1.015217 0.133148 0.287358 1.954448 0.877191 -0.313979 0.188033 1.404924 0.797822 1.641089 -0.072460 0.883498 1.253629 0.955039 1.649989 1.112182 0.909200 1.887346 0.566087 0.831325 1.595619 1.015259 1.132981 1.214225 1.758075 1.475152 1.620993 0.072446 -0.059078 -0.182289 -0.039338 0.155445 0.529297 0.046388 1.441668 0.535178 0.222607 0.659275 1.874433 0.311495 1.718719 0.434358 1.778879 1.619012 0.517997 0.354459 -0.261087 0.248995 1.922764 0.605114 1.052457 -0.265751 1.118974 0.375392 1.608325 1.902594 0.729575 1.283255 1.305350 0.868120 1.355763 1.680987 0.242830 0.477218 1.016250 0.628871 -0.030446 0.679211 1.826138 1.874720 1.129680 1.690954 1.195384 0.889438 1.205646 1.461460 -0.453690 0.712708 1.258870 1.879622 1.875344 1.343716 1.283838 0.647289 0.933542 0.025722 -0.304513 0.859639 0.850257 0.333502 1.942927 1.798084 1.335700 0.932797 0.281618 -0.061736 1.117606 1.074494 0.424155 0.429073 1.579564 1.707609 0.889204 0.016152 1.499631 0.327239 1.110073 0.816898 0.676932 0.517090 0.873228 0.943685 1.557236 1.328668 0.393069 1.595818 0.801812 0.427544 0.632088 1.930520 1.052145 0.001869 0.373834)
      )

;;; 127 prime --------------------------------------------------------------------------------
(vector 127 18.198689419357 #r(0 0 0 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1)

	14.912432 #r(0.000000 -0.112564 0.330831 0.563931 0.720452 1.659462 1.770279 1.222445 1.859857 0.126001 0.651461 1.215294 -0.233033 0.427403 0.814844 0.606037 1.919973 0.930971 0.148326 0.698675 1.110446 0.338577 1.107127 0.863142 1.130521 0.352666 0.715295 1.098761 0.639947 1.470989 0.137887 1.186298 0.901174 1.895291 0.359770 0.973168 1.699946 0.771080 1.375904 -0.248826 1.181644 1.789978 0.712701 0.277767 1.875124 0.813518 1.712932 0.451921 0.276945 1.323596 1.302350 1.483287 1.090079 0.743389 1.264854 1.950370 0.782969 0.914279 0.320477 0.990740 0.622004 0.030993 0.934242 0.961767 0.268688 1.789126 0.206081 0.101936 -0.529878 1.903369 0.539774 1.823204 -0.147241 0.928082 0.776302 1.167127 1.638509 1.576221 0.666141 0.750484 0.892326 0.100670 1.158426 0.166814 1.186903 1.306719 1.235546 0.635532 0.425679 1.719459 0.863874 0.092801 1.266262 1.369621 1.347298 0.966081 0.206817 0.754899 1.254971 0.922627 0.087389 0.135770 0.821247 0.230310 1.412479 0.655130 0.149628 1.814319 1.923709 1.016259 0.975859 0.575686 1.520455 1.205512 0.978744 1.845650 0.833521 0.220528 0.380346 0.141961 -0.028883 0.515081 0.897680 0.876651 0.794347 1.289685 0.792317)

	;; 128-1
	14.536393 #r(0.000000 0.910972 1.475131 1.009861 0.062727 0.222323 1.938743 0.836711 -0.379271 0.255108 1.367947 0.841274 1.648864 0.015930 0.884691 1.125991 0.989606 1.607929 1.107388 0.857011 1.831346 0.433218 0.833149 1.592445 1.050762 1.008151 1.363530 1.700977 1.491038 1.682961 0.086100 -0.103806 -0.179348 0.003896 0.165438 0.493687 0.089620 1.387284 0.581547 0.176309 0.705269 1.811651 0.301490 1.707605 0.333845 1.832817 1.652148 0.600871 0.309714 -0.231587 0.303261 1.879368 0.673797 1.138199 -0.287759 1.071255 0.390644 1.597999 1.895638 0.729896 1.280128 1.313792 0.920129 1.387655 1.675038 0.226144 0.498585 1.104083 0.607578 0.005976 0.644124 1.859066 1.816208 1.159654 1.721231 1.377183 0.892151 1.087634 1.544878 -0.427006 0.761009 1.308993 1.890672 1.804683 1.325584 1.333615 0.649826 0.878906 0.043600 -0.222822 0.983855 0.725901 0.429955 1.892651 1.820617 1.395993 0.939478 0.246907 -0.065788 1.167118 1.004041 0.432075 0.450312 1.618752 1.686873 0.868341 1.893872 1.401676 0.376204 1.113598 0.748962 0.732995 0.557016 0.919800 0.871855 1.529811 1.275389 0.387399 1.586418 0.758929 0.456983 0.576267 1.810711 1.106484 0.012213 0.311973 1.081248)
      )

;;; 128 prime --------------------------------------------------------------------------------
(vector 128 18.276384353638 #r(0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1)

      14.551285 #r(0.000000 0.924459 1.485422 0.985256 0.056811 0.219930 1.908499 0.913743 -0.403193 0.259904 1.334649 0.827148 1.624714 -0.021872 0.937257 1.122813 0.961899 1.532146 1.148701 0.868319 1.827482 0.356035 0.897995 1.553711 0.943178 0.960525 1.352917 1.720117 1.523327 1.617955 0.013172 -0.149597 -0.137644 -0.034035 0.111097 0.498787 0.121406 1.399436 0.620595 0.082527 0.702328 1.824635 0.362315 1.752651 0.335052 1.794344 1.642190 0.610334 0.262361 -0.222978 0.248243 1.869656 0.644580 1.192948 -0.312319 1.070271 0.368940 1.593867 1.836900 0.676177 1.276819 1.276408 0.936758 1.361721 1.692175 0.215294 0.511916 1.079847 0.588820 0.055407 0.579633 1.891289 1.810098 1.133091 1.733591 1.452365 0.980479 1.078929 1.556717 -0.427469 0.779143 1.336023 1.912299 1.782248 1.339461 1.329616 0.616924 0.917615 0.006788 -0.195359 0.981816 0.758001 0.419952 1.868089 1.758394 1.479010 0.921655 0.244745 -0.038674 1.158515 0.987245 0.469852 0.442126 1.652528 1.699770 0.900506 1.793377 1.368738 0.405805 1.083967 0.706228 0.759055 0.550546 0.985536 0.835398 1.537041 1.252754 0.414912 1.587016 0.741668 0.441787 0.537126 1.829954 1.207186 -0.038603 0.324826 1.093300 0.845470)
      )

;;; 256 prime --------------------------------------------------------------------------------
(vector 256 27.740 #r(0 1 0 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1)

      23.954812 #r(0.000000 1.204657 1.078759 1.682184 0.289433 1.857298 -0.103078 0.812130 1.708916 1.896961 1.156555 1.703874 1.227021 0.182267 1.041071 0.489158 1.008682 0.135723 0.046495 1.634992 0.566031 1.311776 1.337489 0.673226 1.836763 0.159154 0.202747 0.341271 0.471573 0.119586 1.124289 1.100574 1.091468 1.313210 0.642853 0.117292 -0.058379 0.647409 0.710309 0.207284 0.060417 0.146614 1.530493 1.426852 1.584556 0.403196 0.281684 1.359791 1.211733 1.335753 1.885602 1.477601 0.688497 0.894421 1.600991 1.328569 0.005997 0.453096 0.992624 0.185444 0.508566 0.835246 0.264281 0.242464 0.561992 0.572786 1.360366 0.402158 1.414686 0.275179 0.381572 -0.113917 0.093761 0.181937 1.876554 0.763184 0.742398 0.316668 0.919942 0.466632 1.953058 0.269310 1.678357 0.562522 0.033550 0.978955 0.884214 0.441468 1.069549 1.818992 0.418629 1.336178 1.464108 0.008854 1.818306 0.399905 1.080809 0.763485 0.787603 1.378379 0.936433 0.806686 0.536881 1.819028 1.671276 0.786432 1.275261 1.884577 0.933469 1.355576 1.479258 0.462174 0.332804 0.282457 0.550215 0.317652 0.454496 0.923565 0.787078 1.464952 0.107434 1.071904 1.315331 0.744343 0.731492 0.092424 1.422672 1.730219 1.887932 1.793030 0.347585 0.560825 1.039175 1.321464 0.820946 1.971856 1.662872 1.726858 0.163305 0.618347 1.843241 1.984311 0.060498 0.046747 0.257781 0.365656 1.677750 -0.207494 0.053362 0.938280 1.295484 0.245637 0.522272 1.268074 1.776463 1.391102 0.235187 1.356696 0.411477 0.726380 0.608354 1.031435 0.374485 1.212534 0.683978 1.636985 -0.020727 1.002990 0.490099 1.193211 1.072433 1.116935 0.177132 1.577198 1.488833 1.426992 0.196808 1.359200 0.812178 0.923445 1.498869 0.535636 1.325569 0.453085 0.957271 0.999087 0.721363 0.748530 0.296873 0.424017 1.951248 0.179282 0.622927 -0.057442 0.420195 1.292402 0.421561 0.376166 1.549061 0.996315 0.165646 0.418099 0.201640 0.421702 0.831456 0.106402 1.463327 0.005503 1.240637 0.776492 0.181978 0.800991 0.047810 1.685961 1.102672 1.488982 0.855213 0.435527 1.756187 1.183435 0.997613 0.162344 0.965285 0.203761 1.756880 0.117280 1.723671 0.647873 1.760056 1.248565 0.397491 1.167098 0.048428 0.194870 -0.145837 0.946144 1.336821 0.037491 0.496156 0.411789 1.814729 0.171113 0.774274 1.046076 0.369134 1.865905 1.353847 0.811560 1.792633 0.305766 0.578868 1.799589 0.584644 1.768023 1.140595 0.983334)
      )

;;; 512 prime --------------------------------------------------------------------------------
(vector 512 43.486 #r(0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1)

      38.602884 #r(0.000000 1.082143 1.690042 0.893575 0.756109 0.365343 0.807438 0.940757 0.585435 0.342350 0.594341 1.140652 1.817226 1.102492 0.331462 1.612595 0.512173 -1.909591 0.094152 0.360726 0.151765 0.706858 0.749498 1.906233 1.235313 0.796232 0.500830 0.064536 1.490244 0.959772 0.522500 0.779779 0.400580 1.439171 1.288511 1.693600 1.634346 1.612029 0.250323 0.286364 -0.273948 -0.057072 0.444920 0.673291 1.660718 0.950511 -0.044480 1.277714 0.922828 1.742498 0.067040 1.123761 0.731844 1.393404 1.039320 1.324896 1.831174 0.387406 1.709067 0.274769 1.267431 0.959919 0.715608 1.693570 0.000362 1.870214 0.699669 0.668933 0.997821 -0.008050 1.092934 0.993144 0.278118 0.973866 0.508203 1.715050 0.139916 0.132362 1.047327 -0.053979 0.185439 0.405403 1.344059 0.788131 1.083324 0.893261 1.764451 1.883814 1.299760 0.554300 0.979273 1.155257 1.533722 0.768283 0.256481 0.366299 0.921394 1.649597 0.976718 0.165847 0.006944 0.856772 0.899715 1.074092 0.112821 1.082075 0.258835 0.138175 -0.004825 0.001351 1.429175 0.630347 0.684026 0.531342 0.847633 0.762458 0.815632 0.219787 0.092949 0.202477 0.797900 -0.145417 -0.117708 1.761218 0.769741 1.161104 1.342323 0.523211 0.405201 0.497008 0.787122 1.231664 1.866867 0.811507 1.822296 0.236359 -0.004728 0.793757 0.887814 1.429788 1.804982 1.942786 0.923502 0.603222 0.794618 0.368216 1.088308 0.796327 0.542686 1.544013 1.716025 0.878200 1.782174 0.062214 0.364255 0.646601 0.833457 0.599270 0.751311 0.607033 1.116295 0.605117 1.252490 0.144452 0.065646 0.340371 1.042827 1.788314 1.880686 0.569623 0.189168 0.776287 1.195192 0.727742 0.491941 0.571446 0.260116 1.294844 -0.224851 1.513707 1.029946 1.744464 -0.045793 1.705297 0.170929 0.776558 1.159210 1.100586 0.974908 0.889723 0.131669 1.514065 0.483669 0.374957 1.765248 0.173880 1.574655 0.579673 1.075226 1.695626 0.618344 0.910042 1.785601 1.685191 1.340397 -0.031592 1.930247 1.607968 0.311691 1.234826 1.008031 0.136574 0.693831 1.350593 1.790691 1.248723 0.321392 0.332409 0.211515 0.677389 0.675342 0.748083 1.542146 0.537541 0.945052 0.644544 1.587504 -0.198604 0.497285 1.589685 1.631769 -0.102021 1.434262 0.504366 1.007294 -0.071908 0.889783 0.106723 1.597262 1.184125 1.385914 1.784083 1.814813 1.444514 0.168106 0.275712 -0.230240 1.482952 1.749244 0.624319 0.820132 0.038543 0.453451 1.192705 1.551536 0.933988 1.412615 0.290421 0.996887 0.879431 1.841715 0.672561 0.642185 1.873294 1.346219 1.516340 0.034439 -0.025203 0.114641 1.027748 0.436673 1.695049 0.946949 0.531849 0.288148 0.279537 1.094778 0.375490 0.307554 0.627782 0.418409 0.832934 0.666935 0.114950 -0.053285 1.218299 1.879745 0.386673 0.915368 -0.165173 1.124058 0.466149 1.878428 1.629128 1.512993 0.806896 0.046040 1.932554 1.129093 0.063911 0.559840 1.823056 0.947920 0.467855 1.479381 1.855655 0.408469 1.725599 1.305170 0.270211 0.911615 0.523954 1.318986 1.354400 1.104393 0.792536 0.687738 1.816953 0.079500 1.734615 0.148004 0.393542 1.491324 1.809997 0.036899 1.917219 0.036016 1.292915 1.439271 0.992174 0.734749 0.043086 0.632449 1.678465 1.214089 0.407041 1.157576 0.467194 1.849834 1.465874 1.299867 0.452820 0.577350 1.178402 0.504471 1.704246 1.529399 0.119449 1.587272 1.187154 1.736018 1.251019 0.054071 0.448967 1.151610 -0.041983 -0.058564 1.189234 1.429143 1.489017 0.205182 1.257753 0.994036 0.781546 0.390902 0.744400 1.772431 0.919261 0.499894 0.419934 0.281518 0.736860 0.910447 1.681100 1.722013 1.141474 0.827377 0.320102 0.007503 0.593080 1.581219 0.475353 0.227567 1.630156 0.895436 0.162740 0.389713 0.427078 0.505436 0.990570 0.227561 1.922194 1.293488 0.525156 0.798692 0.804781 1.222760 -0.002373 0.214414 1.011966 1.489753 0.749041 1.209362 1.542616 0.129806 1.948618 0.096126 0.340987 1.210097 1.746925 0.607998 0.771692 0.843752 0.870293 0.931325 1.216995 -0.219011 0.558727 0.605157 0.764943 0.813267 0.109796 0.025290 0.418750 0.976910 0.611063 1.425653 1.312703 1.416454 1.541723 0.279510 0.000239 1.660016 0.196937 1.482933 0.237398 1.048222 1.226372 0.074770 0.565242 0.782888 1.814840 1.669287 0.878760 1.658003 1.628831 0.063412 1.934276 0.152397 1.633067 1.697411 0.919379 1.358819 1.021028 1.568829 0.560019 1.191100 1.722100 0.879855 0.967865 1.958702 0.180163 1.190964 1.472899 0.387723 1.635329 -0.004167 1.194302 0.101361 0.922515 1.847355 1.174116 0.380497 0.721821 1.201075 1.612741 1.020268 -0.168817 0.406276 1.455790 1.666789 0.232089 1.791143 1.515844 0.427944 0.351285 1.732308 0.954418 0.569378 1.065546 1.527300 1.587063 1.317922 0.415597 0.001422 1.240139 0.099248 1.639437 1.663543 0.562245 1.762090 1.669121 1.738347 1.503729 0.665114 0.450457 0.358214 1.358391 1.040768 0.320330 -0.191120 1.844458)
      )

;;; 1024 prime --------------------------------------------------------------------------------
(vector 1024 70.140 #r(0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1)

       65.349256 #r(0.000000 -0.129848 0.969209 0.836351 0.061754 1.032484 0.051397 -0.047672 0.218624 0.018916 -0.064346 -0.087720 0.896115 1.194836 0.077672 -0.093665 -0.097710 -0.086592 0.949666 1.122929 -0.067767 0.950039 1.122745 0.018018 0.930855 -0.245701 0.859196 -0.118393 -0.017421 0.154025 -0.211100 -0.109137 0.940842 -0.140564 0.967517 -0.167684 0.023269 0.025376 -0.045911 0.903419 -0.200515 -0.239733 0.820269 1.087952 1.103155 -0.067139 0.794572 -0.000447 0.796383 -0.050127 -0.097253 1.071546 0.028226 0.109239 0.999458 0.870447 0.946254 -0.081085 1.245293 0.861076 0.913395 -0.009593 0.921868 1.075746 0.111204 0.213778 0.007799 0.861516 0.879520 1.119282 1.112758 0.023180 0.087708 -0.039342 0.017034 -0.142251 -0.066926 0.123437 -0.087868 0.910913 0.108597 -0.196132 1.069560 1.014239 0.192506 0.075011 0.674937 -0.174632 1.062546 0.982886 -0.071153 -0.102231 1.008769 -0.021251 -0.043692 0.910660 1.203363 0.930076 1.192149 1.079643 1.139869 -0.102933 0.892075 1.081967 1.117296 1.069641 0.961155 0.889926 0.104236 -0.012679 1.018557 0.083425 0.102764 1.041332 1.049506 1.057530 0.927572 -0.192969 -0.132492 0.997314 1.171628 1.067315 1.038820 1.033745 1.322831 -0.007981 0.994085 0.965156 0.070645 1.143780 -0.097751 -0.035141 1.081372 0.841845 0.110341 -0.016561 1.124066 1.050833 0.937074 0.926741 -0.150226 0.056436 0.964946 1.014226 0.961483 0.200116 -0.027025 -0.042596 0.873435 1.128675 -0.074217 0.034750 0.002625 0.037174 1.052187 -0.007505 1.057468 -0.020629 0.954765 1.162873 0.836305 0.919671 0.176115 0.867824 0.159416 0.913293 0.972493 -0.057629 0.902111 0.973589 -0.086627 -0.008031 -0.139087 0.943821 1.137966 0.070214 -0.004563 0.871135 -0.028372 0.970905 -0.036782 0.845326 0.108872 0.880706 -0.063917 0.888627 0.925543 1.066596 0.853571 -0.093806 0.904332 -0.112339 0.945758 0.871634 -0.096140 1.001890 1.129246 0.963672 0.170539 1.085873 0.061910 1.045363 -0.043655 0.071480 -0.112838 1.140479 -0.203871 0.018032 0.967477 -0.109462 0.786798 0.159117 0.091987 1.000511 0.121439 0.998700 0.114766 0.043124 -0.051500 1.039391 -0.116269 0.884009 0.038584 0.870599 -0.009894 -0.177026 1.208055 1.281757 0.041090 1.074146 -0.185247 -0.160109 -0.084894 -0.013678 1.116236 0.043626 0.914436 1.186335 0.008002 -0.013450 -0.068550 0.867764 -0.069795 0.028624 1.053037 1.105179 1.148503 -0.078114 -0.107345 0.808140 0.888280 -0.101397 0.863680 -0.177989 0.805880 0.985054 0.997369 0.970739 0.045371 0.041317 -0.112380 1.007911 0.837435 0.969586 0.893134 1.011096 0.079245 0.911597 -0.043743 1.012740 1.031412 0.069924 0.910651 0.066980 0.855519 1.128309 1.046886 -0.009687 -0.147082 0.900969 1.137525 0.881305 1.084781 -0.031000 1.031283 0.123503 -0.135598 0.951868 0.887466 -0.122854 -0.039498 1.017664 -0.102471 1.018993 1.022945 0.093609 0.101814 1.044330 -0.102747 0.051954 0.001832 1.002061 1.025387 0.930853 0.958319 0.146189 0.932064 0.106399 1.032653 0.014707 0.032026 0.879101 -0.027770 0.031687 0.111934 0.802921 -0.076047 0.059286 0.065123 0.128711 0.974155 1.040636 -0.158251 -0.044445 -0.146345 1.152523 0.901758 -0.061750 0.921515 0.108254 -0.128639 1.088615 0.119335 1.107712 0.012965 0.831934 0.917791 0.827352 0.931376 0.029208 0.968659 1.110903 1.139422 0.103217 0.804597 0.104877 1.024813 1.110962 1.158506 1.074313 0.918885 1.091629 1.052239 1.155470 0.969547 0.176177 1.193274 1.000806 0.167489 -0.087811 1.272916 0.090580 0.837388 0.853777 0.021673 0.795498 0.153088 -0.039163 0.886259 0.953876 0.846456 0.902225 0.108103 -0.023242 1.091272 0.796242 1.011212 0.961046 1.021211 0.039001 -0.032781 1.042170 1.131254 1.092307 0.999148 0.071362 0.869992 0.079822 1.110594 1.044065 1.166722 0.955017 0.117000 0.059709 1.113545 0.131377 1.023012 -0.114272 0.975103 0.983023 -0.046717 0.032378 0.224959 -0.069345 0.040516 1.089631 0.899237 0.136151 0.832552 1.215356 0.881670 0.944211 0.848668 0.152316 -0.124640 0.919395 0.853571 0.038901 0.049308 1.049839 -0.129701 1.004425 -0.052754 0.002949 -0.037696 0.133904 -0.020847 0.967100 0.902003 0.019567 -0.130260 -0.157473 -0.071944 0.135523 0.944472 -0.199005 -0.011428 -0.057531 1.218722 0.021172 0.873547 0.871952 0.950595 -0.066828 0.911583 0.960085 0.059484 1.216384 -0.015251 0.921576 1.107399 1.190526 1.009427 1.067453 1.067973 0.105850 -0.001821 0.968722 0.047666 0.095350 1.060487 0.951973 0.082517 1.139249 1.053557 0.799986 0.981175 0.927100 1.108483 -0.113217 0.056334 0.923079 -0.168060 1.160952 1.109659 0.931859 0.005663 0.016298 0.221144 -0.021547 1.134376 1.041640 -0.085720 1.009292 1.001582 0.885811 0.011233 0.110421 0.907129 0.093259 0.973361 0.842954 0.055170 1.054987 1.014198 -0.048044 0.812989 -0.144503 0.010466 1.029196 0.774851 0.843001 0.004633 1.225056 0.948512 -0.001831 -0.091454 -0.110441 0.000770 0.042991 0.840050 0.957463 0.073186 1.131453 -0.127608 1.100834 0.028867 0.991329 -0.079297 0.226099 1.081074 1.094744 -0.196334 -0.315150 -0.099639 0.860961 1.022403 0.767717 0.956186 1.242205 -0.055123 0.982544 1.115183 0.186049 0.867447 -0.036624 0.161043 -0.021433 0.029621 0.825744 0.027361 -0.010122 1.051195 0.027158 0.125747 -0.012676 1.018144 0.217569 -0.139580 1.065948 0.653885 0.017558 0.122910 1.005607 -0.024503 1.016854 0.118126 0.117812 0.209380 0.129761 0.103368 0.851695 0.818381 -0.060532 0.047740 1.092005 0.126179 -0.128900 1.046458 1.172438 0.945933 0.969409 0.186286 0.067827 0.866733 1.045200 1.053391 0.154799 -0.076177 1.034977 -0.251459 0.843987 1.036970 0.109710 1.081980 -0.054976 -0.104881 0.977835 0.917720 1.151081 1.224827 0.036178 1.178894 0.852252 1.170082 1.170461 0.979772 0.962385 0.904510 0.000036 -0.069878 0.919872 0.173255 1.075581 -0.013411 1.144951 -0.113696 0.013363 1.098609 1.014644 -0.003549 -0.244091 0.859325 1.071514 0.043866 1.123524 0.973631 0.994259 0.294619 0.940489 0.920230 0.796504 -0.004450 1.029035 -0.000831 0.920995 1.002150 0.986683 1.009523 1.089643 0.007497 1.152282 0.045887 1.088386 0.885838 -0.027924 0.051985 -0.076538 -0.224663 0.028256 -0.124194 0.724391 1.154873 0.792085 0.945537 1.154353 0.115964 0.986499 0.966811 1.012457 1.019910 -0.144866 0.815479 0.985586 0.913383 -0.150963 0.023412 -0.040408 -0.003953 0.004799 0.998876 0.002820 -0.098213 1.057293 -0.129926 0.137392 1.102538 1.079292 1.089070 1.130675 1.020925 1.154058 1.123118 0.858700 0.978386 0.138491 0.154692 1.041549 1.046975 1.030488 -0.158543 0.870238 0.064134 0.875614 -0.094478 0.900905 0.880022 1.134267 0.779059 0.063545 1.070040 -0.086015 1.008573 0.109322 -0.247240 0.015151 1.151193 -0.102164 0.087261 0.007995 0.854703 1.140979 -0.090975 0.812937 1.001838 0.168940 0.981369 -0.006072 -0.134631 1.058021 1.081911 0.004162 1.014677 0.995130 1.055979 -0.015306 0.058775 1.111668 0.059318 1.008648 0.996646 0.848989 -0.109175 1.102945 0.116474 0.906494 -0.120660 0.877452 0.886871 0.085411 0.884701 1.181621 1.062561 0.189097 0.973371 1.214908 0.001252 1.030678 0.152018 -0.037592 1.176813 0.948804 0.061120 1.019977 1.028438 -0.000808 0.087217 0.826864 0.893273 -0.207696 -0.074786 -0.108728 0.152240 -0.121688 0.980366 -0.049309 0.988905 0.044844 1.037851 0.979360 0.997856 1.209193 0.179051 1.004545 0.962175 1.139200 1.064077 0.021192 0.871727 0.976645 -0.060807 -0.016180 1.233966 0.984256 -0.044995 0.845917 0.182605 0.998382 0.007096 -0.023173 -0.024155 0.146239 1.013539 0.995536 0.048524 1.174691 1.141919 1.101145 -0.104732 0.114083 1.102748 0.983142 1.123097 -0.131915 1.072939 -0.138725 0.845004 -0.163152 -0.079593 1.018944 1.012216 0.030165 1.054447 0.994960 0.152361 -0.060656 1.093567 0.946563 0.106698 0.153793 -0.034551 1.295949 0.943407 -0.163119 0.067866 1.194305 0.979105 1.022403 1.106721 0.934941 -0.016105 1.092573 -0.050474 0.132465 0.025768 0.046448 0.920971 0.032186 0.827060 -0.132549 0.143363 0.083704 0.912578 -0.030293 0.096970 -0.039315 -0.023765 1.016646 0.854818 -0.052889 1.056921 0.089890 1.018924 0.081699 -0.114805 0.930082 -0.021013 0.109704 0.995297 -0.078029 1.125314 0.178931 0.020308 -0.221485 1.187702 0.047629 0.040061 1.015073 0.069320 0.060090 -0.115159 1.088644 -0.081572 0.068986 0.955768 0.084087 0.114901 1.013399 0.080815 -0.114939 1.007244 -0.059946 1.062447 1.043256 0.100314 1.021597 1.004933 -0.021577 -0.187720 -0.061395 -0.075323 -0.009496 0.985795 0.872323 -0.046461 0.888848 -0.053261 -0.110021 1.099191 0.979002 1.060305 1.062463 1.171427 0.691334 1.098940 0.054888 -0.017909 -0.010409 -0.111589 0.082490 0.948398 1.144871 0.127743 0.031811 1.026180 1.046146 -0.030210 -0.103802 0.989801 -0.310437 1.153393 1.012685 0.952894 1.001378 0.015652 1.054587 1.328504 -0.151531 1.037238 1.151575 0.030623 1.108802 -0.028053 0.044671 0.901073 0.934031 0.058498 0.039050 1.065155 0.024139 -0.131291 -0.082086 0.854526 1.154246 -0.049980 -0.184925 1.049877 -0.115467 -0.018300 1.001119 0.057983 1.189518 -0.114544 1.258100 1.123841 0.961039 1.070424 -0.124628 0.209509 0.034004 0.948762 1.100182 0.083224 0.948264 1.081482 0.076927 -0.000455 0.950737 0.098354 1.005742 1.019785 0.974317 0.230726 -0.067827 1.165865 0.048218 -0.058027 0.937849 0.079916 -0.012394 0.069161 0.050349 0.906284 0.832283 0.101171 0.790746 0.156878 0.740395 1.017554 0.191391 0.080956 1.000597 0.844203 0.944456 -0.111179 0.982617 1.037761 0.099785 0.851180 0.116591 0.142708 -0.015906 0.096645 0.965791 0.020953 0.925519 1.197465 -0.055737 1.095928 -0.064679 0.010255 0.936661 1.178645 0.190866 1.141107 0.130145 0.023056 0.121484 0.185090 -0.056773 0.100045 0.069574 1.039529 0.996635 1.085726 0.949189 -0.165723 -0.039203 1.116369 -0.064244 0.940174 -0.154655 1.121041 0.902088)
       )

;;; 2048 prime --------------------------------------------------------------------------------
(vector 2048 102.619 #r(0 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1)

       95.904258 #r(0.000000 -0.184827 -0.106502 -0.094974 0.803466 0.945074 0.963289 0.946874 -0.103266 0.049155 1.087214 0.886218 0.016107 0.059052 1.086003 0.896052 0.832875 0.168267 0.929954 0.104821 0.801629 0.032075 0.032796 0.227531 0.906532 1.124909 1.032850 0.878053 0.813900 -0.267885 0.885447 1.090714 0.853533 -0.000373 1.207049 0.922018 0.048308 0.893672 0.856221 0.975035 0.868154 0.098949 0.791588 1.196055 0.919249 -0.152557 0.991948 1.006717 1.133320 1.186246 0.920884 -0.060763 0.895777 0.020781 0.811521 0.941459 0.931533 0.044866 -0.116604 0.896466 0.029517 1.096540 0.918555 0.948344 0.929326 1.133930 0.012583 0.960301 1.199033 0.051836 1.012281 -0.182278 -0.104579 0.982487 0.083391 -0.235240 0.238134 0.851365 1.147123 -0.183897 0.931617 0.014719 0.969454 0.114930 -0.007528 0.927332 0.038357 0.920680 -0.081674 -0.182395 -0.011442 1.061361 0.921566 -0.084353 1.041705 0.161045 -0.067878 1.074036 0.941106 0.966219 0.919599 1.168159 1.032081 0.945189 0.044320 0.039817 -0.089720 1.130429 -0.069569 -0.278003 0.838588 0.754892 0.905296 0.076030 0.931578 0.143938 -0.063198 0.009752 0.994216 -0.018389 1.061023 0.998466 -0.064949 0.889855 -0.094736 -0.151667 1.224271 -0.191231 0.981083 0.017183 -0.228680 -0.064528 -0.051088 0.940309 1.101261 -0.034752 0.950794 -0.088223 1.190759 0.000979 1.058816 1.106846 0.070946 0.194156 1.093892 0.886993 1.017953 -0.051739 -0.284107 0.024602 0.969253 1.247816 0.935610 -0.089803 0.006657 0.841177 1.059923 1.023429 0.866137 0.046390 -0.124782 -0.252595 0.166144 1.083896 1.139053 0.949050 1.094868 1.174455 -0.189695 1.188365 1.031424 1.009889 1.067591 0.935164 0.237409 0.909064 0.009677 -0.177665 0.046406 1.016694 1.057379 -0.055836 0.052713 -0.065039 0.120813 0.836055 1.178838 0.902715 0.920359 0.806116 -0.117471 1.158887 0.994531 -0.009494 -0.163337 1.040739 1.131213 0.025531 -0.009616 0.139395 0.950856 -0.014744 0.115132 1.125894 -0.190579 0.101124 -0.125308 0.963704 0.026526 1.118700 0.022614 0.807945 0.913877 0.030742 0.927436 0.988232 -0.140750 0.124385 0.986885 0.991816 1.146772 -0.062919 0.074766 -0.034226 1.128490 0.957963 1.096308 1.046278 -0.048364 0.116505 1.136521 1.090002 -0.014238 -0.112155 1.033034 1.160610 -0.094599 0.068313 1.266010 1.098976 0.044651 0.131033 -0.116651 -0.075950 1.046348 0.030055 0.793219 -0.117150 1.124225 -0.160989 1.100541 1.045178 0.962828 -0.073358 -0.019227 1.173791 1.059709 0.937667 0.966884 0.928018 1.041334 -0.201315 0.174562 1.021851 -0.049449 0.907458 -0.107815 1.126703 0.073928 0.982065 0.825831 -0.033241 0.067472 0.917284 0.902681 1.015596 0.904075 -0.075353 -0.108265 0.963265 -0.090615 0.920339 0.977780 0.090733 0.904078 0.000883 1.347356 1.014221 0.985375 -0.100963 0.008783 0.942615 1.002685 1.149002 0.158462 0.917602 -0.099583 -0.025442 1.103430 0.071006 -0.151207 0.055689 -0.038941 0.098832 0.911418 1.062737 0.996744 0.760254 0.996130 0.014262 0.032851 0.956371 0.019061 0.996091 0.200667 1.164966 0.045741 0.060264 1.166834 -0.025387 0.966912 1.043716 0.969667 1.084931 -0.065039 0.974364 0.980017 0.844958 0.179207 0.723395 1.083973 -0.074447 0.912360 1.089065 1.005958 -0.119354 1.049441 0.937401 0.912303 0.937357 0.078173 0.927334 -0.094425 0.851189 0.132753 0.133028 1.043045 0.054936 -0.083812 0.903122 1.042637 1.178266 -0.107401 1.047050 -0.128737 0.160133 0.840861 0.896100 1.126802 0.903407 0.262267 0.053879 0.947798 -0.144016 -0.003985 0.146029 0.074915 0.771488 1.227288 0.890268 0.933106 1.075829 0.057968 0.066132 0.249704 -0.017827 0.090465 -0.047385 -0.060718 0.123360 0.988529 0.904277 -0.005465 -0.084169 -0.247831 0.999998 0.910292 1.144645 0.071091 0.088886 1.023713 -0.025414 0.984571 -0.240585 0.967555 -0.138539 0.196983 1.010405 -0.049670 -0.081707 0.064139 0.997860 0.836573 1.161272 -0.021657 0.041743 -0.127308 0.045553 0.018541 -0.044739 0.088082 0.142342 0.114457 1.055260 1.064567 -0.119380 -0.070251 -0.004341 0.963091 -0.120638 0.258819 1.053558 0.878500 1.069022 -0.123646 -0.014321 1.121295 1.085748 -0.044674 0.870738 0.685253 -0.051358 1.001113 -0.231350 0.033853 0.961438 0.037712 -0.113045 0.108555 1.037350 1.011749 1.028331 -0.080798 0.196328 0.059651 0.046311 0.977929 0.955683 -0.011917 0.990010 0.826271 0.043303 1.009806 1.189345 0.021063 0.072917 0.057585 0.061242 0.879010 0.849055 1.018528 0.955494 -0.055041 1.189587 -0.028346 -0.082984 0.099423 -0.024146 0.146930 -0.067314 0.849801 0.213148 0.924340 0.080454 0.905046 -0.129837 0.863551 -0.015056 1.161555 -0.111647 0.827215 0.819815 1.100249 1.048851 0.084224 1.096872 0.064524 1.027164 0.125925 0.828778 -0.032148 1.059894 1.017072 0.834004 -0.032573 -0.063582 1.159025 1.022326 0.063607 1.022556 1.099517 0.097842 0.150138 1.115534 0.951150 0.988949 0.155650 -0.134289 -0.115258 1.037176 1.021182 0.975772 1.072700 1.222345 0.924272 0.973662 0.930252 0.059705 0.077967 -0.109443 -0.103486 0.972696 -0.144205 0.802195 0.975677 0.802607 -0.042079 1.071307 1.022073 0.907916 1.035902 -0.048853 0.907965 0.883285 0.084385 -0.108649 0.944568 0.005988 0.933534 1.065312 -0.070265 -0.076879 -0.017044 -0.098932 1.208925 0.930986 -0.119229 -0.037509 1.090406 0.992176 -0.000651 0.937690 0.916741 -0.066544 1.095679 -0.058814 1.036581 -0.051849 -0.017058 -0.030283 0.051491 0.954183 0.950362 -0.021757 -0.062612 1.017252 0.855360 0.008584 0.998471 0.053177 -0.102277 -0.071410 -0.113602 0.020219 0.047660 0.112990 0.815120 1.152303 1.067537 1.052888 0.004076 0.157730 0.930208 0.885789 0.948613 1.018989 0.998994 -0.098675 0.134960 0.084711 0.092822 0.103312 -0.196457 1.024530 1.108457 0.891294 1.054699 1.016928 -0.022703 0.811591 1.004965 -0.017036 0.232325 0.973190 1.052258 1.071581 1.167101 -0.078778 1.126544 0.054092 0.108866 0.166665 1.087490 0.998143 -0.013409 0.871172 0.885040 1.019108 1.127064 1.196444 0.957927 0.852239 -0.008268 -0.145143 1.063054 -0.026011 1.007974 0.983277 -0.031336 1.126868 0.969557 0.015995 0.940510 0.206836 -0.166196 0.069999 0.106477 0.969534 0.962793 1.057184 0.039570 1.013939 0.966957 -0.186086 1.043328 0.103727 0.826020 0.082145 0.142187 0.193131 0.806568 -0.194497 0.073921 0.929470 0.014750 1.003891 1.130669 0.912871 -0.166896 -0.010434 0.224001 0.019969 0.882091 1.015999 0.050540 0.927299 -0.028913 0.088865 -0.038210 0.838785 0.179969 -0.063760 0.909551 0.970913 0.864195 -0.147216 1.017549 0.931612 1.076838 0.174334 -0.004854 1.146351 -0.071188 0.005023 0.983870 0.987921 -0.073293 1.144937 -0.008273 1.069178 0.160218 0.940671 -0.099513 -0.160986 -0.053460 -0.000349 -0.066930 0.258818 0.037651 0.899944 1.011860 -0.024019 0.049159 -0.114396 0.997122 0.988277 -0.086170 1.100402 0.827506 -0.071549 1.014472 0.830365 -0.029296 1.033932 -0.095907 -0.073030 0.967696 1.060165 0.920338 1.199129 -0.072200 0.053416 -0.126898 1.108390 0.903008 1.109424 0.964135 -0.083890 0.099047 -0.111937 1.079528 1.230021 1.124700 0.946124 1.081677 -0.089364 1.123287 0.082817 -0.048549 0.013111 -0.005217 1.016286 0.025359 -0.151572 1.137235 1.013948 1.006359 -0.020039 -0.117293 1.111762 0.892597 1.058754 0.795600 0.996014 0.931963 1.115786 -0.029889 0.877043 -0.234877 1.149674 1.027911 1.261517 0.048880 0.113954 -0.024127 0.075365 -0.048636 0.036252 0.831941 0.943628 0.982317 0.918776 1.086510 0.931126 -0.077364 0.039915 1.020953 -0.068839 0.962253 0.910823 0.025853 0.065365 0.021206 -0.021296 0.872652 0.026536 -0.052762 0.003250 0.029539 0.991921 1.021217 -0.042456 0.777756 0.980840 0.078981 -0.130613 0.133311 -0.065841 -0.085861 1.178451 0.115564 1.082062 1.015392 0.928586 0.967073 1.156891 -0.010223 0.936469 -0.154645 0.995277 1.073333 -0.010159 -0.073318 1.117785 0.123446 0.035440 0.914424 0.055982 1.255170 0.975126 0.021080 -0.037628 1.048938 0.871136 1.107293 0.955878 -0.056277 1.017033 0.090456 0.993267 0.757034 1.002409 0.941223 0.920711 1.181339 0.032023 -0.085516 0.974206 -0.026907 0.142086 -0.002800 0.952901 1.119119 1.039547 0.762175 1.056838 -0.114595 0.884738 0.718220 0.960728 -0.156479 1.189199 -0.165202 0.904637 -0.041429 -0.050488 -0.179745 1.054673 -0.082418 0.030881 1.160170 0.821960 -0.086297 0.010350 0.932553 0.035420 -0.009593 0.011040 0.051718 0.904123 0.028769 0.100605 1.033920 -0.169584 1.086360 1.131494 0.107596 -0.114123 0.021393 0.010364 -0.152848 0.035197 0.012279 -0.133590 -0.062321 1.204840 0.937029 -0.068386 1.145671 0.973614 1.135843 0.883055 0.070061 0.997608 1.003482 0.989245 1.204030 1.197676 0.838535 0.029369 -0.215349 1.060468 0.880276 0.931456 0.125650 1.132780 -0.117697 0.200533 0.075686 1.191015 1.016195 0.037000 1.110074 0.982317 0.982573 0.824837 -0.229925 1.006482 -0.062451 -0.057872 0.979641 -0.230341 -0.020939 1.006077 0.857917 1.098933 -0.267219 0.043265 0.935436 0.964162 -0.007168 0.164970 0.165342 1.068220 0.945315 0.948634 1.023862 -0.029831 0.992343 0.020292 0.067126 0.932456 0.808919 0.096733 0.000609 0.083113 1.019237 0.858419 1.013183 0.098990 0.930352 -0.062223 1.082324 -0.042610 1.104376 0.999943 -0.136202 0.964477 -0.092847 1.096219 1.036690 1.110447 0.987439 0.893158 0.111588 -0.094486 0.748732 0.981962 1.023640 1.021660 0.931300 1.325728 0.988586 0.832724 0.042650 -0.080219 -0.124412 0.083378 -0.047165 0.013229 0.179035 1.036229 0.106634 -0.154080 0.015828 -0.138512 0.228898 0.970943 1.152854 0.994299 1.087348 1.079495 -0.014073 0.985630 1.046303 0.921605 -0.148486 -0.082307 1.049524 0.140156 1.012720 0.976567 0.874688 -0.045198 1.031276 0.883380 0.011846 -0.003498 1.009216 0.885002 0.172619 0.843282 0.029227 -0.097679 -0.125796 0.933874 0.978897 0.725114 0.844720 1.075252 0.947844 0.926610 0.182857 0.841432 1.040159 0.998281 0.169201 0.136041 1.216461 0.161331 -0.074244 1.061895 0.862101 0.118827 1.150273 1.131402 0.028905 0.802992 -0.116645 0.004795 -0.035171 -0.225349 -0.011793 1.004637 1.052814 0.132105 0.965384 1.075721 0.233900 0.952135 0.901143 1.131006 0.032321 1.011176 0.873840 0.182329 -0.079077 0.896822 0.005166 0.903099 1.092780 -0.025076 -0.019178 0.015239 0.984311 1.216486 0.992874 0.054129 0.144836 0.099554 0.103521 0.100432 -0.026631 0.042079 0.163741 1.041917 0.792159 0.979852 0.977128 0.103524 1.113377 -0.157199 1.027202 0.929073 1.074076 -0.112317 0.199279 0.760239 0.001430 1.277148 0.009244 0.986963 0.109581 1.086070 -0.134094 0.327295 0.686709 -0.296672 0.932890 0.968488 0.216488 0.165531 0.285075 -0.094601 -0.165028 0.950486 0.963591 0.864035 -0.065266 1.013992 0.911092 -0.094152 -0.152792 1.070739 -0.039448 1.166353 -0.004048 0.032871 0.996625 1.100064 1.255396 0.839630 -0.081969 0.162263 0.140738 1.003998 0.779814 0.961648 1.146742 0.167212 0.925641 1.185256 0.824157 -0.033666 -0.007601 0.908697 0.230017 0.822888 0.740994 0.033372 1.160544 1.098836 -0.044005 1.021078 0.126042 0.049334 0.898357 1.032574 0.865757 0.947486 0.886121 0.055309 0.044278 -0.037421 1.134951 0.864539 -0.011595 -0.007199 0.067683 1.090102 1.092557 0.046997 0.027613 0.949146 0.875265 0.136983 -0.135656 0.985803 -0.132003 0.135341 0.013222 1.091309 1.098115 0.015599 0.119349 0.014805 1.069340 1.102334 1.032680 -0.031084 0.906554 -0.088863 0.069579 1.064396 0.128172 1.022790 1.107156 -0.057182 0.995012 1.054566 1.042520 -0.160709 1.125070 -0.094154 0.046403 -0.069345 0.119373 -0.184893 0.070830 1.044722 1.098693 1.111409 1.135049 0.985119 0.066473 0.058424 1.004842 -0.094015 1.117752 0.799547 1.268968 0.039520 0.996895 -0.102408 -0.030667 0.930842 1.078283 1.102597 0.055578 0.110127 0.923904 1.005813 0.918634 1.079133 -0.099263 0.905943 1.047321 0.848243 -0.009403 -0.068258 1.012623 -0.037975 1.142196 0.851851 0.109046 1.141382 0.890904 0.996832 -0.088058 1.288646 1.097971 -0.100491 0.918525 0.015332 1.145115 0.117738 1.014796 -0.205627 -0.177297 -0.006318 0.055035 1.183699 0.900390 1.055439 1.182836 0.107470 0.210820 -0.154634 1.100666 0.004257 0.125613 0.849489 1.120995 -0.046236 -0.066772 0.011079 -0.102932 0.932197 0.023264 0.246085 0.163405 0.869069 0.102531 1.077511 0.954854 0.038602 0.079792 0.927047 0.983181 1.030696 0.962590 -0.055603 -0.107934 1.126555 0.946728 1.063664 0.137033 -0.128875 0.885196 0.091522 0.893839 1.007955 0.978475 0.978266 0.067848 1.038168 1.090875 -0.061309 1.116028 1.016019 0.011872 -0.108054 0.108874 0.083760 0.113696 1.116111 0.014309 0.005128 1.099189 -0.004973 1.325065 1.221479 0.028469 1.235019 -0.212490 0.962518 1.027151 -0.044149 0.142639 0.155400 0.936540 -0.039180 0.937115 -0.085578 1.019973 1.270603 0.140594 0.061038 1.087655 0.063712 1.177018 -0.029958 0.758319 0.051019 -0.094233 0.962416 -0.006348 -0.003660 0.019678 1.112579 1.058837 -0.108754 0.005081 0.979604 0.909652 -0.162160 0.189741 1.115396 -0.046934 0.809487 0.174222 -0.004756 1.140939 0.812895 0.050537 0.171915 -0.128895 0.969610 0.953147 1.047572 0.122563 0.889198 -0.104048 0.001916 -0.008785 1.172703 -0.213570 -0.114233 -0.152007 -0.161789 -0.132968 1.055565 0.784424 0.202349 -0.012066 0.004158 -0.039121 1.114936 0.962613 0.954226 1.105200 0.985756 1.026320 -0.117780 0.866616 1.000189 -0.163224 0.999105 1.165142 0.001717 1.023313 -0.052468 -0.233246 -0.078417 -0.014831 0.008989 0.105092 1.100102 -0.114187 0.962275 0.827359 -0.135499 1.155899 0.983914 -0.197096 0.920622 0.925756 0.074101 1.105182 0.068112 0.889324 0.995794 -0.181975 1.079197 -0.174077 -0.086147 1.108775 0.836038 0.920177 0.069115 1.056833 1.065288 1.011220 0.037095 -0.051383 0.059023 0.966919 0.975420 0.992209 -0.050411 1.034776 0.060947 0.024827 0.189251 1.128565 -0.026102 0.882647 1.113292 0.059688 -0.055524 1.097931 -0.076831 0.148308 0.009684 0.993343 0.181407 0.980680 -0.253676 1.203786 0.837538 -0.111906 -0.046920 0.992998 1.138650 0.102810 0.732933 0.974495 1.134363 0.841220 -0.244832 0.191984 1.089926 -0.014286 1.033093 0.795315 0.027888 1.086315 0.921910 0.023081 1.023830 0.070684 1.183612 -0.197469 -0.072227 1.175515 1.132615 0.147372 1.165071 0.693358 0.086944 0.167356 1.154251 0.067038 1.011388 0.195281 0.162053 0.058855 0.118483 1.091391 1.199083 0.861074 0.152693 -0.184650 -0.275426 0.016699 1.041744 1.082925 0.896020 -0.212005 -0.028325 0.837564 1.192865 0.964038 1.140280 0.832699 0.060523 1.017736 0.007067 1.222558 0.776881 1.025602 0.136510 1.065558 0.031534 1.120667 -0.017440 -0.095844 0.986588 0.811881 1.008160 1.083596 -0.057608 1.030774 -0.185755 1.016553 -0.060277 0.044570 0.071469 1.026382 -0.218238 -0.134819 0.125155 1.052665 0.219534 1.053074 0.975626 0.942097 0.042773 0.914988 0.904458 1.068383 0.122945 -0.160737 0.195111 -0.112309 0.079404 0.873713 0.743694 -0.042029 0.017013 1.026689 -0.033216 0.846494 1.151063 -0.096712 0.933521 -0.150138 0.998351 0.097766 1.014397 1.003826 0.249110 -0.089820 -0.095115 -0.041617 1.005328 -0.026956 0.282608 -0.227117 0.900497 0.151081 1.074944 0.999410 0.070956 0.989252 1.046830 0.036838 0.060586 0.119680 1.033878 1.147593 1.072223 1.038019 -0.063806 -0.066418 -0.094579 0.121532 0.058665 0.065637 0.015630 1.033625 -0.167401 -0.044227 0.109799 1.069494 0.978455 0.951966 0.848373 1.183717 0.052564 -0.139052 0.109210 1.056692 1.084067 0.913136 0.026099 0.888367 1.004145 -0.006357 -0.186626 1.147417 0.008987 1.033956 0.198511 1.087879 0.153898 -0.007073 -0.053729 0.960733 -0.079153 -0.112602 0.118601 1.127696 0.124208 -0.118455 1.113389 -0.141400 0.095581 0.831887 0.079625 1.065606 1.064953 -0.043117 0.883460 -0.117838 0.984417 1.073930 -0.020071 -0.020565 -0.110661 -0.029427 0.000735 0.129840 -0.059144 0.853604 0.029159 1.153760 -0.035371 0.120975 0.829886 0.902305 0.004019 1.024841 -0.008315 -0.040841 0.081011 0.034157 0.925135 0.026143 -0.146226 0.818801 0.997553 -0.057337 0.039344 0.045043 -0.058730 0.061450 0.034397 0.032312 1.021479 0.069734 0.032385 -0.034352 1.143739 0.128130 0.837756 0.143447 1.191780 1.005715 -0.145746 0.060156 -0.089751 0.993522 1.117964 1.113924 -0.051214 0.989301 1.131346 0.978070 1.120586 -0.104089 0.755209 0.911168 0.043338 0.799533 -0.065789 1.035956 1.103884 1.108033 -0.011160 0.018199 1.076458 1.033226 1.049461 0.927281 0.875446 -0.132488 -0.016539 1.040494 -0.085837 0.845351 0.082137 0.957295 0.975488 -0.233161 1.046308 0.968283 1.119329 0.799388 0.835437 1.198178 1.006967 -0.080996 1.022071 0.222670 1.054955 1.028112 0.145964 0.775125 0.053077 -0.139928 0.982870 0.012204 1.181785 -0.055209 0.064440 0.028436 -0.055658 0.988257 0.885626 0.925751 1.041503 -0.102556 0.199169 0.817618 1.118232 -0.154162 1.103379 0.161217 0.043204 0.038827 0.297793 0.101115 1.084585 0.911258 -0.017387 1.093864 1.174369 -0.052884 1.010587 1.084918 1.042023 0.988052 1.008470 1.079842 0.911711 -0.105412 1.049916 0.966051 -0.030853 0.634323 0.027996 0.065373 0.165603 -0.198745 0.121133 0.904870 0.798116 0.109313 -0.023197 -0.012270 -0.099679 -0.007982 0.957938 0.064886 1.066324 0.891833 0.030809 0.008848 -0.058683 1.151904 -0.064909 0.005548 0.092447 0.994226 0.980543 0.036553 0.977629 0.908112 1.053035 1.015332 1.120582 1.029707 0.935519 0.767415 -0.107332 1.106993 0.051063 -0.090849 -0.152447 1.074408 0.930237 -0.134191 -0.041339 1.154220 0.912402 0.915882 -0.155688 0.004278 1.005960 -0.029173 0.929692 0.891253 0.904414 -0.022210 0.912185 0.032760 -0.175809 1.064184 0.004444 1.023131 0.014814 0.025559 0.065555 0.781532 -0.029379 -0.197955 0.897852 -0.013217 1.093294 0.004968 -0.102189 1.031592 0.748643 0.996666 0.053363 -0.174095 0.022123 1.073767 0.026629 0.817199 0.923850 0.016734 1.000997 0.181206 0.011231 0.956073 0.190711 0.864217 -0.176983 1.016978 1.028389 0.023092 0.841323 1.197465 -0.032185 -0.023935 -0.154948 0.938794 0.022079 0.018001 0.863273 0.095137 -0.103529 1.048691 1.044424 1.076913 -0.091685 1.016448 0.235867 -0.191122 1.021688 0.903834 1.103008 1.062811 0.974671 0.808982 0.919788 0.797299 0.003866 0.924240 1.138022 1.138392 -0.086041 -0.072381 1.089510 0.997304 -0.196238 -0.081117 0.998652 -0.136927 1.094476 1.025478 1.128812 -0.043799 -0.160622 1.202644 -0.097115 1.028359 1.128248 1.149200 0.046912 1.215106 0.095300 0.230991 -0.177631 1.060265 0.025009 -0.087069 -0.045585 0.107297 0.905981 1.067101 1.105134 0.200901 0.832244 -0.158358 0.063741 -0.002433 0.178939 1.150184 -0.013758 0.739082 0.970621 1.116445 -0.077580 0.874011 -0.000811 0.757786 1.027494 0.948749 0.128206 1.197540 -0.121973 -0.035650 0.227456 1.012591 0.093402 0.788900 0.046330 1.127347 0.937960 0.147998 0.295156 0.047168 -0.449697 1.185666 1.027567 1.056837 0.896828 0.093411 0.188188 1.051113 0.196550 0.986178 0.963111 1.064836 0.986799 0.068409 0.940694 0.044600 0.930849 0.776664 1.119660 0.877476 -0.187121 0.889222 0.896426 1.114193 0.109176 0.974296 0.017034 0.058848 0.003626 -0.056434 -0.053055 -0.327863 1.110462 1.191687 0.833810 -0.093180 1.062518 0.877602 0.130458 1.046517 0.945395 -0.042202 0.884421 0.076614 0.998365 0.963405 -0.042360 1.233324 1.032498 0.850640 0.878991 1.172081 -0.131938 0.138522 1.031223 -0.060356 1.045766 1.146384 1.014251 1.035122 1.033944 0.910994 0.140291 0.017496 0.074785 0.017803 1.051564 0.940908 1.102397 0.914000 -0.151381 -0.037398 0.841172 0.980431 0.926522 1.010521 0.906633 0.898542 -0.046207 1.056040 -0.119697 -0.388635 1.042092 1.062407 -0.114191 0.973897 0.038767 0.170771 0.104476 0.108748 0.973779 0.829369 0.903094)
       )
     )
  )


;;; ---------------------------------------- even-numbered harmonics (and fundamental) ----------------------------------------

(define neven-min-peak-phases (vector 

(vector 1 1.0 #r(0)
    )

(vector 2 1.7601724863052 #r(0 0)
    )

;;; 3 even --------------------------------------------------------------------------------
(vector 3 2.2325525283813 #r(0 0 0)
    2.0235652605711 #r(0 33/64 63/128)

    2.0214650630951 #r(0.0 0.52414411306381 0.48787820339203)
    2.021465 #r(0.000000 0.475854 0.512123)
    2.021465 #r(0.000000 0.524145 0.487877)
    2.021465 #r(0.000000 1.475854 1.512123) ; etc
    )

;;; 4 even --------------------------------------------------------------------------------
(vector 4 2.8359191417694 #r(0 0 0 0)
    2.450505601523 #r(0 3/16 21/32 15/32)

    ;2.434727537119 #r(0 37 52 46) / 31

    2.4311048984528 #r(0.000 0.191 0.672 0.479)
    2.4311048984528 #r(0.000 0.809 0.328 0.521)

    ;; (optit :even 4 1/4 (expt 2 -100) 2.8359191417694 #r(0 0 0 0))
    2.4308773660653 #r(0.0 -1.907463741733863571425899863243103027344E-1 -6.709215487223971763341978657990694046021E-1 -4.783757035623090736464746441924944519997E-1)

    ;; (optit :even 4 1/4 (expt 2 -100) 2.450505601523 #r(0 3/16 21/32 15/32))
    2.430877366065 #r(0.0 1.907463741737958073940717440564185380936E-1 6.709215487230322239042834553401917219162E-1 4.783757035631506226991405128501355648041E-1)
    2.4305741786957 #r(0.0 0.19146482345276 0.67236139177392 0.47990912646831)
    )

;;; 5 even --------------------------------------------------------------------------------
(vector 5 2.816308259964 #r(0 1 0 0 0)

    2.6048328876495 #r(0.0 1.7889379262924 0.49464252591133 0.018512051552534 0.013387856073678)

    2.604848 #r(0.000000 0.211049 1.505353 1.981536 -0.013355)
    )

;;; 6 even --------------------------------------------------------------------------------
(vector 6 2.9795869831363 #r(0 0 1 0 0 0)

    2.8369779013614 #r(0.0 0.17925976781335 1.4035822186281 0.79344665247706 0.91203230191116 1.0958477007498)

    2.836991 #r(0.000000 0.178390 1.402472 0.792230 0.912414 1.093877)
    2.836980 #r(0.000000 1.821818 0.597785 1.208038 1.087532 0.906567)
    2.836978 #r(0.000000 1.178373 0.402442 1.792189 1.912334 0.093818)
    2.836972 #r(0.000000 1.178483 0.402570 -0.207680 -0.087726 0.094035)
    2.836966 #r(0.000000 0.821717 1.597697 0.207985 0.087685 -0.093549)
    2.836953 #r(0.000000 0.821609 1.597559 0.207843 0.087745 -0.093780)
    )

;;; 7 even --------------------------------------------------------------------------------
(vector 7 3.3825581073761 #r(0 0 0 0 0 1 0)

    3.0470769405365 #r(0.0 0.503662109375 0.87483215332031 1.0009307861328 1.2656555175781 0.71012878417969 0.30850219726562)
    3.0469672679901 #r(0.0 0.50373814372209 0.87540721456314 1.0012873875657 1.2663739438299 0.71078327011007 0.30959991380794)
    3.046965 #r(0.000000 0.503616 0.874674 1.000689 1.265332 0.709676 0.308046)
    )

;;; 8 even --------------------------------------------------------------------------------
(vector 8 3.611234664917 #r(0 0 0 0 0 1 0 0)

    3.197691 #r(0.000000 1.463442 0.984712 1.413077 0.862890 0.889575 1.684691 1.613214)
    3.197689 #r(0.000000 0.536983 1.016250 0.588185 1.138902 1.112562 0.318083 0.389844)
    3.197673 #r(0.000000 0.463394 -0.015494 0.412641 1.862274 -0.111008 0.683799 0.612199)
    3.197643 #r(0.000000 1.536907 0.016088 1.587997 0.138641 0.112256 1.317694 1.389405)
    3.197539 #r(0.000000 1.536753 0.015811 1.587753 0.138248 0.111716 1.317048 1.388715)
    )

;;; 9 even --------------------------------------------------------------------------------
(vector 9 4.0601739883423 #r(0 0 0 0 0 0 1 1 0)

    3.454235 #r(0.000000 1.380130 1.542684 1.103203 1.094600 0.755189 1.642794 1.504783 0.092364)
    3.454343 #r(0.000000 0.380149 0.542653 0.103243 0.094157 1.755278 0.642603 0.504207 1.092117)
    3.454167 #r(0.000000 1.619814 1.457133 1.896576 1.905245 0.244460 1.356830 1.494866 0.907164)
    3.454104 #r(0.000000 1.619789 1.457225 1.896592 1.905347 0.244468 1.356940 1.495046 0.907280)
    3.453978 #r(0.000000 1.619848 1.457320 1.896841 1.905503 0.244896 1.357384 1.495389 0.907798)
    )

;;; 10 even --------------------------------------------------------------------------------
(vector 10 4.0054845809937 #r(0 1 1 0 0 0 0 0 1 0)

     3.559069 #r(0.000000 0.728493 1.283356 1.458356 0.068046 1.297046 -0.008724 1.763762 1.458102 1.082546)
     3.559031 #r(0.000000 1.271816 0.716134 0.541742 -0.068143 0.702758 0.008941 0.237259 0.543599 0.918279)
     3.558934 #r(0.000000 0.270311 1.713387 1.540231 0.930533 1.700561 1.006089 1.239216 1.544459 1.919820)
     3.558711 #r(0.000000 0.271020 1.715408 1.541006 0.931409 1.702058 1.007613 1.237445 1.543048 1.918285)
     )

;;; 11 even --------------------------------------------------------------------------------
(vector 11 4.2368197441101 #r(0 0 1 1 0 1 1 1 0 0 0)

     3.656997 #r(0.000000 0.364553 0.246524 0.545081 1.820586 -0.010486 0.065265 0.895857 0.689390 0.398119 1.238723)
     3.656853 #r(0.000000 0.636042 0.753996 0.455733 1.180490 1.011649 0.936897 0.106845 0.312362 0.605377 1.764604)
     3.656814 #r(0.000000 1.363823 1.245209 1.543687 0.818338 0.986715 1.061848 1.892251 1.683956 1.393470 0.233084)
     3.656676 #r(0.000000 1.635670 1.752596 1.453762 0.177717 0.008296 -0.065661 1.103599 1.306278 1.601279 0.759437)
     3.656141 #r(0.000000 1.635206 1.752773 1.453484 0.177816 0.008586 -0.066147 1.102294 1.308244 1.599463 0.758738)
     )

;;; 12 even --------------------------------------------------------------------------------
(vector 12 4.4100483425078 #r(0 0 0 1 1 0 1 0 0 0 0 0)

     3.787770 #r(0.000000 1.448638 0.653979 0.460567 1.750296 1.187409 1.823828 0.621465 0.835166 0.896814 0.649295 0.954712)
     3.787607 #r(0.000000 1.552098 0.349619 0.543969 1.255255 1.818801 1.184427 0.387699 0.175349 0.115468 0.364328 0.059990)
     3.787594 #r(0.000000 0.551763 1.347551 1.541126 0.252553 0.815620 0.180247 1.383525 1.170726 1.109400 1.357991 1.052935)
     3.786929 #r(0.000000 0.551301 1.345490 1.538545 0.249324 0.811835 0.175379 1.377915 1.164645 1.102028 1.349918 1.044104)
     )

;;; 13 even --------------------------------------------------------------------------------
(vector 13 4.4076361656189 #r(0 0 1 0 1 1 0 0 1 1 1 1 1)

     3.973518 #r(0.000000 1.227848 0.569459 0.032525 1.602849 0.995992 1.561449 0.851502 1.005100 0.700156 1.033637 1.225072 1.740227)
     3.973285 #r(0.000000 0.221343 1.559694 1.013474 0.580564 -0.035047 0.522724 -0.190833 -0.044249 1.645456 -0.025041 0.160741 0.667019)
     3.973148 #r(0.000000 0.225623 1.564256 1.022022 0.590378 -0.019884 0.539658 -0.171656 -0.022033 1.670109 0.001495 0.190555 0.699291)
     3.973041 #r(0.000000 0.226214 1.565751 1.024299 0.592784 -0.015292 0.545848 -0.164098 -0.014254 1.677783 0.010954 0.201582 0.710821)
     3.972554 #r(0.000000 0.227025 1.566229 1.025033 0.594027 -0.014872 0.545046 -0.165560 -0.014836 1.678196 0.010096 0.200561 0.709954)
     )

;;; 14 even --------------------------------------------------------------------------------
(vector 14 4.5770673751831 #r(0 1 1 0 0 1 1 1 1 1 1 0 1 0)

     4.097747 #r(0.000000 0.927497 0.986240 1.222647 1.417439 1.485272 1.245695 0.840056 0.775783 1.393795 0.027626 0.815063 1.945062 1.449403)
     4.096703 #r(0.000000 0.927014 0.985352 1.221418 1.415761 1.483290 1.243140 0.836933 0.772657 1.390170 0.023348 0.810693 1.940171 1.444293)
     )

;;; 15 even --------------------------------------------------------------------------------
(vector 15 4.7838921546936 #r(0 0 0 0 0 1 1 1 1 0 1 1 1 0 1)

     4.193545 #r(0.000000 1.673990 1.704095 0.184742 0.312157 1.759699 0.661838 0.338558 1.336129 0.060082 0.592895 0.470075 0.323799 1.690560 1.851587)
     4.193539 #r(0.000000 1.674972 1.705674 0.187574 0.315997 1.764079 0.667192 0.344813 1.343115 0.068186 0.601740 0.479341 0.334140 1.702389 1.863580)
     4.192089 #r(0.000000 1.673474 1.702683 0.182852 0.310553 1.756894 0.658556 0.335052 1.332116 0.055950 0.587971 0.464438 0.317829 1.684035 1.844319)
     )

;;; 16 even --------------------------------------------------------------------------------
(vector 16 5.0737318992615 #r(0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0)

     4.326467 #r(0.000000 0.954646 0.857741 0.564427 0.380619 -0.030405 0.027220 0.443651 0.347240 0.290827 1.057423 1.274647 0.193509 1.337335 0.715554 1.355809)
     4.326323 #r(0.000000 0.953094 0.856111 0.562335 0.378555 -0.035716 0.021343 0.437774 0.341052 0.283988 1.049334 1.266917 0.184364 1.326298 0.704383 1.343207)
     4.325044 #r(0.000000 0.953571 0.856165 0.561119 0.376819 -0.035768 0.021241 0.436352 0.339200 0.281830 1.047126 1.263828 0.181703 1.324018 0.701028 1.340302)
     )

;;; 17 even --------------------------------------------------------------------------------
(vector 17 5.2332563400269 #r(0 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0)

     4.464096 #r(0.000000 1.478399 1.021179 1.293532 1.222041 1.188322 1.479616 1.284032 0.091138 1.349289 0.401522 0.364537 -0.044880 1.268488 1.386805 0.039323 0.607489)
     4.463016 #r(0.000000 1.478182 1.023133 1.293051 1.222719 1.187462 1.479990 1.285327 0.088371 1.348357 0.403976 0.365587 -0.044469 1.267681 1.387786 0.039745 0.610112)
     )

;;; 18 even --------------------------------------------------------------------------------
(vector 18 5.3310880661011 #r(0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 0 0)

     4.569421 #r(0.000000 1.011793 0.580064 1.185332 1.624771 0.036509 -0.103084 0.721775 1.089226 0.493658 0.073953 1.074825 1.595710 1.108207 1.196849 1.497424 1.163445 0.995437)
     )

;;; 19 even --------------------------------------------------------------------------------
(vector 19 5.4619059562683 #r(0 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0)

     4.741489 #r(0.000000 1.217162 0.660633 0.437661 1.320878 1.235636 0.094939 -0.184508 -0.090396 0.415156 1.119340 1.141612 0.652398 0.817014 0.525642 1.150459 0.295913 0.906911 0.831168)
     )

;;; 20 even --------------------------------------------------------------------------------
(vector 20 5.5266017913818 #r(0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 0)

     4.839482 #r(0.000000 0.882739 0.097549 0.018330 1.302731 0.272028 1.407538 1.702479 0.580972 1.045015 0.992304 1.669564 0.673981 0.282219 0.289947 0.363499 1.033218 0.803741 0.771035 0.508087)
     )

;;; 21 even --------------------------------------------------------------------------------
(vector 21 5.6849967470046 #r(0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0)

     4.919735 #r(0.000000 -0.021966 1.377831 1.499470 -0.139205 1.937761 0.320320 0.217546 0.069290 0.938854 1.308616 0.123782 0.469963 1.818882 1.581666 1.414927 0.056553 1.301602 0.788305 1.336052 0.607478)
     )

;;; 22 even --------------------------------------------------------------------------------
(vector 22 5.8572781078687 #r(0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0)
     
     5.055233 #r(0.000000 -1.550778 1.843415 0.900724 0.955590 0.677531 1.390686 0.133831 1.229871 1.016503 1.245622 1.546957 -1.869615 1.414871 -0.060378 -0.077148 1.210164 1.132173 0.909114 1.325478 1.285781 0.509617)
     )

;;; 23 even --------------------------------------------------------------------------------
(vector 23 5.9208135892745 #r(0 0 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 0 0)

     5.147900 #r(0.000000 0.493561 0.617878 0.386087 -0.215675 1.136922 0.632292 0.891205 1.398746 0.878537 0.676611 0.945565 0.610792 -0.182076 0.354229 1.383426 1.649635 0.414770 0.152656 0.561509 0.267633 1.102796 1.466348)
     )

;;; 24 even --------------------------------------------------------------------------------
(vector 24 6.0318420391191 #r(0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0)

     5.253162 #r(0.000000 0.045084 0.641921 -0.205904 0.266767 1.228115 0.912709 0.214922 1.487762 1.357882 0.864877 0.404420 0.601935 0.594931 0.069420 1.052347 1.659787 1.624121 0.035857 0.245103 1.406872 0.042697 -0.053953 0.167577)

     5.253153 #r(0.000000 0.045202 0.642246 -0.205352 0.266926 1.228585 0.913398 0.215740 1.488650 1.358650 0.865965 0.405240 0.603061 0.596132 0.070695 1.053498 1.661316 1.625634 0.037488 0.246663 1.408918 0.044558 -0.052337 0.169870)
     )

;;; 25 even --------------------------------------------------------------------------------
(vector 25 6.1513186981755 #r(0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1)

     5.403228 #r(0.000000 0.045060 1.794212 1.406802 1.249045 0.257853 0.430644 -0.020674 0.209605 1.159346 1.742584 0.244624 1.006989 0.948352 0.613996 0.229169 0.745474 0.773295 0.271006 1.529917 0.384835 1.822065 0.327936 0.153008 0.689262)

     5.408253 #r(0.000000 -0.043635 1.870808 1.373617 1.322838 0.337670 0.345509 0.039602 0.231587 1.174477 1.746219 0.272425 1.051956 0.894710 0.701095 0.201178 0.713607 0.745859 0.396015 1.495521 0.465720 1.748739 0.254514 0.207309 0.670746)
     )

;;; 26 even --------------------------------------------------------------------------------
(vector 26 6.2921685546205 #r(0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0)

     5.452331 #r(0.000000 0.051327 0.204117 1.807782 0.408597 -0.021081 0.115796 0.407761 0.824888 0.626144 0.637118 0.067354 0.844059 0.574978 -0.127497 -0.091341 1.702516 0.546084 0.986055 1.260143 0.631019 1.781357 1.305578 1.812413 0.666374 0.989339)
     )

;;; 27 even --------------------------------------------------------------------------------
(vector 27 6.2436904245852 #r(0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1)

     5.620374 #r(0.000000 -0.021456 0.516604 0.372410 0.864531 1.336703 -0.209149 1.689313 0.033950 1.772624 0.571345 1.616802 0.355488 1.092886 1.391271 1.240098 1.111612 0.854249 0.888716 0.157123 -0.311986 1.252460 1.082038 -0.272435 1.564985 0.964546 1.600742)
     )

;;; 28 even --------------------------------------------------------------------------------
(vector 28 6.5361909866333 #r(0 0 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1)

     5.731679 #r(0.000000 1.447589 1.395977 0.797533 1.295906 1.462640 1.534875 1.774902 1.013697 0.705377 0.626264 1.242696 1.362454 0.181714 0.805604 1.271981 0.570662 1.779635 -0.124462 1.352040 -0.225912 1.764222 0.153642 1.298969 0.773437 0.201599 0.803480 0.102660)

     5.757769 #r(0.000000 -0.064452 1.194800 0.947245 0.026529 0.920008 0.673833 0.051447 -0.007043 1.637680 1.814843 1.945096 0.720067 0.530198 0.753640 0.603773 1.296939 0.860024 0.197512 0.571117 0.903138 1.152266 0.326717 0.457781 -0.069831 0.864587 1.677694 0.471749)
     )

;;; 29 even --------------------------------------------------------------------------------
(vector 29 6.6767044067383 #r(0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1)

     5.766338 #r(0.000000 1.750571 1.825931 1.106253 0.681108 0.654013 0.530242 0.078216 0.174544 1.354195 1.454712 1.045782 1.722411 1.607453 0.347380 0.849326 0.377709 1.136286 1.004911 0.970793 0.410809 0.919085 1.010160 0.193230 0.966878 0.662369 1.289507 1.533180 0.429508)
     )

;;; 30 even --------------------------------------------------------------------------------
(vector 30 6.6998701095581 #r(0 0 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 0)

     5.906955 #r(0.000000 0.906624 1.374273 1.276597 -0.178673 0.094922 0.333601 0.129339 0.400307 0.946356 1.401096 0.557587 0.654474 1.274947 0.061009 -0.048005 1.903626 1.753056 1.439902 1.944968 1.607217 1.115332 0.419220 1.617499 1.734563 1.091117 0.095163 0.781775 -0.001559 1.852411)

     5.930402 #r(0.000000 -0.023546 1.489564 1.475097 0.916826 0.864026 1.899229 1.607559 0.910332 0.924096 1.371927 0.795577 0.542873 0.396054 0.844978 1.658639 0.174074 0.939529 1.326938 1.039010 1.301858 1.417763 1.619561 1.723680 0.850267 0.018519 1.089727 0.405902 1.206335 1.833260)
     )

;;; 31 even --------------------------------------------------------------------------------
(vector 31 6.8660564422607 #r(0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0)

     5.987789 #r(0.000000 1.294084 1.380328 1.151198 1.131917 1.032100 1.467500 1.317593 1.561230 1.149337 1.426512 0.310391 0.093956 -0.092069 1.618651 0.385482 1.276093 0.768907 0.092705 1.372235 0.935730 0.030657 0.353616 1.817773 0.372502 0.700675 1.341184 1.537494 1.331726 0.302069 0.818207)
     )

;;; 32 even --------------------------------------------------------------------------------
(vector 32 6.9974670410156 #r(0 0 0 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 0)

     6.061091 #r(0.000000 0.284769 1.824838 0.360868 1.114185 0.962149 1.153553 1.836957 0.183317 1.504519 0.431670 1.106470 0.465083 1.359049 1.532974 1.672623 0.833072 1.851412 -0.259099 1.829526 0.240313 0.782734 0.067562 1.704922 0.670838 0.000337 1.835105 1.184487 1.464400 1.660678 0.971147 1.137597)
     )

;;; 33 even --------------------------------------------------------------------------------
(vector 33 6.978609085083  #r(0 0 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 1 0 1 1 0)

     6.162617 #r(0.000000 -0.095863 -0.402980 1.394421 -0.306134 0.366840 0.337119 0.377845 0.129322 0.155850 1.349812 0.235845 0.252319 0.242909 1.431344 1.664418 1.236043 1.670315 1.653641 0.461681 0.695631 0.916345 0.353418 1.885954 1.309177 0.582371 1.382992 1.788982 0.399357 0.760664 0.154447 0.882692 0.073082)
     6.161940 #r(0.000000 -0.089768 -0.397651 1.380488 -0.296115 0.371420 0.345733 0.379911 0.132923 0.160976 1.358964 0.245096 0.262235 0.223412 1.423478 1.677942 1.241899 1.681613 1.672008 0.466592 0.705799 0.934883 0.362064 1.890359 1.331917 0.587637 1.400151 1.803286 0.414943 0.770222 0.167447 0.874856 0.070813)
     )

;;; 34 even --------------------------------------------------------------------------------
(vector 34 7.2615523338318 #r(0 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0)

     6.222816 #r(0.000000 -0.031974 0.094234 0.502100 0.850042 0.574691 0.752336 1.914959 -0.024174 0.146232 0.295078 1.383128 -0.007584 0.943763 1.235227 0.413741 0.587141 -0.053979 1.839683 0.252526 0.156123 0.682869 0.409598 -0.127649 0.823619 0.505563 1.228553 1.452425 1.154757 0.224780 1.122198 1.589227 1.075252 0.529430)
     )

;;; 35 even --------------------------------------------------------------------------------
(vector 35 7.2921919822693 #r(0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0)

     6.362258 #r(0.000000 -0.109595 1.553671 0.219728 0.238496 1.170971 0.131935 0.808676 1.471325 1.403853 0.916637 1.560710 -0.099827 1.196395 0.221158 1.202313 0.775632 0.876517 1.782554 1.124579 1.420710 0.952275 0.641256 1.819844 1.425015 -0.516862 1.352551 1.568353 1.482981 0.524776 0.577204 0.865347 -0.128894 -0.102429 0.426519)
     6.361719 #r(0.000000 -0.110076 1.552929 0.219162 0.236735 1.172346 0.133490 0.808935 1.471212 1.403523 0.917858 1.560138 -0.097659 1.196647 0.222164 1.202507 0.775221 0.877704 1.784095 1.125472 1.421754 0.952526 0.640748 1.820898 1.425049 -0.515027 1.354970 1.568414 1.484179 0.525947 0.577101 0.869046 -0.129339 -0.102295 0.425922)
     )

;;; 36 even --------------------------------------------------------------------------------
(vector 36 7.3326554298401 #r(0 0 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0)

     6.432117 #r(0.000000 0.004340 0.086403 1.388728 0.898065 1.458617 0.131985 1.657435 1.521273 1.472417 0.951218 1.324245 1.241442 1.395549 0.150266 1.064974 0.650640 1.427046 1.086279 0.098701 0.328772 1.795832 1.461165 0.857821 1.693245 1.032679 1.245848 0.174782 -0.135078 0.155045 -0.013817 0.388292 0.719587 1.603641 0.575715 0.836424)
     6.431620 #r(0.000000 0.006000 0.080554 1.389520 0.900116 1.459969 0.132102 1.664590 1.525093 1.474799 0.953152 1.333207 1.242869 1.398672 0.151209 1.068678 0.656814 1.431920 1.083387 0.098458 0.329358 1.795094 1.464539 0.858423 1.694073 1.035274 1.250013 0.177341 -0.128516 0.159400 -0.011010 0.388177 0.716334 1.600747 0.574942 0.831074)
     )

;;; 37 even --------------------------------------------------------------------------------
(vector 37 7.4919209480286 #r(0 1 1 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0)

	6.533287 #r(0.000000 0.011564 0.880733 1.522736 0.250376 0.789024 1.673119 0.570623 1.276735 0.341425 -0.532081 0.348007 -0.836598 0.457646 -0.009210 1.409326 1.013302 0.369886 1.439731 1.104224 1.371479 0.882940 0.611993 0.167228 0.213651 -0.123007 -0.145430 -0.035562 0.326284 0.342544 0.027533 0.469211 0.589131 1.242729 -0.350729 -0.122043 0.359222)
	6.530177 #r(0.000000 0.005180 0.879021 1.499280 0.275160 0.799109 1.677585 0.544852 1.266168 0.345286 -0.530036 0.352059 -0.808225 0.494187 0.001305 1.415607 1.022846 0.371397 1.442210 1.100282 1.338874 0.863557 0.625344 0.182117 0.191106 -0.132868 -0.127650 -0.033705 0.307163 0.314512 0.001878 0.475351 0.638583 1.230561 -0.337497 -0.118088 0.370183)
     )

;;; 38 even --------------------------------------------------------------------------------
(vector 38 7.669114112854 #r(0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 0)

     6.536590 #r(0.000000 -0.020563 1.377251 1.769036 0.243537 1.765876 1.779834 1.045673 1.286350 0.293614 0.321305 1.723518 1.560003 0.401205 0.333918 -0.059485 0.232219 0.960903 1.594163 1.401434 0.649608 0.412099 1.329747 0.099455 1.939824 0.267997 0.403580 1.515217 0.579512 0.002234 0.262847 1.800156 0.419089 1.615975 1.110793 1.305676 1.421012 1.714827)
     6.535958 #r(0.000000 -0.016047 1.375557 1.774409 0.240697 1.758438 1.787887 1.049055 1.285090 0.290003 0.323134 1.732540 1.557371 0.401752 0.328608 -0.066450 0.228846 0.961168 1.593631 1.398529 0.653699 0.406608 1.324320 0.103681 1.934570 0.275301 0.402675 1.517210 0.582543 0.007477 0.262240 1.801738 0.419772 1.606650 1.104008 1.310911 1.419744 1.728289)
     )

;;; 39 even --------------------------------------------------------------------------------
(vector 39 8.0062685830938 #r(0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 0)

     6.683157 #r(0.000000 1.091390 0.284404 0.240879 1.660743 1.656550 0.223587 1.552502 0.232972 0.325977 1.767287 0.511127 0.573904 0.685387 0.354731 1.006014 0.648089 0.445081 1.696394 0.327980 -0.210151 0.338005 -0.052572 -0.119111 0.551717 1.087945 0.035621 1.385382 0.802270 1.342811 0.005749 0.410111 0.489512 1.361009 1.309724 1.490142 1.368577 0.636471 0.518214)
     6.680209 #r(0.000000 1.091428 0.280383 0.244205 1.670732 1.669488 0.224029 1.575189 0.233312 0.318787 1.768213 0.518384 0.569316 0.693754 0.363934 1.013259 0.661691 0.458578 1.700546 0.350928 -0.213387 0.356085 -0.045461 -0.104865 0.565481 1.088276 0.042255 1.397895 0.807270 1.344295 0.014241 0.398536 0.486672 1.385842 1.323567 1.486471 1.397014 0.644495 0.514685)
     )

;;; 40 even --------------------------------------------------------------------------------
(vector 40 8.0304555793911 #r(0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 0 1)

     6.748142 #r(0.000000 0.029455 0.022065 0.136105 1.638522 1.203180 0.744941 -0.148784 0.506171 0.560051 -0.084723 -0.078289 0.149301 0.575133 1.046850 1.733499 1.932780 1.304846 -0.055855 1.484587 1.130478 0.869457 1.564935 1.665772 1.478237 0.851162 0.123617 0.568797 1.544770 0.060395 1.377474 0.739849 -0.238843 1.303906 1.521850 1.552033 0.224167 1.493979 0.103832 0.387098)
     6.747628 #r(0.000000 0.028396 0.023284 0.137090 1.639113 1.203686 0.744505 -0.148612 0.506591 0.560243 -0.084058 -0.079706 0.150354 0.575406 1.047012 1.731999 1.933088 1.304747 -0.055909 1.483517 1.131264 0.871845 1.564235 1.665008 1.479340 0.852900 0.123210 0.569321 1.544830 0.060646 1.376451 0.740700 -0.238394 1.304019 1.522364 1.550202 0.223048 1.493425 0.104840 0.387772)
     )

;;; 41 even --------------------------------------------------------------------------------
(vector 41 8.2169809341431 #r(0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0)

     6.881035 #r(0.000000 0.133290 0.436430 -0.019956 0.597994 -0.299445 0.298044 -0.291816 -0.125561 1.379945 1.227240 1.012471 0.995085 0.165521 0.059156 -0.315277 -0.410140 1.321719 -0.217071 0.006502 1.718169 0.636248 0.520158 0.977079 1.417462 -0.764436 1.377242 0.286309 1.475385 1.360726 0.551504 -0.329940 1.190956 0.377718 1.221012 1.703028 0.053941 0.664915 1.563928 1.320457 0.168607)
     6.880353 #r(0.000000 0.135702 0.436760 -0.018715 0.600438 -0.298825 0.298468 -0.293952 -0.126948 1.377543 1.225061 1.010086 0.994900 0.165805 0.056718 -0.315888 -0.413100 1.322145 -0.217343 0.005506 1.717653 0.634203 0.520907 0.977473 1.415853 -0.764924 1.376221 0.284984 1.473542 1.362417 0.550900 -0.330993 1.189698 0.376721 1.222396 1.700794 0.053091 0.666251 1.562750 1.319150 0.169270)
     )

;;; 42 even --------------------------------------------------------------------------------
(vector 42 8.3605623245239 #r(0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1)
     
     6.941481 #r(0.000000 -0.007293 1.286795 1.752349 -0.276621 1.210682 0.997503 0.480778 0.607692 1.419140 -0.000887 0.317063 0.225619 -1.792990 -0.085405 1.621718 1.141369 0.612500 1.711137 0.371822 0.494518 1.158070 0.720118 -0.061260 0.895705 0.558493 0.565336 0.673764 0.965927 1.131140 0.011389 1.067604 1.758075 0.687249 0.164819 0.032158 0.192333 0.816334 0.404498 1.292703 0.160108 0.486834)
     6.939974 #r(0.000000 -0.011476 1.282513 1.747339 -0.277688 1.211500 1.007410 0.488428 0.606299 1.401073 -0.002078 0.313765 0.237406 -1.794782 -0.081922 1.631362 1.138956 0.607469 1.715948 0.367593 0.487696 1.161873 0.717506 -0.061322 0.892863 0.566417 0.552814 0.668102 0.957673 1.124783 0.001669 1.055782 1.736467 0.689242 0.148964 0.036152 0.189064 0.816794 0.403572 1.283363 0.154311 0.470068)
     )

;;; 43 even --------------------------------------------------------------------------------
(vector 43 8.3471550144283 #r(0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0)

     7.055197 #r(0.000000 0.047763 1.657931 1.619393 1.901312 1.535197 1.519084 0.139389 -0.012074 1.734976 0.124057 1.726677 0.967925 0.859090 0.315172 0.782383 0.749080 1.794616 -0.192964 1.214822 1.594002 0.299675 1.830679 1.396713 1.089896 0.461626 0.318824 0.888695 1.307168 1.600142 0.874003 1.625797 0.872538 1.803252 0.868969 0.618677 0.932144 0.968270 1.700058 0.258149 0.614848 0.031586 0.805044)
     7.051741 #r(0.000000 0.051990 1.655214 1.614096 1.907068 1.555280 1.515249 0.134511 -0.008664 1.732014 0.139869 1.723565 0.949408 0.871522 0.314394 0.786924 0.732932 1.794506 -0.190910 1.208261 1.598287 0.291774 1.820337 1.379860 1.075510 0.465725 0.309719 0.898505 1.316947 1.589390 0.877160 1.604060 0.883546 1.819205 0.861308 0.626832 0.933402 0.982260 1.688986 0.256547 0.614293 0.017902 0.815483)
     )

;;; 44 even --------------------------------------------------------------------------------
(vector 44 8.4271850585938 #r(0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 1 1)

     7.048255 #r(0.000000 -0.024272 1.042039 1.706381 0.915231 0.667566 0.791468 1.060500 0.486474 0.357952 1.448848 0.555099 0.559674 0.047957 0.101663 0.263196 0.561105 1.754886 1.445748 0.607834 0.094941 0.549126 0.219045 0.643754 0.108792 0.622710 0.657739 1.176141 0.892775 1.899443 0.047927 1.097541 1.395320 1.432930 0.524754 1.590031 -0.111160 0.804186 0.328664 0.621384 1.470620 1.417525 -0.298999 1.020701)
     7.039071 #r(0.000000 -0.013925 1.023977 1.694880 0.930341 0.651512 0.795511 1.050515 0.480329 0.354015 1.426204 0.565497 0.572134 0.017162 0.112749 0.257720 0.557774 1.761476 1.449185 0.624483 0.049559 0.540675 0.195927 0.677804 0.145100 0.602117 0.677838 1.156300 0.887800 1.868297 0.021883 1.107061 1.432208 1.416051 0.540282 1.556144 -0.158254 0.781340 0.300342 0.637855 1.472235 1.471264 -0.329868 1.025266)
     )

;;; 45 even --------------------------------------------------------------------------------
(vector 45 8.6353975051189 #r(0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1)

     7.165216 #r(0.000000 0.100769 0.427512 0.242955 0.443088 -0.380155 1.940929 -0.101098 -0.133968 -0.026473 1.678192 1.774836 0.508005 0.350465 0.553068 1.094302 0.286670 -1.617200 0.541014 0.212204 1.154970 1.344936 0.804485 1.614258 1.391670 0.188798 0.475817 0.610176 0.585642 -0.044233 1.516307 0.921356 1.091747 0.246161 0.592046 1.532410 0.320765 0.050475 1.141805 0.866052 0.300507 0.986581 -0.103223 1.338567 0.196051)
     7.164277 #r(0.000000 0.107694 0.427808 0.236493 0.439176 -0.374197 1.937652 -0.102495 -0.132721 -0.032953 1.675111 1.775652 0.507632 0.340555 0.542717 1.099543 0.276662 -1.622952 0.531824 0.218194 1.152824 1.344859 0.799252 1.617912 1.391892 0.192249 0.469216 0.602449 0.590449 -0.058189 1.514734 0.926343 1.087922 0.239108 0.589019 1.537544 0.316405 0.049287 1.141222 0.866006 0.287862 0.971067 -0.103613 1.326005 0.198578)
     )

;;; 46 even --------------------------------------------------------------------------------
(vector 46 8.7939519711145 #r(0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0)

     7.276006 #r(0.000000 -0.054506 1.032755 -0.130142 -0.261502 1.224902 0.252129 0.556107 0.758621 1.480820 -0.142360 1.184737 0.014000 1.776705 0.882036 1.883695 0.222183 0.298085 0.448405 1.172485 0.678362 1.341204 0.081280 -0.085381 0.763100 -0.029414 -0.367000 0.048240 1.040410 1.413704 0.227444 -0.058776 -0.204130 1.202166 1.632528 1.205475 1.219937 1.182203 -0.061521 1.269256 0.937830 0.491219 -0.180909 0.028085 1.489097 0.059386)
     7.274042 #r(0.000000 -0.051277 1.027390 -0.132315 -0.261291 1.228854 0.251032 0.552380 0.763319 1.475452 -0.143798 1.181971 0.013380 1.773607 0.881801 1.886030 0.224945 0.302202 0.441836 1.175852 0.673622 1.344439 0.083924 -0.087160 0.770933 -0.028156 -0.368444 0.042592 1.039360 1.409391 0.224578 -0.058999 -0.207178 1.197154 1.631467 1.203180 1.212389 1.178680 -0.059957 1.263246 0.941340 0.484593 -0.188237 0.022295 1.493842 0.056638)
     )

;;; 47 even --------------------------------------------------------------------------------
(vector 47 8.7835607528687 #r(0 0 0 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 1 1)

     7.292551 #r(0.000000 -0.062265 1.442422 1.057676 1.927078 0.605872 0.092606 0.058532 0.177290 1.141099 0.824596 0.143569 1.542821 0.439342 0.943358 1.070588 0.909454 0.332472 1.825929 1.744493 0.079522 0.781524 1.378798 1.290207 0.477850 0.651309 0.041772 0.753335 1.194909 0.871931 1.816269 1.466251 1.199198 1.733301 1.531356 -0.102896 0.905701 1.309802 1.098908 1.238880 1.394185 0.875551 1.145434 -0.145313 0.593458 0.073230 0.938656)
     7.289833 #r(0.000000 -0.084036 1.432202 1.038781 1.950274 0.643485 0.068192 0.031910 0.175982 1.154336 0.840376 0.162660 1.553338 0.428086 0.958882 1.078146 0.916135 0.329186 1.812161 1.725702 0.107796 0.801029 1.365926 1.322756 0.454281 0.641662 0.067460 0.812185 1.185908 0.895886 1.814744 1.472340 1.187400 1.730085 1.557437 -0.068103 0.961873 1.346362 1.135399 1.218693 1.372521 0.881925 1.187221 -0.077728 0.628762 0.087203 0.981360)
     )

;;; 48 even --------------------------------------------------------------------------------
(vector 48 8.9965600967407 #r(0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1)

	7.406994 #r(0.000000 0.047945 0.826536 0.973372 1.740017 0.529769 1.008330 1.827057 0.727986 1.449120 0.514522 1.295511 0.015768 1.206235 0.269772 1.336523 0.110706 1.398598 0.887898 1.776715 1.044804 0.419039 -0.057090 1.238424 0.514960 0.147966 1.655287 1.338551 0.870612 0.661410 0.361317 0.267510 -0.382725 -0.031215 1.567563 1.583622 1.671939 1.775367 1.875910 1.638385 1.546190 0.129055 0.397477 0.763475 0.970476 1.468225 1.622446 0.158949)
	7.392344 #r(0.000000 0.041989 0.861058 0.962468 1.692550 0.528740 1.024259 1.846307 0.716582 1.454867 0.482722 1.288115 0.005482 1.234309 0.262300 1.329545 0.131162 1.430020 0.835179 1.760914 1.026634 0.423777 -0.011457 1.278725 0.497659 0.158517 1.709205 1.351746 0.876088 0.681233 0.363631 0.260083 -0.372612 -0.063945 1.609636 1.595878 1.709081 1.757152 1.898429 1.643054 1.528083 0.139338 0.402100 0.779097 1.034633 1.503447 1.629751 0.183091)
     )

;;; 49 even --------------------------------------------------------------------------------
(vector 49 9.1650037765503 #r(0 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0)

	7.532053 #r(0.000000 0.041305 0.532327 1.215473 1.024214 1.052795 0.585923 1.613470 1.301563 0.656356 1.815283 1.368492 -0.020005 0.356482 1.940348 0.124177 0.127083 1.593092 1.501593 0.678778 0.554128 0.952456 -0.422395 1.575963 0.870840 0.819687 0.743668 0.245617 0.895216 0.369895 0.471783 1.223006 0.679195 1.170671 0.931311 1.629049 0.745807 0.483912 0.397101 0.224181 0.816909 1.126241 1.477811 0.320980 1.574780 0.412692 0.741112 1.583749 0.654625)
	7.528963 #r(0.000000 0.025796 0.542400 1.221275 1.027807 1.048881 0.579715 1.623597 1.304022 0.646018 1.813995 1.364556 -0.023380 0.351532 1.944763 0.139707 0.122998 1.590897 1.500086 0.679592 0.550010 0.935112 -0.422992 1.572225 0.854349 0.812136 0.740870 0.257088 0.891426 0.375100 0.443922 1.209635 0.678555 1.187921 0.933346 1.608133 0.754516 0.492881 0.403863 0.222111 0.791315 1.109188 1.486048 0.297140 1.571132 0.381610 0.730980 1.585357 0.658651)
     )

;;; 50 even --------------------------------------------------------------------------------
(vector 50 9.1582123370176 #r(0 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1)

	7.553949 #r(0.000000 0.001153 1.444901 -0.126735 -0.207597 1.037485 0.982912 0.657278 1.609015 0.548946 0.388265 1.860455 1.146064 0.991559 1.714083 0.419464 0.114879 0.538313 1.517340 1.406138 0.768916 1.006070 1.575014 1.565071 1.458974 0.980173 1.203265 1.481696 -0.150280 1.613515 0.690225 0.227360 0.618441 0.290246 1.012000 0.302852 -0.136236 -0.046604 1.075996 0.025371 0.550031 1.195469 0.193455 0.810822 0.527380 1.640757 0.113795 0.191137 1.871211 0.281051)
	7.547107 #r(0.000000 0.031868 1.397571 -0.229462 -0.248337 0.985174 0.797872 0.567031 1.538504 0.581471 0.395462 1.817148 1.102560 0.918084 1.654360 0.326944 0.011851 0.556327 1.590725 1.453292 0.727461 0.927759 1.546104 1.487290 1.485538 0.934774 1.075778 1.544753 -0.203760 1.697754 0.512269 0.290368 0.574819 0.284759 0.964263 0.133726 -0.145603 -0.080649 1.030600 0.038821 0.553063 1.188703 0.128936 0.847862 0.398867 1.774273 0.047566 0.064041 1.784664 0.244537)
     )

;;; 51 even --------------------------------------------------------------------------------
(vector 51 9.3615226745605 #r(0 0 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0)

	7.601889 #r(0.000000 -0.097299 1.522524 0.604656 1.190459 -0.046061 1.637924 0.391838 1.914014 1.191379 0.937217 0.903859 1.190560 -0.310642 0.795112 0.607488 1.496318 -0.432640 -0.101925 0.993972 1.031274 1.167246 0.466609 0.643027 0.235799 0.569210 0.641350 0.632197 0.268712 1.299950 1.493958 0.876871 -0.115765 0.447597 1.299543 -0.601543 0.991250 1.221680 0.433618 1.269835 0.891674 -0.222937 1.508906 1.194487 1.696510 0.136336 0.547118 0.154250 -0.399784 0.814800 1.474647)
	7.568561 #r(0.000000 -0.176109 1.559676 0.628231 1.207241 0.011758 1.593685 0.362952 1.845250 1.221521 0.935951 0.879199 1.173416 -0.322322 0.823235 0.690110 1.462830 -0.472669 -0.099342 0.958199 1.045903 1.131435 0.514297 0.608428 0.294087 0.558567 0.598851 0.631120 0.215182 1.202641 1.412924 0.839936 -0.189783 0.391594 1.311224 -0.628842 0.969088 1.206622 0.390013 1.225874 0.831020 -0.254475 1.488215 1.198893 1.660505 0.153171 0.589831 0.097658 -0.493115 0.832657 1.410178)
     )

;;; 52 even --------------------------------------------------------------------------------
(vector 52 9.449512348335 #r(0 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1)

	7.715514 #r(0.000000 -0.034843 1.299671 1.297722 1.635310 -0.140716 1.100950 -0.118100 0.547763 0.498559 0.115301 1.387617 0.497862 0.517177 1.775867 1.036003 1.303001 0.627699 1.126538 0.667873 0.716185 0.672233 0.573373 1.713393 1.674703 1.675881 -0.219625 0.205462 0.688511 -0.167042 0.095308 -0.056923 0.925655 1.318413 1.379568 1.567357 0.318805 -0.064577 1.458169 1.228224 0.320505 1.504325 0.170852 1.908593 0.774335 0.156462 0.959528 -0.009590 -0.029886 1.318052 1.521653 0.208620)
	7.705039 #r(0.000000 -0.120160 1.339340 1.336393 1.596047 -0.162471 1.078938 -0.144525 0.558272 0.478329 0.119472 1.390538 0.505661 0.502476 1.790071 1.049001 1.328756 0.582830 1.143369 0.675881 0.702829 0.651237 0.534339 1.745506 1.739276 1.676180 -0.240345 0.150777 0.681206 -0.194935 0.104756 -0.005077 0.926218 1.333708 1.346707 1.577141 0.294151 -0.029928 1.425852 1.208701 0.288918 1.491470 0.174706 1.893172 0.747764 0.193381 0.900774 -0.013909 0.008458 1.330217 1.507450 0.151486)
     )

;;; 53 even --------------------------------------------------------------------------------
(vector 53 9.6159172058105 #r(0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 1 0)

     7.750487 #r(0.000000 0.036779 0.620619 1.389030 1.448590 0.206060 1.401187 0.716369 0.552235 0.039103 0.347305 1.846613 0.552018 1.491421 1.339207 1.372862 1.129023 1.023345 1.671571 0.563034 0.162746 0.439370 1.163228 -0.070535 0.315773 0.561792 1.174490 1.839925 1.161557 1.788132 0.000155 0.215127 1.156326 0.635275 1.204301 0.236777 -0.137602 1.267159 0.914139 0.933059 0.732878 0.757869 1.209147 1.287260 1.087065 1.355017 0.578394 1.465757 0.725442 0.562270 1.513798 1.240390 0.721272)
     7.747803 #r(0.000000 0.039194 0.620413 1.389371 1.443121 0.207159 1.404682 0.719170 0.556070 0.042067 0.345452 1.842252 0.547431 1.492389 1.345143 1.377757 1.130868 1.021817 1.670152 0.554105 0.161080 0.441217 1.158102 -0.062355 0.315571 0.566448 1.168684 1.842060 1.166280 1.782185 0.001290 0.219286 1.155722 0.636430 1.200817 0.245333 -0.135734 1.273218 0.923412 0.943855 0.727077 0.756973 1.213346 1.282414 1.075026 1.359176 0.575167 1.463730 0.719009 0.555783 1.516676 1.235856 0.727835)
     )

;;; 54 even --------------------------------------------------------------------------------
(vector 54 9.5190944671631 #r(0 1 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 1)

     7.845083 #r(0.000000 0.061451 0.633202 0.842273 1.609750 1.150617 1.710229 0.507090 -0.042557 0.310551 0.314728 0.987790 1.351858 1.063896 1.713078 1.603814 0.132592 0.924440 -0.380633 0.855851 1.637781 0.813597 1.013698 0.861640 0.327742 0.192164 0.896540 1.734094 0.874167 -0.001625 0.106463 0.214754 1.657275 0.272925 1.907315 1.437104 1.086576 0.701261 0.411048 1.402011 1.872416 0.559924 1.401281 1.776842 1.632661 1.672063 -0.088862 1.645896 0.861803 0.137030 1.828399 0.307366 0.083970 1.711361)
     7.842903 #r(0.000000 0.060027 0.632572 0.840534 1.609956 1.150996 1.709999 0.505283 -0.042316 0.311030 0.314470 0.988539 1.352916 1.063701 1.713792 1.604820 0.132996 0.924299 -0.380640 0.854614 1.638153 0.814465 1.013932 0.862189 0.327985 0.193317 0.897117 1.733078 0.873773 -0.001006 0.106707 0.215303 1.656885 0.272377 1.907118 1.437374 1.086294 0.702032 0.410835 1.401875 1.872443 0.559095 1.401872 1.777073 1.634625 1.674015 -0.089409 1.647357 0.860412 0.137791 1.828229 0.309024 0.084316 1.711228)
     )

;;; 55 even --------------------------------------------------------------------------------
(vector 55 9.6719217300415 #r(0 1 0 0 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1)

	7.908224 #r(0.000000 -0.006122 1.706850 -0.138031 1.409264 -0.179924 1.291393 0.095673 0.477101 1.213765 -0.191085 0.117017 0.016865 0.128090 1.052814 -0.223928 0.648751 1.402762 0.456990 0.553356 1.095940 1.027495 0.299767 0.447120 0.205834 1.452671 -0.085699 1.609363 1.101039 1.058600 -0.087300 1.595987 1.179897 0.004643 1.423903 0.778740 0.553053 1.139184 0.724189 1.453952 0.381783 0.586983 0.831862 1.181073 0.788144 1.024391 1.771531 1.598505 0.863121 0.198894 0.450345 0.085968 1.228457 0.544951 0.771388)
	7.887815 #r(0.000000 0.067810 1.737812 -0.122811 1.443124 -0.221123 1.362562 0.111083 0.515147 1.202804 -0.153742 0.092056 0.069487 0.163947 1.016287 -0.237810 0.532869 1.386552 0.450227 0.594886 1.080091 0.970410 0.337739 0.449452 0.269437 1.420564 0.034163 1.611412 1.032737 1.077792 -0.088229 1.558506 1.155871 0.005672 1.401629 0.758850 0.618931 1.028067 0.755333 1.491859 0.361129 0.610064 0.849797 1.145175 0.723610 0.997214 1.749864 1.465370 0.865700 0.198966 0.422473 0.083554 1.249104 0.535008 0.693476)
     )

;;; 56 even --------------------------------------------------------------------------------
(vector 56 9.6809562784664 #r(0 0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1)

	8.011195 #r(0.000000 0.008210 0.905992 0.396571 1.720897 1.158304 1.138541 -0.149073 1.014952 1.018591 1.745765 0.438732 0.854592 1.654860 1.011019 1.080405 0.999544 1.358343 1.494524 -0.322084 1.515909 1.690243 0.974840 0.937768 1.405811 0.436415 0.424543 1.360935 -0.014499 1.482939 0.090605 0.959441 1.032814 1.287153 0.868562 1.424617 0.689023 1.690605 0.303801 0.396076 -0.120753 1.039594 0.342297 0.231504 -0.042441 1.626406 0.755064 0.442808 1.366653 1.769637 -0.205340 -0.239797 0.934356 1.176593 0.655901 1.488666)
	7.974749 #r(0.000000 0.037394 0.887445 0.468860 1.746295 1.175646 1.159058 -0.083690 0.977865 1.021939 1.733675 0.463519 0.830986 1.607222 0.977261 1.046527 0.951993 1.337952 1.473478 -0.287182 1.438401 1.666254 0.969024 0.935004 1.368599 0.490566 0.476226 1.378285 -0.102374 1.514691 0.025972 0.974916 1.059546 1.242181 0.851020 1.471951 0.715432 1.703562 0.195156 0.437186 -0.035775 1.014304 0.379158 0.200049 -0.047378 1.663383 0.814982 0.493191 1.371344 1.638725 -0.211432 -0.265471 0.946425 1.299701 0.609040 1.600091)
     )

;;; 57 even --------------------------------------------------------------------------------
(vector 57 9.8992366790771 #r(0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 1)

	7.998443 #r(0.000000 -0.014666 1.566831 1.522473 -0.249684 1.548885 0.061859 1.226467 1.343794 0.283370 1.644204 -0.263860 0.040445 -0.006696 1.612019 1.549636 0.536480 0.507272 1.129223 0.096416 0.070654 1.146329 0.116347 1.310955 1.044576 1.855920 1.741244 0.737054 0.646099 0.980172 1.413425 1.269711 1.581860 1.800144 1.281998 -0.058342 0.653062 1.547228 1.144145 0.578917 0.690679 0.861263 0.345954 0.676296 0.259007 0.725329 -0.285685 1.547409 0.602010 1.240793 0.038406 1.789143 1.881017 1.026132 0.600098 1.097228 -1.919911)
	7.965546 #r(0.000000 -0.095638 1.629377 1.505743 -0.257865 1.542542 0.081191 1.216552 1.252972 0.250947 1.706903 -0.287910 0.050289 0.059867 1.658443 1.577681 0.529653 0.483034 1.093472 0.038780 0.154944 1.137344 0.082702 1.405634 1.058661 1.871514 1.718727 0.668182 0.658605 1.088944 1.503251 1.281426 1.583329 1.761936 1.213156 -0.067149 0.722542 1.593715 1.096874 0.601765 0.752401 0.850940 0.371687 0.656775 0.267872 0.662654 -0.352493 1.531419 0.632686 1.247324 -0.006437 1.833582 1.898768 1.055175 0.588965 1.020315 -1.860450)
     )

;;; 58 even --------------------------------------------------------------------------------
(vector 58 9.8761510848999 #r(0 1 1 1 1 1 0 0 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 0 1)

     8.102746 #r(0.000000 0.021804 0.347449 0.712574 0.904596 1.645925 0.230015 0.473992 0.104969 1.934740 1.209012 1.104800 1.062683 0.358409 0.785934 1.465266 1.235573 1.772411 0.072477 1.559281 1.754795 0.147077 0.219637 0.050078 1.441852 0.333339 0.672730 1.789640 1.230725 1.303568 1.622831 1.659814 0.995447 1.205094 1.295826 0.837873 0.521849 1.476121 0.531055 1.439237 1.534776 0.923559 1.866584 1.504388 0.402718 1.262304 0.589470 1.403389 1.379169 0.218840 1.535374 0.130494 0.618342 0.285582 1.711521 1.399310 1.463120 1.577451)
     8.100734 #r(0.000000 0.021430 0.347022 0.713737 0.905092 1.645754 0.229912 0.474077 0.105073 1.934132 1.209338 1.104304 1.062614 0.356876 0.785787 1.466271 1.235630 1.772115 0.072671 1.559512 1.754734 0.145493 0.220621 0.049952 1.441273 0.332650 0.674384 1.791015 1.230070 1.303791 1.623175 1.659342 0.994865 1.203930 1.296077 0.837641 0.520635 1.476430 0.531243 1.438107 1.534372 0.922866 1.864597 1.503104 0.404808 1.260145 0.588520 1.403415 1.378729 0.219397 1.535041 0.130713 0.617885 0.285219 1.710688 1.399341 1.461475 1.578234)
     )

;;; 59 even --------------------------------------------------------------------------------
(vector 59 10.094394683838 #r(0 1 1 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1)

     8.194538 #r(0.000000 0.192440 1.064997 1.405447 0.666893 0.441718 0.460123 -0.029893 0.102290 1.233991 1.287456 0.262828 0.891341 1.622477 -0.078945 0.794492 1.676056 0.757298 1.625170 1.288224 1.021602 1.270621 0.622162 1.173256 0.639594 0.085293 0.804874 1.211161 -0.067577 0.210901 0.178378 0.446246 -0.092053 1.813463 1.120832 1.269392 -0.271084 1.861664 0.195222 0.087459 0.045547 0.257753 0.386709 0.151559 1.002452 0.352762 0.090741 1.494023 0.840240 1.424148 0.778422 -0.109268 1.896909 0.853535 0.284500 1.503148 1.606229 1.606587 0.287318)
     8.191906 #r(0.000000 0.208043 1.068640 1.415957 0.657053 0.440995 0.455186 -0.041082 0.110511 1.241704 1.296019 0.277579 0.902913 1.621412 -0.074519 0.791975 1.674757 0.759979 1.631215 1.291991 1.012910 1.277340 0.631619 1.165525 0.635918 0.084682 0.823773 1.206086 -0.065324 0.207012 0.192120 0.437715 -0.091880 1.817464 1.121287 1.279417 -0.286096 1.867658 0.184266 0.100569 0.053843 0.263570 0.392050 0.142817 1.000313 0.341265 0.101419 1.503434 0.847586 1.429859 0.784752 -0.103598 1.892264 0.866894 0.288620 1.506687 1.614658 1.620036 0.310805)
     )

;;; 60 even --------------------------------------------------------------------------------
(vector 60 10.333255371943 #r(0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0)

     8.312421 #r(0.000000 0.016764 0.099999 0.395290 1.344482 1.502674 0.248570 0.971438 0.736859 1.561216 0.263938 1.242184 -0.428796 -0.122031 1.528486 0.190921 1.269506 0.099840 0.618839 0.286668 0.310580 0.121766 0.645000 0.953645 1.140529 0.456214 0.631806 0.922426 0.396932 1.354468 1.176819 0.515695 0.171198 0.662750 1.320434 0.506395 1.565445 0.874857 0.531897 0.782628 0.471079 -1.819575 1.656923 0.206815 0.413621 0.205859 1.749126 1.236787 1.333671 0.085487 1.468799 1.666444 0.266215 0.649751 0.639546 0.431656 1.171882 1.863798 1.376382 0.482890)
     8.294966 #r(0.000000 -0.063009 -0.094522 0.425797 1.374786 1.483081 0.148545 1.000132 0.525611 1.640807 0.203662 1.078679 -0.256584 -0.149469 1.403978 0.141642 1.329452 -0.046303 0.679783 0.183124 0.210333 -0.033052 0.639739 1.015677 1.255511 0.486796 0.657629 0.749484 0.360686 1.380916 1.165967 0.436569 0.245010 0.681049 1.289027 0.486773 1.488027 0.953072 0.654244 0.787813 0.422242 -1.680072 1.774325 0.156381 0.383386 0.285516 1.812920 1.151126 1.368336 0.388051 1.563209 1.763145 0.152220 0.632704 0.602570 0.598515 0.977077 1.899879 1.241320 0.511002)
     )

;;; 61 even --------------------------------------------------------------------------------
(vector 61 10.120587847566 #r(0 0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1)

	8.246633 #r(0.000000 0.014137 0.312612 0.249295 0.935740 0.710600 -0.670222 0.029791 0.000981 1.147441 0.399682 0.888394 1.440126 0.108877 -0.294608 1.403751 1.053458 0.779516 0.066815 1.543587 0.107940 1.359190 1.494404 1.618478 0.815280 -0.244135 0.981345 0.739684 0.088784 1.710138 1.218977 0.672306 0.896304 0.148600 0.266242 0.612315 0.136648 0.136688 0.184375 -0.198309 0.518044 0.411032 1.286324 0.855547 0.828794 0.991646 1.167294 -0.167119 0.070397 0.487614 -0.198225 0.121902 0.696143 0.291992 0.984667 1.799531 0.623251 0.161592 0.779281 0.099176 0.369046)
	8.226818 #r(0.000000 0.016994 0.325473 0.251336 0.946736 0.699401 -0.675079 -0.007728 -0.010116 1.126523 0.376569 0.914633 1.446095 0.053980 -0.300394 1.374139 1.077986 0.775879 0.096551 1.537635 0.069761 1.322672 1.473052 1.640018 0.768399 -0.249971 0.982178 0.700147 0.066158 1.674667 1.169657 0.690809 0.918446 0.208659 0.318433 0.638763 0.148904 0.160017 0.167605 -0.164629 0.504035 0.380548 1.286796 0.861236 0.876986 0.992693 1.202515 -0.178183 0.116192 0.499345 -0.210431 0.157968 0.664206 0.256148 1.005577 1.828343 0.582272 0.170110 0.806483 0.100628 0.394696)
     )

;;; 62 even --------------------------------------------------------------------------------
(vector 62 10.318392753601 #r(0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 0 1 1)

     8.390962 #r(0.000000 0.864131 -0.039302 0.501838 0.179590 0.198870 0.408743 -0.099436 -0.035241 1.399095 1.555420 1.066003 1.126029 -0.412606 0.371657 1.690168 1.511157 0.827619 0.057876 1.184261 0.354886 0.869166 0.825315 1.069197 0.055544 0.926747 0.994446 -0.406535 1.243161 1.409918 0.623323 1.296612 0.600545 1.814707 1.913723 0.665613 1.150575 0.642943 -0.000728 0.108004 1.148509 1.338004 0.731747 0.682804 1.190657 0.379742 0.514953 0.586813 0.784946 1.269079 1.453729 1.496418 0.332671 -0.412333 0.644169 0.803815 1.053593 1.563066 0.967726 0.733563 -0.027726 1.710240)
     8.386831 #r(0.000000 0.859901 -0.037314 0.499084 0.172754 0.200053 0.413556 -0.103812 -0.043175 1.401630 1.547880 1.059459 1.128023 -0.412748 0.373286 1.692211 1.505594 0.830265 0.065218 1.195447 0.352197 0.869648 0.832233 1.076333 0.047227 0.926568 0.992906 -0.398829 1.251628 1.417524 0.607369 1.301838 0.591801 1.818966 1.919148 0.665172 1.124200 0.647113 0.006532 0.116994 1.158292 1.339589 0.729938 0.686697 1.201579 0.392196 0.535548 0.591995 0.796606 1.266153 1.468758 1.497693 0.335929 -0.407172 0.650104 0.824841 1.052228 1.568552 0.986491 0.732480 -0.016292 1.711613)
     )

;;; 63 even --------------------------------------------------------------------------------
(vector 63 10.45694065094 #r(0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 1 0)

     8.413888 #r(0.000000 0.010634 0.820887 1.791906 0.180821 1.699733 1.457775 1.781040 1.049055 0.063682 0.656198 -0.016519 1.426220 1.490473 0.018505 1.749295 0.166920 0.934178 0.018879 0.949939 1.163838 0.694420 0.665805 0.087679 1.619302 0.169784 1.099805 0.390614 0.230991 0.703447 0.620497 0.345622 1.520041 1.514348 1.626503 0.238228 1.445149 1.071455 0.772257 1.186699 1.488207 -0.090097 0.947955 1.288711 1.143854 0.328539 1.581009 1.516219 1.752145 1.825272 0.656629 1.607807 1.482688 0.741468 0.684282 0.938749 1.078766 0.076298 1.127102 0.768415 0.654765 1.253057 1.466721)
     8.410525 #r(0.000000 0.001399 0.806426 1.791406 0.178737 1.693772 1.453002 1.766108 1.038935 0.058437 0.646194 -0.015337 1.414249 1.474690 0.017771 1.733567 0.171070 0.923951 0.026909 0.933154 1.151798 0.698968 0.660366 0.087838 1.616344 0.176657 1.080078 0.379155 0.230399 0.700949 0.606872 0.328480 1.529853 1.497342 1.625641 0.221781 1.430841 1.072942 0.756921 1.190553 1.477444 -0.121500 0.950131 1.283964 1.136775 0.314563 1.594944 1.525301 1.752381 1.839723 0.649292 1.587383 1.463916 0.739346 0.677117 0.941654 1.094738 0.055775 1.135356 0.781532 0.625283 1.248630 1.446249)
     )

;;; 64 even --------------------------------------------------------------------------------
(vector 64 10.487 #r(0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 1 1 1)

     8.500897 #r(0.000000 -0.110230 0.253682 0.149208 0.517156 1.680690 0.261962 -0.311932 1.499119 0.134139 0.193946 1.528316 0.126448 1.680960 0.957330 -0.015272 0.163098 1.233151 0.955877 1.516677 1.271750 0.225924 1.801609 0.924065 0.996478 1.135973 0.892170 1.311436 1.257336 0.314351 0.968388 0.136861 1.841069 1.348391 1.398845 -0.195293 1.345125 1.529238 1.112945 1.363188 0.328366 0.804723 1.816185 1.478898 0.163962 1.500837 0.226838 0.805475 0.515967 0.095385 1.528024 1.274946 0.915048 0.129649 1.022985 1.362093 -0.189345 -0.123957 -0.176055 0.992212 1.710004 0.183155 0.509794 0.492211)
     8.488483 #r(0.000000 -0.118114 0.313179 0.116307 0.537176 1.658687 0.216192 -0.344847 1.506370 0.155763 0.208418 1.514849 0.157857 1.664955 0.963481 0.006954 0.149631 1.283307 0.956149 1.518137 1.255443 0.282151 1.825115 0.946089 0.970642 1.107082 0.894001 1.294563 1.287628 0.299372 0.985558 0.184067 1.892317 1.378772 1.391157 -0.222304 1.376273 1.516215 1.126447 1.392881 0.335259 0.776482 1.846059 1.461533 0.174470 1.514120 0.175563 0.824826 0.537543 0.115873 1.536858 1.275915 0.954089 0.159705 1.030084 1.416601 -0.201669 -0.136401 -0.169765 0.989459 1.686060 0.192759 0.496019 0.523157)
     )

;;; 65 even --------------------------------------------------------------------------------
(vector 65 10.593795776367 #r(0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0)

	8.609777 #r(0.000000 0.010286 0.073308 0.156025 1.953119 0.326605 1.156187 1.359503 0.615092 0.625095 1.209776 1.377583 -0.310622 1.815585 1.618945 0.328652 -0.127781 1.904210 1.297763 1.916187 0.801813 0.929154 1.581967 0.478151 0.556340 1.031862 1.480609 -1.661291 1.218834 0.549647 1.223081 1.263443 0.189207 -0.057436 1.688891 1.890453 1.705454 1.164550 1.023002 0.394890 -0.072758 -0.362543 1.102983 0.220165 0.570828 0.506586 1.236790 0.668284 1.330270 0.072079 0.187084 1.026028 0.423887 1.229321 0.594086 1.447463 0.979393 0.850808 0.463831 1.022159 0.562154 0.740405 1.709952 0.862548 0.909149)
	8.567238 #r(0.000000 0.016475 0.108594 0.115078 1.941329 0.266453 1.120248 1.339498 0.699994 0.620437 1.172542 1.326431 -0.361520 1.836695 1.591514 0.344904 -0.145822 1.946144 1.338521 0.013894 0.850127 0.898286 1.609872 0.539311 0.526861 0.957259 1.571247 -1.643771 1.326503 0.617413 1.298256 1.248448 0.255352 -0.154088 1.756739 1.934044 1.770040 1.122574 1.017162 0.470885 -0.004317 -0.415719 1.115681 0.155133 0.493910 0.491332 1.234316 0.650337 1.247665 -0.051232 0.217462 1.088110 0.407320 1.207871 0.679746 1.483837 0.999515 0.954188 0.578133 1.042860 0.625974 0.692508 1.706207 0.810556 0.867800)
     )

;;; 66 even --------------------------------------------------------------------------------
(vector 66 10.77367179842 #r(0 0 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0)

	8.678699 #r(0.000000 0.454997 1.496948 0.519770 1.672039 0.567223 1.755017 0.736664 1.985212 1.381007 0.655920 0.131168 1.193358 0.617219 1.831999 1.143743 0.488405 0.001490 1.636224 1.056726 0.387222 0.101202 1.826852 1.187505 0.710721 0.377670 0.096617 1.812536 1.688958 1.476343 1.264972 1.142558 1.049579 0.690750 1.195534 0.929938 1.522099 1.266451 1.390797 1.538518 1.605610 1.574083 1.889598 0.006801 0.695550 0.832932 1.160944 1.293180 1.683176 0.244325 0.530816 1.180483 1.812767 0.268820 0.993683 1.695534 1.919653 0.449948 1.560150 0.338318 1.266700 1.853107 0.910590 1.381060 0.420174 1.311948)
	8.632415 #r(0.000000 0.349370 1.556983 0.421234 1.616137 0.526541 1.792681 0.630666 1.972820 1.303888 0.668047 0.185874 1.204700 0.605735 1.801435 1.101578 0.499473 -0.033128 1.607932 1.076516 0.444236 0.108864 1.822323 1.184780 0.621714 0.311062 0.092207 1.865663 1.797545 1.591442 1.274722 1.177650 1.020802 0.614400 1.193233 0.964769 1.565329 1.283764 1.369776 1.524204 1.622137 1.617341 1.880743 0.063066 0.749797 0.946049 1.286786 1.349904 1.771520 0.203067 0.478454 1.238589 1.828318 0.267660 0.894470 1.776144 1.875339 0.462001 1.527170 0.297195 1.298088 1.841092 0.920392 1.387764 0.362983 1.255950)
     )

;;; 67 even --------------------------------------------------------------------------------
(vector
 67 10.668939590454 #r(0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 0 0 1 0 0 0)

	8.715278 #r(0.000000 -0.048714 1.201233 1.932201 0.432152 1.784378 1.706119 1.715110 0.918127 0.634326 -0.280426 0.736091 0.881233 0.715749 1.255373 0.306961 0.430124 1.043814 0.355900 1.887422 0.161687 0.974683 1.590380 -0.300251 0.580494 -0.035950 1.388432 1.396578 1.262995 0.125471 0.427569 0.132635 1.747845 1.090690 1.059664 0.781885 0.922127 1.269399 0.290961 0.283370 1.543322 0.245179 1.267332 1.559397 1.540498 0.278811 0.442330 0.979302 0.305622 1.057402 0.123531 1.659773 0.687811 0.574242 1.988850 0.928855 0.118304 0.916897 0.064414 0.547707 0.733829 0.168859 0.108897 0.552498 0.271579 0.641458 0.722670)
	8.680518 #r(0.000000 -0.043644 1.156472 1.929602 0.353761 1.793459 1.704972 1.699186 0.872870 0.617346 -0.249467 0.791588 0.943695 0.700487 1.210665 0.268020 0.351731 0.986938 0.336661 1.907109 0.142220 0.981697 1.535635 -0.431045 0.586416 -0.024607 1.390926 1.451196 1.280482 0.107552 0.443197 0.190946 1.788471 1.067438 1.094568 0.777481 0.924726 1.216918 0.287796 0.194302 1.535749 0.282813 1.326500 1.604906 1.499596 0.251491 0.462521 0.952185 0.345470 1.023546 -0.007975 1.650236 0.724994 0.590428 0.013422 0.854280 0.122767 0.900957 0.082717 0.523513 0.805279 0.154091 0.109168 0.522941 0.212305 0.605855 0.627516)
     )

;;; 68 even --------------------------------------------------------------------------------
(vector 68 10.834321813096 #r(0 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0)

	8.754943 #r(0.000000 0.006701 0.662467 1.132456 -0.029127 0.614111 1.150467 1.706479 0.619454 1.199242 1.758840 0.562498 1.597544 0.407921 1.558651 0.097672 0.926756 -0.032275 0.853950 0.002762 0.680777 1.599641 0.725147 0.147702 1.201496 0.263849 1.380478 0.615269 0.086221 1.573333 1.233822 0.463104 -0.134996 1.463347 0.467790 -0.201328 1.692933 1.307865 0.941345 0.423601 0.364303 1.897445 -0.044200 1.168331 0.738828 0.662829 0.834882 0.503840 0.773952 0.485349 0.168198 0.227087 0.122039 0.075266 0.590053 0.402757 0.920519 0.805378 1.169878 1.002493 1.566599 1.933905 0.435730 0.760806 1.023096 1.785992 1.801946 0.257114)
	8.737685 #r(0.000000 0.011271 0.668436 1.109866 -0.047117 0.635498 1.135888 1.688824 0.641485 1.217954 1.792573 0.564775 1.618901 0.379183 1.590320 0.092885 0.939189 -0.039829 0.894144 0.018539 0.697204 1.575345 0.741258 0.165076 1.219732 0.243990 1.380334 0.653577 0.058955 1.582179 1.217188 0.506682 -0.145644 1.503542 0.465163 -0.203926 1.674851 1.343034 0.935709 0.449262 0.406299 1.921952 -0.005204 1.148292 0.752402 0.667155 0.809216 0.533372 0.786502 0.507725 0.195612 0.268423 0.127763 0.071980 0.591303 0.375550 0.934990 0.815381 1.190826 1.015123 1.567564 1.945341 0.409416 0.747963 1.020919 1.819317 1.811732 0.264138)
     )

;;; 69 even --------------------------------------------------------------------------------
(vector 69 11.164121627808 #r(0 0 0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0)

     8.870351 #r(0.000000 -0.002928 0.090043 1.728264 1.193144 0.838010 0.865027 0.720973 0.639322 0.246096 0.057627 0.302959 -0.048089 1.638389 0.900762 0.946630 1.090094 0.801115 1.083281 1.325801 0.953024 0.800047 1.660883 0.042716 1.927302 1.582152 0.107129 0.057190 -0.097633 0.434745 0.530943 1.556013 -0.117080 1.617479 1.566580 -0.082197 0.137002 1.745306 1.025473 1.476477 1.524388 0.192617 1.281951 0.528156 0.227376 1.631586 1.077576 0.616842 1.479500 0.199402 1.336867 0.525138 1.593133 1.323175 0.217188 0.498012 1.287694 0.007842 1.310482 0.013236 0.970642 -0.011247 0.684481 1.560396 -0.131105 0.613388 0.586300 0.981366 1.715362)
     8.861298 #r(0.000000 -0.014315 0.107745 1.734221 1.188739 0.864616 0.853522 0.701665 0.627466 0.265741 0.086130 0.314910 -0.019937 1.617450 0.883596 0.910173 1.068518 0.802541 1.046841 1.319853 0.948867 0.766596 1.620488 0.096714 1.965624 1.582040 0.085060 0.106281 -0.124978 0.458998 0.531756 1.514877 -0.136493 1.587236 1.553587 -0.064004 0.133766 1.755990 1.052257 1.445105 1.527338 0.192346 1.271689 0.560930 0.225417 1.661856 1.064999 0.603651 1.461102 0.188146 1.372664 0.531903 1.582055 1.360195 0.242798 0.449158 1.259157 0.003876 1.338065 0.028298 0.962940 -0.034639 0.655190 1.502712 -0.152010 0.612951 0.527743 0.973632 1.671816)
     )

;;; 70 even --------------------------------------------------------------------------------
(vector 70 11.188811302185 #r(0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 1)

	8.848811 #r(0.000000 0.246703 1.002261 0.886061 0.801873 1.809738 1.108544 0.562043 1.825392 1.804522 1.262385 0.421389 0.361557 1.923401 1.951742 1.062427 0.438003 0.228289 1.097160 1.013865 0.764041 0.470243 0.831289 0.101425 1.763202 0.709481 0.498799 0.216191 0.861166 0.122620 0.547738 1.235046 0.857238 0.383439 0.822746 0.754977 0.703208 0.715041 0.359010 1.832044 0.247507 1.317151 1.405217 0.206638 0.707472 1.340219 1.707159 1.823029 1.938700 1.479437 0.258261 1.667534 0.316971 1.157956 1.277369 0.826722 1.196822 0.248386 0.546752 1.821030 1.066474 1.952221 1.238401 0.305398 0.369743 0.877722 1.232005 1.532682 1.629962 0.062770)
	8.738310 #r(0.000000 0.060494 0.986675 0.927670 0.927042 1.912795 1.130240 0.504397 1.816891 1.890493 1.358618 0.521191 0.253430 1.962720 0.007805 1.096365 0.386730 0.273184 1.116588 0.973364 0.744812 0.418465 0.707007 0.033855 1.765192 0.661757 0.557886 0.198772 0.854461 0.002899 0.603283 1.248185 0.800028 0.506375 0.669527 0.754045 0.637170 0.745041 0.219675 1.748841 0.204886 1.266431 1.560734 0.352969 0.701996 1.457120 1.739658 1.911657 1.876664 1.591504 0.388398 1.652906 0.410293 1.137585 1.138735 0.861128 1.263560 0.335801 0.480511 1.625411 0.897941 1.902792 1.166909 0.252915 0.353569 0.922988 1.275359 1.530840 1.567036 0.065589)

     )

;;; 71 even --------------------------------------------------------------------------------
(vector 71 11.146488189697 #r(0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0)

	8.877033 #r(0.000000 0.494925 1.537244 0.892084 0.150008 1.375283 0.111396 0.180070 1.039621 1.603551 0.974071 0.067462 1.566530 0.645476 1.559374 0.286202 1.250076 1.040362 0.597158 0.170031 1.495084 0.538551 1.605790 0.911462 0.561795 0.131327 0.669920 1.494711 1.488338 0.162432 0.349959 1.071758 0.876821 1.835299 1.877472 1.338427 1.055237 0.961547 0.343936 0.685277 1.268629 0.932565 0.412531 1.233930 1.960684 0.356135 1.869394 1.068031 1.470058 1.669216 1.450884 1.495861 1.103585 1.290131 0.589390 1.675751 1.864756 1.328404 1.588855 1.689588 1.394915 1.481997 1.790524 0.376533 0.659979 0.194369 0.714680 1.009374 1.293563 1.133522 0.906132)
	8.871487 #r(0.000000 0.501961 1.541872 0.886339 0.156320 1.396889 0.135011 0.196565 1.055358 1.605569 0.968224 0.079515 1.545947 0.630884 1.566775 0.285239 1.241623 1.021147 0.597505 0.194062 1.492344 0.530666 1.629940 0.923400 0.544821 0.122654 0.645735 1.521728 1.527826 0.171212 0.337093 1.111719 0.869475 1.840487 1.876244 1.390257 1.033097 1.006339 0.323258 0.705399 1.295002 0.904992 0.460862 1.246434 1.927017 0.305342 1.897455 1.059620 1.458290 1.674665 1.467549 1.520089 1.086469 1.318586 0.595384 1.676485 1.855914 1.355156 1.637133 1.725092 1.426375 1.504977 1.730717 0.310874 0.666925 0.188355 0.720920 1.037233 1.314825 1.160128 0.935055)
     )

;;; 72 even --------------------------------------------------------------------------------
(vector 72 11.323646371629 #r(0 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0)

     8.985526 #r(0.000000 -0.132001 0.251840 -0.152367 1.238134 0.223104 0.102612 0.998567 1.283059 0.195894 1.573363 0.407537 1.033361 -0.202081 0.593147 0.635495 1.000647 1.220151 0.876169 0.891935 0.590452 0.848621 0.474219 0.520369 1.077034 0.562333 1.205154 1.187120 1.031050 1.268084 0.666333 -0.432529 0.483326 0.764356 0.428610 0.084679 1.685196 -0.154809 0.749260 1.099715 -0.153921 1.175926 0.117589 0.701530 0.528397 1.669792 1.315998 0.695987 0.047259 0.736352 1.073555 1.525504 1.860608 -0.168018 1.587814 -0.029717 0.367471 1.076978 0.934753 0.510954 0.369425 1.530708 0.338598 0.869566 1.012951 0.841118 0.372289 1.598627 0.202786 1.450618 0.578685 0.231358)
     8.966098 #r(0.000000 -0.126524 0.241365 -0.143891 1.246410 0.237827 0.068268 0.981965 1.279896 0.207575 1.600135 0.425223 1.012069 -0.249534 0.586208 0.677616 0.988256 1.224132 0.847502 0.890511 0.594663 0.821814 0.472617 0.509750 1.055611 0.527256 1.206362 1.187311 1.020278 1.260328 0.644599 -0.411471 0.451173 0.741632 0.395690 0.063099 1.651856 -0.169570 0.718417 1.113283 -0.150773 1.169732 0.126856 0.685212 0.541541 1.675462 1.278970 0.617875 0.012957 0.713555 1.056877 1.533856 1.860752 -0.160414 1.609925 -0.009147 0.332551 1.066032 0.906560 0.505523 0.337817 1.535465 0.314417 0.880126 0.996966 0.843436 0.382436 1.584721 0.192373 1.434808 0.561954 0.196295)
     )

;;; 73 even --------------------------------------------------------------------------------
(vector 73 11.416394233704 #r(0 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0)

	9.061347 #r(0.000000 -0.013492 0.700057 0.971458 1.656489 0.226217 1.266397 1.217251 0.034107 1.132703 0.209805 0.859555 1.676063 0.359664 0.948491 1.631395 0.566735 1.564253 0.503600 1.614448 0.423074 1.551405 0.311534 1.292368 0.836304 0.277624 0.872873 0.108697 1.546043 0.974228 -0.054286 1.516659 0.873622 0.075543 -0.025545 1.027508 0.575666 -0.130582 1.023997 1.136740 0.704834 -0.015132 -0.346526 1.509690 1.112218 0.655940 0.431045 0.092523 0.384582 -0.406961 0.058570 -0.216957 1.536312 1.587308 1.645182 1.277358 1.546578 1.141387 -0.381783 1.707248 -0.163708 -0.313272 -0.263055 0.347717 0.363093 0.778459 1.216671 1.669453 -0.038813 0.148398 0.866038 0.847643 1.513063)
	8.998875 #r(0.000000 -0.027738 0.723012 0.987885 1.688793 0.224358 1.257498 1.205244 0.059967 1.110866 0.244239 0.893825 1.678546 0.367238 0.999201 1.584243 0.599700 1.550023 0.571455 1.648100 0.426585 1.592387 0.308230 1.310308 0.762552 0.283753 0.857526 0.065837 1.585997 0.934412 -0.077402 1.498041 0.744404 0.105899 -0.072967 0.997282 0.574754 -0.130584 1.109613 1.163331 0.759965 -0.104852 -0.314435 1.534103 1.175049 0.658149 0.377521 0.124048 0.381799 -0.363750 0.073219 -0.169731 1.548408 1.642328 1.596724 1.300600 1.557656 1.160915 -0.369397 1.745964 -0.047288 -0.349818 -0.267792 0.401403 0.428159 0.831796 1.384022 1.813745 0.039215 0.253980 0.836216 0.800931 1.496823)
     )

;;; 74 even --------------------------------------------------------------------------------
(vector 74 11.47264289856 #r(0 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 1)

	9.134480 #r(0.000000 0.102279 0.371397 0.523001 1.843248 1.152941 1.651341 1.411384 0.791794 0.097952 1.057024 0.161099 0.857363 0.427397 0.372120 0.661194 1.523876 0.922082 -0.041073 -0.033604 0.996743 1.697191 1.295880 0.242720 0.296660 0.925120 0.229105 1.701968 1.808512 0.155026 0.755549 1.603330 1.534401 1.305218 1.056671 1.959110 0.012243 0.095634 0.866653 0.499791 0.642664 1.366362 0.320578 0.556112 0.471836 0.546071 0.453257 0.620145 0.487633 1.413108 0.647644 1.248023 1.294495 1.814325 0.514274 1.440895 0.132821 0.969503 0.559010 0.339598 1.732485 1.513938 0.682886 0.936970 1.342790 0.397470 0.364797 1.929409 1.198862 0.270546 1.048858 1.252852 0.860205 0.013479)
	9.089677 #r(0.000000 0.144071 0.430579 0.603179 1.823332 1.143801 1.591094 1.455623 0.712070 0.082290 1.084154 0.110592 0.804471 0.355531 0.279726 0.662009 1.471918 0.975419 -0.110990 -0.050928 1.029272 1.676464 1.339672 0.210956 0.309032 0.856505 0.268633 1.767141 1.866363 0.080348 0.815161 1.562603 1.496888 1.364954 1.148285 1.915037 0.068161 0.155798 0.832883 0.552250 0.747466 1.278662 0.320719 0.554068 0.448373 0.560964 0.575201 0.582799 0.448437 1.372678 0.663771 1.197915 1.194337 1.764215 0.560010 1.428733 0.089660 1.008988 0.569768 0.320532 1.743415 1.535180 0.723297 0.874095 1.399163 0.469816 0.475982 1.976109 1.247967 0.249280 1.069756 1.236481 0.761110 0.040581)
     )

;;; 75 even --------------------------------------------------------------------------------
(vector 75 11.479255355845 #r(0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1)

	9.136718 #r(0.000000 0.002886 1.335455 0.159358 1.480181 0.946385 -0.044639 1.084031 0.633473 0.070872 0.846110 0.073920 0.712875 1.849807 0.002049 1.333644 0.084510 1.217578 1.455838 0.351015 0.583697 1.521673 -0.105875 -0.161704 1.008277 1.067855 -0.227255 1.066234 0.968179 0.069816 1.652420 0.515209 -0.583628 1.701274 1.644474 0.045597 -0.072256 1.396842 -0.036343 1.242335 0.205214 -0.046339 1.655176 1.585631 1.056865 0.812824 1.251896 1.501857 -0.501015 0.327372 1.079894 1.360106 0.639144 -0.102077 0.025865 0.258537 0.650404 0.029251 0.316419 1.073801 1.065871 0.953311 0.976263 -0.016818 0.369518 -0.028524 0.754304 0.267168 0.876021 1.386930 1.128217 -0.044803 -0.305853 1.417010 1.210349)
	9.122336 #r(0.000000 0.048869 1.339254 0.089666 1.486190 0.870004 0.011978 1.048119 0.676596 0.057206 0.754204 0.107870 0.750530 1.770162 0.039012 1.322332 0.128429 1.247050 1.441477 0.361257 0.456347 1.565436 -0.097913 -0.154028 1.037161 1.046281 -0.149299 1.044015 0.945241 0.030424 1.640451 0.465010 -0.575716 1.739314 1.635330 0.021179 -0.093167 1.405567 0.012379 1.165852 0.184990 -0.085142 1.685196 1.535448 0.976578 0.821468 1.305457 1.520774 -0.462148 0.266842 1.065515 1.372970 0.572598 -0.000709 0.007374 0.181987 0.683855 -0.023831 0.237367 0.994268 1.020527 0.942078 0.930935 0.000689 0.246320 -0.099925 0.725524 0.244873 0.826205 1.407851 1.166455 -0.165415 -0.393537 1.421358 1.270036)
     )

;;; 76 even --------------------------------------------------------------------------------
(vector 76 11.477294510597 #r(0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1)

	9.274323 #r(0.000000 -0.012165 1.750183 1.230595 1.387108 0.131448 0.902665 1.325819 0.139220 0.132421 1.315838 0.916320 1.247629 1.543004 0.326242 0.479315 1.525889 1.714627 0.992625 1.849378 1.028201 1.309429 1.365818 1.322280 1.222257 1.381076 1.644593 0.773733 0.614835 0.306624 1.009114 1.162734 0.610055 0.099066 1.125761 1.356329 0.324777 0.800340 1.850117 0.710340 0.610191 0.810114 1.107918 1.417728 -0.023776 1.259738 0.196765 1.355631 1.575090 1.576385 1.741085 1.748236 0.050375 1.081011 0.178534 1.097122 0.438057 -0.170346 1.371443 0.019537 1.307599 0.833238 0.430491 0.202986 1.382655 1.791419 0.002565 0.061873 0.176928 1.554826 0.852820 1.065814 0.297645 0.742549 0.387652 1.429885)
	9.267049 #r(0.000000 -0.020314 1.755600 1.225815 1.392876 0.129128 0.904701 1.317680 0.135315 0.135157 1.306639 0.906712 1.246319 1.540595 0.325853 0.492145 1.519920 1.711478 0.987890 1.851800 1.025239 1.325366 1.386429 1.327266 1.218403 1.379936 1.651659 0.762609 0.602221 0.305384 1.005148 1.165080 0.607028 0.109898 1.108721 1.348326 0.327807 0.802574 1.851895 0.707744 0.612551 0.813959 1.109818 1.410929 -0.038131 1.260997 0.182282 1.357227 1.580079 1.583723 1.747921 1.744371 0.043874 1.066888 0.166830 1.083294 0.441024 -0.188048 1.363450 0.011580 1.301595 0.836365 0.437311 0.206162 1.388569 1.787918 -0.007275 0.062944 0.169678 1.553243 0.843416 1.054961 0.291307 0.730433 0.353612 1.433902)
     )

;;; 77 even --------------------------------------------------------------------------------
(vector 77 11.594018936157 #r(0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1)

	9.277681 #r(0.000000 -0.007935 0.356695 -0.167840 1.436050 1.267495 0.166108 0.719740 1.788089 0.701383 1.502062 0.971109 -0.201146 1.261312 1.596232 0.380082 0.436900 1.530759 0.673592 1.168750 0.815135 1.757429 0.573966 1.406748 1.792933 1.256151 0.643583 0.884960 0.868508 0.759790 1.464002 -0.196244 0.635729 1.419530 -0.026848 0.857441 0.646295 0.815860 0.331225 0.324537 0.379771 0.793029 -0.189194 0.533286 0.175986 1.162021 0.894997 1.330799 0.028604 0.329088 -0.042751 1.722552 1.010170 0.365295 -0.089972 0.186813 0.250172 1.045796 0.805669 1.150679 1.074682 0.666765 1.119179 0.223717 0.745979 0.727191 0.250299 1.103832 0.833082 -0.215344 1.645081 0.897326 0.690160 1.501085 1.581868 1.570534 1.086810)
	9.258697 #r(0.000000 -0.013339 0.361730 -0.178619 1.458285 1.239693 0.187315 0.723105 1.832453 0.697245 1.501131 0.944520 -0.233993 1.308923 1.563553 0.373130 0.490540 1.502925 0.664091 1.076569 0.784295 1.783245 0.515174 1.454068 1.828406 1.258364 0.555115 0.908733 0.866810 0.793191 1.466746 -0.285489 0.625778 1.405840 -0.033775 0.825706 0.658930 0.687424 0.346833 0.334451 0.295602 0.709401 -0.245908 0.509751 0.038841 1.147976 0.897946 1.319996 -0.002107 0.292751 -0.002528 1.663431 0.945438 0.327586 -0.130505 0.048622 0.206586 1.024810 0.812170 1.202395 1.044181 0.633806 1.054272 0.210049 0.748304 0.737183 0.166918 1.060611 0.839094 -0.333107 1.559498 0.841184 0.651547 1.383431 1.543420 1.536206 0.957253)
     )

;;; 78 even --------------------------------------------------------------------------------
(vector 78 11.940728787203 #r(0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 0)

     9.335941 #r(0.000000 1.404748 1.136727 0.627680 0.129528 0.271686 0.002711 1.737837 1.295987 1.387168 0.097658 1.822832 0.846464 1.039100 1.481322 0.895294 0.827592 0.841157 0.429643 0.718521 1.651578 0.732848 0.670593 1.833752 0.966314 1.266799 1.852734 1.169793 1.403542 0.722295 1.054728 1.444480 1.323054 1.351419 0.414445 0.928183 1.497407 0.895056 0.003473 1.202042 1.804296 0.448756 1.139768 0.075452 1.121542 0.477216 1.723231 0.402648 0.668323 0.045598 1.846940 0.961710 0.765295 1.814929 0.327072 0.120487 1.324670 1.238079 1.405578 -0.005216 1.466365 1.535268 1.050547 0.249219 1.956711 0.420435 0.291291 0.855796 1.032224 0.874733 1.340034 0.852331 1.473861 1.078790 -0.021411 0.624891 0.620475 1.381664)
     9.328276 #r(0.000000 1.406823 1.141364 0.610647 0.126562 0.291088 -0.002810 1.723967 1.290155 1.387808 0.102958 1.845357 0.849277 1.063481 1.501422 0.895746 0.848443 0.832188 0.431168 0.709505 1.679105 0.730831 0.661087 1.841168 0.988482 1.264653 1.865286 1.169037 1.400680 0.724126 1.065027 1.447510 1.315432 1.350791 0.428040 0.921038 1.506688 0.890246 0.013294 1.195026 1.795617 0.458626 1.125258 0.081154 1.116281 0.472818 1.725786 0.409138 0.675258 0.030590 1.838764 0.971536 0.779052 1.812631 0.339909 0.118196 1.331384 1.256650 1.407089 -0.001860 1.469527 1.547682 1.041199 0.265560 1.975848 0.431849 0.301455 0.848353 1.049415 0.858904 1.319566 0.870781 1.483458 1.085719 -0.027060 0.614386 0.627471 1.390841)
     )

;;; 79 even --------------------------------------------------------------------------------
(vector 79 11.878196632448 #r(0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1)

	9.380733 #r(0.000000 0.510780 0.252633 0.712748 0.045825 0.533290 0.570911 1.782693 1.778269 1.965545 0.949265 0.812889 1.687090 1.664308 1.581407 1.710616 0.952117 1.113251 0.535130 1.949191 0.392710 1.113892 0.673455 0.088774 1.234594 1.234700 1.363303 0.874218 0.053582 1.508928 0.207664 0.009853 1.481504 1.794166 0.192648 0.693227 0.386323 1.341036 0.276027 0.630139 0.405686 0.785949 0.090167 1.080676 0.339556 0.634603 1.972094 0.909674 0.642872 1.742555 1.044458 1.900464 0.893867 1.044986 0.466092 0.081355 1.748407 0.417739 0.609777 0.867444 0.996078 1.921822 0.146017 1.547350 1.786775 0.079134 0.379049 1.145195 0.491146 0.827840 1.444544 0.381774 1.018247 0.133450 0.186735 0.732527 1.660451 1.720421 1.438682)
	9.356905 #r(0.000000 0.571128 0.283126 0.710064 0.044861 0.517447 0.565754 1.816476 1.776655 1.961158 0.969237 0.741311 1.685785 1.693335 1.608101 1.714904 0.999281 1.149752 0.496446 -0.005825 0.400462 1.122030 0.649836 0.115106 1.227654 1.245207 1.356694 0.853401 0.066193 1.513339 0.232138 -0.003310 1.407988 1.840789 0.203665 0.695895 0.383959 1.340762 0.259589 0.675435 0.428135 0.786347 0.123158 1.097424 0.337222 0.630879 1.973156 0.929943 0.645917 1.669638 1.042085 1.855979 0.866264 1.042746 0.512422 0.066644 1.718064 0.437594 0.628166 0.854660 1.007811 1.926083 0.161247 1.536075 1.840756 0.056881 0.376915 1.151208 0.451206 0.898922 1.442317 0.402410 0.949195 0.147955 0.214050 0.743975 1.660546 1.690974 1.456466)
     )

;;; 80 even --------------------------------------------------------------------------------
(vector 80 11.989325523376 #r(0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0)

	9.493437 #r(0.000000 -0.003056 0.871305 1.349319 1.858308 0.466908 1.244422 1.764043 0.291426 1.076281 1.682758 0.386304 1.182056 -0.041504 1.018049 1.794160 0.591085 1.410404 0.075268 1.154361 0.262047 1.215494 0.086813 1.119384 0.112085 1.492482 0.546321 1.626715 0.687674 1.840924 1.113879 0.412411 1.693842 1.217772 0.566191 1.613902 0.702693 0.386708 1.626693 1.362021 0.738932 0.368846 1.672871 1.299617 0.788427 0.551598 0.187991 1.803477 1.774821 1.164009 1.487614 0.770019 0.742630 0.390398 -0.088422 1.923288 -0.109062 1.842146 1.690251 0.008381 1.550824 1.531659 1.497616 1.396079 1.603050 1.793260 0.154336 0.252178 0.425516 0.421130 0.697112 0.901699 1.252555 0.016759 0.375241 0.855613 1.211546 1.433945 1.792863 0.351953)
	9.451381 #r(0.000000 -0.008159 0.906753 1.305892 1.835739 0.455299 1.241503 1.764471 0.268792 1.093130 1.721221 0.403868 1.185646 -0.052269 1.047326 1.833500 0.559981 1.435538 0.044639 1.118792 0.211239 1.183285 -0.017880 1.113985 0.075712 1.455698 0.586249 1.582198 0.728760 1.817597 1.133287 0.380801 1.662934 1.263429 0.591618 1.594214 0.731911 0.436203 1.622560 1.339925 0.697686 0.383414 1.692741 1.277746 0.787440 0.567628 0.173328 1.808052 1.713672 1.154020 1.478170 0.695323 0.754309 0.444882 -0.137982 1.914149 -0.163436 1.825364 1.675061 -0.028374 1.567024 1.487026 1.462509 1.367054 1.604880 1.820934 0.179885 0.241810 0.434307 0.468407 0.694148 0.863503 1.227318 0.060705 0.392042 0.847475 1.220917 1.459482 1.773242 0.341153)
     )

;;; 81 even --------------------------------------------------------------------------------
(vector 81 11.979215621948 #r(0 0 1 0 1 0 1 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0)

	9.529325 #r(0.000000 -0.003984 0.725186 0.743737 0.729531 1.119765 1.541925 1.678935 1.738481 1.721543 1.393185 0.731045 0.019478 0.771584 0.581855 0.216656 0.563399 1.242114 0.560651 1.738359 1.170491 0.159270 0.566126 0.483569 1.182790 0.181604 1.706151 1.854339 -0.002194 0.437844 -0.070207 1.440872 0.286463 1.398996 1.367061 0.708028 -0.290957 0.883528 0.399205 0.712176 0.881360 0.586332 1.691690 -0.045439 0.598789 -0.244443 0.663603 1.393152 0.011936 0.502973 1.160110 0.596199 0.257846 0.544341 0.629333 1.752684 0.177491 0.528429 1.038556 0.728481 0.384225 0.529890 0.711236 1.400194 1.498453 1.156244 0.653763 0.305758 -0.155269 1.073363 1.458379 0.702870 0.141716 1.302726 -0.329814 0.298639 1.892688 1.900138 1.655169 0.812034 -0.182220)
	9.484199 #r(0.000000 -0.014989 0.711182 0.702116 0.715678 1.118560 1.541619 1.626360 1.716671 1.701724 1.388047 0.720950 0.043527 0.750136 0.580168 0.242261 0.554505 1.231540 0.585563 1.731545 1.161768 0.189281 0.555798 0.452602 1.215752 0.161495 1.660923 1.830372 -0.010829 0.456142 -0.050721 1.414501 0.305392 1.352545 1.387015 0.684532 -0.327842 0.848714 0.508517 0.769743 0.863349 0.582844 1.732685 -0.045944 0.572477 -0.189530 0.661834 1.428026 0.041444 0.576772 1.162733 0.612356 0.238120 0.518089 0.595961 1.809933 0.228170 0.569100 1.027432 0.767900 0.363008 0.578850 0.716122 1.427686 1.524730 1.163139 0.596916 0.312527 -0.179958 1.099907 1.521616 0.693536 0.160625 1.330705 -0.245662 0.331197 1.886658 1.895780 1.661128 0.854753 -0.196395)
     )

;;; 82 even --------------------------------------------------------------------------------
(vector 82 11.74796962738 #r(0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0)

	9.530985 #r(0.000000 0.002581 0.665465 1.069477 1.708629 0.244744 0.815275 1.389506 0.072967 0.518149 1.258636 0.104869 0.672550 1.578904 0.486254 1.275378 -0.016236 0.797153 -0.276393 0.747043 -0.159462 0.727529 0.109229 1.313965 0.107559 1.101244 0.135391 1.229652 0.386704 1.699152 0.875100 0.220480 1.674529 0.566929 1.803565 1.281089 0.420527 -0.095373 1.451514 0.833105 0.334393 1.926106 1.521915 0.797742 0.037620 1.890450 1.238469 1.288596 0.773237 0.606049 0.213821 0.049140 1.607755 1.437666 0.833194 0.946550 0.684670 0.626164 0.630512 0.902897 0.480081 0.471365 0.308602 0.413372 0.258949 0.442607 0.453613 0.854111 1.173261 1.257079 1.135118 1.379336 1.476222 -0.234240 0.311478 0.480664 1.015136 1.521091 1.852304 0.056526 0.425563 0.785949)
	9.497103 #r(0.000000 -0.029153 0.684444 1.021403 1.658027 0.249250 0.776708 1.428620 0.085535 0.486627 1.258780 0.071150 0.697354 1.572082 0.508727 1.262137 -0.011817 0.780894 -0.218011 0.762691 -0.142015 0.700649 0.106572 1.278342 0.114037 1.097124 0.117125 1.202443 0.366776 1.726169 0.864227 0.247143 1.675002 0.548738 1.828587 1.277326 0.419039 -0.107494 1.445764 0.840468 0.334528 1.912916 1.518113 0.790626 0.013994 1.915183 1.263923 1.327347 0.781659 0.615731 0.262410 0.035907 1.614732 1.446654 0.850073 0.970717 0.734963 0.622068 0.608074 0.894648 0.488587 0.454835 0.326490 0.410839 0.269255 0.474617 0.469240 0.881426 1.112047 1.250719 1.126584 1.346595 1.487368 -0.251240 0.320757 0.542484 1.030672 1.483109 1.856301 0.081488 0.438971 0.778619)
     )

;;; 83 even --------------------------------------------------------------------------------
(vector 83 11.931811297539 #r(0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1)

	9.549360 #r(0.000000 0.032288 0.834116 1.401416 0.035368 0.406563 1.177626 1.509613 0.291626 0.972552 1.726763 0.692721 1.687201 0.129594 1.085873 0.204017 1.139515 0.273445 1.482102 0.192295 1.080179 1.979882 1.285941 0.340403 0.985304 0.533609 1.865099 0.628799 1.889210 1.180384 0.539244 1.842377 1.350512 0.512399 1.815213 1.164340 0.726996 -0.012813 1.099275 1.226281 0.551613 0.011231 1.538277 1.191883 0.928674 0.507861 1.826344 1.417654 1.468918 1.265287 0.819366 0.969679 0.428274 0.455249 1.949916 0.041645 1.591382 1.883937 1.784338 1.762163 1.899526 1.307740 1.800619 1.929764 0.063585 1.701620 1.807254 0.159705 0.531560 0.710036 1.009902 1.081386 1.423742 1.377653 1.714397 0.170534 0.667428 1.526663 1.444085 1.827303 0.046079 0.991518 1.278845)
	9.527422 #r(0.000000 0.039993 0.816893 1.396565 0.052019 0.406851 1.188022 1.530327 0.285917 0.977547 1.744335 0.664199 1.680876 0.156053 1.128267 0.262396 1.109826 0.291301 1.490141 0.180525 1.053020 1.941274 1.253760 0.382165 0.961999 0.532400 1.847797 0.647689 1.830150 1.183965 0.539992 1.837872 1.385863 0.522294 1.844972 1.128571 0.700004 -0.069652 1.070002 1.210347 0.538981 -0.009837 1.537046 1.193589 0.928354 0.544043 1.782489 1.375018 1.429592 1.234747 0.808197 0.986572 0.425099 0.414825 1.922804 0.001710 1.593804 1.877139 1.790889 1.733450 1.866442 1.306101 1.778217 1.887521 0.051591 1.690318 1.780713 0.155363 0.560963 0.744564 1.000076 1.060961 1.426049 1.399817 1.671797 0.161357 0.644151 1.472002 1.472014 1.829962 0.015301 0.965948 1.229794)
     )

;;; 84 even --------------------------------------------------------------------------------
(vector 84 12.426499838032 #r(0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0)

	9.633962 #r(0.000000 0.374922 1.183581 1.290870 0.705975 0.037122 1.139367 1.048350 0.334310 1.326801 1.647856 1.857607 1.812109 0.301068 1.658406 1.344389 0.416349 0.219667 1.233884 1.040486 1.625160 1.657982 1.232289 1.436356 0.879314 1.500837 0.083989 0.524445 1.496583 0.195492 0.415250 0.867702 1.173743 1.828747 1.840334 -0.001715 0.114874 1.289221 0.907468 1.568406 0.412257 0.461669 1.993995 0.175480 1.741500 1.629849 1.860704 1.739722 1.644034 1.223183 0.177672 0.444348 1.320675 1.200379 1.245918 0.030713 1.304971 1.969297 1.489901 0.864880 0.577011 0.034043 1.934323 1.447131 0.730445 1.571480 0.003554 0.387041 0.486597 1.351900 0.594794 1.157107 0.726867 1.857734 0.748709 1.799335 1.043537 0.919611 0.874828 0.732255 1.153375 1.608544 0.740331 1.571952)
	9.614786 #r(0.000000 0.375068 1.187445 1.298436 0.709464 0.020952 1.148798 1.055850 0.320459 1.298871 1.652395 1.860647 1.831143 0.283862 1.652937 1.354808 0.416076 0.228038 1.233244 1.035794 1.620810 1.664738 1.238595 1.418099 0.901000 1.501621 0.079640 0.502746 1.495260 0.205490 0.418812 0.854084 1.160572 1.818322 1.862802 -0.014400 0.107435 1.307461 0.912240 1.586689 0.425403 0.451717 -0.018837 0.188758 1.765670 1.603983 1.861601 1.733712 1.620602 1.226086 0.197611 0.449818 1.288074 1.179947 1.253616 0.051096 1.323541 -0.017431 1.522243 0.870665 0.517902 0.017634 1.973363 1.452286 0.728651 1.585681 0.006719 0.375262 0.515082 1.364281 0.622572 1.146649 0.785551 1.882176 0.813901 1.772516 1.074978 0.933728 0.872134 0.706582 1.147578 1.604862 0.731095 1.575095)
     )

;;; 85 even --------------------------------------------------------------------------------
(vector 85 12.270205061432 #r(0 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1)

     9.693668 #r(0.000000 0.195989 0.490949 0.331600 0.887562 0.028445 1.546017 1.385311 0.812190 1.115113 1.801497 0.487288 0.525794 0.074082 1.723182 1.944316 1.781964 0.421600 0.177518 1.829367 0.571078 1.783004 0.344177 0.329133 1.891108 0.440324 0.259558 0.143603 0.779362 1.104207 1.976902 0.561742 0.767039 1.340228 0.253563 1.774888 1.741378 1.554241 1.474673 0.298807 0.272176 1.211675 1.002346 0.130871 1.176937 0.697418 0.199450 0.178715 1.330092 0.855241 1.512332 1.331159 0.219055 1.811575 1.934102 1.939888 1.043996 0.748687 0.643521 0.780509 1.267694 0.441215 0.667193 0.454905 1.688291 1.972173 0.503377 0.756581 0.239100 0.784029 1.470486 0.189182 1.795940 0.379978 1.569889 1.093199 1.711138 0.905143 0.045022 0.285289 1.219061 0.953496 1.196694 1.742789 0.902060)
     9.676352 #r(0.000000 -0.021506 0.142510 -0.201280 0.182702 1.169448 0.515556 0.222070 1.459504 1.605994 0.066066 0.601645 0.479812 1.884618 1.289236 1.392693 1.037601 1.509258 1.097130 0.618955 1.146396 0.204058 0.576610 0.429829 1.784325 0.190947 -0.177471 1.558612 1.955949 0.141411 0.860726 1.284854 1.277952 -0.296527 0.440455 -0.206162 -0.363530 1.252145 1.013387 1.637160 1.499868 0.217901 -0.179705 0.762898 1.687641 0.983895 0.350810 0.163017 1.102299 0.509811 0.930463 0.652819 1.320027 0.777246 0.714063 0.619559 1.478697 1.064984 0.759208 0.734058 1.089046 -0.001825 0.109656 1.736213 0.746787 0.859777 1.252309 1.312302 0.643160 0.991358 1.500532 0.072854 1.488976 -0.065425 0.980776 0.288766 0.737541 -0.227786 0.745819 0.780965 1.553917 1.095084 1.183710 1.599670 0.559494)
     )

;;; 86 even --------------------------------------------------------------------------------
(vector 86 12.791990425787 #r(0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 0 0 1 1 1 0 0)

     9.779022 #r(0.000000 0.012842 0.387371 0.019737 1.439011 0.434664 1.128389 0.730743 -0.150815 -0.440514 0.639771 1.390058 1.794981 0.621810 1.311431 0.767684 1.625416 1.570273 0.387894 0.736564 0.474233 0.261823 1.118332 0.820501 1.669010 0.015560 0.675733 0.978312 -0.064261 1.739844 1.817488 1.131007 0.062688 1.453390 0.448140 0.394070 0.831458 0.606366 1.363181 1.537589 0.426586 0.909340 1.240040 0.972834 0.683746 1.305881 0.259400 0.331948 0.295699 1.578329 0.042939 0.918607 1.689154 0.940724 1.007722 0.753380 1.536736 1.334795 1.258278 0.206096 0.883227 0.623082 0.840214 0.596829 1.277982 0.836896 1.407813 0.924493 1.193604 0.465208 1.513477 1.273116 0.679902 0.975579 0.664944 1.360910 -0.287799 0.710949 0.308010 -0.006577 0.020520 -0.156639 1.682660 0.621205 0.561199 0.080346)
     9.757994 #r(0.000000 0.016276 0.413658 0.005763 1.416798 0.452490 1.133949 0.717805 -0.139351 -0.416845 0.635126 1.397576 1.784378 0.624787 1.329377 0.775034 1.638049 1.566267 0.397541 0.717995 0.458680 0.241210 1.137210 0.824217 1.676096 0.033354 0.678380 0.974547 -0.074751 1.701263 1.808581 1.130731 0.088685 1.471223 0.433149 0.369913 0.827798 0.624409 1.348287 1.536121 0.451096 0.914922 1.222159 0.944875 0.666511 1.307186 0.261401 0.304523 0.268304 1.558827 0.035349 0.915580 1.674357 0.963952 0.990617 0.774771 1.562772 1.323613 1.282808 0.172130 0.873085 0.634976 0.830754 0.633548 1.260812 0.821220 1.409736 0.921962 1.181706 0.466917 1.496380 1.268080 0.686034 0.967101 0.676822 1.324706 -0.286255 0.721334 0.297385 -0.003595 0.022225 -0.182008 1.671247 0.611513 0.542122 0.060310)
     )

;;; 87 even --------------------------------------------------------------------------------
(vector 87 12.625063286678 #r(0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0)

     9.874660 #r(0.000000 0.366900 0.585885 0.360276 1.741378 1.383744 0.806085 0.218985 1.748601 1.513484 1.913086 1.499231 1.804617 1.560415 0.976184 0.564077 0.614555 0.706893 1.155782 1.743949 0.256106 1.587276 1.479629 0.499900 0.621596 1.318438 0.505053 -0.000351 1.493931 0.351932 1.677582 1.117619 1.631442 0.001969 0.286212 0.372264 0.187053 0.296894 0.961309 0.849648 1.557109 1.714474 -0.039206 1.347988 1.896634 1.217858 1.504538 0.380552 0.871895 1.911392 0.768943 1.752782 0.535064 0.764217 0.468880 0.181130 0.490835 1.212121 1.451975 1.107304 0.551132 0.225217 0.930971 0.652946 1.821236 0.839189 1.745456 0.283826 1.910401 1.397382 1.626785 0.236815 0.165723 1.103589 1.501862 1.903299 0.205800 0.189795 0.285228 0.129502 1.654212 0.651262 -0.043737 0.438462 1.813853 0.852642 1.712123)
     9.833802 #r(0.000000 0.367165 0.536913 0.326688 1.754631 1.386469 0.701887 0.250913 1.770109 1.479583 1.893022 1.432354 1.785784 1.534964 1.065673 0.546258 0.691804 0.707053 1.195808 1.762942 0.317266 1.578293 1.433592 0.550208 0.671749 1.256446 0.518972 -0.102858 1.408512 0.374956 1.658793 1.157613 1.642043 -0.113309 0.260556 0.456626 0.282565 0.411123 0.959912 0.806932 1.532714 1.669316 -0.074293 1.300123 0.015951 1.235972 1.481090 0.353661 0.866116 0.040949 0.766868 1.838392 0.527395 0.761509 0.579783 0.151717 0.504358 1.298332 1.436503 1.047336 0.497873 0.242477 0.820064 0.697963 1.791351 0.825336 1.710371 0.315366 -0.001375 1.285082 1.639193 0.147520 0.106212 1.060911 1.454817 1.978200 0.161929 0.176396 0.295938 0.177484 1.619442 0.666971 0.038844 0.469799 1.852332 0.897967 1.727138)
     )

;;; 88 even --------------------------------------------------------------------------------
(vector 88 12.661032846106 #r(0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1)

	9.812216 #r(0.000000 0.055268 0.583779 1.234211 1.628798 0.277023 0.822779 1.625146 0.035507 0.649602 1.426919 0.034524 0.760555 1.584090 0.426236 1.297108 -0.064648 1.003285 1.954848 1.040940 1.931089 0.684474 1.457006 0.442932 1.400956 0.522371 1.821243 1.045778 -0.071524 1.059165 0.175444 1.376515 0.683418 0.093932 0.976929 0.065328 1.602577 1.185163 0.398809 1.873751 1.266959 0.334189 1.528861 1.254369 0.874420 0.121432 1.565807 1.331351 0.966676 0.377764 -0.254628 1.470234 1.160191 1.088192 0.680440 0.787715 0.046065 0.265716 -0.241611 1.809516 1.268665 1.177712 1.068293 0.934673 1.317512 0.907560 0.977837 0.781524 0.997530 0.958638 1.010309 1.152240 1.559668 1.510870 1.793541 0.022384 -0.034413 0.066685 0.419014 0.865510 1.381137 1.729658 1.950350 0.466719 0.747652 1.418392 1.765101 -0.161755)
	9.718345 #r(0.000000 0.090301 0.580420 1.137948 1.649229 0.242742 0.835819 1.656571 -0.017510 0.559517 1.388287 0.058809 0.753393 1.494701 0.370637 1.260856 -0.119563 1.041192 -0.061687 1.016092 1.945001 0.703035 1.390544 0.418053 1.307211 0.509025 1.790796 0.980057 -0.158235 0.857486 0.120874 1.412962 0.698078 0.037067 0.957739 0.111182 1.653690 1.215943 0.416735 1.835076 1.390628 0.306891 1.454844 1.343506 0.944627 0.195567 1.555857 1.416104 1.116565 0.394891 -0.273959 1.365744 1.143771 0.983147 0.734424 0.789720 0.117391 0.276530 -0.227121 1.795123 1.224424 1.102557 0.938135 0.875496 1.362204 0.858546 1.054224 0.762302 0.972789 0.919506 0.923137 1.096370 1.576367 1.456481 1.754554 -0.038629 -0.053347 -0.002284 0.438792 0.831710 1.315485 1.762939 -0.120155 0.441679 0.734442 1.312359 1.725229 -0.263433)
     )

;;; 89 even --------------------------------------------------------------------------------
(vector 89 12.335865540187 #r(0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1)

	9.997916 #r(0.000000 0.020244 0.870163 0.459782 1.610176 0.844000 1.631839 0.198513 0.309236 0.389591 1.266554 0.907717 1.601376 1.371297 1.457522 1.745042 1.476212 0.073975 0.814060 0.353740 0.627872 0.101452 1.077167 0.352892 0.063779 0.448255 0.216020 0.534427 1.535778 -0.255643 1.360537 0.276814 0.262932 1.399548 0.980210 0.702925 0.453704 0.501694 1.341730 0.007203 0.345436 0.837214 0.770776 -0.073243 0.532634 1.583256 0.698601 0.593928 1.599304 0.808070 1.440125 1.148274 0.114072 0.434799 -0.164129 1.193330 -0.269745 0.418138 1.192504 1.289901 0.986576 0.905136 0.005956 1.233570 1.751871 1.723660 1.197839 1.205999 1.118756 1.106261 1.003380 0.216161 0.037880 0.928786 0.755785 -0.278629 0.531970 0.188018 0.465858 1.197436 0.572455 1.090538 1.091674 0.532343 0.511453 1.688563 1.590718 0.571898 1.255870)
	9.997333 #r(0.000000 0.000374 0.870347 0.430138 1.597497 0.854707 1.645978 0.195809 0.327518 0.386675 1.273173 0.883834 1.572463 1.355519 1.460953 1.742560 1.466652 0.059211 0.803493 0.350986 0.628193 0.108588 1.078791 0.357570 0.049661 0.428788 0.193103 0.539441 1.534442 -0.270762 1.359943 0.266823 0.261536 1.389711 0.984355 0.700121 0.450847 0.511706 1.320150 -0.010111 0.346818 0.823284 0.749541 -0.083397 0.521509 1.572625 0.693799 0.570576 1.592198 0.790089 1.438056 1.137497 0.099306 0.403293 -0.181278 1.213652 -0.275230 0.429537 1.196488 1.257187 0.949493 0.887298 -0.021183 1.237418 1.728439 1.700297 1.208776 1.169553 1.080514 1.089517 0.997178 0.189218 0.010336 0.924195 0.754787 -0.276009 0.524587 0.129921 0.438091 1.173722 0.555071 1.051504 1.084882 0.517543 0.493847 1.648211 1.537221 0.577245 1.229152)
     )

;;; 90 even --------------------------------------------------------------------------------
(vector 90 12.716424196959 #r(0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0)

	10.013305 #r(0.000000 0.276249 0.662327 1.808806 0.247081 1.503786 1.940324 0.419803 0.731998 1.474410 1.308170 1.676869 1.811609 1.215798 0.664610 0.066241 0.912393 1.461826 0.512334 1.631743 1.956766 1.975237 0.185753 0.741305 0.480828 1.966454 1.916940 1.119423 0.845500 1.620533 0.975449 0.450183 0.934883 1.109333 0.667354 1.305384 1.605133 1.189882 1.538095 1.240075 1.975310 0.162522 1.100171 1.036777 1.043788 0.744032 1.593875 0.517982 0.225081 0.407155 1.741456 1.796412 1.700950 0.367751 0.443832 0.733427 0.886793 0.217138 0.457578 1.931221 1.821137 1.223426 0.206884 1.785700 -0.026139 0.112791 0.288549 1.184345 0.406919 0.005051 0.510070 1.732554 1.458011 0.524459 1.130913 0.434368 0.819466 0.015795 0.021375 1.211968 0.985111 0.213416 0.003383 0.752814 1.988526 0.349626 0.383655 1.548554 0.699363 -0.001079)
	10.005385 #r(0.000000 0.266301 0.657933 1.809725 0.259625 1.499388 1.951777 0.417279 0.720631 1.463340 1.313241 1.674280 1.821839 1.222157 0.677020 0.056065 0.913340 1.473757 0.500844 1.618656 1.947044 1.968045 0.165893 0.742583 0.481909 1.957975 1.912063 1.128014 0.854394 1.610032 0.983783 0.446705 0.950214 1.088029 0.680933 1.289258 1.589189 1.192870 1.530162 1.263854 1.970834 0.161039 1.086404 1.031920 1.038629 0.740829 1.589971 0.517225 0.215830 0.397130 1.740853 1.801311 1.698694 0.359017 0.435066 0.722951 0.895327 0.213686 0.474411 1.936524 1.840733 1.231982 0.212190 1.778066 -0.017649 0.107809 0.287686 1.163341 0.406123 0.018771 0.520578 1.723923 1.431482 0.556441 1.126649 0.438444 0.818042 0.023577 0.022169 1.216022 0.981361 0.222433 0.002575 0.758509 1.972547 0.353471 0.372968 1.542215 0.712557 -0.005582)
     )

;;; 91 even --------------------------------------------------------------------------------
(vector 91 12.853587071592 #r(0 0 0 1 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0)

	10.062777 #r(0.000000 -0.044026 0.916183 1.049904 0.191738 0.191234 1.416236 1.067714 0.063138 1.147303 0.129837 0.429350 1.643604 1.587481 1.357034 0.252125 0.130779 1.268840 1.505767 0.040246 0.758000 0.845409 1.205711 0.041467 0.397400 0.371419 1.129085 1.761538 0.418123 -0.386013 -0.020991 1.418674 -0.227521 0.262381 1.257327 0.247702 0.200474 1.000030 0.059835 0.524653 0.278663 0.930707 1.291316 0.903105 1.153153 1.399218 1.175091 1.040190 0.853009 0.848960 0.050279 1.156146 0.310675 1.870226 0.711775 0.475029 1.761660 0.754317 0.936989 -0.122427 1.219572 0.099878 0.730317 0.306957 0.685890 1.871434 1.660611 0.509309 0.546923 0.432379 0.751420 0.579102 -0.249566 -0.007122 1.880100 1.723260 0.707224 -0.253994 0.741449 0.308553 0.722662 0.266964 1.454100 1.331867 1.250657 0.301803 0.242062 0.553976 0.852613 0.695715 0.487374)
	10.042802 #r(0.000000 -0.035866 0.897365 1.053653 0.176403 0.219184 1.440211 1.052349 0.085592 1.162863 0.084431 0.441417 1.631218 1.653054 1.371988 0.264232 0.162497 1.263609 1.486015 0.000279 0.796126 0.856108 1.143739 0.036741 0.359201 0.386354 1.098418 1.740082 0.403417 -0.381985 -0.045741 1.421757 -0.244618 0.284679 1.283482 0.239612 0.207928 1.023191 0.055003 0.481157 0.262505 0.919249 1.223649 0.889223 1.148998 1.351103 1.151749 1.060591 0.840918 0.819670 0.078653 1.166949 0.324971 1.862030 0.777159 0.475422 1.793704 0.731398 0.965906 -0.104231 1.194055 0.079999 0.745567 0.302722 0.702138 1.835624 1.663395 0.439912 0.518314 0.455355 0.752825 0.589824 -0.228956 -0.057907 1.862917 1.732339 0.708967 -0.227779 0.771240 0.335640 0.732499 0.256435 1.503911 1.314370 1.240658 0.306896 0.231765 0.561980 0.840408 0.710675 0.474899)
     )

;;; 92 even --------------------------------------------------------------------------------
(vector 92 12.754180011349 #r(0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 1 1 0)

	10.123598 #r(0.000000 0.031164 0.420530 1.499100 1.680395 0.704037 1.385766 1.730884 1.246618 0.630183 0.903224 0.818406 1.762884 0.926615 1.036829 0.514947 1.139487 1.191198 0.306323 0.126221 1.698783 1.815556 0.082954 0.421957 1.558085 -0.046639 0.629395 0.492462 0.620351 1.539766 0.337850 1.829874 -0.029044 1.650869 1.891900 -0.107840 0.000042 1.651572 0.308113 0.328220 0.164791 0.503391 1.668351 1.327181 0.552781 1.134137 0.130061 0.912409 -0.106533 1.117087 0.419486 1.645903 0.619628 0.903437 1.717082 0.277879 0.300313 -0.111169 1.701263 -0.282651 0.916960 1.725278 0.299760 0.206730 0.258427 0.976768 1.006419 1.405478 1.458477 0.511219 1.976132 0.649673 1.067569 1.036236 0.561892 1.032699 1.113462 1.760313 -0.031912 0.151642 1.253446 0.366329 -0.207662 1.411375 0.168281 1.402361 1.015831 0.966440 0.109303 1.719898 -0.033652 0.850348)
	10.093799 #r(0.000000 0.097475 0.474539 1.483425 1.695433 0.696334 1.384454 1.660791 1.281276 0.651391 0.913798 0.787990 1.790434 0.898224 1.017588 0.489338 1.141353 1.186171 0.350837 0.177621 1.677552 1.789100 0.110343 0.454347 1.559659 -0.042233 0.608466 0.500241 0.603579 1.572339 0.363338 1.814846 0.003161 1.623864 -0.034828 -0.082229 -0.014363 1.697201 0.280864 0.306413 0.160645 0.492279 1.649232 1.327006 0.593871 1.122736 0.171541 0.947619 -0.123703 1.067261 0.409844 1.696986 0.608770 0.942772 1.749773 0.231207 0.233623 -0.088168 1.647955 -0.323810 0.983812 1.702369 0.347530 0.210075 0.231329 1.042751 0.983241 1.466379 1.428117 0.495078 0.039516 0.654874 1.015240 1.000618 0.552384 1.000345 1.081710 1.764837 -0.091885 0.154009 1.296154 0.404476 -0.289622 1.339445 0.215325 1.338919 0.954330 0.913687 0.101078 1.737442 0.041006 0.910374)
     )

;;; 93 even --------------------------------------------------------------------------------
(vector 93 12.876626968384 #r(0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0)

     10.120779 #r(0.000000 -0.035376 0.073991 0.427701 -0.282243 -0.018747 0.215658 -0.153445 1.426646 1.066559 1.939228 0.906624 0.410081 0.611941 0.984019 1.022397 0.624511 1.012954 0.533644 1.662254 0.644321 0.184706 0.621632 0.642800 -0.008009 1.949179 1.710653 -0.084032 0.277398 1.824022 0.699251 0.129968 1.020811 0.661971 1.702058 0.534563 1.888605 -0.287827 0.144583 1.379920 1.385073 1.054451 1.007433 0.338841 0.857467 1.489234 0.309837 0.300057 1.146999 0.772495 0.275152 0.667315 1.064213 0.727453 1.142263 1.118538 0.931092 1.595399 1.937578 1.220927 0.920538 0.541725 0.173459 0.580373 1.100745 1.191038 -0.340664 1.515332 1.223959 0.649170 0.846642 -0.414943 0.030223 1.461947 0.288064 0.141033 0.634411 1.011893 0.138288 1.584616 0.333385 0.901662 0.043826 0.951055 1.409243 0.569338 0.143517 0.644810 -0.103707 1.742249 0.748991 1.014192 0.003204)
     10.065620 #r(0.000000 -0.108011 0.028413 0.428569 -0.264921 -0.072069 0.267827 -0.232905 1.422065 1.049340 1.912600 0.928914 0.359452 0.637331 0.994484 1.088650 0.661107 0.959399 0.501733 1.592595 0.649518 0.112558 0.639845 0.623737 -0.001172 1.885750 1.716702 -0.081979 0.409219 1.833651 0.687305 0.099113 0.976296 0.699765 1.668301 0.522485 1.899898 -0.255451 0.181872 1.354811 1.349077 1.063124 1.067091 0.386071 0.890132 1.558023 0.302347 0.328201 1.215301 0.773485 0.343724 0.711824 1.139582 0.744463 1.144250 1.100613 0.956953 1.649826 1.947556 1.246366 0.939192 0.477006 0.202473 0.703433 1.186050 1.217690 -0.305306 1.548367 1.162238 0.701264 0.901619 -0.418089 0.199961 1.541176 0.296598 0.140984 0.701027 1.041254 0.225036 1.683545 0.413255 0.857529 0.155624 1.010740 1.433842 0.558273 0.224703 0.699603 -0.095757 1.811470 0.813981 1.031240 0.132432)
     )

;;; 94 even --------------------------------------------------------------------------------
(vector 94 12.991560374803 #r(0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1)

     10.168153 #r(0.000000 0.158749 0.428472 1.119399 1.397485 1.337099 1.326309 0.765212 0.646549 0.366853 0.358406 0.186940 -0.004160 1.693556 1.760221 1.908281 -0.019516 0.044061 0.077064 0.115948 0.108699 0.200075 0.580690 0.574214 0.728439 1.050221 1.095053 1.499686 1.600782 1.705303 0.371346 0.785397 1.061620 1.118378 1.565155 0.180785 0.671073 0.956955 1.179900 0.062702 0.732776 1.104782 1.678100 1.936449 1.211526 1.440956 1.926880 0.701684 1.206989 0.357893 0.937759 1.642399 0.674496 1.095199 1.838835 0.811161 1.664081 0.728543 1.536793 0.935285 1.167394 0.592984 1.298896 0.711769 1.719531 0.207782 1.415604 0.678365 1.539785 1.187347 0.265338 1.410498 0.621725 1.553961 0.975230 0.124475 1.147511 0.723691 1.974302 1.764820 1.095390 0.083191 1.554760 0.873910 0.746004 0.060230 1.781492 1.338588 0.986007 0.875321 0.329252 1.786619 1.490792 0.801318)
     10.122815 #r(0.000000 0.133468 0.434550 1.116037 1.367061 1.298685 1.320675 0.772917 0.657709 0.375492 0.359918 0.175405 0.001908 1.653938 1.747543 1.839665 -0.062043 -0.026764 0.038622 0.084576 0.056367 0.216710 0.616631 0.600688 0.712488 1.072113 1.109064 1.489264 1.625638 1.767346 0.350358 0.788682 1.068488 1.139549 1.561780 0.235784 0.655587 0.915751 1.197108 0.029428 0.731728 1.098397 1.683227 -0.011322 1.217188 1.389756 1.893589 0.699420 1.194655 0.326260 0.920410 1.696640 0.677795 1.085105 1.784456 0.793169 1.603872 0.721686 1.454458 0.911227 1.124477 0.602857 1.320529 0.681212 1.671271 0.216947 1.361764 0.646816 1.486120 1.171016 0.310212 1.419455 0.622405 1.553189 0.964805 0.061139 1.154419 0.759830 0.026678 1.736233 1.082201 0.055939 1.530249 0.853387 0.727622 0.057320 1.853782 1.373056 1.001203 0.910058 0.345570 1.764813 1.459492 0.795631)
     )

;;; 95 even --------------------------------------------------------------------------------
(vector 95 12.939489078295 #r(0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 1 0 0 1 0)

	10.274816 #r(0.000000 0.191955 0.747873 1.620627 1.444931 1.117449 0.280309 0.480520 1.626406 1.210786 1.123735 0.279148 1.110058 1.602457 1.869386 0.773421 1.408758 0.850581 0.528012 0.913946 0.482409 1.573182 0.994233 1.305292 1.545980 0.033608 1.905037 0.750852 0.522232 1.918658 0.047508 1.217238 0.972743 0.083444 0.371581 0.796063 1.083361 0.261908 1.433959 0.521900 0.192999 1.966737 0.129605 0.500888 0.331274 0.913857 0.815429 1.023459 0.478085 1.566987 1.222813 1.708572 1.719376 0.723585 1.103104 1.428438 0.152348 0.040494 1.696898 0.190236 1.378447 1.550950 1.870103 1.503205 0.324210 0.355888 1.476257 1.524550 1.168199 1.485278 1.191081 0.963527 1.662530 1.621072 0.604273 0.737525 1.817225 0.670588 1.938761 1.575766 0.221849 1.885601 1.971423 1.331586 0.219292 1.195712 0.125970 0.883030 0.146163 0.807704 1.769915 -0.019375 1.792299 1.733519 1.458753)
	10.269066 #r(0.000000 0.196337 0.744121 1.631500 1.434420 1.112985 0.280820 0.466628 1.611890 1.200048 1.128273 0.300201 1.107837 1.615275 1.861044 0.768326 1.404808 0.847561 0.538134 0.927410 0.484738 1.590211 1.022918 1.308421 1.540744 0.048884 1.906201 0.748264 0.523607 1.912669 0.059747 1.201507 0.965409 0.088695 0.363594 0.778227 1.091252 0.265360 1.420067 0.510511 0.194882 1.977148 0.136470 0.500674 0.349411 0.913896 0.824107 1.033330 0.477216 1.577346 1.234803 1.697387 1.721086 0.725903 1.087039 1.444618 0.157357 0.054414 1.697920 0.198034 1.375172 1.573201 1.879725 1.512172 0.332268 0.349715 1.475813 1.517121 1.176387 1.495828 1.194712 0.970136 1.660156 1.605331 0.615232 0.722796 1.823598 0.676903 1.932703 1.595202 0.236615 1.905584 1.979370 1.321822 0.205301 1.189808 0.131048 0.886535 0.146849 0.803473 1.792940 -0.030202 1.802311 1.740023 1.462432)
     )

;;; 96 even --------------------------------------------------------------------------------
(vector 96 13.077001047978 #r(0 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1)

	10.249441 #r(0.000000 0.009923 1.397522 1.166061 1.129381 0.862136 0.621841 0.072414 1.181071 0.867293 0.079004 1.693135 -0.014893 0.108345 1.780717 1.327197 1.625536 0.881623 1.921096 0.933503 1.182023 0.476766 1.614305 1.196403 0.811564 0.443720 1.497667 1.275176 0.722032 1.799828 1.704575 1.646983 1.348940 1.072546 0.729932 1.823713 0.260241 0.680766 1.080411 1.441731 1.246268 1.050406 0.336794 0.747049 0.875357 0.924454 1.579785 0.440504 0.667236 1.229671 0.158392 0.708858 1.967741 0.138461 0.274346 0.799091 1.692696 0.840214 1.597165 1.145148 1.181538 0.078566 1.784249 0.079340 0.404851 1.249515 0.162426 0.631488 1.171930 0.883287 1.256995 0.882531 0.425580 1.043774 0.166379 1.858551 0.915286 1.404785 1.287221 1.948447 1.096165 0.270960 1.267765 0.984855 1.705672 1.206954 1.635747 1.831700 1.675862 0.020775 1.394335 0.961664 1.111073 1.653261 0.221394 1.853173)
	10.241048 #r(0.000000 0.003757 1.404262 1.186542 1.129971 0.865096 0.631220 0.098231 1.181280 0.873758 0.108892 1.683807 -0.026458 0.125881 1.769512 1.339376 1.635163 0.876941 1.912161 0.936227 1.173994 0.478683 1.599283 1.211922 0.811714 0.443994 1.505961 1.292424 0.708648 1.804209 1.708608 1.666637 1.338958 1.076681 0.747663 1.831744 0.261273 0.683220 1.107456 1.456865 1.254091 1.068402 0.333231 0.745693 0.907431 0.898985 1.579520 0.453253 0.663746 1.227853 0.149659 0.721511 1.948786 0.149093 0.296568 0.790196 1.698592 0.803662 1.598789 1.168565 1.171874 0.082641 1.787827 0.077982 0.385521 1.278297 0.162220 0.619751 1.181312 0.878992 1.244043 0.861252 0.440728 1.044249 0.162951 1.873041 0.921134 1.415997 1.306524 1.965129 1.092611 0.284989 1.258880 0.979541 1.705555 1.205180 1.637307 1.841309 1.672634 0.033086 1.395930 1.017436 1.092392 1.649384 0.223105 1.865219)
     )

;;; 97 even --------------------------------------------------------------------------------
(vector 97 12.969611395004 #r(0 0 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0)

	10.353915 #r(0.000000 0.014320 1.699930 0.475338 0.327588 0.038537 1.537175 1.151125 1.532968 0.067981 0.615972 0.753995 1.850077 0.031584 -0.245176 0.175732 0.019153 0.133227 1.047045 1.449249 1.470511 1.537141 1.108379 0.638023 0.512045 -0.123137 1.442397 -0.285045 0.550401 0.725732 1.137347 0.384697 0.518421 0.107675 0.832943 1.779119 1.053524 1.101550 0.692043 0.797241 -0.542271 0.567053 0.702166 1.746525 1.756713 0.337727 1.446061 0.906449 1.109794 0.007168 1.480499 1.290329 0.754314 1.222669 -0.462191 1.087068 -0.251963 0.941593 1.663909 1.425711 -0.319978 0.693993 1.098604 -0.057825 0.103974 0.674596 -0.040855 0.861405 0.891647 0.007811 0.988956 -0.007355 1.453777 1.088127 0.560798 1.836913 1.159295 1.225761 1.137877 0.994253 -0.314791 0.194425 0.944400 0.940972 1.573317 1.084581 0.080135 1.392169 0.150957 -0.334184 0.271188 0.375796 0.741022 -0.072930 1.298672 1.087468 1.547582)
	10.331609 #r(0.000000 0.059699 1.679418 0.450942 0.341208 0.044956 1.496127 1.161174 1.525174 0.047352 0.606254 0.809600 1.848618 0.039787 -0.223939 0.198520 0.035320 0.164795 1.065103 1.447823 1.468877 1.512497 1.098862 0.655896 0.461251 -0.141526 1.428961 -0.284969 0.570402 0.733971 1.142683 0.365769 0.545990 0.086257 0.813863 1.752030 1.028626 1.080478 0.683235 0.804908 -0.569669 0.552818 0.738379 1.748606 1.743971 0.318921 1.398131 0.903531 1.080144 0.015318 1.470925 1.314323 0.741551 1.256092 -0.466432 1.057036 -0.278181 0.948738 1.681138 1.409042 -0.356236 0.710263 1.151015 -0.045179 0.095392 0.692511 -0.044055 0.872538 0.891007 0.065893 0.992795 0.002450 1.463958 1.118971 0.560807 1.855502 1.102581 1.197238 1.102700 1.013050 -0.347897 0.212419 0.959268 0.927894 1.594478 1.035533 0.111169 1.405266 0.164463 -0.296519 0.289020 0.402469 0.694148 -0.081694 1.289317 1.079081 1.540546)
     )

;;; 98 even --------------------------------------------------------------------------------
(vector 98 13.468658765207 #r(0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1)

	10.480580 #r(0.000000 0.029942 1.595740 0.929637 0.140250 1.273956 1.370085 1.486506 0.768736 0.810999 0.987699 0.622931 1.874848 1.232431 0.796670 -0.004456 1.530075 1.744503 -0.182347 -0.272539 -0.039867 0.251416 0.711006 1.684207 0.083442 1.563617 0.619745 1.154797 1.221621 1.412817 0.843588 0.857496 0.194384 1.348416 0.436247 0.378473 1.472625 0.199665 1.452604 1.135822 1.388047 0.919731 1.753351 0.083481 1.454770 1.242435 0.826611 -0.194897 -0.034005 0.041385 0.915233 0.468973 -0.449881 -0.034037 1.686105 0.937405 1.775189 1.272187 0.656772 0.051128 1.735808 1.941754 -0.153834 1.560953 0.798180 1.420628 1.100906 1.382273 0.014181 1.975964 0.450586 0.615591 0.885414 1.287826 0.533661 0.896633 1.605571 0.202012 1.330045 1.186911 0.653866 0.460432 0.799268 1.432588 0.419263 1.021867 0.188412 0.775135 0.208746 0.411264 0.553114 1.806129 0.584153 1.223473 0.816232 -0.069138 0.707217 1.215423)
	10.469148 #r(0.000000 0.041799 1.596065 0.940539 0.107860 1.301118 1.360284 1.456195 0.770794 0.797213 0.981214 0.615701 1.879665 1.255104 0.792980 0.009757 1.541751 1.750534 -0.164252 -0.228661 -0.000964 0.259847 0.719626 1.683189 0.070974 1.565970 0.626446 1.182840 1.211411 1.387666 0.843346 0.887732 0.199521 1.364727 0.445637 0.374521 1.472461 0.203776 1.458205 1.100974 1.381886 0.898075 1.764681 0.078586 1.428252 1.256209 0.859035 -0.172104 -0.025993 0.039107 0.931073 0.478871 -0.467850 -0.062950 1.711499 0.913120 1.786290 1.259116 0.654598 0.064686 1.755165 1.957362 -0.152445 1.535096 0.794197 1.419704 1.076435 1.392497 0.029274 1.975390 0.472375 0.606537 0.883155 1.276000 0.493031 0.898350 1.602090 0.227444 1.327599 1.208448 0.644216 0.422730 0.787896 1.404845 0.430824 1.020626 0.191889 0.753198 0.234016 0.430598 0.540049 1.795233 0.560850 1.196734 0.812705 -0.032356 0.652329 1.183402)
     )

;;; 99 even --------------------------------------------------------------------------------
(vector 99 13.341398779709 #r(0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 1)

	10.395229 #r(0.000000 0.706072 1.286640 0.926913 0.137440 1.547226 0.117224 1.604362 0.484929 0.893678 0.211396 1.934935 1.381569 0.741431 1.002510 1.548591 1.501995 1.642732 0.386486 0.063170 0.535977 1.363015 0.485356 1.002502 1.149707 1.971779 0.610054 0.176963 1.296429 0.848185 0.077879 0.989380 0.162448 1.939484 1.081728 1.291006 1.781243 0.747318 1.861605 -0.003717 0.355879 1.413789 0.958311 0.004291 0.617108 1.378378 1.118347 1.632856 0.492813 0.823307 1.406872 1.588630 0.799940 0.218833 0.397527 1.627895 0.349077 0.557886 0.566534 1.362311 0.876480 1.822463 0.047284 1.726490 0.281473 1.360892 1.302327 0.630439 0.026319 0.398853 1.499306 1.696667 1.409746 0.843535 1.156093 0.782651 0.844572 0.996729 0.505075 0.454056 0.125470 0.633842 0.812248 1.139044 1.201855 0.936107 1.075661 1.055341 1.239337 1.081381 1.450660 0.544145 0.960193 1.261524 0.471575 0.159670 1.647942 0.617964 0.426032)
	10.387770 #r(0.000000 0.723174 1.299510 0.938148 0.130782 1.537111 0.112390 1.601140 0.503320 0.848767 0.240495 1.955709 1.375024 0.729476 1.036126 1.572806 1.444920 1.621302 0.393808 0.065259 0.537896 1.360502 0.502316 1.033192 1.160053 1.956689 0.593389 0.146787 1.283607 0.862675 0.087404 0.982221 0.127681 1.954427 1.076364 1.276318 1.813925 0.771973 1.846400 0.032344 0.377646 1.403790 0.914062 -0.000037 0.633186 1.405136 1.122873 1.617439 0.482283 0.855693 1.408247 1.588613 0.805766 0.262956 0.418675 1.649935 0.343317 0.552803 0.568407 1.358534 0.902812 1.838429 0.026551 1.721556 0.320222 1.393185 1.332977 0.651907 0.039081 0.348939 1.498662 1.703551 1.415979 0.827556 1.145004 0.798108 0.858363 0.976482 0.496254 0.466661 0.161612 0.684799 0.836631 1.109531 1.218580 0.936551 1.053645 1.124681 1.239229 1.080843 1.469489 0.564251 0.976183 1.320843 0.473769 0.158597 1.642110 0.640983 0.421437)
     )

;;; 100 even --------------------------------------------------------------------------------
(vector 100 13.512077331543 #r(0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0)

      10.472141 #r(0.000000 -0.079327 0.575962 1.216890 -0.014744 1.794579 0.223351 1.035736 1.450027 1.621511 1.146130 0.664482 0.663607 -0.266960 0.246822 0.754872 1.746592 -0.423496 -0.112090 1.668859 1.661047 0.950742 0.085504 0.302466 1.790192 0.512158 1.549763 -0.087872 1.606339 1.457814 0.979132 1.246348 1.572286 1.270907 0.557192 1.282392 0.773062 0.627296 0.449140 1.192929 0.105994 0.224683 -0.182519 0.743965 0.463017 1.607410 -0.217575 1.706348 1.917272 0.364576 0.425823 0.089107 1.477241 0.882347 1.143269 0.061661 0.026397 0.093540 1.833116 0.100956 -0.001875 0.084325 0.282798 1.183349 0.971365 0.306714 1.553029 0.062053 0.155585 0.754942 -0.336663 0.692895 0.554870 1.705080 0.442045 1.319460 0.995119 1.023180 1.734006 0.775241 1.099502 1.819778 -0.446034 1.513278 1.247469 0.530165 0.247921 1.473754 1.799924 0.292965 1.840516 0.908343 1.781887 1.143210 0.571911 1.546526 0.744154 1.261450 1.702101 1.407355)
      10.441892 #r(0.000000 -0.078419 0.614905 1.251438 -0.041619 1.814775 0.177017 1.030080 1.449954 1.597807 1.129312 0.664385 0.695003 -0.253219 0.261630 0.747479 1.802618 -0.450986 -0.124544 1.683979 1.639733 0.928235 0.098329 0.328915 1.800882 0.567004 1.536417 -0.108925 1.607348 1.496392 0.944502 1.250417 1.596577 1.279689 0.522052 1.329649 0.718369 0.631764 0.450072 1.155851 0.121306 0.284048 -0.204852 0.791247 0.417835 1.559590 -0.244455 1.753636 1.896972 0.344992 0.431235 0.072595 1.467994 0.863611 1.094702 0.044112 0.035102 0.103798 1.827379 0.119367 0.011923 0.021208 0.236547 1.180365 1.006347 0.302184 1.584982 0.089332 0.164608 0.799626 -0.353587 0.724007 0.633963 1.695870 0.472534 1.361563 1.063116 1.021659 1.696466 0.823914 1.095544 1.830809 -0.445330 1.497759 1.274799 0.528398 0.283435 1.488419 1.797120 0.309042 1.853448 0.912033 1.787026 1.149240 0.601502 1.544000 0.765984 1.262591 1.692106 1.411716)
      )

;;; 101 even --------------------------------------------------------------------------------
(vector 101 13.916260357992 #r(0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1)

	10.577830 #r(0.000000 0.230088 0.489949 1.896308 0.933068 0.593501 0.422308 0.060228 1.624707 0.198599 1.858938 1.074760 1.176893 0.981397 1.101455 0.671865 0.424692 0.090154 1.204682 1.678470 1.838266 0.024568 0.595975 1.448081 0.084971 1.587793 0.520717 0.874796 1.272960 1.935410 1.267081 1.651444 1.443667 0.106075 1.743028 0.700933 0.469120 0.378892 0.399951 0.519935 1.685545 1.698426 0.785883 0.473603 0.884326 1.731208 1.464294 1.924822 0.636901 0.305356 0.801079 1.744433 1.003951 0.836001 0.264502 0.624042 1.251558 0.465073 1.095465 1.359393 1.201558 0.893610 0.464655 0.265401 1.373759 1.898225 1.761890 -0.002084 1.345698 1.606225 0.081343 1.615987 1.843685 0.952555 0.240683 1.457724 0.753500 1.550264 1.132929 0.635603 1.553592 1.597112 0.562720 1.442901 1.005554 1.242061 1.201605 1.261095 1.477713 0.348336 0.005918 1.590197 0.313622 0.668027 1.281558 1.857136 1.788055 0.849243 1.615883 0.119440 1.251097)
	10.574342 #r(0.000000 0.207139 0.478891 1.897591 0.928981 0.587388 0.446055 0.050644 1.615878 0.191657 1.835743 1.060359 1.176622 0.986408 1.096063 0.672219 0.439657 0.105093 1.210496 1.686955 1.824275 0.042386 0.589348 1.446712 0.092283 1.586359 0.510298 0.881482 1.261115 1.931837 1.262783 1.644402 1.438409 0.120500 1.741963 0.687773 0.477250 0.359346 0.398597 0.520856 1.685678 1.705405 0.817986 0.493104 0.888632 1.741684 1.470396 1.953488 0.643930 0.326254 0.790329 1.755178 1.009415 0.831191 0.253334 0.626669 1.263598 0.475375 1.082491 1.358399 1.198093 0.889493 0.458785 0.265218 1.393268 1.895550 1.749050 -0.014777 1.344490 1.594923 0.077960 1.627750 1.828810 0.948439 0.230435 1.450944 0.756584 1.550397 1.139233 0.642734 1.551088 1.588240 0.570833 1.438946 1.006201 1.225154 1.199417 1.266985 1.477537 0.342731 0.015360 1.593098 0.308444 0.689793 1.283280 1.858379 1.796250 0.849980 1.608558 0.116245 1.256722)
      )

;;; 102 even --------------------------------------------------------------------------------
(vector 102 13.554303556646 #r(0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0)

	10.573986 #r(0.000000 0.455448 1.592339 0.516746 1.755302 0.430730 1.719525 0.951344 -0.011584 1.094962 0.249269 1.210204 0.681046 1.814999 1.100181 0.342805 1.598301 0.973279 1.813912 1.543187 1.213360 0.476019 1.876128 1.338406 0.323141 0.086213 1.782029 1.276211 0.922086 0.263981 1.923412 1.289879 0.951410 0.707896 0.012549 1.851646 1.630674 1.384243 1.051926 0.762336 0.305766 0.298705 1.874016 1.899771 1.620966 1.734952 1.429925 1.177184 1.271518 1.112585 1.351310 1.169594 1.017169 1.072042 1.161752 0.892462 1.662674 1.237843 1.407508 1.778309 1.632181 -0.005924 0.137286 0.529299 0.602002 0.855550 1.115330 1.528193 1.708150 1.986964 0.217781 0.770088 1.353099 1.819055 0.042966 0.583719 0.854932 1.780394 1.890656 0.692898 1.277125 1.902467 0.022802 0.892858 1.554169 0.132068 0.918216 1.832708 0.149377 0.742587 1.856221 0.273349 1.013342 0.114623 0.855957 1.713909 0.875532 1.432041 0.715192 1.022773 0.307135 1.424286)
	10.538847 #r(0.000000 0.439218 1.589873 0.524655 1.786432 0.437845 1.714084 0.878104 -0.008895 1.055200 0.266569 1.154207 0.619962 1.793769 1.048607 0.336793 1.607719 0.996995 1.834733 1.534921 1.220889 0.495358 1.913682 1.349308 0.326714 0.056684 1.791069 1.267966 0.869057 0.276580 1.956562 1.299266 0.899692 0.669547 0.006180 1.827319 1.639498 1.393132 1.017846 0.712519 0.317500 0.362334 1.956426 1.869198 1.633240 1.732987 1.436647 1.173907 1.295302 1.138785 1.390428 1.204234 1.094699 1.115028 1.181678 0.930174 1.689663 1.291196 1.434030 1.698877 1.618526 0.031143 0.150515 0.581125 0.622497 0.867610 1.132006 1.507806 1.700823 0.023406 0.228358 0.780422 1.410689 1.724372 0.072126 0.611697 0.887095 1.715995 1.822929 0.706183 1.227455 1.877274 0.029290 0.908952 1.592196 0.169922 0.937785 1.813425 0.179763 0.632587 1.869412 0.326028 1.038042 0.162062 0.939736 1.740120 0.900865 1.451860 0.737005 1.046089 0.220370 1.371478)
      )

;;; 103 even --------------------------------------------------------------------------------
(vector 103 13.923377530893 #r(0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0)

	10.655070 #r(0.000000 0.098203 0.840876 1.375107 0.153742 0.905827 1.598049 0.226902 1.106387 1.951313 0.409173 1.416206 0.300008 0.991894 1.877024 0.769923 1.633937 0.581083 1.464525 0.440302 1.508923 0.447643 1.643543 0.650572 1.662974 0.812624 0.114340 1.320550 0.512587 1.607339 0.712150 1.624256 0.673697 0.132515 1.684625 1.034157 0.294350 1.413417 0.670789 0.070085 1.514860 0.928557 0.150294 1.635889 1.040664 0.560013 0.195302 1.710399 1.367615 1.043173 0.402177 1.662716 1.456941 1.147051 0.985707 0.632104 0.408799 0.275068 1.862616 1.424547 1.082981 1.090416 0.822477 0.915783 0.592819 0.610365 0.257982 0.450718 0.126885 0.491389 0.133294 0.376246 0.118720 0.195423 1.887844 0.645109 0.531798 0.762689 0.732490 0.998025 0.912568 1.060467 1.162384 1.198622 1.637406 0.207879 0.126974 0.580167 0.848976 1.222343 1.532632 1.780660 0.095903 0.581413 1.052384 1.441822 1.990917 0.734482 1.101269 1.710370 0.157742 0.650375 1.262955)
	10.637699 #r(0.000000 0.072099 0.820394 1.359912 0.179595 0.900065 1.583502 0.218511 1.101883 1.970401 0.400594 1.426728 0.303545 0.996940 1.861231 0.794092 1.616200 0.601408 1.473710 0.479093 1.531323 0.441598 1.650724 0.662292 1.665558 0.821268 0.114838 1.326728 0.506797 1.589106 0.708567 1.634637 0.680975 0.136279 1.696297 1.023011 0.288578 1.399601 0.679633 0.067093 1.517997 0.923741 0.165011 1.627611 1.035363 0.574464 0.211876 1.709426 1.362157 1.035620 0.403713 1.659873 1.434545 1.175630 0.995636 0.635112 0.402899 0.265544 1.863627 1.423028 1.069857 1.098997 0.842321 0.929525 0.582951 0.609559 0.265913 0.460702 0.128433 0.493992 0.146832 0.378353 0.140301 0.185910 1.907475 0.623817 0.539723 0.742726 0.735137 0.992880 0.909352 1.064425 1.147479 1.191187 1.634759 0.235079 0.114445 0.586736 0.844371 1.211150 1.548662 1.768169 0.094471 0.595048 1.045395 1.416944 0.005895 0.738171 1.090696 1.695400 0.153870 0.655104 1.282748)
      )

;;; 104 even --------------------------------------------------------------------------------
(vector 104 14.080453047533 #r(0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 1)

	10.681525 #r(0.000000 -0.024256 0.783678 0.790357 0.543059 0.305361 -0.134503 0.818664 1.525254 0.494738 0.824462 0.413278 0.768548 0.076204 0.116598 0.283930 0.002578 1.585676 1.025319 1.696095 0.040592 0.097252 1.464874 0.943760 1.446445 1.337085 -0.054264 0.475515 1.125978 1.147471 1.094995 0.186610 0.588805 0.970144 0.882957 0.245963 0.284357 -0.394290 1.437271 0.927960 1.125343 0.492129 -0.680606 0.536491 0.927855 1.405256 0.384789 0.057902 1.208331 0.288662 1.508156 1.581082 1.167052 1.243667 1.226450 0.112600 1.111908 1.348016 0.638821 1.169461 0.306222 1.466381 0.659007 1.306085 1.700156 1.339421 0.711646 0.085484 0.909896 -0.178331 1.447928 0.767489 1.399367 -0.197416 1.574394 0.605814 -0.011981 -0.082006 0.824364 0.264841 1.418643 0.988277 -0.314078 0.146715 0.221811 0.630751 0.576546 0.496630 0.654974 1.143866 1.326186 1.202136 1.173988 0.681397 1.563605 0.912110 1.479070 0.009348 0.151736 0.948455 0.251873 0.215256 0.959463 1.013975)
	10.655611 #r(0.000000 0.002737 0.786660 0.762464 0.503819 0.286393 -0.101094 0.874998 1.473752 0.481431 0.799735 0.454749 0.797562 0.123163 0.117222 0.299046 0.020912 1.578857 1.002895 1.705703 -0.007757 0.103195 1.480404 0.954385 1.407414 1.390281 -0.078762 0.508743 1.125652 1.147568 1.109298 0.241566 0.554602 0.966853 0.853762 0.213708 0.336631 -0.359417 1.450986 0.895600 1.109197 0.514949 -0.727672 0.567370 0.897173 1.381717 0.383667 0.089275 1.227868 0.247579 1.500874 1.583210 1.136756 1.239813 1.262486 0.096506 1.116379 1.355019 0.566342 1.196814 0.267296 1.445432 0.676139 1.305121 1.708995 1.306893 0.702076 0.139787 0.915417 -0.114840 1.455487 0.770828 1.400008 -0.253470 1.614592 0.656377 -0.057294 -0.079245 0.869749 0.267749 1.372939 0.997670 -0.263003 0.171045 0.150465 0.628025 0.586743 0.431280 0.661077 1.149059 1.370748 1.121815 1.100709 0.702840 1.550696 0.883995 1.521682 0.013911 0.118726 0.932771 0.320159 0.230465 0.904049 1.045610)
      )

;;; 105 even --------------------------------------------------------------------------------
(vector 105 14.023490699521 #r(0 1 1 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 0 0)

	10.762178 #r(0.000000 0.397875 0.415370 0.882172 0.546824 1.353988 1.428323 0.899356 0.371635 0.978504 0.763060 1.852147 0.544169 0.212342 0.787152 0.707632 0.540670 1.634630 1.456913 1.887455 0.659515 1.903305 1.487136 0.606049 0.181640 0.198532 0.870626 0.299967 1.007267 0.225649 1.806738 0.672311 0.647212 0.706876 1.445160 0.654294 0.635429 0.365790 0.507155 0.852393 0.362305 0.862000 0.544259 1.758526 1.506465 1.313083 0.892464 0.407338 1.550831 0.757533 1.555137 -0.026848 1.155141 1.305207 1.788542 1.889285 0.358766 1.027604 0.314507 0.587817 0.916345 0.200487 1.411080 1.048840 1.178903 0.194143 1.901728 1.960301 1.945844 1.173118 1.765984 0.206171 1.625946 0.040059 1.626954 0.263952 1.564387 1.266244 1.622196 0.755369 0.949828 0.255858 0.753659 1.729344 1.050369 1.743664 1.440420 0.145640 0.301718 1.174665 0.822890 1.317300 1.570892 0.407998 0.956005 1.432600 0.239369 0.699233 1.040355 0.955730 0.525379 0.245609 0.402988 1.983561 1.494957)
	10.723721 #r(0.000000 0.332824 0.415440 0.882736 0.523803 1.360644 1.423388 0.878260 0.362463 0.941638 0.806813 1.864927 0.586179 0.235848 0.839924 0.741525 0.612339 1.698359 1.465636 1.845257 0.657866 1.930277 1.548390 0.683787 0.112127 0.214598 0.881090 0.305091 0.990206 0.262783 1.806904 0.631628 0.647942 0.718460 1.496351 0.662584 0.639216 0.341484 0.526111 0.857527 0.332014 0.848248 0.538801 1.716285 1.540197 1.242894 0.874447 0.424758 1.530278 0.795862 1.560588 -0.045609 1.189403 1.318764 1.757011 1.932209 0.322168 0.988472 0.391897 0.586565 0.851440 0.179414 1.410229 1.032432 1.218472 0.243614 1.885097 -0.034215 1.892638 1.194939 1.805237 0.199323 1.638056 0.029528 1.623101 0.215857 1.613430 1.255620 1.686531 0.731822 0.943406 0.279542 0.804147 1.685225 1.001003 1.798551 1.462914 0.172784 0.323532 1.207708 0.894405 1.305291 1.576647 0.370376 0.912087 1.409772 0.249314 0.754150 0.992208 0.995763 0.410803 0.283607 0.381350 -0.007445 1.467917)
      )

;;; 106 even --------------------------------------------------------------------------------
(vector 106 14.077123010357 #r(0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1)

	10.830737 #r(0.000000 -0.005846 0.570672 0.234799 1.335287 1.359588 -0.419716 0.539638 0.608529 0.339921 1.061903 -0.158242 -0.044398 1.229716 1.763841 1.099423 1.509512 0.089726 1.005316 -0.075124 -0.066461 1.466196 0.771111 0.468552 1.415804 0.138963 -0.245805 0.138836 0.477088 1.188902 1.132158 1.069838 1.264025 0.968611 1.914288 1.097597 1.541915 0.300326 1.372837 1.925102 1.312271 -0.023238 1.373743 1.323233 1.094484 0.489712 0.482163 1.087861 0.500643 0.570320 1.558451 0.587192 1.367163 1.157295 0.201827 0.338548 0.589886 0.627255 0.836138 0.810466 -0.203530 1.496837 1.317835 0.258851 0.104005 1.762383 1.590637 1.892947 1.673713 0.391886 0.132951 1.390857 1.679677 1.113406 0.925816 1.243522 0.395898 -0.235350 0.125786 0.071751 0.796497 -0.006564 0.517719 0.324240 -0.029479 1.648460 0.422894 0.173347 0.366226 -0.269652 0.667311 0.224137 1.099578 1.062306 -0.039311 0.586541 0.652636 1.087861 0.037847 0.544588 -0.167470 1.665629 0.356235 0.598705 1.690854 1.284152)
	10.812622 #r(0.000000 -0.000527 0.583336 0.213931 1.345779 1.365423 -0.414111 0.533941 0.597784 0.342990 1.049705 -0.157990 -0.041990 1.234163 1.765199 1.107878 1.519379 0.093058 0.999648 -0.078379 -0.058631 1.475810 0.769209 0.443553 1.420724 0.126532 -0.252156 0.149708 0.494965 1.199937 1.134682 1.091128 1.279340 0.971378 1.891052 1.097189 1.523842 0.311775 1.348562 1.918994 1.317178 -0.041342 1.372711 1.328828 1.104728 0.497744 0.494504 1.061175 0.513407 0.549915 1.555977 0.588331 1.369798 1.153396 0.187734 0.337016 0.604247 0.633637 0.819682 0.814422 -0.227250 1.486086 1.320807 0.264193 0.090191 1.767222 1.580824 1.892570 1.684578 0.410804 0.153408 1.384440 1.705035 1.128131 0.965667 1.264814 0.410625 -0.232707 0.109608 0.093927 0.772327 0.009719 0.500858 0.326173 -0.027905 1.657634 0.438218 0.180908 0.380595 -0.267994 0.658322 0.234666 1.141409 1.095461 -0.057278 0.604403 0.650485 1.083029 0.054000 0.567556 -0.162320 1.663794 0.358557 0.599805 1.692337 1.285239)
      )

;;; 107 even --------------------------------------------------------------------------------
(vector 107 13.979104817741 #r(0 0 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)

	10.937211 #r(0.000000 -0.004224 0.060024 -0.045111 1.214471 1.071129 0.959468 -0.117229 0.526421 0.777989 1.101830 1.594870 1.129631 1.240597 0.114410 -0.015477 -0.160025 1.227190 0.975588 0.257050 0.062807 0.334972 0.704097 1.491576 0.263834 0.840227 0.134041 0.515784 0.095610 1.204429 1.214110 -0.209995 0.542934 1.280779 0.060334 1.305652 0.399609 0.055093 1.015156 -0.124325 0.060155 1.228735 0.771913 1.621598 0.808853 1.471209 -0.169978 1.121641 0.399914 1.719441 0.379423 1.503274 1.042517 0.685780 0.947470 0.570388 0.750717 1.227614 1.713741 0.574606 1.613832 0.259018 1.237457 1.030851 1.608948 1.331324 0.222275 1.365789 1.141241 0.137043 0.400610 0.136266 1.777801 -0.008027 -0.188345 0.319469 0.129091 -0.503698 1.075061 0.022495 -0.104170 1.746336 1.362807 0.487726 1.046216 1.025881 -0.113705 0.257262 0.139668 0.033537 0.410121 0.067540 0.536883 1.096402 0.595602 1.418336 1.800057 0.344577 0.240890 1.498996 -0.357281 0.342654 1.655013 1.372406 1.308709 -0.240755 1.334030)
	10.871761 #r(0.000000 -0.038260 0.003022 -0.018329 1.213467 1.121724 0.959068 -0.160511 0.488688 0.785281 1.118276 1.544711 1.139909 1.233357 0.126103 -0.029438 -0.121856 1.238446 0.988099 0.353091 0.071789 0.374969 0.697386 1.469303 0.272146 0.836545 0.083890 0.522893 0.105483 1.125265 1.239268 -0.164882 0.473062 1.269911 0.092183 1.233174 0.490289 0.047130 1.055803 -0.115076 0.037623 1.254374 0.719443 1.622331 0.700838 1.458439 -0.131212 1.122661 0.402251 1.752491 0.411765 1.440232 1.051084 0.684942 0.919842 0.607712 0.701901 1.213147 1.671566 0.636427 1.628683 0.318565 1.291417 1.026164 1.614189 1.422466 0.225893 1.447977 1.113341 0.130879 0.381143 0.186791 1.807746 0.010150 -0.205153 0.273652 0.166348 -0.469555 1.063888 0.132156 -0.124512 1.747141 1.417884 0.518199 1.092473 1.116061 -0.120114 0.296073 0.135057 0.077875 0.451444 0.049425 0.587362 1.118866 0.690377 1.355396 1.775522 0.304132 0.222943 1.527070 -0.326515 0.290273 1.679190 1.440502 1.279010 -0.239898 1.289192)
      )

;;; 108 even --------------------------------------------------------------------------------
(vector 108 14.201394892821 #r(0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1)

	10.928835 #r(0.000000 0.001349 1.292491 0.733848 1.693309 1.799399 0.481169 -0.003953 0.631395 1.556718 0.747743 0.394608 -0.163614 0.178289 1.389719 1.500511 0.566775 1.069628 0.140033 0.292869 1.057556 -0.232775 1.757479 1.152928 0.313785 -0.002063 1.713110 1.409517 1.701701 0.540017 -0.081333 0.363976 1.907649 1.714406 0.366131 1.312522 1.061649 -0.016307 1.204902 0.111229 1.131127 1.599963 0.195405 0.048689 0.148454 1.536192 1.518659 0.029237 0.220432 0.060747 0.889494 0.493752 0.976299 1.363602 1.809211 1.216107 0.616567 0.927578 1.398521 0.961300 1.194676 0.366929 1.180567 1.477072 0.270916 0.119650 1.287137 1.475762 1.163703 1.481070 1.371759 0.541244 1.311014 1.044588 1.313660 0.533979 1.490951 0.356285 -0.069909 0.767914 0.271739 0.014710 1.682385 0.162634 1.095329 0.775810 0.661086 0.068467 1.450209 1.785189 0.063589 1.966358 1.523081 1.437414 0.274911 0.580082 1.089239 -0.463689 1.664646 1.305111 1.466902 1.475663 0.556905 0.115271 0.981770 0.504641 0.709948 1.631495)
	10.901890 #r(0.000000 -0.008760 1.311207 0.741829 1.697635 1.769978 0.483762 -0.011910 0.594000 1.571800 0.727336 0.403254 -0.178000 0.178915 1.384182 1.515775 0.559532 1.061635 0.115279 0.323553 1.057305 -0.228524 1.741056 1.146085 0.293235 -0.033854 1.693885 1.428048 1.710511 0.540760 -0.057064 0.340583 1.919299 1.760577 0.355485 1.324653 1.044007 -0.047958 1.234996 0.120399 1.129054 1.589255 0.254279 0.040885 0.123640 1.536357 1.551030 0.029166 0.239461 0.090481 0.896972 0.493208 0.966504 1.387157 1.781930 1.203618 0.622514 0.933478 1.401265 0.946772 1.223548 0.392050 1.186575 1.501791 0.258041 0.107248 1.312213 1.481863 1.152627 1.509627 1.378069 0.561671 1.320539 1.066072 1.308170 0.560447 1.496940 0.414418 -0.059448 0.768917 0.282470 -0.004845 1.720774 0.169167 1.074669 0.800931 0.672622 0.038801 1.475364 1.803127 0.073523 1.954259 1.488839 1.468133 0.272926 0.552978 1.077413 -0.457399 1.655106 1.280832 1.454803 1.496722 0.568629 0.105281 1.014193 0.516031 0.749902 1.660920)
      )

;;; 109 even --------------------------------------------------------------------------------
(vector 109 14.476561866583 #r(0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1)

	10.962218 #r(0.000000 -0.020139 1.296818 0.759398 1.805908 1.100728 0.800122 1.439412 1.622620 0.514993 1.795449 1.209391 0.020235 0.358160 0.092111 0.419753 0.215041 0.890857 0.739133 0.655070 -0.097603 1.149145 1.795049 0.529356 0.278854 0.849651 1.115508 -0.203443 -0.316571 0.636461 0.169404 0.863285 1.244658 0.826671 1.217995 1.641136 1.077104 1.940135 -0.019991 0.361800 0.684590 0.618864 1.574258 0.100541 0.539464 1.815288 0.854878 0.087950 0.096927 0.551713 0.357857 0.524099 0.322958 1.655523 1.025258 0.447127 1.801347 0.241837 1.863980 1.144261 1.218309 0.839437 0.457453 0.658738 1.245153 1.083988 0.663284 0.430502 0.960078 0.132118 0.667264 0.423888 1.801298 1.342075 0.136707 0.381362 0.568108 1.442671 0.522741 -0.163023 0.297994 0.902549 1.034272 0.408426 0.838530 1.491663 1.889043 0.510513 1.243885 -0.037162 0.829406 0.263055 1.957688 1.777764 1.532407 1.532356 -0.098135 1.343701 -0.090007 1.030266 0.540482 0.697946 0.058406 0.051557 1.224797 1.605931 1.084281 1.340523 0.856409)
	10.958464 #r(0.000000 -0.024181 1.291520 0.767267 1.811879 1.096780 0.807284 1.452102 1.623292 0.515719 1.794434 1.214113 0.027114 0.360179 0.096523 0.419005 0.212171 0.895803 0.749024 0.650410 -0.088834 1.146803 1.786825 0.525747 0.276037 0.849704 1.121864 -0.213295 -0.302842 0.632854 0.172238 0.871167 1.241159 0.835818 1.218555 1.639369 1.067001 1.940641 -0.030143 0.337334 0.672999 0.617052 1.569265 0.100021 0.522651 1.816358 0.861901 0.095900 0.093971 0.562585 0.367211 0.522900 0.329144 1.669724 1.020259 0.433402 1.811883 0.264750 1.838811 1.144868 1.228952 0.831417 0.460454 0.660827 1.255397 1.087733 0.659449 0.414654 0.947696 0.143809 0.676137 0.414552 1.792870 1.338552 0.130905 0.385794 0.569443 1.441682 0.524972 -0.164911 0.300497 0.900622 1.033704 0.403265 0.846988 1.497297 1.880923 0.509630 1.259061 -0.017944 0.841039 0.268164 1.965701 1.777373 1.538631 1.547306 -0.085746 1.343313 -0.098745 1.037268 0.541279 0.688208 0.047031 0.052006 1.222954 1.592090 1.082928 1.331120 0.843465)
      )

;;; 110 even --------------------------------------------------------------------------------
(vector 110 14.141825477743 #r(0 0 0 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0)

	11.083621 #r(0.000000 0.102224 0.391557 0.595597 0.594876 1.372717 0.692712 1.820557 0.592991 0.744933 0.284097 0.094534 1.236489 0.656692 0.836105 1.286301 1.045083 0.906213 0.452242 1.303365 1.815972 0.742162 1.260200 1.034689 1.519277 1.714910 0.030360 1.701396 0.878133 1.252260 1.563515 1.824493 1.440884 0.550691 0.625323 0.322441 0.255155 1.747348 1.715563 1.206982 0.695445 1.179481 0.756077 1.528329 0.919865 1.229029 1.159425 1.320573 0.445003 1.914934 0.957065 0.751755 0.916124 0.636546 1.677594 1.368208 1.478534 0.887675 1.827907 0.505854 0.598384 0.760342 0.616916 0.235984 0.997501 1.394766 0.145444 0.892122 1.825648 1.436307 0.231097 0.844561 0.320584 0.655075 0.450233 0.147790 1.886750 0.073198 0.684099 0.980548 1.422263 1.230129 0.607855 1.708107 1.670067 1.087055 1.809960 1.108445 0.779703 1.445375 0.004959 0.570411 1.025881 0.429647 0.658700 0.663819 0.227169 1.057047 0.056802 0.087954 1.060399 1.762629 1.235596 0.276822 0.266842 1.518690 1.130656 0.442538 0.924181 1.667970)
	11.059884 #r(0.000000 0.128382 0.371538 0.557291 0.625808 1.351628 0.701614 1.806009 0.600715 0.732979 0.283318 0.110741 1.230364 0.671428 0.850801 1.299783 1.058519 0.892084 0.432974 1.289301 1.791571 0.752181 1.260875 1.008626 1.512097 1.727166 0.038842 1.700370 0.866999 1.240474 1.578265 1.850372 1.448854 0.547254 0.613823 0.328365 0.250539 1.750062 1.718707 1.197601 0.724627 1.199208 0.765576 1.522749 0.897674 1.199312 1.130651 1.305566 0.409839 1.904493 0.957107 0.778353 0.924733 0.678177 1.680476 1.375915 1.497651 0.853122 1.844560 0.515262 0.618020 0.752328 0.596650 0.237988 0.979601 1.374435 0.138866 0.924444 1.825939 1.448797 0.183030 0.863483 0.340399 0.667618 0.464570 0.154564 1.886018 0.079312 0.671397 0.968235 1.426489 1.234932 0.594098 1.700737 1.694962 1.056715 1.809405 1.117610 0.795602 1.456320 0.035027 0.567201 1.028644 0.435753 0.636400 0.652240 0.222578 1.027763 0.072905 0.073994 1.054216 1.757379 1.232570 0.279961 0.282736 1.511203 1.136073 0.439627 0.936127 1.657387)
      )

;;; 111 even --------------------------------------------------------------------------------
(vector 111 14.043108609984 #r(0 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 0 1)

	11.044285 #r(0.000000 0.158015 0.933037 1.614942 0.438728 1.109662 1.925788 0.472812 1.243741 0.106020 0.791740 1.640176 0.492268 1.485008 0.348988 1.215620 0.210371 0.907594 1.877045 0.815828 1.746879 0.708997 1.883211 1.043991 0.199639 1.074067 0.180622 1.253869 0.348260 1.556554 0.806309 0.044157 1.125294 0.382590 1.810361 1.146217 0.335649 1.611965 0.680338 1.937389 1.233789 0.766403 0.308709 1.641326 0.874950 0.294876 0.039653 1.398544 0.690400 0.241248 1.690671 1.329862 0.933824 0.621841 0.215994 1.901023 1.430062 1.233607 0.739730 0.472666 0.123106 0.067252 1.738994 1.459373 1.478846 1.201845 1.291598 0.805256 0.526423 0.555011 0.429805 0.468900 0.550665 0.287845 0.418385 0.091842 0.561234 0.306326 0.551107 0.349285 0.443927 0.497444 0.741730 0.889477 1.210808 1.343091 1.439025 1.479999 1.836181 0.047632 0.373687 0.550415 0.777036 1.388872 1.698564 0.091159 0.463192 0.987707 1.050209 1.564941 1.953806 0.531885 1.227608 1.522869 0.053791 0.776531 1.501133 1.889970 0.686171 0.911252 1.640718)
	10.962200 #r(0.000000 0.101441 0.982500 1.622182 0.435973 1.132826 1.916394 0.466919 1.282549 0.106702 0.822917 1.670424 0.503141 1.534105 0.375975 1.281575 0.213224 0.919616 1.877533 0.775739 1.697874 0.635743 1.878719 1.005809 0.117804 1.045576 0.184335 1.296556 0.312839 1.530895 0.764842 0.001837 1.065550 0.399001 1.815485 1.127959 0.323638 1.622803 0.618390 1.914806 1.252012 0.774494 0.276141 1.654592 0.875835 0.224220 0.105741 1.448846 0.673723 0.202734 1.719143 1.430787 0.960901 0.580044 0.216029 1.940075 1.519845 1.228068 0.755865 0.422002 0.128938 0.097674 1.767997 1.577346 1.512735 1.286979 1.334403 0.747400 0.566022 0.512464 0.420179 0.476572 0.485716 0.310069 0.410649 0.127310 0.535251 0.330526 0.546628 0.297453 0.460546 0.467102 0.756615 0.965709 1.250982 1.419347 1.512597 1.506550 1.932151 0.044525 0.371558 0.543880 0.793911 1.426881 1.745178 0.091636 0.500091 1.035400 1.040570 1.580458 1.952025 0.527586 1.202063 1.570099 0.075568 0.820249 1.578634 1.929773 0.730234 0.929175 1.607930)
      )

;;; 112 even --------------------------------------------------------------------------------
(vector 112 14.53456401825 #r(0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1)

	11.132899 #r(0.000000 -0.004199 1.283910 0.989370 -0.208623 1.916334 0.074521 1.835438 1.334006 0.305929 1.500009 -0.074494 1.168847 0.049877 1.276892 1.333761 -0.092116 1.454810 0.477624 0.576171 0.178508 0.764025 0.524952 1.017918 1.503303 0.222438 0.024354 0.989207 -0.051649 0.790422 1.303684 -0.215343 0.911639 1.672316 0.816315 1.393173 1.438934 1.325167 0.960271 0.472591 1.161764 -0.301446 0.550621 1.114416 1.344136 1.489640 1.336572 0.050968 0.500820 -0.057732 1.192684 1.166393 1.318354 1.292569 1.273498 0.099165 0.438587 1.952651 -0.094274 1.629010 1.153422 1.621198 0.812392 0.958180 1.035359 0.874583 0.398809 1.397735 0.813120 1.083168 1.586479 1.738041 -0.184237 0.887045 0.555348 1.573618 0.841883 0.094362 0.127164 -0.091421 0.370018 0.132149 0.004963 0.522483 0.330656 0.374322 1.610332 1.059431 0.769509 1.653723 0.151945 1.881470 1.251612 1.570585 0.545409 0.439130 1.754244 0.242385 1.453705 1.649898 0.928413 0.488588 1.234024 -0.316648 1.499904 0.614604 0.329349 1.231718 0.063978 0.324984 0.806167 0.116728)
	11.127877 #r(0.000000 -0.001085 1.282137 0.998741 -0.205971 1.928565 0.071274 1.841319 1.326948 0.300685 1.498908 -0.070768 1.161590 0.056680 1.272930 1.334591 -0.098080 1.464315 0.479872 0.580105 0.176864 0.756087 0.531884 1.012143 1.498205 0.228987 0.022862 0.999876 -0.051067 0.794646 1.309610 -0.219189 0.915579 1.677757 0.806023 1.382033 1.455612 1.332480 0.960905 0.464394 1.162518 -0.306061 0.559742 1.123282 1.350167 1.504507 1.342966 0.050212 0.499237 -0.040806 1.192981 1.158327 1.296484 1.289977 1.276373 0.095106 0.432483 1.951563 -0.083531 1.633917 1.149290 1.612046 0.813429 0.955830 1.031410 0.871830 0.390349 1.411863 0.797892 1.070847 1.576282 1.738863 -0.192573 0.878441 0.534579 1.599154 0.837106 0.103982 0.123777 -0.087352 0.353263 0.141925 0.015053 0.515859 0.335270 0.376322 1.623684 1.054267 0.761042 1.645886 0.155603 1.874182 1.253296 1.577361 0.535183 0.437252 1.764140 0.225923 1.434672 1.651003 0.945081 0.498783 1.227669 -0.300084 1.497489 0.611723 0.332536 1.215022 0.058021 0.315300 0.806999 0.126957)
      )

;;; 113 even --------------------------------------------------------------------------------
(vector 113 14.699631659332 #r(0 0 1 1 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0)

	11.086230 #r(0.000000 -0.000389 -0.085077 1.561730 0.939636 0.783800 0.822356 0.753902 1.063386 1.064106 0.248945 -0.331235 0.891273 0.384236 1.666476 1.209055 0.747827 1.261264 0.977109 0.473018 1.869842 1.640635 0.426272 0.493282 0.533612 0.678013 0.886344 1.278452 0.240683 0.355081 0.485535 1.773399 1.825457 0.749792 0.520365 0.198490 0.250957 0.893317 0.038147 1.767495 1.585752 1.382949 0.153130 0.345263 1.470526 1.544311 -0.012268 0.353892 0.265833 0.472828 0.199271 0.570776 0.068734 -0.052674 -0.058660 0.544786 0.747249 1.268098 -0.214510 0.394163 0.864637 0.802715 -0.354031 0.495687 0.772508 0.500088 0.648134 0.893273 0.437351 0.101751 1.505344 1.430317 1.237725 -0.133160 1.737117 0.276904 0.819294 -0.436692 0.255417 1.171282 -0.127128 0.741289 1.135948 0.224854 1.189320 1.263745 1.436981 1.094323 0.315920 0.551659 -0.076936 0.988425 0.147044 1.117725 1.898145 1.201889 0.000719 0.311682 0.796660 0.441683 0.674490 1.525693 0.432480 -0.261252 0.793197 1.692433 1.264116 1.229766 1.345051 1.012949 0.026436 1.326999 0.385241)
	11.042240 #r(0.000000 -0.011759 -0.091990 1.503851 0.953995 0.848423 0.824449 0.769931 1.085693 0.983953 0.209264 -0.381935 0.887958 0.412792 1.563438 1.182410 0.718501 1.286560 0.936464 0.451526 1.868537 1.661000 0.472937 0.524903 0.523627 0.742147 0.953195 1.273434 0.194871 0.356781 0.462037 1.763149 1.817491 0.735758 0.599041 0.219096 0.223049 0.947680 -0.008188 1.758721 1.570440 1.411663 0.250146 0.316431 1.488300 1.511605 -0.005537 0.330964 0.273108 0.486846 0.169393 0.538750 0.076418 -0.023342 -0.009678 0.527384 0.784140 1.277766 -0.217309 0.402150 0.912791 0.727922 -0.304687 0.485700 0.714916 0.485789 0.629834 0.893321 0.458517 0.111885 1.499674 1.465753 1.237628 -0.061921 1.790009 0.232643 0.792305 -0.479127 0.277430 1.180560 -0.176791 0.702891 1.163014 0.174404 1.121157 1.255388 1.509324 1.042583 0.380342 0.559327 -0.068543 0.980949 0.101017 1.112311 1.902337 1.208033 0.019879 0.351728 0.726801 0.451055 0.693184 1.569399 0.365346 -0.317722 0.810357 1.689676 1.274532 1.275271 1.331575 1.000370 -0.008700 1.311938 0.401453)
      )

;;; 114 even --------------------------------------------------------------------------------
(vector 114 14.492 #r(0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 1 0 0 0 0 0 1)

	11.157135 #r(0.000000 -0.039464 0.696620 1.049808 1.784392 0.325544 0.858380 1.305402 0.025713 0.621307 1.231983 1.810377 0.686152 1.384942 0.194646 1.038532 1.591698 0.399402 1.138014 1.856685 0.607032 1.487902 0.438056 1.390980 0.254957 1.178058 0.067020 0.938265 1.875276 0.851076 0.004242 1.047055 0.045055 1.007007 0.277254 1.473760 0.430329 1.411705 0.732780 1.815871 0.875020 0.057294 1.303464 0.776395 0.029104 1.052938 0.330119 1.901182 1.233681 0.357134 1.566517 1.090726 0.497634 1.859625 1.337968 0.810851 0.475823 1.810735 1.275081 0.613201 0.249187 1.680606 1.475238 0.917317 0.615081 0.035115 1.985536 1.555790 1.295493 0.711316 0.674571 0.194958 0.031526 1.689053 1.752486 1.376552 1.332463 1.199628 1.038471 0.887824 0.776195 0.244582 0.396901 0.380408 0.272363 0.437965 0.462200 0.460243 0.479976 0.174041 0.442325 0.587458 0.662414 0.624435 0.793505 1.270764 1.312001 1.527872 1.906728 0.154209 0.367925 0.274540 0.568448 0.741643 1.347518 1.802398 -0.015484 0.528377 1.078486 1.236948 1.800583 0.083771 0.530926 0.938750)
	11.098347 #r(0.000000 -0.084305 0.686719 1.094932 1.777563 0.352231 0.865991 1.279925 0.026498 0.635188 1.219862 1.804907 0.697456 1.406296 0.222804 1.043716 1.615578 0.439298 1.168459 1.904027 0.627364 1.579649 0.491166 1.406096 0.295653 1.249071 0.073326 0.964412 1.869141 0.835209 -0.027878 1.062653 0.042041 0.921226 0.288367 1.475210 0.454427 1.435928 0.717659 1.808229 0.838869 0.045471 1.230020 0.678087 -0.037112 1.008578 0.361932 1.875193 1.232330 0.293112 1.469296 1.119144 0.503482 1.773502 1.333307 0.823102 0.445692 1.763963 1.223804 0.590000 0.322677 1.712976 1.485726 0.940203 0.584026 -0.050739 -0.000940 1.558065 1.401153 0.782566 0.685465 0.248631 -0.011153 1.752643 1.682340 1.391724 1.316354 1.229915 1.001469 0.942190 0.768191 0.259975 0.412575 0.436097 0.321280 0.485202 0.478377 0.469726 0.528254 0.211780 0.499094 0.616893 0.739571 0.706949 0.797232 1.262382 1.306987 1.509284 1.881383 0.249648 0.351980 0.334789 0.600847 0.755270 1.339168 1.848532 -0.016155 0.526717 1.060832 1.195852 1.719393 0.117308 0.591043 0.923858)
      )

;;; 115 even --------------------------------------------------------------------------------
(vector 115 14.568 #r(0 1 0 1 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1)

	11.164043 #r(0.000000 -0.007735 0.519521 0.853408 0.869518 0.698179 0.507264 1.931615 0.907177 -0.081980 1.081445 -0.614824 0.113202 -0.200689 1.235563 -0.410618 -0.044424 1.664294 0.004420 -0.047758 -0.084756 0.183149 0.916469 0.869368 0.512976 0.672797 1.215314 0.375058 0.915864 1.704866 0.936574 0.218869 0.698296 0.045271 1.628914 0.078964 0.149407 0.338531 0.117882 -0.320994 1.491596 1.006019 -0.240429 1.202447 1.241878 1.751514 1.720285 0.676992 -0.221839 1.582392 1.209034 1.838537 0.581983 1.407446 0.568243 0.270174 1.675976 1.382944 1.186838 0.261842 1.726931 1.658063 1.186047 0.622126 0.744214 1.106115 1.040724 0.077608 1.153074 1.203757 -0.097198 0.746254 0.828552 0.000738 0.431630 0.964545 1.375943 1.286789 1.299809 0.427471 1.340955 0.754972 1.408156 0.094923 0.222079 1.183606 -0.446708 1.549043 0.356824 0.090057 -0.448761 1.856851 1.141144 -0.262172 1.428502 1.426364 0.962275 0.289782 0.928089 1.983331 -0.130528 1.708026 0.141800 0.998440 0.458314 -0.400945 1.256766 -0.158747 1.393865 0.122714 0.409705 1.066166 0.512662 1.368814 -0.157203)
	11.110930 #r(0.000000 -0.022258 0.546651 0.820825 0.863779 0.676552 0.465607 1.912748 0.891113 -0.023328 1.112499 -0.561967 0.077021 -0.236221 1.201056 -0.357028 -0.135597 1.695864 0.020904 -0.014362 -0.046858 0.224875 0.950393 0.860763 0.507889 0.703037 1.149774 0.424951 0.869276 1.742922 0.930660 0.209184 0.714027 0.099306 1.605888 0.094118 0.072793 0.337413 0.037166 -0.429125 1.483943 0.947097 -0.230811 1.260136 1.245063 1.706276 1.663594 0.638816 -0.203738 1.582655 1.221409 1.765408 0.635267 1.340362 0.524104 0.262335 1.733350 1.410810 1.152474 0.297249 1.698065 1.592509 1.170191 0.600245 0.735038 1.067837 1.004305 0.072927 1.171730 1.251359 -0.136393 0.666240 0.837642 -0.025528 0.464160 0.954527 1.436030 1.301459 1.347745 0.368943 1.324507 0.782967 1.347513 0.072002 0.203967 1.181467 -0.425791 1.583443 0.318520 0.146198 -0.532390 1.922934 1.160601 -0.299039 1.454982 1.443796 0.959599 0.283371 0.857470 0.008285 -0.126730 1.672030 0.076134 0.919373 0.449423 -0.420407 1.240674 -0.238980 1.419242 0.108745 0.361247 1.035726 0.526839 1.297726 -0.220148)
      )

;;; 116 even --------------------------------------------------------------------------------
(vector 116 15.016979484255 #r(0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1)

	11.308873 #r(0.000000 0.106229 0.367548 0.759703 1.450113 0.465588 0.341776 1.222993 1.113540 1.977777 0.446611 1.479153 0.955230 1.992164 0.113898 1.375014 0.059260 1.796441 0.549529 1.451646 0.822821 0.184153 0.830995 0.917449 1.204323 1.332702 0.993172 0.476637 0.152682 0.285363 1.211807 1.922965 1.934074 0.639385 1.616893 0.230624 1.048187 1.300335 1.518811 0.179696 1.385435 1.756315 0.391503 1.071522 1.058267 0.918446 1.149703 1.296773 1.452377 0.657106 1.424678 0.536336 1.485981 1.611780 0.685035 0.081570 0.627797 1.372075 1.222404 1.169964 1.598122 0.868152 1.372826 0.969303 1.586861 1.193094 0.604224 0.998617 0.464449 0.148345 1.841878 1.782198 1.348866 0.090916 1.094752 0.710300 0.820593 1.392694 1.514436 0.049760 1.558012 1.165815 1.487314 0.076812 1.896177 1.104849 0.595775 1.855654 1.593410 0.247419 1.353710 0.594589 0.610661 1.819899 0.938600 0.733465 1.567730 0.600698 0.773170 0.184194 0.659368 0.319562 0.537696 0.610429 1.447619 1.265473 0.841708 1.485819 0.127545 1.328769 1.079928 0.763531 0.772097 1.829006 1.877480 1.871926)
	11.277789 #r(0.000000 0.138558 0.353334 0.732609 1.466335 0.442620 0.355400 1.256820 1.098025 -0.005752 0.461058 1.458454 0.950319 0.007368 0.142342 1.388851 0.061902 1.789918 0.549269 1.413537 0.825366 0.204031 0.848000 0.919405 1.149599 1.315026 0.982443 0.510264 0.165540 0.235480 1.204630 1.939519 1.929226 0.652542 1.657663 0.250312 1.036625 1.299117 1.510759 0.176650 1.373970 1.713783 0.402361 1.150814 1.080597 0.910571 1.145886 1.285049 1.424689 0.696501 1.418026 0.550177 1.469848 1.617872 0.718078 0.116111 0.604744 1.337253 1.225191 1.194313 1.618071 0.888974 1.319098 0.950207 1.578045 1.168234 0.588120 0.978791 0.407817 0.203165 1.838352 1.709608 1.322935 0.085508 1.008488 0.674606 0.840645 1.426356 1.496070 0.091872 1.506537 1.114944 1.542923 0.104865 1.908253 1.125385 0.553795 1.861598 1.569825 0.283328 1.347436 0.562934 0.585686 1.843303 0.919209 0.760478 1.551244 0.654366 0.747062 0.126063 0.655696 0.345684 0.578473 0.602953 1.442577 1.226981 0.871137 1.454009 0.120416 1.377725 1.077575 0.748925 0.804978 1.803812 1.882510 1.871714)
      )

;;; 117 even --------------------------------------------------------------------------------
(vector 117 14.875072951405 #r(0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0)

	11.316924 #r(0.000000 0.002007 0.781183 0.142859 1.136983 0.564897 1.668822 1.434278 0.786253 -0.066154 0.611443 0.995393 0.251112 1.435273 1.364551 0.525535 1.314966 0.129127 0.479417 1.253995 -0.066213 1.791978 1.010496 1.762957 1.001915 0.214345 0.247689 0.903489 0.260750 0.253476 1.207167 1.205379 1.535712 0.678624 0.281388 0.707771 0.067718 0.139190 1.072777 -0.486251 1.036395 0.468802 1.185352 1.038535 0.280173 0.909530 -0.484113 1.287468 1.260568 1.711487 0.150804 1.583879 0.090810 1.204628 1.205628 1.363904 1.302202 -0.374153 1.893817 1.633143 0.456452 1.096868 0.228741 1.451713 1.797254 1.457252 0.043295 1.213733 1.209057 1.602790 0.068325 1.156775 0.622551 0.595184 1.038306 1.138842 -0.234118 1.017885 1.021316 0.185827 1.543882 1.771287 1.232077 0.638733 0.782279 1.727494 1.416897 0.927851 0.310771 0.940398 0.359593 0.479087 0.049395 0.127472 0.206640 1.096147 1.150359 1.659289 0.531691 1.180395 -0.391853 1.508862 1.232699 -0.058238 1.293947 -0.476640 -0.441677 -0.000097 0.976133 1.008107 0.426436 0.349033 0.468049 0.890361 0.742074 -0.282223 0.097574)
	11.295655 #r(0.000000 0.015789 0.761927 0.164296 1.137226 0.572015 1.663440 1.422409 0.787792 -0.050155 0.628761 0.990142 0.277289 1.451991 1.375499 0.530096 1.301677 0.122893 0.519504 1.243827 -0.093242 1.778981 0.990377 1.757063 0.998987 0.234404 0.215484 0.915405 0.226108 0.243442 1.185985 1.200501 1.457317 0.707602 0.281757 0.694395 0.083409 0.127419 1.069295 -0.500183 1.020824 0.421117 1.221639 1.025988 0.307270 0.873043 -0.504555 1.251328 1.261585 1.713619 0.158915 1.628175 0.087783 1.174880 1.183778 1.372114 1.284578 -0.354833 1.896012 1.648387 0.414766 1.072585 0.205469 1.421474 1.796970 1.478510 -0.009812 1.222216 1.185407 1.616957 0.050578 1.185467 0.607145 0.554314 1.018625 1.169956 -0.225029 1.045280 0.990726 0.187911 1.542308 1.755477 1.208191 0.597581 0.837919 1.722420 1.401438 0.887685 0.291694 0.955671 0.382697 0.515715 0.058443 0.094135 0.186403 1.061126 1.115386 1.656241 0.520357 1.154728 -0.447353 1.461708 1.223909 -0.102756 1.247952 -0.484730 -0.459947 -0.051712 0.971718 1.010436 0.426586 0.309351 0.447941 0.879457 0.725669 -0.314260 0.136093)
      )

;;; 118 even --------------------------------------------------------------------------------
(vector 118 14.774983755641 #r(0 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1)

	11.484440 #r(0.000000 0.001991 1.371443 1.203612 1.612576 0.004093 1.549674 1.288096 -0.387029 0.195003 0.810853 0.270601 -0.577973 0.504742 1.563436 0.486759 1.262262 1.570710 0.506761 0.593681 0.979316 0.335707 1.012168 1.408672 1.854537 -0.158648 0.922395 1.542523 0.986042 0.834203 1.587297 -0.259646 0.182780 1.551059 1.155567 -0.257572 1.455112 0.260440 0.601953 0.584384 0.049890 0.147201 0.144045 0.167346 1.932438 -0.017361 0.127366 1.610439 0.342924 0.013626 1.817380 1.463720 1.349166 1.704788 0.073700 0.915288 0.862503 0.591911 -0.314143 1.485517 0.827715 -0.237036 1.912130 0.274385 1.072007 0.283372 1.321692 0.776602 1.550269 0.993130 0.787661 0.571393 0.826289 1.556852 0.493665 1.623055 1.585319 1.166393 1.153368 1.675993 0.390711 -0.188185 1.283768 1.613360 0.827291 0.287448 0.106800 0.359659 1.804631 1.116403 1.085383 0.798175 1.148482 1.482094 1.397430 -0.132223 0.799212 -0.083458 -0.185498 0.780581 -0.264041 0.816859 1.276724 0.301164 1.464050 0.647926 1.027415 1.036757 -0.070219 0.009504 1.202438 0.566235 0.360100 -0.509218 0.735525 1.198215 0.064044 0.933335)
	11.430459 #r(0.000000 -0.002386 1.351020 1.195235 1.641650 0.051761 1.571466 1.335031 -0.430277 0.166765 0.795826 0.277081 -0.613994 0.513637 1.515888 0.499068 1.273330 1.561448 0.515799 0.564727 0.965770 0.392215 0.994634 1.399343 1.836525 -0.113380 0.932903 1.544724 1.001123 0.863828 1.623559 -0.213987 0.188358 1.475181 1.229626 -0.263488 1.484470 0.252577 0.644938 0.557482 0.058922 0.194074 0.194026 0.173436 1.980047 -0.041784 0.088352 1.590134 0.326309 -0.014259 1.906859 1.475323 1.365229 1.740371 0.031667 0.992816 0.847417 0.617823 -0.353035 1.539456 0.841917 -0.171556 1.983344 0.333022 1.107476 0.288180 1.297023 0.803275 1.551471 0.997237 0.773738 0.526398 0.839684 1.564071 0.478223 1.619712 1.587580 1.173962 1.170969 1.649064 0.409317 -0.195377 1.263939 1.624548 0.858332 0.359467 0.126566 0.378534 1.850649 1.156439 1.102451 0.823089 1.173995 1.480436 1.412268 -0.136458 0.811973 -0.067259 -0.193895 0.767282 -0.278014 0.867874 1.257081 0.301798 1.419953 0.661723 1.088239 1.080885 0.024818 0.012407 1.197551 0.555424 0.340171 -0.508592 0.747823 1.261611 0.010095 0.902361)
      )

;;; 119 even --------------------------------------------------------------------------------
(vector 119 14.971 #r(0 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1)

	11.482774 #r(0.000000 0.022508 -0.154621 -0.133560 0.019055 0.044006 0.744199 -0.189660 1.646970 0.323873 1.389900 0.872285 1.714451 0.465026 0.101347 1.045318 0.619662 0.299667 0.695492 1.761299 -0.465991 1.247091 0.360217 0.709249 0.270723 1.861018 1.538710 1.394055 1.300550 0.683046 1.420419 1.591103 0.068117 0.694826 0.315654 0.206747 0.551524 0.669546 0.407597 0.609362 1.957764 1.313475 1.269191 1.535059 -0.453483 1.127112 -0.438414 1.098010 0.925063 1.295295 0.349547 1.800021 1.265884 1.210725 1.261945 1.409059 0.031987 1.064471 1.087820 0.131065 1.230087 1.008698 0.646880 1.108562 0.465537 -0.286867 1.491020 1.274669 0.240579 1.517428 0.852795 0.970665 0.563004 0.179967 1.049271 1.080429 0.558118 -0.026181 0.946833 1.033681 0.158731 0.889882 0.983418 -0.020663 1.724961 1.892566 0.743055 1.647217 1.582049 1.007387 1.541602 0.779919 1.494250 -0.227797 0.081916 -0.223533 0.250776 1.270562 1.106978 1.124428 0.217158 1.341937 0.121564 0.628868 -0.092377 1.005391 0.266805 1.036087 -0.286050 1.835950 0.190028 0.634731 1.031073 0.250385 1.062823 1.900473 0.065255 0.789889 1.186094)
	11.463073 #r(0.000000 0.028171 -0.146165 -0.131228 -0.002871 0.050862 0.742523 -0.204055 1.645617 0.290828 1.406479 0.868199 1.741918 0.453857 0.088300 1.057973 0.604458 0.312110 0.689801 1.760212 -0.475356 1.256266 0.378606 0.694419 0.272116 1.873466 1.520538 1.381650 1.298553 0.700506 1.390078 1.585936 0.052258 0.695189 0.310787 0.176459 0.526361 0.630602 0.358929 0.591920 1.972035 1.304111 1.258732 1.517336 -0.464016 1.113538 -0.482148 1.088302 0.933845 1.295331 0.335606 1.776922 1.275033 1.204638 1.244333 1.391313 0.047180 1.055001 1.066280 0.151122 1.195544 0.996156 0.624574 1.115134 0.474024 -0.291188 1.475027 1.248341 0.247929 1.521222 0.881443 0.964448 0.548203 0.189206 1.035434 1.076866 0.562671 -0.062004 0.950468 1.056851 0.161376 0.895700 1.001831 -0.042194 1.726944 1.884332 0.736198 1.659191 1.569481 1.019363 1.524131 0.771585 1.477099 -0.207180 0.066265 -0.237803 0.271422 1.281028 1.112414 1.108282 0.202944 1.362449 0.127218 0.632811 -0.100436 0.992623 0.244460 1.024970 -0.305227 1.813759 0.191019 0.633237 1.010988 0.236979 1.092657 1.909957 0.072845 0.799668 1.186061)
      )

;;; 120 even --------------------------------------------------------------------------------
(vector 120 15.153992567168 #r(0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)

	11.467293 #r(0.000000 0.182387 0.991318 1.555550 0.388952 1.165472 1.861486 0.514097 1.467680 0.222754 0.972121 1.805786 0.710465 1.475951 0.467146 1.464916 0.222083 1.170792 0.137691 0.926627 1.940353 0.964985 0.072695 1.174272 0.187090 1.145640 0.255557 1.524936 0.697660 1.793860 0.870660 1.991349 1.164698 0.214289 1.427601 0.920631 0.315825 1.506380 0.771158 0.081551 1.397459 0.660219 0.101946 1.376912 0.742252 1.975042 1.384246 0.994395 0.741688 0.116508 1.476904 0.995545 0.574556 -0.050092 1.395747 1.037641 0.654167 0.178367 0.000799 1.661003 1.401198 1.027447 0.549822 0.319024 -0.009775 1.643655 1.451741 1.190761 1.247596 1.019397 0.814792 0.637301 0.619820 0.528955 0.206546 0.210086 1.907606 0.080551 1.852358 0.220977 0.039775 0.240556 0.118697 0.201230 0.183490 0.410415 0.195004 0.346621 0.384871 0.552316 0.919228 0.966578 1.294194 1.669482 1.481782 1.816544 0.045277 0.459121 0.610971 0.884884 1.313099 1.767978 0.251484 0.557317 0.967847 1.457578 1.608185 1.982656 0.491182 1.030233 1.763557 0.343009 0.756305 1.429088 0.071947 0.646318 1.100378 0.016785 0.234469 0.966926)
	11.313532 #r(0.000000 0.104676 0.956023 1.599059 0.434678 1.169528 1.889256 0.640257 1.442051 0.165889 0.976076 1.807981 0.621356 1.475584 0.405972 1.323209 0.236755 1.233785 0.143049 1.033596 -0.026904 0.898062 0.015792 1.074368 0.192320 1.129597 0.306160 1.522081 0.616138 1.751385 0.834142 1.904965 0.997895 0.086818 1.434728 0.883358 0.351550 1.560824 0.820370 0.158445 1.507547 0.792677 0.129947 1.360589 0.737958 0.079098 1.407146 0.914007 0.770470 0.203603 1.502034 1.135858 0.645176 -0.091774 1.390493 1.144809 0.615547 0.243071 -0.050058 1.638797 1.461450 1.127851 0.650628 0.301074 0.089123 1.648239 1.424234 1.260231 1.210544 1.114894 0.875173 0.670427 0.701424 0.535264 0.413558 0.108332 1.989055 -0.068545 1.919263 0.116924 -0.035789 0.276203 0.037296 0.275125 0.137295 0.424822 0.191149 0.279247 0.302996 0.574841 0.813529 0.980002 1.232330 1.725699 1.569712 1.924406 0.069223 0.360022 0.573659 0.933475 1.279691 1.632918 0.255469 0.562101 1.067756 1.530003 1.698816 0.039390 0.454576 1.121018 1.691949 0.294664 0.786095 1.482129 0.154068 0.520585 1.217560 0.096243 0.268392 0.991799)
      )

;;; 121 even --------------------------------------------------------------------------------
(vector 121 14.652157793709 #r(0 0 1 1 0 0 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 1 1 0 0 0 1)

	11.519858 #r(0.000000 0.011378 1.753896 1.437136 0.631135 0.114781 0.660482 1.334498 0.581894 0.089402 1.905979 0.990187 0.248688 0.037998 1.898481 0.142274 0.776484 1.706556 0.191753 0.338054 1.318431 0.126497 0.601712 -0.255350 -0.163162 0.402669 1.476694 -0.235785 0.342102 -0.362582 1.698550 0.968284 0.940716 1.711626 1.326298 1.313163 0.329811 1.359487 0.105165 0.702440 0.022566 -0.069577 1.342187 0.008210 1.716840 0.240520 -0.171785 1.502743 1.676402 1.248370 0.723049 1.865376 0.001307 0.034537 0.684465 1.516715 0.492834 1.116078 0.672438 1.182471 0.641149 0.373795 0.379475 0.145636 0.762178 0.433641 0.347370 0.948832 -0.132296 -0.133379 1.190338 1.266604 1.009701 0.238209 0.752479 1.596905 -0.296398 -0.192578 0.605136 0.075081 1.420344 0.466284 -0.288768 1.297330 1.689017 1.567153 1.185252 0.260951 0.236638 1.431783 0.599599 1.509650 0.653104 0.899471 1.457027 1.068607 0.961380 1.256645 0.033616 -0.139517 0.092125 1.417841 1.213189 1.821992 1.761054 0.238734 0.417918 0.642844 -0.104823 0.081427 0.065359 0.670607 1.054994 1.082441 -0.176585 1.119180 -0.224101 0.108660 -0.203752 0.470242 1.351870)
	11.498650 #r(0.000000 0.017479 1.752861 1.440003 0.624686 0.129479 0.641447 1.341562 0.593468 0.092573 1.905946 0.997125 0.261861 0.048372 1.889251 0.142837 0.765384 1.710687 0.195906 0.342410 1.315796 0.119265 0.608166 -0.244887 -0.154423 0.398137 1.484756 -0.229778 0.353900 -0.366461 1.696566 0.970815 0.945103 1.713230 1.318200 1.305130 0.325861 1.373725 0.105467 0.699102 0.023474 -0.075524 1.335272 0.029557 1.727394 0.232393 -0.164352 1.504070 1.671916 1.239192 0.731760 1.855994 0.001337 0.046623 0.665635 1.502977 0.498905 1.125632 0.665870 1.191192 0.658116 0.375900 0.379214 0.151038 0.768298 0.439539 0.358454 0.950615 -0.144313 -0.136711 1.187031 1.258149 1.034973 0.243678 0.738640 1.590401 -0.293096 -0.203284 0.606420 0.080088 1.430878 0.439253 -0.306828 1.275529 1.691931 1.561946 1.190151 0.261707 0.236268 1.436181 0.601609 1.510865 0.669751 0.888690 1.488607 1.056654 0.978586 1.244435 0.048869 -0.143024 0.092247 1.414882 1.219028 1.818727 1.767970 0.238185 0.423897 0.655297 -0.079893 0.085180 0.061907 0.656438 1.053530 1.078859 -0.174787 1.119475 -0.227903 0.106017 -0.202495 0.468409 1.347654)
      )

;;; 122 even --------------------------------------------------------------------------------
(vector 122 15.057187309653 #r(0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)

	11.608575 #r(0.000000 0.491043 0.007498 0.791398 0.660542 0.960014 1.233279 1.608131 1.227878 1.325414 0.833262 0.826707 1.074054 0.805872 0.453534 0.680408 0.163876 1.857437 1.971814 1.942244 1.528127 1.170281 1.451447 1.612886 0.379280 0.469353 0.748640 0.861019 0.289879 1.554726 0.245277 0.578277 0.944303 0.525039 0.312641 0.462849 0.710444 0.524042 0.736659 1.743905 0.289146 1.405383 1.146345 1.959424 1.266837 0.105168 0.264372 0.716079 0.180416 0.676462 1.349909 0.242201 1.112324 1.903652 0.096097 0.298665 1.938506 0.907637 0.445138 0.676772 1.018566 1.538692 1.890411 1.037889 1.754475 0.454828 0.375080 1.028535 1.584256 0.107387 0.732227 1.941438 0.410085 0.465514 0.392267 1.461968 0.104792 1.428078 0.866762 0.928264 0.963879 0.060101 0.001979 1.538408 1.110694 0.832374 1.363340 1.030944 1.856655 0.680542 1.663245 1.268139 0.925891 1.913766 1.292282 1.484272 0.663172 0.251878 0.695143 1.443461 0.967688 0.177908 1.246199 1.066133 0.923551 1.951433 0.308206 1.532986 1.662559 1.880618 0.612432 0.084712 1.836918 1.410469 0.509104 0.078690 0.955183 1.487132 0.007102 1.473132 0.898543 1.722166)
	11.529673 #r(0.000000 0.531989 0.032244 0.809359 0.643699 0.940233 1.211701 1.640307 1.230816 1.281163 0.890644 0.832673 1.060694 0.784767 0.437632 0.739384 0.159222 1.884203 1.914674 1.955506 1.571876 1.250069 1.476246 1.593357 0.408554 0.425314 0.771861 0.879512 0.289738 1.524282 0.281054 0.607673 0.973892 0.526830 0.325881 0.459829 0.755809 0.530576 0.720264 1.799209 0.280393 1.362171 1.088718 1.980773 1.307845 0.079595 0.230562 0.731677 0.253961 0.706744 1.348348 0.256969 1.089508 1.878912 0.073929 0.290602 1.952316 0.832619 0.413722 0.636491 0.972388 1.527623 1.896001 1.061049 1.746008 0.425430 0.321016 1.095129 1.552982 0.090441 0.747170 1.958559 0.427124 0.466797 0.418100 1.541242 0.046283 1.361223 0.855174 0.943632 1.010409 0.014689 -0.019342 1.505174 1.159416 0.847135 1.349741 0.989026 1.835207 0.712087 1.684724 1.236150 0.856469 1.983000 1.274029 1.431454 0.606044 0.240737 0.706711 1.477845 0.962578 0.131471 1.263708 1.072723 0.899054 1.950074 0.263111 1.509700 1.649975 1.866656 0.559967 0.043385 1.804958 1.384084 0.518887 0.028429 0.971508 1.500748 0.072959 1.501179 0.980256 1.692731)
      )

;;; 123 even --------------------------------------------------------------------------------
(vector 123 15.156582832336 #r(0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 0 1 1 1 0)

	11.636238 #r(0.000000 -0.006745 1.718129 0.124324 0.694087 1.248162 1.264742 -0.205335 0.401180 1.175941 1.275199 0.664232 1.306473 1.775017 0.032088 1.172990 1.182530 1.684652 1.496052 1.018965 1.419875 1.724105 0.881080 0.365436 1.623371 0.118184 1.144470 1.090686 0.455215 1.110091 1.537843 1.409976 0.722528 0.766713 0.291253 1.154526 0.688621 0.079128 0.455767 1.072502 0.449509 1.072583 0.529271 0.933123 1.665962 0.456257 0.965966 0.378656 1.446789 1.599052 -0.405591 0.510787 1.741784 0.047873 1.179439 0.534603 0.738060 1.583394 -0.036662 0.033912 0.990276 0.359185 -0.041714 1.309428 0.206155 0.615264 1.013822 0.916642 1.092385 1.276567 0.943657 1.397941 1.325784 1.841099 0.255550 0.983848 0.698027 0.630229 0.444618 1.485280 0.538087 1.172707 0.510703 0.139282 1.060931 1.974722 0.748366 1.241445 1.282543 1.643915 -0.055670 1.226488 1.259535 1.054944 0.867004 1.180445 0.871590 -0.304557 0.449098 0.105044 0.415180 1.325658 1.915647 1.593801 1.274805 -0.206650 -0.888906 0.385364 0.203928 0.267603 1.679470 1.529346 0.775016 1.650475 0.752800 0.231942 -0.128889 1.695246 -0.352686 0.872132 -0.113288 1.107634 0.969190)
	11.588512 #r(0.000000 0.004875 1.711641 0.140774 0.694092 1.226604 1.265115 -0.232126 0.423381 1.136178 1.270348 0.682996 1.300162 1.791337 0.002717 1.237250 1.220041 1.704800 1.500206 1.020887 1.436449 1.720551 0.899742 0.381519 1.626861 0.127065 1.123427 1.121023 0.433993 1.100929 1.512958 1.385432 0.720403 0.730341 0.295517 1.153332 0.686704 0.085572 0.424177 1.036488 0.470639 1.022538 0.516762 0.951898 1.664193 0.436191 0.950792 0.414108 1.426930 1.592214 -0.395823 0.466806 1.703885 0.079107 1.138873 0.565646 0.730205 1.577236 -0.050693 0.031099 1.032773 0.365734 -0.025372 1.345006 0.200195 0.590510 1.028771 0.941037 1.075449 1.242854 0.949630 1.389801 1.326208 1.907760 0.229976 0.990177 0.702999 0.627311 0.416140 1.460991 0.506869 1.150816 0.534159 0.164078 1.018971 -0.006478 0.769808 1.242997 1.281067 1.607631 -0.072110 1.211385 1.277184 1.052743 0.841699 1.197547 0.833355 -0.346596 0.499473 0.169111 0.418582 1.296369 1.945343 1.611120 1.206903 -0.218771 -0.883336 0.406585 0.188807 0.277040 1.647310 1.538067 0.815727 1.634132 0.720484 0.234373 -0.063759 1.712001 -0.338750 0.844698 -0.161091 1.122039 0.983728)
      )

;;; 124 even --------------------------------------------------------------------------------
(vector 124 15.192802705519 #r(0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 0)

	11.657070 #r(0.000000 -0.014444 0.618588 1.072923 1.770483 0.269156 0.799491 1.415133 0.042486 0.667402 1.107625 1.860582 0.629761 1.228415 0.069647 0.757140 1.477152 0.235584 0.874179 1.620964 0.498598 1.283127 0.032336 0.931298 1.753048 0.690202 1.655180 0.637473 1.388106 0.380043 1.352876 0.417570 1.513619 0.398780 1.331736 0.297986 1.356056 0.723808 1.880303 1.075552 0.270324 1.454538 0.409485 1.419750 0.727467 0.088163 1.085380 0.180158 1.411841 0.476674 0.009315 1.487690 0.712294 -0.024891 1.362496 0.659010 -0.191074 1.370827 0.842745 0.281346 1.600375 1.056928 0.756127 0.303601 1.748097 1.271638 0.793604 0.293922 -0.112046 1.276835 1.265355 0.825565 0.530280 0.127474 1.794406 1.661127 1.499821 1.002415 0.662420 0.351459 0.106647 -0.108853 1.731304 1.778120 1.591760 1.488839 1.111393 1.249609 0.941574 1.119732 0.633391 0.859266 0.602796 0.706230 0.723444 0.862387 0.960018 1.160855 0.914474 1.092081 1.010153 1.292261 1.124565 1.486704 1.752791 1.765950 0.121592 0.301316 0.732598 0.775797 0.931505 1.227451 1.354358 1.806530 0.301686 0.668653 0.912777 1.521847 -0.005389 0.243631 0.695894 1.356048 1.421601 -0.009388)
	11.613572 #r(0.000000 -0.077215 0.641178 1.060103 1.725628 0.306888 0.805842 1.450285 0.080271 0.676079 1.132241 1.857448 0.658171 1.295977 0.051176 0.763104 1.487286 0.227693 0.896976 1.651658 0.503362 1.260680 0.020442 0.960467 1.750723 0.706447 1.647633 0.608155 1.404763 0.411396 1.378386 0.497264 1.537045 0.390954 1.312815 0.244673 1.348183 0.754218 1.873067 1.079854 0.297487 1.463268 0.418762 1.468541 0.755787 0.073685 1.109207 0.169319 1.335623 0.476893 -0.001720 1.492892 0.733144 0.017259 1.410812 0.672365 -0.203035 1.394200 0.880895 0.286488 1.576916 1.026797 0.776208 0.334706 1.764790 1.273553 0.792808 0.273363 -0.126099 1.289140 1.274608 0.822262 0.511006 0.130142 1.781612 1.702529 1.506031 1.031169 0.621717 0.386447 0.078504 -0.139145 1.736386 1.809301 1.574313 1.478345 1.122012 1.243432 0.926704 1.118043 0.660452 0.854324 0.610672 0.712796 0.721629 0.815653 1.007264 1.134982 0.924943 1.132678 1.013992 1.272278 1.166045 1.487404 1.763433 1.755645 0.132866 0.350667 0.743565 0.800556 0.940828 1.208015 1.336563 1.760012 0.309924 0.660774 0.885951 1.465040 -0.071806 0.213365 0.719022 1.340303 1.411523 -0.008348)
      )

;;; 125 even --------------------------------------------------------------------------------
(vector 125 15.340427254326 #r(0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0)

	11.726117 #r(0.000000 -0.030799 0.144449 1.728737 0.676919 0.980768 0.920869 0.523856 0.255848 1.651421 0.139364 0.110259 -0.007857 -0.065476 0.898902 0.948218 0.041888 0.431499 0.955394 1.279597 0.899810 0.236632 1.338434 0.051979 0.022413 1.076247 0.455727 1.395710 0.537276 1.454562 -0.640673 1.646766 0.563227 0.468669 0.349014 0.207631 1.436456 -0.313434 1.039871 1.394849 1.334026 0.410015 0.714625 0.314535 0.295044 0.730112 0.878789 0.469330 0.349941 1.427732 0.501996 1.482747 1.311352 1.023386 -0.133711 0.934640 1.777275 0.139714 0.307620 0.411617 0.680605 1.805628 0.987833 -0.006267 1.325295 0.129226 0.029571 -0.131946 1.571497 0.134896 1.855074 0.957063 1.276873 0.033353 0.738862 1.196621 0.702473 1.212401 0.334974 0.594964 -0.391144 1.491428 1.659733 1.324319 0.593336 1.121378 1.836235 -0.494188 -0.410122 0.669230 1.852484 1.550441 0.612411 1.088978 0.233243 0.429977 0.213254 1.111633 0.529727 1.280152 1.687453 0.208804 0.661537 0.543046 1.373269 -0.302027 0.236049 0.167939 1.751438 0.754446 0.306753 -0.393681 0.981979 0.613716 0.543141 0.783701 1.211717 0.696576 0.743400 0.902651 1.308022 0.648265 1.051117 0.596115 0.465417)
	11.696823 #r(0.000000 -0.085750 0.158005 1.735612 0.685137 0.945836 0.940768 0.518947 0.290366 1.666997 0.139045 0.126203 -0.010830 -0.066052 0.885099 0.937954 0.044708 0.464249 0.929915 1.304222 0.908681 0.209565 1.334067 0.050259 0.057814 1.106583 0.493155 1.406315 0.503058 1.426903 -0.609961 1.642370 0.567715 0.443903 0.372472 0.229085 1.417589 -0.346355 1.038979 1.429340 1.311859 0.366425 0.720813 0.298548 0.333529 0.756555 0.885562 0.416723 0.319844 1.424324 0.513839 1.436280 1.307000 1.020838 -0.126223 0.941415 1.709852 0.135933 0.334813 0.368977 0.672118 1.809440 0.983753 -0.003965 1.265366 0.117324 0.012853 -0.124324 1.605949 0.158672 1.903061 0.984489 1.293097 0.030888 0.683378 1.189519 0.718666 1.266029 0.346022 0.570626 -0.391723 1.498161 1.644708 1.306785 0.578694 1.158328 1.797525 -0.527735 -0.363727 0.648855 1.852302 1.504515 0.619970 1.089044 0.226289 0.384003 0.209403 1.104542 0.537595 1.258766 1.665789 0.231209 0.662211 0.482958 1.347241 -0.340183 0.238825 0.143658 1.745780 0.737818 0.314391 -0.394796 1.010702 0.585559 0.523138 0.790496 1.162076 0.664333 0.775733 0.877231 1.314011 0.663054 1.008894 0.598395 0.431429)
      )

;;; 126 even --------------------------------------------------------------------------------
(vector 126 15.28212621738 #r(0 1 0 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1)

	11.728732 #r(0.000000 0.080423 0.859652 1.251285 0.001006 0.708480 1.329479 1.910986 0.575680 1.212005 1.941153 0.634379 1.324750 0.149467 1.036506 1.708281 0.612012 1.577838 0.338405 1.197595 0.029554 0.897812 1.895059 0.811840 1.778431 0.660286 1.607791 0.800800 1.947497 0.840295 1.874911 0.873100 1.809637 0.999296 0.039834 1.184996 0.352552 1.522062 0.693733 0.018959 1.247028 0.457540 1.699479 1.003229 -0.011631 1.387625 0.675778 1.873479 1.137263 0.739657 0.006673 1.350424 0.946270 0.348539 1.590673 1.018988 0.508851 1.844396 1.236918 0.897127 0.426111 1.973108 1.634669 1.217265 0.734120 0.464551 1.899258 1.421045 1.113676 0.840738 0.386615 0.153879 1.864697 1.811230 1.560296 1.258544 1.008246 0.775514 0.569961 0.379626 0.120794 0.073632 1.824999 1.979635 1.804273 1.934045 1.809824 1.823348 1.667350 1.525160 1.703620 1.223510 1.668539 1.353060 1.680931 1.768624 1.959157 0.014225 0.272244 0.168722 0.385113 0.365860 0.784448 0.739738 0.967615 1.309874 1.705334 0.092760 0.302680 0.844130 0.978941 1.342601 1.583162 1.784704 0.228093 0.608194 1.171628 1.840667 0.207453 0.811900 1.464070 1.557525 0.111382 0.715963 1.219826 1.691486)
	11.703152 #r(0.000000 0.096558 0.858237 1.253318 -0.015046 0.718704 1.348846 1.900141 0.566192 1.208317 1.941379 0.630210 1.308548 0.144213 1.015208 1.707639 0.626405 1.587907 0.354824 1.208059 0.008953 0.884521 1.873194 0.819738 1.783293 0.643406 1.599810 0.796866 1.955770 0.860026 1.884479 0.882399 1.818134 1.010533 0.035693 1.179576 0.329825 1.512427 0.674447 0.023525 1.226679 0.448543 1.685164 0.973203 -0.048933 1.379465 0.672254 1.854706 1.136118 0.729702 -0.026031 1.325925 0.964455 0.342495 1.575265 1.011689 0.505283 1.830974 1.220292 0.905128 0.429702 1.955910 1.643840 1.228384 0.736382 0.444010 1.912379 1.426082 1.115112 0.833472 0.391194 0.150101 1.880095 1.833447 1.569604 1.250709 1.013961 0.775242 0.571573 0.416334 0.125474 0.075273 1.824141 1.986914 1.815271 1.931859 1.836071 1.823625 1.665372 1.543210 1.698633 1.228598 1.673505 1.361896 1.687203 1.790599 1.955483 0.031563 0.256585 0.174165 0.370849 0.358074 0.779148 0.726705 0.965589 1.287288 1.714926 0.099738 0.323073 0.843752 0.970655 1.331421 1.560527 1.778487 0.212367 0.598792 1.166691 1.836224 0.212608 0.794199 1.448179 1.527740 0.079660 0.725629 1.206239 1.660826)
      )

;;; 127 even --------------------------------------------------------------------------------
(vector 127 15.237931718393 #r(0 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0)

	11.791982 #r(0.000000 -0.006501 0.895946 0.390502 1.267039 0.777220 0.845244 1.619366 1.738905 1.963883 0.834239 -0.095420 1.729892 0.328487 0.839467 -0.107042 0.077371 1.006289 0.934388 1.316468 0.399445 1.446071 0.867321 0.749721 0.310809 0.608045 0.928981 0.860186 0.132975 0.107680 0.035103 0.310673 1.698683 1.209244 1.219344 1.008158 0.868768 0.774429 0.524607 1.259150 0.968654 0.225551 0.670254 0.584349 1.206486 0.849939 0.881353 1.316256 1.223028 -0.051550 1.266841 0.533270 0.307133 0.871408 0.135067 0.350791 1.392175 1.398704 1.054665 1.094835 0.720758 1.235433 1.111126 1.315441 0.540735 1.759697 1.421149 1.220945 1.416174 0.271820 0.476065 0.346906 0.599580 1.865670 -0.010232 0.873428 0.191144 -0.138143 0.473276 0.793750 0.140345 0.466125 0.753788 0.166751 0.509961 1.311817 1.848999 0.485052 0.151803 1.266182 1.022497 -0.055512 1.662000 1.747291 0.161074 0.983665 1.511467 0.958919 1.602506 1.536897 -0.682895 0.108054 0.153831 0.495344 -0.168193 1.039701 1.035352 0.840794 0.198694 1.029171 0.222780 1.379441 0.220019 1.296462 0.080553 0.616328 1.212980 -0.006268 1.810129 0.820776 0.816381 1.107475 0.666818 -0.087937 0.128508 1.246653 0.713705)
	11.789979 #r(0.000000 -0.001132 0.897517 0.394382 1.260286 0.778304 0.836616 1.625461 1.739876 1.973405 0.832561 -0.094515 1.731739 0.333639 0.836968 -0.107876 0.070482 1.012477 0.940091 1.307348 0.393707 1.442720 0.861719 0.744806 0.312510 0.611089 0.927754 0.853317 0.134994 0.107430 0.037825 0.312394 1.700751 1.213044 1.226487 1.011854 0.861083 0.772034 0.520630 1.253292 0.972555 0.220816 0.667221 0.579331 1.207076 0.848173 0.881872 1.323012 1.222919 -0.052129 1.260636 0.538181 0.300938 0.871330 0.135056 0.343171 1.400686 1.405366 1.050179 1.096651 0.719543 1.228509 1.109861 1.313762 0.542329 1.766261 1.421361 1.230519 1.420958 0.268636 0.479183 0.342346 0.595355 1.855218 -0.019779 0.874866 0.185594 -0.136341 0.472427 0.790967 0.143693 0.462337 0.746424 0.172494 0.510100 1.302826 1.846530 0.481197 0.145292 1.261219 1.016223 -0.050720 1.664990 1.749224 0.161564 0.976204 1.514784 0.954951 1.610573 1.531118 -0.672953 0.098304 0.152113 0.497593 -0.167125 1.036222 1.044964 0.844274 0.193598 1.029973 0.233918 1.378605 0.220451 1.286808 0.078131 0.610438 1.205447 -0.007484 1.810339 0.820177 0.824174 1.112769 0.665708 -0.080601 0.134336 1.244008 0.715267)
      )

;;; 128 even --------------------------------------------------------------------------------
(vector 128 15.651492555885 #r(0 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0)

	11.855311 #r(0.000000 0.002954 1.086498 1.244708 0.303059 1.259751 0.309362 1.790916 0.248895 1.162193 1.314225 0.079985 1.834875 1.698159 1.370884 1.061591 -0.405592 -0.007226 1.415554 0.291472 1.616511 1.201031 1.724790 1.253920 0.381007 0.342864 0.129931 0.302334 -0.166886 0.040095 1.246486 0.230946 0.369951 0.214007 1.131361 0.213336 1.629333 0.734004 -0.271832 0.632327 1.004669 0.077953 0.729010 1.810693 1.420215 0.630309 0.700436 0.258567 1.628605 0.905586 1.142265 1.152326 0.326100 0.774940 1.890046 0.949029 1.868832 0.198910 0.434455 0.456405 1.398232 1.234171 1.184276 0.214987 0.193919 1.966273 0.843555 1.673855 -0.209700 -0.268011 0.949312 0.413392 1.382861 0.178390 0.571474 0.487109 0.423929 0.039033 -0.034545 0.870551 -0.120684 0.116249 1.774235 1.707680 -0.047053 0.113885 0.286561 0.199524 1.084037 1.096961 1.211384 1.152747 1.410823 -0.217304 0.227497 0.871674 1.589823 1.733427 1.481818 1.243310 0.262436 -0.018186 1.415352 0.786188 0.083970 1.335483 0.643231 1.707508 0.337299 0.567129 1.109274 1.685444 0.517101 1.030998 1.341062 1.313109 1.648731 0.561739 0.479232 -0.033647 0.047901 0.115737 1.542601 0.315780 1.289558 1.424186 0.245639 1.518252)
	11.830152 #r(0.000000 0.006782 1.060624 1.211296 0.293074 1.273318 0.314512 1.826803 0.239201 1.156802 1.298198 0.077804 1.822347 1.682910 1.385524 1.038512 -0.396824 0.008830 1.443050 0.294818 1.610271 1.195727 1.747067 1.264125 0.380208 0.325636 0.108242 0.283890 -0.191659 0.067237 1.290037 0.217524 0.336243 0.213550 1.141382 0.223281 1.623265 0.741878 -0.249759 0.604458 1.040995 0.068971 0.721985 1.834529 1.429615 0.606681 0.670356 0.241565 1.624232 0.893260 1.150356 1.152656 0.346887 0.798654 1.851338 0.951081 1.875604 0.202415 0.414236 0.457570 1.375118 1.252622 1.176332 0.207988 0.196677 1.941237 0.863363 1.619621 -0.226038 -0.283982 0.962795 0.411171 1.411590 0.197410 0.563329 0.468261 0.398533 0.069544 -0.014006 0.870262 -0.106509 0.116268 1.812259 1.697896 -0.060401 0.066686 0.279835 0.231452 1.082447 1.099824 1.175787 1.117046 1.447844 -0.230882 0.230008 0.906488 1.601754 1.772871 1.477415 1.267041 0.261730 -0.040738 1.416845 0.809274 0.114237 1.322977 0.639146 1.726468 0.362841 0.604035 1.100292 1.726907 0.530237 1.036102 1.333246 1.293644 1.618742 0.555320 0.472298 -0.036953 0.020660 0.061453 1.538933 0.319946 1.305954 1.451303 0.269500 1.531977)
      )

;;; 256 even --------------------------------------------------------------------------------
(vector 256 24.434719362486 #r(0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1)

	16.895858 #r(0.000000 -0.009189 0.902358 0.365887 -0.111323 -0.780998 -0.023618 -0.522343 0.279380 0.055265 -0.008058 0.474170 0.130008 0.951121 -0.734333 0.844285 0.824339 -0.107239 0.507621 0.164958 -0.496056 -0.789687 0.259333 -0.449818 0.843661 -0.030179 -0.474099 0.774618 -0.182868 0.024412 0.577418 -0.074812 -0.020675 0.192634 -0.599606 -0.070169 -0.948055 -0.992660 0.778395 -0.043578 -0.432579 -0.186685 -0.510874 -0.014069 -0.480270 0.346549 0.508024 0.846868 -0.259984 -0.239547 -0.834355 0.758428 0.757435 0.373609 -0.602450 0.574091 0.372351 0.871018 -1.004894 0.279914 0.796533 0.315579 -0.170724 -0.162430 -0.867211 -0.645076 0.714848 -0.271719 0.114112 0.067143 0.832100 -0.116990 -0.262191 -0.281235 -0.535795 0.830911 -0.182047 0.489779 0.867411 0.246384 -0.008329 -0.604672 0.770953 -0.982833 0.931441 -0.618590 -0.552932 0.209497 -0.183212 0.365740 0.769646 0.703588 -0.289040 -0.817528 -0.369365 0.293481 0.472048 0.790519 -0.426911 0.891352 -0.538143 -0.944128 -0.920976 0.221321 -0.509927 -0.348596 -0.644560 -0.213342 -0.745624 -0.706666 0.930922 -0.848273 -0.242448 -0.036301 0.898791 -0.590640 0.780449 -0.061417 0.458673 -0.691004 -0.831524 0.551686 0.225320 0.474068 0.953196 -0.781398 0.825342 0.760168 0.391595 0.124100 0.860713 -0.055973 0.585971 -0.869796 1.059960 -0.289476 -0.119142 0.020537 -0.912617 0.156202 0.608148 0.008605 -0.492103 -0.103742 0.428971 0.411193 -0.565692 0.935156 -0.112585 0.617223 -0.155032 0.327195 0.230999 -0.493871 -0.157653 0.741876 0.652071 0.725265 -0.509926 -0.435321 0.803678 0.422316 0.647203 -0.330251 -0.717114 -0.003821 -0.171433 0.905326 -0.870296 -0.075782 -0.123811 -0.827857 0.305695 -0.297883 0.361037 0.368875 0.307670 -0.861180 0.111296 0.743619 -0.505788 0.890369 -0.751559 0.768455 0.001867 -0.755119 0.593706 0.249715 0.003021 0.017365 -0.006817 0.077961 0.209405 -0.908703 -0.016914 0.016411 -0.745949 -0.862316 0.805206 -0.373876 -0.644818 0.552974 -0.723400 0.564147 0.221354 0.241461 -0.891285 0.457125 0.981689 -0.591672 -0.034527 -0.765054 -0.120687 0.438528 0.848881 -0.507062 0.069395 0.639313 -0.825275 0.641684 -0.188946 0.565634 -0.791635 -0.287596 -0.132874 -0.202513 0.559214 0.080018 0.796540 0.338441 0.210736 0.641999 0.009248 0.322360 -0.028925 0.697480 0.479428 0.122723 0.885702 -0.174527 0.157389 0.019802 0.207762 -0.007817 -0.188184 0.284891 0.769384 -0.699713 -0.860470 0.816560 0.661637 0.821235 0.090760 0.680062 0.906877 -0.017234)
      )

;;; 512 even --------------------------------------------------------------------------------
(vector 512 35.776 #r(0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1)

      ;; from (try-all :even 512 513 0.0057725498034576  0.26769012113045) = 29.0733
	24.510365 #r(0.000000 -0.019547 0.424156 1.640830 1.364680 1.818776 1.105842 0.737080 1.188869 0.460419 0.154877 0.614397 1.827954 1.526781 0.018169 1.203682 0.956144 1.444331 0.584264 0.344508 0.856804 -0.002275 1.790988 0.291010 1.439116 1.211881 1.741084 0.845603 0.707294 1.180635 0.339890 0.164786 0.645301 1.820612 1.656940 0.157290 1.307936 1.130965 1.686613 0.833679 0.620052 1.209627 0.322209 0.138398 0.734419 1.838268 1.653494 0.235420 1.341020 1.194471 1.729004 0.905361 0.771623 1.262727 0.487832 0.366383 0.843119 0.069579 1.963835 0.460118 1.649699 1.520680 0.055018 1.185740 1.101098 1.643899 0.752530 0.667948 1.169078 0.382792 0.269771 0.820501 0.061364 1.929744 0.493658 1.740499 1.549752 0.138458 1.334798 1.217842 1.724754 0.932476 0.823652 1.326258 0.605394 0.510375 1.024728 0.340933 0.185795 0.774497 0.036705 1.862931 0.456043 1.668642 1.590302 0.139925 1.318436 1.326961 1.864132 1.011509 1.051965 1.624689 0.808072 0.775618 1.339118 0.606082 0.484361 1.076072 0.379297 0.250899 0.852275 0.110682 0.007792 0.595200 1.830378 1.789905 0.359788 1.659536 1.611286 0.154864 1.497402 1.399711 1.998779 1.270070 1.199870 1.801564 1.085483 1.010139 1.613933 0.921049 0.862702 1.434888 0.750644 0.728545 1.284532 0.570978 0.570652 1.118882 0.422457 0.414420 0.977086 0.320768 0.330042 0.881914 0.218609 0.199085 0.805391 0.088964 0.043485 0.695205 -0.000491 1.966513 0.612316 1.930538 1.950727 0.563038 1.854742 1.879285 0.451929 1.795108 1.794421 0.370361 1.783471 1.745602 0.399279 1.738776 1.661161 0.350902 1.625174 1.614568 0.302843 1.577093 1.678861 0.313770 1.663823 1.660571 0.328157 1.709209 1.610846 0.310206 1.720381 1.669108 0.335355 1.656296 1.693491 0.346281 1.654195 1.699773 0.373651 1.773772 1.752470 0.473140 1.826907 1.822715 0.581620 1.832675 1.919552 0.622630 1.929526 0.005176 0.677897 0.085092 0.090877 0.761048 0.206124 0.205634 0.890197 0.304835 0.339949 1.002646 0.395940 0.448746 1.152273 0.561345 0.581101 1.310704 0.737714 0.744961 1.486545 0.848210 0.931544 1.627529 1.007712 1.110684 1.778206 1.199087 1.278685 -0.040639 1.383705 1.405450 0.148513 1.511196 1.633778 0.391073 1.740722 1.849679 0.658438 0.031218 0.137149 0.870371 0.331222 0.296051 1.070588 0.528400 0.591834 1.345092 0.751955 0.829846 1.642139 1.030239 1.201544 1.943718 1.298486 1.407002 0.143893 1.607481 1.695116 0.415675 1.905744 -0.027620 0.742513 0.206291 0.320377 1.123679 0.506496 0.647078 1.425059 0.880594 0.962991 1.736110 1.225483 1.369479 0.064842 1.600531 1.706861 0.517054 1.973656 0.069623 0.837048 0.295925 0.404900 1.263222 0.684812 0.775618 1.577141 1.057937 1.264522 0.064638 1.531997 1.682245 0.471443 1.922985 0.104388 0.897292 0.423113 0.526550 1.412335 0.758158 0.917306 1.736464 1.285171 1.451805 0.278569 1.745150 1.879876 0.677038 0.183709 0.366812 1.118883 0.736257 0.864386 1.688806 1.159516 1.253423 0.100375 1.645658 1.871576 0.762011 0.249411 0.395560 1.273133 0.699592 0.948774 1.805372 1.338330 1.530595 0.294092 1.900787 0.034538 0.923012 0.390364 0.586314 1.386265 1.030145 1.202559 0.071001 1.609371 1.743831 0.671235 0.194183 0.391537 1.251984 0.751826 1.009573 1.860932 1.448367 1.525073 0.422286 -0.073409 0.262981 1.099563 0.626545 0.818453 1.723102 1.361444 1.531582 0.390953 1.909101 0.215438 1.139977 0.737652 0.881882 1.821234 1.380301 1.618894 0.473317 0.045322 0.250969 1.146414 0.800355 0.959156 1.857842 1.429019 1.673847 0.622261 0.184525 0.502145 1.323715 0.914639 1.172552 0.096636 1.761155 1.977345 0.871966 0.396190 0.668483 1.677724 1.221155 1.466337 0.368967 0.009966 0.302335 1.180746 0.786475 1.025502 -0.022711 1.584463 1.830638 0.746555 0.413840 0.650268 1.656745 1.224810 1.557055 0.513491 0.173029 0.435007 1.290629 0.926051 1.263115 0.272344 1.896521 0.084566 1.048863 0.725520 0.987362 -0.027617 1.571108 1.900984 0.869809 0.386916 0.758635 1.730437 1.409025 1.672233 0.588812 0.243929 0.511763 1.494695 1.169935 1.437757 0.431437 0.111507 0.458811 1.437247 1.136523 1.434884 0.401589 0.040030 0.372128 1.370962 0.999488 1.378913 0.377301 -0.009324 0.355264 1.331258 1.008855 1.339035 0.373593 0.044480 0.312196 1.329497 1.000220 1.342701 0.417261 0.083063 0.411303 1.346062 1.090657 1.409862 0.373501 0.211768 0.447452 1.458597 1.131955 1.458774 0.553807 0.205989 0.569249 1.645656 1.188483 1.668112 0.674809 0.371651 0.732131 1.751447 1.522458 1.904784 0.884407 0.617430 0.990830 0.073047 1.730004 0.133217 1.189522 0.869836 1.203019 0.328634 0.051596 0.424552 1.471161 1.210755 1.549745 0.605989 0.343260 0.768857 1.816839 1.581320 1.934635 1.014299 0.737558 1.116115 0.236955 0.018173 0.380416 1.539634 1.251595 1.652099 0.829587 0.536746 0.936033)
      )

;;; 1024 even --------------------------------------------------------------------------------
(vector 1024 51.895 #r(0 1 0 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 0 1 1 1 0 1 0 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0)

	34.486667 #r(0.000000 0.010065 0.257552 0.593803 0.986349 1.354691 1.689002 0.065945 0.448419 0.795563 1.178916 1.585370 1.936149 0.310262 0.750710 1.056729 1.463725 1.825064 0.240816 0.539819 0.934214 1.340840 1.748800 0.092213 0.555713 0.915825 1.311840 1.650847 0.107697 0.477455 0.875194 1.288435 1.748432 0.197793 0.591516 1.015839 1.387092 1.854496 0.260210 0.614591 1.088807 1.497165 1.960609 0.347241 0.837150 1.265241 1.711792 0.103196 0.588662 1.043276 1.427385 1.898809 0.315073 0.790510 1.283232 1.726769 0.124226 0.582532 1.048754 1.444755 1.928781 0.425680 0.899080 1.335881 1.855991 0.327701 0.850115 1.267294 1.746464 0.254433 0.681023 1.221402 1.713475 0.176608 0.633457 1.170011 1.638469 0.136940 0.628672 1.079274 1.611588 0.107068 0.579047 1.125534 1.649825 0.159484 0.714499 1.195717 1.694762 0.283005 0.777095 1.317639 1.818676 0.294685 0.848021 1.366508 1.912960 0.442114 0.974399 1.491097 0.046085 0.607725 1.172318 1.701676 0.262890 0.804042 1.333049 1.847711 0.428372 0.986686 1.556422 0.120990 0.632701 1.249707 1.826221 0.398395 0.969062 1.507301 0.132868 0.725711 1.273823 1.851630 0.403540 1.046615 1.591703 0.182065 0.801530 1.386897 0.003430 0.562296 1.182148 1.798000 0.384640 0.992083 1.618128 0.211791 0.774713 1.389562 -0.001657 0.608366 1.236020 1.865011 0.529780 1.135532 1.738754 0.419570 1.019563 1.624992 0.265061 0.904049 1.533452 0.168181 0.865137 1.479101 0.127557 0.777817 1.390745 0.031342 0.661481 1.347873 -0.028252 0.673301 1.341813 0.012139 0.723533 1.359095 0.015081 0.667348 1.354810 -0.010820 0.651242 1.361901 0.014799 0.676361 1.414902 0.077676 0.777314 1.483046 0.156058 0.835487 1.534362 0.214249 0.944327 1.656367 0.337182 1.061518 1.736952 0.487837 1.221677 1.941805 0.641987 1.334519 0.012624 0.761615 1.493616 0.235055 0.987696 1.681644 0.449481 1.152512 1.880553 0.557489 1.300096 0.093548 0.829304 1.606739 0.333558 1.038662 1.817653 0.564596 1.346595 0.088231 0.789038 1.556219 0.364445 1.109277 1.894547 0.648472 1.394876 0.167696 0.927734 1.744135 0.473122 1.327580 0.053170 0.846408 1.630482 0.424396 1.252576 0.026366 0.794678 1.571738 0.353780 1.148629 -0.009061 0.802059 1.560730 0.388025 1.189760 -0.020908 0.838019 1.634252 0.450483 1.274303 0.061988 0.909080 1.739029 0.567344 1.395698 0.191004 1.056594 1.900321 0.701479 1.570664 0.420443 1.216101 0.035038 0.906051 1.794894 0.619739 1.485033 0.319328 1.177367 0.049998 0.912455 1.796694 0.663275 1.464877 0.322458 1.201076 0.079874 0.975135 1.812753 0.671629 1.550884 0.438265 1.308416 0.227568 1.107771 0.008272 0.852340 1.757258 0.665419 1.573359 0.450697 1.364674 0.288498 1.149330 0.046861 0.927672 1.818815 0.731499 1.703383 0.640630 1.515945 0.404842 1.338883 0.309581 1.223075 0.140786 1.078108 -0.017158 0.933921 1.856585 0.819946 1.718757 0.674573 1.629213 0.552624 1.480565 0.473092 1.440553 0.370780 1.316286 0.261652 1.233065 0.181284 1.136614 0.128844 1.063581 0.043473 0.988622 -0.007730 0.942926 1.896166 0.930670 1.890388 0.822783 1.839642 0.888701 1.829032 0.748117 1.787911 0.785711 1.793168 0.753464 1.768597 0.785917 1.789379 0.746424 1.769933 0.789526 1.789893 0.806228 1.806824 0.845014 1.858918 0.876599 1.887462 0.916183 -0.011424 0.947836 0.026544 1.052806 0.074297 1.092552 0.117837 1.145621 0.172062 1.271069 0.265950 1.343262 0.368273 1.426940 0.471985 1.600258 0.591440 1.643063 0.779963 1.778002 0.823172 1.887460 0.980164 0.056312 1.104881 0.194563 1.270671 0.317598 1.432357 0.527173 1.586831 0.679001 1.710986 0.856576 1.952932 1.034214 0.168860 1.247239 0.332452 1.455153 0.496571 1.598578 0.746454 1.841506 0.980194 0.065850 1.191729 0.313463 1.362280 0.540259 1.674133 0.807281 1.901298 1.046989 0.152754 1.296905 0.437367 1.599457 0.712142 1.832022 1.021052 0.159471 1.255226 0.399699 1.567354 0.776219 1.903366 1.055241 0.221691 1.359842 0.508090 1.682588 0.830923 0.010406 1.164777 0.321654 1.495630 0.648746 1.854778 1.028798 0.224012 1.437178 0.587301 1.746745 0.969426 0.124185 1.311647 0.558251 1.730677 0.926291 0.114111 1.341596 0.557527 1.745728 0.936491 0.127337 1.383134 0.617625 1.786691 1.023246 0.229459 1.472437 0.676585 1.907197 1.123237 0.355057 1.633938 0.880784 0.058692 1.279872 0.552335 1.779394 1.011586 0.276736 1.508029 0.759625 0.024536 1.276380 0.493761 1.728419 1.013811 0.266997 1.523472 0.795713 0.046243 1.307283 0.623236 1.877970 1.148383 0.427672 1.683629 1.001954 0.298274 1.554589 0.835462 0.173731 1.457407 0.693880 -0.034472 1.275602 0.593467 1.866633 1.210093 0.521728 1.772084 1.113712 0.385701 1.695457 1.069859 0.333163 1.607126 0.969652 0.282736 1.586932 0.934788 0.272131 1.571926 0.921386 0.293345 1.575513 0.936770 0.269737 1.574193 0.968165 0.284669 1.613899 0.986360 0.310459 1.654676 0.993511 0.432366 1.747611 1.058842 0.426357 1.800267 1.182611 0.576028 1.923944 1.270340 0.656610 0.044384 1.408707 0.752047 0.170780 1.558617 0.971026 0.315606 1.679451 1.091283 0.469917 1.819954 1.288114 0.668750 0.054741 1.461129 0.888977 0.275646 1.712213 1.100500 0.539170 1.932708 1.357198 0.750588 0.169930 1.599158 1.015737 0.433884 1.847466 1.290316 0.699471 0.106715 1.618980 1.039270 0.483584 1.877301 1.355281 0.739383 0.283415 1.680260 1.142458 0.582946 0.025158 1.503785 0.917235 0.402386 1.888910 1.374775 0.801742 0.267251 1.729725 1.190453 0.690588 0.170200 1.607615 1.116870 0.626944 0.099949 1.558114 1.042989 0.565792 0.001984 1.534796 0.981050 0.506989 0.024697 1.512493 1.045167 0.509838 0.035449 1.540981 1.040413 0.579777 0.067009 1.583544 1.092800 0.643044 0.165297 1.660919 1.190925 0.750261 0.244662 1.789497 1.303951 0.852702 0.402882 1.925637 1.511267 0.983904 0.525287 0.093612 1.625678 1.236625 0.751894 0.317275 1.862598 1.434730 1.003450 0.590395 0.130259 1.632064 1.251831 0.793529 0.395744 1.982905 1.518992 1.185899 0.724078 0.280841 1.851085 1.414649 1.036031 0.628024 0.190307 1.817967 1.407380 0.997638 0.626750 0.187117 1.827944 1.364014 1.005368 0.643575 0.271950 1.870132 1.455625 1.102716 0.663688 0.366474 1.947786 1.531948 1.165389 0.820292 0.417060 0.106203 1.736409 1.349795 1.017056 0.602019 0.247808 1.904232 1.522798 1.168173 0.822339 0.502122 0.190982 1.830461 1.503095 1.146005 0.824132 0.425448 0.163732 1.809535 1.439358 1.134762 0.787451 0.444950 0.125696 1.859821 1.507864 1.225427 0.898766 0.552383 0.249459 1.921771 1.641843 1.335828 1.036153 0.712405 0.407286 0.113814 1.810275 1.573082 1.216807 0.937380 0.622140 0.413886 0.065441 1.811766 1.479615 1.239853 0.962208 0.676221 0.428567 0.149787 1.861526 1.595913 1.378366 1.072254 0.858051 0.546952 0.352387 0.048977 1.781409 1.500802 1.320643 1.034780 0.814060 0.561026 0.270289 0.105077 1.781981 1.587128 1.356228 1.096895 0.899561 0.695426 0.422635 0.191053 0.015040 1.742763 1.540766 1.372440 1.135422 0.929280 0.712972 0.501615 0.300048 0.059338 1.847659 1.743466 1.446302 1.288333 1.097146 0.896394 0.693469 0.504749 0.273709 0.134422 -0.008122 1.752436 1.590209 1.416861 1.263443 1.015309 0.919786 0.724562 0.550733 0.413427 0.220154 0.085059 1.972253 1.758570 1.618664 1.418349 1.309492 1.092633 0.962125 0.822521 0.683138 0.548516 0.433745 0.271343 0.157018 -0.024488 1.878961 1.706051 1.633364 1.472286 1.423267 1.197350 1.130839 0.991815 0.864748 0.717411 0.656940 0.500335 0.378398 0.306249 0.174522 0.042370 1.957239 1.876551 1.787343 1.657177 1.630866 1.501218 1.454476 1.399481 1.281728 1.174679 1.094880 1.013897 0.872646 0.836534 0.733703 0.745572 0.645048 0.520901 0.517442 0.446338 0.403105 0.220915 0.272964 0.177893 0.121891 0.010365 -0.003026 -0.000541 1.946558 1.858421 1.798242 1.770282 1.765566 1.731024 1.646864 1.612063 1.606047 1.594080 1.512626 1.534901 1.459982 1.452555 1.426312 1.441887 1.450640 1.394928 1.401770 1.413824 1.398282 1.361199 1.386696 1.351788 1.315050 1.337782 1.369731 1.375462 1.382434 1.387327 1.390480 1.425063 1.472649 1.428947 1.444989 1.479959 1.454545 1.459856 1.514843 1.537769 1.564144 1.568551 1.669900 1.683717 1.723822 1.813102 1.823001 1.907890 1.890197 1.964939 -1.797036 0.049327 0.116611 0.169727 0.229816 0.312230 0.322585 0.436099 0.459978 0.494355 0.617621 0.657990 0.713966 0.784856 0.873687 0.939607 1.031179 1.056185 1.173421 1.311953 1.410978 1.454966 1.612093 1.676857 1.761378 1.862190 1.974384 0.042558 0.158632 0.245595 0.350975 0.483237 0.594289 0.729058 0.805700 0.959748 1.072984 1.213228 1.313277 1.445492 1.585944 1.673320 1.810642 1.960761 0.110169 0.205253 0.318753 0.449203 0.638254 0.764806 0.903920 1.064434 1.168013 1.366785 1.485581 1.644159 1.803584 -0.028237 0.153100 0.380114 0.509401 0.641451 0.849001 1.016399 1.215481 1.423241 1.573069 1.764733 1.942264 0.047242 0.295850 0.470228 0.640443 0.830347 1.055180 1.227983 1.357851 1.599606 1.739714 -0.029549 0.205220 0.379610 0.585030 0.816103 1.019847 1.251050 1.461935 1.647821 1.868576 0.147180 0.369132 0.579279 0.840715 1.094368 1.320093 1.565710 1.787983 -1.714361 0.195527 0.507750 0.710357 0.949912 1.153061 1.372724 1.700420 1.865502 0.178913 0.436041 0.694461 0.986729 1.187621 1.476665 1.752454 0.027539 0.321199 0.550142 0.802831 1.077337 1.362471 1.620159 1.900867 0.213014 0.446588 0.803703 1.113716 1.403572 1.697697 0.018021 0.315688 0.615559 0.932639 1.205074 1.541734 1.854009 0.125499 0.502519 0.744264 1.071360 1.395926 1.658298 -0.006671 0.333250 0.704886 1.026706 1.348527 1.693526)
       )

;;; 2048 even --------------------------------------------------------------------------------
(vector 2048 87.471149563312 #r(0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 1 1)

       ;; (try-all :even 2048 2049  0.0014328746687631 0.51217918249646) = 56.93601 start for next
	50.887273 #r(0.000000 -0.001703 0.433172 1.590778 1.336810 1.796101 0.945990 0.630649 1.068973 0.276030 0.019619 0.418921 1.642205 1.314880 1.815562 0.937954 0.690335 1.166456 0.260174 0.033467 0.534551 1.577952 1.359691 1.855935 0.978115 0.778145 1.214744 0.305514 0.073250 0.585950 1.700979 1.456846 1.891326 1.051448 0.870291 1.262779 0.419868 0.209104 0.667538 1.764244 1.534253 0.022691 1.157333 0.886455 1.397513 0.522770 0.305417 0.791572 1.882641 1.706581 0.124613 1.245754 1.016938 1.507704 0.621789 0.423116 0.882723 0.034318 1.775279 0.266045 1.420137 1.176158 1.620182 0.842558 0.553079 1.037944 0.182615 0.005162 0.432646 1.577593 1.375077 1.777427 0.999839 0.726166 1.218120 0.366911 0.123723 0.662290 1.808464 1.555557 0.050943 1.161441 0.961088 1.469391 0.581778 0.421014 0.869182 1.964711 1.782785 0.217679 1.412311 1.228590 1.681851 0.818320 0.617489 1.120821 0.226824 0.041870 0.539030 1.644423 1.496409 1.937912 1.088438 0.861771 1.374952 0.504902 0.301816 0.831900 1.946273 1.700988 0.237333 1.351841 1.174113 1.697709 0.766188 0.601502 1.097799 0.223664 0.073707 0.490731 1.705779 1.529713 0.004900 1.114151 0.927806 1.413217 0.593263 0.370397 0.876728 0.024219 1.840075 0.345172 1.498140 1.311278 1.774455 0.911735 0.779474 1.231046 0.351370 0.170176 0.732535 1.828332 1.647912 0.151754 1.304922 1.134715 1.583698 0.773654 0.612595 1.042987 0.199634 0.036653 0.549756 1.681847 1.475587 0.005194 1.173802 0.977842 1.470305 0.643755 0.476622 0.917721 0.111850 1.936419 0.450243 1.616355 1.416777 1.915014 1.098462 0.907664 1.447783 0.570918 0.405291 0.889269 0.066991 1.881365 0.373330 1.508358 1.402579 1.870612 1.085131 0.920739 1.348392 0.568783 0.336415 0.843225 0.063446 1.926774 0.418106 1.565445 1.379520 1.897103 1.050320 0.891564 1.380927 0.530987 0.385626 0.908446 0.068664 1.943935 0.430612 1.518729 1.398232 1.924184 1.103625 0.924587 1.417433 0.610522 0.456479 0.953409 0.112059 0.013043 0.495872 1.633744 1.493163 0.038519 1.187544 1.048687 1.588579 0.748576 0.532785 1.100237 0.281535 0.104911 0.635452 1.811612 1.634030 0.184177 1.345558 1.153862 1.750039 0.857060 0.732788 1.250092 0.418042 0.246015 0.725057 1.972355 1.807991 0.351695 1.540788 1.347415 1.848165 1.067747 0.908528 1.413312 0.618180 0.467879 0.991799 0.190738 0.053795 0.507730 1.744900 1.620134 0.124619 1.318661 1.152397 1.685590 0.894836 0.688791 1.239521 0.488835 0.282246 0.831794 -0.015794 1.883123 0.431031 1.583860 1.447618 1.964025 1.125655 1.064343 1.569856 0.748855 0.603708 1.107653 0.309052 0.196774 0.696407 1.871049 1.742283 0.240318 1.473905 1.321207 1.881514 1.047815 0.924156 1.493868 0.689863 0.543896 1.026203 0.246976 0.140944 0.678125 1.870899 1.706720 0.276250 1.408196 1.319078 1.889412 1.061123 0.937583 1.451370 0.684034 0.567548 1.075578 0.293854 0.180105 0.705838 1.911360 1.764817 0.292975 1.493988 1.411105 1.895989 1.081687 1.012629 1.575334 0.718344 0.628406 1.174951 0.386415 0.230260 0.768066 -0.015753 1.886981 0.454216 1.616098 1.441778 0.077596 1.316514 1.144927 1.696140 0.867400 0.757625 1.309429 0.563210 0.364175 0.954929 0.137349 0.057751 0.597415 1.789122 1.677288 0.252684 1.417924 1.313555 1.862237 1.126315 1.015807 1.510443 0.802206 0.652057 1.184565 0.404523 0.277585 0.843687 0.148971 1.933489 0.514414 1.743011 1.592866 0.129290 1.346399 1.259419 1.817805 1.029171 0.962338 1.475532 0.708188 0.633076 1.151811 0.395581 0.307725 0.834201 0.078405 1.959228 0.466843 1.769721 1.650538 0.159441 1.402559 1.321215 1.914285 1.128095 1.014297 1.571134 0.803693 0.677208 1.246457 0.469701 0.356795 0.908733 0.149102 0.035900 0.615966 1.826481 1.708851 0.339243 1.554134 1.413247 -0.028956 1.251019 1.106816 1.704569 0.926586 0.827768 1.430366 0.655894 0.524343 1.153832 0.363573 0.234391 0.825975 0.037037 1.955590 0.487803 1.776970 1.679179 0.270247 1.494959 1.379330 1.956206 1.186819 1.071982 1.644518 0.897716 0.759160 1.349574 0.601679 0.512657 1.067152 0.367997 0.259056 0.818805 0.070970 1.979460 0.551129 1.797928 1.685198 0.237267 1.508404 1.457352 0.047420 1.261021 1.192815 1.789893 0.995526 0.930294 1.496757 0.778086 0.636312 1.222185 0.505076 0.392642 1.016934 0.236492 0.140361 0.774022 0.001411 1.961469 0.498526 1.750119 1.648169 0.240766 1.450209 1.419896 0.004281 1.237513 1.195486 1.793570 1.030159 0.946491 1.529067 0.769460 0.726220 1.269159 0.564615 0.472841 1.084479 0.322182 0.217540 0.870218 0.092806 0.039652 0.580465 1.871900 1.768958 0.330755 1.643083 1.574291 0.148815 1.382016 1.330434 1.953984 1.191904 1.113085 1.729795 0.935173 0.941506 1.487573 0.777735 0.706146 1.300602 0.552074 0.471965 1.086702 0.368313 0.238388 0.870358 0.129144 0.034415 0.647185 1.956907 1.855191 0.450494 1.695322 1.674270 0.277115 1.525710 1.462245 0.090299 1.329096 1.259635 1.870782 1.128184 1.069973 1.694787 0.953585 0.907980 1.546930 0.802555 0.747675 1.322734 0.664094 0.527920 1.163169 0.460332 0.399285 0.970040 0.217204 0.171752 0.769371 0.047350 -0.025234 0.632915 1.894302 1.830249 0.455254 1.760595 1.701533 0.321139 1.541634 1.515918 0.102674 1.367783 1.346029 1.941486 1.223287 1.213347 1.782946 1.029999 1.005092 1.692642 0.911840 0.875191 1.494140 0.757479 0.727400 1.310293 0.611635 0.559689 1.154763 0.453641 0.402989 1.051223 0.342693 0.309148 0.919084 0.199108 0.132609 0.759042 0.053229 -0.033954 0.648811 1.906240 1.894740 0.483288 1.798246 1.730147 0.369025 1.616846 1.576788 0.217080 1.494201 1.461719 0.088483 1.386902 1.325078 1.982480 1.249756 1.217589 1.872681 1.143670 1.127132 1.742603 1.001258 0.969685 1.653400 0.948140 0.903244 1.474757 0.844045 0.804740 1.381313 0.669059 0.696990 1.287624 0.590259 0.542974 1.139086 0.529408 0.444238 1.060949 0.381119 0.387330 0.982887 0.274265 0.262799 0.892622 0.182183 0.155238 0.802580 0.125716 0.062385 0.697970 -0.029110 -0.005740 0.631814 1.935506 1.905147 0.526743 1.805035 1.822539 0.427610 1.754204 1.769095 0.334244 1.671094 1.648758 0.313430 1.604455 1.580989 0.249732 1.534106 1.501925 0.141332 1.456591 1.376333 0.087064 1.395898 1.349285 -0.007846 1.309141 1.324784 1.926752 1.235223 1.257013 1.870695 1.183965 1.196890 1.833185 1.161076 1.134259 1.737981 1.066217 1.029285 1.761061 1.046404 1.003567 1.669085 1.015282 0.945700 1.628153 0.957401 0.910198 1.578015 0.892702 0.920061 1.560411 0.892643 0.883270 1.499087 0.881141 0.786754 1.465346 0.814870 0.806704 1.420951 0.745568 0.748981 1.428779 0.724569 0.722331 1.414318 0.735199 0.680304 1.412191 0.642055 0.663317 1.362918 0.692620 0.652852 1.255275 0.655029 0.616540 1.306668 0.607368 0.596378 1.278318 0.605729 0.626127 1.248672 0.605969 0.598531 1.270199 0.590247 0.604018 1.248420 0.564539 0.573991 1.243120 0.541247 0.581568 1.247013 0.548311 0.583389 1.254363 0.570054 0.592870 1.314918 0.584147 0.601170 1.285128 0.585385 0.636800 1.268157 0.564860 0.618673 1.241680 0.593206 0.649499 1.294308 0.619335 0.690828 1.290074 0.662251 0.659564 1.319465 0.684267 0.676527 1.346573 0.684074 0.749941 1.376399 0.760563 0.735778 1.409735 0.781193 0.776861 1.424608 0.803012 0.794890 1.482330 0.849249 0.820388 1.516581 0.910615 0.864461 1.540065 0.895368 0.913334 1.630286 0.950361 0.962747 1.686669 0.985439 1.020247 1.674781 0.998529 1.106931 1.784420 1.109819 1.080550 1.792617 1.141848 1.167488 1.815820 1.225904 1.216862 1.932151 1.308230 1.267897 -0.026968 1.330184 1.385176 0.022707 1.458233 1.415333 0.128552 1.487923 1.523242 0.191001 1.550003 1.584242 0.283355 1.596921 1.662782 0.308217 1.689429 1.701664 0.432683 1.765615 1.799785 0.477706 1.814969 1.847473 0.536692 1.956606 -0.125001 0.671687 0.021081 0.062099 0.778322 0.143122 0.195164 0.870404 0.217515 0.248340 0.992771 0.296311 0.393796 1.036703 0.444136 0.428455 1.144392 0.545916 0.532816 1.274635 0.638559 0.682382 1.366079 0.738438 0.791235 1.469530 0.832133 0.861591 1.597033 0.965134 0.975949 1.660906 1.074595 1.121780 1.850802 1.205711 1.200292 1.955639 1.297951 1.320764 0.075418 1.456186 1.481933 0.158684 1.566840 1.641287 0.359580 1.677476 1.730799 0.448508 1.815321 1.873655 0.540161 1.931330 1.974330 0.742536 0.063433 0.156314 0.825290 0.223991 0.306298 0.962765 0.360970 0.418863 1.127740 0.516243 0.542975 1.312005 0.652439 0.710545 1.452213 0.776568 0.871797 1.548353 0.973587 1.004549 1.725321 1.089618 1.233086 1.882229 1.280829 1.345266 0.036253 1.417172 1.451706 0.202998 1.622238 1.674924 0.340016 1.728728 1.833591 0.567298 1.946042 0.023405 0.702356 0.135275 0.153799 0.884198 0.265400 0.340889 1.099730 0.493458 0.526956 1.267239 0.676407 0.690082 1.422573 0.812500 0.926029 1.644040 1.074851 1.097114 1.811626 1.221109 1.268846 0.019885 1.418865 1.465834 0.226550 1.602283 1.642652 0.409600 1.782663 1.847764 0.612518 -0.014414 0.080272 0.793644 0.189642 0.287941 1.015956 0.430798 0.498270 1.212055 0.606553 0.678263 1.458990 0.847157 0.901708 1.629236 1.030896 1.120792 1.854770 1.260369 1.292084 0.058109 1.472251 1.530032 0.298666 1.686445 1.750885 0.465407 1.926615 -0.015762 0.736186 0.179728 0.219514 0.995121 0.367989 0.459496 1.186779 0.640597 0.690551 1.458450 0.858324 0.911511 1.699195 1.068188 1.186092 1.897316 1.337175 1.402416 0.144009 1.638297 1.673138 0.373403 1.812913 1.888979 0.630635 0.080370 0.169331 0.914815 0.273060 0.393754 1.122091 0.596144 0.640794 1.390765 0.839105 0.918214 1.680880 1.131151 1.205710 1.974811 1.393861 1.452322 0.156477 1.645144 1.718367 0.451059 1.878144 0.022469 0.716191 0.203622 0.204052 1.000934 0.419218 0.531168 1.297295 0.702318 0.799989 1.534195 0.962961 1.059623 1.864764 1.322381 1.390676 0.140300 1.535535 1.653796 0.423232 1.846167 1.958815 0.705134 0.115159 0.251430 1.006465 0.470237 0.504026 1.267250 0.734232 0.836445 1.549915 1.039694 1.136664 1.905550 1.321296 1.400727 0.208474 1.633666 1.709003 0.486386 1.940896 0.025205 0.789590 0.229116 0.395199 1.113150 0.560152 0.653681 1.459139 0.830910 0.975236 1.738577 1.210343 1.308624 0.093706 1.493739 1.620053 0.424641 1.828846 1.940485 0.729339 0.163547 0.294790 1.029106 0.522695 0.623772 1.363366 0.795679 0.991955 1.735746 1.166232 1.233433 0.033448 1.517164 1.590656 0.407889 1.837549 1.928075 0.698672 0.187906 0.288583 1.089091 0.525365 0.646727 1.419503 0.847075 1.003035 1.770682 1.222701 1.368528 0.132834 1.552702 1.702988 0.486356 1.942867 0.028321 0.834453 0.305865 0.427874 1.193367 0.646670 0.777994 1.535326 0.959127 1.141152 1.974723 1.386313 1.482039 0.241727 1.733430 1.907279 0.652190 0.113225 0.233654 1.053634 0.521015 0.606360 1.407458 0.868195 0.979596 1.802838 1.252544 1.387190 0.144685 1.620697 1.765258 0.551267 0.016634 0.102630 0.966227 0.379774 0.557760 1.339080 0.772792 0.943942 1.714448 1.227165 1.340588 0.135412 1.553794 1.733262 0.505137 0.052411 0.115242 0.903954 0.369383 0.566147 1.338694 0.822997 0.955372 1.767911 1.219397 1.351801 0.123533 1.574789 1.767438 0.582707 0.059344 0.173569 0.987297 0.434401 0.616641 1.368611 0.898977 1.018679 1.815949 1.269299 1.423987 0.244273 1.756592 1.844278 0.628834 0.156429 0.267440 1.098495 0.557657 0.757430 1.527200 1.032316 1.157667 1.941839 1.435329 1.592128 0.417339 1.857219 0.027921 0.825078 0.326257 0.472209 1.266409 0.776877 0.907550 1.713542 1.197483 1.352897 0.148954 1.643699 1.805895 0.598148 0.109639 0.271416 1.099053 0.556356 0.664165 1.505314 0.973330 1.224262 1.958351 1.490436 1.656174 0.418476 1.960327 0.146807 0.899660 0.444751 0.550436 1.400125 0.831060 1.011690 1.850969 1.328814 1.486005 0.311620 1.812294 -0.006342 0.797723 0.305173 0.491901 1.322423 0.745375 0.923548 1.782732 1.275234 1.378532 0.222379 1.713386 1.920722 0.741433 0.280929 0.401426 1.209280 0.698837 0.886341 1.726784 1.225163 1.413939 0.172159 1.726536 1.893106 0.754636 0.203236 0.351446 1.190416 0.680791 0.829406 1.684757 1.210208 1.371232 0.224484 1.699825 1.891292 0.738873 0.258642 0.425836 1.243225 0.713196 0.891190 1.771850 1.235681 1.368819 0.270358 1.784768 1.928168 0.781510 0.284144 0.430703 1.331232 0.807861 0.993486 1.852203 1.325750 1.549374 0.376307 1.889520 0.034521 0.884377 0.427788 0.583618 1.373059 0.934920 1.074386 1.964373 1.419552 1.645249 0.489767 0.008746 0.185928 1.061283 0.556624 0.715745 1.608195 1.103831 1.267216 0.164802 1.613900 1.850921 0.624698 0.161160 0.408839 1.261772 0.735470 0.975590 1.782335 1.311907 1.475716 0.390097 1.869546 0.060780 0.873934 0.410643 0.589799 1.451558 0.998661 1.152970 0.054633 1.557268 1.731872 0.575393 0.117821 0.307307 1.198887 0.683313 0.897819 1.753607 1.284857 1.473685 0.314273 1.836871 0.060820 0.932547 0.420398 0.613590 1.461860 1.038061 1.203207 0.095116 1.584547 1.810340 0.624226 0.177690 0.397754 1.253072 0.802314 0.987311 1.879162 1.342549 1.566135 0.442620 1.908917 0.137619 1.011650 0.599336 0.755517 1.642027 1.174961 1.369054 0.211942 1.782659 -0.010486 0.840251 0.357521 0.581790 1.461271 1.014049 1.200403 0.044641 1.613689 1.808581 0.690100 0.250270 0.388899 1.294231 0.842257 1.021201 1.901029 1.462877 1.641210 0.546531 0.075531 0.291167 1.142643 0.703128 0.915213 1.799433 1.361706 1.526251 0.463549 1.971569 0.185024 1.029933 0.578985 0.824751 1.713096 1.250117 1.463497 0.301505 1.881822 0.143407 0.962817 0.507734 0.729352 1.590586 1.169240 1.393909 0.249757 1.802780 0.053110 0.895331 0.464179 0.669201 1.582612 1.097231 1.355127 0.231353 1.735403 0.021720 0.880348 0.431395 0.697354 1.573165 1.060767 1.347507 0.185124 1.772265 1.983494 0.879718 0.443530 0.687541 1.535902 1.151743 1.322419 0.212153 1.745041 -0.024853 0.929578 0.461659 0.706048 1.575808 1.122374 1.345663 0.241665 1.798693 0.038133 0.893828 0.497759 0.738405 1.619233 1.230529 1.391018 0.311367 1.875986 0.111417 0.982712 0.552692 0.779545 1.673926 1.277817 1.495634 0.424964 1.933807 0.193663 1.085748 0.635034 0.877002 1.797408 1.324014 1.603040 0.515913 0.114700 0.279027 1.230954 0.738758 0.971164 1.923699 1.522824 1.758904 0.629325 0.199968 0.431971 1.357304 0.920686 1.144660 0.047634 1.638457 1.887367 0.770386 0.339803 0.608798 1.474763 1.082399 1.336813 0.240373 1.815488 0.071521 0.978055 0.575127 0.812951 1.691650 1.236419 1.523987 0.428018 -0.014053 0.227398 1.211471 0.739843 1.033454 1.889876 1.490608 1.764875 0.650358 0.197774 0.479040 1.394298 0.990877 1.266721 0.153708 1.743738 1.993903 0.889105 0.452779 0.717556 1.641719 1.258531 1.472505 0.400527 0.003181 0.277816 1.190582 0.720088 1.018145 1.947482 1.529759 1.763205 0.679772 0.305019 0.551595 1.459782 1.056328 1.376741 0.254961 1.837237 0.083779 1.033490 0.597121 0.863372 1.752800 1.369817 1.661724 0.554009 0.132249 0.412929 1.366488 0.929237 1.205521 0.153686 1.780997 0.028187 0.910073 0.518459 0.747299 1.736440 1.285832 1.584544 0.515963 0.139650 0.379555 1.267964 0.869992 1.153100 0.094361 1.717865 1.955775 0.900339 0.490824 0.754072 1.676728 1.277159 1.570274 0.491155 0.127499 0.354589 1.327580 0.971916 1.203157 0.189781 1.749254 -0.000141 0.971242 0.569275 0.834995 1.792334 1.386324 1.620367 0.641313 0.177512 0.493821 1.395372 1.027112 1.276574 0.195767 1.840052 0.118782 1.057366 0.655353 0.981627 1.889857 1.497516 1.809949 0.727076 0.311895 0.619859 1.589373 1.177776 1.446089 0.402884 -0.013138 0.323859 1.242590 0.872932 1.139811 0.103389 1.705727 0.012476 0.932654 0.580713 0.844428 1.776557 1.375650 1.683357 0.653489 0.286018 0.530346 1.477873 1.102629 1.446550 0.391220 0.013493 0.315912 1.191737 0.889652 1.135899 0.064317 1.726753 0.008311 0.973187 0.561368 0.881325 1.835182 1.452878 1.728216 0.640203 0.296506 0.611465 1.537761 1.163681 1.521594 0.455106 0.113603 0.376193 1.335690 0.990813 1.252928 0.217355 1.798201 0.130538 1.099312 0.694187 1.042508 1.990873 1.625313 1.908796 0.833102 0.534393 0.775983 1.784275 1.381831 1.684754 0.630094 0.272616 0.575688 1.559911 1.184625 1.453679 0.491431 0.104067 0.400708 1.342106 0.977889 1.261797 0.248038 1.904884 0.237792 1.209205 0.805676 1.119936 0.155727 1.752922 0.098394 1.023110 0.709066 0.956558 1.945167 1.621782 1.885544 0.851378 0.511350 0.815303 1.752479 1.417551 1.712996 0.651328 0.341725 0.648800 1.652874 1.229749 1.564655 0.595314 0.162557 0.496357 1.536686 1.115189 1.443475 0.423294 0.108662 0.395018 1.332526 0.999816 1.352353 0.328398 1.960089 0.256657 1.276205 0.950110 1.251154 0.223763 1.856947 0.198310 1.202811 0.823347 1.139257 0.137493 1.791954 0.126818 1.077613 0.742716 1.034617 0.042667 1.702855 0.035869 0.942965 0.683955 0.962192 1.957952 1.636826 1.953521 0.904062 0.576569 0.908521 1.946168 1.527121 1.835900 0.915076 0.530360 0.860954 1.848124 1.476416 1.825816 0.801278 0.498232 0.791951 1.825898 1.460369 1.801238 0.807022 0.470147 0.775520 1.782957 1.421022 1.758922 0.747391 0.412834 0.729983 1.748458 1.430447 1.754281 0.725069 0.444203 0.754125 1.805117 1.457795 1.776284 0.724624 0.428724 0.744488 1.781494 1.483810 1.771396 0.825589 0.485350 0.772930 1.812210 1.489700 1.842892 0.808972 0.497919 0.826699 1.849758 1.501581 1.863781 0.830698 0.510646 0.856199 1.880392 1.487637 1.841337 0.883565 0.587660 0.933592 1.879899 1.575694 1.912690 0.882053 0.596355 0.876449 1.942318 1.604954 1.957913 0.991402 0.632658 0.965194 -0.031486 1.680264 0.039739 1.057207 0.660079 1.072774 0.084190 1.760660 0.122642 1.146243 0.783356 1.166710 0.158916 1.820281 0.220718 1.231907 0.956518 1.285669 0.300669 1.936753 0.315132 1.335110 1.060246 1.374454 0.394758 0.082667 0.417144 1.497357 1.121455 1.497524 0.558460 0.253594 0.585079 1.609798 1.353184 1.698378 0.628590 0.358364 0.702657 1.718959 1.448521 1.778728 0.811121 0.552978 0.858398 1.901305 1.551915 1.964990 1.006942 0.659821 0.990952 0.063543 1.773494 0.063737 1.160916 0.874963 1.254235 0.227903 1.909287 0.327897 1.310953 0.994777 1.331010 0.411728 0.136015 0.418712 1.516878 1.254075 1.541807 0.597800 0.341732 0.654709 1.684819 1.408026 1.806837 0.819367 0.523512 0.857369 1.895100 1.607979 1.949425 0.987941 0.703347 1.084034 0.136539 1.830122 0.250645 1.285193 0.947170 1.289548 0.328696 0.029933 0.461597 1.469311 1.207559 1.503925 0.619432 0.268080 0.678945 1.716381 1.398922 1.858266 0.884402 0.579547 0.942855 -0.007780 1.697643 0.060832 1.147089 0.859119 1.243156 0.279683 1.948552 0.303518 1.436858 1.120717 1.478393 0.523558 0.237367 0.599745 1.706188 1.421576 1.811698 0.850440 0.556037 0.945518 -0.871745 1.728994 0.072385 1.111766 0.835570 1.223297 0.269709 0.056622 0.355706 1.422876 1.147014 1.551471 0.600627 0.344660 0.724082 1.763987 1.516159 1.882823 0.942715 0.661410 1.033320 0.094097 1.855748 0.231455 1.280646 1.044202 1.442450 0.460350 0.194810 0.625856 1.678168 1.370560 1.773190 0.847696 0.600688 1.001562 0.035016 1.824811 0.145896 1.197674 0.963152 1.364275 0.436987 0.180547 0.564604 1.641854 1.399407 1.733896 0.850418 0.609483 0.927674)
       )

))


;;; triangle waves in place of sinusoids have different mimima at different places, so
;;;   we can't simplify in that direction

;;; the waveforms for a given number of peaks are surprisingly similar -- :odd and :even in particular
;;;   this includes cases involving all sines (0 and 1), as compared to all cosines (1/2 and 3/2)


(define (tstodd phs)
  (do ((len (length phs))
       (incr 0.0001)
       (mx 0.0)
       (loc 0.0)
       (x 0.0))
      ((> x (* 2 pi)) 
       (list mx loc))
    (do ((val 0.0)
	 (k 0 (+ k 1))
	 (j 1 (+ j 2)))
	((= k len)
	 (when (> (abs val) mx)
	   (set! mx (abs val))
	   (set! loc x)))
      (set! val (+ val (sin (+ (* j x) (* pi (phs k)))))))
    (set! x (+ x incr))))


(define (tstoddderiv x phs) 
  (do ((sum 0.0)
       (len (length phs))
       (i 0 (+ i 1))
       (j 1 (+ j 2)))
      ((= i len) sum)
    (set! sum (+ sum (* j (cos (+ (* j x) (* pi (phs i)))))))))


(define* (tstall phs phs1)
  (if (real? phs) (set! phs phs1))
  (do ((len (length phs))
       (incr 0.0001)
       (mx 0.0)
       (loc 0.0)
       (x 0.0))
      ((> x (* 2 pi)) 
       (list mx loc))
    (do ((val 0.0)
	 (k 0 (+ k 1))
	 (j 1 (+ j 1)))
	((= k len)
	 (when (> (abs val) mx)
	   (set! mx (abs val))
	   (set! loc x)))
      (set! val (+ val (sin (+ (* j x) (* pi (phs k)))))))
    (set! x (+ x incr))))

(define (tstallf mult phs)
  (do ((len (length phs))
       (incr 0.0001)
       (mx 0.0)
       (loc 0.0)
       (x 0.0))
      ((> x (* 2 pi)) 
       (list mx loc))
    (do ((val 0.0)
	 (k 0 (+ k 1))
	 (j 1 (+ j 1)))
	((= k len)
	 (when (> (abs val) mx)
	   (set! mx (abs val))
	   (set! loc x)))
      (set! val (+ val (if (= k (- len 1))
			   (* mult (sin (+ (* j x) (* pi (phs k)))))
			   (sin (+ (* j x) (* pi (phs k))))))))
    (set! x (+ x incr))))

(define (tsteven phs)
  (do ((len (length phs))
       (incr 0.0001)
       (mx 0.0)
       (loc 0.0)
       (x 0.0))
      ((> x (* 2 pi)) 
       (list mx loc))
    (do ((val 0.0)
	 (k 0 (+ k 1)))
	((= k len)
	 (when (> (abs val) mx)
	   (set! mx (abs val))
	   (set! loc x)))
      (set! val (+ val (sin (+ (* (max (* 2 k) 1) x) (* pi (phs k)))))))
    (set! x (+ x incr))))

(define (tstprime phs)
  (do ((len (length phs))
       (incr 0.0001)
       (mx 0.0)
       (loc 0.0)
       (x 0.0))
      ((> x (* 2 pi)) 
       (list mx loc))
    (do ((val 0.0)
	 (k 0 (+ k 1)))
	((= k len)
	 (when (> (abs val) mx)
	   (set! mx (abs val))
	   (set! loc x)))
      (set! val (+ val (sin (+ (* (primes k) x) (* pi (phs k)))))))
    (set! x (+ x incr))))

(define (tstallderiv x phs) 
  (do ((sum 0.0)
       (len (length phs))
       (i 0 (+ i 1))
       (j 1 (+ j 1)))
      ((= i len) sum)
    (set! sum (+ sum (* j (cos (+ (* j x) (* pi (phs i)))))))))


(define (get-best choice n)
  (let ((func (lambda (val)
		(and (vector? val)
		     (= (val 0) n)
		     (let ((a-val (val 1))
			   (a-len (length val))
			   (a-data (val 2)))
		       (do ((k 3 (+ 1 k)))
			   ((= k a-len))
			 (if (and (real? (val k))
				  (< (val k) a-val))
			     (begin
			       (set! a-val (val k))
			       (set! a-data (val (+ k 1))))))
		       (list a-val a-data)))))
	(vect (case choice
		((:all) noid-min-peak-phases)
		((:odd) nodd-min-peak-phases)
		((:even) neven-min-peak-phases)
		(else primoid-min-peak-phases))))
    (do ((len (length vect))
	 (result #f)
	 (i 0 (+ i 1)))
	((or (= i len) result) 
	 result)
      (set! result (func (vect i))))))

(define (sum-sines v i x len phs)
  (do ((val 0.0)
       (k 0 (+ k 1))
       (j 1 (+ j 1)))
      ((= k len)
       (set! (v i) val))   
    (set! val (+ val (sin (+ (* j x) (* pi (phs k))))))))
  

(define (showall len)
  (let ((phs-data (get-best :all len)))
    (do ((phs (cadr phs-data))
	 (mx (car phs-data))
	 (v (make-float-vector (ceiling (+ (* pi 2000) 2))))
	 (incr 0.001)
	 (x 0.0)
	 (i 0 (+ i 1)))
	((> x (* 2 pi))
	 (new-sound)
	 (float-vector->channel v)
	 (set! (y-bounds) (list (- mx) mx)))
      (sum-sines v i x len phs)
      (set! x (+ x incr)))))

(define (showphases mx phs)
  (do ((v (make-float-vector (ceiling (+ (* pi 2000) 2))))
       (incr 0.001)
       (len (length phs))
       (x 0.0)
       (i 0 (+ i 1)))
      ((> x (* 2 pi))
       (new-sound)
       (float-vector->channel v)
       (set! (y-bounds) (list (- mx) mx)))
    (sum-sines v i x len phs)
    (set! x (+ x incr))))

(define (showodd len)
  (let ((phs-data (get-best :odd len)))
    (do ((phs (cadr phs-data))
	 (mx (car phs-data))
	 (v (make-float-vector (ceiling (+ (* pi 2000) 2))))
	 (incr 0.001)
	 (x 0.0)
	 (i 0 (+ i 1)))
	((> x (* 2 pi))
	 (new-sound)
	 (float-vector->channel v)
	 (set! (y-bounds) (list (- mx) mx)))
      (sum-sines v i x len phs)
      (set! x (+ x incr)))))

(define (showdiff n1 n2)
  (let ((len (length n1)))
    (do ((data (make-float-vector len))
	 (i 0 (+ i 1)))
	((= i len)
	 (new-sound)
	 (float-vector->channel data))
      (set! (data i) (modulo (- (n1 i) (n2 i)) 2.0))
      (if (> (data i) 1.0)
	  (set! (data i) (- (data i) 2.0))
	  (if (< (data i) -1)
	      (set! (data i) (+ (data i) 2.0)))))))

(define (differ snd) 
  (let ((x 0.0))
    (map-channel 
     (lambda (y) 
       (let ((res (- y x)))
	 (set! x y) 
	 res))
     0 #f snd 0)))    


(define (find-other-mins peak-amp peak-phases)

  ;; given a point, find the 3 other matching points (this assumes all harmonics, but the other cases are similar;
  ;;   in the even case, we'd flip all above 0, not just every other one, because they're all even, but we end
  ;;   up with 4 equivalent points as before -- step by 1 not 2 in the 1st and 3rd loops below.  In the odd and 
  ;;   prime cases, I can only think of 2 such points, the symmetry being around 0 (2-val)).

  (let ((temp-phases (copy peak-phases))
	(n (length peak-phases))
	(results ()))

    ;; flip evens
    (do ((i 1 (+ i 2)))
	((>= i n))
      (set! (temp-phases i) (modulo (+ (temp-phases i) 1.0) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format () ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

    ;; get case symmetric around 0
    (set! temp-phases (copy peak-phases))
    (do ((i 1 (+ i 1)))
	((= i n))
      (set! (temp-phases i) (modulo (- 2.0 (temp-phases i)) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format () ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

    ;; flip evens on the previous case
    (set! temp-phases (copy temp-phases))
    (do ((i 1 (+ i 2)))
	((>= i n))
      (set! (temp-phases i) (modulo (+ (temp-phases i) 1.0) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format () ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

;   (format #f "~{~{~,8F ~A~%~}~}" (reverse results))
    results
    ))

;;; :(find-other-mins (car (tstall #r(0.0 0.1 0.2 0.3))) #r(0.0 0.1 0.2 0.3))
;;; 3.49630991 #r(0.0 1.1 0.2 1.3)
;;; 3.49630680 #r(0.0 1.9 1.8 1.7)
;;; 3.49630979 #r(0.0 0.9 1.8 0.7)



(define (canonicalize-one i p)
  (let ((data (get-best :all i)))
    (let ((old-peak (car data))
	  (old-phases (cadr data)))
      (let ((phases (copy old-phases)))
	(if (< (phases 2) -1.0)
	    (set! (phases 2) (+ (phases 2) 2.0))
	    (if (> (phases 2) 1.0)
		(set! (phases 2) (- (phases 2) 2.0))))
	(if (< (phases 2) 0.0)
	    (do ((j 1 (+ j 1)))
		((>= j i))
	      (set! (phases j) (modulo (- 2.0 (phases j)) 2.0))))
	(if (< (phases 1) -1.0)
	    (set! (phases 1) (+ (phases 1) 2.0))
	    (if (> (phases 1) 1.0)
		(set! (phases 1) (- (phases 1) 2.0))))
	(if (< (phases 1) 0.0) ; this is an "even" harmonic
	    (do ((j 1 (+ j 2)))
		((>= j i))
	      (set! (phases j) (modulo (+ 1.0 (phases j)) 2.0))))
	(do ((j 1 (+ j 1)))
	    ((= j i))
	  (if (< (phases j) -1.0)
	      (set! (phases j) (+ (phases j) 2.0))
	      (if (> (phases j) 1.0)
		  (set! (phases j) (- (phases j) 2.0)))))
	(let ((new-peak-info (tstall phases)))
	  (let ((new-peak (car new-peak-info)))
	    (if (> (abs (- new-peak old-peak)) .001)
		(format *stderr* "oops: ~D: ~A ~A~%" i old-peak new-peak))
	    (format p "(vector ~D ~,6F #r(" i new-peak))
	  (do ((k 1 (+ k 1)))
	      ((= k i))
	    (format p "~,6F " (phases (- k 1))))
	  (format p "~,6F))~%  ;; loc: ~F~%~%" (phases (- i 1)) (/ (cadr new-peak-info) pi)))))))

(define (canonicalize)
  ;; this is slow because we call tstall on each one 
  (call-with-output-file "pp4.scm" 
    (lambda (p)
      (format p "(define noid-min-peak-phases (vector~%~%(vector 1  1.0    #r(0))~%(vector 2  1.76   #r(0 0))~%~%")
      (do ((i 3 (+ i 1)))
	  ((> i 128))
	(format *stderr* "~D " i)
	(canonicalize-one i p))
      (format p "))~%"))))

(if (provided? 'snd) (set! (print-length) 123123) (set! (*s7* 'print-length) 123123))

(define (show-mins i)
  (let ((data (get-best :all i)))
    (let ((other-mins (apply find-other-mins data)))
      (let ((pk1 (cadr data))
	    (pk2 (cadar other-mins))
	    (pk3 (cadadr other-mins))
	    (pk4 (cadr (caddr other-mins))))

	(if (or (> (abs (- (caar other-mins) (car data))) .001)
		(> (abs (- (caadr other-mins) (car data))) .001)
		(> (abs (- (caaddr other-mins) (car data))) .001))
	    (format () "trouble in ~D: ~A ~A~%" i data other-mins))

	(let ((phases (sort! (list pk1 pk2 pk3 pk4)
			     (lambda (a b)
			       (< (a 1) (b 1))))))
	  (format () "~,8F~%    ~A~%    ~A~%    ~A~%    ~A~%"
		  (data 0)
		  (phases 0)
		  (phases 1)
		  (phases 2)
		  (phases 3)
		  ))))))

;; (09)
;; 1 Mar 5446.42
;; 1 Apr 5405.890
;; 1 May 5138.261
;; 1 Jun 5061.829
;; 1 Jul 4669.101
;; 1 Aug 4633.454
;; 1 Sep 4616.517
;; 1 Oct 4592.994
;; 1 Nov 4560.903
;; 1 Dec 4541.710
;; (10)
;; 1 Jan 4360.644
;; 1 Feb 4292.451
;; 1 Mar 4280.782
;; 1 Apr 4272.964
;; 1 May 4267.719
;; 1 Jun 4261.356
;; 1 Jul 4244.312, sqrts: 82 74 0 0
;; 1 Aug 4218.456, sqrts: 82 74 0 0
;; 1 Sep 4209.464, sqrts: 85 74 0 0   (9.5330)
;; 1 Oct 4202.347, sqrts: 89 75 0 0   (6.9438)
;; 1 Nov 4198.764, sqrts: 94 78 0 0   (5.5196)
;; 1 Dec 4196.395, sqrts: 98 84 0 0   (4.1226)
;; (11)
;; 1 Jan 4194.669, sqrts: 101 91 0 0  (2.9465)
;; 1 Feb 4194.106, sqrts: 105 91 0 0  (2.5054)
;; 1 Mar 4193.048, sqrts: 110 95 0 0  (1.6862)
;; 1 Apr 4188.373, sqrts: 114 104 0 0 (0.8505)
;; 1 May 4186.610, sqrts: 114 105 0 0 (0.6439)
;; 1 Jun 4186.498, sqrts: 115 105 0 0 (0.5422)
;; 1 Nov 4186.465, sqrts: 116 105 0 0 (0.5095)
;; 1 Dec 4186.315, sqrts: 117 108 0 0 (0.4198) 
;; (12)
;; 1 Jan 4185.693, sqrts: 118 112 0 0 (0.3225)
;; 1 Feb 4185.458, sqrts: 119 113 0 0 (0.2534)
;; 1 Mar 4185.289, sqrts: 119 115 0 0 (0.1710)
;; 1 Apr 4185.029, sqrts: 120 115 0 0 (0.1464)
;; 1 Nov 4184.742, sqrts: 120 115 0 0 (0.1429)
;; 1 Dec 4184.727, sqrts: 121 115 0 0 (0.1349)
;; (13)
;; 1 Feb 4184.520, sqrts: 122 115 0 0 (0.1159)
;; 1 Jun 4184.160, sqrts: 122 118 0 0 (0.0926)
;; 1 Aug 4183.948, sqrts: 122 118 0 0 (0.0440)
;; 1 Sep 4183.825, sqrts: 122 119 0 0 (0.0382)
;; 1 Oct 4183.673, sqrts: 122 119 0 0 (0.0382)
;; 1 Nov 4183.616, sqrts: 122 119 0 0 (0.0382)
;; 1 Dec 4183.180, sqrts: 122 120 0 0 (0.0361)
;; (14)
;; 1 Jan 4183.004, sqrts: 122 120 0 0 (0.0346)
;; 1 Mar 4182.956, sqrts: 122 120 0 0 (0.0346)
;; 1 Apr 4182.919, sqrts: 122 120 0 0 (0.0346)
;; 1 May 4182.759, sqrts: 122 120 0 0 (0.0346)
;; 1 Jun 4177.414, sqrts: 122 120 0 0 (0.0346)
;; 1 Jul 4174.620, sqrts: 122 120 0 0 (0.0346)
;; 1 Aug 4171.810, sqrts: 122 120 0 0 (0.0346)
;; 1 Sep 4169.400, sqrts: 122 120 0 0 (0.0346)
;; 1 Oct 4166.886, sqrts: 122 121 0 0 (0.0242)
;; 1 Nov 4163.522, sqrts: 122 122 0 0 (0.0000)
;; 1 Dec 4161.032, sqrts: 122 122 0 0 (0.0000)
;; (15)
;; 1 Jan 4158.938
;; 1 Feb 4156.526
;; 1 Mar 4154.769
;; 1 Apr 4154.180
;; 1 May 4153.716
;; 1 Jun 4153.330
;; 1 Jul 4152.859
;; 1 Aug 4152.637
;; 1 Sep 4152.306
;; 1 Oct 4152.200
;; 1 Nov 4152.089
;; 1 Dec 4151.958
;; (16)
;; 1 Jan 4151.620
;; (17)
;; 1-Oct 4150.037
;; (18)
;; 1-Jan 4149.99

;    all 0.4860 (20) to 0.4986 (125), dist: 0.0000, 15.0910
;    odd 0.4820 (11) to 0.5000 (112), dist: 0.0000, 9.0892
;    even 0.5085 (115) to 0.5242 (22), dist: 57.6613, 0.0000
;    prime 0.5444 (24) to 0.5540 (67), dist: 232.5920, 0.0000

#|
20-Jul-18:
sum: 4146.508608384121, sqrts: 122 122 0 0 (0.0000)
    all 0.4860 (20) to 0.4986 (125), dist: 0.0000, 15.0910
    odd 0.4820 (11) to 0.5000 (112), dist: 0.0000, 9.0892
    even 0.5067 (120) to 0.5242 (22), dist: 55.3350, 0.0000
    prime 0.5444 (24) to 0.5539 (67), dist: 231.4321, 0.0000
|#

;(test-all-phases #f) in test-phases.scm

#|
;;; 31-May-10: 214
;;;  1-Mar-11: 120
;;;  6-Mar-12:  28
;;;  3-Feb-13:  41
;;; 19-Jul-14:  22
;;;  9-Jul-15:  18
;;;  9-Nov-16:  22
;;; 20-Jul-17:   6
;;; 24-Jun-18:   6

;all peaks... Sat 18-Aug-2018 03:46
(0.00149573739942177 101)
;odd peaks... Sat 18-Aug-2018 03:48
(0.001687315629254726 125)
;even peaks... Sat 18-Aug-2018 03:49
(0.001467169674692848 4)
;prime peaks... Sat 18-Aug-2018 03:50
(0.001975582609148319 2048)
;all done! Sat 18-Aug-2018 03:52

390.831u 0.007s 6:30.85 99.9%	0+0k 0+0io 0pf+0w
|#

;;; gad161: clean-up-evens
;;; t139.scm: show-circle (Motif-based)
;;; t283.scm: poly stuff
;;; tmp26.scm sqrt graph
;;; t404.scm for averages, graphed via graph-averages.scm
;;; t405.scm for function searcher
