/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.synonym.SynonymGraphFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.ESSolrSynonymParser;
import org.elasticsearch.index.analysis.ESWordnetSynonymParser;
import org.elasticsearch.index.analysis.SynonymTokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;

public class SynonymGraphTokenFilterFactory
extends SynonymTokenFilterFactory {
    public SynonymGraphTokenFilterFactory(IndexSettings indexSettings, Environment env, AnalysisRegistry analysisRegistry, String name, Settings settings) throws IOException {
        super(indexSettings, env, analysisRegistry, name, settings);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        throw new IllegalStateException("Call createPerAnalyzerSynonymGraphFactory to specialize this factory for an analysis chain first");
    }

    Factory createPerAnalyzerSynonymGraphFactory(Analyzer analyzerForParseSynonym, Environment env) {
        return new Factory("synonymgraph", analyzerForParseSynonym, this.getRulesFromSettings(env));
    }

    public class Factory
    implements TokenFilterFactory {
        private final String name;
        private final SynonymMap synonymMap;

        public Factory(String name, Analyzer analyzerForParseSynonym, Reader rulesReader) {
            this.name = name;
            try {
                Object parser;
                if ("wordnet".equalsIgnoreCase(SynonymGraphTokenFilterFactory.this.format)) {
                    parser = new ESWordnetSynonymParser(true, SynonymGraphTokenFilterFactory.this.expand, SynonymGraphTokenFilterFactory.this.lenient, analyzerForParseSynonym);
                    parser.parse(rulesReader);
                } else {
                    parser = new ESSolrSynonymParser(true, SynonymGraphTokenFilterFactory.this.expand, SynonymGraphTokenFilterFactory.this.lenient, analyzerForParseSynonym);
                    ((ESSolrSynonymParser)((Object)parser)).parse(rulesReader);
                }
                this.synonymMap = parser.build();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("failed to build synonyms", e);
            }
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public TokenStream create(TokenStream tokenStream) {
            return this.synonymMap.fst == null ? tokenStream : new SynonymGraphFilter(tokenStream, this.synonymMap, SynonymGraphTokenFilterFactory.this.ignoreCase);
        }
    }
}

