/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.TimestampUtc;
import tim.prune.data.Track;
import tim.prune.undo.UndoConvertNamesToTimes;

public class ConvertNamesToTimes
extends GenericFunction {
    public ConvertNamesToTimes(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.convertnamestotimes";
    }

    public void begin() {
        int n = this._app.getTrackInfo().getSelection().getStart();
        int n2 = this._app.getTrackInfo().getSelection().getEnd();
        Track track = this._app.getTrackInfo().getTrack();
        if (!track.hasData(Field.WAYPT_NAME, n, n2)) {
            this._app.showErrorMessage(this.getNameKey(), "error.convertnamestotimes.nonames");
            return;
        }
        UndoConvertNamesToTimes undoConvertNamesToTimes = new UndoConvertNamesToTimes(this._app.getTrackInfo());
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            TimestampUtc timestampUtc;
            DataPoint dataPoint = track.getPoint(n4);
            if (dataPoint.isWaypoint() && (timestampUtc = new TimestampUtc(dataPoint.getWaypointName())).isValid()) {
                dataPoint.setFieldValue(Field.TIMESTAMP, dataPoint.getWaypointName(), false);
                dataPoint.setFieldValue(Field.WAYPT_NAME, null, false);
                ++n3;
            }
            ++n4;
        }
        if (n3 > 0) {
            this._app.getTrackInfo().getTrack().requestRescale();
            UpdateMessageBroker.informSubscribers((byte)2);
            this._app.completeFunction(undoConvertNamesToTimes, I18nManager.getText("confirm.convertnamestotimes"));
        }
    }
}

