/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class ParagraphRepeatBeginningRule
extends TextLevelRule {
    public ParagraphRepeatBeginningRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.setDefaultOff();
    }

    @Override
    public String getId() {
        return "PARAGRAPH_REPEAT_BEGINNING_RULE";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("repetition_paragraph_beginning_desc");
    }

    private static int getParagraphBegin(AnalyzedTokenReadings[] tokens, int start) {
        if (start < 1) {
            start = 1;
        }
        for (int i = start; i < tokens.length; ++i) {
            if (!"\n".equals(tokens[i].getToken()) && !"\r\n".equals(tokens[i].getToken()) && !"\n\r".equals(tokens[i].getToken())) continue;
            ++i;
            while (i < tokens.length && tokens[i].isWhitespace()) {
                ++i;
            }
            return i;
        }
        return -1;
    }

    public boolean isArticle(AnalyzedTokenReadings token) {
        return token.hasPosTagStartingWith("DT");
    }

    private int numCharEqualBeginning(AnalyzedTokenReadings[] tokens, int start, AnalyzedTokenReadings[] nextTokens, int nextStart) throws IOException {
        if (tokens.length < 2 || nextTokens.length < 2) {
            return 0;
        }
        int i = start;
        if (i < 1) {
            i = 1;
        }
        while (i < tokens.length && (tokens[i].isWhitespace() || tokens[i].isSentenceStart())) {
            ++i;
        }
        if (i >= tokens.length) {
            return 0;
        }
        String token = tokens[i].getToken();
        if (token.length() == 1) {
            return 0;
        }
        int j = nextStart;
        if (j < 1) {
            j = 1;
        }
        while (j < nextTokens.length && (nextTokens[j].isWhitespace() || nextTokens[j].isSentenceStart())) {
            ++j;
        }
        if (j >= nextTokens.length) {
            return 0;
        }
        String nextToken = nextTokens[j].getToken();
        if (token.equals(nextToken)) {
            if (!this.isArticle(tokens[i])) {
                return tokens[i].getEndPos() - tokens[i].getStartPos();
            }
            int startPos = tokens[i].getStartPos();
            ++i;
            while (i < tokens.length && tokens[i].isWhitespace()) {
                ++i;
            }
            if (i >= tokens.length) {
                return 0;
            }
            ++j;
            while (j < nextTokens.length && nextTokens[j].isWhitespace()) {
                ++j;
            }
            if (j >= nextTokens.length) {
                return 0;
            }
            token = tokens[i].getToken();
            if (token.equals(nextToken = nextTokens[j].getToken()) && token.length() > 1) {
                return tokens[i].getEndPos() - startPos;
            }
        }
        return 0;
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        if (sentences.size() < 1) {
            return this.toRuleMatchArray(ruleMatches);
        }
        int pos = 0;
        int nextPos = 0;
        int lastParaBegin = 1;
        int paraBegin = -1;
        int nextParaBegin = 1;
        int numNextSentence = 0;
        AnalyzedTokenReadings[] lastTokens = null;
        AnalyzedSentence nextSentence = sentences.get(0);
        AnalyzedSentence sentence = null;
        AnalyzedTokenReadings[] tokens = null;
        AnalyzedTokenReadings[] nextTokens = nextSentence.getTokens();
        while (numNextSentence < sentences.size()) {
            if (numNextSentence > 0 || paraBegin >= 0) {
                lastTokens = tokens;
                lastParaBegin = paraBegin;
            }
            sentence = nextSentence;
            tokens = nextTokens;
            paraBegin = nextParaBegin;
            nextPos = 0;
            boolean isPara = false;
            while (numNextSentence < sentences.size() && !isPara) {
                if ((nextParaBegin = ParagraphRepeatBeginningRule.getParagraphBegin(nextTokens, nextParaBegin)) >= 0) {
                    isPara = true;
                }
                if (nextParaBegin >= 0 && nextParaBegin < nextTokens.length) continue;
                if (++numNextSentence < sentences.size()) {
                    if (nextParaBegin >= nextTokens.length) {
                        nextParaBegin = 1;
                    }
                    nextPos += nextSentence.getText().length();
                    nextSentence = sentences.get(numNextSentence);
                    nextTokens = nextSentence.getTokens();
                    continue;
                }
                nextTokens = null;
            }
            if (tokens.length > 2) {
                RuleMatch ruleMatch;
                String msg;
                int startPos;
                int endPos = 0;
                int num = 0;
                num = paraBegin;
                if (num < 1) {
                    num = 1;
                }
                if (lastTokens != null && (endPos = this.numCharEqualBeginning(tokens, paraBegin, lastTokens, lastParaBegin)) > 0) {
                    while (tokens[num].isWhitespace() || tokens[num].isSentenceStart()) {
                        ++num;
                    }
                    startPos = pos + tokens[num].getStartPos();
                    msg = this.messages.getString("repetition_paragraph_beginning_last_msg");
                    ruleMatch = new RuleMatch((Rule)this, sentence, startPos, startPos + endPos, msg);
                    ruleMatches.add(ruleMatch);
                }
                if (endPos == 0 && nextTokens != null && (endPos = this.numCharEqualBeginning(tokens, paraBegin, nextTokens, nextParaBegin)) > 0) {
                    while (tokens[num].isWhitespace() || tokens[num].isSentenceStart()) {
                        ++num;
                    }
                    startPos = pos + tokens[num].getStartPos();
                    msg = this.messages.getString("repetition_paragraph_beginning_next_msg");
                    ruleMatch = new RuleMatch((Rule)this, sentence, startPos, startPos + endPos, msg);
                    ruleMatches.add(ruleMatch);
                }
            }
            pos += nextPos;
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

