/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.util.DefaultOptions;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.constant.HaMode;

public class UrlParser
implements Cloneable {
    private static final String DISABLE_MYSQL_URL = "disableMariaDbDriver";
    private static final Pattern URL_PARAMETER = Pattern.compile("(\\/([^\\?]*))?(\\?(.+))*", 32);
    private static final Pattern AWS_PATTERN = Pattern.compile("(.+)\\.([a-z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2);
    private String database;
    private Options options = null;
    private List<HostAddress> addresses;
    private HaMode haMode;
    private String initialUrl;
    private boolean multiMaster;

    private UrlParser() {
    }

    protected UrlParser(String database, List<HostAddress> addresses, Options options, HaMode haMode) {
        this.options = options;
        this.database = database;
        this.addresses = addresses;
        this.haMode = haMode;
        if (haMode == HaMode.AURORA) {
            for (HostAddress hostAddress : addresses) {
                hostAddress.type = null;
            }
        } else {
            for (HostAddress hostAddress : addresses) {
                if (hostAddress.type != null) continue;
                hostAddress.type = "master";
            }
        }
        DefaultOptions.optionCoherenceValidation(options);
        this.setInitialUrl();
        this.loadMultiMasterValue();
    }

    private void setInitialUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:mariadb:");
        if (this.haMode != HaMode.NONE) {
            sb.append(this.haMode.toString().toLowerCase(Locale.ROOT)).append(":");
        }
        sb.append("//");
        for (int i = 0; i < this.addresses.size(); ++i) {
            HostAddress hostAddress = this.addresses.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append("address=(host=").append(hostAddress.host).append(")").append("(port=").append(hostAddress.port).append(")");
            if (hostAddress.type == null) continue;
            sb.append("(type=").append(hostAddress.type).append(")");
        }
        sb.append("/");
        if (this.database != null) {
            sb.append(this.database);
        }
        DefaultOptions.propertyString(this.options, this.haMode, sb);
        this.initialUrl = sb.toString();
    }

    public static boolean acceptsUrl(String url) {
        return url != null && (url.startsWith("jdbc:mariadb:") || url.startsWith("jdbc:mysql:") && !url.contains(DISABLE_MYSQL_URL));
    }

    public static UrlParser parse(String url) throws SQLException {
        return UrlParser.parse(url, new Properties());
    }

    public static UrlParser parse(String url, Properties prop) throws SQLException {
        if (url != null && (url.startsWith("jdbc:mariadb:") || url.startsWith("jdbc:mysql:") && !url.contains(DISABLE_MYSQL_URL))) {
            UrlParser urlParser = new UrlParser();
            UrlParser.parseInternal(urlParser, url, prop == null ? new Properties() : prop);
            return urlParser;
        }
        return null;
    }

    private static void parseInternal(UrlParser urlParser, String url, Properties properties) throws SQLException {
        try {
            String additionalParameters;
            String hostAddressesString;
            int paramIndex;
            urlParser.initialUrl = url;
            int separator = url.indexOf("//");
            if (separator == -1) {
                throw new IllegalArgumentException("url parsing error : '//' is not present in the url " + url);
            }
            urlParser.haMode = UrlParser.parseHaMode(url, separator);
            String urlSecondPart = url.substring(separator + 2);
            int dbIndex = urlSecondPart.indexOf("/");
            if (dbIndex < (paramIndex = urlSecondPart.indexOf("?")) && dbIndex < 0 || dbIndex > paramIndex && paramIndex > -1) {
                hostAddressesString = urlSecondPart.substring(0, paramIndex);
                additionalParameters = urlSecondPart.substring(paramIndex);
            } else if (dbIndex < paramIndex && dbIndex > -1 || dbIndex > paramIndex && paramIndex < 0) {
                hostAddressesString = urlSecondPart.substring(0, dbIndex);
                additionalParameters = urlSecondPart.substring(dbIndex);
            } else {
                hostAddressesString = urlSecondPart;
                additionalParameters = null;
            }
            UrlParser.defineUrlParserParameters(urlParser, properties, hostAddressesString, additionalParameters);
            UrlParser.setDefaultHostAddressType(urlParser);
            urlParser.loadMultiMasterValue();
        }
        catch (IllegalArgumentException i) {
            throw new SQLException("error parsing url : " + i.getMessage(), i);
        }
    }

    private static void defineUrlParserParameters(UrlParser urlParser, Properties properties, String hostAddressesString, String additionalParameters) {
        if (additionalParameters != null) {
            Matcher matcher = URL_PARAMETER.matcher(additionalParameters);
            if (matcher.find()) {
                urlParser.database = matcher.group(2);
                urlParser.options = DefaultOptions.parse(urlParser.haMode, matcher.group(4), properties, urlParser.options);
                DefaultOptions.optionCoherenceValidation(urlParser.options);
                if (urlParser.database != null && urlParser.database.isEmpty()) {
                    urlParser.database = null;
                }
            } else {
                urlParser.database = null;
                urlParser.options = DefaultOptions.parse(urlParser.haMode, "", properties, urlParser.options);
                DefaultOptions.optionCoherenceValidation(urlParser.options);
            }
        } else {
            urlParser.database = null;
            urlParser.options = DefaultOptions.parse(urlParser.haMode, "", properties, urlParser.options);
            DefaultOptions.optionCoherenceValidation(urlParser.options);
        }
        LoggerFactory.init(urlParser.options.log || urlParser.options.profileSql || urlParser.options.slowQueryThresholdNanos != null);
        urlParser.addresses = HostAddress.parse(hostAddressesString, urlParser.haMode);
    }

    public UrlParser auroraPipelineQuirks() {
        boolean disablePipeline = this.isAurora();
        if (this.options.useBatchMultiSend == null) {
            Boolean bl = this.options.useBatchMultiSend = disablePipeline ? Boolean.FALSE : Boolean.TRUE;
        }
        if (this.options.usePipelineAuth == null) {
            this.options.usePipelineAuth = disablePipeline ? Boolean.FALSE : Boolean.TRUE;
        }
        return this;
    }

    public boolean isAurora() {
        if (this.haMode == HaMode.AURORA) {
            return true;
        }
        if (this.addresses != null) {
            for (HostAddress hostAddress : this.addresses) {
                Matcher matcher = AWS_PATTERN.matcher(hostAddress.host);
                if (!matcher.find()) continue;
                return true;
            }
        }
        return false;
    }

    private static HaMode parseHaMode(String url, int separator) {
        int firstColonPos = url.indexOf(58);
        int secondColonPos = url.indexOf(58, firstColonPos + 1);
        int thirdColonPos = url.indexOf(58, secondColonPos + 1);
        if (thirdColonPos > separator || thirdColonPos == -1) {
            if (secondColonPos == separator - 1) {
                return HaMode.NONE;
            }
            thirdColonPos = separator;
        }
        try {
            return HaMode.valueOf(url.substring(secondColonPos + 1, thirdColonPos).toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException i) {
            throw new IllegalArgumentException("wrong failover parameter format in connection String " + url);
        }
    }

    private static void setDefaultHostAddressType(UrlParser urlParser) {
        if (urlParser.haMode == HaMode.AURORA) {
            for (HostAddress hostAddress : urlParser.addresses) {
                hostAddress.type = null;
            }
        } else {
            for (HostAddress hostAddress : urlParser.addresses) {
                if (hostAddress.type != null) continue;
                hostAddress.type = "master";
            }
        }
    }

    public void parseUrl(String url) throws SQLException {
        if (UrlParser.acceptsUrl(url)) {
            UrlParser.parseInternal(this, url, new Properties());
        }
    }

    public String getUsername() {
        return this.options.user;
    }

    public void setUsername(String username) {
        this.options.user = username;
    }

    public String getPassword() {
        return this.options.password;
    }

    public void setPassword(String password) {
        this.options.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public List<HostAddress> getHostAddresses() {
        return this.addresses;
    }

    public void setHostAddresses(List<HostAddress> addresses) {
        this.addresses = addresses;
    }

    public Options getOptions() {
        return this.options;
    }

    protected void setProperties(String urlParameters) {
        DefaultOptions.parse(this.haMode, urlParameters, this.options);
        this.setInitialUrl();
    }

    public String toString() {
        return this.initialUrl;
    }

    public String getInitialUrl() {
        return this.initialUrl;
    }

    public HaMode getHaMode() {
        return this.haMode;
    }

    public boolean equals(Object parser) {
        if (this == parser) {
            return true;
        }
        if (!(parser instanceof UrlParser)) {
            return false;
        }
        UrlParser urlParser = (UrlParser)parser;
        return (this.initialUrl != null ? this.initialUrl.equals(urlParser.getInitialUrl()) : urlParser.getInitialUrl() == null) && (this.getUsername() != null ? this.getUsername().equals(urlParser.getUsername()) : urlParser.getUsername() == null) && (this.getPassword() != null ? this.getPassword().equals(urlParser.getPassword()) : urlParser.getPassword() == null);
    }

    public int hashCode() {
        int result = this.options.password != null ? this.options.password.hashCode() : 0;
        result = 31 * result + (this.options.user != null ? this.options.user.hashCode() : 0);
        result = 31 * result + this.initialUrl.hashCode();
        return result;
    }

    private void loadMultiMasterValue() {
        if (this.haMode == HaMode.SEQUENTIAL || this.haMode == HaMode.REPLICATION || this.haMode == HaMode.FAILOVER) {
            boolean firstMaster = false;
            for (HostAddress host : this.addresses) {
                if (!host.type.equals("master")) continue;
                if (firstMaster) {
                    this.multiMaster = true;
                    return;
                }
                firstMaster = true;
            }
        }
        this.multiMaster = false;
    }

    public boolean isMultiMaster() {
        return this.multiMaster;
    }

    public Object clone() throws CloneNotSupportedException {
        UrlParser tmpUrlParser = (UrlParser)super.clone();
        tmpUrlParser.options = (Options)this.options.clone();
        tmpUrlParser.addresses = new ArrayList<HostAddress>();
        tmpUrlParser.addresses.addAll(this.addresses);
        return tmpUrlParser;
    }
}

