// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `RemoteLogger.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package Ice;

/**
 * The Ice remote logger interface. An application can implement a
 * RemoteLogger to receive the log messages sent to the local {@link Logger}
 * of another Ice application.
 *
 **/
public interface RemoteLoggerPrx extends ObjectPrx
{
    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     *
     * @param prefix The prefix of the associated local Logger.
     *
     * @param logMessages Old log messages generated before "now".
     *
     **/
    public void init(String prefix, LogMessage[] logMessages);

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     *
     * @param prefix The prefix of the associated local Logger.
     *
     * @param logMessages Old log messages generated before "now".
     *
     * @param context The Context map to send with the invocation.
     **/
    public void init(String prefix, LogMessage[] logMessages, java.util.Map<String, String> context);

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     *
     * @param prefix The prefix of the associated local Logger.
     *
     * @param logMessages Old log messages generated before "now".
     *
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_init(String prefix, LogMessage[] logMessages);

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     *
     * @param prefix The prefix of the associated local Logger.
     *
     * @param logMessages Old log messages generated before "now".
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_init(String prefix, LogMessage[] logMessages, java.util.Map<String, String> context);

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     *
     * @param prefix The prefix of the associated local Logger.
     *
     * @param logMessages Old log messages generated before "now".
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_init(String prefix, LogMessage[] logMessages, Callback cb);

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     *
     * @param prefix The prefix of the associated local Logger.
     *
     * @param logMessages Old log messages generated before "now".
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_init(String prefix, LogMessage[] logMessages, java.util.Map<String, String> context, Callback cb);

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     *
     * @param prefix The prefix of the associated local Logger.
     *
     * @param logMessages Old log messages generated before "now".
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_init(String prefix, LogMessage[] logMessages, Callback_RemoteLogger_init cb);

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     *
     * @param prefix The prefix of the associated local Logger.
     *
     * @param logMessages Old log messages generated before "now".
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_init(String prefix, LogMessage[] logMessages, java.util.Map<String, String> context, Callback_RemoteLogger_init cb);

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     *
     * @param prefix The prefix of the associated local Logger.
     *
     * @param logMessages Old log messages generated before "now".
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_init(String prefix,
                                      LogMessage[] logMessages,
                                      IceInternal.Functional_VoidCallback responseCb,
                                      IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     *
     * @param prefix The prefix of the associated local Logger.
     *
     * @param logMessages Old log messages generated before "now".
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_init(String prefix,
                                      LogMessage[] logMessages,
                                      IceInternal.Functional_VoidCallback responseCb,
                                      IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                      IceInternal.Functional_BoolCallback sentCb);

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     *
     * @param prefix The prefix of the associated local Logger.
     *
     * @param logMessages Old log messages generated before "now".
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_init(String prefix,
                                      LogMessage[] logMessages,
                                      java.util.Map<String, String> context,
                                      IceInternal.Functional_VoidCallback responseCb,
                                      IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     *
     * @param prefix The prefix of the associated local Logger.
     *
     * @param logMessages Old log messages generated before "now".
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_init(String prefix,
                                      LogMessage[] logMessages,
                                      java.util.Map<String, String> context,
                                      IceInternal.Functional_VoidCallback responseCb,
                                      IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                      IceInternal.Functional_BoolCallback sentCb);

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     *
     * @param result The asynchronous result object.
     **/
    public void end_init(Ice.AsyncResult result);

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     *
     * @param message The message to log.
     *
     **/
    public void log(LogMessage message);

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     *
     * @param message The message to log.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void log(LogMessage message, java.util.Map<String, String> context);

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     *
     * @param message The message to log.
     *
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_log(LogMessage message);

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     *
     * @param message The message to log.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_log(LogMessage message, java.util.Map<String, String> context);

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     *
     * @param message The message to log.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_log(LogMessage message, Callback cb);

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     *
     * @param message The message to log.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_log(LogMessage message, java.util.Map<String, String> context, Callback cb);

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     *
     * @param message The message to log.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_log(LogMessage message, Callback_RemoteLogger_log cb);

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     *
     * @param message The message to log.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_log(LogMessage message, java.util.Map<String, String> context, Callback_RemoteLogger_log cb);

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     *
     * @param message The message to log.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_log(LogMessage message,
                                     IceInternal.Functional_VoidCallback responseCb,
                                     IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     *
     * @param message The message to log.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_log(LogMessage message,
                                     IceInternal.Functional_VoidCallback responseCb,
                                     IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                     IceInternal.Functional_BoolCallback sentCb);

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     *
     * @param message The message to log.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_log(LogMessage message,
                                     java.util.Map<String, String> context,
                                     IceInternal.Functional_VoidCallback responseCb,
                                     IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     *
     * @param message The message to log.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_log(LogMessage message,
                                     java.util.Map<String, String> context,
                                     IceInternal.Functional_VoidCallback responseCb,
                                     IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                     IceInternal.Functional_BoolCallback sentCb);

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     *
     * @param result The asynchronous result object.
     **/
    public void end_log(Ice.AsyncResult result);
}
