/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.jira;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xpack.core.watcher.actions.Action;
import org.elasticsearch.xpack.core.watcher.actions.ExecutableAction;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.actions.jira.JiraAction;
import org.elasticsearch.xpack.watcher.common.text.TextTemplate;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.notification.jira.JiraAccount;
import org.elasticsearch.xpack.watcher.notification.jira.JiraIssue;
import org.elasticsearch.xpack.watcher.notification.jira.JiraService;
import org.elasticsearch.xpack.watcher.support.Variables;

public class ExecutableJiraAction
extends ExecutableAction<JiraAction> {
    private final TextTemplateEngine engine;
    private final JiraService jiraService;

    public ExecutableJiraAction(JiraAction action, Logger logger, JiraService jiraService, TextTemplateEngine templateEngine) {
        super((Action)action, logger);
        this.jiraService = jiraService;
        this.engine = templateEngine;
    }

    public Action.Result execute(String actionId, WatchExecutionContext ctx, Payload payload) throws Exception {
        JiraAccount account = (JiraAccount)this.jiraService.getAccount(((JiraAction)this.action).account);
        if (account == null) {
            throw new IllegalStateException("account [" + ((JiraAction)this.action).account + "] was not found. perhaps it was deleted");
        }
        Function<String, String> render = s -> this.engine.render(new TextTemplate((String)s), Variables.createCtxModel(ctx, payload));
        Map<String, Object> fields = new HashMap<String, Object>();
        fields = ExecutableJiraAction.merge(fields, ((JiraAction)this.action).fields, render);
        fields = ExecutableJiraAction.merge(fields, account.getDefaults(), render);
        if (ctx.simulateAction(actionId)) {
            return new JiraAction.Simulated(fields);
        }
        JiraIssue result = account.createIssue(fields, ((JiraAction)this.action).proxy);
        return new JiraAction.Executed(result);
    }

    static Map<String, Object> merge(Map<String, Object> fields, Map<String, ?> defaults, Function<String, String> fn) {
        if (defaults != null) {
            for (Map.Entry<String, ?> defaultEntry : defaults.entrySet()) {
                String key;
                Object newValues;
                Object value = defaultEntry.getValue();
                if (value instanceof String) {
                    value = fn.apply((String)value);
                } else if (value instanceof Map) {
                    value = ExecutableJiraAction.merge(new HashMap<String, Object>(), (Map)value, fn);
                } else if (value instanceof String[]) {
                    newValues = new String[((String[])value).length];
                    for (int i = 0; i < ((String[])newValues).length; ++i) {
                        newValues[i] = fn.apply(((String[])value)[i]);
                    }
                    value = newValues;
                } else if (value instanceof List) {
                    newValues = new ArrayList(((List)value).size());
                    for (Object v : (List)value) {
                        if (v instanceof String) {
                            newValues.add(fn.apply((String)v));
                            continue;
                        }
                        newValues.add(v);
                    }
                    value = newValues;
                }
                if (fields.containsKey(key = fn.apply(defaultEntry.getKey()))) continue;
                fields.put(key, value);
            }
        }
        return fields;
    }
}

