/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.parser;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.Alias;
import org.elasticsearch.xpack.sql.expression.Exists;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.expression.Order;
import org.elasticsearch.xpack.sql.expression.ScalarSubquery;
import org.elasticsearch.xpack.sql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.sql.expression.UnresolvedStar;
import org.elasticsearch.xpack.sql.expression.function.Function;
import org.elasticsearch.xpack.sql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.Cast;
import org.elasticsearch.xpack.sql.expression.function.scalar.arithmetic.Add;
import org.elasticsearch.xpack.sql.expression.function.scalar.arithmetic.Div;
import org.elasticsearch.xpack.sql.expression.function.scalar.arithmetic.Mod;
import org.elasticsearch.xpack.sql.expression.function.scalar.arithmetic.Mul;
import org.elasticsearch.xpack.sql.expression.function.scalar.arithmetic.Neg;
import org.elasticsearch.xpack.sql.expression.function.scalar.arithmetic.Sub;
import org.elasticsearch.xpack.sql.expression.predicate.And;
import org.elasticsearch.xpack.sql.expression.predicate.Equals;
import org.elasticsearch.xpack.sql.expression.predicate.GreaterThan;
import org.elasticsearch.xpack.sql.expression.predicate.GreaterThanOrEqual;
import org.elasticsearch.xpack.sql.expression.predicate.In;
import org.elasticsearch.xpack.sql.expression.predicate.IsNotNull;
import org.elasticsearch.xpack.sql.expression.predicate.LessThan;
import org.elasticsearch.xpack.sql.expression.predicate.LessThanOrEqual;
import org.elasticsearch.xpack.sql.expression.predicate.Not;
import org.elasticsearch.xpack.sql.expression.predicate.Or;
import org.elasticsearch.xpack.sql.expression.predicate.Range;
import org.elasticsearch.xpack.sql.expression.predicate.fulltext.MatchQueryPredicate;
import org.elasticsearch.xpack.sql.expression.predicate.fulltext.MultiMatchQueryPredicate;
import org.elasticsearch.xpack.sql.expression.predicate.fulltext.StringQueryPredicate;
import org.elasticsearch.xpack.sql.expression.regex.Like;
import org.elasticsearch.xpack.sql.expression.regex.LikePattern;
import org.elasticsearch.xpack.sql.expression.regex.RLike;
import org.elasticsearch.xpack.sql.parser.IdentifierBuilder;
import org.elasticsearch.xpack.sql.parser.ParsingException;
import org.elasticsearch.xpack.sql.parser.SqlBaseParser;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;
import org.elasticsearch.xpack.sql.type.DataTypes;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

abstract class ExpressionBuilder
extends IdentifierBuilder {
    private final Map<Token, SqlTypedParamValue> params;

    ExpressionBuilder(Map<Token, SqlTypedParamValue> params) {
        this.params = params;
    }

    protected Expression expression(ParseTree ctx) {
        return this.typedParsing(ctx, Expression.class);
    }

    protected List<Expression> expressions(List<? extends ParserRuleContext> contexts) {
        return this.visitList(contexts, Expression.class);
    }

    @Override
    public Expression visitSingleExpression(SqlBaseParser.SingleExpressionContext ctx) {
        return this.expression((ParseTree)ctx.expression());
    }

    @Override
    public Expression visitSelectExpression(SqlBaseParser.SelectExpressionContext ctx) {
        Expression exp = this.expression((ParseTree)ctx.expression());
        String alias = this.visitIdentifier(ctx.identifier());
        if (alias != null) {
            exp = new Alias(ExpressionBuilder.source(ctx), alias, exp);
        }
        return exp;
    }

    @Override
    public Expression visitStar(SqlBaseParser.StarContext ctx) {
        return new UnresolvedStar(ExpressionBuilder.source(ctx), ctx.qualifiedName() != null ? new UnresolvedAttribute(ExpressionBuilder.source(ctx.qualifiedName()), this.visitQualifiedName(ctx.qualifiedName())) : null);
    }

    @Override
    public Object visitColumnReference(SqlBaseParser.ColumnReferenceContext ctx) {
        return new UnresolvedAttribute(ExpressionBuilder.source(ctx), this.visitIdentifier(ctx.identifier()));
    }

    @Override
    public Object visitDereference(SqlBaseParser.DereferenceContext ctx) {
        return new UnresolvedAttribute(ExpressionBuilder.source(ctx), this.visitQualifiedName(ctx.qualifiedName()));
    }

    @Override
    public Expression visitExists(SqlBaseParser.ExistsContext ctx) {
        return new Exists(ExpressionBuilder.source(ctx), this.plan((ParseTree)ctx.query()));
    }

    @Override
    public Expression visitComparison(SqlBaseParser.ComparisonContext ctx) {
        Expression left = this.expression((ParseTree)ctx.left);
        Expression right = this.expression((ParseTree)ctx.right);
        TerminalNode op = (TerminalNode)ctx.comparisonOperator().getChild(0);
        Location loc = ExpressionBuilder.source(ctx);
        switch (op.getSymbol().getType()) {
            case 80: {
                return new Equals(loc, left, right);
            }
            case 81: {
                return new Not(loc, new Equals(loc, left, right));
            }
            case 82: {
                return new LessThan(loc, left, right);
            }
            case 83: {
                return new LessThanOrEqual(loc, left, right);
            }
            case 84: {
                return new GreaterThan(loc, left, right);
            }
            case 85: {
                return new GreaterThanOrEqual(loc, left, right);
            }
        }
        throw new ParsingException(loc, "Unknown operator {}", op.getSymbol().getText());
    }

    @Override
    public Expression visitPredicated(SqlBaseParser.PredicatedContext ctx) {
        Expression exp = this.expression((ParseTree)ctx.valueExpression());
        if (ctx.predicate() == null) {
            return exp;
        }
        SqlBaseParser.PredicateContext pCtx = ctx.predicate();
        Location loc = ExpressionBuilder.source(pCtx);
        Expression e = null;
        switch (pCtx.kind.getType()) {
            case 12: {
                e = new Range(loc, exp, this.expression((ParseTree)pCtx.lower), true, this.expression((ParseTree)pCtx.upper), true);
                break;
            }
            case 35: {
                if (pCtx.query() != null) {
                    throw new ParsingException(loc, "IN query not supported yet", new Object[0]);
                }
                e = new In(loc, exp, this.expressions(pCtx.expression()));
                break;
            }
            case 40: {
                e = new Like(loc, exp, this.visitPattern(pCtx.pattern()));
                break;
            }
            case 56: {
                e = new RLike(loc, exp, new Literal(ExpressionBuilder.source(pCtx.regex), this.string(pCtx.regex), DataType.KEYWORD));
                break;
            }
            case 46: {
                e = new IsNotNull(loc, exp);
                return pCtx.NOT() != null ? e : new Not(loc, e);
            }
            default: {
                throw new ParsingException(loc, "Unknown predicate {}", pCtx.kind.getText());
            }
        }
        return pCtx.NOT() != null ? new Not(loc, e) : e;
    }

    @Override
    public LikePattern visitPattern(SqlBaseParser.PatternContext ctx) {
        String escapeString;
        if (ctx == null) {
            return null;
        }
        String pattern = this.string(ctx.value);
        int pos = pattern.indexOf(42);
        if (pos >= 0) {
            throw new ParsingException(ExpressionBuilder.source(ctx.value), "Invalid char [*] found in pattern [{}] at position {}; use [%] or [_] instead", pattern, pos);
        }
        char escape = '\u0000';
        SqlBaseParser.PatternEscapeContext escapeCtx = ctx.patternEscape();
        String string = escapeString = escapeCtx == null ? null : this.string(escapeCtx.escape);
        if (Strings.hasText((String)escapeString)) {
            if (escapeString.length() > 1) {
                throw new ParsingException(ExpressionBuilder.source(escapeCtx), "A character not a string required for escaping; found [{}]", escapeString);
            }
            if (escapeString.length() == 1) {
                escape = escapeString.charAt(0);
                if (escape == '*' || escape == '%' || escape == '_') {
                    throw new ParsingException(ExpressionBuilder.source(escapeCtx.escape), "Char [{}] cannot be used for escaping", Character.valueOf(escape));
                }
                for (int i = 0; i < pattern.length(); ++i) {
                    char current = pattern.charAt(i);
                    if (current != escape) continue;
                    if (i + 1 == pattern.length()) {
                        throw new ParsingException(ExpressionBuilder.source(ctx.value), "Pattern [{}] is invalid as escape char [{}] at position {} does not escape anything", pattern, Character.valueOf(escape), i);
                    }
                    char next = pattern.charAt(i + 1);
                    if (next == '%' || next == '_') continue;
                    throw new ParsingException(ExpressionBuilder.source(ctx.value), "Pattern [{}] is invalid as escape char [{}] at position {} can only escape wildcard chars; found [{}]", pattern, Character.valueOf(escape), i, Character.valueOf(next));
                }
            }
        }
        return new LikePattern(ExpressionBuilder.source(ctx), pattern, escape);
    }

    @Override
    public Object visitArithmeticUnary(SqlBaseParser.ArithmeticUnaryContext ctx) {
        Expression value = this.expression((ParseTree)ctx.valueExpression());
        Location loc = ExpressionBuilder.source(ctx);
        switch (ctx.operator.getType()) {
            case 86: {
                return value;
            }
            case 87: {
                return new Neg(ExpressionBuilder.source(ctx.operator), value);
            }
        }
        throw new ParsingException(loc, "Unknown arithemtic {}", ctx.operator.getText());
    }

    @Override
    public Object visitArithmeticBinary(SqlBaseParser.ArithmeticBinaryContext ctx) {
        Expression left = this.expression((ParseTree)ctx.left);
        Expression right = this.expression((ParseTree)ctx.right);
        Location loc = ExpressionBuilder.source(ctx.operator);
        switch (ctx.operator.getType()) {
            case 88: {
                return new Mul(loc, left, right);
            }
            case 89: {
                return new Div(loc, left, right);
            }
            case 90: {
                return new Mod(loc, left, right);
            }
            case 86: {
                return new Add(loc, left, right);
            }
            case 87: {
                return new Sub(loc, left, right);
            }
        }
        throw new ParsingException(loc, "Unknown arithemtic {}", ctx.operator.getText());
    }

    @Override
    public Object visitStringQuery(SqlBaseParser.StringQueryContext ctx) {
        return new StringQueryPredicate(ExpressionBuilder.source(ctx), this.string(ctx.queryString), this.string(ctx.options));
    }

    @Override
    public Object visitMatchQuery(SqlBaseParser.MatchQueryContext ctx) {
        return new MatchQueryPredicate(ExpressionBuilder.source(ctx), new UnresolvedAttribute(ExpressionBuilder.source(ctx.singleField), this.visitQualifiedName(ctx.singleField)), this.string(ctx.queryString), this.string(ctx.options));
    }

    @Override
    public Object visitMultiMatchQuery(SqlBaseParser.MultiMatchQueryContext ctx) {
        return new MultiMatchQueryPredicate(ExpressionBuilder.source(ctx), this.string(ctx.multiFields), this.string(ctx.queryString), this.string(ctx.options));
    }

    @Override
    public Order visitOrderBy(SqlBaseParser.OrderByContext ctx) {
        return new Order(ExpressionBuilder.source(ctx), this.expression((ParseTree)ctx.expression()), ctx.DESC() != null ? Order.OrderDirection.DESC : Order.OrderDirection.ASC);
    }

    @Override
    public DataType visitPrimitiveDataType(SqlBaseParser.PrimitiveDataTypeContext ctx) {
        String type;
        switch (type = this.visitIdentifier(ctx.identifier()).toLowerCase(Locale.ROOT)) {
            case "bit": 
            case "bool": 
            case "boolean": {
                return DataType.BOOLEAN;
            }
            case "tinyint": 
            case "byte": {
                return DataType.BYTE;
            }
            case "smallint": 
            case "short": {
                return DataType.SHORT;
            }
            case "int": 
            case "integer": {
                return DataType.INTEGER;
            }
            case "long": 
            case "bigint": {
                return DataType.LONG;
            }
            case "real": {
                return DataType.FLOAT;
            }
            case "float": 
            case "double": {
                return DataType.DOUBLE;
            }
            case "date": 
            case "timestamp": {
                return DataType.DATE;
            }
            case "char": 
            case "varchar": 
            case "string": {
                return DataType.KEYWORD;
            }
        }
        throw new ParsingException(ExpressionBuilder.source(ctx), "Does not recognize type {}", type);
    }

    @Override
    public Cast visitCastExpression(SqlBaseParser.CastExpressionContext ctx) {
        SqlBaseParser.CastTemplateContext ctc = ctx.castTemplate();
        return new Cast(ExpressionBuilder.source(ctc), this.expression((ParseTree)ctc.expression()), this.typedParsing((ParseTree)ctc.dataType(), DataType.class));
    }

    @Override
    public Function visitExtractExpression(SqlBaseParser.ExtractExpressionContext ctx) {
        SqlBaseParser.ExtractTemplateContext template = ctx.extractTemplate();
        String fieldString = this.visitIdentifier(template.field);
        return new UnresolvedFunction(ExpressionBuilder.source(template), fieldString, UnresolvedFunction.ResolutionType.EXTRACT, Collections.singletonList(this.expression((ParseTree)template.valueExpression())));
    }

    @Override
    public Function visitFunctionExpression(SqlBaseParser.FunctionExpressionContext ctx) {
        SqlBaseParser.FunctionTemplateContext template = ctx.functionTemplate();
        String name = template.functionName().getText();
        boolean isDistinct = template.setQuantifier() != null && template.setQuantifier().DISTINCT() != null;
        UnresolvedFunction.ResolutionType resolutionType = isDistinct ? UnresolvedFunction.ResolutionType.DISTINCT : UnresolvedFunction.ResolutionType.STANDARD;
        return new UnresolvedFunction(ExpressionBuilder.source(ctx), name, resolutionType, this.expressions(template.expression()));
    }

    @Override
    public Expression visitSubqueryExpression(SqlBaseParser.SubqueryExpressionContext ctx) {
        return new ScalarSubquery(ExpressionBuilder.source(ctx), this.plan((ParseTree)ctx.query()));
    }

    @Override
    public Expression visitParenthesizedExpression(SqlBaseParser.ParenthesizedExpressionContext ctx) {
        return this.expression((ParseTree)ctx.expression());
    }

    @Override
    public Object visitLogicalNot(SqlBaseParser.LogicalNotContext ctx) {
        return new Not(ExpressionBuilder.source(ctx), this.expression((ParseTree)ctx.booleanExpression()));
    }

    @Override
    public Object visitLogicalBinary(SqlBaseParser.LogicalBinaryContext ctx) {
        int type = ctx.operator.getType();
        Location loc = ExpressionBuilder.source(ctx);
        Expression left = this.expression((ParseTree)ctx.left);
        Expression right = this.expression((ParseTree)ctx.right);
        if (type == 8) {
            return new And(loc, left, right);
        }
        if (type == 49) {
            return new Or(loc, left, right);
        }
        throw new ParsingException(loc, "Don't know how to parse {}", new Object[]{ctx});
    }

    @Override
    public Expression visitNullLiteral(SqlBaseParser.NullLiteralContext ctx) {
        return new Literal(ExpressionBuilder.source(ctx), null, DataType.NULL);
    }

    @Override
    public Expression visitBooleanLiteral(SqlBaseParser.BooleanLiteralContext ctx) {
        return new Literal(ExpressionBuilder.source(ctx), Booleans.parseBoolean((String)ctx.getText().toLowerCase(Locale.ROOT), (boolean)false), DataType.BOOLEAN);
    }

    @Override
    public Expression visitStringLiteral(SqlBaseParser.StringLiteralContext ctx) {
        StringBuilder sb = new StringBuilder();
        for (TerminalNode node : ctx.STRING()) {
            sb.append(ExpressionBuilder.unquoteString(ExpressionBuilder.text((ParseTree)node)));
        }
        return new Literal(ExpressionBuilder.source(ctx), sb.toString(), DataType.KEYWORD);
    }

    @Override
    public Literal visitDecimalLiteral(SqlBaseParser.DecimalLiteralContext ctx) {
        return new Literal(ExpressionBuilder.source(ctx), new BigDecimal(ctx.getText()).doubleValue(), DataType.DOUBLE);
    }

    @Override
    public Literal visitIntegerLiteral(SqlBaseParser.IntegerLiteralContext ctx) {
        BigDecimal bigD = new BigDecimal(ctx.getText());
        long value = bigD.longValueExact();
        DataType type = DataType.LONG;
        if ((long)((int)value) == value) {
            type = DataType.INTEGER;
        }
        return new Literal(ExpressionBuilder.source(ctx), value, type);
    }

    @Override
    public Literal visitParamLiteral(SqlBaseParser.ParamLiteralContext ctx) {
        DataType sourceType;
        SqlTypedParamValue param = this.param(ctx.PARAM());
        Location loc = ExpressionBuilder.source(ctx);
        if (param.value == null) {
            return new Literal(loc, null, param.dataType);
        }
        try {
            sourceType = DataTypes.fromJava(param.value);
        }
        catch (SqlIllegalArgumentException ex) {
            throw new ParsingException((Exception)((Object)ex), loc, "Unexpected actual parameter type [{}] for type [{}]", param.value.getClass().getName(), param.dataType);
        }
        if (sourceType == param.dataType) {
            return new Literal(loc, param.value, param.dataType);
        }
        try {
            return new Literal(loc, DataTypeConversion.conversionFor(sourceType, param.dataType).convert(param.value), param.dataType);
        }
        catch (SqlIllegalArgumentException ex) {
            throw new ParsingException((Exception)((Object)ex), loc, "Unexpected actual parameter type [{}] for type [{}]", sourceType, param.dataType);
        }
    }

    @Override
    public String visitString(SqlBaseParser.StringContext ctx) {
        return this.string(ctx);
    }

    String string(SqlBaseParser.StringContext ctx) {
        if (ctx == null) {
            return null;
        }
        SqlTypedParamValue param = this.param(ctx.PARAM());
        if (param != null) {
            return param.value != null ? param.value.toString() : null;
        }
        return ExpressionBuilder.unquoteString(ctx.getText());
    }

    private SqlTypedParamValue param(TerminalNode node) {
        if (node == null) {
            return null;
        }
        Token token = node.getSymbol();
        if (!this.params.containsKey(token)) {
            throw new ParsingException(ExpressionBuilder.source(node), "Unexpected parameter", new Object[0]);
        }
        return this.params.get(token);
    }

    @Override
    public Literal visitDateEscapedLiteral(SqlBaseParser.DateEscapedLiteralContext ctx) {
        String string = this.string(ctx.string());
        Location loc = ExpressionBuilder.source(ctx);
        DateTime dt = null;
        try {
            dt = ISODateTimeFormat.date().parseDateTime(string);
        }
        catch (IllegalArgumentException ex) {
            throw new ParsingException(loc, "Invalid date received; {}", ex.getMessage());
        }
        return new Literal(loc, dt, DataType.DATE);
    }

    @Override
    public Literal visitTimeEscapedLiteral(SqlBaseParser.TimeEscapedLiteralContext ctx) {
        String string = this.string(ctx.string());
        Location loc = ExpressionBuilder.source(ctx);
        DateTime dt = null;
        try {
            dt = ISODateTimeFormat.hourMinuteSecond().parseDateTime(string);
        }
        catch (IllegalArgumentException ex) {
            throw new ParsingException(loc, "Invalid time received; {}", ex.getMessage());
        }
        throw new SqlIllegalArgumentException("Time (only) literals are not supported; a date component is required as well");
    }

    @Override
    public Literal visitTimestampEscapedLiteral(SqlBaseParser.TimestampEscapedLiteralContext ctx) {
        String string = this.string(ctx.string());
        Location loc = ExpressionBuilder.source(ctx);
        DateTime dt = null;
        try {
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).appendLiteral(" ").append(ISODateTimeFormat.hourMinuteSecondFraction()).toFormatter();
            dt = formatter.parseDateTime(string);
        }
        catch (IllegalArgumentException ex) {
            throw new ParsingException(loc, "Invalid timestamp received; {}", ex.getMessage());
        }
        return new Literal(loc, dt, DataType.DATE);
    }

    @Override
    public Literal visitGuidEscapedLiteral(SqlBaseParser.GuidEscapedLiteralContext ctx) {
        int[] separatorPos;
        String string = this.string(ctx.string());
        Location loc = ExpressionBuilder.source(ctx.string());
        String lowerCase = string.toLowerCase(Locale.ROOT);
        String errorPrefix = "Invalid GUID, ";
        if (lowerCase.length() != 36) {
            throw new ParsingException(loc, "{}too {}", errorPrefix, lowerCase.length() > 36 ? "long" : "short");
        }
        for (int pos : separatorPos = new int[]{8, 13, 18, 23}) {
            if (lowerCase.charAt(pos) == '-') continue;
            throw new ParsingException(loc, "{}expected group separator at offset [{}], found [{}]", errorPrefix, pos, Character.valueOf(string.charAt(pos)));
        }
        String HEXA = "0123456789abcdef";
        for (int i = 0; i < lowerCase.length(); ++i) {
            boolean inspect = true;
            for (int pos : separatorPos) {
                if (i == pos) {
                    inspect = false;
                    break;
                }
                if (pos > i) break;
            }
            if (!inspect || HEXA.indexOf(lowerCase.charAt(i)) >= 0) continue;
            throw new ParsingException(loc, "{}expected hexadecimal at offset[{}], found [{}]", errorPrefix, i, Character.valueOf(string.charAt(i)));
        }
        return new Literal(ExpressionBuilder.source(ctx), string, DataType.KEYWORD);
    }
}

