/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.privilege;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;

public final class ApplicationPrivilege
extends Privilege {
    private static final Pattern VALID_APPLICATION_PREFIX = Pattern.compile("^[a-z][A-Za-z0-9]*$");
    private static final Pattern WHITESPACE = Pattern.compile("[\\v\\h]");
    private static final Pattern VALID_NAME = Pattern.compile("^[a-z][a-zA-Z0-9_.-]*$");
    private static final Pattern VALID_NAME_OR_ACTION = Pattern.compile("^\\p{Graph}*$");
    public static final Function<String, ApplicationPrivilege> NONE = app -> new ApplicationPrivilege((String)app, "none", new String[0]);
    private final String application;
    private final String[] patterns;

    public ApplicationPrivilege(String application, String privilegeName, String ... patterns) {
        this(application, Collections.singleton(privilegeName), patterns);
    }

    public ApplicationPrivilege(String application, Set<String> name, String ... patterns) {
        super(name, patterns);
        this.application = application;
        this.patterns = patterns;
    }

    public String getApplication() {
        return this.application;
    }

    String[] getPatterns() {
        return this.patterns;
    }

    public static void validateApplicationName(String application) {
        ApplicationPrivilege.validateApplicationName(application, false);
    }

    public static void validateApplicationNameOrWildcard(String application) {
        ApplicationPrivilege.validateApplicationName(application, true);
    }

    private static void validateApplicationName(String application, boolean allowWildcard) {
        String suffix;
        if (Strings.isEmpty((CharSequence)application)) {
            throw new IllegalArgumentException("Application names cannot be blank");
        }
        int asterisk = application.indexOf(42);
        if (asterisk != -1) {
            if (!allowWildcard) {
                throw new IllegalArgumentException("Application names may not contain '*' (found '" + application + "')");
            }
            if (application.equals("*")) {
                return;
            }
            if (asterisk != application.length() - 1) {
                throw new IllegalArgumentException("Application name patterns only support trailing wildcards (found '" + application + "')");
            }
        }
        if (WHITESPACE.matcher(application).find()) {
            throw new IllegalArgumentException("Application names may not contain whitespace (found '" + application + "')");
        }
        String[] parts = application.split("[_-]", 2);
        String prefix = parts[0];
        if (prefix.endsWith("*")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (!VALID_APPLICATION_PREFIX.matcher(prefix).matches()) {
            throw new IllegalArgumentException("An application name prefix must match the pattern " + VALID_APPLICATION_PREFIX.pattern() + " (found '" + prefix + "')");
        }
        if (prefix.length() < 3 && asterisk == -1) {
            throw new IllegalArgumentException("An application name prefix must be at least 3 characters long (found '" + prefix + "')");
        }
        if (parts.length > 1 && !Strings.validFileName((String)(suffix = parts[1]))) {
            throw new IllegalArgumentException("An application name suffix may not contain any of the characters '" + Strings.collectionToDelimitedString((Iterable)Strings.INVALID_FILENAME_CHARS, (String)"") + "' (found '" + suffix + "')");
        }
    }

    public static void validatePrivilegeName(String name) {
        if (!ApplicationPrivilege.isValidPrivilegeName(name)) {
            throw new IllegalArgumentException("Application privilege names must match the pattern " + VALID_NAME.pattern() + " (found '" + name + "')");
        }
    }

    private static boolean isValidPrivilegeName(String name) {
        return VALID_NAME.matcher(name).matches();
    }

    public static void validatePrivilegeOrActionName(String name) {
        if (!VALID_NAME_OR_ACTION.matcher(name).matches()) {
            throw new IllegalArgumentException("Application privilege names and actions must match the pattern " + VALID_NAME_OR_ACTION.pattern() + " (found '" + name + "')");
        }
    }

    public static ApplicationPrivilege get(String application, Set<String> name, Collection<ApplicationPrivilegeDescriptor> stored) {
        if (name.isEmpty()) {
            return NONE.apply(application);
        }
        Map<String, ApplicationPrivilegeDescriptor> lookup = stored.stream().filter(apd -> apd.getApplication().equals(application)).collect(Collectors.toMap(ApplicationPrivilegeDescriptor::getName, Function.identity()));
        return ApplicationPrivilege.resolve(application, name, lookup);
    }

    private static ApplicationPrivilege resolve(String application, Set<String> names, Map<String, ApplicationPrivilegeDescriptor> lookup) {
        int size = names.size();
        if (size == 0) {
            throw new IllegalArgumentException("empty set should not be used");
        }
        HashSet<String> actions = new HashSet<String>();
        HashSet<String> patterns = new HashSet<String>();
        for (String name : names) {
            if (ApplicationPrivilege.isValidPrivilegeName(name)) {
                ApplicationPrivilegeDescriptor descriptor = lookup.get(name);
                if (descriptor == null) continue;
                patterns.addAll(descriptor.getActions());
                continue;
            }
            actions.add(name);
        }
        patterns.addAll(actions);
        return new ApplicationPrivilege(application, names, patterns.toArray(new String[patterns.size()]));
    }

    @Override
    public String toString() {
        return this.application + ":" + super.toString() + "(" + Strings.arrayToCommaDelimitedString((Object[])this.patterns) + ")";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.application);
        result = 31 * result + Arrays.hashCode(this.patterns);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Objects.equals(this.application, ((ApplicationPrivilege)o).application) && Arrays.equals(this.patterns, ((ApplicationPrivilege)o).patterns);
    }
}

