/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.action;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.gradle.api.GradleException;
import org.gradle.api.publication.maven.internal.action.LoggingMavenTransferListener;
import org.gradle.api.publication.maven.internal.action.MavenPublishAction;
import org.gradle.api.publication.maven.internal.action.SnapshotVersionManager;
import org.gradle.api.publish.maven.internal.publisher.MavenProjectIdentity;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.sonatype.aether.RepositoryException;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactType;
import org.sonatype.aether.impl.Deployer;
import org.sonatype.aether.impl.MetadataGeneratorFactory;
import org.sonatype.aether.impl.internal.DefaultDeployer;
import org.sonatype.aether.impl.internal.SimpleLocalRepositoryManager;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.aether.util.artifact.DefaultArtifact;

abstract class AbstractMavenPublishAction
implements MavenPublishAction {
    private final PlexusContainer container;
    private final DefaultRepositorySystemSession session;
    private final MavenProjectIdentity projectIdentity;
    private final List<Artifact> attached = new ArrayList<Artifact>();
    private Artifact pomArtifact;
    private Artifact mainArtifact;
    private SnapshotVersionManager snapshotVersionManager = new SnapshotVersionManager();

    protected AbstractMavenPublishAction(String packaging, MavenProjectIdentity projectIdentity, List<File> wagonJars) {
        this.container = this.newPlexusContainer(wagonJars);
        this.session = new MavenRepositorySystemSession();
        this.projectIdentity = projectIdentity;
        CurrentBuildOperationRef currentBuildOperationRef = CurrentBuildOperationRef.instance();
        BuildOperationRef currentBuildOperation = currentBuildOperationRef.get();
        this.session.setTransferListener((TransferListener)new LoggingMavenTransferListener(currentBuildOperationRef, currentBuildOperation));
        this.pomArtifact = new DefaultArtifact((String)projectIdentity.getGroupId().get(), (String)projectIdentity.getArtifactId().get(), "pom", (String)projectIdentity.getVersion().get());
        this.mainArtifact = this.createTypedArtifact(packaging, null);
    }

    public void setLocalMavenRepositoryLocation(File localMavenRepository) {
        this.session.setLocalRepositoryManager((LocalRepositoryManager)new SimpleLocalRepositoryManager(localMavenRepository));
    }

    public void produceLegacyMavenMetadata() {
        this.session.getConfigProperties().put("maven.metadata.legacy", "true");
    }

    @Override
    public void setPomArtifact(File file) {
        this.pomArtifact = this.pomArtifact.setFile(file);
    }

    @Override
    public void setMainArtifact(File file) {
        this.mainArtifact = this.mainArtifact.setFile(file);
    }

    @Override
    public void addAdditionalArtifact(File file, String type, String classifier) {
        this.attached.add(this.createTypedArtifact(type, classifier).setFile(file));
    }

    @Override
    public void publish() {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        if (this.mainArtifact.getFile() != null) {
            artifacts.add(this.mainArtifact);
        }
        artifacts.add(this.pomArtifact);
        for (Artifact artifact : this.attached) {
            File file = artifact.getFile();
            if (file == null || !file.isFile()) continue;
            artifacts.add(artifact);
        }
        try {
            this.publishArtifacts(artifacts, this.newRepositorySystem(), (RepositorySystemSession)this.session);
        }
        catch (RepositoryException e) {
            throw new GradleException(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract void publishArtifacts(Collection<Artifact> var1, RepositorySystem var2, RepositorySystemSession var3) throws RepositoryException;

    protected PlexusContainer getContainer() {
        return this.container;
    }

    private PlexusContainer newPlexusContainer(List<File> wagonJars) {
        try {
            ClassWorld world = new ClassWorld("plexus.core", ClassWorld.class.getClassLoader());
            ClassRealm classRealm = new ClassRealm(world, "plexus.core", ClassWorld.class.getClassLoader());
            if (wagonJars != null) {
                for (File jar : wagonJars) {
                    classRealm.addURL(jar.toURI().toURL());
                }
            }
            return new DefaultPlexusContainer(new DefaultContainerConfiguration().setRealm(classRealm));
        }
        catch (PlexusContainerException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private RepositorySystem newRepositorySystem() {
        try {
            DefaultDeployer deployer = (DefaultDeployer)this.getContainer().lookup(Deployer.class);
            deployer.setMetadataFactories(null);
            deployer.addMetadataGeneratorFactory((MetadataGeneratorFactory)new VersionsMetadataGeneratorFactory());
            deployer.addMetadataGeneratorFactory((MetadataGeneratorFactory)new SnapshotMetadataGeneratorFactory());
            deployer.addMetadataGeneratorFactory((MetadataGeneratorFactory)this.snapshotVersionManager);
            return (RepositorySystem)this.container.lookup(RepositorySystem.class);
        }
        catch (ComponentLookupException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private Artifact createTypedArtifact(String type, String classifier) {
        String extension = type;
        ArtifactType stereotype = this.session.getArtifactTypeRegistry().get(type);
        if (stereotype != null) {
            extension = stereotype.getExtension();
            if (classifier == null) {
                classifier = stereotype.getClassifier();
            }
        }
        return new DefaultArtifact((String)this.projectIdentity.getGroupId().get(), (String)this.projectIdentity.getArtifactId().get(), classifier, extension, (String)this.projectIdentity.getVersion().get());
    }

    public void setUniqueVersion(boolean uniqueVersion) {
        this.snapshotVersionManager.setUniqueVersion(uniqueVersion);
    }
}

