/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.print.Paper;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import org.gjt.sp.jedit.print.BufferPrinter1_7;
import org.gjt.sp.jedit.print.PrintPreviewModel;
import org.gjt.sp.jedit.print.PrintPreviewPane;
import org.gjt.sp.jedit.print.PrintPreviewPaneUI;

public class BasicPrintPreviewPaneUI
extends PrintPreviewPaneUI
implements ChangeListener {
    private PrintPreviewPane printPreviewPane = null;
    private JScrollPane scrollPane = null;
    private PrintPreviewRenderer printPreviewRenderer = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicPrintPreviewPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.printPreviewPane = (PrintPreviewPane)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    public void installDefaults() {
        this.printPreviewPane.setLayout(this.createLayoutManager());
    }

    public void installComponents() {
        this.printPreviewRenderer = new PrintPreviewRenderer();
        this.scrollPane = new JScrollPane(this.printPreviewRenderer);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.printPreviewPane.add((Component)this.scrollPane, "Center");
    }

    public void installListeners() {
        this.printPreviewPane.addChangeListener(this);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.setLayout(null);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.printPreviewPane = null;
    }

    public void uninstallDefaults() {
    }

    public void uninstallComponents() {
        this.printPreviewRenderer = null;
    }

    public void uninstallListeners() {
        this.printPreviewPane.removeChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.printPreviewRenderer != null) {
            this.printPreviewRenderer.setSize(this.printPreviewRenderer.getPreferredSize());
            this.printPreviewRenderer.repaint();
        }
    }

    protected LayoutManager createLayoutManager() {
        return new BorderLayout();
    }

    public class PrintPreviewRenderer
    extends JPanel {
        public Dimension getPaperSize() {
            PrintPreviewModel printPreviewModel = BasicPrintPreviewPaneUI.this.printPreviewPane.getModel();
            if (printPreviewModel != null) {
                PrintRequestAttributeSet printRequestAttributeSet = printPreviewModel.getAttributes();
                float f = printPreviewModel.getZoomLevel();
                Media media = (Media)printRequestAttributeSet.get(Media.class);
                MediaSize mediaSize = null;
                if (media instanceof MediaSizeName) {
                    MediaSizeName mediaSizeName = (MediaSizeName)media;
                    mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
                    int n = 25400;
                    float f2 = 72.0f * f;
                    float f3 = mediaSize.getX(n) * f2;
                    float f4 = mediaSize.getY(n) * f2;
                    Dimension dimension = new Dimension();
                    dimension.setSize(f3, f4);
                    OrientationRequested orientationRequested = (OrientationRequested)printRequestAttributeSet.get(OrientationRequested.class);
                    if ((OrientationRequested.LANDSCAPE.equals(orientationRequested) || OrientationRequested.REVERSE_LANDSCAPE.equals(orientationRequested)) && f3 < f4) {
                        dimension.setSize(dimension.getHeight(), dimension.getWidth());
                    }
                    return dimension;
                }
                Paper paper = printPreviewModel.getPaper();
                Dimension dimension = new Dimension(new Double(paper.getWidth() * (double)f).intValue(), new Double(paper.getHeight() * (double)f).intValue());
                return dimension;
            }
            return this.getSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getPaperSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void paintComponent(Graphics graphics) {
            PrintPreviewModel printPreviewModel = BasicPrintPreviewPaneUI.this.printPreviewPane.getModel();
            if (printPreviewModel == null) {
                return;
            }
            super.paintComponent(graphics);
            Dimension dimension = this.getPaperSize();
            double d = dimension.getWidth();
            double d2 = dimension.getHeight();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, new Double(d).intValue(), new Double(d2).intValue());
            this.updateModel();
            printPreviewModel.setGraphics(graphics);
            BufferPrinter1_7.printPage(printPreviewModel);
            BasicPrintPreviewPaneUI.this.scrollPane.revalidate();
            BasicPrintPreviewPaneUI.this.printPreviewPane.revalidate();
            BasicPrintPreviewPaneUI.this.printPreviewPane.repaint();
        }

        private void updateModel() {
            PrintPreviewModel printPreviewModel = BasicPrintPreviewPaneUI.this.printPreviewPane.getModel();
            if (printPreviewModel == null) {
                return;
            }
            PrintRequestAttributeSet printRequestAttributeSet = printPreviewModel.getAttributes();
            float f = printPreviewModel.getZoomLevel();
            MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(MediaPrintableArea.class);
            int n = 25400;
            double d = 72.0 * (double)f;
            double d2 = (double)mediaPrintableArea.getX(n) * d;
            double d3 = (double)mediaPrintableArea.getY(n) * d;
            double d4 = (double)mediaPrintableArea.getWidth(n) * d;
            double d5 = (double)mediaPrintableArea.getHeight(n) * d;
            Paper paper = new Paper();
            Dimension dimension = this.getPaperSize();
            paper.setSize(dimension.getWidth(), dimension.getHeight());
            int n2 = 1;
            OrientationRequested orientationRequested = (OrientationRequested)printRequestAttributeSet.get(OrientationRequested.class);
            if (OrientationRequested.LANDSCAPE.equals(orientationRequested)) {
                paper.setSize(dimension.getHeight(), dimension.getWidth());
                n2 = 0;
            } else if (OrientationRequested.REVERSE_LANDSCAPE.equals(orientationRequested)) {
                paper.setSize(dimension.getHeight(), dimension.getWidth());
                n2 = 2;
            }
            paper.setImageableArea(d2, d3, d4, d5);
            printPreviewModel.setPaper(paper);
            printPreviewModel.setOrientation(n2);
        }
    }
}

