/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.console;

import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FilenameFilter;
import javajs.util.AU;
import javajs.util.Lst;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import org.jmol.api.JmolAbstractButton;
import org.jmol.api.JmolScriptEditorInterface;
import org.jmol.awt.Platform;
import org.jmol.console.GenericConsole;
import org.jmol.console.JmolButton;
import org.jmol.console.KeyJMenu;
import org.jmol.console.KeyJMenuItem;
import org.jmol.console.ScriptEditor;
import org.jmol.i18n.GT;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public abstract class JmolConsole
extends GenericConsole
implements ActionListener,
WindowListener {
    protected JFrame vwrFrame;
    protected Container externalContainer;
    protected ScriptEditor scriptEditor;

    @Override
    public void dispose() {
        if (this.externalContainer instanceof Window) {
            ((Window)this.externalContainer).dispose();
        } else {
            this.externalContainer.setVisible(false);
        }
    }

    protected Container getPane() {
        return this.externalContainer instanceof JFrame ? ((JFrame)this.externalContainer).getContentPane() : this.externalContainer;
    }

    @Override
    protected void setTitle() {
        if (this.externalContainer instanceof JFrame) {
            ((JFrame)this.externalContainer).setTitle(JmolConsole.getLabel("title"));
        } else if (this.externalContainer instanceof JDialog) {
            ((JDialog)this.externalContainer).setTitle(JmolConsole.getLabel("title"));
        }
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.externalContainer.setVisible(isVisible);
    }

    @Override
    protected JmolAbstractButton setButton(String label) {
        return this.addButton(new JmolButton(JmolConsole.getLabel(label)), label);
    }

    @Override
    protected void updateLabels() {
        labels = null;
        boolean doTranslate = GT.setDoTranslate((boolean)true);
        this.setViewer(this.vwr);
        this.defaultMessage = JmolConsole.getLabel("default");
        JmolConsole.setAbstractButtonLabels(this.menuMap, labels);
        this.setTitle();
        if (this.label1 != null) {
            this.label1.setText(JmolConsole.getLabel("label1"));
        }
        GT.setDoTranslate((boolean)doTranslate);
    }

    @Override
    public JmolScriptEditorInterface getScriptEditor() {
        return this.scriptEditor == null ? (this.scriptEditor = new ScriptEditor(this.vwr, this.vwrFrame, this)) : this.scriptEditor;
    }

    @Override
    protected String nextFileName(String stub, int nTab) {
        String sname = FileManager.getLocalPathForWritingFile((Viewer)this.vwr, (String)stub);
        if (sname == null) {
            return null;
        }
        String root = sname.substring(0, sname.lastIndexOf("/") + 1);
        if (sname.startsWith("file:/")) {
            sname = sname.substring(6);
        }
        if (sname.indexOf("/") >= 0) {
            if (root.equals(sname)) {
                stub = "";
            } else {
                File dir = new File(sname);
                sname = dir.getParent();
                stub = dir.getName();
            }
        }
        FileChecker fileChecker = new FileChecker(stub);
        try {
            new File(sname).list(fileChecker);
            return root + fileChecker.getFile(nTab);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doAction(e.getSource());
    }

    @Override
    protected boolean isMenuItem(Object source) {
        return source instanceof JMenuItem;
    }

    protected void addWindowListener() {
        Window w = Platform.getWindow((Container)this.externalContainer);
        if (w != null) {
            w.addWindowListener(this);
        }
    }

    @Override
    public void windowActivated(WindowEvent we) {
        this.updateFontSize();
    }

    @Override
    public void windowClosed(WindowEvent we) {
        this.destroyConsole();
    }

    @Override
    public void windowClosing(WindowEvent we) {
        this.destroyConsole();
    }

    @Override
    public void windowDeactivated(WindowEvent we) {
    }

    @Override
    public void windowDeiconified(WindowEvent we) {
    }

    @Override
    public void windowIconified(WindowEvent we) {
    }

    @Override
    public void windowOpened(WindowEvent we) {
    }

    public Object newJMenu(String key) {
        return new KeyJMenu(key, JmolConsole.getLabel(key), null);
    }

    public Object newJMenuItem(String key) {
        return new KeyJMenuItem(key, JmolConsole.getLabel(key), null);
    }

    public void updateFontSize() {
    }

    private class FileChecker
    implements FilenameFilter {
        private String stub;
        private Lst<String> v = new Lst();

        protected FileChecker(String stub) {
            this.stub = stub.toLowerCase();
        }

        @Override
        public boolean accept(File dir, String name) {
            if (!name.toLowerCase().startsWith(this.stub)) {
                return false;
            }
            this.v.addLast((Object)name);
            return true;
        }

        protected String getFile(int n) {
            return AU.sortedItem(this.v, (int)n);
        }
    }
}

