/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

class BooleanTypeUtil {
    private static final Logger LOGGER = Logger.getLogger(BooleanTypeUtil.class.getName());

    private BooleanTypeUtil() {
    }

    static boolean castToBoolean(Object in) throws PSQLException {
        LOGGER.log(Level.FINE, "Object to cast: {0}", in);
        if (in instanceof Boolean) {
            return (Boolean)in;
        }
        if (in instanceof String) {
            return BooleanTypeUtil.from((String)in);
        }
        if (in instanceof Character) {
            return BooleanTypeUtil.from((Character)in);
        }
        if (in instanceof Number) {
            return BooleanTypeUtil.from((Number)in, in.getClass().getName());
        }
        throw BooleanTypeUtil.cannotCoerceException(in.getClass().getName());
    }

    private static boolean from(String strval) throws PSQLException {
        String val = strval.trim();
        if ("1".equals(val) || "true".equalsIgnoreCase(val) || "t".equalsIgnoreCase(val) || "yes".equalsIgnoreCase(val) || "y".equalsIgnoreCase(val) || "on".equalsIgnoreCase(val)) {
            return true;
        }
        if ("0".equals(val) || "false".equalsIgnoreCase(val) || "f".equalsIgnoreCase(val) || "no".equalsIgnoreCase(val) || "n".equalsIgnoreCase(val) || "off".equalsIgnoreCase(val)) {
            return false;
        }
        throw BooleanTypeUtil.cannotCoerceException("String", val);
    }

    private static boolean from(Character charval) throws PSQLException {
        if ('1' == charval.charValue() || 't' == charval.charValue() || 'T' == charval.charValue() || 'y' == charval.charValue() || 'Y' == charval.charValue()) {
            return true;
        }
        if ('0' == charval.charValue() || 'f' == charval.charValue() || 'F' == charval.charValue() || 'n' == charval.charValue() || 'N' == charval.charValue()) {
            return false;
        }
        throw BooleanTypeUtil.cannotCoerceException("Character", charval.toString());
    }

    private static boolean from(Number numval, String className) throws PSQLException {
        double value = numval.doubleValue();
        if (value == 1.0) {
            return true;
        }
        if (value == 0.0) {
            return false;
        }
        throw BooleanTypeUtil.cannotCoerceException(className, String.valueOf(numval));
    }

    private static PSQLException cannotCoerceException(String fromType) {
        LOGGER.log(Level.FINE, "Cannot cast type {0} to boolean", fromType);
        return new PSQLException(GT.tr("Cannot cast type {0} to boolean", fromType), PSQLState.CANNOT_COERCE);
    }

    private static PSQLException cannotCoerceException(String fromType, String value) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Cannot cast type {0} to boolean: \"{1}\"", new Object[]{fromType, value});
        }
        return new PSQLException(GT.tr("Cannot cast type {0} to boolean: \"{1}\"", fromType, value), PSQLState.CANNOT_COERCE);
    }
}

