/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.PersistentRangeMarkerUtil;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PersistentRangeMarker
extends RangeMarkerImpl {
    private LinesCols myLinesCols;

    @Nullable
    static LinesCols storeLinesAndCols(@NotNull Document myDocument, int startOffset, int endOffset) {
        if (myDocument == null) {
            PersistentRangeMarker.$$$reportNull$$$0(1);
        }
        LineCol start = PersistentRangeMarker.calcLineCol(myDocument, startOffset);
        LineCol end = PersistentRangeMarker.calcLineCol(myDocument, endOffset);
        if (start == null || end == null) {
            return null;
        }
        return new LinesCols(start.line, start.col, end.line, end.col);
    }

    private static LineCol calcLineCol(@NotNull Document document, int offset2) {
        if (document == null) {
            PersistentRangeMarker.$$$reportNull$$$0(2);
        }
        if (offset2 <= document.getTextLength()) {
            int line = document.getLineNumber(offset2);
            int col = offset2 - document.getLineStartOffset(line);
            if (col < 0) {
                return null;
            }
            return new LineCol(line, col);
        }
        return null;
    }

    @Nullable
    static Pair<TextRange, LinesCols> translateViaDiff(@NotNull DocumentEventImpl event, @NotNull LinesCols linesCols) {
        if (event == null) {
            PersistentRangeMarker.$$$reportNull$$$0(3);
        }
        if (linesCols == null) {
            PersistentRangeMarker.$$$reportNull$$$0(4);
        }
        try {
            int myStartLine = event.translateLineViaDiffStrict(linesCols.myStartLine);
            Document document = event.getDocument();
            if (myStartLine < 0 || myStartLine >= document.getLineCount()) {
                return null;
            }
            int start = document.getLineStartOffset(myStartLine) + linesCols.myStartColumn;
            if (start >= document.getTextLength()) {
                return null;
            }
            int myEndLine = event.translateLineViaDiffStrict(linesCols.myEndLine);
            if (myEndLine < 0 || myEndLine >= document.getLineCount()) {
                return null;
            }
            int end = document.getLineStartOffset(myEndLine) + linesCols.myEndColumn;
            if (end > document.getTextLength() || end < start) {
                return null;
            }
            if (end > event.getDocument().getTextLength() || myEndLine < myStartLine || myStartLine == myEndLine && linesCols.myEndColumn < linesCols.myStartColumn || event.getDocument().getLineCount() < myEndLine) {
                return null;
            }
            return Pair.create(new TextRange(start, end), new LinesCols(myStartLine, linesCols.myStartColumn, myEndLine, linesCols.myEndColumn));
        }
        catch (FilesTooBigForDiffException e) {
            return null;
        }
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            PersistentRangeMarker.$$$reportNull$$$0(5);
        }
        if (!this.isValid()) {
            return;
        }
        Pair<TextRange, LinesCols> pair = PersistentRangeMarker.applyChange(e, this, this.intervalStart(), this.intervalEnd(), this.isGreedyToLeft(), this.isGreedyToRight(), this.isStickingToRight(), this.myLinesCols);
        if (pair == null) {
            this.invalidate(e);
            return;
        }
        this.setIntervalStart(((TextRange)pair.first).getStartOffset());
        this.setIntervalEnd(((TextRange)pair.first).getEndOffset());
        this.myLinesCols = (LinesCols)pair.second;
    }

    @Nullable
    private static Pair<TextRange, LinesCols> applyChange(DocumentEvent event, Segment range, int intervalStart, int intervalEnd, boolean greedyLeft, boolean greedyRight, boolean stickingToRight, LinesCols linesCols) {
        boolean shouldTranslateViaDiff = PersistentRangeMarkerUtil.shouldTranslateViaDiff(event, range.getStartOffset(), range.getEndOffset());
        Pair<TextRange, LinesCols> translated = null;
        if (shouldTranslateViaDiff) {
            translated = PersistentRangeMarker.translateViaDiff((DocumentEventImpl)event, linesCols);
        }
        if (translated == null) {
            TextRange fallback = PersistentRangeMarker.applyChange(event, intervalStart, intervalEnd, greedyLeft, greedyRight, stickingToRight);
            if (fallback == null) {
                return null;
            }
            LinesCols lc = PersistentRangeMarker.storeLinesAndCols(event.getDocument(), fallback.getStartOffset(), fallback.getEndOffset());
            if (lc == null) {
                return null;
            }
            translated = Pair.create(fallback, lc);
        }
        return translated;
    }

    @Override
    public String toString() {
        return "PersistentRangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + " " + this.myLinesCols + (this.isGreedyToRight() ? "]" : ")");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myDocument";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linesCols";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/PersistentRangeMarker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "storeLinesAndCols";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calcLineCol";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "translateViaDiff";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "changedUpdateImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class LinesCols {
        private final int myStartLine;
        private final int myStartColumn;
        private final int myEndLine;
        private final int myEndColumn;

        private LinesCols(int startLine, int startColumn, int endLine, int endColumn) {
            this.myStartLine = startLine;
            this.myStartColumn = startColumn;
            this.myEndLine = endLine;
            this.myEndColumn = endColumn;
        }

        public String toString() {
            return this.myStartLine + ":" + this.myStartColumn + "-" + this.myEndLine + ":" + this.myEndColumn;
        }
    }

    private static class LineCol {
        private final int line;
        private final int col;

        LineCol(int line, int col) {
            this.line = line;
            this.col = col;
        }
    }
}

