/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.LateinitIntrinsicApplicabilityChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/LateinitIntrinsicApplicabilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "ACCESSIBLE_LATEINIT_PROPERTY_LITERAL", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isBackingFieldAccessible", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "frontend"})
public final class LateinitIntrinsicApplicabilityChecker
implements CallChecker {
    private static final FqName ACCESSIBLE_LATEINIT_PROPERTY_LITERAL;
    public static final LateinitIntrinsicApplicabilityChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        KtExpression expression2;
        KtExpression ktExpression;
        Object object;
        Object object2;
        boolean bl;
        block20: {
            Object descriptor2;
            Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
            Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
            Intrinsics.checkParameterIsNotNull(context, "context");
            Object obj = descriptor2 = resolvedCall2.getResultingDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(obj, "descriptor");
            if (Intrinsics.areEqual(obj.getName().asString(), "isInitialized") ^ true) {
                return;
            }
            Object object3 = descriptor2.getExtensionReceiverParameter();
            if (object3 == null || (object3 = object3.getValue()) == null || (object3 = object3.getType()) == null || (object3 = object3.getAnnotations()) == null || (object3 = object3.getUseSiteTargetedAnnotations()) == null) {
                return;
            }
            List<AnnotationWithTarget> annotations2 = object3;
            Iterable $receiver$iv = annotations2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                object2 = $receiver$iv.iterator();
                while (object2.hasNext()) {
                    Object element$iv = object2.next();
                    AnnotationWithTarget it = (AnnotationWithTarget)element$iv;
                    if (!Intrinsics.areEqual(it.getAnnotation().getFqName(), ACCESSIBLE_LATEINIT_PROPERTY_LITERAL)) continue;
                    bl = false;
                    break block20;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        ReceiverValue receiverValue = resolvedCall2.getExtensionReceiver();
        if (!(receiverValue instanceof ExpressionReceiver)) {
            receiverValue = null;
        }
        if ((object = (ExpressionReceiver)receiverValue) != null && (object = object.getExpression()) != null) {
            Object p1 = object2 = object;
            ktExpression = KtPsiUtil.safeDeparenthesize((KtExpression)p1);
        } else {
            ktExpression = expression2 = null;
        }
        if (!(expression2 instanceof KtCallableReferenceExpression)) {
            context.getTrace().report(Errors.LATEINIT_INTRINSIC_CALL_ON_NON_LITERAL.on(reportOn));
        } else {
            KtElement ktElement = ((KtCallableReferenceExpression)expression2).getCallableReference();
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            if (resolvedCall3 == null) {
                return;
            }
            ResolvedCall<? extends CallableDescriptor> propertyReferenceResolvedCall = resolvedCall3;
            CallableDescriptor referencedProperty = propertyReferenceResolvedCall.getResultingDescriptor();
            if (!(referencedProperty instanceof PropertyDescriptor)) {
                String string = "Lateinit intrinsic is incorrectly resolved not to a property: " + referencedProperty;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (!((PropertyDescriptor)referencedProperty).isLateInit()) {
                context.getTrace().report(Errors.LATEINIT_INTRINSIC_CALL_ON_NON_LATEINIT.on(reportOn));
            } else if (!this.isBackingFieldAccessible((PropertyDescriptor)referencedProperty, context)) {
                context.getTrace().report(Errors.LATEINIT_INTRINSIC_CALL_ON_NON_ACCESSIBLE_PROPERTY.on(reportOn, (PropertyDescriptor)referencedProperty));
            } else {
                DeclarationDescriptor declarationDescriptor = context.getScope().getOwnerDescriptor();
                if (!(declarationDescriptor instanceof FunctionDescriptor)) {
                    declarationDescriptor = null;
                }
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
                if (functionDescriptor != null) {
                    if (functionDescriptor.isInline()) {
                        context.getTrace().report(Errors.LATEINIT_INTRINSIC_CALL_IN_INLINE_FUNCTION.on(reportOn));
                    }
                }
            }
        }
    }

    private final boolean isBackingFieldAccessible(PropertyDescriptor descriptor2, CallCheckerContext context) {
        Set<CallableMemberDescriptor> set = OverridingUtil.filterOutOverridden(OverridingUtil.getOverriddenDeclarations(descriptor2));
        Intrinsics.checkExpressionValueIsNotNull(set, "OverridingUtil.filterOut\u2026Declarations(descriptor))");
        CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)CollectionsKt.singleOrNull((Iterable)set);
        if (callableMemberDescriptor == null) {
            return false;
        }
        CallableMemberDescriptor declaration = callableMemberDescriptor;
        KtFile ktFile = DescriptorToSourceUtils.getContainingFile(declaration);
        if (ktFile == null) {
            return false;
        }
        KtFile declarationSourceFile = ktFile;
        KtFile ktFile2 = DescriptorToSourceUtils.getContainingFile(context.getScope().getOwnerDescriptor());
        if (ktFile2 == null) {
            return false;
        }
        KtFile usageSourceFile = ktFile2;
        if (Intrinsics.areEqual(declarationSourceFile, usageSourceFile) ^ true) {
            return false;
        }
        Sequence<DeclarationDescriptor> sequence2 = SequencesKt.generateSequence(context.getScope().getOwnerDescriptor(), (Function1)isBackingFieldAccessible.1.INSTANCE);
        DeclarationDescriptor declarationDescriptor = declaration.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "declaration.containingDeclaration");
        return SequencesKt.contains(sequence2, declarationDescriptor);
    }

    private LateinitIntrinsicApplicabilityChecker() {
    }

    static {
        LateinitIntrinsicApplicabilityChecker lateinitIntrinsicApplicabilityChecker;
        INSTANCE = lateinitIntrinsicApplicabilityChecker = new LateinitIntrinsicApplicabilityChecker();
        ACCESSIBLE_LATEINIT_PROPERTY_LITERAL = new FqName("kotlin.internal.AccessibleLateinitPropertyLiteral");
    }
}

