/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Ice;

import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.LogMessage;
import com.zeroc.Ice.OptionalFormat;
import com.zeroc.Ice.OutputStream;
import java.util.Optional;

public final class LogMessageSeqHelper {
    public static void write(OutputStream ostr, LogMessage[] v) {
        if (v == null) {
            ostr.writeSize(0);
        } else {
            ostr.writeSize(v.length);
            for (int i0 = 0; i0 < v.length; ++i0) {
                LogMessage.ice_write(ostr, v[i0]);
            }
        }
    }

    public static LogMessage[] read(InputStream istr) {
        int len0 = istr.readAndCheckSeqSize(11);
        LogMessage[] v = new LogMessage[len0];
        for (int i0 = 0; i0 < len0; ++i0) {
            v[i0] = LogMessage.ice_read(istr);
        }
        return v;
    }

    public static void write(OutputStream ostr, int tag, Optional<LogMessage[]> v) {
        if (v != null && v.isPresent()) {
            LogMessageSeqHelper.write(ostr, tag, v.get());
        }
    }

    public static void write(OutputStream ostr, int tag, LogMessage[] v) {
        if (ostr.writeOptional(tag, OptionalFormat.FSize)) {
            int pos = ostr.startSize();
            LogMessageSeqHelper.write(ostr, v);
            ostr.endSize(pos);
        }
    }

    public static Optional<LogMessage[]> read(InputStream istr, int tag) {
        if (istr.readOptional(tag, OptionalFormat.FSize)) {
            istr.skip(4);
            LogMessage[] v = LogMessageSeqHelper.read(istr);
            return Optional.of(v);
        }
        return Optional.empty();
    }
}

