// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `Locator.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package Ice;

/**
 * The Ice locator interface. This interface is used by clients to
 * lookup adapters and objects. It is also used by servers to get the
 * locator registry proxy.
 *
 * <p class="Note">The {@link Locator} interface is intended to be used by
 * Ice internals and by locator implementations. Regular user code
 * should not attempt to use any functionality of this interface
 * directly.
 *
 **/
public interface LocatorPrx extends ObjectPrx
{
    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     *
     * @param id The identity.
     *
     * @return The proxy, or null if the object is not active.
     *
     * @throws ObjectNotFoundException Raised if the object cannot
     * be found.
     *
     **/
    public Ice.ObjectPrx findObjectById(Identity id)
        throws ObjectNotFoundException;

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     *
     * @param id The identity.
     *
     * @param context The Context map to send with the invocation.
     * @return The proxy, or null if the object is not active.
     *
     * @throws ObjectNotFoundException Raised if the object cannot
     * be found.
     *
     **/
    public Ice.ObjectPrx findObjectById(Identity id, java.util.Map<String, String> context)
        throws ObjectNotFoundException;

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     *
     * @param id The identity.
     *
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_findObjectById(Identity id);

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     *
     * @param id The identity.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_findObjectById(Identity id, java.util.Map<String, String> context);

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     *
     * @param id The identity.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Identity id, Callback cb);

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     *
     * @param id The identity.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Identity id, java.util.Map<String, String> context, Callback cb);

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     *
     * @param id The identity.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Identity id, Callback_Locator_findObjectById cb);

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     *
     * @param id The identity.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Identity id, java.util.Map<String, String> context, Callback_Locator_findObjectById cb);

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     *
     * @param id The identity.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Identity id,
                                                IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     *
     * @param id The identity.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Identity id,
                                                IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     *
     * @param id The identity.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Identity id,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     *
     * @param id The identity.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findObjectById(Identity id,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     *
     * @param result The asynchronous result object.
     * @return The proxy, or null if the object is not active.
     *
     * @throws ObjectNotFoundException Raised if the object cannot
     * be found.
     *
     **/
    public Ice.ObjectPrx end_findObjectById(Ice.AsyncResult result)
        throws ObjectNotFoundException;

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     *
     * @param id The adapter id.
     *
     * @return The adapter proxy, or null if the adapter is not active.
     *
     * @throws AdapterNotFoundException Raised if the adapter cannot be
     * found.
     *
     **/
    public Ice.ObjectPrx findAdapterById(String id)
        throws AdapterNotFoundException;

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     *
     * @param id The adapter id.
     *
     * @param context The Context map to send with the invocation.
     * @return The adapter proxy, or null if the adapter is not active.
     *
     * @throws AdapterNotFoundException Raised if the adapter cannot be
     * found.
     *
     **/
    public Ice.ObjectPrx findAdapterById(String id, java.util.Map<String, String> context)
        throws AdapterNotFoundException;

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     *
     * @param id The adapter id.
     *
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_findAdapterById(String id);

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     *
     * @param id The adapter id.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_findAdapterById(String id, java.util.Map<String, String> context);

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     *
     * @param id The adapter id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAdapterById(String id, Callback cb);

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     *
     * @param id The adapter id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAdapterById(String id, java.util.Map<String, String> context, Callback cb);

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     *
     * @param id The adapter id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAdapterById(String id, Callback_Locator_findAdapterById cb);

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     *
     * @param id The adapter id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAdapterById(String id, java.util.Map<String, String> context, Callback_Locator_findAdapterById cb);

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     *
     * @param id The adapter id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAdapterById(String id,
                                                 IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                 IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     *
     * @param id The adapter id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAdapterById(String id,
                                                 IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                 IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     *
     * @param id The adapter id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAdapterById(String id,
                                                 java.util.Map<String, String> context,
                                                 IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                 IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     *
     * @param id The adapter id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_findAdapterById(String id,
                                                 java.util.Map<String, String> context,
                                                 IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                 IceInternal.Functional_GenericCallback1<UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     *
     * @param result The asynchronous result object.
     * @return The adapter proxy, or null if the adapter is not active.
     *
     * @throws AdapterNotFoundException Raised if the adapter cannot be
     * found.
     *
     **/
    public Ice.ObjectPrx end_findAdapterById(Ice.AsyncResult result)
        throws AdapterNotFoundException;

    /**
     * Get the locator registry.
     *
     * @return The locator registry.
     *
     **/
    public LocatorRegistryPrx getRegistry();

    /**
     * Get the locator registry.
     *
     * @param context The Context map to send with the invocation.
     * @return The locator registry.
     *
     **/
    public LocatorRegistryPrx getRegistry(java.util.Map<String, String> context);

    /**
     * Get the locator registry.
     *
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_getRegistry();

    /**
     * Get the locator registry.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public AsyncResult begin_getRegistry(java.util.Map<String, String> context);

    /**
     * Get the locator registry.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistry(Callback cb);

    /**
     * Get the locator registry.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistry(java.util.Map<String, String> context, Callback cb);

    /**
     * Get the locator registry.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistry(Callback_Locator_getRegistry cb);

    /**
     * Get the locator registry.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistry(java.util.Map<String, String> context, Callback_Locator_getRegistry cb);

    /**
     * Get the locator registry.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistry(IceInternal.Functional_GenericCallback1<LocatorRegistryPrx> responseCb,
                                             IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Get the locator registry.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistry(IceInternal.Functional_GenericCallback1<LocatorRegistryPrx> responseCb,
                                             IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the locator registry.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistry(java.util.Map<String, String> context,
                                             IceInternal.Functional_GenericCallback1<LocatorRegistryPrx> responseCb,
                                             IceInternal.Functional_GenericCallback1<Exception> exceptionCb);

    /**
     * Get the locator registry.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistry(java.util.Map<String, String> context,
                                             IceInternal.Functional_GenericCallback1<LocatorRegistryPrx> responseCb,
                                             IceInternal.Functional_GenericCallback1<Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the locator registry.
     *
     * @param result The asynchronous result object.
     * @return The locator registry.
     *
     **/
    public LocatorRegistryPrx end_getRegistry(Ice.AsyncResult result);
}
