/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ne extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u0905\u092b\u094d\u0930\u093f\u0915\u0940 \u0938\u092e\u092f",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "\u092e\u0938\u094d\u0915\u094b \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "MSK",
               "\u092e\u0938\u094d\u0915\u094b \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "MSD",
               "\u092e\u0938\u094d\u0915\u094b \u0938\u092e\u092f",
               "MT",
            };
        final String[] Japan = new String[] {
               "\u091c\u093e\u092a\u093e\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "JST",
               "\u091c\u093e\u092a\u093e\u0928 \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "JDT",
               "\u091c\u093e\u092a\u093e\u0928 \u0938\u092e\u092f",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "PKT",
               "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "PKST",
               "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928\u0940 \u0938\u092e\u092f",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "\u0924\u093e\u0907\u092a\u0947\u0907 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "CST",
               "\u0924\u093e\u0907\u092a\u0947\u0907 \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "CDT",
               "\u0924\u093e\u0907\u092a\u0947\u0907 \u0938\u092e\u092f",
               "CT",
            };
        final String[] Hovd = new String[] {
               "\u0939\u094b\u092c\u094d\u0921 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "HOVT",
               "\u0939\u094b\u092c\u094d\u0921 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "HOVST",
               "\u0939\u094b\u092c\u094d\u0921 \u0938\u092e\u092f",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "\u092e\u093e\u0917\u093e\u0926\u093e\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "MAGT",
               "\u092e\u093e\u0917\u093e\u0926\u093e\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "MAGST",
               "\u092e\u093e\u0917\u093e\u0926\u093e\u0928 \u0938\u092e\u092f",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "ACWST",
               "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "ACWDT",
               "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0938\u092e\u092f",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u092f\u0941\u0930\u094b\u092a\u0947\u0932\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "CET",
               "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u092f\u0941\u0930\u094b\u092a\u0947\u0932\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "CEST",
               "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u092f\u0941\u0930\u094b\u092a\u0947\u0932\u0940 \u0938\u092e\u092f",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "\u0938\u093e\u0916\u093e\u0932\u093f\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "SAKT",
               "\u0938\u093e\u0916\u093e\u0932\u093f\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "SAKST",
               "\u0938\u093e\u0916\u093e\u0932\u093f\u0928 \u0938\u092e\u092f",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "\u092a\u093e\u0930\u093e\u0917\u094d\u0935\u0947 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "PYT",
               "\u092a\u093e\u0930\u093e\u0917\u094d\u0935\u0947 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "PYST",
               "\u092a\u093e\u0930\u093e\u0917\u094d\u0935\u0947 \u0938\u092e\u092f",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "\u092e\u0932\u0947\u0938\u093f\u092f\u093e \u0938\u092e\u092f",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "EST",
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "EDT",
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0938\u092e\u092f",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "\u0932\u0930\u094d\u0921 \u0939\u093e\u0935\u0947 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "LHST",
               "\u0932\u0930\u094d\u0921 \u0939\u093e\u0935\u0947 \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "LHDT",
               "\u0932\u0930\u094d\u0921 \u0939\u093e\u0935\u0947 \u0938\u092e\u092f",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "\u0928\u094d\u092f\u0942\u091c\u093f\u0932\u094d\u092f\u093e\u0928\u094d\u0921 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "NZST",
               "\u0928\u094d\u092f\u0942\u091c\u093f\u0932\u094d\u092f\u093e\u0928\u094d\u0921 \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "NZDT",
               "\u0928\u094d\u092f\u0942\u091c\u093f\u0932\u094d\u092f\u093e\u0928\u094d\u0921 \u0938\u092e\u092f",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u0939\u093f\u0928\u094d\u0926 \u092e\u0939\u093e\u0938\u093e\u0917\u0930 \u0938\u092e\u092f",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "\u092f\u093e\u0915\u0941\u0938\u094d\u091f \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "YAKT",
               "\u092f\u093e\u0915\u0941\u0938\u094d\u091f \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "YAKST",
               "\u092f\u093e\u0915\u0941\u0938\u094d\u091f \u0938\u092e\u092f",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "\u092e\u0909\u0930\u093f\u091f\u0938 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "MUT",
               "\u092e\u0909\u0930\u093f\u091f\u0938 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "MUST",
               "\u092e\u0909\u0930\u093f\u091f\u0938 \u0938\u092e\u092f",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0905\u092b\u094d\u0930\u093f\u0915\u0940 \u0938\u092e\u092f",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u091f\u093f\u092e\u094b\u0930 \u0938\u092e\u092f",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "\u0938\u094b\u0932\u094b\u092e\u094b\u0928 \u091f\u093e\u092a\u0941 \u0938\u092e\u092f",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "\u0915\u094b\u0938\u0930\u093e\u090f \u0938\u092e\u092f",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "\u092e\u093e\u0930\u094d\u0936\u0932 \u091f\u093e\u092a\u0941 \u0938\u092e\u092f",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u092f\u0941\u0930\u094b\u092a\u0947\u0932\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "EET",
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u092f\u0941\u0930\u094b\u092a\u0947\u0932\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "EEST",
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u092f\u0941\u0930\u094b\u092a\u0947\u0932\u0940 \u0938\u092e\u092f",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u0928\u094d\u092f\u0942\u092b\u093e\u0909\u0928\u094d\u0921\u0932\u094d\u092f\u093e\u0923\u094d\u0921 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "NST",
               "\u0928\u094d\u092f\u0942\u092b\u093e\u0909\u0928\u094d\u0932\u094d\u092f\u093e\u0923\u094d\u0921 \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "NDT",
               "\u0928\u094d\u092f\u0942\u092b\u093e\u0909\u0928\u094d\u0921\u0932\u094d\u092f\u093e\u0923\u094d\u0921 \u0938\u092e\u092f",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "\u0905\u092b\u0917\u093e\u0928\u093f\u0938\u094d\u0924\u093e\u0928 \u0938\u092e\u092f",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "\u0939\u0919\u0915\u0919 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "HKT",
               "\u0939\u0919\u0915\u0919 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "HKST",
               "\u0939\u0919\u0915\u0919 \u0938\u092e\u092f",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u0930\u094d\u091c\u0947\u0928\u091f\u093f\u0928\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "ART",
               "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u0930\u094d\u091c\u0947\u0928\u091f\u093f\u0928\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "ARST",
               "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u0930\u094d\u091c\u0947\u0928\u091f\u093f\u0928\u0940 \u0938\u092e\u092f",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "\u090f\u091f\u094d\u0932\u093e\u0928\u094d\u091f\u093f\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AST",
               "\u090f\u091f\u094d\u0932\u093e\u0928\u094d\u091f\u093f\u0915 \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "ADT",
               "\u090f\u091f\u094d\u0932\u093e\u0928\u094d\u091f\u093f\u0915 \u0938\u092e\u092f",
               "AT",
            };
        final String[] Ponape = new String[] {
               "\u092a\u094b\u0928\u093e\u092a\u0947 \u0938\u092e\u092f",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "\u092c\u094b\u0932\u093f\u092d\u093f\u092f\u093e \u0938\u092e\u092f",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\u0938\u093e\u092f\u094d\u091f \u092a\u0947\u0908\u0930\u093f \u0930 \u092e\u093f\u0915\u094d\u092f\u0942\u0932\u094b\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "PMST",
               "\u0938\u093e\u092f\u094d\u091f \u092a\u0947\u0908\u0930\u093f \u0930 \u092e\u093f\u0915\u094d\u092f\u0942\u0932\u094b\u0928 \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "PMDT",
               "\u0938\u093e\u092f\u094d\u091f \u092a\u0947\u0908\u0930\u093f \u0930 \u092e\u093f\u0915\u094d\u092f\u0942\u0932\u094b\u0928 \u0938\u092e\u092f",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "\u0907\u0928\u094d\u0921\u094b\u091a\u093e\u0907\u0928\u093e \u0938\u092e\u092f",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u092f\u0947\u0915\u093e\u091f\u0947\u0930\u093f\u0928\u092c\u0930\u094d\u0917 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "YEKT",
               "\u092f\u0947\u0915\u093e\u091f\u0947\u0930\u093f\u0928\u092c\u0930\u094d\u0917 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "YEKST",
               "\u092f\u0947\u0915\u093e\u091f\u0947\u0930\u093f\u0928\u092c\u0930\u094d\u0917 \u0938\u092e\u092f",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "\u092e\u093e\u0932\u094d\u0926\u093f\u092d\u094d\u0938 \u0938\u092e\u092f",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "\u0924\u093e\u0939\u093f\u0924\u0940 \u0938\u092e\u092f",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "\u0907\u091c\u0930\u093e\u092f\u0932 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "IST",
               "\u0907\u091c\u0930\u093e\u092f\u0932 \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "IDT",
               "\u0907\u091c\u0930\u093e\u092f\u0932 \u0938\u092e\u092f",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u0907\u0928\u094d\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e \u0938\u092e\u092f",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "\u0935\u093e\u0932\u093f\u0938\u094d \u0930 \u092b\u0941\u091f\u0941\u0928\u093e \u0938\u092e\u092f",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "\u0926\u0915\u094d\u0937\u093f\u0923 \u0905\u092b\u094d\u0930\u093f\u0915\u0940 \u0938\u092e\u092f",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "\u0938\u094d\u092f\u094b\u0935\u093e \u0938\u092e\u092f",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "\u0932\u093e\u0907\u0928 \u091f\u093e\u092a\u0941 \u0938\u092e\u092f",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "\u0909\u091c\u094d\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "UZT",
               "\u0909\u091c\u094d\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "UZST",
               "\u0909\u091c\u094d\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928 \u0938\u092e\u092f",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "\u0913\u092e\u094d\u0938\u094d\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "OMST",
               "\u0913\u092e\u094d\u0938\u094d\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "OMSST",
               "\u0913\u092e\u094d\u0938\u094d\u0915 \u0938\u092e\u092f",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "\u0938\u0947\u092f\u0947\u091a\u0947\u0932\u093e\u0938\u094d \u0938\u092e\u092f",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "\u0909\u0930\u0942\u0917\u094d\u0935\u0947 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "UYT",
               "\u0909\u0930\u0941\u0917\u094d\u0935\u0947 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "UYST",
               "\u0909\u0930\u0941\u0917\u094d\u0935\u0947 \u0938\u092e\u092f",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "\u0928\u0947\u092a\u093e\u0932\u0940 \u0938\u092e\u092f",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "\u0909\u0932\u093e\u0928 \u092c\u093e\u091f\u094b\u0930 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "ULAT",
               "\u0909\u0932\u093e\u0928 \u092c\u093e\u091f\u094b\u0930 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "ULAST",
               "\u0909\u0932\u093e\u0928 \u092c\u093e\u091f\u094b\u0930 \u0938\u092e\u092f",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "CST",
               "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "CDT",
               "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u0938\u092e\u092f",
               "CT",
            };
        final String[] Truk = new String[] {
               "\u091a\u0941\u0909\u0915 \u0938\u092e\u092f",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "\u0928\u093f\u0909\u090f \u0938\u092e\u092f",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "\u0935\u0947\u0915 \u091f\u093e\u092a\u0941 \u0938\u092e\u092f",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "\u092b\u0932\u094d\u0915\u0932\u094d\u092f\u093e\u0928\u094d\u0921 \u091f\u093e\u092a\u0942 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "FKT",
               "\u092b\u0932\u094d\u0915\u0932\u094d\u092f\u093e\u0928\u094d\u0921 \u091f\u093e\u092a\u0942 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "FKST",
               "\u092b\u0932\u094d\u0915\u0932\u094d\u092f\u093e\u0928\u094d\u0921 \u091f\u093e\u092a\u0942 \u0938\u092e\u092f",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "\u092d\u093e\u0928\u0941\u0906\u0924\u0941 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "VUT",
               "\u092d\u093e\u0928\u0941\u0906\u0924\u0941 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "VUST",
               "\u092d\u093e\u0928\u0941\u0906\u0924\u0941 \u0938\u092e\u092f",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "\u0928\u094b\u092d\u094b\u0938\u093f\u0935\u093f\u0930\u094d\u0938\u094d\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "NOVT",
               "\u0928\u094b\u092d\u094b\u0938\u093f\u0935\u093f\u0930\u094d\u0938\u094d\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "NOVST",
               "\u0928\u094b\u092d\u094b\u0938\u093f\u0935\u093f\u0930\u094d\u0938\u094d\u0915 \u0938\u092e\u092f",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "\u0938\u093f\u0902\u0917\u093e\u092a\u0941\u0930 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "\u090f\u091c\u094b\u0930\u0947\u0938\u094d \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AZOT",
               "\u090f\u091c\u094b\u0930\u0947\u0938\u094d \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "AZOST",
               "\u090f\u091c\u094b\u0930\u0947\u0938\u094d \u0938\u092e\u092f",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "\u0906\u092a\u093f\u092f\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "WSST",
               "\u0906\u092a\u093f\u092f\u093e \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "WSDT",
               "\u0906\u092a\u093f\u092f\u093e \u0938\u092e\u092f",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "\u092d\u0941\u091f\u093e\u0928\u0940 \u0938\u092e\u092f",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "\u0938\u0941\u0930\u093f\u0928\u093e\u092e\u093e \u0938\u092e\u092f",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "\u0928\u093e\u0909\u0930\u0941 \u0938\u092e\u092f",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u0915\u094d\u0930\u093e\u0938\u0928\u094b\u092f\u093e\u0930\u094d\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "KRAT",
               "\u0915\u094d\u0930\u093e\u0938\u0928\u094b\u092f\u093e\u0930\u094d\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "KRAST",
               "\u0915\u094d\u0930\u093e\u0938\u0928\u094b\u092f\u093e\u0930\u094d\u0915 \u0938\u092e\u092f",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u092a\u0936\u094d\u091a\u093f\u092e \u0915\u093e\u091c\u0915\u0938\u094d\u0924\u093e\u0928 \u0938\u092e\u092f",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "\u092e\u094d\u092f\u093e\u0928\u092e\u093e\u0930 \u0938\u092e\u092f",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "\u0915\u094d\u0930\u093f\u0938\u094d\u092e\u0938 \u091f\u093e\u092a\u0941 \u0938\u092e\u092f",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "\u0905\u092e\u0947\u091c\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AMT",
               "\u0905\u092e\u0947\u091c\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "AMST",
               "\u0905\u092e\u0947\u091c\u0928 \u0938\u092e\u092f",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0915\u093e\u091c\u0915\u0938\u094d\u0924\u093e\u0928 \u0938\u092e\u092f",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "\u092b\u093f\u091c\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "FJT",
               "\u092b\u093f\u091c\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "FJST",
               "\u092b\u093f\u091c\u0940 \u0938\u092e\u092f",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "\u0930\u093f\u092f\u0941\u0928\u093f\u092f\u0928 \u0938\u092e\u092f",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "\u0915\u094b\u0915\u094b\u0938 \u091f\u093e\u092a\u0941 \u0938\u092e\u092f",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "\u091a\u093e\u0925\u093e\u092e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "CHAST",
               "\u091a\u093e\u0925\u093e\u092e \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "CHADT",
               "\u091a\u093e\u0925\u093e\u092e \u0938\u092e\u092f",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "\u092d\u093e\u0938\u094d\u091f\u094b\u0915 \u0938\u092e\u092f",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "\u0905\u0930\u094d\u091c\u0947\u0928\u091f\u093f\u0928\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "ART",
               "\u0905\u0930\u094d\u091c\u0947\u0928\u091f\u093f\u0928\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "ARST",
               "\u0905\u0930\u094d\u091c\u0947\u0928\u091f\u093f\u0928\u0940 \u0938\u092e\u092f",
               "ART",
            };
        final String[] Gambier = new String[] {
               "\u0917\u094d\u092f\u093e\u092e\u094d\u092c\u093f\u092f\u0930 \u0938\u092e\u092f",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Tuvalu = new String[] {
               "\u091f\u0941\u092d\u093e\u0932\u0941 \u0938\u092e\u092f",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "\u0917\u093e\u0932\u093e\u092a\u093e\u0917\u094b\u0938\u094d \u0938\u092e\u092f",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "\u092e\u093e\u0915\u094d\u0935\u0947\u0930\u0940 \u091f\u093e\u092a\u0941 \u0938\u092e\u092f",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "\u092d\u0947\u0928\u0947\u091c\u094d\u092f\u0941\u090f\u0932\u093e \u0938\u092e\u092f",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u0939\u0935\u093e\u0908-\u090f\u0932\u0941\u091f\u093f\u092f\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "HAST",
               "\u0939\u0935\u093e\u0908-\u090f\u0932\u0941\u091f\u093f\u092f\u0928 \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "HADT",
               "\u0939\u0935\u093e\u0908-\u090f\u0932\u0941\u091f\u093f\u092f\u0928 \u0938\u092e\u092f",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "ACST",
               "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "ACDT",
               "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0938\u092e\u092f",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "\u092a\u094d\u092f\u093e\u0938\u093f\u092b\u093f\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "PST",
               "\u092a\u094d\u092f\u093e\u0938\u093f\u092b\u093f\u0915 \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "PDT",
               "\u092a\u094d\u092f\u093e\u0938\u093f\u092b\u093f\u0915 \u0938\u092e\u092f",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u092b\u093f\u0928\u093f\u0915\u094d\u0938 \u091f\u093e\u092a\u0941 \u0938\u092e\u092f",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u093f\u0938\u094d\u0924\u093e\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "TMT",
               "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u093f\u0938\u094d\u0924\u093e\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "TMST",
               "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u093f\u0938\u094d\u0924\u093e\u0928 \u0938\u092e\u092f",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092f\u0941\u0930\u094b\u092a\u0947\u0932\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "WET",
               "\u092f\u0941\u0930\u094b\u092a\u0947\u0932\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "WEST",
               "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092f\u0941\u0930\u094b\u092a\u0947\u0932\u0940 \u0938\u092e\u092f",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "\u0915\u0947\u092a \u092d\u0930\u094d\u0926\u0947 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "CVT",
               "\u0915\u0947\u092a \u092d\u0930\u094d\u0926\u0947 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "CVST",
               "\u0915\u0947\u092a \u092d\u0930\u094d\u0926\u0947 \u0938\u092e\u092f",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "\u0928\u094b\u0930\u094d\u092b\u0932\u094d\u0915 \u091f\u093e\u092a\u0942 \u0938\u092e\u092f",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "\u0917\u0941\u092f\u093e\u0928\u093e \u0938\u092e\u092f",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "\u092a\u093f\u091f\u0915\u0948\u0930\u0923 \u0938\u092e\u092f",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "\u0930\u094b\u0925\u0947\u0930\u093e \u0938\u092e\u092f",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "\u0938\u093e\u092e\u094b\u0905 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "SST",
               "\u0938\u093e\u092e\u094b\u0905 \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "SDT",
               "\u0938\u093e\u092e\u094b\u0905 \u0938\u092e\u092f",
               "ST",
            };
        final String[] Palau = new String[] {
               "\u092a\u093e\u0932\u093e\u0909 \u0938\u092e\u092f",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "\u0925\u092a-\u092a\u0942\u0930\u094d\u0935\u0940 \u092f\u0941\u0930\u094b\u092a\u0947\u0932\u0940 \u0938\u092e\u092f",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "\u0905\u091c\u0930\u092c\u0948\u091c\u093e\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AZT",
               "\u0905\u091c\u0930\u092c\u0948\u091c\u093e\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "AZST",
               "\u0905\u091c\u0930\u092c\u0948\u091c\u093e\u0928 \u0938\u092e\u092f",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "\u092e\u094d\u0935\u0938\u0928 \u0938\u092e\u092f",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u0928 \u092a\u094d\u092f\u093e\u0938\u093f\u092b\u093f\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "MST",
               "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u0928 \u092a\u094d\u092f\u093e\u0938\u093f\u092b\u093f\u0915 \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "MDT",
               "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u0928 \u092a\u094d\u092f\u093e\u0938\u093f\u092b\u093f\u0915 \u0938\u092e\u092f",
               "MT",
            };
        final String[] Davis = new String[] {
               "\u0921\u0947\u092d\u093f\u0938 \u0938\u092e\u092f",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "\u0915\u094d\u092f\u0942\u092c\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "CST",
               "\u0915\u094d\u092f\u0942\u092c\u093e \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "CDT",
               "\u0915\u094d\u092f\u0942\u092c\u093e \u0938\u092e\u092f",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "\u092a\u0936\u094d\u091a\u093f\u092e \u0905\u092b\u094d\u0930\u093f\u0915\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "CAT",
               "\u092a\u0936\u094d\u091a\u093f\u092e \u0905\u092b\u094d\u0930\u093f\u0915\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "CAST",
               "\u092a\u0936\u094d\u091a\u093f\u092e \u0905\u092b\u094d\u0930\u093f\u0915\u0940 \u0938\u092e\u092f",
               "CAT",
            };
        final String[] GMT = new String[] {
               "\u0917\u094d\u0930\u0940\u0928\u0935\u093f\u091a \u092e\u093f\u0928 \u0938\u092e\u092f",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "\u092b\u093f\u0932\u093f\u092a\u093f\u0928\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "PHT",
               "\u092b\u093f\u0932\u093f\u092a\u093f\u0928\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "PHST",
               "\u092b\u093f\u0932\u093f\u092a\u093f\u0928\u0940 \u0938\u092e\u092f",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "\u092b\u094d\u0930\u0947\u0928\u094d\u091a \u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0930 \u0905\u0928\u094d\u091f\u093e\u0930\u094d\u091f\u093f\u0915 \u0938\u092e\u092f",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "\u0926\u0915\u094d\u0937\u093f\u0923 \u091c\u0930\u094d\u091c\u093f\u092f\u093e \u0938\u092e\u092f",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "\u0928\u092f\u093e\u0901 \u0915\u093e\u0932\u0947\u0926\u094b\u0928\u093f\u092f\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "NCT",
               "\u0928\u092f\u093e\u0901 \u0915\u093e\u0932\u0947\u0926\u094b\u0928\u093f\u092f\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "NCST",
               "\u0928\u092f\u093e\u0901 \u0915\u093e\u0932\u0947\u0926\u094b\u0928\u093f\u092f\u093e \u0938\u092e\u092f",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "\u092c\u094d\u0930\u0941\u0928\u093e\u0907 \u0926\u093e\u0930\u0942\u0938\u094d\u0938\u0932\u092e \u0938\u092e\u092f",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "\u0907\u0930\u093e\u0928\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "IRST",
               "\u0907\u0930\u093e\u0928\u0940 \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "IRDT",
               "\u0907\u0930\u093e\u0928\u0940 \u0938\u092e\u092f",
               "IRT",
            };
        final String[] Easter = new String[] {
               "\u0907\u0938\u094d\u091f\u0930 \u091f\u093e\u092a\u0942 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "EAST",
               "\u0907\u0938\u094d\u091f\u0930 \u091f\u093e\u092a\u0942 \u0917\u094d\u0930\u0940\u0937\u094d\u092e \u0938\u092e\u092f",
               "EASST",
               "\u0907\u0938\u094d\u091f\u0930 \u091f\u093e\u092a\u0942 \u0938\u092e\u092f",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "\u0909\u0924\u094d\u0924\u0930 \u092a\u0936\u094d\u091a\u093f\u092e \u092e\u0947\u0915\u094d\u0938\u093f\u0915\u094b \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "PST",
               "\u0909\u0924\u094d\u0924\u0930 \u092a\u0936\u094d\u091a\u093f\u092e \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "PDT",
               "\u0909\u0924\u094d\u0924\u0930 \u092a\u0936\u094d\u091a\u093f\u092e \u092e\u0947\u0915\u094d\u0938\u093f\u0915\u094b \u0938\u092e\u092f",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "\u0921\u0941\u092e\u094b\u0928\u094d\u091f-\u0921\u0940\u2018 \u0909\u0930\u094d\u092d\u093f\u0932\u0947 \u0938\u092e\u092f",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "\u0924\u093e\u091c\u093f\u0915\u0938\u094d\u0924\u093e\u0928 \u0938\u092e\u092f",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "\u091f\u094b\u0902\u0917\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "TOT",
               "\u091f\u094b\u0902\u0917\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "TOST",
               "\u091f\u094b\u0902\u0917\u093e \u0938\u092e\u092f",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "\u092c\u0902\u0917\u0932\u093e\u0926\u0947\u0936\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "BDT",
               "\u092c\u0902\u0917\u0932\u093e\u0926\u0947\u0936\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "BDST",
               "\u092c\u0902\u0917\u0932\u093e\u0926\u0947\u0936\u0940 \u0938\u092e\u092f",
               "BDT",
            };
        final String[] Peru = new String[] {
               "\u092a\u0947\u0930\u0942 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "PET",
               "\u092a\u0947\u0930\u0941 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "PEST",
               "\u092a\u0947\u0930\u0941 \u0938\u092e\u092f",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0917\u094d\u0930\u0940\u0928\u0932\u094d\u092f\u093e\u0923\u094d\u0921 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "WGT",
               "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0917\u094d\u0930\u0940\u0928\u0932\u094d\u092f\u093e\u0923\u094d\u0921 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "WGST",
               "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0917\u094d\u0930\u0940\u0928\u0932\u094d\u092f\u093e\u0923\u094d\u0921 \u0938\u092e\u092f",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "\u0908\u0915\u094d\u0935\u094b\u0921\u094b\u0930 \u0938\u092e\u092f",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0917\u094d\u0930\u0940\u0928\u0932\u094d\u092f\u093e\u0923\u094d\u0921 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "EGT",
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0917\u094d\u0930\u0940\u0928\u0932\u094d\u092f\u093e\u0921 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "EGST",
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0917\u094d\u0930\u0940\u0928\u0932\u094d\u092f\u093e\u0921 \u0938\u092e\u092f",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "\u0916\u093e\u0921\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0907\u0928\u094d\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e \u0938\u092e\u092f",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "\u0915\u094b\u0930\u093f\u092f\u093e\u0932\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "KST",
               "\u0915\u094b\u0930\u093f\u092f\u093e\u0932\u0940 \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "KDT",
               "\u0915\u094b\u0930\u093f\u092f\u093e\u0932\u0940 \u0938\u092e\u092f",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AWST",
               "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "AWDT",
               "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0938\u092e\u092f",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "\u0915\u093f\u0930\u094d\u0917\u093f\u0938\u094d\u0924\u093e\u0928 \u0938\u092e\u092f",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0907\u0928\u094d\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e \u0938\u092e\u092f",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AEST",
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "AEDT",
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0938\u092e\u092f",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "\u092b\u094d\u0930\u0947\u0928\u094d\u091a \u0917\u094d\u0935\u093e\u0928\u093e \u0938\u092e\u092f",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "\u0915\u094b\u0932\u092e\u094d\u092c\u093f\u092f\u093e\u0932\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "COT",
               "\u0915\u094b\u0932\u092e\u094d\u092c\u093f\u092f\u093e\u0932\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "COST",
               "\u0915\u094b\u0932\u092e\u094d\u092c\u093f\u092f\u093e\u0932\u0940 \u0938\u092e\u092f",
               "COT",
            };
        final String[] Chile = new String[] {
               "\u091a\u093f\u0932\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "CLT",
               "\u091a\u093f\u0932\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "CLST",
               "\u091a\u093f\u0932\u0940 \u0938\u092e\u092f",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u0917\u093f\u0932\u094d\u092c\u0930\u094d\u091f \u091f\u093e\u092a\u0941 \u0938\u092e\u092f",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "\u0939\u093f\u092e\u093e\u0932\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "MST",
               "\u0939\u093f\u092e\u093e\u0932\u0940 \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "MDT",
               "\u0939\u093f\u092e\u093e\u0932\u0940 \u0938\u092e\u092f",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "\u092e\u093e\u0930\u094d\u0915\u093f\u0938\u0938 \u0938\u092e\u092f",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "\u0905\u0930\u092c\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AST",
               "\u0905\u0930\u092c\u0940 \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "ADT",
               "\u0905\u0930\u092c\u0940 \u0938\u092e\u092f",
               "AT",
            };
        final String[] Alaska = new String[] {
               "\u0905\u0932\u093e\u0938\u094d\u0915\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AKST",
               "\u0905\u0932\u0938\u094d\u0915\u093e \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "AKDT",
               "\u0905\u0932\u093e\u0938\u094d\u0915\u093e \u0938\u092e\u092f",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "\u092d\u094d\u0932\u093e\u0926\u093f\u092d\u093e\u0938\u094d\u091f\u094b\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "VLAT",
               "\u092d\u094d\u0932\u093e\u0926\u093f\u092d\u093e\u0938\u094d\u091f\u094b\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "VLAST",
               "\u092d\u094d\u0932\u093e\u0926\u093f\u092d\u093e\u0938\u094d\u091f\u094b\u0915 \u0938\u092e\u092f",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "\u091a\u093e\u092e\u094b\u0930\u094d\u0930\u094b \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "\u0908\u0930\u094d\u0915\u0941\u091f\u094d\u0938\u094d\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "IRKT",
               "\u0908\u0930\u094d\u0915\u0941\u091f\u094d\u0938\u094d\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "IRKST",
               "\u0908\u0930\u094d\u0915\u0941\u091f\u094d\u0938\u094d\u0915 \u0938\u092e\u092f",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "\u091c\u0930\u094d\u091c\u093f\u092f\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "GET",
               "\u091c\u0930\u094d\u091c\u093f\u092f\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "GEST",
               "\u091c\u0930\u094d\u091c\u093f\u092f\u093e \u0938\u092e\u092f",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "\u0924\u094b\u0915\u0947\u0932\u093e\u0909 \u0938\u092e\u092f",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u092a\u092a\u0942\u0935\u093e \u0928\u094d\u092f\u0942 \u0917\u093f\u0928\u0940 \u0938\u092e\u092f",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "\u092b\u0930\u094d\u0928\u093e\u0928\u094d\u0921\u094b \u0921\u0947 \u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "FNT",
               "\u092b\u0930\u094d\u0928\u093e\u0928\u094d\u0921\u094b \u0921\u0947 \u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "FNST",
               "\u092b\u0930\u094d\u0928\u093e\u0928\u094d\u0921\u094b \u0921\u0947 \u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e \u0938\u092e\u092f",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u091a\u094b\u0907\u092c\u093e\u0932\u094d\u0938\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "CHOT",
               "\u091a\u094b\u0907\u092c\u093e\u0932\u094d\u0938\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "CHOST",
               "\u091a\u094b\u0907\u092c\u093e\u0932\u094d\u0938\u0928 \u0938\u092e\u092f",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "\u092c\u094d\u0930\u093e\u091c\u093f\u0932\u093f\u092f\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "BRT",
               "\u092c\u094d\u0930\u093e\u091c\u093f\u0932\u0940\u092f\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "BRST",
               "\u092c\u094d\u0930\u093e\u091c\u093f\u0932\u0940\u092f\u093e \u0938\u092e\u092f",
               "BRT",
            };
        final String[] China = new String[] {
               "\u091a\u0940\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "CST",
               "\u091a\u0940\u0928 \u0926\u093f\u0935\u093e \u0938\u092e\u092f",
               "CDT",
               "\u091a\u0940\u0928 \u0938\u092e\u092f",
               "CT",
            };
        final String[] Armenia = new String[] {
               "\u0905\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AMT",
               "\u0905\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "AMST",
               "\u0905\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e \u0938\u092e\u092f",
               "AMT",
            };
        final String[] India = new String[] {
               "\u092d\u093e\u0930\u0924\u0940\u092f \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "\u0915\u0941\u0915 \u091f\u093e\u092a\u0941 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "CKT",
               "\u0915\u0941\u0915 \u091f\u093e\u092a\u0941 \u0906\u0927\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "CKHST",
               "\u0915\u0941\u0915 \u091f\u093e\u092a\u0941 \u0938\u092e\u092f",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "\u0917\u094d\u0930\u0940\u0928\u0935\u093f\u091a \u092e\u093f\u0928 \u0938\u092e\u092f",
                    "GMT",
                    "\u092c\u0947\u0932\u093e\u092f\u0924\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "\u0917\u094d\u0930\u0940\u0928\u0935\u093f\u091a \u092e\u093f\u0928 \u0938\u092e\u092f",
                    "GMT",
                    "\u0906\u0907\u0930\u093f\u0936 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
