/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.ldap;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.xpack.core.security.authc.ldap.PoolingSessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.SearchGroupsResolverSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.UserAttributeGroupsResolverSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.core.security.authc.ldap.support.SessionFactorySettings;

public final class LdapUserSearchSessionFactorySettings {
    public static final Setting<String> SEARCH_ATTRIBUTE = new Setting("user_search.attribute", "uid", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated});
    public static final Setting<String> SEARCH_BASE_DN = Setting.simpleString((String)"user_search.base_dn", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> SEARCH_FILTER = Setting.simpleString((String)"user_search.filter", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<LdapSearchScope> SEARCH_SCOPE = new Setting("user_search.scope", (String)null, s -> LdapSearchScope.resolve(s, LdapSearchScope.SUB_TREE), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> POOL_ENABLED = Setting.boolSetting((String)"user_search.pool.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final String DEFAULT_USERNAME_ATTRIBUTE = "uid";

    private LdapUserSearchSessionFactorySettings() {
    }

    public static Set<Setting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.addAll(SessionFactorySettings.getSettings());
        settings.addAll(PoolingSessionFactorySettings.getSettings());
        settings.add(SEARCH_BASE_DN);
        settings.add(SEARCH_SCOPE);
        settings.add(SEARCH_ATTRIBUTE);
        settings.add(POOL_ENABLED);
        settings.add(SEARCH_FILTER);
        settings.addAll(SearchGroupsResolverSettings.getSettings());
        settings.addAll(UserAttributeGroupsResolverSettings.getSettings());
        return settings;
    }
}

