/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.impl.client.ClientStorageSaveContext;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.opensaml.storage.impl.client.ClientStorageServiceOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateClientStorageSaveContext<InboundMessageType, OutboundMessageType>
extends AbstractProfileAction<InboundMessageType, OutboundMessageType> {
    @Nonnull
    @NotEmpty
    public static final String SAVE_NOT_NEEDED = "NoSaveNeeded";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateClientStorageSaveContext.class);
    @Nonnull
    @NonnullElements
    private Collection<ClientStorageService> storageServices = Collections.emptyList();

    public void setStorageServices(@Nonnull @NonnullElements Collection<ClientStorageService> services) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(services, (String)"StorageService collection cannot be null");
        this.storageServices = new ArrayList<ClientStorageService>(Collections2.filter(services, (Predicate)Predicates.notNull()));
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            ActionSupport.buildEvent(profileRequestContext, (String)SAVE_NOT_NEEDED);
            return false;
        }
        if (this.storageServices.isEmpty()) {
            this.log.debug("{} No ClientStorageServices supplied, nothing to do", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, (String)SAVE_NOT_NEEDED);
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext) {
        ClientStorageSaveContext saveCtx = new ClientStorageSaveContext();
        for (ClientStorageService service : this.storageServices) {
            ClientStorageServiceOperation operation = service.save();
            if (operation == null) continue;
            saveCtx.getStorageOperations().add(operation);
        }
        if (saveCtx.getStorageOperations().isEmpty()) {
            this.log.debug("{} No ClientStorageServices require saving, nothing to do", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, (String)SAVE_NOT_NEEDED);
        } else {
            Collection ids = Collections2.transform(saveCtx.getStorageOperations(), (Function)new Function<ClientStorageServiceOperation, String>(){

                public String apply(ClientStorageServiceOperation input) {
                    return input.getStorageServiceID();
                }
            });
            this.log.debug("{} ClientStorageServices requiring save: {}", (Object)this.getLogPrefix(), (Object)ids);
            profileRequestContext.addSubcontext((BaseContext)saveCtx, true);
        }
    }
}

