/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.retention;

import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.CategorizerState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.ml.job.persistence.BatchedStateDocIdsIterator;
import org.elasticsearch.xpack.ml.job.retention.MlDataRemover;

public class UnusedStateRemover
implements MlDataRemover {
    private static final Logger LOGGER = Loggers.getLogger(UnusedStateRemover.class);
    private final Client client;
    private final ClusterService clusterService;

    public UnusedStateRemover(Client client, ClusterService clusterService) {
        this.client = Objects.requireNonNull(client);
        this.clusterService = Objects.requireNonNull(clusterService);
    }

    @Override
    public void remove(ActionListener<Boolean> listener) {
        try {
            BulkRequestBuilder deleteUnusedStateRequestBuilder = this.findUnusedStateDocs();
            if (deleteUnusedStateRequestBuilder.numberOfActions() > 0) {
                this.executeDeleteUnusedStateDocs(deleteUnusedStateRequestBuilder, listener);
            } else {
                listener.onResponse((Object)true);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private BulkRequestBuilder findUnusedStateDocs() {
        Set<String> jobIds = this.getJobIds();
        BulkRequestBuilder deleteUnusedStateRequestBuilder = this.client.prepareBulk();
        BatchedStateDocIdsIterator stateDocIdsIterator = new BatchedStateDocIdsIterator(this.client, AnomalyDetectorsIndex.jobStateIndexName());
        while (stateDocIdsIterator.hasNext()) {
            Deque stateDocIds = stateDocIdsIterator.next();
            for (String stateDocId : stateDocIds) {
                String jobId = JobIdExtractor.extractJobId(stateDocId);
                if (jobId == null || jobIds.contains(jobId)) continue;
                deleteUnusedStateRequestBuilder.add(new DeleteRequest(AnomalyDetectorsIndex.jobStateIndexName(), "doc", stateDocId));
            }
        }
        return deleteUnusedStateRequestBuilder;
    }

    private Set<String> getJobIds() {
        return MlMetadata.getMlMetadata((ClusterState)this.clusterService.state()).getJobs().keySet();
    }

    private void executeDeleteUnusedStateDocs(BulkRequestBuilder deleteUnusedStateRequestBuilder, final ActionListener<Boolean> listener) {
        LOGGER.info("Found [{}] unused state documents; attempting to delete", (Object)deleteUnusedStateRequestBuilder.numberOfActions());
        deleteUnusedStateRequestBuilder.execute((ActionListener)new ActionListener<BulkResponse>(){

            public void onResponse(BulkResponse bulkItemResponses) {
                if (bulkItemResponses.hasFailures()) {
                    LOGGER.error("Some unused state documents could not be deleted due to failures: {}", (Object)bulkItemResponses.buildFailureMessage());
                } else {
                    LOGGER.info("Successfully deleted all unused state documents");
                }
                listener.onResponse((Object)true);
            }

            public void onFailure(Exception e) {
                LOGGER.error("Error deleting unused model state documents: ", (Throwable)e);
                listener.onFailure(e);
            }
        });
    }

    private static class JobIdExtractor {
        private static List<Function<String, String>> extractors = Arrays.asList(ModelState::extractJobId, Quantiles::extractJobId, CategorizerState::extractJobId);

        private JobIdExtractor() {
        }

        private static String extractJobId(String docId) {
            for (Function<String, String> extractor : extractors) {
                String jobId = extractor.apply(docId);
                if (jobId == null) continue;
                return jobId;
            }
            return null;
        }
    }
}

