/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener.interceptor;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedExtendedRequest;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedExtendedResult;
import com.unboundid.ldap.listener.interceptor.InterceptedOperation;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.util.Mutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
final class InterceptedExtendedOperation
extends InterceptedOperation
implements InMemoryInterceptedExtendedRequest,
InMemoryInterceptedExtendedResult {
    private ExtendedRequest extendedRequest;
    private ExtendedResult extendedResult;

    InterceptedExtendedOperation(LDAPListenerClientConnection clientConnection, int messageID, ExtendedRequestProtocolOp requestOp, Control ... requestControls) {
        super(clientConnection, messageID);
        this.extendedRequest = requestOp.toExtendedRequest(requestControls);
        this.extendedResult = null;
    }

    public ExtendedRequest getRequest() {
        return this.extendedRequest;
    }

    public void setRequest(ExtendedRequest extendedRequest) {
        this.extendedRequest = extendedRequest;
    }

    public ExtendedResult getResult() {
        return this.extendedResult;
    }

    public void setResult(ExtendedResult extendedResult) {
        this.extendedResult = extendedResult;
    }

    public void toString(StringBuilder buffer) {
        buffer.append("InterceptedExtendedOperation(");
        this.appendCommonToString(buffer);
        buffer.append(", request=");
        buffer.append(this.extendedRequest);
        buffer.append(", result=");
        buffer.append(this.extendedResult);
        buffer.append(')');
    }
}

