/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.GenericSASLBindRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.LDAPSDKUsageException;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class BindRequestProtocolOp
implements ProtocolOp {
    public static final byte CRED_TYPE_SIMPLE = -128;
    public static final byte CRED_TYPE_SASL = -93;
    private static final long serialVersionUID = 6661208657485444954L;
    private final ASN1OctetString saslCredentials;
    private final ASN1OctetString simplePassword;
    private final byte credentialsType;
    private final int version;
    private final String bindDN;
    private final String saslMechanism;

    public BindRequestProtocolOp(String bindDN, String password) {
        this.bindDN = bindDN == null ? "" : bindDN;
        this.simplePassword = password == null ? new ASN1OctetString(-128) : new ASN1OctetString(-128, password);
        this.version = 3;
        this.credentialsType = (byte)-128;
        this.saslMechanism = null;
        this.saslCredentials = null;
    }

    public BindRequestProtocolOp(String bindDN, byte[] password) {
        this.bindDN = bindDN == null ? "" : bindDN;
        this.simplePassword = password == null ? new ASN1OctetString(-128) : new ASN1OctetString(-128, password);
        this.version = 3;
        this.credentialsType = (byte)-128;
        this.saslMechanism = null;
        this.saslCredentials = null;
    }

    public BindRequestProtocolOp(String bindDN, String saslMechanism, ASN1OctetString saslCredentials) {
        this.saslMechanism = saslMechanism;
        this.saslCredentials = saslCredentials;
        this.bindDN = bindDN == null ? "" : bindDN;
        this.version = 3;
        this.credentialsType = (byte)-93;
        this.simplePassword = null;
    }

    public BindRequestProtocolOp(SimpleBindRequest request) throws LDAPSDKUsageException {
        this.version = 3;
        this.credentialsType = (byte)-128;
        this.bindDN = request.getBindDN();
        this.simplePassword = request.getPassword();
        this.saslMechanism = null;
        this.saslCredentials = null;
        if (this.simplePassword == null) {
            throw new LDAPSDKUsageException(ProtocolMessages.ERR_BIND_REQUEST_CANNOT_CREATE_WITH_PASSWORD_PROVIDER.get());
        }
    }

    public BindRequestProtocolOp(GenericSASLBindRequest request) {
        this.version = 3;
        this.credentialsType = (byte)-93;
        this.bindDN = request.getBindDN();
        this.simplePassword = null;
        this.saslMechanism = request.getSASLMechanismName();
        this.saslCredentials = request.getCredentials();
    }

    BindRequestProtocolOp(ASN1StreamReader reader) throws LDAPException {
        try {
            reader.beginSequence();
            this.version = reader.readInteger();
            this.bindDN = reader.readString();
            this.credentialsType = (byte)reader.peek();
            Validator.ensureNotNull(this.bindDN);
            switch (this.credentialsType) {
                case -128: {
                    this.simplePassword = new ASN1OctetString(this.credentialsType, reader.readBytes());
                    this.saslMechanism = null;
                    this.saslCredentials = null;
                    Validator.ensureNotNull(this.bindDN);
                    break;
                }
                case -93: {
                    ASN1StreamReaderSequence saslSequence = reader.beginSequence();
                    this.saslMechanism = reader.readString();
                    Validator.ensureNotNull(this.saslMechanism);
                    this.saslCredentials = saslSequence.hasMoreElements() ? new ASN1OctetString(reader.readBytes()) : null;
                    this.simplePassword = null;
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_REQUEST_INVALID_CRED_TYPE.get(StaticUtils.toHex(this.credentialsType)));
                }
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private BindRequestProtocolOp(int version, String bindDN, byte credentialsType, ASN1OctetString simplePassword, String saslMechanism, ASN1OctetString saslCredentials) {
        this.version = version;
        this.bindDN = bindDN;
        this.credentialsType = credentialsType;
        this.simplePassword = simplePassword;
        this.saslMechanism = saslMechanism;
        this.saslCredentials = saslCredentials;
    }

    public int getVersion() {
        return this.version;
    }

    public String getBindDN() {
        return this.bindDN;
    }

    public byte getCredentialsType() {
        return this.credentialsType;
    }

    public ASN1OctetString getSimplePassword() {
        return this.simplePassword;
    }

    public String getSASLMechanism() {
        return this.saslMechanism;
    }

    public ASN1OctetString getSASLCredentials() {
        return this.saslCredentials;
    }

    public byte getProtocolOpType() {
        return 96;
    }

    public ASN1Element encodeProtocolOp() {
        ASN1Element credentials = this.credentialsType == -128 ? this.simplePassword : (this.saslCredentials == null ? new ASN1Sequence(-93, new ASN1OctetString(this.saslMechanism)) : new ASN1Sequence(-93, new ASN1OctetString(this.saslMechanism), this.saslCredentials));
        return new ASN1Sequence(96, new ASN1Integer(this.version), new ASN1OctetString(this.bindDN), credentials);
    }

    public static BindRequestProtocolOp decodeProtocolOp(ASN1Element element) throws LDAPException {
        try {
            ASN1OctetString saslCredentials;
            String saslMechanism;
            ASN1OctetString simplePassword;
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(element).elements();
            int version = ASN1Integer.decodeAsInteger(elements[0]).intValue();
            String bindDN = ASN1OctetString.decodeAsOctetString(elements[1]).stringValue();
            switch (elements[2].getType()) {
                case -128: {
                    simplePassword = ASN1OctetString.decodeAsOctetString(elements[2]);
                    saslMechanism = null;
                    saslCredentials = null;
                    break;
                }
                case -93: {
                    ASN1Element[] saslElements = ASN1Sequence.decodeAsSequence(elements[2]).elements();
                    saslMechanism = ASN1OctetString.decodeAsOctetString(saslElements[0]).stringValue();
                    saslCredentials = saslElements.length == 1 ? null : ASN1OctetString.decodeAsOctetString(saslElements[1]);
                    simplePassword = null;
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_REQUEST_INVALID_CRED_TYPE.get(StaticUtils.toHex(elements[2].getType())));
                }
            }
            return new BindRequestProtocolOp(version, bindDN, elements[2].getType(), simplePassword, saslMechanism, saslCredentials);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public void writeTo(ASN1Buffer buffer) {
        ASN1BufferSequence opSequence = buffer.beginSequence((byte)96);
        buffer.addInteger(this.version);
        buffer.addOctetString(this.bindDN);
        if (this.credentialsType == -128) {
            buffer.addElement(this.simplePassword);
        } else {
            ASN1BufferSequence saslSequence = buffer.beginSequence((byte)-93);
            buffer.addOctetString(this.saslMechanism);
            if (this.saslCredentials != null) {
                buffer.addElement(this.saslCredentials);
            }
            saslSequence.end();
        }
        opSequence.end();
        buffer.setZeroBufferOnClear();
    }

    public BindRequest toBindRequest(Control ... controls) {
        if (this.credentialsType == -128) {
            return new SimpleBindRequest(this.bindDN, this.simplePassword.getValue(), controls);
        }
        return new GenericSASLBindRequest(this.bindDN, this.saslMechanism, this.saslCredentials, controls);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("BindRequestProtocolOp(version=");
        buffer.append(this.version);
        buffer.append(", bindDN='");
        buffer.append(this.bindDN);
        buffer.append("', type=");
        if (this.credentialsType == -128) {
            buffer.append("simple");
        } else {
            buffer.append("SASL, mechanism=");
            buffer.append(this.saslMechanism);
        }
        buffer.append(')');
    }
}

