/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.action.user.PutUserRequestBuilder;
import org.elasticsearch.xpack.core.security.action.user.PutUserResponse;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.core.security.rest.RestRequestFilter;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestPutUserAction
extends SecurityBaseRestHandler
implements RestRequestFilter {
    private final Hasher passwordHasher;
    private static final Set<String> FILTERED_FIELDS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"password", "passwordHash"}));

    public RestPutUserAction(Settings settings, RestController controller, XPackLicenseState licenseState) {
        super(settings, licenseState);
        this.passwordHasher = Hasher.resolve((String)((String)XPackSettings.PASSWORD_HASHING_ALGORITHM.get(this.settings)));
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/user/{username}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.PUT, "/_xpack/security/user/{username}", (RestHandler)this);
        controller.registerAsDeprecatedHandler(RestRequest.Method.POST, "/_shield/user/{username}", (RestHandler)this, "[POST /_shield/user/{username}] is deprecated! Use [POST /_xpack/security/user/{username}] instead.", this.deprecationLogger);
        controller.registerAsDeprecatedHandler(RestRequest.Method.PUT, "/_shield/user/{username}", (RestHandler)this, "[PUT /_shield/user/{username}] is deprecated! Use [PUT /_xpack/security/user/{username}] instead.", this.deprecationLogger);
    }

    public String getName() {
        return "xpack_security_put_user_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutUserRequestBuilder requestBuilder = (PutUserRequestBuilder)new SecurityClient((ElasticsearchClient)client).preparePutUser(request.param("username"), request.requiredContent(), request.getXContentType(), this.passwordHasher).setRefreshPolicy(request.param("refresh"));
        return channel -> requestBuilder.execute((ActionListener)new RestBuilderListener<PutUserResponse>(channel){

            public RestResponse buildResponse(PutUserResponse putUserResponse, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(RestStatus.OK, builder.startObject().field("user", (ToXContent)putUserResponse).endObject());
            }
        });
    }

    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }
}

