/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.matcher;

import org.elasticsearch.common.inject.matcher.Matcher;

public abstract class AbstractMatcher<T>
implements Matcher<T> {
    @Override
    public Matcher<T> and(Matcher<? super T> other) {
        return new AndMatcher<T>(this, other);
    }

    @Override
    public Matcher<T> or(Matcher<? super T> other) {
        return new OrMatcher<T>(this, other);
    }

    private static class OrMatcher<T>
    extends AbstractMatcher<T> {
        private final Matcher<? super T> a;
        private final Matcher<? super T> b;

        OrMatcher(Matcher<? super T> a, Matcher<? super T> b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean matches(T t) {
            return this.a.matches(t) || this.b.matches(t);
        }

        public boolean equals(Object other) {
            return other instanceof OrMatcher && ((OrMatcher)other).a.equals(this.a) && ((OrMatcher)other).b.equals(this.b);
        }

        public int hashCode() {
            return 37 * (this.a.hashCode() ^ this.b.hashCode());
        }

        public String toString() {
            return "or(" + this.a + ", " + this.b + ")";
        }
    }

    private static class AndMatcher<T>
    extends AbstractMatcher<T> {
        private final Matcher<? super T> a;
        private final Matcher<? super T> b;

        AndMatcher(Matcher<? super T> a, Matcher<? super T> b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean matches(T t) {
            return this.a.matches(t) && this.b.matches(t);
        }

        public boolean equals(Object other) {
            return other instanceof AndMatcher && ((AndMatcher)other).a.equals(this.a) && ((AndMatcher)other).b.equals(this.b);
        }

        public int hashCode() {
            return 41 * (this.a.hashCode() ^ this.b.hashCode());
        }

        public String toString() {
            return "and(" + this.a + ", " + this.b + ")";
        }
    }
}

