/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.Extensions;
import org.openstreetmap.josm.data.gpx.GpxConstants;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.IWithAttributes;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.date.DateUtils;

public class GpxWriter
extends XmlWriter
implements GpxConstants {
    private final DateFormat gpxFormat = DateUtils.getGpxFormat();
    private GpxData data;
    private String indent = "";
    private static final int WAY_POINT = 0;
    private static final int ROUTE_POINT = 1;
    private static final int TRACK_POINT = 2;

    public GpxWriter(PrintWriter out) {
        super(out);
    }

    public GpxWriter(OutputStream out) {
        super(new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8))));
    }

    public void write(GpxData data) {
        this.data = data;
        boolean hasExtensions = data.fromServer;
        if (!hasExtensions) {
            for (WayPoint wpt : data.waypoints) {
                Extensions extensions = (Extensions)wpt.get("meta.extensions");
                if (extensions == null || extensions.isEmpty()) continue;
                hasExtensions = true;
                break;
            }
        }
        this.out.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.out.println("<gpx version=\"1.1\" creator=\"JOSM GPX export\" xmlns=\"http://www.topografix.com/GPX/1/1\"");
        this.out.println((hasExtensions ? String.format("    xmlns:josm=\"%s\"%n", JOSM_EXTENSIONS_NAMESPACE_URI) : "") + "    xmlns:xsi=\"" + "http://www.w3.org/2001/XMLSchema-instance" + "\"");
        this.out.println("    xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd\">");
        this.indent = "  ";
        this.writeMetaData();
        this.writeWayPoints();
        this.writeRoutes();
        this.writeTracks();
        this.out.print("</gpx>");
        this.out.flush();
    }

    private void writeAttr(IWithAttributes obj, List<String> keys) {
        for (String key : keys) {
            if ("meta.links".equals(key)) {
                Collection lValue = obj.getCollection(key);
                if (lValue == null) continue;
                for (GpxLink link : lValue) {
                    this.gpxLink(link);
                }
                continue;
            }
            if ("meta.extensions".equals(key)) {
                Extensions extensions = (Extensions)obj.get(key);
                if (extensions == null) continue;
                this.gpxExtensions(extensions);
                continue;
            }
            String value = obj.getString(key);
            if (value != null) {
                this.simpleTag(key, value);
                continue;
            }
            Object val = obj.get(key);
            if (!(val instanceof Date)) continue;
            this.simpleTag(key, this.gpxFormat.format(val));
        }
    }

    private void writeMetaData() {
        Bounds bounds;
        Map attr = this.data.attr;
        this.openln("metadata");
        if (attr.containsKey("meta.desc")) {
            this.simpleTag("desc", this.data.getString("meta.desc"));
        }
        if (attr.containsKey("meta.author.name") || attr.containsKey("meta.author.email")) {
            Object tmp;
            this.openln("author");
            this.simpleTag("name", this.data.getString("meta.author.name"));
            if (attr.containsKey("meta.author.email") && ((String[])(tmp = this.data.getString("meta.author.email").split("@"))).length == 2) {
                this.inline("email", "id=\"" + (String)tmp[0] + "\" domain=\"" + (String)tmp[1] + '\"');
            }
            this.gpxLink((GpxLink)this.data.get("meta.author.link"));
            this.closeln("author");
        }
        if (attr.containsKey("meta.copyright.license") || attr.containsKey("meta.copyright.year")) {
            this.openAtt("copyright", "author=\"" + this.data.get("meta.copyright.author") + '\"');
            if (attr.containsKey("meta.copyright.year")) {
                this.simpleTag("year", (String)this.data.get("meta.copyright.year"));
            }
            if (attr.containsKey("meta.copyright.license")) {
                this.simpleTag("license", GpxWriter.encode((String)this.data.get("meta.copyright.license")));
            }
            this.closeln("copyright");
        }
        if (attr.containsKey("meta.links")) {
            for (GpxLink link : this.data.getCollection("meta.links")) {
                this.gpxLink(link);
            }
        }
        if (attr.containsKey("meta.keywords")) {
            this.simpleTag("keywords", this.data.getString("meta.keywords"));
        }
        if ((bounds = this.data.recalculateBounds()) != null) {
            String b = "minlat=\"" + bounds.getMinLat() + "\" minlon=\"" + bounds.getMinLon() + "\" maxlat=\"" + bounds.getMaxLat() + "\" maxlon=\"" + bounds.getMaxLon() + '\"';
            this.inline("bounds", b);
        }
        if (this.data.fromServer) {
            this.openln("extensions");
            this.simpleTag("josm:from-server", "true");
            this.closeln("extensions");
        }
        this.closeln("metadata");
    }

    private void writeWayPoints() {
        for (WayPoint pnt : this.data.getWaypoints()) {
            this.wayPoint(pnt, 0);
        }
    }

    private void writeRoutes() {
        for (GpxRoute rte : this.data.getRoutes()) {
            this.openln("rte");
            this.writeAttr(rte, RTE_TRK_KEYS);
            for (WayPoint pnt : rte.routePoints) {
                this.wayPoint(pnt, 1);
            }
            this.closeln("rte");
        }
    }

    private void writeTracks() {
        for (GpxTrack trk : this.data.getTracks()) {
            this.openln("trk");
            this.writeAttr(trk, RTE_TRK_KEYS);
            for (GpxTrackSegment seg : trk.getSegments()) {
                this.openln("trkseg");
                for (WayPoint pnt : seg.getWayPoints()) {
                    this.wayPoint(pnt, 2);
                }
                this.closeln("trkseg");
            }
            this.closeln("trk");
        }
    }

    private void openln(String tag) {
        this.open(tag);
        this.out.println();
    }

    private void open(String tag) {
        this.out.print(this.indent + '<' + tag + '>');
        this.indent = this.indent + "  ";
    }

    private void openAtt(String tag, String attributes) {
        this.out.println(this.indent + '<' + tag + ' ' + attributes + '>');
        this.indent = this.indent + "  ";
    }

    private void inline(String tag, String attributes) {
        this.out.println(this.indent + '<' + tag + ' ' + attributes + "/>");
    }

    private void close(String tag) {
        this.indent = this.indent.substring(2);
        this.out.print(this.indent + "</" + tag + '>');
    }

    private void closeln(String tag) {
        this.close(tag);
        this.out.println();
    }

    private void simpleTag(String tag, String content) {
        if (content != null && !content.isEmpty()) {
            this.open(tag);
            this.out.print(GpxWriter.encode(content));
            this.out.println("</" + tag + '>');
            this.indent = this.indent.substring(2);
        }
    }

    private void gpxLink(GpxLink link) {
        if (link != null) {
            this.openAtt("link", "href=\"" + link.uri + '\"');
            this.simpleTag("text", link.text);
            this.simpleTag("type", link.type);
            this.closeln("link");
        }
    }

    private void wayPoint(WayPoint pnt, int mode) {
        String type;
        switch (mode) {
            case 0: {
                type = "wpt";
                break;
            }
            case 1: {
                type = "rtept";
                break;
            }
            case 2: {
                type = "trkpt";
                break;
            }
            default: {
                throw new JosmRuntimeException(I18n.tr("Unknown mode {0}.", mode));
            }
        }
        if (pnt != null) {
            LatLon c = pnt.getCoor();
            String coordAttr = "lat=\"" + c.lat() + "\" lon=\"" + c.lon() + '\"';
            if (pnt.attr.isEmpty()) {
                this.inline(type, coordAttr);
            } else {
                this.openAtt(type, coordAttr);
                this.writeAttr(pnt, WPT_KEYS);
                this.closeln(type);
            }
        }
    }

    private void gpxExtensions(Extensions extensions) {
        if (extensions != null && !extensions.isEmpty()) {
            this.openln("extensions");
            for (Map.Entry e : extensions.entrySet()) {
                this.simpleTag("josm:" + (String)e.getKey(), (String)e.getValue());
            }
            this.closeln("extensions");
        }
    }
}

