/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.presentation.java;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionStub;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class ClassPresentationUtil {
    private ClassPresentationUtil() {
    }

    public static String getNameForClass(@NotNull PsiClass aClass2, boolean qualified) {
        String qName;
        if (aClass2 == null) {
            ClassPresentationUtil.$$$reportNull$$$0(0);
        }
        if (aClass2 instanceof PsiAnonymousClass) {
            if (aClass2 instanceof PsiEnumConstantInitializer) {
                PsiEnumConstant enumConstant = ((PsiEnumConstantInitializer)aClass2).getEnumConstant();
                String name = enumConstant.getName();
                return PsiBundle.message("enum.constant.context", name, ClassPresentationUtil.getContextName(enumConstant, qualified, false));
            }
            return PsiBundle.message("anonymous.class.context.display", ClassPresentationUtil.getContextName(aClass2, qualified, false));
        }
        if (qualified && (qName = aClass2.getQualifiedName()) != null) {
            return qName;
        }
        String className2 = aClass2.getName();
        String contextName = ClassPresentationUtil.getContextName(aClass2, qualified);
        return contextName != null ? PsiBundle.message("class.context.display", className2, contextName) : className2;
    }

    private static String getNameForElement(@NotNull PsiElement element, boolean qualified, boolean ignorePsiClassOwner) {
        if (element == null) {
            ClassPresentationUtil.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiClass) {
            return ClassPresentationUtil.getNameForClass((PsiClass)element, qualified);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            String methodName = method.getName();
            return PsiBundle.message("method.context.display", methodName, ClassPresentationUtil.getContextName(method, qualified, false));
        }
        if (element instanceof PsiClassOwner && ignorePsiClassOwner) {
            return null;
        }
        if (element instanceof PsiFile) {
            return ((PsiFile)element).getName();
        }
        if (element instanceof PsiField) {
            return ((PsiField)element).getName() + " in " + ClassPresentationUtil.getContextName(element, qualified, false);
        }
        return null;
    }

    public static String getContextName(@NotNull PsiElement element, boolean qualified) {
        if (element == null) {
            ClassPresentationUtil.$$$reportNull$$$0(2);
        }
        return ClassPresentationUtil.getContextName(element, qualified, true);
    }

    public static String getContextName(@NotNull PsiElement element, boolean qualified, boolean ignorePsiClassOwner) {
        PsiElement parent2;
        if (element == null) {
            ClassPresentationUtil.$$$reportNull$$$0(3);
        }
        if ((parent2 = PsiTreeUtil.getStubOrPsiParentOfType(element, PsiMember.class)) == null) {
            parent2 = element.getContainingFile();
        }
        while (parent2 != null) {
            String name = ClassPresentationUtil.getNameForElement(parent2, qualified, ignorePsiClassOwner);
            if (name != null) {
                return name;
            }
            if (parent2 instanceof PsiFile) {
                return null;
            }
            parent2 = PsiTreeUtil.getStubOrPsiParent(parent2);
        }
        return null;
    }

    public static String getFunctionalExpressionPresentation(PsiFunctionalExpression functionalExpression, boolean qualified) {
        Object stub2 = ((StubBasedPsiElementBase)((Object)functionalExpression)).getGreenStub();
        String lambdaText = stub2 instanceof FunctionalExpressionStub ? ((FunctionalExpressionStub)stub2).getPresentableText() : PsiExpressionTrimRenderer.render(functionalExpression);
        return PsiBundle.message("class.context.display", lambdaText, ClassPresentationUtil.getContextName(functionalExpression, qualified, false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/presentation/java/ClassPresentationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getNameForClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getNameForElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

