/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.office.IndexMark;
import writer2latex.office.OfficeReader;
import writer2latex.util.Misc;
import writer2latex.util.StringComparator;
import writer2latex.xhtml.AlphabeticalEntry;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.IndexConverterHelper;
import writer2latex.xhtml.XhtmlConfig;

class AlphabeticalIndexConverter
extends IndexConverterHelper {
    private List<AlphabeticalEntry> index = new ArrayList<AlphabeticalEntry>();
    private int nIndexIndex = -1;
    private int nAlphabeticalIndex = -1;

    AlphabeticalIndexConverter(OfficeReader ofr, XhtmlConfig config, Converter converter) {
        super(ofr, config, converter, "text:alphabetical-index-source", "index");
    }

    int getFileIndex() {
        return this.nAlphabeticalIndex;
    }

    void handleIndexMark(Node onode, Node hnode) {
        this.handleIndexMark(Misc.getAttribute(onode, "text:string-value"), hnode);
    }

    void handleIndexMarkStart(Node onode, Node hnode) {
        this.handleIndexMark(IndexMark.getIndexValue(onode), hnode);
    }

    void handleIndexMark(String sWord, Node hnode) {
        if (sWord != null) {
            AlphabeticalEntry entry = new AlphabeticalEntry();
            entry.sWord = sWord;
            entry.nIndex = ++this.nIndexIndex;
            this.index.add(entry);
            hnode.appendChild(this.converter.createTarget("idx" + this.nIndexIndex));
        }
    }

    @Override
    void handleIndex(Element onode, Element hnode) {
        this.nAlphabeticalIndex = this.converter.getOutFileIndex();
        this.converter.setIndexFile(null);
        super.handleIndex(onode, hnode);
    }

    @Override
    void populateIndex(Element source, Element container) {
        this.sortEntries(source);
        String sEntryStyleName = this.getEntryStyleName(source);
        for (int i = 0; i <= this.nIndexIndex; ++i) {
            AlphabeticalEntry entry = this.index.get(i);
            Element li = this.converter.createElement("li");
            container.appendChild(li);
            Element p = this.getTextCv().createParagraph(li, sEntryStyleName);
            Element a = this.converter.createLink("idx" + entry.nIndex);
            p.appendChild(a);
            a.appendChild(this.converter.createTextNode(entry.sWord));
        }
    }

    private void sortEntries(Element source) {
        StringComparator<AlphabeticalEntry> comparator = new StringComparator<AlphabeticalEntry>(Misc.getAttribute(source, "fo:language"), Misc.getAttribute(source, "fo:country")){

            @Override
            public int compare(AlphabeticalEntry a, AlphabeticalEntry b) {
                return this.getCollator().compare(a.sWord, b.sWord);
            }
        };
        Collections.sort(this.index, comparator);
    }

    private String getEntryStyleName(Element source) {
        for (Node child = source.getFirstChild(); child != null; child = child.getNextSibling()) {
            int nLevel;
            if (child.getNodeType() != 1 || !child.getNodeName().equals("text:alphabetical-index-entry-template") || (nLevel = Misc.getPosInteger(Misc.getAttribute(child, "text:outline-level"), 0)) != 1) continue;
            return Misc.getAttribute(child, "text:style-name");
        }
        return null;
    }
}

