/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.CSecurity;
import com.tigervnc.rfb.CSecurityIdent;
import com.tigervnc.rfb.CSecurityNone;
import com.tigervnc.rfb.CSecurityPlain;
import com.tigervnc.rfb.CSecurityStack;
import com.tigervnc.rfb.CSecurityTLS;
import com.tigervnc.rfb.CSecurityVeNCrypt;
import com.tigervnc.rfb.CSecurityVncAuth;
import com.tigervnc.rfb.Configuration;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.Security;
import com.tigervnc.rfb.StringParameter;

public class SecurityClient
extends Security {
    public static StringParameter secTypes = new StringParameter("SecurityTypes", "Specify which security scheme to use (None, VncAuth, Plain, Ident, TLSNone, TLSVnc, TLSPlain, TLSIdent, X509None, X509Vnc, X509Plain, X509Ident)", "X509Ident,X509Plain,TLSIdent,TLSPlain,X509Vnc,TLSVnc,X509None,TLSNone,Ident,VncAuth,None", Configuration.ConfigurationObject.ConfViewer);

    public SecurityClient() {
        super(secTypes);
    }

    public CSecurity GetCSecurity(int n) {
        assert (CSecurity.upg != null);
        assert (CSecurityTLS.msg != null);
        if (!this.IsSupported(n)) {
            throw new Exception("Security type not supported");
        }
        switch (n) {
            case 1: {
                return new CSecurityNone();
            }
            case 2: {
                return new CSecurityVncAuth();
            }
            case 19: {
                return new CSecurityVeNCrypt(this);
            }
            case 256: {
                return new CSecurityPlain();
            }
            case 265: {
                return new CSecurityIdent();
            }
            case 257: {
                return new CSecurityStack(257, "TLS with no password", new CSecurityTLS(true), null);
            }
            case 258: {
                return new CSecurityStack(258, "TLS with VNCAuth", new CSecurityTLS(true), new CSecurityVncAuth());
            }
            case 259: {
                return new CSecurityStack(259, "TLS with Username/Password", new CSecurityTLS(true), new CSecurityPlain());
            }
            case 266: {
                return new CSecurityStack(266, "TLS with username only", new CSecurityTLS(true), new CSecurityIdent());
            }
            case 260: {
                return new CSecurityStack(260, "X509 with no password", new CSecurityTLS(false), null);
            }
            case 261: {
                return new CSecurityStack(261, "X509 with VNCAuth", new CSecurityTLS(false), new CSecurityVncAuth());
            }
            case 262: {
                return new CSecurityStack(262, "X509 with Username/Password", new CSecurityTLS(false), new CSecurityPlain());
            }
            case 267: {
                return new CSecurityStack(267, "X509 with username only", new CSecurityTLS(false), new CSecurityIdent());
            }
        }
        throw new Exception("Security type not supported");
    }

    public static void setDefaults() {
        CSecurityTLS.setDefaults();
    }
}

