/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.Logger;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice.Util;
import com.zeroc.IceInternal.MetricsMap;
import com.zeroc.IceInternal.MetricsViewI;
import com.zeroc.IceInternal.Time;
import com.zeroc.IceMX.Metrics;
import com.zeroc.IceMX.MetricsAdmin;
import com.zeroc.IceMX.MetricsFailures;
import com.zeroc.IceMX.UnknownMetricsView;
import com.zeroc.IceUtilInternal.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class MetricsAdminI
implements MetricsAdmin,
Consumer<Map<String, String>> {
    private static final String[] suffixes = new String[]{"Disabled", "GroupBy", "Accept.*", "Reject.*", "RetainDetached", "Map.*"};
    private Properties _properties;
    private final Logger _logger;
    private final Map<String, MetricsMapFactory<?>> _factories = new HashMap();
    private Map<String, MetricsViewI> _views = new HashMap<String, MetricsViewI>();
    private Set<String> _disabledViews = new HashSet<String>();

    static void validateProperties(String prefix, Properties properties) {
        Map<String, String> props = properties.getPropertiesForPrefix(prefix);
        ArrayList<String> unknownProps = new ArrayList<String>();
        for (String prop : props.keySet()) {
            boolean valid = false;
            for (String suffix : suffixes) {
                if (!StringUtil.match(prop, prefix + suffix, false)) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            unknownProps.add(prop);
        }
        if (unknownProps.size() != 0 && properties.getPropertyAsIntWithDefault("Ice.Warn.UnknownProperties", 1) > 0) {
            StringBuffer message = new StringBuffer("found unknown IceMX properties for `");
            message.append(prefix.substring(0, prefix.length() - 1));
            message.append("':");
            for (String p : unknownProps) {
                message.append("\n    ");
                message.append(p);
            }
            Util.getProcessLogger().warning(message.toString());
        }
    }

    public MetricsAdminI(Properties properties, Logger logger) {
        this._logger = logger;
        this._properties = properties;
        this.updateViews();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateViews() {
        HashSet updatedMaps = new HashSet();
        MetricsAdminI metricsAdminI = this;
        synchronized (metricsAdminI) {
            String string = "IceMX.Metrics.";
            Map<String, String> viewsProps = this._properties.getPropertiesForPrefix(string);
            Map<String, MetricsViewI> views = new HashMap<String, MetricsViewI>();
            this._disabledViews.clear();
            for (Map.Entry<String, String> e : viewsProps.entrySet()) {
                String viewName = e.getKey().substring(string.length());
                int dotPos = viewName.indexOf(46);
                if (dotPos > 0) {
                    viewName = viewName.substring(0, dotPos);
                }
                if (views.containsKey(viewName) || this._disabledViews.contains(viewName)) continue;
                MetricsAdminI.validateProperties(string + viewName + ".", this._properties);
                if (this._properties.getPropertyAsIntWithDefault(string + viewName + ".Disabled", 0) > 0) {
                    this._disabledViews.add(viewName);
                    continue;
                }
                MetricsViewI v = this._views.get(viewName);
                if (v == null) {
                    v = new MetricsViewI(viewName);
                }
                views.put(viewName, v);
                for (Map.Entry<String, MetricsMapFactory<?>> f : this._factories.entrySet()) {
                    if (!v.addOrUpdateMap(this._properties, f.getKey(), f.getValue(), this._logger)) continue;
                    updatedMaps.add(f.getValue());
                }
            }
            Map<String, MetricsViewI> tmp = this._views;
            this._views = views;
            views = tmp;
            for (Map.Entry<String, MetricsViewI> v : views.entrySet()) {
                if (this._views.containsKey(v.getKey())) continue;
                for (String n : v.getValue().getMaps()) {
                    updatedMaps.add(this._factories.get(n));
                }
            }
        }
        for (MetricsMapFactory metricsMapFactory : updatedMaps) {
            metricsMapFactory.update();
        }
    }

    @Override
    public synchronized MetricsAdmin.GetMetricsViewNamesResult getMetricsViewNames(Current current) {
        MetricsAdmin.GetMetricsViewNamesResult r = new MetricsAdmin.GetMetricsViewNamesResult();
        r.disabledViews = this._disabledViews.toArray(new String[this._disabledViews.size()]);
        r.returnValue = this._views.keySet().toArray(new String[this._views.size()]);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableMetricsView(String name, Current current) throws UnknownMetricsView {
        MetricsAdminI metricsAdminI = this;
        synchronized (metricsAdminI) {
            this.getMetricsView(name);
            this._properties.setProperty("IceMX.Metrics." + name + ".Disabled", "0");
        }
        this.updateViews();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableMetricsView(String name, Current current) throws UnknownMetricsView {
        MetricsAdminI metricsAdminI = this;
        synchronized (metricsAdminI) {
            this.getMetricsView(name);
            this._properties.setProperty("IceMX.Metrics." + name + ".Disabled", "1");
        }
        this.updateViews();
    }

    @Override
    public synchronized MetricsAdmin.GetMetricsViewResult getMetricsView(String viewName, Current current) throws UnknownMetricsView {
        MetricsAdmin.GetMetricsViewResult r = new MetricsAdmin.GetMetricsViewResult();
        MetricsViewI view = this.getMetricsView(viewName);
        r.timestamp = Time.currentMonotonicTimeMillis();
        r.returnValue = view != null ? view.getMetrics() : new HashMap<String, Metrics[]>();
        return r;
    }

    @Override
    public synchronized MetricsFailures[] getMapMetricsFailures(String viewName, String mapName, Current current) throws UnknownMetricsView {
        MetricsViewI view = this.getMetricsView(viewName);
        if (view != null) {
            return view.getFailures(mapName);
        }
        return new MetricsFailures[0];
    }

    @Override
    public synchronized MetricsFailures getMetricsFailures(String viewName, String mapName, String id, Current current) throws UnknownMetricsView {
        MetricsViewI view = this.getMetricsView(viewName);
        if (view != null) {
            return view.getFailures(mapName, id);
        }
        return new MetricsFailures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Metrics> void registerMap(String map, Class<T> cl, Runnable updater) {
        boolean updated;
        MetricsMapFactory<T> factory;
        MetricsAdminI metricsAdminI = this;
        synchronized (metricsAdminI) {
            factory = new MetricsMapFactory<T>(updater, cl);
            this._factories.put(map, factory);
            updated = this.addOrUpdateMap(map, factory);
        }
        if (updated) {
            factory.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <S extends Metrics> void registerSubMap(String map, String subMap, Class<S> cl, Field field) {
        boolean updated;
        MetricsMapFactory<?> factory;
        MetricsAdminI metricsAdminI = this;
        synchronized (metricsAdminI) {
            factory = this._factories.get(map);
            if (factory == null) {
                return;
            }
            factory.registerSubMap(subMap, cl, field);
            this.removeMap(map);
            updated = this.addOrUpdateMap(map, factory);
        }
        if (updated) {
            factory.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMap(String mapName) {
        boolean updated;
        MetricsMapFactory<?> factory;
        MetricsAdminI metricsAdminI = this;
        synchronized (metricsAdminI) {
            factory = this._factories.remove(mapName);
            if (factory == null) {
                return;
            }
            updated = this.removeMap(mapName);
        }
        if (updated) {
            factory.update();
        }
    }

    public <T extends Metrics> List<MetricsMap<T>> getMaps(String mapName, Class<T> cl) {
        ArrayList<MetricsMap<T>> maps = new ArrayList<MetricsMap<T>>();
        for (MetricsViewI v : this._views.values()) {
            MetricsMap<T> map = v.getMap(mapName, cl);
            if (map == null) continue;
            maps.add(map);
        }
        return maps;
    }

    public Logger getLogger() {
        return this._logger;
    }

    @Override
    public void accept(Map<String, String> props) {
        for (Map.Entry<String, String> e : props.entrySet()) {
            if (e.getKey().indexOf("IceMX.") != 0) continue;
            try {
                this.updateViews();
            }
            catch (Exception ex) {
                this._logger.warning("unexpected exception while updating metrics view configuration:\n" + ex.toString());
            }
            return;
        }
    }

    private MetricsViewI getMetricsView(String name) throws UnknownMetricsView {
        MetricsViewI view = this._views.get(name);
        if (view == null) {
            if (!this._disabledViews.contains(name)) {
                throw new UnknownMetricsView();
            }
            return null;
        }
        return view;
    }

    private boolean addOrUpdateMap(String mapName, MetricsMapFactory<?> factory) {
        boolean updated = false;
        for (MetricsViewI v : this._views.values()) {
            updated |= v.addOrUpdateMap(this._properties, mapName, factory, this._logger);
        }
        return updated;
    }

    private boolean removeMap(String mapName) {
        boolean updated = false;
        for (MetricsViewI v : this._views.values()) {
            updated |= v.removeMap(mapName);
        }
        return updated;
    }

    static class MetricsMapFactory<T extends Metrics> {
        private final Runnable _updater;
        private final Class<T> _class;
        private final Map<String, MetricsMap.SubMapFactory<?>> _subMaps = new HashMap();

        public MetricsMapFactory(Runnable updater, Class<T> cl) {
            this._updater = updater;
            this._class = cl;
        }

        public void update() {
            assert (this._updater != null);
            this._updater.run();
        }

        public MetricsMap<T> create(String mapPrefix, Properties properties) {
            return new MetricsMap<T>(mapPrefix, this._class, properties, this._subMaps);
        }

        public <S extends Metrics> void registerSubMap(String subMap, Class<S> cl, Field field) {
            this._subMaps.put(subMap, new MetricsMap.SubMapFactory<S>(cl, field));
        }
    }
}

