/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public final class Unsafe {
    private static final Unsafe theUnsafe;
    public static final int INVALID_FIELD_OFFSET = -1;
    private static final boolean BE;
    private static final boolean unalignedAccess;
    public static final int ARRAY_BOOLEAN_BASE_OFFSET;
    public static final int ARRAY_BYTE_BASE_OFFSET;
    public static final int ARRAY_SHORT_BASE_OFFSET;
    public static final int ARRAY_CHAR_BASE_OFFSET;
    public static final int ARRAY_INT_BASE_OFFSET;
    public static final int ARRAY_LONG_BASE_OFFSET;
    public static final int ARRAY_FLOAT_BASE_OFFSET;
    public static final int ARRAY_DOUBLE_BASE_OFFSET;
    public static final int ARRAY_OBJECT_BASE_OFFSET;
    public static final int ARRAY_BOOLEAN_INDEX_SCALE;
    public static final int ARRAY_BYTE_INDEX_SCALE;
    public static final int ARRAY_SHORT_INDEX_SCALE;
    public static final int ARRAY_CHAR_INDEX_SCALE;
    public static final int ARRAY_INT_INDEX_SCALE;
    public static final int ARRAY_LONG_INDEX_SCALE;
    public static final int ARRAY_FLOAT_INDEX_SCALE;
    public static final int ARRAY_DOUBLE_INDEX_SCALE;
    public static final int ARRAY_OBJECT_INDEX_SCALE;
    public static final int ADDRESS_SIZE;

    private static native void registerNatives();

    private Unsafe() {
    }

    @CallerSensitive
    public static Unsafe getUnsafe() {
        Class cc = Reflection.getCallerClass();
        if (cc.getClassLoader() != null) {
            throw new SecurityException("Unsafe");
        }
        return theUnsafe;
    }

    public native int getInt(Object var1, long var2);

    public native void putInt(Object var1, long var2, int var4);

    public native Object getObject(Object var1, long var2);

    public native void putObject(Object var1, long var2, Object var4);

    public native boolean getBoolean(Object var1, long var2);

    public native void putBoolean(Object var1, long var2, boolean var4);

    public native byte getByte(Object var1, long var2);

    public native void putByte(Object var1, long var2, byte var4);

    public native short getShort(Object var1, long var2);

    public native void putShort(Object var1, long var2, short var4);

    public native char getChar(Object var1, long var2);

    public native void putChar(Object var1, long var2, char var4);

    public native long getLong(Object var1, long var2);

    public native void putLong(Object var1, long var2, long var4);

    public native float getFloat(Object var1, long var2);

    public native void putFloat(Object var1, long var2, float var4);

    public native double getDouble(Object var1, long var2);

    public native void putDouble(Object var1, long var2, double var4);

    @Deprecated
    public int getInt(Object o, int offset) {
        return this.getInt(o, (long)offset);
    }

    @Deprecated
    public void putInt(Object o, int offset, int x) {
        this.putInt(o, (long)offset, x);
    }

    @Deprecated
    public Object getObject(Object o, int offset) {
        return this.getObject(o, (long)offset);
    }

    @Deprecated
    public void putObject(Object o, int offset, Object x) {
        this.putObject(o, (long)offset, x);
    }

    @Deprecated
    public boolean getBoolean(Object o, int offset) {
        return this.getBoolean(o, (long)offset);
    }

    @Deprecated
    public void putBoolean(Object o, int offset, boolean x) {
        this.putBoolean(o, (long)offset, x);
    }

    @Deprecated
    public byte getByte(Object o, int offset) {
        return this.getByte(o, (long)offset);
    }

    @Deprecated
    public void putByte(Object o, int offset, byte x) {
        this.putByte(o, (long)offset, x);
    }

    @Deprecated
    public short getShort(Object o, int offset) {
        return this.getShort(o, (long)offset);
    }

    @Deprecated
    public void putShort(Object o, int offset, short x) {
        this.putShort(o, (long)offset, x);
    }

    @Deprecated
    public char getChar(Object o, int offset) {
        return this.getChar(o, (long)offset);
    }

    @Deprecated
    public void putChar(Object o, int offset, char x) {
        this.putChar(o, (long)offset, x);
    }

    @Deprecated
    public long getLong(Object o, int offset) {
        return this.getLong(o, (long)offset);
    }

    @Deprecated
    public void putLong(Object o, int offset, long x) {
        this.putLong(o, (long)offset, x);
    }

    @Deprecated
    public float getFloat(Object o, int offset) {
        return this.getFloat(o, (long)offset);
    }

    @Deprecated
    public void putFloat(Object o, int offset, float x) {
        this.putFloat(o, (long)offset, x);
    }

    @Deprecated
    public double getDouble(Object o, int offset) {
        return this.getDouble(o, (long)offset);
    }

    @Deprecated
    public void putDouble(Object o, int offset, double x) {
        this.putDouble(o, (long)offset, x);
    }

    public native byte getByte(long var1);

    public native void putByte(long var1, byte var3);

    public native short getShort(long var1);

    public native void putShort(long var1, short var3);

    public native char getChar(long var1);

    public native void putChar(long var1, char var3);

    public native int getInt(long var1);

    public native void putInt(long var1, int var3);

    public native long getLong(long var1);

    public native void putLong(long var1, long var3);

    public native float getFloat(long var1);

    public native void putFloat(long var1, float var3);

    public native double getDouble(long var1);

    public native void putDouble(long var1, double var3);

    public native long getAddress(long var1);

    public native void putAddress(long var1, long var3);

    public native long allocateMemory(long var1);

    public native long reallocateMemory(long var1, long var3);

    public native void setMemory(Object var1, long var2, long var4, byte var6);

    public void setMemory(long address, long bytes, byte value) {
        this.setMemory(null, address, bytes, value);
    }

    public native void copyMemory(Object var1, long var2, Object var4, long var5, long var7);

    public void copyMemory(long srcAddress, long destAddress, long bytes) {
        this.copyMemory(null, srcAddress, null, destAddress, bytes);
    }

    private boolean isPrimitiveArray(Class<?> c) {
        Class<?> componentType = c.getComponentType();
        return componentType != null && componentType.isPrimitive();
    }

    private native void copySwapMemory0(Object var1, long var2, Object var4, long var5, long var7, long var9);

    public void copySwapMemory(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes, long elemSize) {
        if (bytes < 0L) {
            throw new IllegalArgumentException();
        }
        if (elemSize != 2L && elemSize != 4L && elemSize != 8L) {
            throw new IllegalArgumentException();
        }
        if (bytes % elemSize != 0L) {
            throw new IllegalArgumentException();
        }
        if (srcBase == null && srcOffset == 0L || destBase == null && destOffset == 0L) {
            throw new NullPointerException();
        }
        if (!(srcBase == null || srcOffset >= 0L && this.isPrimitiveArray(srcBase.getClass()))) {
            throw new IllegalArgumentException();
        }
        if (!(destBase == null || destOffset >= 0L && this.isPrimitiveArray(destBase.getClass()))) {
            throw new IllegalArgumentException();
        }
        if (ADDRESS_SIZE == 4 && (bytes >>> 32 != 0L || srcOffset >>> 32 != 0L || destOffset >>> 32 != 0L)) {
            throw new IllegalArgumentException();
        }
        if (bytes == 0L) {
            return;
        }
        this.copySwapMemory0(srcBase, srcOffset, destBase, destOffset, bytes, elemSize);
    }

    public void copySwapMemory(long srcAddress, long destAddress, long bytes, long elemSize) {
        this.copySwapMemory(null, srcAddress, null, destAddress, bytes, elemSize);
    }

    public native void freeMemory(long var1);

    @Deprecated
    public int fieldOffset(Field f) {
        if (Modifier.isStatic(f.getModifiers())) {
            return (int)this.staticFieldOffset(f);
        }
        return (int)this.objectFieldOffset(f);
    }

    @Deprecated
    public Object staticFieldBase(Class c) {
        Field[] fields = c.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!Modifier.isStatic(fields[i].getModifiers())) continue;
            return this.staticFieldBase(fields[i]);
        }
        return null;
    }

    public final boolean isBigEndian() {
        return BE;
    }

    public final boolean unalignedAccess() {
        return unalignedAccess;
    }

    public final long getLongUnaligned(Object o, long offset) {
        if ((offset & 7L) == 0L) {
            return this.getLong(o, offset);
        }
        if ((offset & 3L) == 0L) {
            return Unsafe.makeLong(this.getInt(o, offset), this.getInt(o, offset + 4L));
        }
        if ((offset & 1L) == 0L) {
            return Unsafe.makeLong(this.getShort(o, offset), this.getShort(o, offset + 2L), this.getShort(o, offset + 4L), this.getShort(o, offset + 6L));
        }
        return Unsafe.makeLong(this.getByte(o, offset), this.getByte(o, offset + 1L), this.getByte(o, offset + 2L), this.getByte(o, offset + 3L), this.getByte(o, offset + 4L), this.getByte(o, offset + 5L), this.getByte(o, offset + 6L), this.getByte(o, offset + 7L));
    }

    public final long getLongUnaligned(Object o, long offset, boolean bigEndian) {
        return Unsafe.convEndian(bigEndian, this.getLongUnaligned(o, offset));
    }

    public final int getIntUnaligned(Object o, long offset) {
        if ((offset & 3L) == 0L) {
            return this.getInt(o, offset);
        }
        if ((offset & 1L) == 0L) {
            return Unsafe.makeInt(this.getShort(o, offset), this.getShort(o, offset + 2L));
        }
        return Unsafe.makeInt(this.getByte(o, offset), this.getByte(o, offset + 1L), this.getByte(o, offset + 2L), this.getByte(o, offset + 3L));
    }

    public final int getIntUnaligned(Object o, long offset, boolean bigEndian) {
        return Unsafe.convEndian(bigEndian, this.getIntUnaligned(o, offset));
    }

    public final short getShortUnaligned(Object o, long offset) {
        if ((offset & 1L) == 0L) {
            return this.getShort(o, offset);
        }
        return Unsafe.makeShort(this.getByte(o, offset), this.getByte(o, offset + 1L));
    }

    public final short getShortUnaligned(Object o, long offset, boolean bigEndian) {
        return Unsafe.convEndian(bigEndian, this.getShortUnaligned(o, offset));
    }

    public final char getCharUnaligned(Object o, long offset) {
        return (char)this.getShortUnaligned(o, offset);
    }

    public final char getCharUnaligned(Object o, long offset, boolean bigEndian) {
        return Unsafe.convEndian(bigEndian, this.getCharUnaligned(o, offset));
    }

    public final void putLongUnaligned(Object o, long offset, long x) {
        if ((offset & 7L) == 0L) {
            this.putLong(o, offset, x);
        } else if ((offset & 3L) == 0L) {
            this.putLongParts(o, offset, (int)(x >> 0), (int)(x >>> 32));
        } else if ((offset & 1L) == 0L) {
            this.putLongParts(o, offset, (short)(x >>> 0), (short)(x >>> 16), (short)(x >>> 32), (short)(x >>> 48));
        } else {
            this.putLongParts(o, offset, (byte)(x >>> 0), (byte)(x >>> 8), (byte)(x >>> 16), (byte)(x >>> 24), (byte)(x >>> 32), (byte)(x >>> 40), (byte)(x >>> 48), (byte)(x >>> 56));
        }
    }

    public final void putLongUnaligned(Object o, long offset, long x, boolean bigEndian) {
        this.putLongUnaligned(o, offset, Unsafe.convEndian(bigEndian, x));
    }

    public final void putIntUnaligned(Object o, long offset, int x) {
        if ((offset & 3L) == 0L) {
            this.putInt(o, offset, x);
        } else if ((offset & 1L) == 0L) {
            this.putIntParts(o, offset, (short)(x >> 0), (short)(x >>> 16));
        } else {
            this.putIntParts(o, offset, (byte)(x >>> 0), (byte)(x >>> 8), (byte)(x >>> 16), (byte)(x >>> 24));
        }
    }

    public final void putIntUnaligned(Object o, long offset, int x, boolean bigEndian) {
        this.putIntUnaligned(o, offset, Unsafe.convEndian(bigEndian, x));
    }

    public final void putShortUnaligned(Object o, long offset, short x) {
        if ((offset & 1L) == 0L) {
            this.putShort(o, offset, x);
        } else {
            this.putShortParts(o, offset, (byte)(x >>> 0), (byte)(x >>> 8));
        }
    }

    public final void putShortUnaligned(Object o, long offset, short x, boolean bigEndian) {
        this.putShortUnaligned(o, offset, Unsafe.convEndian(bigEndian, x));
    }

    public final void putCharUnaligned(Object o, long offset, char x) {
        this.putShortUnaligned(o, offset, (short)x);
    }

    public final void putCharUnaligned(Object o, long offset, char x, boolean bigEndian) {
        this.putCharUnaligned(o, offset, Unsafe.convEndian(bigEndian, x));
    }

    private native boolean unalignedAccess0();

    private native boolean isBigEndian0();

    private static int pickPos(int top, int pos) {
        return BE ? top - pos : pos;
    }

    private static long makeLong(byte i0, byte i1, byte i2, byte i3, byte i4, byte i5, byte i6, byte i7) {
        return Unsafe.toUnsignedLong(i0) << Unsafe.pickPos(56, 0) | Unsafe.toUnsignedLong(i1) << Unsafe.pickPos(56, 8) | Unsafe.toUnsignedLong(i2) << Unsafe.pickPos(56, 16) | Unsafe.toUnsignedLong(i3) << Unsafe.pickPos(56, 24) | Unsafe.toUnsignedLong(i4) << Unsafe.pickPos(56, 32) | Unsafe.toUnsignedLong(i5) << Unsafe.pickPos(56, 40) | Unsafe.toUnsignedLong(i6) << Unsafe.pickPos(56, 48) | Unsafe.toUnsignedLong(i7) << Unsafe.pickPos(56, 56);
    }

    private static long makeLong(short i0, short i1, short i2, short i3) {
        return Unsafe.toUnsignedLong(i0) << Unsafe.pickPos(48, 0) | Unsafe.toUnsignedLong(i1) << Unsafe.pickPos(48, 16) | Unsafe.toUnsignedLong(i2) << Unsafe.pickPos(48, 32) | Unsafe.toUnsignedLong(i3) << Unsafe.pickPos(48, 48);
    }

    private static long makeLong(int i0, int i1) {
        return Unsafe.toUnsignedLong(i0) << Unsafe.pickPos(32, 0) | Unsafe.toUnsignedLong(i1) << Unsafe.pickPos(32, 32);
    }

    private static int makeInt(short i0, short i1) {
        return Unsafe.toUnsignedInt(i0) << Unsafe.pickPos(16, 0) | Unsafe.toUnsignedInt(i1) << Unsafe.pickPos(16, 16);
    }

    private static int makeInt(byte i0, byte i1, byte i2, byte i3) {
        return Unsafe.toUnsignedInt(i0) << Unsafe.pickPos(24, 0) | Unsafe.toUnsignedInt(i1) << Unsafe.pickPos(24, 8) | Unsafe.toUnsignedInt(i2) << Unsafe.pickPos(24, 16) | Unsafe.toUnsignedInt(i3) << Unsafe.pickPos(24, 24);
    }

    private static short makeShort(byte i0, byte i1) {
        return (short)(Unsafe.toUnsignedInt(i0) << Unsafe.pickPos(8, 0) | Unsafe.toUnsignedInt(i1) << Unsafe.pickPos(8, 8));
    }

    private static byte pick(byte le, byte be) {
        return BE ? be : le;
    }

    private static short pick(short le, short be) {
        return BE ? be : le;
    }

    private static int pick(int le, int be) {
        return BE ? be : le;
    }

    private void putLongParts(Object o, long offset, byte i0, byte i1, byte i2, byte i3, byte i4, byte i5, byte i6, byte i7) {
        this.putByte(o, offset + 0L, Unsafe.pick(i0, i7));
        this.putByte(o, offset + 1L, Unsafe.pick(i1, i6));
        this.putByte(o, offset + 2L, Unsafe.pick(i2, i5));
        this.putByte(o, offset + 3L, Unsafe.pick(i3, i4));
        this.putByte(o, offset + 4L, Unsafe.pick(i4, i3));
        this.putByte(o, offset + 5L, Unsafe.pick(i5, i2));
        this.putByte(o, offset + 6L, Unsafe.pick(i6, i1));
        this.putByte(o, offset + 7L, Unsafe.pick(i7, i0));
    }

    private void putLongParts(Object o, long offset, short i0, short i1, short i2, short i3) {
        this.putShort(o, offset + 0L, Unsafe.pick(i0, i3));
        this.putShort(o, offset + 2L, Unsafe.pick(i1, i2));
        this.putShort(o, offset + 4L, Unsafe.pick(i2, i1));
        this.putShort(o, offset + 6L, Unsafe.pick(i3, i0));
    }

    private void putLongParts(Object o, long offset, int i0, int i1) {
        this.putInt(o, offset + 0L, Unsafe.pick(i0, i1));
        this.putInt(o, offset + 4L, Unsafe.pick(i1, i0));
    }

    private void putIntParts(Object o, long offset, short i0, short i1) {
        this.putShort(o, offset + 0L, Unsafe.pick(i0, i1));
        this.putShort(o, offset + 2L, Unsafe.pick(i1, i0));
    }

    private void putIntParts(Object o, long offset, byte i0, byte i1, byte i2, byte i3) {
        this.putByte(o, offset + 0L, Unsafe.pick(i0, i3));
        this.putByte(o, offset + 1L, Unsafe.pick(i1, i2));
        this.putByte(o, offset + 2L, Unsafe.pick(i2, i1));
        this.putByte(o, offset + 3L, Unsafe.pick(i3, i0));
    }

    private void putShortParts(Object o, long offset, byte i0, byte i1) {
        this.putByte(o, offset + 0L, Unsafe.pick(i0, i1));
        this.putByte(o, offset + 1L, Unsafe.pick(i1, i0));
    }

    private static int toUnsignedInt(byte n) {
        return n & 0xFF;
    }

    private static int toUnsignedInt(short n) {
        return n & 0xFFFF;
    }

    private static long toUnsignedLong(byte n) {
        return (long)n & 0xFFL;
    }

    private static long toUnsignedLong(short n) {
        return (long)n & 0xFFFFL;
    }

    private static long toUnsignedLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    private static char convEndian(boolean big, char n) {
        return big == BE ? n : Character.reverseBytes(n);
    }

    private static short convEndian(boolean big, short n) {
        return big == BE ? n : Short.reverseBytes(n);
    }

    private static int convEndian(boolean big, int n) {
        return big == BE ? n : Integer.reverseBytes(n);
    }

    private static long convEndian(boolean big, long n) {
        return big == BE ? n : Long.reverseBytes(n);
    }

    public native long staticFieldOffset(Field var1);

    public native long objectFieldOffset(Field var1);

    public native Object staticFieldBase(Field var1);

    public native boolean shouldBeInitialized(Class<?> var1);

    public native void ensureClassInitialized(Class var1);

    public native int arrayBaseOffset(Class var1);

    public native int arrayIndexScale(Class var1);

    public native int addressSize();

    public native int pageSize();

    public native Class defineClass(String var1, byte[] var2, int var3, int var4, ClassLoader var5, ProtectionDomain var6);

    @Deprecated
    @CallerSensitive
    public native Class defineClass(String var1, byte[] var2, int var3, int var4);

    public native Class defineAnonymousClass(Class var1, byte[] var2, Object[] var3);

    public native Object allocateInstance(Class var1) throws InstantiationException;

    public native void monitorEnter(Object var1);

    public native void monitorExit(Object var1);

    public native boolean tryMonitorEnter(Object var1);

    public native void throwException(Throwable var1);

    public final native boolean compareAndSwapObject(Object var1, long var2, Object var4, Object var5);

    public final native boolean compareAndSwapInt(Object var1, long var2, int var4, int var5);

    public final native boolean compareAndSwapLong(Object var1, long var2, long var4, long var6);

    public native Object getObjectVolatile(Object var1, long var2);

    public native void putObjectVolatile(Object var1, long var2, Object var4);

    public native int getIntVolatile(Object var1, long var2);

    public native void putIntVolatile(Object var1, long var2, int var4);

    public native boolean getBooleanVolatile(Object var1, long var2);

    public native void putBooleanVolatile(Object var1, long var2, boolean var4);

    public native byte getByteVolatile(Object var1, long var2);

    public native void putByteVolatile(Object var1, long var2, byte var4);

    public native short getShortVolatile(Object var1, long var2);

    public native void putShortVolatile(Object var1, long var2, short var4);

    public native char getCharVolatile(Object var1, long var2);

    public native void putCharVolatile(Object var1, long var2, char var4);

    public native long getLongVolatile(Object var1, long var2);

    public native void putLongVolatile(Object var1, long var2, long var4);

    public native float getFloatVolatile(Object var1, long var2);

    public native void putFloatVolatile(Object var1, long var2, float var4);

    public native double getDoubleVolatile(Object var1, long var2);

    public native void putDoubleVolatile(Object var1, long var2, double var4);

    public native void putOrderedObject(Object var1, long var2, Object var4);

    public native void putOrderedInt(Object var1, long var2, int var4);

    public native void putOrderedLong(Object var1, long var2, long var4);

    public native void unpark(Object var1);

    public native void park(boolean var1, long var2);

    public native int getLoadAverage(double[] var1, int var2);

    static {
        Unsafe.registerNatives();
        Reflection.registerMethodsToFilter(Unsafe.class, "getUnsafe");
        theUnsafe = new Unsafe();
        BE = theUnsafe.isBigEndian0();
        unalignedAccess = theUnsafe.unalignedAccess0();
        ARRAY_BOOLEAN_BASE_OFFSET = theUnsafe.arrayBaseOffset(boolean[].class);
        ARRAY_BYTE_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
        ARRAY_SHORT_BASE_OFFSET = theUnsafe.arrayBaseOffset(short[].class);
        ARRAY_CHAR_BASE_OFFSET = theUnsafe.arrayBaseOffset(char[].class);
        ARRAY_INT_BASE_OFFSET = theUnsafe.arrayBaseOffset(int[].class);
        ARRAY_LONG_BASE_OFFSET = theUnsafe.arrayBaseOffset(long[].class);
        ARRAY_FLOAT_BASE_OFFSET = theUnsafe.arrayBaseOffset(float[].class);
        ARRAY_DOUBLE_BASE_OFFSET = theUnsafe.arrayBaseOffset(double[].class);
        ARRAY_OBJECT_BASE_OFFSET = theUnsafe.arrayBaseOffset(Object[].class);
        ARRAY_BOOLEAN_INDEX_SCALE = theUnsafe.arrayIndexScale(boolean[].class);
        ARRAY_BYTE_INDEX_SCALE = theUnsafe.arrayIndexScale(byte[].class);
        ARRAY_SHORT_INDEX_SCALE = theUnsafe.arrayIndexScale(short[].class);
        ARRAY_CHAR_INDEX_SCALE = theUnsafe.arrayIndexScale(char[].class);
        ARRAY_INT_INDEX_SCALE = theUnsafe.arrayIndexScale(int[].class);
        ARRAY_LONG_INDEX_SCALE = theUnsafe.arrayIndexScale(long[].class);
        ARRAY_FLOAT_INDEX_SCALE = theUnsafe.arrayIndexScale(float[].class);
        ARRAY_DOUBLE_INDEX_SCALE = theUnsafe.arrayIndexScale(double[].class);
        ARRAY_OBJECT_INDEX_SCALE = theUnsafe.arrayIndexScale(Object[].class);
        ADDRESS_SIZE = theUnsafe.addressSize();
    }
}

