/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.Krb5;

public final class KdcComm {
    private static int defaultKdcRetryLimit;
    private static int defaultKdcTimeout;
    private static int defaultUdpPrefLimit;
    private static final boolean DEBUG;
    private static final String BAD_POLICY_KEY = "krb5.kdc.bad.policy";
    private static int tryLessMaxRetries;
    private static int tryLessTimeout;
    private static BpType badPolicy;
    private String realm;

    public static void initStatic() {
        int udf_pref_limit;
        int max_retries;
        int timeout;
        block11: {
            String value = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return Security.getProperty(KdcComm.BAD_POLICY_KEY);
                }
            });
            if (value != null) {
                String[] ss = (value = value.toLowerCase(Locale.ENGLISH)).split(":");
                if ("tryless".equals(ss[0])) {
                    block10: {
                        if (ss.length > 1) {
                            String[] params = ss[1].split(",");
                            try {
                                int tmp0 = Integer.parseInt(params[0]);
                                if (params.length > 1) {
                                    tryLessTimeout = Integer.parseInt(params[1]);
                                }
                                tryLessMaxRetries = tmp0;
                            }
                            catch (NumberFormatException nfe) {
                                if (!DEBUG) break block10;
                                System.out.println("Invalid krb5.kdc.bad.policy parameter for tryLess: " + value + ", use default");
                            }
                        }
                    }
                    badPolicy = BpType.TRY_LESS;
                } else {
                    badPolicy = "trylast".equals(ss[0]) ? BpType.TRY_LAST : BpType.NONE;
                }
            } else {
                badPolicy = BpType.NONE;
            }
            timeout = -1;
            max_retries = -1;
            udf_pref_limit = -1;
            try {
                Config cfg = Config.getInstance();
                String temp = cfg.getDefault("kdc_timeout", "libdefaults");
                timeout = KdcComm.parsePositiveIntString(temp);
                temp = cfg.getDefault("max_retries", "libdefaults");
                max_retries = KdcComm.parsePositiveIntString(temp);
                temp = cfg.getDefault("udp_preference_limit", "libdefaults");
                udf_pref_limit = KdcComm.parsePositiveIntString(temp);
            }
            catch (Exception exc) {
                if (!DEBUG) break block11;
                System.out.println("Exception in getting KDC communication settings, using default value " + exc.getMessage());
            }
        }
        defaultKdcTimeout = timeout > 0 ? timeout : 30000;
        defaultKdcRetryLimit = max_retries > 0 ? max_retries : 3;
        defaultUdpPrefLimit = udf_pref_limit;
        KdcAccessibility.reset();
    }

    public KdcComm(String realm) throws KrbException {
        if (realm == null && (realm = Config.getInstance().getDefaultRealm()) == null) {
            throw new KrbException(60, "Cannot find default realm");
        }
        this.realm = realm;
    }

    public byte[] send(byte[] obuf) throws IOException, KrbException {
        int udpPrefLimit = this.getRealmSpecificValue(this.realm, "udp_preference_limit", defaultUdpPrefLimit);
        boolean useTCP = udpPrefLimit > 0 && obuf != null && obuf.length > udpPrefLimit;
        return this.send(obuf, useTCP);
    }

    private byte[] send(byte[] obuf, boolean useTCP) throws IOException, KrbException {
        String kdcList;
        if (obuf == null) {
            return null;
        }
        Exception savedException = null;
        Config cfg = Config.getInstance();
        if (this.realm == null) {
            this.realm = cfg.getDefaultRealm();
            if (this.realm == null) {
                throw new KrbException(60, "Cannot find default realm");
            }
        }
        if ((kdcList = cfg.getKDCList(this.realm)) == null) {
            throw new KrbException("Cannot get kdc for realm " + this.realm);
        }
        String tempKdc = null;
        byte[] ibuf = null;
        String[] arr$ = KdcAccessibility.list(kdcList);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String tmp;
            tempKdc = tmp = arr$[i$];
            try {
                ibuf = this.send(obuf, tempKdc, useTCP);
                KRBError ke = null;
                try {
                    ke = new KRBError(ibuf);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ke != null && ke.getErrorCode() == 52) {
                    ibuf = this.send(obuf, tempKdc, true);
                }
                KdcAccessibility.removeBad(tempKdc);
                break;
            }
            catch (Exception e) {
                if (DEBUG) {
                    System.out.println(">>> KrbKdcReq send: error trying " + tempKdc);
                    e.printStackTrace(System.out);
                }
                KdcAccessibility.addBad(tempKdc);
                savedException = e;
                continue;
            }
        }
        if (ibuf == null) {
            if (savedException != null) {
                if (savedException instanceof IOException) {
                    throw (IOException)savedException;
                }
                throw (KrbException)savedException;
            }
            throw new IOException("Cannot get a KDC reply");
        }
        return ibuf;
    }

    private byte[] send(byte[] obuf, String tempKdc, boolean useTCP) throws IOException, KrbException {
        int tempPort;
        if (obuf == null) {
            return null;
        }
        int port = 88;
        int retries = this.getRealmSpecificValue(this.realm, "max_retries", defaultKdcRetryLimit);
        int timeout = this.getRealmSpecificValue(this.realm, "kdc_timeout", defaultKdcTimeout);
        if (badPolicy == BpType.TRY_LESS && KdcAccessibility.isBad(tempKdc)) {
            if (retries > tryLessMaxRetries) {
                retries = tryLessMaxRetries;
            }
            if (timeout > tryLessTimeout) {
                timeout = tryLessTimeout;
            }
        }
        String kdc = null;
        String portStr = null;
        if (tempKdc.charAt(0) == '[') {
            int pos = tempKdc.indexOf(93, 1);
            if (pos == -1) {
                throw new IOException("Illegal KDC: " + tempKdc);
            }
            kdc = tempKdc.substring(1, pos);
            if (pos != tempKdc.length() - 1) {
                if (tempKdc.charAt(pos + 1) != ':') {
                    throw new IOException("Illegal KDC: " + tempKdc);
                }
                portStr = tempKdc.substring(pos + 2);
            }
        } else {
            int colon = tempKdc.indexOf(58);
            if (colon == -1) {
                kdc = tempKdc;
            } else {
                int nextColon = tempKdc.indexOf(58, colon + 1);
                if (nextColon > 0) {
                    kdc = tempKdc;
                } else {
                    kdc = tempKdc.substring(0, colon);
                    portStr = tempKdc.substring(colon + 1);
                }
            }
        }
        if (portStr != null && (tempPort = KdcComm.parsePositiveIntString(portStr)) > 0) {
            port = tempPort;
        }
        if (DEBUG) {
            System.out.println(">>> KrbKdcReq send: kdc=" + kdc + (useTCP ? " TCP:" : " UDP:") + port + ", timeout=" + timeout + ", number of retries =" + retries + ", #bytes=" + obuf.length);
        }
        KdcCommunication kdcCommunication = new KdcCommunication(kdc, port, useTCP, timeout, retries, obuf);
        try {
            byte[] ibuf = AccessController.doPrivileged(kdcCommunication);
            if (DEBUG) {
                System.out.println(">>> KrbKdcReq send: #bytes read=" + (ibuf != null ? ibuf.length : 0));
            }
            return ibuf;
        }
        catch (PrivilegedActionException e) {
            Exception wrappedException = e.getException();
            if (wrappedException instanceof IOException) {
                throw (IOException)wrappedException;
            }
            throw (KrbException)wrappedException;
        }
    }

    private int getRealmSpecificValue(String realm, String key, int defValue) {
        int v = defValue;
        if (realm == null) {
            return v;
        }
        int temp = -1;
        try {
            String value = Config.getInstance().getDefault(key, realm);
            temp = KdcComm.parsePositiveIntString(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (temp > 0) {
            v = temp;
        }
        return v;
    }

    private static int parsePositiveIntString(String intString) {
        if (intString == null) {
            return -1;
        }
        int ret = -1;
        try {
            ret = Integer.parseInt(intString);
        }
        catch (Exception exc) {
            return -1;
        }
        if (ret >= 0) {
            return ret;
        }
        return -1;
    }

    static {
        DEBUG = Krb5.DEBUG;
        tryLessMaxRetries = 1;
        tryLessTimeout = 5000;
        KdcComm.initStatic();
    }

    static class KdcAccessibility {
        private static Set<String> bads = new HashSet<String>();

        KdcAccessibility() {
        }

        private static synchronized void addBad(String kdc) {
            if (DEBUG) {
                System.out.println(">>> KdcAccessibility: add " + kdc);
            }
            bads.add(kdc);
        }

        private static synchronized void removeBad(String kdc) {
            if (DEBUG) {
                System.out.println(">>> KdcAccessibility: remove " + kdc);
            }
            bads.remove(kdc);
        }

        private static synchronized boolean isBad(String kdc) {
            return bads.contains(kdc);
        }

        private static synchronized void reset() {
            if (DEBUG) {
                System.out.println(">>> KdcAccessibility: reset");
            }
            bads.clear();
        }

        private static synchronized String[] list(String kdcList) {
            StringTokenizer st = new StringTokenizer(kdcList);
            ArrayList<String> list = new ArrayList<String>();
            if (badPolicy == BpType.TRY_LAST) {
                ArrayList<String> badkdcs = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String t = st.nextToken();
                    if (bads.contains(t)) {
                        badkdcs.add(t);
                        continue;
                    }
                    list.add(t);
                }
                list.addAll(badkdcs);
            } else {
                while (st.hasMoreTokens()) {
                    list.add(st.nextToken());
                }
            }
            return list.toArray(new String[list.size()]);
        }
    }

    private static class KdcCommunication
    implements PrivilegedExceptionAction<byte[]> {
        private String kdc;
        private int port;
        private boolean useTCP;
        private int timeout;
        private int retries;
        private byte[] obuf;

        public KdcCommunication(String kdc, int port, boolean useTCP, int timeout, int retries, byte[] obuf) {
            this.kdc = kdc;
            this.port = port;
            this.useTCP = useTCP;
            this.timeout = timeout;
            this.retries = retries;
            this.obuf = obuf;
        }

        /*
         * Exception decompiling
         */
        @Override
        public byte[] run() throws IOException, KrbException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static enum BpType {
        NONE,
        TRY_LAST,
        TRY_LESS;

    }
}

