/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class RollupJobStats
implements ToXContentObject,
Writeable {
    public static final ParseField NAME = new ParseField("job_stats", new String[0]);
    private static ParseField NUM_PAGES = new ParseField("pages_processed", new String[0]);
    private static ParseField NUM_DOCUMENTS = new ParseField("documents_processed", new String[0]);
    private static ParseField NUM_ROLLUPS = new ParseField("rollups_indexed", new String[0]);
    private static ParseField NUM_INVOCATIONS = new ParseField("trigger_count", new String[0]);
    private long numPages = 0L;
    private long numDocuments = 0L;
    private long numRollups = 0L;
    private long numInvocations = 0L;
    public static final ConstructingObjectParser<RollupJobStats, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), args -> new RollupJobStats((Long)args[0], (Long)args[1], (Long)args[2], (Long)args[3]));

    public RollupJobStats() {
    }

    public RollupJobStats(long numPages, long numDocuments, long numRollups, long numInvocations) {
        this.numPages = numPages;
        this.numDocuments = numDocuments;
        this.numRollups = numRollups;
        this.numInvocations = numInvocations;
    }

    public RollupJobStats(StreamInput in) throws IOException {
        this.numPages = in.readVLong();
        this.numDocuments = in.readVLong();
        this.numRollups = in.readVLong();
        this.numInvocations = in.readVLong();
    }

    public long getNumPages() {
        return this.numPages;
    }

    public long getNumDocuments() {
        return this.numDocuments;
    }

    public long getNumInvocations() {
        return this.numInvocations;
    }

    public long getNumRollups() {
        return this.numRollups;
    }

    public void incrementNumPages(long n) {
        assert (n >= 0L);
        this.numPages += n;
    }

    public void incrementNumDocuments(long n) {
        assert (n >= 0L);
        this.numDocuments += n;
    }

    public void incrementNumInvocations(long n) {
        assert (n >= 0L);
        this.numInvocations += n;
    }

    public void incrementNumRollups(long n) {
        assert (n >= 0L);
        this.numRollups += n;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.numPages);
        out.writeVLong(this.numDocuments);
        out.writeVLong(this.numRollups);
        out.writeVLong(this.numInvocations);
    }

    public static RollupJobStats fromXContent(XContentParser parser) {
        try {
            return (RollupJobStats)PARSER.parse(parser, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NUM_PAGES.getPreferredName(), this.numPages);
        builder.field(NUM_DOCUMENTS.getPreferredName(), this.numDocuments);
        builder.field(NUM_ROLLUPS.getPreferredName(), this.numRollups);
        builder.field(NUM_INVOCATIONS.getPreferredName(), this.numInvocations);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RollupJobStats that = (RollupJobStats)other;
        return Objects.equals(this.numPages, that.numPages) && Objects.equals(this.numDocuments, that.numDocuments) && Objects.equals(this.numRollups, that.numRollups) && Objects.equals(this.numInvocations, that.numInvocations);
    }

    public int hashCode() {
        return Objects.hash(this.numPages, this.numDocuments, this.numRollups, this.numInvocations);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_PAGES);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_DOCUMENTS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_ROLLUPS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_INVOCATIONS);
    }
}

