/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrPropertyImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrTypeParameterImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrValueParameterImpl;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.util.OverridesKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010#\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020%J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u000fJ\u0018\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0014\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u0010\u0014\u001a\u000200H\u0002J\u001e\u00101\u001a\u00020\f2\f\u00102\u001a\b\u0012\u0004\u0012\u000200032\u0006\u0010\u0010\u001a\u000204H\u0002J\u0010\u00105\u001a\u0002062\u0006\u0010\u0014\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\f2\u0006\u00109\u001a\u00020:H\u0002J\f\u0010;\u001a\u000206*\u00020<H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;", "", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "(Lorg/jetbrains/kotlin/ir/util/SymbolTable;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;)V", "getOrigin", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "generateChildStubs", "", "descriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "generateClassStub", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "generateConstructorStub", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "generateEmptyExternalPackageFragmentStub", "Lorg/jetbrains/kotlin/ir/declarations/IrExternalPackageFragment;", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "generateEmptyModuleFragmentStub", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "generateEnumEntryStub", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "generateFunctionStub", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateMemberStub", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "generateMemberStubs", "memberScope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "generatePropertyStub", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "generateTypeParameterStub", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "generateTypeParameterStubs", "typeParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "generateValueParameterStub", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "generateValueParametersStubs", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "generateReceiverParameterStub", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "ir.tree"})
public final class DeclarationStubGenerator {
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final IrDeclarationOrigin origin;

    @NotNull
    public final IrModuleFragment generateEmptyModuleFragmentStub(@NotNull ModuleDescriptor descriptor2, @NotNull IrBuiltIns irBuiltIns) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)irBuiltIns, (String)"irBuiltIns");
        return new IrModuleFragmentImpl(descriptor2, irBuiltIns);
    }

    @NotNull
    public final IrExternalPackageFragment generateEmptyExternalPackageFragmentStub(@NotNull PackageFragmentDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        return this.symbolTable.declareExternalPackageFragment(descriptor2);
    }

    @NotNull
    public final IrDeclaration generateMemberStub(@NotNull DeclarationDescriptor descriptor2) {
        IrDeclaration irDeclaration;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof ClassDescriptor) {
            irDeclaration = DescriptorUtils.isEnumEntry(descriptor2) ? (IrSymbolDeclaration)this.generateEnumEntryStub((ClassDescriptor)descriptor2) : (IrSymbolDeclaration)this.generateClassStub((ClassDescriptor)descriptor2);
        } else if (declarationDescriptor instanceof ClassConstructorDescriptor) {
            irDeclaration = this.generateConstructorStub((ClassConstructorDescriptor)descriptor2);
        } else if (declarationDescriptor instanceof FunctionDescriptor) {
            irDeclaration = this.generateFunctionStub((FunctionDescriptor)descriptor2);
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            irDeclaration = this.generatePropertyStub((PropertyDescriptor)descriptor2);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected member descriptor: " + descriptor2)));
        }
        return irDeclaration;
    }

    private final IrProperty generatePropertyStub(PropertyDescriptor descriptor2) {
        IrSimpleFunction irSimpleFunction;
        IrPropertyImpl irPropertyImpl;
        IrPropertyImpl irProperty = irPropertyImpl = new IrPropertyImpl(-1, -1, this.origin, descriptor2);
        PropertyGetterDescriptor getterDescriptor = descriptor2.getGetter();
        if (getterDescriptor == null) {
            irProperty.setBackingField(this.symbolTable.declareField(-1, -1, this.origin, descriptor2));
        } else {
            irProperty.setGetter(this.generateFunctionStub(getterDescriptor));
        }
        IrPropertyImpl irPropertyImpl2 = irProperty;
        PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
        if (propertySetterDescriptor != null) {
            PropertySetterDescriptor it;
            PropertySetterDescriptor propertySetterDescriptor2 = propertySetterDescriptor;
            IrPropertyImpl irPropertyImpl3 = irPropertyImpl2;
            PropertySetterDescriptor propertySetterDescriptor3 = it = propertySetterDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)propertySetterDescriptor3, (String)"it");
            IrSimpleFunction irSimpleFunction2 = this.generateFunctionStub(propertySetterDescriptor3);
            irPropertyImpl2 = irPropertyImpl3;
            irSimpleFunction = irSimpleFunction2;
        } else {
            irSimpleFunction = null;
        }
        irPropertyImpl2.setSetter(irSimpleFunction);
        return irPropertyImpl;
    }

    @NotNull
    public final IrSimpleFunction generateFunctionStub(@NotNull FunctionDescriptor descriptor2) {
        IrSimpleFunction irSimpleFunction;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        IrDeclarationOrigin irDeclarationOrigin = descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE ? (IrDeclarationOrigin)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE : this.origin;
        FunctionDescriptor functionDescriptor = descriptor2.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"descriptor.original");
        IrSimpleFunction irFunction = irSimpleFunction = OverridesKt.declareSimpleFunctionWithOverrides(this.symbolTable, -1, -1, irDeclarationOrigin, functionDescriptor);
        List<TypeParameterDescriptor> list2 = DescriptorUtilsKt.getPropertyIfAccessor(descriptor2).getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.propertyIfAccessor.typeParameters");
        this.generateTypeParameterStubs(list2, irFunction);
        this.generateValueParametersStubs(irFunction);
        return irSimpleFunction;
    }

    private final IrConstructor generateConstructorStub(ClassConstructorDescriptor descriptor2) {
        IrConstructor irConstructor;
        IrConstructor irConstructor2 = irConstructor = this.symbolTable.declareConstructor(-1, -1, this.origin, descriptor2.getOriginal());
        this.generateValueParametersStubs(irConstructor2);
        return irConstructor;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateValueParametersStubs(IrFunction function2) {
        void $receiver$iv;
        FunctionDescriptor descriptor2 = function2.getDescriptor();
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getDispatchReceiverParameter();
        function2.setDispatchReceiverParameter(receiverParameterDescriptor != null ? this.generateReceiverParameterStub(receiverParameterDescriptor) : null);
        ReceiverParameterDescriptor receiverParameterDescriptor2 = descriptor2.getExtensionReceiverParameter();
        function2.setExtensionReceiverParameter(receiverParameterDescriptor2 != null ? this.generateReceiverParameterStub(receiverParameterDescriptor2) : null);
        List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.valueParameters");
        Iterable iterable = list2;
        Collection destination$iv = function2.getValueParameters();
        for (Object item$iv : $receiver$iv) {
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv;
            Collection collection = destination$iv;
            void v3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
            IrValueParameter irValueParameter = this.generateValueParameterStub((ValueParameterDescriptor)v3);
            collection.add(irValueParameter);
        }
    }

    private final IrValueParameter generateReceiverParameterStub(@NotNull ReceiverParameterDescriptor $receiver) {
        return new IrValueParameterImpl(-1, -1, this.origin, $receiver);
    }

    private final IrValueParameter generateValueParameterStub(ValueParameterDescriptor descriptor2) {
        IrValueParameterImpl irValueParameterImpl;
        IrValueParameterImpl irValueParameter = irValueParameterImpl = new IrValueParameterImpl(-1, -1, this.origin, descriptor2);
        if (descriptor2.declaresDefaultValue()) {
            KotlinType kotlinType = descriptor2.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"descriptor.type");
            irValueParameter.setDefaultValue(new IrExpressionBodyImpl(new IrErrorExpressionImpl(-1, -1, kotlinType, "Stub expression for default value of " + descriptor2.getName())));
        }
        return irValueParameterImpl;
    }

    /*
     * Unable to fully structure code
     */
    private final IrClass generateClassStub(ClassDescriptor descriptor) {
        irClass = var2_2 = this.symbolTable.declareClass(-1, -1, this.origin, descriptor);
        v0 = descriptor.getTypeConstructor();
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"descriptor.typeConstructor");
        v1 = v0.getSupertypes();
        Intrinsics.checkExpressionValueIsNotNull(v1, (String)"descriptor.typeConstructor.supertypes");
        var4_4 = v1;
        destination$iv = irClass.getSuperClasses();
        $receiver$iv$iv = $receiver$iv;
        for (T element$iv$iv : $receiver$iv$iv) {
            element$iv = element$iv$iv;
            it = (KotlinType)element$iv;
            v2 = it.getConstructor().getDeclarationDescriptor();
            if (v2 == null) ** GOTO lbl-1000
            $receiver$iv = v2;
            v3 = $receiver$iv;
            if (!(v3 instanceof ClassDescriptor)) {
                v3 = null;
            }
            if ((v2 = (ClassDescriptor)v3) != null) {
                it = var11_11 = v2;
                v4 = this.symbolTable.referenceClass((ClassDescriptor)it);
            } else lbl-1000:
            // 2 sources

            {
                v4 = null;
            }
            if (v4 == null) continue;
            it$iv = var13_13 = v4;
            destination$iv.add(it$iv);
        }
        v5 = descriptor.getDeclaredTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(v5, (String)"descriptor.declaredTypeParameters");
        this.generateTypeParameterStubs(v5, irClass);
        v6 = descriptor.getThisAsReceiverParameter();
        Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"descriptor.thisAsReceiverParameter");
        irClass.setThisReceiver(this.generateReceiverParameterStub(v6));
        v7 = descriptor.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(v7, (String)"descriptor.constructors");
        this.generateChildStubs(v7, irClass);
        this.generateMemberStubs(descriptor.getDefaultType().getMemberScope(), irClass);
        v8 = descriptor.getStaticScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"descriptor.staticScope");
        this.generateMemberStubs(v8, irClass);
        return var2_2;
    }

    private final IrEnumEntry generateEnumEntryStub(ClassDescriptor descriptor2) {
        return this.symbolTable.declareEnumEntry(-1, -1, this.origin, descriptor2);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateTypeParameterStubs(List<? extends TypeParameterDescriptor> typeParameters2, IrTypeParametersContainer container2) {
        void $receiver$iv;
        Iterable iterable = typeParameters2;
        Collection destination$iv = container2.getTypeParameters();
        for (Object item$iv : $receiver$iv) {
            void it;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv;
            Collection collection = destination$iv;
            IrTypeParameter irTypeParameter = this.generateTypeParameterStub((TypeParameterDescriptor)it);
            collection.add(irTypeParameter);
        }
    }

    private final IrTypeParameter generateTypeParameterStub(TypeParameterDescriptor descriptor2) {
        return new IrTypeParameterImpl(-1, -1, this.origin, descriptor2);
    }

    private final void generateMemberStubs(MemberScope memberScope2, IrDeclarationContainer container2) {
        this.generateChildStubs(ResolutionScope.DefaultImpls.getContributedDescriptors$default(memberScope2, null, null, 3, null), container2);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateChildStubs(Collection<? extends DeclarationDescriptor> descriptors, IrDeclarationContainer container2) {
        void $receiver$iv;
        Iterable iterable = descriptors;
        Collection destination$iv = container2.getDeclarations();
        for (Object item$iv : $receiver$iv) {
            void it;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)item$iv;
            Collection collection = destination$iv;
            IrDeclaration irDeclaration = this.generateMemberStub((DeclarationDescriptor)it);
            collection.add(irDeclaration);
        }
    }

    @NotNull
    public final SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @NotNull
    public final IrDeclarationOrigin getOrigin() {
        return this.origin;
    }

    public DeclarationStubGenerator(@NotNull SymbolTable symbolTable, @NotNull IrDeclarationOrigin origin) {
        Intrinsics.checkParameterIsNotNull((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        this.symbolTable = symbolTable;
        this.origin = origin;
    }
}

