/****************************************************************************
**
*W  macfloat.h                      GAP source                  Steve Linton
**
**
*Y  Copyright (C)  1996,  Lehrstuhl D für Mathematik,  RWTH Aachen,  Germany
*Y  (C) 1998 School Math and Comp. Sci., University of St Andrews, Scotland
*Y  Copyright (C) 2002 The GAP Group
**
**  This file declares the functions for the macfloating point package
*/
#include <string.h>

#ifndef libGAP_GAP_MACFLOAT_H
#define libGAP_GAP_MACFLOAT_H


#ifdef VERY_LONG_DOUBLES
typedef long double /* __float128 */ libGAP_Double;
#define libGAP_TOPRINTFFORMAT long double
#define libGAP_PRINTFDIGITS 20
#define libGAP_PRINTFFORMAT "Lg"
#define libGAP_STRTOD strtold
#define libGAP_MATH(name) name ## l
#else
typedef double libGAP_Double;
#define libGAP_TOPRINTFFORMAT double
#define libGAP_PRINTFDIGITS 16
#define libGAP_PRINTFFORMAT "g"
#define libGAP_STRTOD strtod
#define libGAP_MATH(name) name
#endif

static inline libGAP_Double libGAP_VAL_MACFLOAT(libGAP_Obj obj)
{ libGAP_Double __val; memcpy(&__val,libGAP_ADDR_OBJ(obj),sizeof(libGAP_Double)); return __val; }
static inline void libGAP_SET_VAL_MACFLOAT(libGAP_Obj obj, libGAP_Double val)
{ libGAP_Double __val = (val); memcpy(libGAP_ADDR_OBJ(obj),&__val,sizeof(libGAP_Double)); }

#define libGAP_IS_MACFLOAT(obj) (libGAP_TNUM_OBJ(obj) == libGAP_T_MACFLOAT)

extern libGAP_Obj libGAP_NEW_MACFLOAT( libGAP_Double val);



/*F * * * * * * * * * * * * * initialize package * * * * * * * * * * * * * * **/

/****************************************************************************
**

*F  InitInfoMacfloat()  . . . . . . . . . . . . . . . . . table of init functions
*/
libGAP_StructInitInfo * libGAP_InitInfoMacfloat ( void );


#endif // GAP_MACFLOAT_H

/****************************************************************************
**
*E  macfloat.h  . . . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
*/
