/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.w2lcommon.filter;

import com.sun.star.awt.XContainerWindowEventHandler;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XDialogProvider2;
import com.sun.star.awt.XWindow;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.io.NotConnectedException;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.adapter.XInputStreamToInputStreamAdapter;
import com.sun.star.lib.uno.adapter.XOutputStreamToOutputStreamAdapter;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XSimpleFileAccess2;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XStringSubstitution;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openoffice.da.comp.w2lcommon.helper.DialogAccess;
import org.openoffice.da.comp.w2lcommon.helper.FilePicker;
import org.openoffice.da.comp.w2lcommon.helper.StyleNameProvider;
import writer2latex.api.ComplexOption;
import writer2latex.api.Config;
import writer2latex.api.ConverterFactory;
import writer2latex.util.Misc;

public abstract class ConfigurationDialogBase
extends WeakBase
implements XContainerWindowEventHandler {
    private String sConfigFileName = null;
    protected XComponentContext xContext;
    protected FilePicker filePicker = null;
    protected XSimpleFileAccess2 sfa2 = null;
    protected XStringSubstitution xPathSub = null;
    protected Config config;
    protected Map<String, PageHandler> pageHandlers = new HashMap<String, PageHandler>();

    protected abstract String getMIMEType();

    protected abstract String getDialogLibraryName();

    protected abstract String getConfigFileName();

    public ConfigurationDialogBase(XComponentContext xContext) {
        this.xContext = xContext;
        this.filePicker = new FilePicker(xContext);
        try {
            Object sfaObject = xContext.getServiceManager().createInstanceWithContext("com.sun.star.ucb.SimpleFileAccess", xContext);
            this.sfa2 = (XSimpleFileAccess2)UnoRuntime.queryInterface(XSimpleFileAccess2.class, (Object)sfaObject);
        }
        catch (com.sun.star.uno.Exception sfaObject) {
            // empty catch block
        }
        try {
            Object psObject = xContext.getServiceManager().createInstanceWithContext("com.sun.star.util.PathSubstitution", xContext);
            this.xPathSub = (XStringSubstitution)UnoRuntime.queryInterface(XStringSubstitution.class, (Object)psObject);
            this.sConfigFileName = this.xPathSub.substituteVariables("$(user)/" + this.getConfigFileName(), false);
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
        this.config = ConverterFactory.createConverter(this.getMIMEType()).getConfig();
    }

    public boolean callHandlerMethod(XWindow xWindow, Object event, String sMethod) throws WrappedTargetException {
        XDialog xDialog = (XDialog)UnoRuntime.queryInterface(XDialog.class, (Object)xWindow);
        String sTitle = xDialog.getTitle();
        if (!this.pageHandlers.containsKey(sTitle)) {
            throw new WrappedTargetException("Unknown dialog " + sTitle);
        }
        DialogAccess dlg = new DialogAccess(xDialog);
        try {
            if (sMethod.equals("external_event")) {
                return this.handleExternalEvent(dlg, sTitle, event);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (com.sun.star.uno.Exception e) {
            throw new WrappedTargetException(sMethod, (Object)this, (Object)e);
        }
        return this.pageHandlers.get(sTitle).handleEvent(dlg, sMethod);
    }

    private boolean handleExternalEvent(DialogAccess dlg, String sTitle, Object aEventObject) throws com.sun.star.uno.Exception {
        try {
            String sMethod = AnyConverter.toString((Object)aEventObject);
            if (sMethod.equals("ok")) {
                this.loadConfig();
                this.pageHandlers.get(sTitle).getControls(dlg);
                this.saveConfig();
                return true;
            }
            if (sMethod.equals("back") || sMethod.equals("initialize")) {
                this.loadConfig();
                this.pageHandlers.get(sTitle).setControls(dlg);
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Method external_event requires a string in the event object argument.", (Object)this, -1);
        }
        return false;
    }

    private void loadConfig() {
        if (this.sfa2 != null && this.sConfigFileName != null) {
            try {
                XInputStream xIs = this.sfa2.openFileRead(this.sConfigFileName);
                if (xIs != null) {
                    XInputStreamToInputStreamAdapter is = new XInputStreamToInputStreamAdapter(xIs);
                    this.config.read((InputStream)is);
                    is.close();
                    xIs.closeInput();
                }
            }
            catch (IOException iOException) {
            }
            catch (NotConnectedException notConnectedException) {
            }
            catch (CommandAbortedException commandAbortedException) {
            }
            catch (com.sun.star.uno.Exception exception) {
                // empty catch block
            }
        }
    }

    private void saveConfig() {
        if (this.sfa2 != null && this.sConfigFileName != null) {
            try {
                XOutputStream xOs;
                if (this.sfa2.exists(this.sConfigFileName)) {
                    this.sfa2.kill(this.sConfigFileName);
                }
                if ((xOs = this.sfa2.openFileWrite(this.sConfigFileName)) != null) {
                    XOutputStreamToOutputStreamAdapter os = new XOutputStreamToOutputStreamAdapter(xOs);
                    this.config.write((OutputStream)os);
                    os.close();
                    xOs.closeOutput();
                }
            }
            catch (IOException iOException) {
            }
            catch (NotConnectedException notConnectedException) {
            }
            catch (CommandAbortedException commandAbortedException) {
            }
            catch (com.sun.star.uno.Exception exception) {
                // empty catch block
            }
        }
    }

    protected abstract class AttributePageHandler
    extends PageHandler {
        protected String[] sAttributeNames;
        private ComplexOption attributeMap;
        private int nCurrentAttribute;

        protected AttributePageHandler() {
            this.attributeMap = new ComplexOption();
            this.nCurrentAttribute = -1;
        }

        protected abstract void getControls(DialogAccess var1, Map<String, String> var2);

        protected abstract void setControls(DialogAccess var1, Map<String, String> var2);

        protected abstract void prepareControls(DialogAccess var1, boolean var2);

        @Override
        protected void setControls(DialogAccess dlg) {
            this.attributeMap.clear();
            this.attributeMap.copyAll(ConfigurationDialogBase.this.config.getComplexOption("text-attribute-map"));
            this.nCurrentAttribute = -1;
            dlg.setListBoxSelectedItem("FormattingAttribute", (short)0);
            this.formattingAttributeChange(dlg);
        }

        @Override
        protected void getControls(DialogAccess dlg) {
            this.updateAttributeMaps(dlg);
            ComplexOption configMap = ConfigurationDialogBase.this.config.getComplexOption("text-attribute-map");
            configMap.clear();
            for (String s : this.attributeMap.keySet()) {
                Map<String, String> attr = this.attributeMap.get(s);
                if (attr.containsKey("deleted") && !attr.get("deleted").equals("false")) continue;
                configMap.copy(s, attr);
            }
        }

        @Override
        protected boolean handleEvent(DialogAccess dlg, String sMethod) {
            if (sMethod.equals("FormattingAttributeChange")) {
                this.formattingAttributeChange(dlg);
                return true;
            }
            if (sMethod.equals("CustomAttributeChange")) {
                this.customAttributeChange(dlg);
                return true;
            }
            return false;
        }

        private void updateAttributeMaps(DialogAccess dlg) {
            if (this.nCurrentAttribute > -1) {
                String sName = this.sAttributeNames[this.nCurrentAttribute];
                if (!this.attributeMap.containsKey(sName)) {
                    this.attributeMap.put(sName, new HashMap<String, String>());
                }
                Map<String, String> attr = this.attributeMap.get(sName);
                attr.put("deleted", Boolean.toString(!dlg.getCheckBoxStateAsBoolean("CustomAttribute")));
                this.getControls(dlg, attr);
                this.attributeMap.put(sName, attr);
            }
        }

        private void formattingAttributeChange(DialogAccess dlg) {
            this.updateAttributeMaps(dlg);
            short nNewAttribute = dlg.getListBoxSelectedItem("FormattingAttribute");
            if (nNewAttribute > -1 && nNewAttribute != this.nCurrentAttribute) {
                Map<String, String> attr;
                this.nCurrentAttribute = nNewAttribute;
                String sName = this.sAttributeNames[this.nCurrentAttribute];
                if (!this.attributeMap.containsKey(sName)) {
                    this.attributeMap.put(sName, new HashMap<String, String>());
                    this.attributeMap.get(sName).put("deleted", "true");
                }
                dlg.setCheckBoxStateAsBoolean("CustomAttribute", !(attr = this.attributeMap.get(sName)).containsKey("deleted") || attr.get("deleted").equals("false"));
                this.customAttributeChange(dlg);
                this.setControls(dlg, attr);
            }
        }

        private void customAttributeChange(DialogAccess dlg) {
            this.prepareControls(dlg, dlg.getCheckBoxStateAsBoolean("CustomAttribute"));
        }
    }

    protected abstract class StylesPageHandler
    extends UserListPageHandler {
        protected String[] sFamilyNames;
        protected String[] sOOoFamilyNames;
        private ComplexOption[] styleMap;
        protected short nCurrentFamily;
        private String sCurrentStyleName;
        protected StyleNameProvider styleNameProvider;

        protected abstract String getDefaultConfigName();

        protected abstract void getControls(DialogAccess var1, Map<String, String> var2);

        protected abstract void setControls(DialogAccess var1, Map<String, String> var2);

        protected abstract void clearControls(DialogAccess var1);

        protected abstract void prepareControls(DialogAccess var1, boolean var2);

        protected StylesPageHandler(int nCount) {
            this.nCurrentFamily = (short)-1;
            this.sCurrentStyleName = null;
            this.styleNameProvider = null;
            this.styleNameProvider = new StyleNameProvider(ConfigurationDialogBase.this.xContext);
            this.styleMap = new ComplexOption[nCount];
            for (int i = 0; i < nCount; ++i) {
                this.styleMap[i] = new ComplexOption();
            }
        }

        @Override
        protected void setControls(DialogAccess dlg) {
            int nCount = this.sFamilyNames.length;
            for (int i = 0; i < nCount; ++i) {
                ComplexOption configMap = ConfigurationDialogBase.this.config.getComplexOption(this.sFamilyNames[i] + "-map");
                this.styleMap[i].clear();
                Map<String, String> displayNames = this.styleNameProvider.getDisplayNames(this.sOOoFamilyNames[i]);
                this.copyStyles(configMap, this.styleMap[i], displayNames);
            }
            this.nCurrentFamily = (short)-1;
            this.sCurrentStyleName = null;
            dlg.setListBoxSelectedItem("StyleFamily", (short)1);
            this.styleFamilyChange(dlg);
        }

        @Override
        protected void getControls(DialogAccess dlg) {
            this.updateStyleMaps(dlg);
            int nCount = this.sFamilyNames.length;
            for (int i = 0; i < nCount; ++i) {
                ComplexOption configMap = ConfigurationDialogBase.this.config.getComplexOption(this.sFamilyNames[i] + "-map");
                configMap.clear();
                Map<String, String> internalNames = this.styleNameProvider.getInternalNames(this.sOOoFamilyNames[i]);
                this.copyStyles(this.styleMap[i], configMap, internalNames);
            }
        }

        @Override
        protected boolean handleEvent(DialogAccess dlg, String sMethod) {
            if (sMethod.equals("StyleFamilyChange")) {
                this.styleFamilyChange(dlg);
                return true;
            }
            if (sMethod.equals("StyleNameChange")) {
                this.styleNameChange(dlg);
                return true;
            }
            if (sMethod.equals("NewStyleClick")) {
                this.newStyleClick(dlg);
                return true;
            }
            if (sMethod.equals("DeleteStyleClick")) {
                this.deleteStyleClick(dlg);
                return true;
            }
            if (sMethod.equals("LoadDefaultsClick")) {
                this.loadDefaultsClick(dlg);
                return true;
            }
            return false;
        }

        private void updateStyleMaps(DialogAccess dlg) {
            if (this.nCurrentFamily > -1 && this.sCurrentStyleName != null) {
                this.getControls(dlg, this.styleMap[this.nCurrentFamily].get(this.sCurrentStyleName));
            }
        }

        private void styleFamilyChange(DialogAccess dlg) {
            short nNewFamily = dlg.getListBoxSelectedItem("StyleFamily");
            if (nNewFamily > -1 && nNewFamily != this.nCurrentFamily) {
                this.updateStyleMaps(dlg);
                this.nCurrentFamily = nNewFamily;
                this.sCurrentStyleName = null;
                String[] sStyleNames = Misc.sortStringSet(this.styleMap[nNewFamily].keySet());
                dlg.setListBoxStringItemList("StyleName", sStyleNames);
                if (sStyleNames.length > 0) {
                    dlg.setListBoxSelectedItem("StyleName", (short)0);
                } else {
                    dlg.setListBoxSelectedItem("StyleName", (short)-1);
                }
                this.updateStyleControls(dlg);
                this.styleNameChange(dlg);
            }
        }

        private void styleNameChange(DialogAccess dlg) {
            if (this.nCurrentFamily > -1) {
                this.updateStyleMaps(dlg);
                short nStyleNameItem = dlg.getListBoxSelectedItem("StyleName");
                if (nStyleNameItem >= 0) {
                    this.sCurrentStyleName = dlg.getListBoxStringItemList("StyleName")[nStyleNameItem];
                    this.setControls(dlg, this.styleMap[this.nCurrentFamily].get(this.sCurrentStyleName));
                } else {
                    this.sCurrentStyleName = null;
                    this.clearControls(dlg);
                }
            }
        }

        private void newStyleClick(DialogAccess dlg) {
            if (this.nCurrentFamily > -1) {
                this.updateStyleMaps(dlg);
                this.sCurrentStyleName = null;
                String sNewName = this.appendItem(dlg, "StyleName", this.styleNameProvider.getInternalNames(this.sOOoFamilyNames[this.nCurrentFamily]).keySet());
                if (sNewName != null) {
                    this.styleMap[this.nCurrentFamily].put(sNewName, new HashMap<String, String>());
                    this.clearControls(dlg);
                }
                this.styleNameChange(dlg);
                this.updateStyleControls(dlg);
            }
        }

        private void deleteStyleClick(DialogAccess dlg) {
            if (this.nCurrentFamily > -1 && this.sCurrentStyleName != null) {
                String sStyleName = this.sCurrentStyleName;
                if (this.deleteCurrentItem(dlg, "StyleName")) {
                    this.styleMap[this.nCurrentFamily].remove(sStyleName);
                    this.sCurrentStyleName = null;
                    this.styleNameChange(dlg);
                }
                this.updateStyleControls(dlg);
            }
        }

        private void loadDefaultsClick(DialogAccess dlg) {
            this.updateStyleMaps(dlg);
            Config clean = ConverterFactory.createConverter(ConfigurationDialogBase.this.getMIMEType()).getConfig();
            clean.readDefaultConfig(this.getDefaultConfigName());
            int nCount = 0;
            int nFamilyCount = this.sFamilyNames.length;
            for (int i = 0; i < nFamilyCount; ++i) {
                ComplexOption cleanMap = clean.getComplexOption(this.sFamilyNames[i] + "-map");
                Map<String, String> displayNames = this.styleNameProvider.getDisplayNames(this.sOOoFamilyNames[i]);
                for (String sName : cleanMap.keySet()) {
                    String sDisplayName = displayNames != null && displayNames.containsKey(sName) ? displayNames.get(sName) : "";
                    if (!this.styleMap[i].containsKey(sDisplayName)) continue;
                    ++nCount;
                }
            }
            boolean bConfirm = false;
            XDialog xDialog = this.getDialog(ConfigurationDialogBase.this.getDialogLibraryName() + ".LoadDefaults");
            if (xDialog != null) {
                DialogAccess ldlg = new DialogAccess(xDialog);
                if (nCount > 0) {
                    String sLabel = ldlg.getLabelText("OverwriteLabel");
                    sLabel = sLabel.replaceAll("%s", Integer.toString(nCount));
                    ldlg.setLabelText("OverwriteLabel", sLabel);
                } else {
                    ldlg.setLabelText("OverwriteLabel", "");
                }
                bConfirm = xDialog.execute() == 1;
                xDialog.endExecute();
            }
            if (bConfirm) {
                for (int i = 0; i < nFamilyCount; ++i) {
                    ComplexOption cleanMap = clean.getComplexOption(this.sFamilyNames[i] + "-map");
                    Map<String, String> displayNames = this.styleNameProvider.getDisplayNames(this.sOOoFamilyNames[i]);
                    this.copyStyles(cleanMap, this.styleMap[i], displayNames);
                }
            }
            this.nCurrentFamily = (short)-1;
            this.sCurrentStyleName = null;
            this.styleFamilyChange(dlg);
        }

        private void updateStyleControls(DialogAccess dlg) {
            boolean bHasMappings = dlg.getListBoxStringItemList("StyleName").length > 0;
            dlg.setControlEnabled("DeleteStyleButton", bHasMappings);
            this.prepareControls(dlg, bHasMappings);
        }

        private void copyStyles(ComplexOption source, ComplexOption target, Map<String, String> nameTranslation) {
            Iterator<String> iterator = source.keySet().iterator();
            while (iterator.hasNext()) {
                String sName;
                String sNewName = sName = iterator.next();
                if (nameTranslation != null && nameTranslation.containsKey(sName)) {
                    sNewName = nameTranslation.get(sName);
                }
                target.copy(sNewName, source.get(sName));
            }
        }
    }

    protected abstract class UserListPageHandler
    extends PageHandler {
        protected UserListPageHandler() {
        }

        protected boolean deleteCurrentItem(DialogAccess dlg, String sListName) {
            String[] sItems = dlg.getListBoxStringItemList(sListName);
            short nSelected = dlg.getListBoxSelectedItem(sListName);
            if (nSelected >= 0 && this.deleteItem(sItems[nSelected])) {
                int nOldLen = sItems.length;
                String[] sNewItems = new String[nOldLen - 1];
                if (nSelected > 0) {
                    System.arraycopy(sItems, 0, sNewItems, 0, nSelected);
                }
                if (nSelected < nOldLen - 1) {
                    System.arraycopy(sItems, nSelected + 1, sNewItems, nSelected, nOldLen - 1 - nSelected);
                }
                dlg.setListBoxStringItemList(sListName, sNewItems);
                short nNewSelected = nSelected < nOldLen - 1 ? nSelected : (short)(nSelected - 1);
                dlg.setListBoxSelectedItem(sListName, nNewSelected);
                return true;
            }
            return false;
        }

        private String newItem(Set<String> suggestions) {
            XDialog xDialog = this.getDialog(ConfigurationDialogBase.this.getDialogLibraryName() + ".NewDialog");
            if (xDialog != null) {
                String[] sItems = Misc.sortStringSet(suggestions);
                DialogAccess ndlg = new DialogAccess(xDialog);
                ndlg.setListBoxStringItemList("Name", sItems);
                String sResult = null;
                if (xDialog.execute() == 1) {
                    DialogAccess dlg = new DialogAccess(xDialog);
                    sResult = dlg.getTextFieldText("Name");
                }
                xDialog.endExecute();
                return sResult;
            }
            return null;
        }

        protected String appendItem(DialogAccess dlg, String sListName, Set<String> suggestions) {
            String[] sItems = dlg.getListBoxStringItemList(sListName);
            String sNewItem = this.newItem(suggestions);
            if (sNewItem != null) {
                short nOldLen = sItems.length;
                for (short i = 0; i < nOldLen; i = (short)(i + 1)) {
                    if (!sNewItem.equals(sItems[i])) continue;
                    dlg.setListBoxSelectedItem(sListName, i);
                    return null;
                }
                String[] sNewItems = new String[nOldLen + 1];
                System.arraycopy(sItems, 0, sNewItems, 0, nOldLen);
                sNewItems[nOldLen] = sNewItem;
                dlg.setListBoxStringItemList(sListName, sNewItems);
                dlg.setListBoxSelectedItem(sListName, nOldLen);
            }
            return sNewItem;
        }
    }

    protected abstract class CustomFileHandler
    extends PageHandler {
        private String sCustomFileName;

        public CustomFileHandler() {
            try {
                this.sCustomFileName = ConfigurationDialogBase.this.xPathSub.substituteVariables("$(user)/" + this.getFileName(), false);
            }
            catch (NoSuchElementException e) {
                this.sCustomFileName = this.getFileName();
            }
        }

        protected abstract String getSuffix();

        protected abstract String getFileName();

        protected abstract void useCustomInner(DialogAccess var1, boolean var2);

        @Override
        protected void setControls(DialogAccess dlg) {
            String sText = "";
            boolean bUseCustom = false;
            if (this.fileExists(this.sCustomFileName)) {
                sText = this.loadFile(this.sCustomFileName);
                bUseCustom = true;
            } else if (this.fileExists(this.sCustomFileName + ".bak")) {
                sText = this.loadFile(this.sCustomFileName + ".bak");
            }
            if (sText == null) {
                sText = "";
            }
            dlg.setCheckBoxStateAsBoolean("UseCustom" + this.getSuffix(), bUseCustom);
            dlg.setTextFieldText("Custom" + this.getSuffix(), sText);
            this.useCustomChange(dlg);
        }

        @Override
        protected void getControls(DialogAccess dlg) {
            if (dlg.getCheckBoxStateAsBoolean("UseCustom" + this.getSuffix())) {
                this.saveFile(this.sCustomFileName, dlg.getTextFieldText("Custom" + this.getSuffix()));
                this.killFile(this.sCustomFileName + ".bak");
            } else {
                this.saveFile(this.sCustomFileName + ".bak", dlg.getTextFieldText("Custom" + this.getSuffix()));
                this.killFile(this.sCustomFileName);
            }
        }

        @Override
        protected boolean handleEvent(DialogAccess dlg, String sMethod) {
            if (sMethod.equals("UseCustom" + this.getSuffix() + "Change")) {
                this.useCustomChange(dlg);
                return true;
            }
            if (sMethod.equals("Load" + this.getSuffix() + "Click")) {
                this.loadCustomClick(dlg);
                return true;
            }
            return false;
        }

        private void useCustomChange(DialogAccess dlg) {
            boolean bUseCustom = dlg.getCheckBoxStateAsBoolean("UseCustom" + this.getSuffix());
            dlg.setControlEnabled("Custom" + this.getSuffix(), bUseCustom);
            dlg.setControlEnabled("Load" + this.getSuffix() + "Button", bUseCustom);
            this.useCustomInner(dlg, bUseCustom);
        }

        protected void loadCustomClick(DialogAccess dlg) {
            String sText;
            String sFileName = ConfigurationDialogBase.this.filePicker.getPath();
            if (sFileName != null && (sText = this.loadFile(sFileName)) != null) {
                dlg.setTextFieldText("Custom" + this.getSuffix(), sText);
            }
        }

        protected boolean fileExists(String sFileName) {
            try {
                return ConfigurationDialogBase.this.sfa2 != null && ConfigurationDialogBase.this.sfa2.exists(sFileName);
            }
            catch (CommandAbortedException commandAbortedException) {
            }
            catch (com.sun.star.uno.Exception exception) {
                // empty catch block
            }
            return false;
        }

        protected boolean killFile(String sFileName) {
            try {
                if (ConfigurationDialogBase.this.sfa2 != null && ConfigurationDialogBase.this.sfa2.exists(sFileName)) {
                    ConfigurationDialogBase.this.sfa2.kill(sFileName);
                    return true;
                }
            }
            catch (com.sun.star.uno.Exception exception) {
                // empty catch block
            }
            return false;
        }

        private String loadFile(String sFileName) {
            block6: {
                if (ConfigurationDialogBase.this.sfa2 != null) {
                    try {
                        XInputStream xIs = ConfigurationDialogBase.this.sfa2.openFileRead(sFileName);
                        if (xIs == null) break block6;
                        XInputStreamToInputStreamAdapter is = new XInputStreamToInputStreamAdapter(xIs);
                        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
                        StringBuilder buf = new StringBuilder();
                        try {
                            String sLine;
                            while ((sLine = reader.readLine()) != null) {
                                buf.append(sLine).append('\n');
                            }
                            reader.close();
                            is.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        xIs.closeInput();
                        return buf.toString();
                    }
                    catch (com.sun.star.uno.Exception exception) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        protected boolean saveFile(String sFileName, String sText) {
            block4: {
                this.killFile(sFileName);
                try {
                    XOutputStream xOs = ConfigurationDialogBase.this.sfa2.openFileWrite(sFileName);
                    if (xOs == null) break block4;
                    XOutputStreamToOutputStreamAdapter os = new XOutputStreamToOutputStreamAdapter(xOs);
                    try {
                        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, "UTF-8");
                        osw.write(sText);
                        osw.flush();
                        os.close();
                    }
                    catch (IOException e) {
                        xOs.closeOutput();
                        return false;
                    }
                    xOs.closeOutput();
                    return true;
                }
                catch (com.sun.star.uno.Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    protected abstract class PageHandler {
        protected PageHandler() {
        }

        protected abstract void getControls(DialogAccess var1);

        protected abstract void setControls(DialogAccess var1);

        protected abstract boolean handleEvent(DialogAccess var1, String var2);

        protected void checkBoxFromConfig(DialogAccess dlg, String sCheckBoxName, String sConfigName) {
            dlg.setCheckBoxStateAsBoolean(sCheckBoxName, "true".equals(ConfigurationDialogBase.this.config.getOption(sConfigName)));
        }

        protected void checkBoxToConfig(DialogAccess dlg, String sCheckBoxName, String sConfigName) {
            ConfigurationDialogBase.this.config.setOption(sConfigName, Boolean.toString(dlg.getCheckBoxStateAsBoolean(sCheckBoxName)));
        }

        protected void textFieldFromConfig(DialogAccess dlg, String sTextBoxName, String sConfigName) {
            dlg.setTextFieldText(sTextBoxName, ConfigurationDialogBase.this.config.getOption(sConfigName));
        }

        protected void textFieldToConfig(DialogAccess dlg, String sTextBoxName, String sConfigName) {
            ConfigurationDialogBase.this.config.setOption(sConfigName, dlg.getTextFieldText(sTextBoxName));
        }

        protected void listBoxFromConfig(DialogAccess dlg, String sListBoxName, String sConfigName, String[] sConfigValues, short nDefault) {
            String sCurrentValue = ConfigurationDialogBase.this.config.getOption(sConfigName);
            short nCount = sConfigValues.length;
            for (short i = 0; i < nCount; i = (short)(i + 1)) {
                if (!sConfigValues[i].equals(sCurrentValue)) continue;
                dlg.setListBoxSelectedItem(sListBoxName, i);
                return;
            }
            dlg.setListBoxSelectedItem(sListBoxName, nDefault);
        }

        protected void listBoxToConfig(DialogAccess dlg, String sListBoxName, String sConfigName, String[] sConfigValues) {
            ConfigurationDialogBase.this.config.setOption(sConfigName, sConfigValues[dlg.getListBoxSelectedItem(sListBoxName)]);
        }

        protected XDialog getDialog(String sDialogName) {
            XMultiComponentFactory xMCF = ConfigurationDialogBase.this.xContext.getServiceManager();
            try {
                Object provider = xMCF.createInstanceWithContext("com.sun.star.awt.DialogProvider2", ConfigurationDialogBase.this.xContext);
                XDialogProvider2 xDialogProvider = (XDialogProvider2)UnoRuntime.queryInterface(XDialogProvider2.class, (Object)provider);
                String sDialogUrl = "vnd.sun.star.script:" + sDialogName + "?location=application";
                return xDialogProvider.createDialog(sDialogUrl);
            }
            catch (Exception e) {
                return null;
            }
        }

        protected boolean deleteItem(String sName) {
            XDialog xDialog = this.getDialog(ConfigurationDialogBase.this.getDialogLibraryName() + ".DeleteDialog");
            if (xDialog != null) {
                DialogAccess ddlg = new DialogAccess(xDialog);
                String sLabel = ddlg.getLabelText("DeleteLabel");
                sLabel = sLabel.replaceAll("%s", sName);
                ddlg.setLabelText("DeleteLabel", sLabel);
                boolean bDelete = xDialog.execute() == 1;
                xDialog.endExecute();
                return bDelete;
            }
            return false;
        }
    }
}

